/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vhdldt.model.reflection.IFileDocumentListener;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfPropertySequence;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.utils.Utils;

public class RfDefElement
implements Serializable,
IFileDocumentListener,
IRfScope,
IRfDefElement,
IDVTMapElement<RfDefElement>,
ListContainer<RfDefElement>,
IRfBreadcrumbElement {
    private static final long serialVersionUID = 1L;
    private int fStartLine;
    private int fEndLine;
    private int fStartRealOffset;
    private int fEndRealOffset;
    private int fEndLabelOffset;
    private transient RfFileDef fDefFile;
    private CommentBlock fDefComment;
    private transient Object fNamedElements;
    protected DVTLinkedHashMap<RfDefElement, RfDefElement> fChildrenDefs;
    private transient Position fPosition;
    protected int fHashCode;

    public RfDefElement(RfFileDef file, String name, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        this.fDefFile = file;
        this.fStartLine = startInfo == null ? -1 : startInfo.line;
        this.fEndLine = endInfo == null ? -1 : endInfo.line;
        this.fStartRealOffset = startInfo == null ? -1 : startInfo.realOffset;
        this.fEndRealOffset = endInfo == null ? -1 : endInfo.realOffset;
        this.fEndLabelOffset = -1;
        this.fDefComment = comment;
        this.internalComputeHashCode(name);
    }

    public void addNamedElement(RfNamedElement namedElem) {
        if (this.fNamedElements == null) {
            this.fNamedElements = namedElem;
        } else if (this.fNamedElements instanceof RfNamedElement) {
            ArrayList<RfNamedElement> namedElements = new ArrayList<RfNamedElement>(4);
            namedElements.add((RfNamedElement)this.fNamedElements);
            namedElements.add(namedElem);
            this.fNamedElements = namedElements;
        } else {
            ((ArrayList)this.fNamedElements).add(namedElem);
        }
    }

    public int getStartLabelLine() {
        return this.getStartLine();
    }

    public int getStartLabelOffset() {
        return this.getStartOffset();
    }

    public void setStartLabelLine(int startLabelLine) {
    }

    public void setStartLabelOffset(int startLabelOffset) {
    }

    public void setEndLabelOffset(int endLabelOffset) {
        this.fEndLabelOffset = endLabelOffset;
    }

    public int getEndLabelOffset() {
        return this.fEndLabelOffset;
    }

    public boolean hasEndLabel() {
        return this.fEndLabelOffset != -1;
    }

    @Override
    public RfDefElement getDefElement() {
        return this;
    }

    @Override
    public RfNamedElement getNamedElement() {
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return (RfNamedElement)((List)this.fNamedElements).get(0);
        }
        return (RfNamedElement)this.fNamedElements;
    }

    public RfNamedElement getLastNamedElement() {
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return (RfNamedElement)((List)this.fNamedElements).get(((List)this.fNamedElements).size() - 1);
        }
        return (RfNamedElement)this.fNamedElements;
    }

    public RfNamedElement getEnclosingScope() {
        return this.getNamedElement();
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfNamedElement scope = this.getNamedElement();
        if (scope == null) {
            return null;
        }
        return scope.getEnclosingScope(clazz);
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        RfNamedElement scope = this.getNamedElement();
        if (scope == null) {
            return null;
        }
        return scope.getEnclosingScope(classes);
    }

    public RfNamedElement[] getNamedElements() {
        if (this.fNamedElements == null) {
            return null;
        }
        if (this.fNamedElements instanceof List) {
            if (((List)this.fNamedElements).isEmpty()) {
                return null;
            }
            return ((List)this.fNamedElements).toArray(new RfNamedElement[((List)this.fNamedElements).size()]);
        }
        return new RfNamedElement[]{(RfNamedElement)this.fNamedElements};
    }

    public RfFileDef getDefFile() {
        return this.fDefFile;
    }

    public ParserPath getParserPath() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getParserPath();
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getLanguageSyntax();
    }

    public LanguageKind getLanguageKind() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getLanguageKind();
    }

    public IResource getFileAdapter() {
        if (this.fDefFile == null) {
            return null;
        }
        return this.fDefFile.getFileAdapter();
    }

    public void setDefComment(CommentBlock comment) {
        this.fDefComment = comment;
    }

    public String getDefComment() {
        return this.fDefComment == null ? "" : this.fDefComment.toString();
    }

    public String getRawDefComment() {
        return this.fDefComment == null ? "" : this.fDefComment.toRawString();
    }

    public CommentBlock getCommentBlock() {
        return this.fDefComment;
    }

    @Override
    public boolean connectPositionToDocument(IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        block6: {
            if (document != null) break block6;
            return false;
        }
        try {
            if (this.fStartRealOffset > 0 && this.fEndRealOffset >= this.fStartRealOffset && Utils.documentLength(document) >= this.fEndRealOffset) {
                DVTPosition position = new DVTPosition(this.fStartRealOffset, this.fEndRealOffset - this.fStartRealOffset + 1);
                Position existingPosition = cachedPositions.get(position);
                if (existingPosition == null) {
                    this.fPosition = position;
                    reflectionPositions.add(this.fPosition);
                    cachedPositions.put(this.fPosition, this.fPosition);
                } else {
                    this.fPosition = existingPosition;
                }
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public void removePosition() {
        this.fPosition = null;
    }

    public boolean containsOffset(int offset) {
        return offset == -1 || this.fStartRealOffset <= offset && (this.fEndRealOffset == -1 || offset <= this.fEndRealOffset);
    }

    public int getStartLine() {
        int result;
        if (this.fPosition != null && !Utils.positionDeleted(this.fPosition) && Utils.positionLength(this.fPosition) > 0 && this.fDefFile != null && (result = Utils.positionOffset(this.fPosition)) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.convertPositionToLine(this.fDefFile.getDocument(), this.fStartRealOffset);
        }
        return this.fStartLine;
    }

    public int getEndLine() {
        int result;
        if (this.fPosition != null && !Utils.positionDeleted(this.fPosition) && Utils.positionLength(this.fPosition) > 0 && this.fDefFile != null && (result = Utils.positionOffset(this.fPosition) + Utils.positionLength(this.fPosition) - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.convertPositionToLine(this.fDefFile.getDocument(), this.fEndRealOffset);
        }
        return this.fEndLine;
    }

    public int getStartOffset() {
        int result;
        if (this.fPosition != null && !Utils.positionDeleted(this.fPosition) && Utils.positionLength(this.fPosition) > 0 && this.fDefFile != null && (result = Utils.positionOffset(this.fPosition)) >= 0) {
            this.fStartRealOffset = result;
            this.fStartLine = Utils.convertPositionToLine(this.fDefFile.getDocument(), this.fStartRealOffset);
        }
        return this.fStartRealOffset;
    }

    public LineInfo getStartInfo() {
        return new LineInfo(this.fStartLine, this.fStartRealOffset, -1);
    }

    public LineInfo getEndInfo() {
        return new LineInfo(this.fEndLine, this.fStartRealOffset, -1);
    }

    public int getEndOffset() {
        int result;
        if (this.fPosition != null && !Utils.positionDeleted(this.fPosition) && Utils.positionLength(this.fPosition) > 0 && this.fDefFile != null && (result = Utils.positionOffset(this.fPosition) + Utils.positionLength(this.fPosition) - 1) >= 0) {
            this.fEndRealOffset = result;
            this.fEndLine = Utils.convertPositionToLine(this.fDefFile.getDocument(), this.fEndRealOffset);
        }
        return this.fEndRealOffset;
    }

    public RfProject getRfProject() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement != null) {
            return namedElement.getRfProject();
        }
        return null;
    }

    public void addChild(RfDefElement child) {
        if (this.fChildrenDefs == null) {
            this.fChildrenDefs = new DVTLinkedHashMap();
        }
        this.fChildrenDefs.put((Object)child, (IDVTMapElement)child);
    }

    public void removeChild(RfDefElement child) {
        if (this.fChildrenDefs == null) {
            return;
        }
        this.fChildrenDefs.remove((Object)child);
    }

    public Collection<RfDefElement> getChildren() {
        if (this.fChildrenDefs == null) {
            return null;
        }
        return this.fChildrenDefs.values();
    }

    public String getName() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getName();
    }

    public String getQualifiedName() {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getQualifiedName();
    }

    public void setEndOffset(LineInfo endInfo) {
        this.fEndRealOffset = endInfo == null ? -1 : endInfo.realOffset;
        this.fEndLine = endInfo == null ? -1 : endInfo.line;
    }

    @Override
    public List<RfArchitecture> getArchitecturesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getArchitecturesWithPrefix(prefix, matchType);
    }

    @Override
    public RfArchitecture getArchitectureWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getArchitectureWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfConfiguration> getConfigurationsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getConfigurationsWithPrefix(prefix, matchType);
    }

    @Override
    public RfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getConfigurationWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfBlock> getBlocksWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getBlocksWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfBlock getBlockWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getBlockWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getLibrariesWithPrefix(prefix, matchType);
    }

    @Override
    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getLibraryWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfComponent> getComponentsWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getComponentsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfComponent getComponentWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getComponentWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfEntity> getEntitiesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getEntitiesWithPrefix(prefix, matchType);
    }

    @Override
    public RfEntity getEntityWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getEntityWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfFunction> getFunctionsWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getFunctionsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfFunction getFunctionWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getFunctionWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfFunctionsHolder> getFunctionHoldersWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getFunctionHoldersWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfFunctionsHolder getFunctionHolderWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getFunctionHolderWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfInstance> getInstancesWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getInstancesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getInstanceWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfContext> getContextsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getContextsWithPrefix(prefix, matchType);
    }

    @Override
    public RfContext getContextWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getContextWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPackagesWithPrefix(prefix, matchType);
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPackageWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfPackageBody> getPackageBodiesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPackageBodiesWithPrefix(prefix, matchType);
    }

    @Override
    public RfPackageBody getPackageBodyWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPackageBodyWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfTypeBody> getTypeBodiesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypeBodiesWithPrefix(prefix, matchType);
    }

    @Override
    public RfTypeBody getTypeBodyWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypeBodyWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPortsWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPortWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfProcess> getProcessesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getProcessesWithPrefix(prefix, matchType);
    }

    @Override
    public RfProcess getProcessWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getProcessWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfVariable> getVariablesWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getVariablesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfVariable getVariableWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getVariableWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getEnumsWithPrefix(prefix, matchType);
    }

    @Override
    public RfEnum getEnumWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getEnumWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfType> getTypesWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfType getTypeWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypeWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfActionBlock> getSequentialStatementsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getSequentialStatementsWithPrefix(prefix, matchType);
    }

    @Override
    public RfActionBlock getSequentialStatementWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getSequentialStatementWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfVUnit> getVUnitsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getVUnitsWithPrefix(prefix, matchType);
    }

    @Override
    public RfVUnit getVUnitWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getVUnitWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfPropertySequence> getPropertiesSequencesWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPropertiesSequencesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfPropertySequence getPropertySequenceWithPrefix(String prefix, int matchType, boolean local) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getPropertySequenceWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<IRfNamedElement> getOtherLangMembersWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getOtherLangMembersWithPrefix(prefix, matchType);
    }

    @Override
    public IRfNamedElement getOtherLangMemberWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getOtherLangMemberWithPrefix(prefix, matchType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfDefElement other = (RfDefElement)obj;
        if (this.fHashCode != other.fHashCode) {
            return false;
        }
        if (this.fStartRealOffset != other.fStartRealOffset) {
            return false;
        }
        return this.fStartLine == other.fStartLine;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    protected void internalComputeHashCode(String name) {
        StringBuilder hashName = new StringBuilder(name).append('@').append(this.getStartOffset());
        this.fHashCode = hashName.toString().hashCode();
    }

    public RfDefElement findDefElement(RfDefElement elem) {
        if (this.fChildrenDefs == null) {
            return null;
        }
        RfDefElement result = (RfDefElement)this.fChildrenDefs.get((Object)elem);
        if (result == null || result.getClass() == elem.getClass()) {
            return result;
        }
        return null;
    }

    protected void cleanChildren(IncrementalDeltaContainer incrementalDeltaContainer, boolean disableChildrenCollect) {
        RfNamedElement[] namedElements = this.getNamedElements();
        if (namedElements != null) {
            RfNamedElement[] rfNamedElementArray = namedElements;
            int n = namedElements.length;
            int n2 = 0;
            while (n2 < n) {
                RfNamedElement namedElem = rfNamedElementArray[n2];
                namedElem.removeDef(this);
                ++n2;
            }
        }
        if (this.fChildrenDefs == null) {
            return;
        }
        for (RfDefElement defElement : this.getChildren()) {
            if (defElement.fChildrenDefs == this.fChildrenDefs) continue;
            boolean newDisableChildrenCollect = incrementalDeltaContainer == null ? true : incrementalDeltaContainer.collectElementsInFileBeforeIncremental(defElement, disableChildrenCollect);
            defElement.cleanChildren(incrementalDeltaContainer, newDisableChildrenCollect);
        }
        this.fChildrenDefs.clear();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    public boolean isPredefined() {
        if (this.fDefFile != null) {
            return this.fDefFile.isPredefined();
        }
        return false;
    }

    public boolean isInsideOtherDef(RfDefElement otherDef) {
        if (this.fDefFile == null || !this.fDefFile.equals(otherDef.getDefFile())) {
            return false;
        }
        return this.fStartRealOffset >= otherDef.fStartRealOffset && this.fEndRealOffset <= otherDef.fEndRealOffset;
    }

    public RfDefElement getKey() {
        return this;
    }

    public void deepClean() {
        if (this.fDefFile != null) {
            this.fDefFile.deepClean();
        }
        this.fDefComment = null;
        if (this.fChildrenDefs != null) {
            this.fChildrenDefs.clear();
        }
        this.fNamedElements = null;
        this.fPosition = null;
        this.fHashCode = 0;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getSignalWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getSignalsWithPrefix(prefix, matchType);
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getInstanceWithPrefix(prefix, matchType);
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getDesignsWithPrefix(prefix, matchType);
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getDesignWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypesWithPrefix(prefix, matchType);
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        RfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getTypeWithPrefix(prefix, matchType);
    }

    public boolean visit(RfDefElementVisitorAdapter visitor) throws Exception {
        if (!visitor.visitEntering(this)) {
            return false;
        }
        if (this.fChildrenDefs != null) {
            for (RfDefElement def : this.fChildrenDefs.values()) {
                if (def.visit(visitor)) continue;
                return false;
            }
        }
        return visitor.visitLeaving(this);
    }

    protected void recursiveSetDefFile(RfFileDef defFile) {
        this.fDefFile = defFile;
        Collection<RfDefElement> childrenDefs = this.getChildren();
        if (childrenDefs != null && !childrenDefs.isEmpty()) {
            for (RfDefElement childDef : childrenDefs) {
                childDef.recursiveSetDefFile(this.fDefFile);
            }
        }
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        this.getNamedElement().getElementsWithPrefix(result, prefix, matchType, local, isFirst, accessModifier, elementFilter);
    }

    public IRfLibraryElement getEnclosingLibrary() {
        return this.getNamedElement().getEnclosingLibrary();
    }

    public boolean isPredefinedDef() {
        return this.getNamedElement() == null || this.getNamedElement().isPredefined();
    }

    public RfDefElement internalThis() {
        return this;
    }
}

