/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfEntity
extends RfComponent {
    private static final long serialVersionUID = 3L;
    private transient RfArchitecture fTransientArchitecture;

    public RfEntity(String name) {
        super(name);
    }

    @Override
    public String getSignature() {
        return "entity " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    @Deprecated
    public IRfDesignElement getResolvedElement() {
        return this;
    }

    @Override
    protected RfDefElement getArchitectureOrConfigurationDeclaration() {
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null || members.isEmpty()) {
            return null;
        }
        for (RfNamedElement member : members) {
            RfDefElement declaration;
            if (!(member instanceof RfArchitecture) && !(member instanceof RfConfiguration) || (declaration = member.getDeclaration()) == null) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public List<RfBlock> getBlocksWithPrefix(String prefix, int matchType, boolean local) {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getBlocksWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfBlock getBlockWithPrefix(String prefix, int matchType, boolean local) {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getBlockWithPrefix(prefix, matchType, local);
    }

    @Override
    public List<RfInstance> getInstancesWithPrefix(String prefix, int matchType, boolean local) {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getInstancesWithPrefix(prefix, matchType, local);
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, boolean local) {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getInstanceWithPrefix(prefix, matchType, local);
    }

    public synchronized RfArchitecture getArchitecture() {
        if (this.fTransientArchitecture == null || this.fTransientArchitecture.getDeclarations() == null || this.fTransientArchitecture.getDeclarations().isEmpty()) {
            List<RfArchitecture> architectures = this.getLocalMembers(RfArchitecture.class);
            if (architectures == null) {
                this.fTransientArchitecture = null;
                return null;
            }
            Iterator it = architectures.iterator();
            this.fTransientArchitecture = null;
            while (it.hasNext()) {
                this.fTransientArchitecture = (RfArchitecture)it.next();
            }
            if (this.fTransientArchitecture == null) {
                return null;
            }
        }
        return this.fTransientArchitecture;
    }

    public List<RfArchitecture> getArchitectures() {
        return this.getLocalMembers(RfArchitecture.class);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        this.getSuperLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return;
        }
        architecture.getSuperLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    protected <T extends IRfNamedElement> void getSuperLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        RfNamedElement result = this.getSuperLocalMember(classes, name, exclude);
        if (result != null) {
            return result;
        }
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getSuperLocalMember(classes, name, exclude);
    }

    @Override
    public Collection<? extends IRfInstanceElement> getLocalInstancesWithPrefix(String prefix, int matchType) {
        return this.getInstancesWithPrefix(prefix, matchType, true);
    }

    protected RfNamedElement getSuperLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        return super.getLocalMember((Set)classes, name, exclude);
    }

    @Override
    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getLocalGenerateBlocks();
    }

    @Override
    public Collection<? extends IRfInstanceElement> getLocalInstances() {
        RfArchitecture architecture = this.getArchitecture();
        if (architecture == null) {
            return null;
        }
        return architecture.getLocalInstances();
    }

    @Override
    public Set<IRfNamedElement> elabGetAllImportedPackages() {
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
        NullProtectedList<ImportInfo> allImportDeclarations = this.getAllImportDeclarations();
        for (ImportInfo imp : allImportDeclarations) {
            IRfNamedElement element = imp.getImportedElement();
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public synchronized void internalResolveHidsFromElaboration(ELWidthCheckContext elabContext, boolean triggerError) throws BuildCancelException {
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return;
        }
        try {
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, rfProject.getToolCompat());
            configInfo.setElabContext(elabContext);
            ELManager manager = elabContext.getManager();
            FullChecksAndLibs fullCompileChecks = manager.getFullChecksAndLibs();
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (onlyLibAndPkgNames != null && !enclosingLibrary.isPredefined()) {
                if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                    return;
                }
                if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                    return;
                }
            }
            this.resolveHids(configInfo, triggerError, false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public byte getSemanticEnableRaw() {
        List<RfArchitecture> architectures = this.getArchitectures();
        if (architectures == null || architectures.isEmpty()) {
            return 0;
        }
        byte semanticEnable = 0;
        for (RfArchitecture architecture : architectures) {
            byte semanticEnableRaw = architecture.getSemanticEnableRaw();
            if (semanticEnableRaw <= semanticEnable) continue;
            semanticEnable = semanticEnableRaw;
        }
        return semanticEnable;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_ENTITY: Duplicate entity ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public int getSemanticErrorSeverityForDuplicate() {
        return 2;
    }

    @Override
    public IRfNamedElement.ElementKind getKind() {
        return IRfNamedElement.ElementKind.VHDL_ENTITY;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof RfComponent && ((RfComponent)obj).getResolvedElement() == this;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY);
    }

    @Override
    public void deepClean() {
        this.fTransientArchitecture = null;
        super.deepClean();
    }
}

