/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class RfEnum
extends RfVariable {
    private static final long serialVersionUID = 2L;
    private int ordinal;

    public RfEnum(String name, int ordinal, int kind, RfNamedElement parentEnumType) {
        super(name, 1, kind, null, parentEnumType == null ? null : new DataType(parentEnumType.getName()), null);
        this.ordinal = ordinal;
    }

    public void init(String name, int ordinal, int kind, RfNamedElement parentEnumType) {
        this.init(name, 1, kind, null, parentEnumType == null ? null : new DataType(parentEnumType.getName()), null);
        this.ordinal = ordinal;
    }

    public String getParentEnumTypeName() {
        IRfNamedElement associatedType = this.getAssociatedType();
        return associatedType != null ? associatedType.getName() : "";
    }

    public RfNamedElement getParentEnumType() {
        IRfNamedElement associatedType = this.getAssociatedType();
        return associatedType instanceof RfNamedElement ? (RfNamedElement)associatedType : null;
    }

    @Override
    public String getElabName(boolean isCaseSensitive) {
        String enumTypeName = this.getParentEnumTypeName();
        return String.valueOf(enumTypeName) + "." + this.getKey();
    }

    @Override
    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
    }

    @Override
    public String getSignature() {
        switch (this.getFieldKind()) {
            case 0x400000: {
                return "enum " + this.getName() + " of type " + this.getParentEnumTypeName();
            }
            case 0x800000: {
                return "unit " + this.getName() + " of physical type " + this.getParentEnumTypeName();
            }
        }
        return "";
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    @Override
    public String getKey() {
        String name = this.getName();
        return name != null && '\'' == name.charAt(0) ? name : super.getKey();
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

