/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.utils.Utils;

public class RfFileDef
extends RfDefElement
implements IRfFileDef {
    private static final long serialVersionUID = 1L;
    public int fIndex = -1;
    private ParserPath fParserPath;
    private String fName;
    private boolean fPredefined;
    private IBuildConfigParserConstants.LanguageSyntax fLanguageSyntax;
    private Deque<RfDefElement> fPhysicalScopes;
    private String fLibraryName;
    private transient RfLibrary fLibrary;
    private transient RfDefElement fCachedScope;
    private transient int fCachedScopeOffset;

    public RfFileDef(String name, int index, ParserPath parserPath, RfLibrary enclosingLibrary, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        super(null, name, null, null, null);
        this.fName = name;
        if (RfProject.isPredefined(parserPath)) {
            this.fPredefined = true;
        }
        this.fIndex = index;
        this.fParserPath = parserPath;
        this.fLanguageSyntax = languageSyntax;
        this.fLibrary = enclosingLibrary;
        if (this.fLibrary != null) {
            this.fLibrary.addDeclaration(this);
        }
        this.fLibraryName = enclosingLibrary == null ? null : enclosingLibrary.getName();
        this.fPhysicalScopes = new ArrayDeque<RfDefElement>();
        this.fPhysicalScopes.push(this);
    }

    public void cleanUpFile(IncrementalDeltaContainer incrementalDeltaContainer) {
        this.cleanChildren(incrementalDeltaContainer, false);
        this.fCachedScope = null;
        this.fPhysicalScopes.clear();
        this.fPhysicalScopes.push(this);
    }

    @Override
    public ParserPath getParserPath() {
        return this.fParserPath;
    }

    @Override
    public void addNamedElement(RfNamedElement namedElem) {
    }

    @Override
    public RfNamedElement getNamedElement() {
        return null;
    }

    public IDocument getDocument() {
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        DVTEditor editor = rfProject.getEditor(this.fParserPath);
        if (editor == null) {
            return null;
        }
        return editor.getDocument();
    }

    @Override
    public RfProject getRfProject() {
        if (this.fLibrary == null) {
            return null;
        }
        return this.fLibrary.getRfProject();
    }

    public void connectPositionToDocument(Set<DVTSemanticFoldingPosition> foldingPositions, boolean connectOnlyVisualPositions, boolean isEditorVisible, List<Position> reflectionPositions) {
        Utils.getInstance().connectPositionToDocument(this.getDocument(), this, foldingPositions, connectOnlyVisualPositions, isEditorVisible, reflectionPositions);
        ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
    }

    public void disconnectPositionFromDocument() {
        Utils.disconnectPositionToDocument(this.getDocument(), this);
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        return this.fLibrary;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getFileAdapter();
        }
        return null;
    }

    @Override
    public IResource getFileAdapter() {
        if (this.fLibrary == null || this.fLibrary.getRfProject() == null || this.fParserPath == null) {
            return null;
        }
        return Utils.getFileAdapter(this.fLibrary.getRfProject(), this.fParserPath.path);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public RfDefElement findDefElement(RfDefElement elem) {
        if (this.fPhysicalScopes.peek() instanceof RfFileDef) {
            return super.findDefElement(elem);
        }
        return this.fPhysicalScopes.peek().findDefElement(elem);
    }

    public void removeChildDef(RfDefElement elem) {
        this.fPhysicalScopes.peek().removeChild(elem);
    }

    public RfDefElement addChildDef(RfDefElement child) {
        RfDefElement foundElem = this.fPhysicalScopes.peek().findDefElement(child);
        if (foundElem != null) {
            return foundElem;
        }
        this.fPhysicalScopes.peek().addChild(child);
        return child;
    }

    public void pushPhysicalScope(RfDefElement scope) {
        this.fPhysicalScopes.push(scope);
    }

    public RfDefElement popPhysicalScope() {
        return this.fPhysicalScopes.pop();
    }

    public RfDefElement peekPhysicalScope() {
        return this.fPhysicalScopes.peek();
    }

    public boolean stackContains(RfDefElement elem) {
        for (RfDefElement defElem : this.fPhysicalScopes) {
            if (elem != defElem) continue;
            return true;
        }
        return false;
    }

    public RfDefElement getScope(int line, int offset) {
        return this.getScope(offset);
    }

    public RfDefElement getScope(int offset) {
        if (offset == this.fCachedScopeOffset && this.fCachedScope != null) {
            return this.fCachedScope;
        }
        this.fCachedScopeOffset = offset;
        this.fCachedScope = this.getScopeRecursive(offset, null, this.getChildren(), null);
        if (this.fCachedScope == null) {
            this.fCachedScope = this;
        }
        return this.fCachedScope;
    }

    public RfDefElement getScope(int offset, Class<? extends RfNamedElement> clazz) {
        if (offset == this.fCachedScopeOffset && this.fCachedScope != null && (clazz == null || clazz == this.fCachedScope.getNamedElement().getClass())) {
            return this.fCachedScope;
        }
        this.fCachedScopeOffset = offset;
        this.fCachedScope = this.getScopeRecursive(offset, null, this.getChildren(), clazz);
        if (this.fCachedScope == null) {
            this.fCachedScope = this;
        }
        return this.fCachedScope;
    }

    /*
     * Unable to fully structure code
     */
    private RfDefElement getScopeRecursive(int offset, RfDefElement result, Collection<RfDefElement> childList, Class<? extends RfNamedElement> clazz) {
        block10: {
            try {
                if (childList == null) {
                    return result;
                }
                layers = childList.toArray(new RfDefElement[childList.size()]);
                adaptiveStep = Math.max(100, layers.length / 100);
                i = layers.length - 1;
                while (i >= 0) {
                    block12: {
                        block11: {
                            child = null;
                            if (i - adaptiveStep < 0) break block11;
                            child = layers[i - adaptiveStep];
                            if (child.getChildren() == childList) break block12;
                            if (child.getStartOffset() <= offset) break block11;
                            i -= adaptiveStep;
                            break block12;
                        }
                        if ((child = layers[i]).getChildren() == childList) break block12;
                        if (child.getEndOffset() < offset) break block10;
                        if (child.getStartOffset() > offset) break block12;
                        if (result == null) {
                            result = child;
                            namedElement = result.getNamedElement();
                            if (namedElement != null && namedElement.getClass() == clazz) {
                                return result;
                            }
                            namedElement = (result = this.getScopeRecursive(offset, result, result.getChildren(), clazz)).getNamedElement();
                            if (namedElement != null && namedElement.getClass() == clazz) {
                                return result;
                            }
                            break;
                        }
                        if (result.containsOffset(child.getStartOffset()) && result.containsOffset(child.getEndOffset())) {
                            result = child;
                            namedElement = result.getNamedElement();
                            if (namedElement != null && namedElement.getClass() == clazz) {
                                return result;
                            }
                            namedElement = (result = this.getScopeRecursive(offset, result, result.getChildren(), clazz)).getNamedElement();
                            if (namedElement != null && namedElement.getClass() == clazz) {
                                return result;
                            } else {
                                ** GOTO lbl37
                            }
                        }
                        break block12;
lbl37:
                        // 2 sources

                        break;
                    }
                    --i;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }

    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public RfLibrary getEnclosingLibrary() {
        return this.fLibrary;
    }

    @Override
    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return this.fLanguageSyntax;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unit";
    }

    @Override
    public boolean isPredefined() {
        return this.fPredefined;
    }

    @Override
    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        return this.getEnclosingLibrary().getLibrariesWithPrefix(prefix, matchType);
    }

    @Override
    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        return this.getEnclosingLibrary().getLibraryWithPrefix(prefix, matchType);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fParserPath = null;
        this.fName = null;
        this.fLibrary = null;
        this.fLibraryName = null;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fPhysicalScopes = new ArrayDeque<RfDefElement>();
        Collection<RfDefElement> childrenDefs = this.getChildren();
        if (childrenDefs != null && !childrenDefs.isEmpty()) {
            for (RfDefElement childDef : childrenDefs) {
                childDef.recursiveSetDefFile(this);
            }
        }
    }

    protected RfLibrary restoreLibraryFromName(RfProject rfProject) {
        if (this.fLibraryName == null) {
            return null;
        }
        this.fLibrary = rfProject.getLocalLibrary(this.fLibraryName);
        return this.fLibrary;
    }

    public String getLibraryName() {
        return this.fLibraryName;
    }
}

