/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidUtils;

public class RfFunction
extends RfAssociatedType
implements IRfMethodElement {
    private static final long serialVersionUID = 1L;
    public static final int SIMPLE_SUBPROGRAM = 0;
    public static final int UNINSTANTIATED_SUBPROGRAM = 1;
    public static final int GENERIC_MAPPED_SUBPROGRAM = 2;
    public static final int GENERIC_SUBPROGRAM = 3;
    public static final int UNIVERSAL_SUBPROGRAM = 4;
    private boolean isProcedure;
    private int subprogramKind;
    public static final String ARRAY_MINIMUM_FUNCTION_NAME = "minimum";
    public static final String ARRAY_MAXIMUM_FUNCTION_NAME = "maximum";
    private transient RfFunction cachedImplementation;
    public static final Set<String> PREDEFINED_OPERATORS = new HashSet<String>(Arrays.asList("\"??\"", "\"and\"", "\"or\"", "\"nand\"", "\"nor\"", "\"xor\"", "\"xnor\"", "\"=\"", "\"/=\"", "\"<\"", "\"<=\"", "\">\"", "\">=\"", "\"?=\"", "\"?/=\"", "\"?<\"", "\"?<=\"", "\"?>\"", "\"?>=\"", "\"sll\"", "\"srl\"", "\"sla\"", "\"sra\"", "\"rol\"", "\"ror\"", "\"+\"", "\"-\"", "\"&\"", "\"*\"", "\"/\"", "\"mod\"", "\"rem\"", "\"**\"", "\"abs\"", "\"not\""));

    public RfFunction(String name, boolean isProcedure, int subprogramKind, DataType dataType) {
        super(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_TYPE);
        this.isProcedure = isProcedure;
        this.subprogramKind = subprogramKind;
    }

    public RfFunction(String name, boolean isProcedure, int subprogramKind, List<? extends IRfNamedElement> args, IRfNamedElement returnType, RfNamedElement enclosingScope) {
        this(name, isProcedure, subprogramKind, returnType == null ? null : new DataType(returnType.getName()));
        int index = 0;
        this.transientType = returnType;
        if (args != null) {
            for (IRfNamedElement iRfNamedElement : args) {
                int interfaceKind = iRfNamedElement instanceof RfVariable ? ((RfVariable)iRfNamedElement).getInterfaceKind() : 8;
                int fieldKind = iRfNamedElement instanceof RfVariable ? ((RfVariable)iRfNamedElement).getInterfaceKind() : 8192;
                this.addMember(new RfVariable(index == 0 ? "anonymous" : DVTStringUtil.appendString((Object[])new Object[]{"anonymous", index}), interfaceKind, fieldKind, iRfNamedElement));
                ++index;
            }
        }
        this.setEnclosingScope(enclosingScope, false);
    }

    public void addInEnclosingScopeOf(RfNamedElement type, RfFunctionsHolder holder) {
        if (type == null || type.getEnclosingScope() == null) {
            return;
        }
        RfNamedElement typeEnclosingScope = type.getEnclosingScope();
        if (holder == null) {
            holder = new RfFunctionsHolder(this.getName());
        }
        holder.addMember(this);
        RfDefElement typeEnclosingDef = typeEnclosingScope.getDeclaration();
        RfDefElement typeDef = type.getDeclaration();
        RfDefElement declaration = new RfDefElement(typeDef.getDefFile(), this.getName(), typeDef.getStartInfo(), typeDef.getEndInfo(), null);
        declaration = this.addDeclaration(declaration);
        typeEnclosingDef.addChild(declaration);
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        super.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        this.checkUnimplementedSubprogram(rfProject, report);
    }

    private void checkUnimplementedSubprogram(RfProject rfProject, boolean report) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (report && !this.isPredefined() && this.isPrototype()) {
            RfTypeBody typeBody;
            RfFunction implementation = this.getImplementation();
            if (implementation != this) {
                return;
            }
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath = declaration.getParserPath();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + declaration.getName().length();
            if (enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).hasPackageBody()) {
                RfPackage pkg = (RfPackage)this.getEnclosingScope();
                rfProject.addSemanticError(2, "MISSING_PACKAGE_BODY_DEFINITION: Subprogram ''{0}'' is not implemented in package body ''{1}''", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, this.getNiceSignatureText(), pkg.getName());
            }
            if (enclosingScope instanceof RfType && (typeBody = ((RfType)enclosingScope).getTypeBody()) != null) {
                rfProject.addSemanticError(2, "MISSING_SUBPROGRAM_BODY: Subprogram ''{0}'' is not implemented in protected type body ''{1}''", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, this.getNiceSignatureText(), typeBody.getName());
            }
        }
    }

    @Override
    public String getName() {
        String fullName = super.getName();
        return RfFunctionsHolder.getSimpleName(fullName);
    }

    @Override
    public String getLowerCaseName() {
        String fullLowerCaseName = super.getLowerCaseName();
        return RfFunctionsHolder.getSimpleName(fullLowerCaseName);
    }

    public void init(String name, boolean isProcedure, int subprogramKind, DataType dataType) {
        super.init(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_TYPE);
        this.isProcedure = isProcedure;
        this.subprogramKind = subprogramKind;
    }

    public String getFunctionSignatureWithReturnType(boolean printReturnType) {
        String typeName = this.getAssociatedTypeName();
        return String.valueOf(this.isProcedure ? "procedure " : "function ") + this.printScope() + this.getName() + "(" + (this.hasArguments() ? this.getArgs(true, true, false) : "") + ")" + (!printReturnType || typeName == null || typeName.isEmpty() ? "" : " : " + typeName);
    }

    public String getSignatureWithoutType(boolean printReturnType) {
        String typeName = this.getAssociatedTypeName();
        return String.valueOf(this.getName()) + "(" + (this.hasArguments() ? this.getArgs(true, true, false) : "") + ")" + (!printReturnType || typeName == null || typeName.isEmpty() ? "" : " : " + typeName);
    }

    public String getSignature() {
        return this.getFunctionSignatureWithReturnType(true);
    }

    public String getNiceSignatureText() {
        String returnType;
        String result = this.getQualifiedName();
        int argumentsIndex = result.indexOf("@a:");
        int returnIndex = result.indexOf("@r:");
        int isBodyIndex = result.indexOf("@b:");
        if (argumentsIndex == -1 || returnIndex == -1 || isBodyIndex == -1) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        name.append(result.substring(0, argumentsIndex)).append("[");
        String arguments = result.substring(argumentsIndex + "@a:".length(), returnIndex);
        if (!arguments.isEmpty()) {
            name.append(arguments);
        }
        if (!(returnType = result.substring(returnIndex + "@r:".length(), isBodyIndex)).isEmpty()) {
            if (!arguments.isEmpty()) {
                name.append(" ");
            }
            name.append("return ").append(returnType);
        }
        name.append("]");
        return name.toString();
    }

    public String getFullName(boolean removeBodyInfo) {
        int bodyInfoIndex;
        String result = this.getKey();
        if (removeBodyInfo && (bodyInfoIndex = result.indexOf("@b:")) > 0) {
            return result.substring(0, bodyInfoIndex);
        }
        return result;
    }

    public Set<String> getFullTranslatedName() {
        String fullName = this.getFullName(false);
        int replaceStart = fullName.indexOf("@a:");
        int replaceEnd = fullName.indexOf("@b:");
        StringBuilder signaturePrefix = new StringBuilder().append(fullName.substring(0, replaceStart + "@a:".length()));
        StringBuilder signature = new StringBuilder();
        String bodySignature = fullName.substring(replaceEnd, fullName.length());
        String returnTypeSignature = "@r:" + RfHidUtils.getAssocBaseType(this);
        List<RfVariable> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return Collections.singleton(signaturePrefix + signature + returnTypeSignature + bodySignature);
        }
        LinkedHashSet<String> allFullTranslatedSignatures = new LinkedHashSet<String>();
        for (RfVariable argument : arguments) {
            boolean hasInitialValue;
            String type = RfHidUtils.getAssocBaseType(argument);
            if (type == null || type.isEmpty()) continue;
            boolean bl = hasInitialValue = argument.getInitialValue(false) != null && !argument.getInitialValue(false).isEmpty();
            if (hasInitialValue && allFullTranslatedSignatures.isEmpty()) {
                allFullTranslatedSignatures.add(signaturePrefix + signature + returnTypeSignature + bodySignature);
            }
            if (signature.length() != 0) {
                signature.append(",");
            }
            signature.append(type.toLowerCase());
            if (!hasInitialValue) continue;
            allFullTranslatedSignatures.add(signaturePrefix + signature + returnTypeSignature + bodySignature);
        }
        allFullTranslatedSignatures.add(signaturePrefix + signature + returnTypeSignature + bodySignature);
        return allFullTranslatedSignatures;
    }

    public Object[] getAllArgsByName() {
        Object[] result = new Object[2];
        List<RfVariable> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            result[0] = Collections.emptyMap();
            result[1] = 0;
            return result;
        }
        LinkedHashMap<String, RfVariable> argsByName = new LinkedHashMap<String, RfVariable>();
        int defaultValueArgsNum = 0;
        for (RfVariable arg : arguments) {
            if (arg.getInitialValue(false) != null && !arg.getInitialValue(false).isEmpty()) {
                ++defaultValueArgsNum;
            }
            String argName = arg.getName();
            argsByName.put(argName, arg);
        }
        result[0] = argsByName;
        result[1] = defaultValueArgsNum;
        return result;
    }

    public boolean hasArguments() {
        List<RfVariable> variables = this.getLocalMembers(RfVariable.class);
        if (variables == null || variables.isEmpty()) {
            return false;
        }
        for (RfVariable variable : variables) {
            if (!variable.isArgument()) continue;
            return true;
        }
        return false;
    }

    public boolean isTask() {
        return this.isProcedure;
    }

    public boolean isFunction() {
        return !this.isProcedure;
    }

    public boolean isPredefinedOperator() {
        String name = this.getName();
        return PREDEFINED_OPERATORS.contains(name);
    }

    public boolean isGeneric() {
        return this.subprogramKind == 3;
    }

    public boolean isGenericMapped() {
        return this.subprogramKind == 2;
    }

    public int getNofArgs() {
        List<RfVariable> arguments = this.getArguments();
        return arguments == null || arguments.isEmpty() ? 0 : arguments.size();
    }

    public String getArgs(boolean addName, boolean hasType, boolean asTemplateVariables) {
        List<RfVariable> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator argIt = arguments.iterator();
        while (argIt.hasNext()) {
            RfVariable arg = (RfVariable)argIt.next();
            result.append(addName ? String.valueOf(asTemplateVariables ? "${" : "") + arg.getName() + (asTemplateVariables ? "}" : "") : "").append(addName && hasType ? " : " : "").append(hasType ? arg.getAssociatedTypeName() : "");
            if (!argIt.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public RfVariable getLocalArgument(String name) {
        RfVariable localMember = this.getLocalMember(RfVariable.class, name);
        if (localMember == null || !localMember.isArgument()) {
            return null;
        }
        return localMember;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        if (this.isTask()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCEDURE);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    public boolean isUninstantiated() {
        return this.subprogramKind == 1;
    }

    public boolean isPrototype() {
        String methodFullSignature = this.getFullName(false);
        int bodyInfoIndex = methodFullSignature.indexOf("@b:");
        if (bodyInfoIndex < 0) {
            return true;
        }
        return !"true".equalsIgnoreCase(this.getFullName(false).substring(bodyInfoIndex + "@b:".length()));
    }

    public RfFunction getPrototype() {
        RfPackage correspondingEnclosing;
        if (this.isPrototype()) {
            return this;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        RfNamedElement rfNamedElement = enclosingScope instanceof RfPackageBody ? ((RfPackageBody)enclosingScope).getPackage() : (correspondingEnclosing = enclosingScope instanceof RfTypeBody ? ((RfTypeBody)enclosingScope).getType() : null);
        if (correspondingEnclosing == null) {
            return this;
        }
        List<RfFunction> possiblePrototypes = correspondingEnclosing.getFunctionsWithPrefix(this.getName(), 9, true);
        if (possiblePrototypes == null) {
            return this;
        }
        for (RfFunction possible : possiblePrototypes) {
            if (!this.equals(possible)) continue;
            return possible;
        }
        return this;
    }

    public RfFunction getImplementation() {
        RfPackageBody correspondingEnclosing;
        if (this.cachedImplementation != null) {
            return this.cachedImplementation;
        }
        if (!this.isPrototype()) {
            this.cachedImplementation = this;
            return this.cachedImplementation;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        RfAssociatedType rfAssociatedType = enclosingScope instanceof RfPackage ? ((RfPackage)enclosingScope).getPackageBody() : (correspondingEnclosing = enclosingScope instanceof RfType && ((RfType)enclosingScope).isProtected() ? ((RfType)enclosingScope).getTypeBody() : null);
        if (correspondingEnclosing == null) {
            this.cachedImplementation = this;
            return this.cachedImplementation;
        }
        List<RfFunction> possiblePrototypes = correspondingEnclosing.getFunctionsWithPrefix(this.getName(), 9, true);
        for (RfFunction possible : possiblePrototypes) {
            if (!this.equals(possible) || possible.isPrototype()) continue;
            this.cachedImplementation = possible;
            return this.cachedImplementation;
        }
        this.cachedImplementation = this;
        return this.cachedImplementation;
    }

    public void setSubprogramKind(int subprogramKind) {
        this.subprogramKind = subprogramKind;
    }

    public int getSubprogramKind() {
        return this.subprogramKind;
    }

    @Override
    public String elementPathName() {
        return super.getName();
    }

    @Override
    public String toString() {
        return this.getFunctionSignatureWithReturnType(true);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isProcedure ? 1231 : 1237);
        result = 31 * result + this.subprogramKind;
        result = 31 * result + this.getFullName(true).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RfFunction)) {
            return false;
        }
        RfFunction other = (RfFunction)obj;
        if (this.isProcedure != other.isProcedure) {
            return false;
        }
        if (this.subprogramKind != other.subprogramKind) {
            return false;
        }
        return this.getFullName(true).equals(other.getFullName(true)) && this.getEnclosingScope().checkEquals(other.getEnclosingScope());
    }

    public boolean equals(Object obj, boolean strict) {
        boolean anyFunctionUniversal;
        if (!(obj instanceof RfFunction)) {
            return false;
        }
        RfFunction function = (RfFunction)obj;
        List<RfVariable> otherArguments = function.getArguments();
        List<RfVariable> myArguments = this.getArguments();
        boolean bl = anyFunctionUniversal = this.isUniversal() || function.isUniversal();
        if (otherArguments != null && myArguments != null) {
            int noArgs = Math.max(otherArguments.size(), myArguments.size());
            int i = 0;
            while (i < noArgs) {
                RfVariable myArg;
                RfVariable otherArg = i >= otherArguments.size() ? null : otherArguments.get(i);
                RfVariable rfVariable = myArg = i >= myArguments.size() ? null : myArguments.get(i);
                if (myArg == null) {
                    return otherArg == null || anyFunctionUniversal && otherArg.getInitialValue(false) != null;
                }
                if (otherArg == null) {
                    return anyFunctionUniversal && myArg.getInitialValue(false) != null;
                }
                IRfNamedElement otherArgumentType = otherArg.getAssociatedType();
                IRfNamedElement myArgumentType = myArg.getAssociatedType();
                if (otherArgumentType == null && myArgumentType != null) {
                    return false;
                }
                if (strict ? otherArgumentType != null && !otherArgumentType.equals(myArgumentType) : otherArgumentType != null && !otherArgumentType.checkTypeCompatibility(myArgumentType)) {
                    return false;
                }
                ++i;
            }
        }
        IRfNamedElement otherReturnType = function.getAssociatedType();
        IRfNamedElement myReturnType = this.getAssociatedType();
        if (otherReturnType == null) {
            return myReturnType == null;
        }
        return !(strict ? !otherReturnType.equals(myReturnType) : !otherReturnType.checkTypeCompatibility(myReturnType));
    }

    private boolean isUniversal() {
        return this.subprogramKind == 4;
    }

    @Override
    public String getFullNameLabel() {
        return String.valueOf(super.getFullNameLabel()) + "()";
    }

    @Override
    public boolean checkEquals(Object obj) {
        return this.equals(obj);
    }

    @Override
    public String getCustomName() {
        return this.getFullName(false);
    }

    @Override
    public boolean isBefore(int useIndex, int useLine, int useOffset) {
        if (!this.isPrototype()) {
            RfFunction prototype = this.getPrototype();
            return prototype != this ? prototype.isBefore(useIndex, useLine, useOffset) : super.isBefore(useIndex, useLine, useOffset);
        }
        return super.isBefore(useIndex, useLine, useOffset);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.cachedImplementation = null;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.cachedImplementation = null;
    }
}

