/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfWrapper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class RfFunctionsHolder
extends RfNamedElement
implements IRfWrapper {
    private static final long serialVersionUID = 2L;

    public RfFunctionsHolder(String name, List<? extends RfNamedElement> functions) {
        this(name);
        if (functions == null || functions.isEmpty()) {
            functions = Collections.emptyList();
        }
        for (RfNamedElement function : functions) {
            this.addMember(function);
        }
    }

    public static RfFunctionsHolder of(String name, List<RfFunctionsHolder> functHolders) {
        if (functHolders == null || functHolders.isEmpty()) {
            functHolders = Collections.emptyList();
        }
        RfFunctionsHolder holder = new RfFunctionsHolder(name);
        for (RfFunctionsHolder functHolder : functHolders) {
            holder.addMembers(functHolder);
        }
        return holder;
    }

    public void addFromFunctionsHolders(List<RfFunctionsHolder> holders) {
        if (holders == null || holders.isEmpty()) {
            return;
        }
        for (RfFunctionsHolder holder : holders) {
            this.addMembers(holder);
        }
    }

    public RfFunctionsHolder(String name) {
        super(name);
    }

    @Override
    public String getContextType() {
        return null;
    }

    public String getSignature() {
        List<RfFunction> localFunctions = this.getLocalMembers(RfFunction.class);
        if (localFunctions == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RfFunction func : localFunctions) {
            sb.append(func.getSignature());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        return super.getEnclosingScope();
    }

    @Override
    public boolean isDirtyElement() {
        return this.getMembers() == null || this.getMembers().isEmpty();
    }

    protected void addMembers(RfNamedElement element) {
        if (element == null) {
            return;
        }
        Collection<RfNamedElement> members = element.getMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfNamedElement member : members) {
            if (member instanceof RfDuplicate) {
                this.addMembers(member);
                continue;
            }
            this.addMember(member);
        }
    }

    @Override
    protected void addMember(RfNamedElement element) {
        this.internalAddMember(element);
    }

    public boolean hasMultipleFunctions() {
        return this.nofFunctions() > 1;
    }

    public int nofFunctions() {
        List<RfFunction> candidates = this.getLocalMembers(RfFunction.class);
        if (candidates == null || candidates.isEmpty()) {
            return 0;
        }
        return candidates.size();
    }

    public RfFunction getFunctionByArgumentTypes(List<IRfNamedElement> argumentTypes, IRfNamedElement returnType) {
        if (argumentTypes == null) {
            return null;
        }
        block0: for (RfFunction candidate : this.getLocalMembers(RfFunction.class)) {
            List<RfVariable> arguments = candidate.getArguments();
            if (arguments.size() != argumentTypes.size() || !(returnType != null ^ candidate.isTask())) continue;
            int i = 0;
            for (RfVariable argument : arguments) {
                IRfNamedElement candArgResolvedType;
                IRfNamedElement argResolvedType;
                if (!(argResolvedType = argumentTypes.get(i++)).checkTypeCompatibility(candArgResolvedType = argument.getResolvedType(true))) continue block0;
            }
            if (returnType != null && !returnType.checkTypeCompatibility(candidate.getResolvedType(true))) continue;
            return candidate;
        }
        return null;
    }

    public RfFunction getLastDefinedFunction() {
        List<RfFunction> candidates = this.getLocalMembers(RfFunction.class);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        return candidates.get(candidates.size() - 1);
    }

    @Override
    public void setEnclosingScope(IRfNamedElement enclosingScope, boolean isRestore) {
        super.setEnclosingScope(enclosingScope, isRestore);
        if (isRestore) {
            this.setEnclosingScopeOfChildrenForRestore(enclosingScope);
        }
    }

    public static final String getSimpleName(String fullName) {
        if (fullName == null) {
            return null;
        }
        int index = fullName.indexOf("@a:");
        if (index > 0) {
            return fullName.substring(0, index);
        }
        return fullName;
    }

    public <T extends IRfNamedElement> T getNamedElement(Class<T> clazz) {
        RfFunction firstElement = this.getLastDefinedFunction();
        if (clazz.isInstance(firstElement)) {
            return (T)firstElement;
        }
        return null;
    }

    public String getTooltipFormatedText() {
        StringBuilder sb = new StringBuilder();
        for (RfFunction func : this.getLocalMembers(RfFunction.class)) {
            sb.append("<b>");
            sb.append(DVTStringUtil.partiallyEscapeHTML((String)func.getSignature()));
            sb.append("</b><br>");
            if (func.getComment() == null || func.getComment().isEmpty()) continue;
            sb.append(DVTStringUtil.partiallyEscapeHTML((String)func.getComment()));
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public RfDefElement getDeclaration() {
        RfFunction function = this.getLastDefinedFunction();
        return function != null ? function.getDeclaration() : null;
    }

    @Override
    public RfProject getRfProject() {
        RfFunction function = this.getLastDefinedFunction();
        if (function != null) {
            return function.getRfProject();
        }
        return null;
    }

    @Override
    public boolean checkEquals(Object obj) {
        List<RfFunction> localFunctions = this.getLocalMembers(RfFunction.class);
        if (localFunctions == null) {
            return false;
        }
        for (RfFunction func : localFunctions) {
            if (!func.checkEquals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        if (this.isDirtyElement()) {
            return true;
        }
        RfFunction lastDefinedFunction = this.getLastDefinedFunction();
        return lastDefinedFunction == null || lastDefinedFunction.hasNoDefs(rawDefs);
    }

    public boolean isGeneric() {
        RfFunction function = this.getLastDefinedFunction();
        return function != null && function.isGeneric();
    }

    @Override
    public int getInvocNumber() {
        return -1;
    }

    @Override
    public int getDeclarationIndex() {
        return -1;
    }

    @Override
    public boolean isBefore(RfNamedElement usageElement) {
        return true;
    }

    @Override
    public boolean isBefore(int useIndex, int useLine, int useOffset) {
        return true;
    }
}

