/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;

public class RfGeneratesContainer
extends RfBlock {
    private static final long serialVersionUID = 1L;
    @NotNull
    private transient List<RfBlock> listMembers;

    public RfGeneratesContainer(String name, List<RfBlock> generates) {
        super(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_BLOCK, 0L, null, false, 0);
        this.listMembers = generates;
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        for (RfBlock member : this.listMembers) {
            IRfNamedElement result = member.semanticGetLocalMember(name, hid, parserPath, null, visited, enumNameProposals, isFirst, isLast, recursiveCall);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        for (RfBlock member : this.listMembers) {
            IRfNamedElement result = member.getMember(name, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        for (RfBlock member : this.listMembers) {
            if (!member.hasNoDefs(rawDefs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RfDefElement getDeclaration() {
        RfBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getDeclaration();
        }
        return null;
    }

    public Collection<RfDefElement> getDeclarations() {
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        for (RfBlock member : this.listMembers) {
            if (member.hasNoDefs(false)) continue;
            result.addAll(member.getDeclarations());
        }
        return result;
    }

    @Override
    public int getAllDefsSize() {
        int result = 0;
        for (RfBlock member : this.listMembers) {
            if (member.hasNoDefs(false)) continue;
            result += member.getAllDefsSize();
        }
        return result;
    }

    public <T extends IRfNamedElement> T getLastMember(Class<T> clazz) {
        int i = this.listMembers.size() - 1;
        while (i >= 0) {
            RfNamedElement member = this.listMembers.get(i);
            if (clazz.isInstance(member)) {
                return (T)member;
            }
            --i;
        }
        return null;
    }

    public RfBlock getFirstMember() {
        return this.listMembers.get(0);
    }

    public RfBlock getGenerateBlockAlternative(String label) {
        if (label == null) {
            return this.getFirstMember();
        }
        for (RfBlock member : this.listMembers) {
            if (!label.equals(member.getAlternativeLabel())) continue;
            return member;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<RfNamedElement> getMembers() {
        return new ArrayList<RfNamedElement>(this.listMembers);
    }

    @Override
    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        ArrayList<? extends IRfBlockElement> result = new ArrayList<IRfBlockElement>();
        for (RfBlock member : this.listMembers) {
            Collection<? extends IRfBlockElement> localGenerates = member.getLocalGenerateBlocks();
            if (localGenerates == null || localGenerates.isEmpty()) continue;
            result.addAll(localGenerates);
        }
        return result;
    }

    @Override
    public Collection<? extends IRfActionBlockElement> getLocalActionBlocks() {
        ArrayList<? extends IRfActionBlockElement> result = new ArrayList<IRfActionBlockElement>();
        for (RfBlock member : this.listMembers) {
            Collection<? extends IRfActionBlockElement> localActionBlocks = member.getLocalActionBlocks();
            if (localActionBlocks == null || localActionBlocks.isEmpty()) continue;
            result.addAll(localActionBlocks);
        }
        return result;
    }

    @Override
    public RfNamedElement getEnclosingScope() {
        RfBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingScope();
        }
        return null;
    }

    @Override
    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingScope(clazz);
        }
        return null;
    }

    @Override
    public RfLibrary getEnclosingLibrary() {
        RfBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getEnclosingLibrary();
        }
        return null;
    }

    @Override
    public LibraryPackageScope getLibPkgScope() {
        RfBlock firstMember = this.getFirstMember();
        if (firstMember != null) {
            return firstMember.getLibPkgScope();
        }
        return null;
    }

    @Override
    public String getSignature() {
        return "generate blocks " + this.getName();
    }

    @Override
    public String getCustomName() {
        return this.getName();
    }

    @Override
    public String elementPathName() {
        return this.getName();
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        if (classes != null && !classes.contains(RfBlock.class)) {
            return null;
        }
        for (RfBlock member : this.listMembers) {
            if (!member.elementPathName().equals(name)) continue;
            return member;
        }
        return null;
    }

    @Override
    public int getInducedParametricDependencyValue() {
        return 15;
    }
}

