/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public enum RfKind implements IRfKind
{
    ENTITY("entity"),
    ARCHITECTURE("architecture"),
    ENUM("enum"),
    PACKAGE("package"),
    PACKAGE_BODY("package body"),
    PORT("port"),
    INPUT_PORT("input port"),
    INOUT_PORT("inout port"),
    OUTPUT_PORT("output port"),
    BUFFER_PORT("buffer port"),
    LINKAGE_PORT("linkage port"),
    VARIABLE("variable"),
    PROCEDURE("procedure"),
    FUNCTION("function"),
    BLOCK("block"),
    PROCESS("process"),
    COMPONENT("component"),
    INSTANCE("instance"),
    TYPE("type"),
    TYPE_BODY("type body"),
    CONFIGURATION("configuration"),
    INTERFACE_PORT("interface_port"),
    ARGUMENT("argument"),
    GENERIC("generic"),
    CONSTANT("constant"),
    SIGNAL("signal"),
    LIBRARY("library"),
    FILE("FILE"),
    UNKNOWN("");

    private String fName;

    private RfKind(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public String getCapitalizedName() {
        if (this.fName == null || this.fName.length() == 0) {
            return this.fName;
        }
        return String.valueOf(Character.toUpperCase(this.fName.charAt(0))) + this.fName.substring(1);
    }

    public static RfKind of(IRfNamedElement element) {
        if (element instanceof RfEntity) {
            return ENTITY;
        }
        if (element instanceof RfType) {
            return TYPE;
        }
        if (element instanceof RfTypeBody) {
            return TYPE_BODY;
        }
        if (element instanceof RfArchitecture) {
            return ARCHITECTURE;
        }
        if (element instanceof RfEnum) {
            return ENUM;
        }
        if (element instanceof RfPackage) {
            return PACKAGE;
        }
        if (element instanceof RfPackageBody) {
            return PACKAGE_BODY;
        }
        if (element instanceof RfPort) {
            RfPort port = (RfPort)element;
            if (port.isInput()) {
                return INPUT_PORT;
            }
            if (port.isInout()) {
                return INOUT_PORT;
            }
            if (port.isBuffer()) {
                return BUFFER_PORT;
            }
            if (port.isLinkage()) {
                return LINKAGE_PORT;
            }
            if (port.isOutput()) {
                return OUTPUT_PORT;
            }
            return INTERFACE_PORT;
        }
        if (element instanceof RfFunction) {
            if (((RfFunction)element).isTask()) {
                return PROCEDURE;
            }
            return FUNCTION;
        }
        if (element instanceof RfBlock) {
            return BLOCK;
        }
        if (element instanceof RfProcess) {
            return PROCESS;
        }
        if (element instanceof RfComponent) {
            return COMPONENT;
        }
        if (element instanceof RfInstance) {
            return INSTANCE;
        }
        if (element instanceof RfConfiguration) {
            return CONFIGURATION;
        }
        if (element instanceof RfVariable) {
            if (((RfVariable)element).isArgument()) {
                return ARGUMENT;
            }
            if (((RfVariable)element).isParameter()) {
                return GENERIC;
            }
            if (((RfVariable)element).isConstant()) {
                return CONSTANT;
            }
            if (((RfVariable)element).isSharedVariable()) {
                return VARIABLE;
            }
            if (((RfVariable)element).isSignal()) {
                return SIGNAL;
            }
            if (((RfVariable)element).isFile()) {
                return FILE;
            }
            return VARIABLE;
        }
        if (element instanceof RfLibrary) {
            return LIBRARY;
        }
        return UNKNOWN;
    }
}

