/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedIdentityHashSet;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfLibrary
extends RfNamedElement
implements IRfLibraryElement {
    private static final long serialVersionUID = 2L;
    public static final Set<Class<? extends IRfScopeElement>> ELABCONSTANTS_SKIPPED_MEMBERS = new LinkedHashSet<Class<? extends IRfScopeElement>>();
    private transient Map<String, Set<IRfNamedElement>> fTypeReferences;
    private Map<String, String> fTranslatedLibraryNames;
    private ImportInfo stdStandardPackageUse;

    static {
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfArchitecture.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfEntity.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfPackage.class);
        ELABCONSTANTS_SKIPPED_MEMBERS.add(RfPackageBody.class);
    }

    public RfLibrary(String name, RfProject rfProject) {
        super(name);
        this.setEnclosingScope(rfProject, false);
    }

    public void initPredefinedLibraries(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        if (this instanceof RfDummyElement) {
            return;
        }
        ArrayList<DataTypeChunk> useList = new ArrayList<DataTypeChunk>();
        useList.add(new DataTypeChunk("std", -1, -1));
        useList.add(new DataTypeChunk("standard", -1, -1));
        this.stdStandardPackageUse = ImportInfo.StdImportInfo.of(useList);
        this.fTranslatedLibraryNames = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.fTranslatedLibraryNames.put("std", languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 ? "std_08" : "std_93");
        this.fTranslatedLibraryNames.put("ieee", languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 ? "ieee_08" : "ieee_93");
        this.fTranslatedLibraryNames.put("VITAL2000", this.fTranslatedLibraryNames.get("ieee"));
    }

    public String getSignature() {
        return "library " + this.getCustomName();
    }

    @Override
    public RfProject getRfProject() {
        return (RfProject)this.getEnclosingScope();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public boolean isDirtyElement() {
        return false;
    }

    @Override
    public void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
    }

    public void resolveHidsSuper(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        super.resolveHids(configInfo, triggerError, disableExprEvaluate, skipMemberClasses);
    }

    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean resolvePredefined, boolean disableExprEvaluate, FullChecksKind fullChecksKind, Set<String> onlyPkgNames) throws BuildCancelException {
        List<RfPackage> packages;
        ExecutorService executor = ((RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature")).getExecutorService();
        SemanticWorker worker = new SemanticWorker(configInfo, triggerError, resolvePredefined, disableExprEvaluate, null);
        executor.execute(worker);
        Set visitedPackages = Collections.newSetFromMap(new IdentityHashMap());
        List<RfPackageBody> packageBodies = this.getLocalMembers(RfPackageBody.class);
        if (packageBodies != null) {
            for (RfPackageBody packageElement : packageBodies) {
                String packageElementName = packageElement.getName();
                if (onlyPkgNames != null && fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(packageElementName) || onlyPkgNames != null && fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(packageElementName)) continue;
                RfPackage ownPackage = packageElement.getPackage();
                if (ownPackage != null) {
                    visitedPackages.add(ownPackage);
                }
                worker = new SemanticWorker(configInfo, triggerError &= !packageElement.isPredefined(), resolvePredefined, disableExprEvaluate, packageElement);
                executor.execute(worker);
            }
        }
        if ((packages = this.getLocalMembers(RfPackage.class)) != null) {
            for (RfPackage packageElement : packages) {
                if (visitedPackages.contains(packageElement)) continue;
                String packageElementName = packageElement.getName();
                if (onlyPkgNames != null && fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(packageElementName) || onlyPkgNames != null && fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(packageElementName)) continue;
                worker = new SemanticWorker(configInfo, triggerError &= !packageElement.isPredefined(), resolvePredefined, disableExprEvaluate, packageElement);
                executor.execute(worker);
            }
        }
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, Iterator<? extends RfNamedElement> it, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if ("work".equalsIgnoreCase(name)) {
            return this;
        }
        IRfNamedElement result = super.semanticGetLocalMember(name, hid, parserPath, prevScope, visited, enumNameProposals, isFirst, isLast, recursiveCall);
        if (result != null) {
            return result;
        }
        Set<String> configNames = this.getConfigNames();
        if (configNames == null || configNames.isEmpty()) {
            return result;
        }
        String lowerCaseName = name.toLowerCase();
        if (!configNames.contains(lowerCaseName)) {
            return result;
        }
        RfConfiguration configurationWithPrefix = this.getConfigurationWithPrefix(name, 5);
        return configurationWithPrefix;
    }

    @Override
    protected IRfNamedElement semanticGetMember(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        name = this.translateLibraryName(name);
        return super.semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
    }

    @Override
    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        prefix = this.translateLibraryName(prefix);
        return super.getLibraryWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        List<RfLibrary> librariesWithPrefix = super.getLibrariesWithPrefix(prefix = this.translateLibraryName(prefix), matchType);
        if (librariesWithPrefix == null || librariesWithPrefix.isEmpty()) {
            return librariesWithPrefix;
        }
        String otherStdLibraryName = this.getOtherStdTranslatedLibrary();
        String otherIeeeLibraryName = this.getOtherIeeeTranslatedLibrary();
        Iterator<RfLibrary> it = librariesWithPrefix.iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            if (otherStdLibraryName.equals(name)) {
                it.remove();
                continue;
            }
            if (!otherIeeeLibraryName.equals(name)) continue;
            it.remove();
        }
        return librariesWithPrefix;
    }

    public String translateLibraryName(String name) {
        if (this.fTranslatedLibraryNames != null && this.fTranslatedLibraryNames.containsKey(name)) {
            return this.fTranslatedLibraryNames.get(name);
        }
        return name;
    }

    @Override
    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        boolean equals;
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        result.addAll(this.getEntitiesWithPrefix(prefix, matchType));
        boolean bl = equals = (matchType & 1) != 0;
        if (!equals || result.isEmpty()) {
            result.addAll(this.getConfigurationsWithPrefix(prefix, matchType));
        }
        return result;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        RfNamedElement candidate = this.getEntityWithPrefix(prefix, matchType);
        if (candidate == null) {
            candidate = this.getConfigurationWithPrefix(prefix, matchType);
        }
        return candidate;
    }

    @Override
    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        boolean equals;
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        result.addAll(this.getTypesWithPrefix(prefix, matchType, true));
        boolean bl = equals = (matchType & 1) != 0;
        if (!equals || result.isEmpty()) {
            result.addAll(this.getComponentsWithPrefix(prefix, matchType, true));
        }
        return result;
    }

    @Override
    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        RfNamedElement candidate = this.getTypeWithPrefix(prefix, matchType, true);
        if (candidate == null) {
            candidate = this.getComponentWithPrefix(prefix, matchType, true);
        }
        return candidate;
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        boolean equals;
        this.internalGetMembersWithPrefix(result, RfType.class, prefix, null, first, matchType, true);
        boolean bl = equals = (matchType & 1) != 0;
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfPackage.class, prefix, null, first, matchType, true);
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfContext.class, prefix, null, first, matchType, true);
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfEntity.class, prefix, null, first, matchType, true);
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfAlias.class, prefix, null, first, matchType, true);
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        IRfNamedElement result = super.getMember(name, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, skipParents);
        if (result != null) {
            return result;
        }
        if (classes != null && !classes.contains(RfConfiguration.class)) {
            return null;
        }
        return this.getConfigurationWithPrefix(name, 1);
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        List<RfEntity> entities;
        HashMap tempResult = new HashMap();
        if (clazz == null || clazz == RfPackage.class) {
            this.internalGetMembersWithPrefix(tempResult, RfPackage.class, prefix, null, isFirst, matchType, true);
        }
        if (clazz == null || clazz == RfType.class) {
            this.internalGetMembersWithPrefix(tempResult, RfType.class, prefix, null, isFirst, matchType, true);
        }
        if (clazz == null || clazz == RfEntity.class) {
            this.internalGetMembersWithPrefix(tempResult, RfEntity.class, prefix, null, isFirst, matchType, true);
        }
        if (clazz == null || clazz == RfAlias.class) {
            this.internalGetMembersWithPrefix(tempResult, RfAlias.class, prefix, null, isFirst, matchType, true);
        }
        if (!(clazz != null && clazz != RfConfiguration.class || (entities = this.getLocalMembers(RfEntity.class)) == null || entities.isEmpty())) {
            for (RfEntity entity : entities) {
                entity.internalGetMembersWithPrefix(tempResult, RfConfiguration.class, prefix, null, isFirst, matchType, true);
            }
        }
        for (IRfNamedElement candidate : tempResult.values()) {
            result.add(candidate);
        }
    }

    @Override
    public RfArchitecture getArchitectureWithPrefix(String prefix, int matchType) {
        List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        HashMap resultMap = new HashMap();
        int i = entities.size() - 1;
        while (i >= 0) {
            entities.get(i).internalGetMembersWithPrefix(resultMap, RfArchitecture.class, prefix, null, true, matchType, true);
            if (!resultMap.isEmpty()) {
                return (RfArchitecture)resultMap.values().iterator().next();
            }
            --i;
        }
        return null;
    }

    @Override
    public List<RfArchitecture> getArchitecturesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
        if (entities == null || entities.isEmpty()) {
            return new NullProtectedList<RfArchitecture>((Collection<RfArchitecture>)resultMap.values());
        }
        for (RfEntity entity : entities) {
            entity.internalGetMembersWithPrefix(resultMap, RfArchitecture.class, prefix, null, false, matchType, true);
        }
        return new NullProtectedList<RfArchitecture>((Collection<RfArchitecture>)resultMap.values());
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        IRfNamedElement result = super.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, skipParents);
        if (result != null) {
            return result;
        }
        if (classes != null && classes.contains(RfConfiguration.class)) {
            List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
            if (entities == null || entities.isEmpty()) {
                return null;
            }
            int i = entities.size() - 1;
            while (i >= 0) {
                result = entities.get(i).getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                if (result != null) {
                    return result;
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public RfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
        if (entities == null || entities.isEmpty()) {
            return null;
        }
        HashMap resultMap = new HashMap();
        int i = entities.size() - 1;
        while (i >= 0) {
            entities.get(i).internalGetMembersWithPrefix(resultMap, RfConfiguration.class, prefix, null, true, matchType, true);
            if (!resultMap.isEmpty()) {
                return (RfConfiguration)resultMap.values().iterator().next();
            }
            --i;
        }
        return null;
    }

    @Override
    public List<RfConfiguration> getConfigurationsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
        if (entities == null || entities.isEmpty()) {
            return new NullProtectedList<RfConfiguration>((Collection<RfConfiguration>)resultMap.values());
        }
        for (RfEntity entity : entities) {
            entity.internalGetMembersWithPrefix(resultMap, RfConfiguration.class, prefix, null, false, matchType, true);
        }
        return new NullProtectedList<RfConfiguration>((Collection<RfConfiguration>)resultMap.values());
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LIBRARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String typeName, IRfNamedElement referencedIn) {
        if (typeName == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        if (referencedIn == this) {
            return;
        }
        RfLibrary rfLibrary = this;
        synchronized (rfLibrary) {
            String typeNameKey;
            OptimizedIdentityHashSet types;
            if (this.fTypeReferences == null) {
                this.fTypeReferences = new HashMap<String, Set<IRfNamedElement>>();
            }
            if ((types = this.fTypeReferences.get(typeNameKey = typeName.toUpperCase())) == null) {
                types = new OptimizedIdentityHashSet();
                this.fTypeReferences.put(DVTStringUtil.intern((String)typeNameKey), (Set<IRfNamedElement>)types);
            }
            types.add((IRfNamedElement)referencedIn);
        }
    }

    public void addReferenceInClosestContainer(String typeName, IRfNamedElement referencedIn) {
        IRfScopeElement scope;
        if (referencedIn != null && (scope = referencedIn.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) instanceof IRfNamedElement) {
            referencedIn = (IRfNamedElement)scope;
        }
        this.addReference(typeName, referencedIn);
    }

    public void addReference(DataType dataType, IRfNamedElement referencedIn) {
        if (dataType == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        List<DataTypeChunk> typeName = dataType.getTypeName();
        if (typeName == null || typeName.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < typeName.size()) {
            this.addReference(typeName.get((int)i).name, referencedIn);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IRfNamedElement> getReferences(String typeName) {
        if (this.fTypeReferences == null) {
            return null;
        }
        RfLibrary rfLibrary = this;
        synchronized (rfLibrary) {
            Set<IRfNamedElement> references;
            block7: {
                String typeNameKey = typeName.toUpperCase();
                references = this.fTypeReferences.get(typeNameKey);
                if (references != null && !references.isEmpty()) break block7;
                return null;
            }
            HashSet<IRfNamedElement> result = new HashSet<IRfNamedElement>(references);
            for (IRfNamedElement reference : references) {
                RfPackageBody packageBody;
                if (!(reference instanceof RfPackage) || (packageBody = ((RfPackage)reference).getPackageBody()) == null) continue;
                result.add(packageBody);
            }
            Iterator<IRfNamedElement> iterator = references.iterator();
            while (iterator.hasNext()) {
                IRfNamedElement reference = iterator.next();
                if (!reference.hasNoDefs(false)) continue;
                iterator.remove();
            }
            return result;
        }
    }

    public String getStdTranslatedLibrary() {
        return this.fTranslatedLibraryNames != null ? this.fTranslatedLibraryNames.get("std") : "std_08";
    }

    private String getOtherStdTranslatedLibrary() {
        return this.getStdTranslatedLibrary().equals("std_08") ? "std_93" : "std_08";
    }

    public String getIeeeTranslatedLibrary() {
        return this.fTranslatedLibraryNames != null ? this.fTranslatedLibraryNames.get("ieee") : "ieee_08";
    }

    private String getOtherIeeeTranslatedLibrary() {
        return this.getIeeeTranslatedLibrary().equals("ieee_08") ? "ieee_93" : "ieee_08";
    }

    public void cleanElaborationInfoFromDesigns() {
        this.accept(this.getRfProject(), namedElement -> {
            if (namedElement instanceof IRfDesignElement) {
                RfMixedLangProject.recursiveCleanElaborationInfoFromDesign((IRfDesignElement)((IRfDesignElement)namedElement));
            } else if (namedElement instanceof IRfPackageElement) {
                RfMixedLangProject.cleanElaborationInfoFromPackages((IRfPackageElement)((IRfPackageElement)namedElement));
            }
            return true;
        });
    }

    @Override
    public String getCustomName() {
        String name = this.getName();
        return "std_08".equals(name) || "std_93".equals(name) ? "std" : ("ieee_08".equals(name) || "ieee_93".equals(name) ? "ieee" : name);
    }

    public void resolveTypes2(final ConfigInfo configInfo, final RfProject rfProject, final boolean triggerError, final boolean onlyUnresolved, final boolean otherLanguage, FullChecksKind fullChecksKind, Set<String> onlyPkgNames) {
        if (!onlyUnresolved) {
            this.fTransientUsedRecordTypes = null;
        }
        configInfo.closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null) {
            return;
        }
        Iterator<RfNamedElement> it = members.iterator();
        ExecutorService executor = rfProject.getExecutorService();
        block0: while (it.hasNext()) {
            final RfNamedElement element = it.next();
            if (onlyPkgNames != null) {
                Collection<RfNamedElement> duplicateMembers;
                if (element instanceof RfPackage || element instanceof RfPackageBody) {
                    if (fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(element.getName()) || fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(element.getName())) {
                        continue;
                    }
                } else if (element instanceof RfDuplicate && (duplicateMembers = ((RfDuplicate)element).getMembers()) != null) {
                    for (RfNamedElement member : duplicateMembers) {
                        if ((member instanceof RfPackage || member instanceof RfPackageBody) && (fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(member.getName()) || fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(member.getName()))) continue block0;
                    }
                }
            }
            SemanticWorker worker = new SemanticWorker(this, null, triggerError, false, false, null){

                @Override
                public void run() {
                    ConfigInfo newConfigInfo = new ConfigInfo(configInfo);
                    element.resolveTypes(newConfigInfo, rfProject, triggerError, onlyUnresolved, otherLanguage, null);
                }
            };
            executor.execute(worker);
        }
    }

    @Override
    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        if (this.stdStandardPackageUse == null) {
            return;
        }
        IRfNamedElement importElement = this.stdStandardPackageUse.getElement();
        if (importElement == null) {
            IRfNamedElement element = this.stdStandardPackageUse.resolve(rfProject, this, false);
            this.stdStandardPackageUse.setElement(element);
        }
        super.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
    }

    public ImportInfo getStdPackageImport() {
        return this.stdStandardPackageUse;
    }

    public IRfNamedElement semanticGetMemberInSTDStandardUseClause(String name) {
        if (this.stdStandardPackageUse == null) {
            return null;
        }
        IRfNamedElement result = null;
        IRfNamedElement element = this.stdStandardPackageUse.getElement();
        if (element instanceof RfNamedElement) {
            result = ((RfNamedElement)element).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
        } else if (element instanceof IRfLibraryElement) {
            result = element.getDesignWithPrefix(name, 9);
        }
        return result;
    }

    @Override
    public String getFullNameLabel() {
        return this.getName();
    }

    @Override
    public String toString() {
        return this.getCustomName();
    }

    @NotNull
    public List<RfNamedElement> getAllConfigurations() {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        List<RfEntity> entities = this.getLocalMembers(RfEntity.class);
        if (entities != null && !entities.isEmpty()) {
            for (RfNamedElement rfNamedElement : entities) {
                List<RfConfiguration> configurations;
                Set<String> configNames = rfNamedElement.getConfigNames();
                if (configNames == null || configNames.isEmpty() || (configurations = rfNamedElement.getLocalMembers(RfConfiguration.class)) == null || configurations.isEmpty()) continue;
                result.addAll(configurations);
            }
        }
        return result;
    }

    @Override
    public boolean isBefore(RfNamedElement usageElement) {
        return true;
    }

    @Override
    public boolean isBefore(int useIndex, int useLine, int useOffset) {
        return true;
    }

    public boolean isNonTopFilesLibrary() {
        return "non-top-files".equals(this.getName());
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        RfProject rfProject;
        Collection<? extends IRfNamedElement> members = super.xGetLocalMembers();
        ArrayList<Object> result = new ArrayList<Object>(members == null ? 0 : members.size());
        if (members != null) {
            result.addAll(members);
        }
        if ((rfProject = this.getRfProject()) == null) {
            return result;
        }
        String thisLibraryName = this.getCustomName();
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        if (mixedLangProject != null && mixedLangProject.isMixed()) {
            List<IRfPackageElement> otherLangPackages = rfProject.getOtherLangPackagesWithPrefix("", 2);
            if (otherLangPackages == null || otherLangPackages.isEmpty()) {
                return result;
            }
            for (IRfPackageElement otherLangPackage : otherLangPackages) {
                IRfLibraryElement enclosingLibrary = otherLangPackage.getEnclosingLibrary();
                if (enclosingLibrary == null || !thisLibraryName.equals(enclosingLibrary.getCustomName())) continue;
                result.add(otherLangPackage);
            }
        }
        return result;
    }

    public List<? extends IRfPackageElement> getLocalPackages() {
        return this.getLocalMembers(RfPackage.class);
    }

    class SemanticWorker
    implements Runnable {
        private ConfigInfo configInfo;
        private IRfPackageElement rfPackageElement;
        private boolean triggerError;
        private boolean onlyPredefined;
        private boolean disableExprEvaluate;

        public SemanticWorker(ConfigInfo configInfo, boolean triggerError, boolean resolvePredefined, boolean disableExprEvaluate, IRfPackageElement packageElement) {
            this.configInfo = configInfo;
            this.rfPackageElement = packageElement;
            this.onlyPredefined = resolvePredefined;
            this.triggerError = triggerError;
            this.disableExprEvaluate = disableExprEvaluate;
        }

        @Override
        public void run() {
            try {
                if (this.rfPackageElement instanceof RfNamedElement) {
                    RfPackage rfPackage;
                    if (this.rfPackageElement instanceof RfPackageBody && (rfPackage = ((RfPackageBody)this.rfPackageElement).getPackage()) != null) {
                        rfPackage.resolveHids(this.configInfo, this.triggerError, this.disableExprEvaluate, null);
                    }
                    ((RfNamedElement)this.rfPackageElement).resolveHids(this.configInfo, this.triggerError, this.disableExprEvaluate, null);
                } else {
                    RfLibrary.this.resolveHidsSuper(this.configInfo, this.triggerError, this.disableExprEvaluate, null);
                }
            }
            catch (BuildCancelException buildCancelException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

