/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTMixedLangBuildListener;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.vhdldt.model.IVhdlBuildListener;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.model.VhdlFileInfo;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.VhdlModule;
import ro.amiq.vhdldt.model.persistence.Persistence;
import ro.amiq.vhdldt.model.reflection.RfProject;

public class RfManager
implements IVhdlBuildListener,
IDVTMixedLangBuildListener {
    private static volatile RfManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RfManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new RfManager();
            }
        }
        return fInstance;
    }

    public final RfProject getRfProject(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vhdldt.VhdlNature", true);
    }

    public final RfProject getRfProjectWithoutRestore(IProject project) {
        return (RfProject)RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vhdldt.VhdlNature", false);
    }

    public final void fullBuild(DVTFileInfo dvtFileInfo) {
    }

    public final void incrementalBuild(DVTFileInfo dvtFileInfo) {
        VhdlFileInfo info = VhdlModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.incrementalBuild(info);
        DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_NAME_CHECKING.getId()).scheduleObjectionsClear(project);
    }

    public final void postIncrementalBuild(DVTFileInfo dvtFileInfo) {
        VhdlFileInfo info = VhdlModelManager.getInstance().getModuleInfo(dvtFileInfo);
        IProject project = info.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postIncrementalBuild(info);
    }

    public final void clean(IDVTProject iDVTProject) {
        this.clean(iDVTProject, true);
    }

    public final void clean(IDVTProject iDVTProject, boolean compilePredef) {
        IVhdlProject vhdlProject = VhdlModelManager.getInstance().getIVhdlProject(iDVTProject);
        if (vhdlProject == null) {
            return;
        }
        IProject project = vhdlProject.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProjectWithoutRestore(vhdlProject.getProject());
        if (rfProject == null) {
            return;
        }
        rfProject.clean(compilePredef);
        this.getPersistence(project).setDirty();
        try {
            if (MemUtils.COLLECT_STATS) {
                MemUtils.forceGC();
            }
        }
        catch (Exception exception) {}
    }

    public Persistence getPersistence(IProject project) {
        return (Persistence)RfMixedLangManager.getInstance().getPersistence(project, "ro.amiq.vhdldt.VhdlNature");
    }

    public final void remove(IDVTFile iDVTFile) {
        IVhdlModule eModule = VhdlModelManager.getInstance().getIVhdlModule(iDVTFile);
        IProject project = eModule.getFile().getProject();
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.getPersistence(project).setDirty();
        rfProject.remove(eModule);
        BuildEventManager.getInstance().notifyIncrementalBuild(project, null, null);
    }

    public final void postFullBuild(IDVTProject dvtProject, boolean success) {
        IVhdlProject VhdlProject2 = VhdlModelManager.getInstance().getIVhdlProject(dvtProject);
        IProject project = dvtProject.getProject();
        if (!success) {
            this.clean(VhdlProject2, true);
        } else {
            if (project == null) {
                return;
            }
            RfProject rfProject = this.getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.postFullBuild(true);
        }
    }

    public final void activeTestChangedNotification(IProject project) {
        if (project != null) {
            RfProject rfProject = this.getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.activeTestChangedNotification();
            BuildEventManager.getInstance().notifyIncrementalBuild(project, null, ViewsUtils.ALL_VIEWS);
        }
    }

    public final void clean(IDVTFile dvtFile) {
        VhdlModule vhdlFile = (VhdlModule)VhdlModelManager.getInstance().getIVhdlModule(dvtFile);
        if (vhdlFile == null || vhdlFile.getResource() == null) {
            return;
        }
        IProject project = vhdlFile.getResource().getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.getPersistence(project).setDirty();
        rfProject.cleanIncremental(vhdlFile.getParserPath());
    }

    public void postMixedLangFullBuildPreElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuildPreElab(BuildConfigManager.getFullCompileChecks((IProject)project), true);
    }

    public void postMixedLangFullBuildPostElab(IProject project) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangFullBuildPostElab(BuildConfigManager.getFullCompileChecks((IProject)project), true);
    }

    public final void postMixedLangIncrementalBuildPreElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuildPreElab(changedFiles.get(LanguageKind.VHDL), updateViewIds);
    }

    public final void postMixedLangIncrementalBuildPostElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postMixedLangIncrementalBuildPostElab(changedFiles.get(LanguageKind.VHDL), updateViewIds);
    }

    public final void performExtendedChecks(IProject project, ChecksKindWrapper checksKindWrapper) {
    }

    public void postBuildConfigIncrementalBuild(IProject project) {
    }

    public void postIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        RfProject rfProject = this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        rfProject.postIncrementalBuild(changedFiles.get(LanguageKind.VHDL));
    }

    public void postUpfIncrementalBuild(IProject project) {
    }
}

