/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IMembersProvider;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfHDLNamedElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.HidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.HidOperatorVisitorWithPaths;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTArrayList;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.InsensitiveLinkedMap;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor2;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAnyListType;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAttribute;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfImplicitDef;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfPropertySequence;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.RfVariableDef;
import ro.amiq.vhdldt.model.reflection.semantic.RfSemanticError;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;

public abstract class RfNamedElement
implements IHidHolder,
IRfScope,
IDVTMapElement<String>,
IRfNamedElement,
IRfHDLNamedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ANONYMOUS_NAME = "[anonymous]";
    private static final Set<Class<? extends IRfNamedElement>> MEMBERS_OTHERS_WITH_FUNCTIONS;
    private String fName;
    private String fLowerCaseName;
    private transient ListContainer<RfDefElement> fDefs;
    private transient RfNamedElement fEnclosingScope;
    private transient IRfNamedElement fCachedBaseType;
    private InsensitiveLinkedMap<RfNamedElement> fMembers;
    protected transient Map<String, IRfNamedElement> fTransientResolvedGenericMap;
    protected List<ImportInfo> fWildcardUses;
    protected List<ImportInfo> fExplicitUses;
    protected List<ImportInfo> fLibraryClauses;
    private transient RfHidHolder fHidHolder;
    private transient Map<String, List<RfEnum>> fEnumValuesMap;
    protected transient Map<String, RfType> fTransientUsedRecordTypes;
    protected transient Set<String> fReferencedIdentifierNames;
    private Set<String> fConfigNames;
    private transient List<RfNamedElement> fCachedParameters;
    private transient List<RfNamedElement> fCachedPortListParameters;
    private transient List<RfNamedElement> fCachedConstants;
    private transient List<RfVariable> fCachedArguments;
    private transient List<RfVariable> fCachedRecordElements;
    private VhdlCompileInfo compileInfo;
    private static final EnumSet<HidFlatteningOption> GENERIC_CONNECTION_HID_FLATTENING;
    private static final Comparator<ImportInfo> USE_COMPARATOR;
    private RfProject fRfProject;

    static {
        DVTRfUtils.MEMBERS_DESIGN.add(RfEntity.class);
        DVTRfUtils.MEMBERS_DESIGN.add(RfComponent.class);
        DVTRfUtils.MEMBERS_METHOD.add(RfFunction.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfPackage.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfRecordType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfListType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfAnyListType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfScalarType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfEntity.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfComponent.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfConfiguration.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfAlias.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfPackage.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfType.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfRecordType.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfListType.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfAnyListType.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfScalarType.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfEntity.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfComponent.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfConfiguration.class);
        DVTRfUtils.MEMBERS_TYPES_NO_TYPE_PARAM.add(RfAlias.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfVariable.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfAttribute.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPort.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfLibrary.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPackage.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfType.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfRecordType.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfScalarType.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfListType.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfAnyListType.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfEntity.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfComponent.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfConfiguration.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfArchitecture.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfAlias.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfProcess.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfInstance.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfBlock.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfEnum.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPropertySequence.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfVUnit.class);
        DVTRfUtils.MEMBERS_CONFIG.add(RfConfiguration.class);
        MEMBERS_OTHERS_WITH_FUNCTIONS = new HashSet<Class<? extends IRfNamedElement>>(DVTRfUtils.MEMBERS_OTHERS);
        MEMBERS_OTHERS_WITH_FUNCTIONS.add(RfFunction.class);
        MEMBERS_OTHERS_WITH_FUNCTIONS.add(RfFunctionsHolder.class);
        RfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES.addAll(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        RfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES.add(RfComponent.class);
        GENERIC_CONNECTION_HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS, HidFlatteningOption.IGNORE_CONCAT_AND_ASSIGN_PATTERNS);
        USE_COMPARATOR = new Comparator<ImportInfo>(){

            @Override
            public int compare(ImportInfo o1, ImportInfo o2) {
                IRfNamedElement o1Element = o1.getElement();
                IRfNamedElement o2Element = o2.getElement();
                if (o1Element == null || o2Element == null) {
                    return 0;
                }
                if (o1Element.isPredefined()) {
                    return o2Element.isPredefined() ? 0 : 1;
                }
                if (o2Element.isPredefined()) {
                    return o1Element.isPredefined() ? 0 : -1;
                }
                return 0;
            }
        };
    }

    public RfNamedElement(String name) {
        this.fName = DVTStringUtil.intern((String)name);
        this.fLowerCaseName = name != null ? DVTStringUtil.intern((String)name.toLowerCase()) : null;
    }

    public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        return false;
    }

    public IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.HOLDER;
    }

    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        Object searchHolder;
        HidVisitor visitor = new HidVisitor(qualifiers);
        Object object = searchHolder = local ? this.getHidHolder() : this;
        if (searchHolder == null) {
            return null;
        }
        searchHolder.visitHidObject(null, (IHidVisitor)visitor);
        return visitor.getObjects();
    }

    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return this.getHidOperators(qualifiers, null, local);
    }

    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, Set<ParserPath> changedFiles, boolean local) {
        Object searchHolder;
        Object object = searchHolder = local ? this.getHidHolder() : this;
        if (searchHolder == null) {
            return null;
        }
        HidOperatorVisitor visitor = new HidOperatorVisitor(qualifiers, changedFiles);
        searchHolder.visitHidObject(null, (IHidVisitor)visitor);
        return visitor.getObjects();
    }

    public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        return this.fHidHolder.addOperator(operatorRequest);
    }

    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        return this.fHidHolder.addIdentifier(hidRequest, access);
    }

    public boolean removeIdentifier(String name) {
        if (this.fHidHolder != null) {
            return this.fHidHolder.removeIdentifier(name);
        }
        return false;
    }

    public IRfLibraryElement getLibraryAndWork(String name) {
        if ("work".equalsIgnoreCase(name)) {
            return this.getEnclosingLibrary();
        }
        return this.getLibraryWithPrefix(name, 9);
    }

    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
        rfProject.checkBuildCanceled();
        try {
            configInfo = new ConfigInfo(configInfo);
            configInfo.closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
            if (this.hasHidObjects()) {
                RfHidHolder hidHolder = this.getHidHolder();
                hidHolder.resolveHids(configInfo, this, triggerError);
            }
            if (this instanceof RfInstance || this instanceof RfConfigurationRule) {
                this.resolvePortAndGenericMaps(configInfo, disableExprEvaluate, triggerError);
            } else if (!disableExprEvaluate) {
                SEvaluator.INSTANCE.calculate(configInfo, triggerError, (IHidHolder)this.getHidHolder());
            }
            Collection<RfNamedElement> members = this.getMembers();
            if (members != null) {
                for (RfNamedElement member : members) {
                    rfProject.checkBuildCanceled();
                    if (member == null || skipMemberClasses != null && skipMemberClasses.contains(member.getClass()) || (member instanceof RfPackage || member instanceof RfPackageBody) && member.getEnclosingScope() instanceof RfLibrary || configInfo.incremental && member instanceof RfArchitecture) continue;
                    member.resolveHids(configInfo, triggerError, disableExprEvaluate, skipMemberClasses);
                }
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void resolvePortAndGenericMaps(ConfigInfo configInfo, boolean disableExprEvaluate, boolean triggerError) {
    }

    protected void resolveLocalHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate) throws BuildCancelException {
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
        rfProject.checkBuildCanceled();
        try {
            configInfo = new ConfigInfo(configInfo);
            configInfo.closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
            if (this.hasHidObjects()) {
                RfHidHolder hidHolder = this.getHidHolder();
                hidHolder.resolveHids(configInfo, this, triggerError);
            }
            if (!disableExprEvaluate) {
                SEvaluator.INSTANCE.calculate(configInfo, triggerError, (IHidHolder)this.getHidHolder());
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IHidBuilders getHidBuilders() {
        return STransformer.BUILDERS;
    }

    protected void checkUnused(RfProject rfProject, boolean incremental, boolean triggerError, Set<ParserPath> changedFiles) throws BuildCancelException {
        rfProject.checkBuildCanceled();
    }

    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            RfHidHolder hidHolder;
            visitor.setScope((IRfNamedElement)this);
            if (this.hasHidObjects() && !(hidHolder = this.getHidHolder()).visitHidObject(rfProject, visitor)) {
                return false;
            }
            try {
                Collection<RfNamedElement> members = this.getMembers();
                if (members != null) {
                    for (RfNamedElement member : members) {
                        member.visitHidObject(rfProject, visitor);
                    }
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            visitor.endScope((IRfNamedElement)this);
        }
        return true;
    }

    public boolean isHidObjectsEmpty() {
        return true;
    }

    public void updateHolder(IHidHolder updater) {
        if (updater == null) {
            return;
        }
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        this.fHidHolder.updateHolder(updater);
    }

    public void addIdentifiers(IHidHolder updater) {
        if (updater == null) {
            return;
        }
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        this.fHidHolder.addIdentifiers(updater);
    }

    public void addOperators(IHidHolder updater) {
        if (updater == null) {
            return;
        }
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        this.fHidHolder.addOperators(updater);
    }

    public boolean isEscaped() {
        return this.fName != null && '\\' == this.fName.charAt(0);
    }

    public String printScope() {
        RfNamedElement scope = this;
        String result = "";
        while (scope != null && (scope = scope.getEnclosingScope()) != null && !(scope instanceof RfLibrary) && !(scope instanceof RfProject)) {
            String scopeName = scope.getName();
            if (scope.isAnonymous() || scope instanceof RfActionBlock || scope instanceof RfFunctionsHolder) continue;
            result = DVTStringUtil.appendString((Object[])new Object[]{scopeName, ".", result});
        }
        return result;
    }

    @Override
    public RfDefElement getDefElement() {
        return this.getDeclaration();
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this;
    }

    public RfNamedElement getEnclosingScope() {
        return this.fEnclosingScope;
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfNamedElement scope = this;
        do {
            if (scope.getClass() != clazz) continue;
            return (T)scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public IRfNamedElement getEnclosingScope(Set<?> classes) {
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        RfNamedElement scope = this;
        do {
            if (!classes.contains(scope.getClass())) continue;
            return scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public void setEnclosingScope(IRfNamedElement enclosingScope, boolean isRestore) {
        this.fEnclosingScope = (RfNamedElement)enclosingScope;
    }

    public RfLibrary getEnclosingLibrary() {
        RfNamedElement scope = this;
        do {
            if (!(scope instanceof RfLibrary)) continue;
            return (RfLibrary)scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public String getEnclosingPackageName() {
        RfNamedElement scope = this;
        do {
            if (!(scope instanceof RfPackage) && !(scope instanceof RfPackageBody)) continue;
            return scope.getName();
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public LibraryPackageScope getLibPkgScope() {
        String packageName = null;
        String libraryName = null;
        IRfNamedElement closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        RfElementPath closestTypeContainerPath = RfElementPath.path((IRfNamedElement)closestTypeContainer);
        RfNamedElement scope = this;
        do {
            if (packageName == null && scope.getClass() == RfPackage.class) {
                packageName = scope.getName();
            }
            if (scope.getClass() != RfLibrary.class) continue;
            libraryName = ((RfLibrary)scope).getCustomName();
            return new LibraryPackageScope(libraryName, packageName, closestTypeContainerPath);
        } while ((scope = scope.getEnclosingScope()) != null);
        return new LibraryPackageScope("work", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
    }

    public RfFileDef getFile() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getDefFile();
        }
        return null;
    }

    public boolean isDirtyElement() {
        return this.fDefs == null || this.fDefs.isEmpty();
    }

    public void setImportsDirty(ParserPath parserPath) {
        if (this.fWildcardUses != null) {
            for (ImportInfo importItem : this.fWildcardUses) {
                if (!parserPath.equals((Object)importItem.getParserPath())) continue;
                importItem.setDirty(true);
            }
        }
        if (this.fExplicitUses != null) {
            for (ImportInfo importItem : this.fExplicitUses) {
                if (!parserPath.equals((Object)importItem.getParserPath())) continue;
                importItem.setDirty(true);
            }
        }
        if (this.fLibraryClauses != null) {
            for (ImportInfo importItem : this.fLibraryClauses) {
                if (!parserPath.equals((Object)importItem.getParserPath())) continue;
                importItem.setDirty(true);
            }
        }
    }

    public Collection<RfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        if (this.fMembers == null) {
            return null;
        }
        if (!unpackDuplicates) {
            return this.fMembers.values();
        }
        ArrayList<RfNamedElement> unpacked = new ArrayList<RfNamedElement>(this.fMembers.size());
        for (RfNamedElement member : this.fMembers.values()) {
            if (member instanceof RfDuplicate) {
                Collection<RfNamedElement> members = ((RfDuplicate)member).getMembers(rawMembers, true);
                if (members == null) continue;
                unpacked.addAll(members);
                continue;
            }
            unpacked.add(member);
        }
        return unpacked;
    }

    public Collection<RfNamedElement> getMembers() {
        return this.getMembers(false, false);
    }

    public boolean hasLocalMembers() {
        return this.fMembers != null && !this.fMembers.isEmpty();
    }

    protected void removeDirtyElements(ParserPath parserPath, RfProject project) {
        Collection<RfNamedElement> members = this.getMembers();
        if (members != null) {
            this.removeDirtyElements(members.iterator(), parserPath, project);
        }
        boolean hasDirtyImports = false;
        if (this.fWildcardUses != null) {
            hasDirtyImports = this.removeDirtyImports(project, this.fWildcardUses.iterator());
        }
        if (this.fExplicitUses != null) {
            hasDirtyImports |= this.removeDirtyImports(project, this.fExplicitUses.iterator());
        }
        if (this.fLibraryClauses != null) {
            hasDirtyImports |= this.removeDirtyImports(project, this.fLibraryClauses.iterator());
        }
        if (hasDirtyImports) {
            this.clearAssociatedTypes();
        }
    }

    protected boolean removeDirtyImports(RfProject rfProject, Iterator<? extends ImportInfo> it) {
        boolean hasDirtyImports = false;
        while (it.hasNext()) {
            ImportInfo elem = it.next();
            if (!elem.isDirty()) continue;
            it.remove();
            rfProject.setIncrementalChangedImports(true, elem.getExplicitName(), this);
            hasDirtyImports = true;
        }
        return hasDirtyImports;
    }

    protected void clearAssociatedTypes() {
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfNamedElement member : members) {
            if (!(member instanceof RfVariable) && !(member instanceof RfFunctionsHolder)) continue;
            member.clearAssociatedTypes();
        }
        this.fTransientResolvedGenericMap = null;
        this.fCachedBaseType = null;
    }

    protected void removeDirtyElements(Iterator<? extends RfNamedElement> it, ParserPath parserPath, RfProject project) {
        while (it.hasNext()) {
            RfNamedElement element = it.next();
            if (element.isPredefined()) continue;
            if (element instanceof RfLibrary) {
                element.removeDirtyElements(parserPath, project);
                continue;
            }
            if (element instanceof RfDuplicate) {
                element.removeDirtyElements(parserPath, project);
                Collection<RfNamedElement> members = element.getMembers();
                if (members != null && !members.isEmpty()) continue;
                it.remove();
                continue;
            }
            if (element.isDirtyElement()) {
                if (this.getConfigNames() != null && element instanceof RfConfiguration) {
                    Set<String> configNames = this.getConfigNames();
                    boolean remove = true;
                    if (this instanceof RfDuplicate) {
                        for (RfNamedElement member : this.getMembers()) {
                            if (member == element || !(member instanceof RfConfiguration)) continue;
                            remove = false;
                        }
                    }
                    if (remove) {
                        Set<String> libraryConfigNames;
                        configNames.remove(element.getKey());
                        RfLibrary enclosingLibrary = this.getEnclosingLibrary();
                        Set<String> set = libraryConfigNames = enclosingLibrary != null ? enclosingLibrary.getConfigNames() : null;
                        if (libraryConfigNames != null && !libraryConfigNames.isEmpty()) {
                            libraryConfigNames.remove(element.getKey());
                        }
                    }
                    it.remove();
                    continue;
                }
                if (element instanceof RfEntity) {
                    RfDefElement declaration = element.getArchitectureOrConfigurationDeclaration();
                    if (declaration == null) {
                        it.remove();
                        continue;
                    }
                    element.addDeclaration(new RfImplicitDef(declaration.getDefFile(), this.getName(), declaration.getStartInfo()));
                    element.removeDirtyElements(parserPath, project);
                    continue;
                }
                it.remove();
                continue;
            }
            element.removeDirtyElements(parserPath, project);
        }
    }

    protected RfDefElement getArchitectureOrConfigurationDeclaration() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public String getLowerCaseName() {
        return this.fLowerCaseName;
    }

    public String getQualifiedName(IRfScopeElement initialScope, ElementPath hierarchyPath, int options) {
        return this.fName;
    }

    public String getNameForDiagram() {
        String qn = this.getQualifiedName();
        return qn != null ? qn.toLowerCase() : null;
    }

    public String getKey() {
        return this.isEscaped() ? this.fName : this.fLowerCaseName;
    }

    protected int internalMaxDefSizePerElement() {
        return 4;
    }

    public RfDefElement addDeclaration(RfDefElement element) {
        element.addNamedElement(this);
        if (this.fDefs != null && this.fDefs.size() == 1 && this.fDefs.get(0) instanceof RfImplicitDef) {
            this.fDefs = OptimizedUtils.listContainerAdd(null, (Object)element);
            return element;
        }
        if (this.fDefs == null || this.fDefs.size() < this.internalMaxDefSizePerElement()) {
            this.fDefs = OptimizedUtils.listContainerAdd(this.fDefs, (Object)element);
            return element;
        }
        return (RfDefElement)this.fDefs.get(0);
    }

    public RfDefElement getDeclaration() {
        if (this.getAllDefsSize() == 0) {
            return null;
        }
        return (RfDefElement)this.fDefs.get(0);
    }

    public Collection<? extends RfDefElement> getDeclarations() {
        if (this.fDefs == null) {
            return Collections.emptyList();
        }
        return OptimizedUtils.asList(this.fDefs, (boolean)false);
    }

    public int getAllDefsSize() {
        if (this.fDefs == null) {
            return 0;
        }
        return this.fDefs.size();
    }

    public boolean hasNoDefs(boolean rawDefs) {
        int defsSize = this.getAllDefsSize();
        return defsSize == 0 || defsSize == 1 && this.fDefs.get(0) instanceof RfImplicitDef;
    }

    public IResource getFileAdapter() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getFileAdapter();
        }
        return null;
    }

    public Map<String, IRfNamedElement> getLocalResolvedGenericMap(boolean resolveIfNotCached) {
        List<IHidOperator> genericMap = this.getHidOperators(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY, false);
        if (genericMap == null || genericMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, IRfNamedElement> result = new HashMap<String, IRfNamedElement>();
        for (IHidOperator generic : genericMap) {
            Set portHids;
            IRfNamedElement assocType;
            List associatedTypeName;
            IHidObject hid;
            Set signalHids = HidUtils.flattenToHids((List)OptimizedUtils.asList((ListContainer)generic.getRHValues(), (boolean)false), GENERIC_CONNECTION_HID_FLATTENING);
            if (signalHids.size() != 1 || (hid = (IHidObject)signalHids.iterator().next()).getHidKind() != IHidObject.HidKind.HID || (associatedTypeName = ((Hid)hid).getHidNameAsStringList()) == null || (assocType = this.internalComputeAssociatedType(new DataType(associatedTypeName), IRfAssociatedType.AssocTypeKind.ASSOC_TYPE, true)) == null || (portHids = HidUtils.flattenToHids((IHidObject)generic.getLHValue(), GENERIC_CONNECTION_HID_FLATTENING)).size() != 1 || !HidUtils.isHid((IHidObject)(hid = (IHidObject)portHids.iterator().next()))) continue;
            result.put(HidUtils.toString((IHidObject)hid, (boolean)false, (boolean)false), assocType);
        }
        return result;
    }

    protected IRfNamedElement internalComputeAssociatedType(DataType associatedDataType, IRfAssociatedType.AssocTypeKind associatedTypeKind, boolean returnDummyInfoType) {
        return RfNamedElement.internalComputeAssociatedType(associatedDataType, associatedTypeKind, this.getEnclosingScope(), this, this.getRfProject());
    }

    protected static IRfNamedElement internalComputeAssociatedType(DataType associatedDataType, IRfAssociatedType.AssocTypeKind associatedTypeKind, RfNamedElement searchScope, RfNamedElement thisScope, RfProject rfProject) {
        List<DataTypeChunk> associatedTypeName;
        RfNamedElement scope;
        block42: {
            if (associatedDataType == null) {
                return null;
            }
            scope = searchScope;
            if (scope instanceof RfEntity && ((RfEntity)scope).isImplicit()) {
                scope = thisScope;
            }
            if ((associatedTypeName = associatedDataType.getTypeName()) != null && !associatedTypeName.isEmpty()) break block42;
            return null;
        }
        try {
            List<IHidObject> architectureConstraints;
            Object candidate;
            String candidateName;
            int typeLength = associatedTypeName.size();
            RfAssociatedType.RfUnresolvedInfo unresolvedTypeInfo = null;
            HashSet<Class<? extends IRfNamedElement>> classes = new HashSet<Class<? extends IRfNamedElement>>(DVTRfUtils.MEMBERS_TYPES);
            if (associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN) {
                if (associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_COMPONENT) {
                    classes.remove(RfComponent.class);
                }
                if (associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY) {
                    classes.remove(RfEntity.class);
                }
                if (associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_CONFIGURATION) {
                    classes.remove(RfConfiguration.class);
                }
                if (associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_TYPE) {
                    classes.remove(RfType.class);
                }
            }
            boolean hasSubtypeAttribute = typeLength >= 2 && "'subtype".equalsIgnoreCase(associatedTypeName.get((int)(typeLength - 1)).name);
            int i = 0;
            while (scope != null && i < typeLength) {
                int unresolvedOffset;
                candidateName = associatedTypeName.get((int)i).name;
                candidate = null;
                if (i == 0 && typeLength > 1 && (candidate = searchScope.getLibraryAndWork(candidateName)) == null) {
                    candidate = rfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)rfProject, candidateName, 9);
                }
                if (candidate == null) {
                    candidate = scope.getMember(candidateName, hasSubtypeAttribute ? MEMBERS_OTHERS_WITH_FUNCTIONS : classes, null, i == 0, i == typeLength - 1, false, true, false);
                }
                if (hasSubtypeAttribute) {
                    if (candidate instanceof RfFunctionsHolder && !((RfFunctionsHolder)candidate).hasMultipleFunctions()) {
                        candidate = ((RfFunctionsHolder)candidate).getLastDefinedFunction();
                    }
                    if (candidate instanceof RfType || candidate instanceof RfAlias && ((RfAlias)candidate).getTranslatedType() instanceof RfType) {
                        candidate = null;
                    } else if (candidate instanceof RfAssociatedType) {
                        Object resolvedType;
                        List selectsAndArgs = associatedTypeName.get(i).getSelectsAndArgs();
                        Object object = resolvedType = candidate instanceof IRfFieldElement || candidate instanceof RfFunction ? ((IRfAssociatedTypeElement)candidate).getResolvedType(true) : candidate;
                        if (resolvedType instanceof IRfTypeAliasElement) {
                            resolvedType = ((IRfTypeAliasElement)resolvedType).getTranslatedType();
                        }
                        if (selectsAndArgs != null) {
                            int startIndex;
                            List<RfVariable> functArgs = candidate instanceof RfFunction ? ((RfFunction)candidate).getArguments() : null;
                            int index = startIndex = functArgs != null && !functArgs.isEmpty() ? 1 : 0;
                            while (index < selectsAndArgs.size()) {
                                IHidObject hidObject = (IHidObject)selectsAndArgs.get(index);
                                List expandedSelect = HidUtils.flattenSelect((IHidObject)hidObject);
                                int nOfDimensions = expandedSelect.get(0) == null ? 0 : expandedSelect.size();
                                while (resolvedType instanceof RfListType && nOfDimensions > 0) {
                                    if ((resolvedType = ((RfListType)resolvedType).getResolvedType(true)) instanceof IRfTypeAliasElement) {
                                        resolvedType = ((IRfTypeAliasElement)resolvedType).getTranslatedType();
                                    }
                                    --nOfDimensions;
                                }
                                ++index;
                            }
                        }
                        candidate = resolvedType;
                    }
                }
                if (candidate instanceof RfNamedElement && ((RfNamedElement)candidate).isImplicit()) {
                    candidate = null;
                }
                if (candidate instanceof RfFunctionsHolder) {
                    candidate = ((RfFunctionsHolder)candidate).getEnclosingScope().getFunctionWithPrefix(candidateName, 9, true);
                }
                if (candidate == null && (associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY || associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN)) {
                    candidate = rfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)rfProject, candidateName, 9);
                }
                if (candidate == null && (associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_CONFIGURATION || associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN) && (candidate = scope.getDesignWithPrefix(candidateName, 1)) == null) {
                    candidate = scope.getConfigurationWithPrefix(candidateName, 1);
                }
                if (candidate instanceof RfAlias && ((RfAlias)candidate).isPackageInstatiation() && i < typeLength - 1) {
                    candidate = ((RfAlias)candidate).getTranslatedType();
                }
                if (candidate == null && (unresolvedOffset = associatedTypeName.get((int)i).offset) >= 0) {
                    unresolvedTypeInfo = new RfAssociatedType.RfUnresolvedInfo(candidateName, i, unresolvedOffset, scope);
                }
                if (hasSubtypeAttribute && i == typeLength - 2) {
                    if (candidate instanceof RfAssociatedType) {
                        IRfNamedElement resolvedType = ((RfAssociatedType)candidate).getResolvedType(true);
                        return resolvedType instanceof RfAssociatedType.RfUnresolvedInfo ? null : resolvedType;
                    }
                    return candidate instanceof RfAssociatedType.RfUnresolvedInfo ? null : candidate;
                }
                scope = candidate;
                ++i;
            }
            if (scope instanceof RfEntity && (architectureConstraints = associatedDataType.getElementConstraintHidObjects()) != null && architectureConstraints.size() == 1) {
                Hid architectureHid;
                IHidObject architectureHidObject = architectureConstraints.get(0);
                Hid hid = architectureHid = HidUtils.isHid((IHidObject)architectureHidObject) ? (Hid)architectureHidObject : null;
                if (architectureHid != null) {
                    architectureHid.addQualifier(HidQualifierCache.FORMAL_PART_QUALIFIER);
                    if (architectureHid.getName() != null) {
                        String archName = architectureHid.getName();
                        IRfNamedElement candidate2 = scope.getMember(archName, Collections.singleton(RfArchitecture.class), null, true, true, false, true, false);
                        if (candidate2 == null) {
                            return new RfAssociatedType.RfUnresolvedInfo(archName, -5, architectureHid.getOccurrence().getOffset(), scope);
                        }
                        architectureHid.setElement(candidate2);
                        return candidate2;
                    }
                }
            }
            if (scope != null) {
                return scope;
            }
            scope = searchScope;
            i = 0;
            while (scope != null && i < typeLength) {
                candidateName = associatedTypeName.get((int)i).name;
                candidate = null;
                if (i == 0 && typeLength > 1) {
                    candidate = rfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)rfProject, candidateName, 9);
                }
                if (i == 1 && candidate == null && typeLength > 2) {
                    candidate = scope.getPackageWithPrefix(candidateName, 9);
                }
                if (candidate == null && (associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_ENTITY || associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_CONFIGURATION || associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN || associatedTypeKind == IRfAssociatedType.AssocTypeKind.ASSOC_TYPE)) {
                    candidate = i == 0 ? thisScope.getOtherLangMemberWithPrefix(candidateName, 9) : scope.getTypeWithPrefix(candidateName, 9);
                    if (candidate == null && associatedTypeKind != IRfAssociatedType.AssocTypeKind.ASSOC_TYPE && (candidate = scope.getDesignWithPrefix(candidateName, 9)) == null) {
                        candidate = scope.getConfigurationWithPrefix(candidateName, 9);
                    }
                }
                scope = candidate;
                ++i;
            }
            if (scope == null && unresolvedTypeInfo != null) {
                return unresolvedTypeInfo;
            }
            return scope;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return this.getSignature();
    }

    protected void addMember(RfNamedElement element) {
        this.internalAddMember(element);
        element.setEnclosingScope(this, false);
    }

    protected void internalAddMember(RfNamedElement element) {
        RfNamedElement existing = null;
        String name = element.getKey();
        if (this.fMembers == null) {
            this.fMembers = new InsensitiveLinkedMap();
        } else {
            existing = (RfNamedElement)this.fMembers.get(name);
        }
        if (element instanceof RfConfiguration) {
            Set<String> configNames = this.getConfigNames();
            if (configNames == null) {
                configNames = new LinkedHashSet<String>();
            }
            configNames.add(name);
            this.setConfigNames(configNames);
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (enclosingLibrary != null) {
                configNames = enclosingLibrary.getConfigNames();
                if (configNames == null) {
                    configNames = new LinkedHashSet<String>();
                }
                configNames.add(name);
                enclosingLibrary.setConfigNames(configNames);
            }
        }
        if (existing instanceof RfDuplicate) {
            existing.addMember(element);
        } else if (this.internalCheckExisting(existing, element)) {
            RfDuplicate container = new RfDuplicate(name);
            container.setConfigNames(this.getConfigNames());
            container.setEnclosingScope(this, false);
            container.addMember(existing);
            container.addMember(element);
            this.fMembers.put((Object)name, (IDVTMapElement)container);
        } else {
            this.fMembers.put((Object)name, (IDVTMapElement)element);
        }
    }

    private boolean internalCheckExisting(RfNamedElement existing, RfNamedElement element) {
        return existing != null && existing.getKey().equals(element.getKey());
    }

    public void setConfigNames(Set<String> configNames) {
        this.fConfigNames = configNames;
    }

    public Set<String> getConfigNames() {
        return this.fConfigNames;
    }

    protected DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(boolean rawMembers) {
        return this.fMembers;
    }

    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        return this.getLocalMembers(false, clazz);
    }

    public <T extends IRfNamedElement> List<T> getLocalMembers(boolean hideDuplicates, Class<T> clazz) {
        if (this.fMembers == null) {
            return null;
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement member : this.fMembers.values()) {
            if (clazz == RfComponent.class && member instanceof RfEntity || clazz == RfVariable.class && member instanceof RfPort || clazz == RfVariable.class && member instanceof RfEnum) continue;
            if (clazz.isInstance(member)) {
                result.add(member);
                continue;
            }
            if (!(member instanceof RfDuplicate)) continue;
            ((RfDuplicate)member).getLocalMembers(hideDuplicates, result, clazz);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public RfEnum getLocalEnum(String name, String parentTypeName, boolean incremental) {
        if (this.fMembers == null) {
            return null;
        }
        RfNamedElement candidate = (RfNamedElement)this.fMembers.get(name);
        if (candidate instanceof RfEnum && (parentTypeName == null || parentTypeName.equalsIgnoreCase(((RfEnum)candidate).getParentEnumTypeName()))) {
            return (RfEnum)candidate;
        }
        if (candidate instanceof RfDuplicate) {
            if (parentTypeName == null) {
                if (incremental) {
                    return ((RfDuplicate)candidate).getFirstMember(RfEnum.class, true);
                }
                return ((RfDuplicate)candidate).getLastMember(RfEnum.class);
            }
            Collection<RfNamedElement> members = candidate.getMembers();
            for (RfNamedElement member : members) {
                if (!(member instanceof RfEnum) || parentTypeName != null && !parentTypeName.equalsIgnoreCase(((RfEnum)member).getParentEnumTypeName())) continue;
                return (RfEnum)member;
            }
        }
        return null;
    }

    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name) {
        return this.getLocalMember(clazz, name, false);
    }

    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name, boolean incremental) {
        if (this.fMembers == null) {
            return null;
        }
        if (clazz == RfEnum.class) {
            int index = name.indexOf(64);
            String parentTypeName = null;
            if (index > 0) {
                parentTypeName = name.substring(index + 1);
                name = name.substring(0, index);
            }
            return (T)this.getLocalEnum(name, parentTypeName, incremental);
        }
        RfNamedElement candidate = (RfNamedElement)this.fMembers.get(name);
        if (clazz == RfComponent.class && candidate instanceof RfEntity) {
            return null;
        }
        if (clazz == RfVariable.class && candidate instanceof RfPort) {
            return null;
        }
        if (clazz == RfVariable.class && candidate instanceof RfEnum) {
            return null;
        }
        if (candidate instanceof RfDuplicate) {
            if (clazz.isInstance(candidate)) {
                return (T)candidate;
            }
            if (clazz == RfPackage.class && "standard".equals(name)) {
                return ((RfDuplicate)candidate).getFirstMember(clazz, false);
            }
            if (incremental) {
                return ((RfDuplicate)candidate).getFirstMember(clazz, true);
            }
            return ((RfDuplicate)candidate).getLastMember(clazz);
        }
        if (candidate == null || !clazz.isInstance(candidate)) {
            return null;
        }
        return (T)candidate;
    }

    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        if (this.fMembers == null) {
            return null;
        }
        RfNamedElement candidate = (RfNamedElement)this.fMembers.get(name);
        if (candidate instanceof RfDuplicate) {
            return ((RfDuplicate)candidate).getLastMember(classes);
        }
        if (candidate != null && (classes == null || classes.contains(candidate.getClass()))) {
            return candidate;
        }
        return null;
    }

    public void swapElement(RfNamedElement element) {
        this.fMembers.swap((Object)element.getKey());
    }

    public void addWildcardUse(ImportInfo importInfo) {
        if (this.fWildcardUses == null) {
            this.fWildcardUses = new ArrayList<ImportInfo>(4);
        }
        this.fWildcardUses.add(importInfo);
    }

    public Set<IRfNamedElement> elabGetAllImportedPackages() {
        LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement instanceof IRfBlockElement && !(namedElement instanceof RfArchitecture)) {
                return false;
            }
            if (namedElement instanceof RfDuplicate) {
                return true;
            }
            NullProtectedList<ImportInfo> importDeclarations = namedElement.getAllImportDeclarations();
            if (importDeclarations == null || importDeclarations.isEmpty()) {
                return true;
            }
            for (ImportInfo importDeclaration : importDeclarations) {
                IRfNamedElement imported = importDeclaration.getImportedElement();
                if (imported == null) continue;
                result.add(imported);
            }
            return true;
        };
        this.accept(this.getRfProject(), visitor);
        return result;
    }

    public NullProtectedList<ImportInfo> getAllImportDeclarations() {
        List<ImportInfo> explicitImports;
        NullProtectedList<ImportInfo> importInfos = new NullProtectedList<ImportInfo>();
        List<ImportInfo> wildcardImports = this.getWildcardUse();
        if (wildcardImports != null && !wildcardImports.isEmpty()) {
            for (ImportInfo wildcardImportInfo : wildcardImports) {
                if (wildcardImportInfo == null || wildcardImportInfo.isDirty()) continue;
                importInfos.add(wildcardImportInfo);
            }
        }
        if ((explicitImports = this.getExplicitUse()) != null && !explicitImports.isEmpty()) {
            for (ImportInfo explicitImportInfo : explicitImports) {
                if (explicitImportInfo == null || explicitImportInfo.isDirty()) continue;
                importInfos.add(explicitImportInfo);
            }
        }
        return importInfos;
    }

    public List<ImportInfo> getWildcardUse() {
        return this.fWildcardUses;
    }

    public void addLibraryClause(ImportInfo importInfo) {
        if (this.fLibraryClauses == null) {
            this.fLibraryClauses = new ArrayList<ImportInfo>(4);
        }
        this.fLibraryClauses.add(importInfo);
    }

    public List<ImportInfo> getLibraryClause() {
        return this.fLibraryClauses;
    }

    public void addExplicitUse(ImportInfo importInfo) {
        if (this.fExplicitUses == null) {
            this.fExplicitUses = new ArrayList<ImportInfo>(4);
        }
        this.fExplicitUses.add(importInfo);
    }

    public List<ImportInfo> getExplicitUse() {
        return this.fExplicitUses;
    }

    protected List<RfPackage> getPackageUses() {
        IRfNamedElement usedElement;
        ArrayList<RfPackage> result = new ArrayList<RfPackage>(4);
        if (this.fWildcardUses != null) {
            for (ImportInfo use : this.fWildcardUses) {
                usedElement = use.getElement();
                if (!(usedElement instanceof RfPackage)) continue;
                result.add((RfPackage)usedElement);
            }
        }
        if (this.fExplicitUses != null) {
            for (ImportInfo use : this.fExplicitUses) {
                usedElement = use.getElement();
                if (usedElement instanceof RfNamedElement && usedElement.getEnclosingScope() instanceof RfPackage) {
                    result.add((RfPackage)usedElement.getEnclosingScope());
                    continue;
                }
                if (!(usedElement instanceof RfContext)) continue;
                result.addAll(((RfContext)usedElement).getPackageUses());
            }
        }
        return result;
    }

    public List<ImportInfo> getReferencesUses(IRfNamedElement namedElement) {
        IRfNamedElement usedElement;
        ArrayList<ImportInfo> infos = new ArrayList<ImportInfo>();
        if (namedElement == null) {
            return infos;
        }
        if (this.fWildcardUses != null) {
            for (ImportInfo use : this.fWildcardUses) {
                usedElement = use.getElement();
                if (namedElement.checkEquals((Object)usedElement)) {
                    infos.add(use);
                    continue;
                }
                if (namedElement.checkEquals((Object)usedElement.getEnclosingScope())) {
                    infos.add(use);
                    continue;
                }
                if (!namedElement.checkEquals((Object)usedElement.getEnclosingLibrary())) continue;
                infos.add(use);
            }
        }
        if (this.fExplicitUses != null) {
            for (ImportInfo use : this.fExplicitUses) {
                usedElement = use.getElement();
                if (namedElement.checkEquals((Object)usedElement)) {
                    infos.add(use);
                    continue;
                }
                if (namedElement.checkEquals((Object)usedElement.getEnclosingScope())) {
                    infos.add(use);
                    continue;
                }
                if (namedElement.checkEquals((Object)usedElement.getEnclosingLibrary())) {
                    infos.add(use);
                    continue;
                }
                if (!(usedElement instanceof RfContext)) continue;
                infos.addAll(((RfContext)usedElement).getReferencesUses(namedElement));
            }
        }
        if (this.fLibraryClauses != null) {
            for (ImportInfo libraryClause : this.fLibraryClauses) {
                IRfNamedElement element = libraryClause.getElement();
                if (!namedElement.checkEquals((Object)element)) continue;
                infos.add(libraryClause);
            }
        }
        return infos;
    }

    @Override
    public List<RfArchitecture> getArchitecturesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfArchitecture.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfArchitecture>((Collection<RfArchitecture>)resultMap.values());
    }

    @Override
    public RfArchitecture getArchitectureWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfArchitecture.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfArchitecture)resultMap.values().iterator().next();
    }

    @Override
    public RfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfConfiguration.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfConfiguration)resultMap.values().iterator().next();
    }

    @Override
    public List<RfConfiguration> getConfigurationsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfConfiguration.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfConfiguration>((Collection<RfConfiguration>)resultMap.values());
    }

    @Override
    public List<RfBlock> getBlocksWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfBlock.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfBlock>((Collection<RfBlock>)resultMap.values());
    }

    @Override
    public RfBlock getBlockWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfBlock.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfBlock)resultMap.values().iterator().next();
    }

    @Override
    public List<RfComponent> getComponentsWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfComponent.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfComponent>((Collection<RfComponent>)resultMap.values());
    }

    @Override
    public RfComponent getComponentWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfComponent.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfComponent)resultMap.values().iterator().next();
    }

    @Override
    public List<RfInstance> getInstancesWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfInstance.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfInstance>((Collection<RfInstance>)resultMap.values());
    }

    @Override
    public RfInstance getInstanceWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfInstance.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfInstance)resultMap.values().iterator().next();
    }

    @Override
    public List<RfProcess> getProcessesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfProcess.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfProcess>((Collection<RfProcess>)resultMap.values());
    }

    @Override
    public RfProcess getProcessWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfProcess.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfProcess)resultMap.values().iterator().next();
    }

    @Override
    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getLibrariesWithPrefix(prefix, matchType);
    }

    @Override
    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getLibraryWithPrefix(prefix, matchType);
    }

    @Override
    public List<RfEntity> getEntitiesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfEntity.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfEntity>((Collection<RfEntity>)resultMap.values());
    }

    @Override
    public RfEntity getEntityWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfEntity.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfEntity)resultMap.values().iterator().next();
    }

    @Override
    public List<RfFunction> getFunctionsWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashSet<RfFunction> result = new LinkedHashSet<RfFunction>();
        List<RfFunctionsHolder> holders = this.getFunctionHoldersWithPrefix(prefix, matchType, local);
        if (holders == null || holders.isEmpty()) {
            return Collections.emptyList();
        }
        for (RfFunctionsHolder holder : holders) {
            List<RfFunction> functions = holder.getLocalMembers(RfFunction.class);
            if (functions == null || functions.isEmpty()) continue;
            result.addAll(functions);
        }
        return new NullProtectedList<RfFunction>((Collection<RfFunction>)result);
    }

    @Override
    public RfFunction getFunctionWithPrefix(String prefix, int matchType, boolean local) {
        RfFunctionsHolder holder = this.getFunctionHolderWithPrefix(prefix, matchType, local);
        if (holder == null) {
            return null;
        }
        List<RfFunction> functions = holder.getLocalMembers(RfFunction.class);
        if (functions != null && !functions.isEmpty()) {
            return (RfFunction)functions.iterator().next();
        }
        return null;
    }

    @Override
    public List<RfFunctionsHolder> getFunctionHoldersWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfFunctionsHolder.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfFunctionsHolder>((Collection<RfFunctionsHolder>)resultMap.values());
    }

    @Override
    public RfFunctionsHolder getFunctionHolderWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfFunctionsHolder.class, prefix, null, false, matchType, local);
        return resultMap.isEmpty() ? null : (RfFunctionsHolder)resultMap.values().iterator().next();
    }

    @Override
    public List<RfContext> getContextsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfContext.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfContext>((Collection<RfContext>)resultMap.values());
    }

    @Override
    public RfContext getContextWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfContext.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfContext)resultMap.values().iterator().next();
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPackage.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfPackage>((Collection<RfPackage>)resultMap.values());
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPackage.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfPackage)resultMap.values().iterator().next();
    }

    @Override
    public List<RfPackageBody> getPackageBodiesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPackageBody.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfPackageBody>((Collection<RfPackageBody>)resultMap.values());
    }

    @Override
    public RfPackageBody getPackageBodyWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPackageBody.class, prefix, null, false, matchType, false);
        return resultMap.isEmpty() ? null : (RfPackageBody)resultMap.values().iterator().next();
    }

    @Override
    public List<RfTypeBody> getTypeBodiesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfTypeBody.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfTypeBody>((Collection<RfTypeBody>)resultMap.values());
    }

    @Override
    public RfTypeBody getTypeBodyWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfTypeBody.class, prefix, null, false, matchType, false);
        return resultMap.isEmpty() ? null : (RfTypeBody)resultMap.values().iterator().next();
    }

    @Override
    public List<RfPort> getPortsWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPort.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfPort>((Collection<RfPort>)resultMap.values());
    }

    @Override
    public RfPort getPortWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPort.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfPort)resultMap.values().iterator().next();
    }

    @Override
    public List<RfVariable> getVariablesWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfVariable.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfVariable>((Collection<RfVariable>)resultMap.values());
    }

    @Override
    public RfVariable getVariableWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfVariable.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfVariable)resultMap.values().iterator().next();
    }

    @Override
    public List<RfVUnit> getVUnitsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfVUnit.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfVUnit>((Collection<RfVUnit>)resultMap.values());
    }

    @Override
    public RfVUnit getVUnitWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfVUnit.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfVUnit)resultMap.values().iterator().next();
    }

    @Override
    public List<RfPropertySequence> getPropertiesSequencesWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPropertySequence.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfPropertySequence>((Collection<RfPropertySequence>)resultMap.values());
    }

    @Override
    public RfPropertySequence getPropertySequenceWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfPropertySequence.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfPropertySequence)resultMap.values().iterator().next();
    }

    public Collection<? extends IRfNamedElement> getAllSignals() {
        return this.getVariablesWithPrefix("", 2, false);
    }

    public Map<String, RfPort> mapAllPorts() {
        List<RfPort> ports = this.getLocalMembers(RfPort.class);
        if (ports == null || ports.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, RfPort> result = new LinkedHashMap<String, RfPort>(ports.size());
        for (RfPort port : ports) {
            result.put(port.getLowerCaseName(), port);
        }
        return result;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        RfVariable result = this.getVariableWithPrefix(prefix, matchType, false);
        if (result != null) {
            return result;
        }
        return this.getPortWithPrefix(prefix, matchType, true);
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        boolean equals;
        NullProtectedList<RfVariable> result = new NullProtectedList<RfVariable>();
        result.addAll(this.getVariablesWithPrefix(prefix, matchType, false));
        boolean bl = equals = (matchType & 1) != 0;
        if (!equals || result.isEmpty()) {
            result.addAll(this.getPortsWithPrefix(prefix, matchType, true));
        }
        return result;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return this.getInstanceWithPrefix(prefix, matchType, true);
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfEnum.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfEnum>((Collection<RfEnum>)resultMap.values());
    }

    @Override
    public RfEnum getEnumWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfEnum.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfEnum)resultMap.values().iterator().next();
    }

    @Override
    public List<RfType> getTypesWithPrefix(String prefix, int matchType, boolean local) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfType.class, prefix, null, false, matchType, local);
        return new NullProtectedList<RfType>((Collection<RfType>)resultMap.values());
    }

    @Override
    public RfType getTypeWithPrefix(String prefix, int matchType, boolean local) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfType.class, prefix, null, true, matchType, local);
        return resultMap.isEmpty() ? null : (RfType)resultMap.values().iterator().next();
    }

    @Override
    public List<RfActionBlock> getSequentialStatementsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetMembersWithPrefix(resultMap, RfActionBlock.class, prefix, null, false, matchType, false);
        return new NullProtectedList<RfActionBlock>((Collection<RfActionBlock>)resultMap.values());
    }

    @Override
    public RfActionBlock getSequentialStatementWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.internalGetMembersWithPrefix(resultMap, RfActionBlock.class, prefix, null, true, matchType, false);
        return resultMap.isEmpty() ? null : (RfActionBlock)resultMap.values().iterator().next();
    }

    @Override
    public List<IRfNamedElement> getOtherLangMembersWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap(1);
        this.internalMXGetMembersWithPrefix(resultMap, prefix, false, matchType);
        return new NullProtectedList<IRfNamedElement>((Collection<IRfNamedElement>)resultMap.values());
    }

    @Override
    public IRfNamedElement getOtherLangMemberWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap(1);
        this.internalMXGetMembersWithPrefix(resultMap, prefix, true, matchType);
        return resultMap.isEmpty() ? null : (IRfNamedElement)resultMap.values().iterator().next();
    }

    protected <T extends IRfNamedElement> void internalMXGetMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        Set<IRfNamedElement> visited;
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            visited = Collections.newSetFromMap(new IdentityHashMap());
            this.internalMXGetMembersInImports(visited, useList, result, prefix, first, matchType);
        }
        if ((useList = this.getExplicitUse()) != null) {
            visited = Collections.newSetFromMap(new IdentityHashMap());
            this.internalMXGetMembersInImports(visited, useList, result, prefix, first, matchType);
        }
        if (this.getEnclosingScope() != null) {
            this.getEnclosingScope().internalMXGetMembersWithPrefix(result, prefix, first, matchType);
        }
    }

    private <T extends IRfNamedElement> void internalMXGetMembersInImports(Set<IRfNamedElement> visited, List<ImportInfo> importsInfo, Map<String, T> result, String prefix, boolean first, int matchType) {
        if (importsInfo == null) {
            return;
        }
        boolean equals = (matchType & 1) != 0;
        for (ImportInfo importInfo : importsInfo) {
            IRfNamedElement element = importInfo.getElement();
            if (element instanceof RfLibrary) {
                RfProject rfProject = this.getRfProject();
                element = rfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)rfProject, element.getName(), 9);
            }
            if (element == null || element instanceof RfNamedElement || visited.contains(element)) continue;
            visited.add(element);
            if (element instanceof IRfPackageElement) {
                ((IRfPackageElement)element).getMembersWithPrefix(result, prefix, first, matchType);
                continue;
            }
            if (element instanceof IRfLibraryElement) {
                ((IRfLibraryElement)element).getMembersWithPrefix(result, prefix, first, matchType);
                continue;
            }
            if (result.containsKey(element.getName()) || !DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)(matchType | 8))) continue;
            result.put(element.getName(), element);
            if (!equals && !first) continue;
            return;
        }
    }

    protected <Z extends IRfNamedElement, T extends IRfNamedElement> void internalGetLocalMembersWithPrefix(Map<String, Z> result, Class<T> localMemberKind, String prefix, String enumParentTypeName, boolean first, int matchType) {
        boolean ignoreCase;
        boolean equals = (matchType & 1) != 0;
        boolean strictEquals = matchType == 1;
        boolean bl = ignoreCase = (matchType & 8) != 0;
        if (ignoreCase) {
            prefix = prefix.toLowerCase();
            boolean bl2 = strictEquals = matchType == 9;
        }
        if (strictEquals) {
            T localMember = this.getLocalMember(localMemberKind, prefix);
            if (localMember == null || ((RfNamedElement)localMember).isImplicit()) {
                return;
            }
            if (enumParentTypeName != null && localMember instanceof RfEnum && !((RfEnum)localMember).getParentEnumTypeName().equals(enumParentTypeName)) {
                return;
            }
            if (localMember instanceof RfFunctionsHolder) {
                result.put(String.valueOf(prefix) + result.size(), localMember);
            } else {
                result.put(prefix, localMember);
            }
        } else {
            List<T> localMembers = this.getLocalMembers(localMemberKind);
            if (localMembers == null) {
                return;
            }
            for (IRfNamedElement localMember : localMembers) {
                String memberName;
                if (((RfNamedElement)localMember).isAnonymous() || ((RfNamedElement)localMember).isImplicit() || !DVTStringUtil.regionMatches((String)(memberName = localMember.getLowerCaseName()), (String)prefix, (int)(matchType | 8))) continue;
                if (localMember instanceof RfFunctionsHolder) {
                    result.put(String.valueOf(memberName) + result.size(), localMember);
                } else if (enumParentTypeName == null || localMember instanceof RfEnum && ((RfEnum)localMember).getParentEnumTypeName().equals(enumParentTypeName)) {
                    result.put(memberName, localMember);
                }
                if (!first && !equals) continue;
                return;
            }
        }
    }

    protected <Z extends IRfNamedElement, T extends IRfNamedElement> void internalGetMembersWithPrefix(Map<String, Z> result, Class<T> localMemberKind, String prefix, String enumParentTypeName, boolean first, int matchType, boolean local) {
        RfLibrary workLib;
        this.internalGetLocalMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType);
        boolean equals = (matchType & 1) != 0;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        if (localMemberKind != RfFunctionsHolder.class && ((equals || first) && size > 0 || limit100 && size >= 100)) {
            return;
        }
        if (local && localMemberKind == RfFunctionsHolder.class && ("deallocate".equals(prefix) || "to_string".equals(prefix))) {
            this.internalGetMemberWithPrefixInUseClauses(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
            size = result.size();
            if ((equals || first) && size > 0 || limit100 && size >= 100) {
                return;
            }
        }
        if (local) {
            return;
        }
        if (this instanceof RfLibrary) {
            prefix = ((RfLibrary)this).translateLibraryName(prefix);
        }
        this.internalGetMemberWithPrefixInUseClauses(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        if (localMemberKind == RfEntity.class && (workLib = this.getEnclosingLibrary()) != null) {
            workLib.internalGetLocalMembersWithPrefix(result, localMemberKind, prefix, null, first, matchType);
            size = result.size();
            if ((equals || first) && size > 0 || limit100 && size >= 100) {
                return;
            }
        }
        if (this instanceof RfContext) {
            return;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope != null) {
            enclosingScope.internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        }
    }

    public <Z extends IRfNamedElement, T extends IRfNamedElement> void internalGetMemberWithPrefixInUseClauses(Map<String, Z> result, Class<T> localMemberKind, String prefix, String enumParentTypeName, boolean first, int matchType, boolean local) {
        IRfNamedElement element;
        boolean equals = (matchType & 1) != 0;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfPackage) {
                    ((RfPackage)element).internalGetLocalMembersWithPrefix(result, localMemberKind, prefix, null, first, matchType);
                } else if (element instanceof RfLibrary) {
                    ((RfLibrary)element).internalGetLocalMembersWithPrefix(result, localMemberKind, prefix, null, first, matchType);
                } else if (element instanceof IRfLibraryElement && localMemberKind == RfEntity.class) {
                    ((IRfLibraryElement)element).getDesignWithPrefix(prefix, matchType);
                }
                size = result.size();
                if (localMemberKind == RfFunctionsHolder.class || (!equals && !first || size <= 0) && (!limit100 || size < 100)) continue;
                return;
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext) {
                    ((RfContext)element).internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
                    size = result.size();
                    if (localMemberKind == RfFunctionsHolder.class || (!equals && !first || size <= 0) && (!limit100 || size < 100)) continue;
                    return;
                }
                if (!localMemberKind.isInstance(element) || !(element instanceof RfNamedElement) || result.containsKey(element.getName()) || !DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)(matchType | 8))) continue;
                result.put(element.getName(), element);
                size = result.size();
                if (localMemberKind == RfFunctionsHolder.class || !equals && !first && (!limit100 || size < 100)) continue;
                return;
            }
        }
    }

    public int getLine() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getStartLine();
        }
        return 0;
    }

    public int getStartOffset() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getStartOffset();
        }
        return 0;
    }

    public String getComment() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        if (this.isPredefined()) {
            return "PREDEFINED: " + declaration.getDefComment();
        }
        return declaration.getDefComment();
    }

    public String getRawComment() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        if (this.isPredefined()) {
            return "PREDEFINED: " + declaration.getRawDefComment();
        }
        return declaration.getRawDefComment();
    }

    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        CommentBlock declarationBlockComment = this.getCommentBlock();
        if (declarationBlockComment == null) {
            return "";
        }
        if (this.isPredefined()) {
            return "PREDEFINED: " + declarationBlockComment.toRawUntrimmedString(inlineAboveDelimiter);
        }
        return declarationBlockComment.toRawUntrimmedString(inlineAboveDelimiter);
    }

    public CommentBlock getCommentBlock() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null) {
            return declaration.getCommentBlock();
        }
        return null;
    }

    public void removeDef(RfDefElement def) {
        if (this.fDefs != null) {
            this.fDefs = OptimizedUtils.listContainerRemove(this.fDefs, (Object)def);
            this.clearAssociatedTypes();
        }
        this.fCachedArguments = null;
        this.fCachedRecordElements = null;
        this.fCachedParameters = null;
        this.fCachedPortListParameters = null;
        this.fCachedConstants = null;
        this.fEnumValuesMap = null;
        this.fCachedBaseType = null;
        RfFileDef defFile = def.getDefFile();
        if (defFile != null) {
            ParserPath parserPath = defFile.getParserPath();
            this.setImportsDirty(parserPath);
            if (this.fHidHolder != null && parserPath != null) {
                this.fHidHolder.invalidate(parserPath);
            }
        }
    }

    public void removeElement(RfNamedElement element) {
        Collection<RfNamedElement> members = this.getMembers();
        if (members != null) {
            Iterator<RfNamedElement> iterator = members.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != element) continue;
                iterator.remove();
            }
        }
    }

    public boolean checkEquals(Object obj) {
        return obj == this;
    }

    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        Collection<RfNamedElement> members;
        int endOffset;
        IRfNamedElement element;
        List<DataTypeChunk> useClauseList;
        LibraryPackageScope libraryPackageScope = this.getLibPkgScope();
        if (this.fWildcardUses != null && !this.fWildcardUses.isEmpty()) {
            for (ImportInfo importInfo : this.fWildcardUses) {
                RfPackage enclosingPackage;
                List<DataTypeChunk> useClauseList2;
                if (importInfo instanceof ImportInfo.StdImportInfo) continue;
                IRfNamedElement importElement = importInfo.getElement();
                if (onlyUnresolved && importElement != null && !(importElement instanceof ImportInfo.ErrorPackage)) {
                    boolean hasBeforeDeclError;
                    if (importElement.isPredefined()) continue;
                    useClauseList = importInfo.getUseClauseList();
                    boolean bl = hasBeforeDeclError = importElement instanceof RfNamedElement && !((RfNamedElement)importElement).isBefore(importInfo);
                    if (!hasBeforeDeclError || !RfProject.isEnableDefBeforeUseCheck(this, importElement, rfProject) || !report || useClauseList == null) continue;
                    DataTypeChunk dataTypeChunk = useClauseList.get(useClauseList.size() - 1);
                    int startOffset = dataTypeChunk.offset;
                    int endOffset2 = startOffset + dataTypeChunk.name.length();
                    IRfDefElement declaration = RfProject.getUsageBeforeDeclaration(importElement);
                    if (declaration == null) continue;
                    rfProject.addSemanticError(1, "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}", libraryPackageScope, startOffset, endOffset2, null, importInfo.getLine(), importInfo.getParserPath(), RfKind.of(importElement).getCapitalizedName(), importElement.getName(), declaration.getStartLine(), declaration.getParserPath());
                    continue;
                }
                element = importInfo.resolve(rfProject, this, otherLanguage);
                if (element instanceof ImportInfo.ErrorPackage && report && importInfo.getParserPath() != null) {
                    String nameOfMissingItem = ((ImportInfo.ErrorPackage)element).getNameOfMissingItem();
                    int startOffset = importInfo.getExplicitOffset(((ImportInfo.ErrorPackage)element).getIndex());
                    endOffset = startOffset + nameOfMissingItem.length();
                    rfProject.addSemanticError(1, ((ImportInfo.ErrorPackage)element).getErrorMessage(), libraryPackageScope, startOffset, endOffset, null, importInfo.getLine(), importInfo.getParserPath(), nameOfMissingItem);
                }
                if ((useClauseList2 = importInfo.getUseClauseList()) != null && useClauseList2.size() >= 2) {
                    DataTypeChunk libraryPart = useClauseList2.get(0);
                    DataTypeChunk packagePart = useClauseList2.get(1);
                    String libraryName = libraryPart.name.toUpperCase();
                    String packageName = packagePart.name.toUpperCase();
                    if (!libraryName.equals("WORK")) {
                        this.addReference(libraryName);
                        this.addReferenceToIdentifierName(libraryName);
                    }
                    this.addReference(packageName);
                    this.addReferenceToIdentifierName(packageName);
                    if (libraryName.equals("IEEE") && (packageName.equals("STD_LOGIC_SIGNED") || packageName.equals("STD_LOGIC_UNSIGNED") || packageName.equals("STD_LOGIC_ARITH"))) {
                        int startOffset = packagePart.offset;
                        endOffset = startOffset + packageName.length();
                        attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", packagePart.name);
                        attributes.put("QUICKFIX_KIND", 6);
                        rfProject.addSemanticError(2, "DEPRECATED_PACKAGE: Package ''{0}.{1}'' is deprecated, use ''IEEE.NUMERIC_STD'' standard package", libraryPackageScope, startOffset, endOffset, attributes, importInfo.getLine(), importInfo.getParserPath(), libraryPart, packagePart);
                    } else if (libraryName.equals("IEEE") && packageName.equals("STD_LOGIC_MISC")) {
                        int startOffset = packagePart.offset;
                        endOffset = startOffset + packageName.length();
                        attributes = new HashMap(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", packagePart.name);
                        attributes.put("QUICKFIX_KIND", 7);
                        rfProject.addSemanticError(2, RfSemanticError.NON_STANDARD_USE_CLAUSE_PACKAGE, libraryPackageScope, startOffset, endOffset, attributes, importInfo.getLine(), importInfo.getParserPath(), libraryPart, packagePart);
                    }
                }
                if (element != null) {
                    this.addReference(element.getName());
                    this.addReferenceToIdentifierName(element.getName());
                    if (!element.isPredefined()) {
                        boolean hasBeforeDeclError;
                        boolean bl = hasBeforeDeclError = element instanceof RfNamedElement && !((RfNamedElement)element).isBefore(importInfo);
                        if (hasBeforeDeclError && RfProject.isEnableDefBeforeUseCheck(this, element, rfProject) && report && useClauseList2 != null) {
                            DataTypeChunk dataTypeChunk = useClauseList2.get(useClauseList2.size() - 1);
                            int startOffset = dataTypeChunk.offset;
                            int endOffset3 = startOffset + dataTypeChunk.name.length();
                            IRfDefElement declaration = RfProject.getUsageBeforeDeclaration(element);
                            if (declaration != null) {
                                rfProject.addSemanticError(1, "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}", libraryPackageScope, startOffset, endOffset3, null, importInfo.getLine(), importInfo.getParserPath(), RfKind.of(element).getCapitalizedName(), element.getName(), declaration.getStartLine(), declaration.getParserPath());
                            }
                        }
                    }
                }
                if (element instanceof RfPackage) {
                    rfProject.setIncrementalChangedImports(true, element.getName(), this);
                }
                if (element != null && element != importInfo.getElement() && (enclosingPackage = (RfPackage)element.getEnclosingScope(RfPackage.class)) != null) {
                    rfProject.setIncrementalChangedImports(true, enclosingPackage.getName(), this);
                }
                importInfo.setElement(element);
            }
            if (this.fWildcardUses.size() > 1) {
                this.fWildcardUses.sort(USE_COMPARATOR);
            }
        }
        if (this.fExplicitUses != null && !this.fExplicitUses.isEmpty()) {
            for (ImportInfo importInfo : this.fExplicitUses) {
                RfPackage enclosingPackage;
                int startOffset;
                List<DataTypeChunk> useClauseList3;
                IRfNamedElement oldElement = importInfo.getElement();
                if (onlyUnresolved && importInfo.getElement() != null && !(importInfo.getElement() instanceof ImportInfo.ErrorPackage)) continue;
                element = importInfo.resolve(rfProject, this, otherLanguage);
                if (element instanceof ImportInfo.ErrorPackage && oldElement instanceof ImportInfo.ErrorPackage && ((ImportInfo.ErrorPackage)oldElement).getNameOfMissingItem().equals(importInfo.getExplicitName())) {
                    element = oldElement;
                }
                if (element instanceof ImportInfo.ErrorPackage && report && importInfo.getParserPath() != null) {
                    String nameOfMissingItem = ((ImportInfo.ErrorPackage)element).getNameOfMissingItem();
                    int startOffset2 = importInfo.getExplicitOffset(((ImportInfo.ErrorPackage)element).getIndex());
                    endOffset = startOffset2 + nameOfMissingItem.length();
                    rfProject.addSemanticError(1, ((ImportInfo.ErrorPackage)element).getErrorMessage(), libraryPackageScope, startOffset2, endOffset, null, importInfo.getLine(), importInfo.getParserPath(), nameOfMissingItem);
                }
                if ((useClauseList3 = importInfo.getUseClauseList()) != null && useClauseList3.size() >= 2) {
                    String libraryName = useClauseList3.get((int)0).name.toUpperCase();
                    String packageName = useClauseList3.get((int)1).name.toUpperCase();
                    if (!libraryName.equals("WORK")) {
                        this.addReference(libraryName);
                        this.addReferenceToIdentifierName(libraryName);
                    }
                    this.addReference(packageName);
                    this.addReferenceToIdentifierName(packageName);
                    if (libraryName.equals("IEEE") && packageName.equals("STD_LOGIC_SIGNED") || packageName.equals("STD_LOGIC_UNSIGNED") || packageName.equals("STD_LOGIC_ARITH")) {
                        startOffset = importInfo.getUseClauseList().get((int)0).offset + "ieee.".length();
                        int endOffset4 = startOffset + packageName.length();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", useClauseList3.get((int)1).name);
                        attributes.put("QUICKFIX_KIND", 6);
                        rfProject.addSemanticError(2, "DEPRECATED_PACKAGE: Package ''{0}.{1}'' is deprecated, use ''IEEE.NUMERIC_STD'' standard package", libraryPackageScope, startOffset, endOffset4, attributes, importInfo.getLine(), importInfo.getParserPath(), useClauseList3.get(0), useClauseList3.get(1));
                    } else if (libraryName.equals("IEEE") && packageName.equals("STD_LOGIC_MISC")) {
                        startOffset = importInfo.getUseClauseList().get((int)0).offset + "ieee.".length();
                        int endOffset5 = startOffset + packageName.length();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", useClauseList3.get((int)1).name);
                        attributes.put("QUICKFIX_KIND", 7);
                        rfProject.addSemanticError(2, RfSemanticError.NON_STANDARD_USE_CLAUSE_PACKAGE, libraryPackageScope, startOffset, endOffset5, attributes, importInfo.getLine(), importInfo.getParserPath(), useClauseList3.get(0), useClauseList3.get(1));
                    }
                }
                if (element != null) {
                    this.addReference(element.getName());
                    this.addReferenceToIdentifierName(element.getName());
                    if (!element.isPredefined()) {
                        boolean hasBeforeDeclError;
                        boolean bl = hasBeforeDeclError = element instanceof RfNamedElement && !((RfNamedElement)element).isBefore(importInfo);
                        if (hasBeforeDeclError && RfProject.isEnableDefBeforeUseCheck(this, element, rfProject) && report && useClauseList3 != null) {
                            DataTypeChunk dataTypeChunk = useClauseList3.get(useClauseList3.size() - 1);
                            startOffset = dataTypeChunk.offset;
                            int endOffset6 = startOffset + dataTypeChunk.name.length();
                            IRfDefElement declaration = RfProject.getUsageBeforeDeclaration(element);
                            if (declaration != null) {
                                rfProject.addSemanticError(1, "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}", libraryPackageScope, startOffset, endOffset6, null, importInfo.getLine(), importInfo.getParserPath(), RfKind.of(element).getCapitalizedName(), element.getName(), declaration.getStartLine(), declaration.getParserPath());
                            }
                        }
                    }
                }
                if (element != null && element != importInfo.getElement() && (enclosingPackage = (RfPackage)element.getEnclosingScope(RfPackage.class)) != null) {
                    rfProject.setIncrementalChangedImports(true, enclosingPackage.getName(), this);
                }
                importInfo.setElement(element);
            }
            if (this.fExplicitUses.size() > 1) {
                this.fExplicitUses.sort(USE_COMPARATOR);
            }
        }
        if (this.fLibraryClauses != null && !this.fLibraryClauses.isEmpty()) {
            for (ImportInfo importInfo : this.fLibraryClauses) {
                if (onlyUnresolved && importInfo.getElement() != null && !(importInfo.getElement() instanceof ImportInfo.ErrorPackage)) continue;
                IRfNamedElement element2 = importInfo.resolve(rfProject, this, otherLanguage);
                if (element2 instanceof ImportInfo.ErrorPackage && report && importInfo.getParserPath() != null) {
                    String nameOfMissingItem = ((ImportInfo.ErrorPackage)element2).getNameOfMissingItem();
                    int startOffset = importInfo.getOffset();
                    int endOffset7 = startOffset + nameOfMissingItem.length();
                    HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                    attributes.put("QUICKFIX_ELEMENT_NAME", nameOfMissingItem);
                    attributes.put("QUICKFIX_KIND", 13);
                    rfProject.addSemanticError(1, ((ImportInfo.ErrorPackage)element2).getErrorMessage(), libraryPackageScope, startOffset, endOffset7, attributes, importInfo.getLine(), importInfo.getParserPath(), nameOfMissingItem);
                } else if (element2 instanceof RfLibrary && (useClauseList = importInfo.getUseClauseList()) != null && !useClauseList.isEmpty()) {
                    String libraryName = useClauseList.get((int)0).name.toUpperCase();
                    if (!libraryName.equals("WORK")) {
                        this.addReference(libraryName);
                        this.addReferenceToIdentifierName(libraryName);
                    }
                    if (libraryName.equals("STD") || libraryName.equals("WORK")) {
                        int startOffset = importInfo.getOffset();
                        endOffset = startOffset + libraryName.length();
                        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                        attributes.put("QUICKFIX_ELEMENT_NAME", libraryName);
                        attributes.put("QUICKFIX_KIND", 8);
                        rfProject.addSemanticError(2, "IMPLICIT_LIBRARY_ACCESS: Access to ''{0}'' library is implicit; the library clause can be removed", libraryPackageScope, startOffset, endOffset, attributes, importInfo.getLine(), importInfo.getParserPath(), useClauseList.get(0));
                    }
                }
                importInfo.setElement(element2);
            }
        }
        if ((members = this.getMembers()) != null) {
            this.resolveUses(members.iterator(), rfProject, report, onlyUnresolved, otherLanguage);
        }
    }

    protected void resolveUses(Iterator<? extends RfNamedElement> it, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        while (it.hasNext()) {
            it.next().resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
        }
    }

    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        if (!onlyUnresolved) {
            this.fTransientUsedRecordTypes = null;
        }
        configInfo.closestTypeContainer = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        Collection<RfNamedElement> members = this.getMembers(false, true);
        if (members != null) {
            this.resolveTypes(configInfo, members.iterator(), rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        }
    }

    protected void resolveTypes(ConfigInfo configInfo, Iterator<? extends RfNamedElement> it, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        while (it.hasNext()) {
            RfNamedElement member = it.next();
            if (skipMemberClasses != null && skipMemberClasses.contains(member.getClass()) || configInfo.incremental && (member instanceof RfArchitecture || member instanceof RfConfiguration)) continue;
            member.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        }
    }

    public boolean isPredefined() {
        RfDefElement def = this.getDeclaration();
        if (def == null) {
            return false;
        }
        return def.isPredefined();
    }

    public boolean isAnonymous() {
        return this.fName != null && this.fName.length() > 0 && this.fName.charAt(0) == '@';
    }

    public static String getUniqueNameForAnonymous(ParserPath parserPath, LineInfo lineInfo) {
        return "@" + parserPath + '@' + lineInfo.line;
    }

    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_NAME: Duplicate name ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public RfProject getRfProject() {
        RfNamedElement scope = this.getEnclosingScope();
        while (scope != null && !(scope instanceof RfProject)) {
            scope = scope.getEnclosingScope();
        }
        return (RfProject)scope;
    }

    public Image getImage() {
        return null;
    }

    public Image testGetImage(String imageName) {
        try {
            ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(imageName).get(null);
            return DVTImages.imageCache.getImage(descriptor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BindingRuleWrapper computeAndVerifyBinds2(RfComponent component, RfInstance instance, ElementPath instanceName, Collection<? extends IRfConfigurationRule> rules, ElementPath instancePath) {
        if (rules == null || rules.isEmpty()) {
            return null;
        }
        if (instanceName != null && instanceName.length() > 1) {
            ArrayList<? extends IRfConfigurationRule> workingRules = new ArrayList<IRfConfigurationRule>(rules);
            String[] stringArray = instanceName.getSegments();
            String blockName = stringArray[0];
            if (blockName != null) {
                for (RfConfigurationRule rfConfigurationRule : workingRules) {
                    BindingRuleWrapper candidateResult;
                    IRfBlockElement candidateBlockElement;
                    if (!rfConfigurationRule.isBlockRule() || (candidateBlockElement = rfConfigurationRule.getBlockElement()) == null || !blockName.equals(candidateBlockElement.getName()) || (candidateResult = RfNamedElement.computeAndVerifyBinds2(component, instance, instanceName = instanceName.removeFirstSegment(), rfConfigurationRule.getLocalRules(), instancePath)) == null) continue;
                    return candidateResult;
                }
            }
            return null;
        }
        ArrayList<RfInstance> usedInstances = new ArrayList<RfInstance>();
        block6: for (IRfConfigurationRule iRfConfigurationRule : rules) {
            RfComponent rfComponent;
            RfConfigurationRule rule;
            if (!(iRfConfigurationRule instanceof RfConfigurationRule) || (rule = (RfConfigurationRule)iRfConfigurationRule).isBlockRule() || !component.equals(rfComponent = rule.getComponentElement())) continue;
            switch (rule.getRuleCoverage()) {
                case LIST: {
                    List<RfInstance> listInstances;
                    if (instance == null || (listInstances = rule.getSpecificationInstances()) == null) continue block6;
                    for (RfInstance listInstance : listInstances) {
                        if (instance.equals(listInstance)) {
                            return BindingRuleWrapper.fromRule((IRfConfigurationRule)rule, (ElementPath)instancePath);
                        }
                        usedInstances.add(listInstance);
                    }
                    continue block6;
                }
                case OTHERS: {
                    if (instance == null || usedInstances.contains(instance)) continue block6;
                    return BindingRuleWrapper.fromRule((IRfConfigurationRule)rule, (ElementPath)instancePath);
                }
                case ALL: {
                    return BindingRuleWrapper.fromRule((IRfConfigurationRule)rule, (ElementPath)instancePath);
                }
            }
        }
        return null;
    }

    public void deepClean() {
        if (!(this instanceof RfProject)) {
            this.fName = null;
        }
        if (this.fDefs != null) {
            OptimizedUtils.deepClean(this.fDefs);
        }
        this.fDefs = null;
        this.compileInfo = null;
        if (this.fHidHolder != null) {
            this.fHidHolder.deepClean();
        }
        this.fHidHolder = null;
        this.fEnclosingScope = null;
        if (this.fMembers != null) {
            this.fMembers.deepClean();
        }
        this.fMembers = null;
        this.setConfigNames(null);
        if (this.fWildcardUses != null) {
            this.fWildcardUses.clear();
        }
        if (this.fExplicitUses != null) {
            this.fExplicitUses.clear();
        }
        if (this.fLibraryClauses != null) {
            this.fLibraryClauses.clear();
        }
        this.fCachedArguments = null;
        this.fCachedRecordElements = null;
        this.fCachedParameters = null;
        this.fCachedPortListParameters = null;
        this.fCachedConstants = null;
        this.fConfigNames = null;
        this.fTransientResolvedGenericMap = null;
        this.fEnumValuesMap = null;
        this.fCachedBaseType = null;
    }

    public IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        IRfNamedElement result = this.semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
        return result;
    }

    protected IRfNamedElement semanticGetMember(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        if (visited.contains(this)) {
            return null;
        }
        IRfNamedElement result = this.semanticGetLocalMember(name, hid, null, null, visited, null, isFirst, isLast, recursiveCall);
        if (result != null) {
            return result;
        }
        result = this.semanticGetMemberInUseClauses(visited, recursiveCall, name, isFirst, isLast, hid);
        if (result != null) {
            return result;
        }
        if (this instanceof RfContext) {
            return result;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (this instanceof RfConfigurationRule && !(enclosingScope instanceof RfConfigurationRule) && !(enclosingScope instanceof RfConfiguration)) {
            RfLibrary enclosingLibrary = this.getEnclosingLibrary();
            if (enclosingLibrary != null && isFirst && (result = enclosingLibrary.semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid)) == null) {
                result = enclosingLibrary.semanticGetMemberInSTDStandardUseClause(name);
            }
            return result;
        }
        if (isFirst && enclosingScope != null) {
            result = enclosingScope.semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
        }
        return result;
    }

    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        if (visited != null) {
            if (visited.contains(this)) {
                return null;
            }
            visited.add(this);
        }
        Set<Class<RfComponent>> classes = hid == null || !hid.hasOccurrence(HidQualifierCache.COMPONENT_TYPE) ? DVTRfUtils.MEMBERS_OTHERS : Collections.singleton(RfComponent.class);
        IRfNamedElement result = this.getLocalMember(classes, name, (IRfNamedElement)null);
        return result;
    }

    public IRfNamedElement semanticGetMemberInUseClauses(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfNamedElement) {
                    result = ((RfNamedElement)element).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
                } else if (element instanceof IRfLibraryElement) {
                    result = ((IRfLibraryElement)element).getDesignWithPrefix(name, 9);
                }
                if (result == null) continue;
                return result;
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext) {
                    result = ((RfContext)element).semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
                    if (result == null) continue;
                    return result;
                }
                if (!(element instanceof RfNamedElement)) continue;
                if (DVTStringUtil.regionMatches((String)element.getName(), (String)name, (int)9) && DVTRfUtils.MEMBERS_OTHERS.contains(element.getClass())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        return result;
    }

    public List<RfConfiguration> getLocalConfigurations() {
        Set<String> configNames = this.getConfigNames();
        if (configNames == null || configNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfConfiguration> result = new ArrayList<RfConfiguration>(configNames.size());
        for (String configName : configNames) {
            RfConfiguration element = this.getLocalMember(RfConfiguration.class, configName);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getDesignsWithPrefix(prefix, matchType);
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getDesignWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return this.getTypesWithPrefix(prefix, matchType, true);
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return this.getTypeWithPrefix(prefix, matchType, true);
    }

    public boolean hasHidObjects() {
        return this.fHidHolder != null && !this.fHidHolder.isHidObjectsEmpty();
    }

    public RfHidHolder getHidHolder() {
        return this.fHidHolder;
    }

    public RfHidHolder getOrCreateHidHolder() {
        if (this.fHidHolder == null) {
            this.fHidHolder = new RfHidHolder(this);
        }
        return this.fHidHolder;
    }

    public void setHidHolder(RfHidHolder hidHolder) {
        this.fHidHolder = hidHolder;
    }

    public void clearOnlyHidOperators() {
        if (this.fHidHolder != null) {
            this.fHidHolder.clearOnlyHidOperators();
        }
    }

    public List<IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (persistence.isSaveCanceled()) {
            throw new PersistenceCancelException();
        }
        out.writeObject(this.fName);
        out.writeObject(this.fLowerCaseName);
        out.writeObject(this.fWildcardUses);
        out.writeObject(this.fExplicitUses);
        out.writeObject(this.fLibraryClauses);
        out.writeObject(this.fMembers);
        out.writeObject(this.fEnumValuesMap);
        out.writeObject(this.getConfigNames());
        out.writeObject(this.compileInfo);
        out.writeObject(this.fDefs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!(in instanceof PersistenceInputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceInputStream)in).getPersistence();
        persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readStart((Object)this);
        if (persistence.isRestoreCanceled()) {
            throw new PersistenceCancelException();
        }
        this.fName = (String)in.readObject();
        this.fLowerCaseName = (String)in.readObject();
        this.fWildcardUses = (List)in.readObject();
        this.fExplicitUses = (List)in.readObject();
        this.fLibraryClauses = (List)in.readObject();
        this.fMembers = (InsensitiveLinkedMap)in.readObject();
        this.fEnumValuesMap = (HashMap)in.readObject();
        this.setConfigNames((Set)in.readObject());
        this.compileInfo = (VhdlCompileInfo)in.readObject();
        this.fDefs = (ListContainer)in.readObject();
        if (this.fDefs != null) {
            for (RfDefElement def : this.fDefs) {
                if (def == null) {
                    DVTLogger.INSTANCE.logInfo("[RESTORE] NULL def in " + RfElementPath.path((IRfNamedElement)this).toNiceString());
                    continue;
                }
                def.addNamedElement(this);
            }
        }
        persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readEnd((Object)this);
    }

    public boolean isImplicit() {
        return (this instanceof RfEntity || this instanceof RfLibrary) && this.getDeclaration() instanceof RfImplicitDef;
    }

    public int getMemberSelect() {
        return -1;
    }

    public Map<String, IRfNamedElement> getResolvedGenericMap(boolean keepGenericMap) {
        if (this.fTransientResolvedGenericMap != null) {
            return this.fTransientResolvedGenericMap;
        }
        OptimizedLinkedHashMap resolvedGenericMap = new OptimizedLinkedHashMap();
        this.internalGetResolvedGenericMap((Map<String, IRfNamedElement>)resolvedGenericMap);
        if (keepGenericMap) {
            this.fTransientResolvedGenericMap = resolvedGenericMap;
        }
        return resolvedGenericMap;
    }

    protected void internalGetResolvedGenericMap(Map<String, IRfNamedElement> result) {
        RfNamedElement enclosingScope;
        RfAlias packageInstance;
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                packageInstance = use.getPackageInstance();
                if (packageInstance == null) continue;
                packageInstance.internalGetLocalResolvedGenericMap(result);
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                packageInstance = use.getPackageInstance();
                if (packageInstance == null) continue;
                packageInstance.internalGetLocalResolvedGenericMap(result);
            }
        }
        if ((enclosingScope = this.getEnclosingScope()) != null) {
            enclosingScope.internalGetResolvedGenericMap(result);
        }
    }

    public static Map<String, IRfNamedElement> updateGenericMap(IRfNamedElement element, Map<String, IRfNamedElement> oldGenericMap, boolean keepGenericMap) {
        if (!(element instanceof RfNamedElement)) {
            return oldGenericMap;
        }
        Map<String, IRfNamedElement> genericMap = ((RfNamedElement)element).getResolvedGenericMap(keepGenericMap);
        if (oldGenericMap == null || oldGenericMap.isEmpty()) {
            return genericMap;
        }
        return oldGenericMap;
    }

    public boolean visitNamedElements(RfProject rfProject, IRfNamedElementVisitor visitor) {
        block7: {
            try {
                if (!(visitor instanceof IRfNamedElementVisitor2) || ((IRfNamedElementVisitor2)visitor).preVisit(this)) break block7;
                return false;
            }
            catch (Exception e) {
                throw new RfNamedElementVisitorException(e);
            }
        }
        if (!visitor.visit(this)) {
            return false;
        }
        Collection<RfNamedElement> members = this.getMembers();
        if (members != null && !this.visitNamedElement(rfProject, visitor, members)) {
            return false;
        }
        try {
            return !(visitor instanceof IRfNamedElementVisitor2) || ((IRfNamedElementVisitor2)visitor).postVisit(this);
        }
        catch (Exception e) {
            throw new RfNamedElementVisitorException(e);
        }
    }

    public void accept(RfProject rfProject, IRfNamedElementVisitor visitor) {
        this.visitNamedElements(rfProject, visitor);
    }

    protected boolean visitNamedElement(RfProject rfProject, IRfNamedElementVisitor visitor, Collection<? extends RfNamedElement> namedElements) {
        if (namedElements != null && !namedElements.isEmpty()) {
            for (RfNamedElement rfNamedElement : namedElements) {
                if (rfNamedElement.visitNamedElements(rfProject, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean visitNamedElement(RfProject rfProject, IRfNamedElementVisitor visitor, DVTArrayList<? extends RfNamedElement> namedElements) {
        if (namedElements != null && !namedElements.isEmpty()) {
            for (RfNamedElement namedElement : namedElements.values()) {
                if (namedElement.visitNamedElements(rfProject, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public void setEnclosingScopeOfChildrenForRestore(IRfNamedElement rfNamedElement) {
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null) {
            return;
        }
        for (RfNamedElement member : members) {
            member.setEnclosingScope(rfNamedElement, true);
        }
    }

    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumParentTypeNameList, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (this.fMembers == null) {
            return null;
        }
        String enumParentTypeName = enumParentTypeNameList != null && enumParentTypeNameList.size() == 1 ? enumParentTypeNameList.get(0) : null;
        RfNamedElement candidate = (RfNamedElement)this.fMembers.get(name);
        if (candidate instanceof RfDuplicate) {
            return ((RfDuplicate)candidate).getLastMember(classes, enumParentTypeName);
        }
        if (!(candidate == null || classes != null && !classes.contains(candidate.getClass()) || enumParentTypeName != null && candidate instanceof RfEnum && !((RfEnum)candidate).getParentEnumTypeName().equals(enumParentTypeName))) {
            return candidate;
        }
        return null;
    }

    public Class<? extends RfNamedElement> getCustomClass() {
        return this.getClass();
    }

    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        IRfNamedElement result = this.getMember(visited, name, null, isFirst, isLast, isOnlyType, classes, exclude);
        return result;
    }

    protected IRfNamedElement getMemberInUseClauses(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getExplicitUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext && (result = ((RfContext)element).getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null) {
                    return result;
                }
                if (element == exclude || element == null || classes != null && !classes.contains(element.getClass())) continue;
                if (element instanceof RfNamedElement && name.equalsIgnoreCase(element.getName())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        if ((useList = this.getWildcardUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element != null) {
                    result = element.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                }
                if (result == null || result == exclude) continue;
                return result;
            }
        }
        return result;
    }

    protected IRfNamedElement getLocalMember(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        IMembersProvider membersProvider = scope -> {
            IRfNamedElement result = scope.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
            if (result == exclude) {
                result = null;
            }
            if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
                result = null;
            }
            return result;
        };
        IRfNamedElement result = membersProvider.getLocalMember((IRfNamedElement)this);
        if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
            return null;
        }
        return result;
    }

    protected IRfNamedElement getMember(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        IRfNamedElement result = this.getLocalMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude);
        if (result != null && result != exclude) {
            return result;
        }
        if (isFirst) {
            result = this.getMemberInUseClauses(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude);
            if (result != exclude) {
                return result;
            }
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (enclosingScope != null && !visited.contains(enclosingScope) && (result = enclosingScope.getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null && result != exclude) {
                return result;
            }
        }
        return null;
    }

    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        Collection<RfNamedElement> members = this.getMembers();
        if (members == null) {
            return;
        }
        for (RfNamedElement element : members) {
            String tmpPrefix;
            if (element instanceof RfDuplicate) {
                element.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
                continue;
            }
            if (element == null || clazz != null && !clazz.isInstance(element) || element.isAnonymous() || !elementFilter.validElement((IRfNamedElement)element) || (tmpPrefix = prefix) != null && !DVTStringUtil.regionMatches((String)element.getName(), (String)tmpPrefix, (int)matchType)) continue;
            result.add(element);
            if (elementFilter.resultMaxSize() != result.size()) continue;
            throw new MaxSizeReachedException();
        }
    }

    public <T extends IRfNamedElement> void getMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        RfLibrary workLib;
        IRfNamedElement element;
        Assert.isNotNull((Object)elementFilter);
        HashSet<RfNamedElement> visited = new HashSet<RfNamedElement>();
        this.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
        visited.add(this);
        if (local == 1 || local == 2) {
            return;
        }
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfPackage) {
                    ((RfPackage)element).getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
                    continue;
                }
                if (element instanceof RfLibrary) {
                    ((RfLibrary)element).getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
                    continue;
                }
                if (!(element instanceof IRfLibraryElement)) continue;
                ((IRfLibraryElement)element).getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element == null || clazz != null && !clazz.isInstance(element) || !elementFilter.validElement(element) || prefix != null && !DVTStringUtil.regionMatches((String)element.getName(), (String)prefix, (int)matchType)) continue;
                result.add(element);
                if (elementFilter.resultMaxSize() != result.size()) continue;
                throw new MaxSizeReachedException();
            }
        }
        if ((clazz == null || clazz == RfEntity.class) && (workLib = this.getEnclosingLibrary()) != null) {
            workLib.getLocalMembers(result, clazz, prefix, enumPrefixProposals, matchType, isFirst, accessModifier, elementFilter);
        }
        IRfElementFilter elementFilter2 = elementFilter;
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope != null && !visited.contains(enclosingScope)) {
            enclosingScope.getMembers(result, clazz, prefix, enumPrefixProposals, matchType, local, isFirst, accessModifier, elementFilter2);
        }
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        try {
            this.getMembers(result, null, prefix, null, matchType |= 8, local, isFirst, accessModifier, elementFilter);
        }
        catch (MaxSizeReachedException maxSizeReachedException) {}
    }

    public String getNameForNoDuplicateList() {
        return this.getName();
    }

    public String getElabName(boolean isCaseSensitive) {
        return this.getLowerCaseName();
    }

    public IRfNamedElement semanticGetUsedRecordElement(Set<IRfNamedElement> visited, String name) {
        IRfNamedElement element;
        boolean hasTransientUsedRecordTypes;
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        if (this instanceof RfProcess || this instanceof RfFunction || this instanceof RfFunctionsHolder || this instanceof RfActionBlock) {
            RfNamedElement enclosingScope = this.getEnclosingScope();
            return enclosingScope.semanticGetUsedRecordElement(visited, name);
        }
        boolean bl = hasTransientUsedRecordTypes = this.fTransientUsedRecordTypes != null && !this.fTransientUsedRecordTypes.isEmpty();
        if (this.getExplicitUse() == null && this.getWildcardUse() == null && !hasTransientUsedRecordTypes) {
            RfNamedElement enclosingScope = this.getEnclosingScope();
            if (enclosingScope == null || enclosingScope instanceof RfProject) {
                return null;
            }
            return enclosingScope.semanticGetUsedRecordElement(visited, name);
        }
        if (hasTransientUsedRecordTypes) {
            block0: for (RfType recordType : this.fTransientUsedRecordTypes.values()) {
                HashSet<RfType> visisted2 = new HashSet<RfType>();
                while (recordType instanceof RfListType || recordType.isAccess()) {
                    if (visisted2.contains(recordType)) break;
                    visisted2.add(recordType);
                    IRfNamedElement associatedType = recordType.getAssociatedType();
                    if (!(associatedType instanceof RfType)) continue block0;
                    recordType = (RfType)associatedType;
                }
                if (!recordType.isRecord()) continue;
                element = recordType.getLocalMember(RfVariable.class, name);
                if (element != null) {
                    return element;
                }
                if (recordType == this || (element = recordType.semanticGetUsedRecordElement(visited, name)) == null) continue;
                return element;
            }
        }
        if (!(!(this instanceof RfBlock) || this instanceof RfPackage || this instanceof RfPackageBody || this instanceof RfArchitecture || this instanceof RfTypeBody)) {
            return this.getEnclosingScope().semanticGetUsedRecordElement(visited, name);
        }
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfPackage) {
                    element = ((RfPackage)element).semanticGetUsedRecordElement(visited, name);
                } else if (element instanceof RfLibrary) {
                    element = ((RfLibrary)element).semanticGetUsedRecordElement(visited, name);
                } else if (!(element instanceof RfNamedElement)) {
                    element = null;
                }
                if (element == null) continue;
                return element;
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            block3: for (ImportInfo use : useList) {
                element = use.getElement();
                if (element == null || !(element instanceof RfType)) continue;
                RfType recordType = (RfType)element;
                HashSet<RfType> visisted2 = new HashSet<RfType>();
                while (recordType instanceof RfListType || recordType.isAccess()) {
                    if (visisted2.contains(recordType)) break;
                    visisted2.add(recordType);
                    IRfNamedElement associatedType = recordType.getAssociatedType();
                    if (!(associatedType instanceof RfType)) continue block3;
                    recordType = (RfType)associatedType;
                }
                element = recordType.getLocalMember(RfVariable.class, name);
                if (element != null) {
                    return element;
                }
                if (recordType == this) continue;
                element = recordType.semanticGetUsedRecordElement(visited, name);
                if (element != null) {
                    return element;
                }
                if (recordType.isRecord()) continue;
            }
        }
        return null;
    }

    public void addUsedRecordType(RfType recordType) {
        if (recordType == null) {
            return;
        }
        if (this instanceof RfProcess || this instanceof RfFunction || this instanceof RfFunctionsHolder || this instanceof RfActionBlock) {
            RfNamedElement enclosingScope = this.getEnclosingScope();
            enclosingScope.addUsedRecordType(recordType);
            return;
        }
        if (this.fTransientUsedRecordTypes == null) {
            this.fTransientUsedRecordTypes = new HashMap<String, RfType>();
        }
        this.fTransientUsedRecordTypes.put(recordType.getName(), recordType);
    }

    public int getSemanticErrorSeverityForDuplicate() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReferenceToIdentifierName(String name) {
        if (name == null || this.isPredefined()) {
            return;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            this.fReferencedIdentifierNames = OptimizedUtils.setAdd(this.fReferencedIdentifierNames, (Object)DVTStringUtil.intern((String)name.toLowerCase()));
        }
    }

    public void addReferenceToIdentifierNameInClosestContainer(String name) {
        IRfNamedElement enclosingScope = this.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
        if (enclosingScope != null) {
            enclosingScope.addReferenceToIdentifierName(name);
        }
    }

    public void addReferenceToIdentifierName(DataType dataType) {
        if (dataType == null) {
            return;
        }
        List<DataTypeChunk> typeName = dataType.getTypeName();
        if (typeName == null || typeName.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < typeName.size()) {
            this.addReferenceToIdentifierName(typeName.get((int)i).name);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReferenceToIdentifierName(String name) {
        if (this.fReferencedIdentifierNames == null) {
            return false;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            return this.fReferencedIdentifierNames.contains(DVTStringUtil.intern((String)name.toLowerCase()));
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    public String getKindName() {
        return RfKind.of(this).getName();
    }

    public RfNamedElement getClosestTypeContainer() {
        RfNamedElement result = this;
        while (result.getEnclosingScope() != null) {
            if (result instanceof RfPackage || result instanceof RfPackageBody || result instanceof RfEntity || result instanceof RfArchitecture || result instanceof RfType || result instanceof RfTypeBody || result instanceof RfComponent || result instanceof RfLibrary || result instanceof RfConfiguration) {
                return result;
            }
            result = result.getEnclosingScope();
        }
        return result;
    }

    public boolean isNonStandard() {
        return false;
    }

    public IRfNamedElement getAssociatedBaseType() {
        return null;
    }

    public String elementPathName() {
        return this.getName();
    }

    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        String holderName;
        IRfNamedElement functionHolder;
        RfNamedElement thisScope = this;
        if (classes != null && classes.contains(RfFunction.class) && (functionHolder = this.getMember(holderName = RfFunctionsHolder.getSimpleName(name), Collections.singleton(RfFunctionsHolder.class), exclude, isFirst, isLast, includeEnums, isOnlyType, false)) != null) {
            thisScope = functionHolder;
        }
        if (classes != null && classes.contains(RfBlock.class)) {
            String containerName = RfBlock.getSimpleName(name);
            return this.getMember(containerName, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, false);
        }
        return thisScope.getMember(name, classes, exclude, isFirst, isLast, includeEnums, isOnlyType, false);
    }

    public Collection<? extends IRfInstanceElement> getLocalInstances() {
        return this.getLocalMembers(RfInstance.class);
    }

    public Collection<? extends IRfBlockElement> getLocalGenerateBlocks() {
        return this.getLocalMembers(RfBlock.class);
    }

    public List<? extends IRfPortElement> getLocalPorts() {
        return this.getLocalMembers(RfPort.class);
    }

    public Collection<? extends IRfFieldElement> getLocalSignals() {
        return this.getLocalMembers(RfVariable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends RfNamedElement> getLocalParameters() {
        if (this.fCachedParameters != null) {
            return this.fCachedParameters;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            if (this.fCachedParameters == null) {
                this.cacheElements();
            }
        }
        return this.fCachedParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends RfNamedElement> getPortListParameters() {
        if (this.fCachedPortListParameters != null) {
            return this.fCachedPortListParameters;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            if (this.fCachedPortListParameters == null) {
                this.cacheElements();
            }
        }
        return this.fCachedPortListParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends RfNamedElement> getLocalElabConstants() {
        if (this.fCachedConstants != null) {
            return this.fCachedConstants;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            if (this.fCachedConstants == null) {
                this.cacheElements();
            }
        }
        return this.fCachedConstants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfVariable> getArguments() {
        if (this.fCachedArguments != null) {
            return this.fCachedArguments;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            if (this.fCachedArguments == null) {
                this.cacheElements();
            }
        }
        return this.fCachedArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfVariable> getRecordElements() {
        if (this.fCachedRecordElements != null) {
            return this.fCachedRecordElements;
        }
        RfNamedElement rfNamedElement = this;
        synchronized (rfNamedElement) {
            if (this.fCachedRecordElements == null) {
                this.cacheElements();
            }
        }
        return this.fCachedRecordElements;
    }

    private final void cacheElements() {
        DVTLinkedHashMap<String, RfNamedElement> members;
        boolean[] hasSortedConstants;
        ArrayList<RfNamedElement> localConstants;
        ArrayList<RfNamedElement> localPortListParameters;
        ArrayList<RfNamedElement> localParameters;
        ArrayList<RfVariable> localRecordElements;
        ArrayList<RfVariable> localArguments;
        block20: {
            RfEntity entity;
            localArguments = new ArrayList<RfVariable>();
            localRecordElements = new ArrayList<RfVariable>();
            localParameters = new ArrayList<RfNamedElement>();
            localPortListParameters = new ArrayList<RfNamedElement>();
            localConstants = new ArrayList<RfNamedElement>();
            hasSortedConstants = new boolean[]{true};
            if (this instanceof RfArchitecture && (entity = ((RfArchitecture)this).getEntity()) != null) {
                List<? extends RfNamedElement> entityLocalParameters = entity.getLocalParameters();
                localParameters.addAll(entityLocalParameters);
                localPortListParameters.addAll(entityLocalParameters);
                localConstants.addAll(localParameters);
            }
            if ((members = this.getLocalMembers(true)) != null) break block20;
            this.fCachedArguments = localArguments.isEmpty() ? Collections.emptyList() : localArguments;
            this.fCachedRecordElements = localRecordElements.isEmpty() ? Collections.emptyList() : localRecordElements;
            List<Object> list = this.fCachedParameters = localParameters.isEmpty() ? Collections.emptyList() : localParameters;
            List<RfNamedElement> list2 = localPortListParameters.size() == localParameters.size() ? this.fCachedParameters : (this.fCachedPortListParameters = localPortListParameters.isEmpty() ? Collections.emptyList() : localPortListParameters);
            if (!localConstants.isEmpty()) {
                if (!hasSortedConstants[0]) {
                    Collections.sort(localConstants, new Comparator<RfNamedElement>(){

                        @Override
                        public int compare(RfNamedElement o1, RfNamedElement o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            RfNamedElement o1EnclosingScope = o1.getEnclosingScope();
                            RfNamedElement o2EnclosingScope = o2.getEnclosingScope();
                            if (DesignUtils.isVHDLEntity((IRfNamedElement)o1EnclosingScope) && !DesignUtils.isVHDLEntity((IRfNamedElement)o2EnclosingScope)) {
                                return -1;
                            }
                            if (!DesignUtils.isVHDLEntity((IRfNamedElement)o1EnclosingScope) && DesignUtils.isVHDLEntity((IRfNamedElement)o2EnclosingScope)) {
                                return 1;
                            }
                            RfDefElement o2Decl = o2.getDeclaration();
                            if (o2Decl == null) {
                                return 1;
                            }
                            boolean isBefore = o1.isBefore(o2);
                            return isBefore ? -1 : 1;
                        }
                    });
                    this.fCachedConstants = localConstants;
                } else {
                    this.fCachedConstants = localConstants.size() == this.fCachedParameters.size() ? this.fCachedParameters : localConstants;
                }
            } else {
                this.fCachedConstants = Collections.emptyList();
            }
            return;
        }
        try {
            for (RfNamedElement member : members) {
                Collection<RfNamedElement> members2;
                RfNamedElement.cacheElement(member, localArguments, localRecordElements, localParameters, localPortListParameters, localConstants, hasSortedConstants);
                if (member instanceof RfDuplicate) {
                    members2 = member.getMembers();
                    if (members2 == null) continue;
                    for (RfNamedElement member2 : members2) {
                        RfNamedElement.cacheElement(member2, localArguments, localRecordElements, localParameters, localPortListParameters, localConstants, hasSortedConstants);
                    }
                    continue;
                }
                if (!(member instanceof RfFunctionsHolder) || (members2 = member.getMembers()) == null) continue;
                for (RfNamedElement member2 : members2) {
                    RfNamedElement.cacheElement(member2, localArguments, localRecordElements, localParameters, localPortListParameters, localConstants, hasSortedConstants);
                }
            }
        }
        catch (Throwable throwable) {
            this.fCachedArguments = localArguments.isEmpty() ? Collections.emptyList() : localArguments;
            this.fCachedRecordElements = localRecordElements.isEmpty() ? Collections.emptyList() : localRecordElements;
            List<Object> list = this.fCachedParameters = localParameters.isEmpty() ? Collections.emptyList() : localParameters;
            List<RfNamedElement> list3 = localPortListParameters.size() == localParameters.size() ? this.fCachedParameters : (this.fCachedPortListParameters = localPortListParameters.isEmpty() ? Collections.emptyList() : localPortListParameters);
            if (!localConstants.isEmpty()) {
                if (!hasSortedConstants[0]) {
                    Collections.sort(localConstants, new /* invalid duplicate definition of identical inner class */);
                    this.fCachedConstants = localConstants;
                } else {
                    this.fCachedConstants = localConstants.size() == this.fCachedParameters.size() ? this.fCachedParameters : localConstants;
                }
            } else {
                this.fCachedConstants = Collections.emptyList();
            }
            throw throwable;
        }
        this.fCachedArguments = localArguments.isEmpty() ? Collections.emptyList() : localArguments;
        this.fCachedRecordElements = localRecordElements.isEmpty() ? Collections.emptyList() : localRecordElements;
        List<Object> list = this.fCachedParameters = localParameters.isEmpty() ? Collections.emptyList() : localParameters;
        List<RfNamedElement> list4 = localPortListParameters.size() == localParameters.size() ? this.fCachedParameters : (this.fCachedPortListParameters = localPortListParameters.isEmpty() ? Collections.emptyList() : localPortListParameters);
        if (!localConstants.isEmpty()) {
            if (!hasSortedConstants[0]) {
                Collections.sort(localConstants, new /* invalid duplicate definition of identical inner class */);
                this.fCachedConstants = localConstants;
            } else {
                this.fCachedConstants = localConstants.size() == this.fCachedParameters.size() ? this.fCachedParameters : localConstants;
            }
        } else {
            this.fCachedConstants = Collections.emptyList();
        }
    }

    static final void cacheElement(RfNamedElement member, List<RfVariable> localArguments, List<RfVariable> localRecordElements, List<RfNamedElement> localParameters, List<RfNamedElement> localPortListParameters, List<RfNamedElement> localConstants, boolean[] hasSortedConstants) {
        if (member instanceof RfVariable) {
            RfVariable variable = (RfVariable)member;
            if (variable.isArgument()) {
                localArguments.add(variable);
            } else if (variable.isRecordElement()) {
                localRecordElements.add(variable);
            } else if (variable.isEnumElement()) {
                if (hasSortedConstants[0] && !localConstants.isEmpty()) {
                    hasSortedConstants[0] = hasSortedConstants[0] & RfNamedElement.internalFastCheckIsSorted(localConstants.get(localConstants.size() - 1), member);
                }
                localConstants.add(variable);
            } else if (variable.isParameter()) {
                localParameters.add(variable);
                localPortListParameters.add(variable);
                if (hasSortedConstants[0] && !localConstants.isEmpty()) {
                    hasSortedConstants[0] = hasSortedConstants[0] & RfNamedElement.internalFastCheckIsSorted(localConstants.get(localConstants.size() - 1), member);
                }
                localConstants.add(variable);
            } else if (variable.isConstant()) {
                localParameters.add(variable);
                if (hasSortedConstants[0] && !localConstants.isEmpty()) {
                    hasSortedConstants[0] = hasSortedConstants[0] & RfNamedElement.internalFastCheckIsSorted(localConstants.get(localConstants.size() - 1), member);
                }
                localConstants.add(variable);
            }
        } else if (member instanceof RfType && ((RfType)member).isGeneric() || member instanceof RfFunction && ((RfFunction)member).isGeneric()) {
            localParameters.add(member);
            localPortListParameters.add(member);
            if (hasSortedConstants[0] && !localConstants.isEmpty()) {
                hasSortedConstants[0] = hasSortedConstants[0] & RfNamedElement.internalFastCheckIsSorted(localConstants.get(localConstants.size() - 1), member);
            }
            localConstants.add(member);
        }
    }

    private static boolean internalFastCheckIsSorted(RfNamedElement prev, RfNamedElement next) {
        RfDefElement prevDeclaration = prev.getDeclaration();
        RfDefElement nextDeclaration = next.getDeclaration();
        return prevDeclaration != null && nextDeclaration != null && prevDeclaration.getParserPath() != null && prevDeclaration.getParserPath().equals((Object)nextDeclaration.getParserPath()) && prevDeclaration.getStartOffset() < nextDeclaration.getStartOffset();
    }

    public IRfPortElement getPortWithPrefix(String prefix, int matchType) {
        return this.getPortWithPrefix(prefix, matchType, true);
    }

    public List<? extends IRfPortElement> getPortsWithPrefix(String prefix, int matchType) {
        return this.getPortsWithPrefix(prefix, matchType, true);
    }

    public Collection<? extends IRfPortElement> getLocalInterfacePorts() {
        return null;
    }

    public void addEnumElement(RfEnum enumElement) {
        String key;
        List<RfEnum> existing;
        if (this.fEnumValuesMap == null) {
            this.fEnumValuesMap = new LinkedHashMap<String, List<RfEnum>>();
        }
        if ((existing = this.fEnumValuesMap.get(key = enumElement.getKey())) == null) {
            existing = new ArrayList<RfEnum>();
            this.fEnumValuesMap.put(key, existing);
        }
        existing.add(enumElement);
    }

    @NotNull
    public Collection<IRfNamedElement> getEnumTypeCandidates(String enumValue, boolean exitWhenFirstFound) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        this.internalGetEnumTypeCandidates(enumValue.startsWith("'") ? enumValue : enumValue.toLowerCase(), result, true, exitWhenFirstFound);
        return result;
    }

    protected void internalGetEnumTypeCandidates(String enumValue, List<IRfNamedElement> result, boolean traverseScope, boolean exitWhenFirstFound) {
        RfNamedElement enclosingScope;
        List<ImportInfo> explicitUses;
        this.internalGetLocalEnumCandidates(enumValue, result);
        if (exitWhenFirstFound && !result.isEmpty()) {
            return;
        }
        List<ImportInfo> wildcardUses = this.getWildcardUse();
        if (wildcardUses != null) {
            for (ImportInfo use : wildcardUses) {
                IRfNamedElement usedElement = use.getElement();
                if (!(usedElement instanceof RfNamedElement)) continue;
                ((RfNamedElement)usedElement).internalGetLocalEnumCandidates(enumValue, result);
            }
        }
        if ((explicitUses = this.getExplicitUse()) != null) {
            Set<RfNamedElement> enclosingScopes = Collections.newSetFromMap(new IdentityHashMap());
            for (ImportInfo use : explicitUses) {
                IRfNamedElement usedElement = use.getElement();
                if (usedElement instanceof RfScalarType && (((RfScalarType)usedElement).isEnumType() || ((RfScalarType)usedElement).hasPhysicalUnits())) {
                    enclosingScopes.add((RfNamedElement)usedElement.getEnclosingScope());
                    continue;
                }
                if (usedElement instanceof RfContext) {
                    ((RfContext)usedElement).internalGetEnumTypeCandidates(enumValue, result, traverseScope, exitWhenFirstFound);
                    continue;
                }
                if (!(usedElement instanceof RfNamedElement)) continue;
                enclosingScopes.add((RfNamedElement)usedElement);
            }
            for (RfNamedElement importInfo : enclosingScopes) {
                importInfo.internalGetLocalEnumCandidates(enumValue, result);
            }
        }
        if (exitWhenFirstFound && !result.isEmpty()) {
            return;
        }
        if (traverseScope && (enclosingScope = this.getEnclosingScope()) != null) {
            enclosingScope.internalGetEnumTypeCandidates(enumValue, result, traverseScope, exitWhenFirstFound);
        }
    }

    protected void internalGetLocalEnumCandidates(String name, List<IRfNamedElement> result) {
        if (this.fEnumValuesMap != null && this.fEnumValuesMap.containsKey(name)) {
            result.addAll((Collection<IRfNamedElement>)this.fEnumValuesMap.get(name));
        }
    }

    @NotNull
    public Map<String, IRfNamedElement> getLocalEnumCandidatesByType(RfScalarType type) {
        if (type == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, IRfNamedElement> result = new LinkedHashMap<String, IRfNamedElement>();
        for (RfEnum elem : this.getLocalMembers(RfEnum.class)) {
            if (!type.equals(elem.getParentEnumType())) continue;
            result.put(elem.getName(), elem);
        }
        return result;
    }

    protected RfProject getCachedRfProject(IRfNamedElement type1, IRfNamedElement type2) {
        RfProject rfProject;
        if (this.fRfProject != null) {
            return this.fRfProject;
        }
        RfProject rfProject2 = rfProject = type1 instanceof RfNamedElement ? ((RfNamedElement)type1).getRfProject() : null;
        if (rfProject == null) {
            if (type2 instanceof RfNamedElement && ((RfNamedElement)type2).getRfProject() != null) {
                rfProject = ((RfNamedElement)type2).getRfProject();
            } else {
                return null;
            }
        }
        this.fRfProject = rfProject;
        return rfProject;
    }

    protected void computeConstants(ELManager manager, ELParamValues working) {
        ELParamValuesHidEvaluator evaluator = working.getHidEvaluator(manager);
        IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, (IRfNamedElement)this, null, (boolean)false, (ELManager)manager);
        List<HidOperatorWrapper> initialAssigns = this.getSortedAssignsToComputeConstants();
        if (initialAssigns == null || initialAssigns.isEmpty()) {
            return;
        }
        boolean markElabOperators = manager.markElabHidObjects();
        for (HidOperatorWrapper operatorWithPath : initialAssigns) {
            IRfFieldElement candidateField;
            IHidObject lhValue;
            HidOperator operator = (HidOperator)operatorWithPath.hidObject;
            if (markElabOperators) {
                operator.addQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER);
            }
            if (!((lhValue = operator.getLHValue()) instanceof IHid)) continue;
            String hidName = ((IHid)lhValue).getName();
            IRfNamedElement candidate = null;
            if (operator.hasQualifier(HidQualifierCache.IS_HIDDEN_QUALIFIER)) {
                ISDataType dataType;
                IRfNamedElement type;
                ISDataAbstract resolvedType = operator.getOperatorResolvedType();
                if (resolvedType != null && (type = (dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType)).getType()) instanceof RfScalarType && ((RfScalarType)type).isEnumType()) {
                    candidate = ((RfScalarType)type).getEnclosingScope().getLocalEnum(hidName, type.getName(), false);
                }
            } else {
                candidate = this.semanticGetMember(hidName, null, null, this, this, true, true, false);
            }
            if (!(candidate instanceof IRfFieldElement) || !ELUtils.isVHDLConstant((IRfNamedElement)(candidateField = (IRfFieldElement)candidate))) continue;
            String paramName = candidateField.getElabName(false);
            if (working.containsKey(paramName)) {
                manager.logger.debug(ElaborationDebugZone.EVAL, "Found existing constant:", new Object[]{candidate.getNameAndEnclosing()});
                continue;
            }
            IHidObject valueHidObject = operator.getFirstRHValue();
            if (valueHidObject == null) continue;
            IELParamValue finalValue = null;
            if (candidateField.getInterfaceKind() == 2) {
                finalValue = IELParamValue.UNDEFINED_VALUE;
            } else {
                IRfDefElement declaration;
                BitVectorContext context = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)candidateField, null, (ELManager)manager);
                finalValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)valueHidObject, (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
                if (finalValue == null && (declaration = candidateField.getDeclaration()) != null) {
                    String pattern = ELUtils.isVHDLEnumName((IRfNamedElement)candidateField) ? "UNRESOLVED_ENUM_NAME_VALUE: Cannot determine value of enum name ''{1}'' from expression: {2}" : "UNRESOLVED_CONSTANT_VALUE: Cannot determine {0} value of constant ''{1}'' from expression: {2}";
                    int startOffset = declaration.getStartOffset();
                    int endOffset = startOffset + hidName.length();
                    int line = declaration.getStartLine();
                    manager.reportProblem(ElaborationDebugZone.SECOND_PASS, true, pattern, (IRfNamedElement)candidateField, declaration, startOffset, endOffset, line, null, null, new Object[]{"default", hidName, HidUtils.toNiceStringVHDL((IHidObject)valueHidObject)});
                }
            }
            working.putDirectly(paramName, finalValue);
        }
    }

    protected List<HidOperatorWrapper> getSortedAssignsToComputeConstants() {
        HidOperatorVisitorWithPaths visitor = new HidOperatorVisitorWithPaths(ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY);
        this.visitHidObjectsLocalAndEnums((IHidVisitor<?>)visitor);
        List initialAssigns = visitor.getObjectsWithPaths();
        if (initialAssigns == null || initialAssigns.isEmpty()) {
            return null;
        }
        if (!visitor.hasSortedResults()) {
            Collections.sort(initialAssigns, HidOperatorVisitorWithPaths.OPERATOR_WRAPPER_COMPARATOR);
        }
        return initialAssigns;
    }

    protected final boolean visitHidObjectsLocalAndEnums(IHidVisitor<?> visitor) {
        block6: {
            RfHidHolder hidHolder;
            if (!this.hasHidObjects() || (hidHolder = this.getHidHolder()).visitHidObject(null, visitor)) break block6;
            return false;
        }
        try {
            Collection<RfNamedElement> members = this.getMembers();
            if (members != null) {
                for (RfNamedElement member : members) {
                    if (!(member instanceof RfAlias) && (!(member instanceof RfScalarType) || !((RfScalarType)member).isEnumType())) continue;
                    member.visitHidObject(null, visitor);
                }
            }
        }
        catch (OperationCanceledException | BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean checkTypeCompatibility(IRfNamedElement second) {
        RfProject rfProject = this.getCachedRfProject(this, second);
        if (rfProject == null) {
            return true;
        }
        IRfNamedElement firstType = STransformer.INSTANCE.getBaseType(this, false);
        IRfNamedElement secondType = STransformer.INSTANCE.getBaseType(second, false);
        if (firstType == null || secondType == null) {
            return false;
        }
        if (firstType.equals(secondType)) {
            return true;
        }
        if (firstType == SDataAbstracts.OPEN_DUMMY || secondType == SDataAbstracts.OPEN_DUMMY) {
            return true;
        }
        if (firstType == SDataAbstracts.NULL_IMPLICIT || secondType == SDataAbstracts.NULL_IMPLICIT) {
            return true;
        }
        if (firstType == SDataAbstracts.NEW_IMPLICIT || secondType == SDataAbstracts.NEW_IMPLICIT) {
            return true;
        }
        if (firstType instanceof RfType && ((RfType)firstType).isGeneric() || secondType instanceof RfType && ((RfType)secondType).isGeneric()) {
            return true;
        }
        IRfNamedElement anyAccessType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_ACCESS);
        if (firstType.equals(anyAccessType)) {
            return secondType instanceof RfType && ((RfType)secondType).isAccess();
        }
        if (secondType.equals(anyAccessType)) {
            return firstType instanceof RfType && ((RfType)firstType).isAccess();
        }
        IRfNamedElement anyType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE);
        if (firstType.equals(anyType) || secondType.equals(anyType)) {
            return true;
        }
        if (firstType instanceof RfAssociatedType.RfUnresolvedInfo || secondType instanceof RfAssociatedType.RfUnresolvedInfo) {
            return firstType.equals(secondType);
        }
        IRfNamedElement anyFileType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_FILE);
        if (firstType.equals(anyFileType)) {
            return secondType instanceof RfType && ((RfType)secondType).isFile();
        }
        if (secondType.equals(anyFileType)) {
            return firstType instanceof RfType && ((RfType)firstType).isFile();
        }
        IRfNamedElement anyScalarOrArrayType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_SCALAR_OR_ARRAY);
        if (firstType.equals(anyScalarOrArrayType)) {
            return secondType instanceof RfScalarType || secondType instanceof RfListType;
        }
        if (secondType.equals(anyScalarOrArrayType)) {
            return firstType instanceof RfScalarType || firstType instanceof RfListType;
        }
        IRfNamedElement anyCharacterType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER);
        if (firstType.equals(anyCharacterType)) {
            return secondType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.CHARACTER)) || secondType instanceof RfScalarType && ((RfScalarType)secondType).isEnumType();
        }
        if (secondType.equals(anyCharacterType)) {
            return firstType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.CHARACTER)) || firstType instanceof RfScalarType && ((RfScalarType)firstType).isEnumType();
        }
        if (firstType == SDataAbstracts.ANY_AGGREGATE) {
            return secondType instanceof RfRecordType || secondType instanceof RfListType;
        }
        if (secondType == SDataAbstracts.ANY_AGGREGATE) {
            return firstType instanceof RfRecordType || firstType instanceof RfListType;
        }
        if (firstType instanceof RfListType && secondType instanceof RfAnyListType || secondType instanceof RfListType && firstType instanceof RfAnyListType) {
            boolean characterLiteralCompatibility;
            boolean arrayElementTypeCompatibility;
            RfListType secondListType;
            boolean isSecondOneDimensional;
            RfListType firstListType = (RfListType)firstType;
            boolean isFirstOneDimensional = firstListType.isOneDimensional();
            if (isFirstOneDimensional ^ (isSecondOneDimensional = (secondListType = (RfListType)secondType).isOneDimensional())) {
                return false;
            }
            IRfNamedElement firstAssocType = firstListType.getAssociatedType();
            IRfNamedElement secondAssocType = secondListType.getAssociatedType();
            boolean bl = arrayElementTypeCompatibility = firstAssocType != null && firstAssocType.checkTypeCompatibility(secondAssocType) || secondAssocType != null && secondAssocType.equals(firstAssocType);
            boolean bl2 = anyCharacterType.equals(firstAssocType) && secondAssocType instanceof RfScalarType ? ((RfAnyListType)firstType).checkWithContext((RfScalarType)secondAssocType) : (characterLiteralCompatibility = anyCharacterType.equals(secondAssocType) && firstAssocType instanceof RfScalarType ? ((RfAnyListType)secondType).checkWithContext((RfScalarType)firstAssocType) : true);
            return arrayElementTypeCompatibility && characterLiteralCompatibility;
        }
        IRfNamedElement integerType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.INTEGER);
        IRfNamedElement realType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.REAL);
        IRfNamedElement physicalType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_PHYSICAL);
        if (firstType instanceof RfScalarType) {
            RfScalarType firstScalar = (RfScalarType)firstType;
            if (firstScalar.equals(integerType) && secondType instanceof RfScalarType && ((RfScalarType)secondType).isNumericType()) {
                return !((RfScalarType)secondType).hasFloatingRange() && !((RfScalarType)secondType).hasPhysicalUnits();
            }
            if (firstType.equals(realType) && secondType instanceof RfScalarType && ((RfScalarType)secondType).isNumericType()) {
                return ((RfScalarType)secondType).hasFloatingRange();
            }
            if (firstScalar.equals(physicalType)) {
                return secondType instanceof RfScalarType && ((RfScalarType)secondType).hasPhysicalUnits();
            }
        }
        if (secondType instanceof RfScalarType) {
            RfScalarType secondScalar = (RfScalarType)secondType;
            if (secondScalar.equals(integerType) && firstType instanceof RfScalarType && ((RfScalarType)firstType).isNumericType()) {
                return !((RfScalarType)firstType).hasFloatingRange() && !((RfScalarType)firstType).hasPhysicalUnits();
            }
            if (secondType.equals(realType) && firstType instanceof RfScalarType && ((RfScalarType)firstType).isNumericType()) {
                return ((RfScalarType)firstType).hasFloatingRange();
            }
            if (secondScalar.equals(physicalType)) {
                return firstType instanceof RfScalarType && ((RfScalarType)firstType).hasPhysicalUnits();
            }
        }
        return false;
    }

    public void init(String name) {
        if (name != null) {
            this.fName = name;
            this.fLowerCaseName = name.toLowerCase();
        }
    }

    public void setCachedBaseType(IRfNamedElement resolvedBaseType) {
        this.fCachedBaseType = resolvedBaseType;
    }

    public IRfNamedElement getCachedBaseType() {
        if (this.fCachedBaseType != null && this.fCachedBaseType.hasNoDefs(false)) {
            this.fCachedBaseType = null;
        }
        return this.fCachedBaseType;
    }

    public void addReference(String typeName) {
        RfLibrary library = this.getEnclosingLibrary();
        if (library == null) {
            return;
        }
        library.addReference(typeName, (IRfNamedElement)this);
    }

    public void addReference(DataType dataType) {
        RfLibrary library = this.getEnclosingLibrary();
        if (library == null) {
            return;
        }
        library.addReference(dataType, (IRfNamedElement)this);
    }

    public int hashCode() {
        return RfElementPath.segmentHashCode(this.getCustomClass(), (String)this.getCustomName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RfNamedElement)) {
            return false;
        }
        return RfNamedElement.equals(this, (RfNamedElement)obj);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean equals(RfNamedElement element1, RfNamedElement element2) {
        if (element1 != element2) ** GOTO lbl10
        return true;
lbl-1000:
        // 1 sources

        {
            if (element1.getCustomClass() != element2.getCustomClass()) {
                return false;
            }
            name1 = element1.getCustomName();
            if (name1 == null || !name1.equals(element2.getCustomName())) {
                return false;
            }
            element1 = element1.getEnclosingScope();
            element2 = element2.getEnclosingScope();
lbl10:
            // 2 sources

            ** while (element1 != null && element2 != null && !(element1 instanceof RfProject) && !(element2 instanceof RfProject))
        }
lbl11:
        // 1 sources

        if (element1 instanceof RfProject && element2 instanceof RfProject) {
            return true;
        }
        return element1 == null && element2 == null;
    }

    public String getCustomName() {
        return this.getName();
    }

    public RfNamedElement internalThis() {
        return this;
    }

    public String getFullNameLabel() {
        RfLibrary enclosingLibrary = this.getEnclosingLibrary();
        if (enclosingLibrary == null) {
            return String.valueOf(this.printScope()) + this.getName();
        }
        String enclosingLibraryName = enclosingLibrary.getName();
        if (enclosingLibraryName == null || enclosingLibraryName.isEmpty()) {
            return String.valueOf(this.printScope()) + this.getName();
        }
        return enclosingLibraryName + "." + this.printScope() + this.getName();
    }

    public void setCompileInfo(VhdlCompileInfo compileInfo) {
        this.compileInfo = compileInfo;
    }

    public VhdlCompileInfo getCompileInfo() {
        return this.compileInfo;
    }

    public int getDeclarationIndex() {
        return this.compileInfo == null ? -1 : this.compileInfo.getCompileIndex();
    }

    public int getInvocNumber() {
        return this.compileInfo == null ? -1 : this.compileInfo.getInvocNumber();
    }

    public boolean isBefore(ImportInfo importInfo) {
        if (importInfo == null) {
            return true;
        }
        VhdlCompileInfo info = importInfo.getCompileInfo();
        return this.isBefore(info != null ? info.getCompileIndex() : -1, importInfo.getLine(), importInfo.getOffset());
    }

    public boolean isBefore(RfNamedElement usageElement) {
        if (usageElement == null) {
            return true;
        }
        RfDefElement usageDeclaration = usageElement.getDeclaration();
        if (usageDeclaration == null) {
            return true;
        }
        int useLine = usageDeclaration.getStartLine();
        int useOffset = usageDeclaration instanceof RfVariableDef ? ((RfVariableDef)usageDeclaration).getDeclEndOffset() : usageDeclaration.getStartOffset();
        int useIndex = usageElement.getDeclarationIndex();
        return this.isBefore(useIndex, useLine, useOffset);
    }

    public boolean isBefore(int useIndex, int useLine, int useOffset) {
        int declOffset;
        int declIndex = this.getDeclarationIndex();
        if (declIndex < 0 || useIndex < 0) {
            return true;
        }
        if (declIndex != useIndex) {
            return declIndex < useIndex;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return true;
        }
        int declLine = declaration.getStartLine();
        int n = declOffset = declaration instanceof RfVariableDef ? ((RfVariableDef)declaration).getDeclEndOffset() : declaration.getStartOffset();
        if (useLine < 0 || useOffset < 0) {
            return true;
        }
        return declLine == useLine ? declOffset < useOffset : declLine < useLine;
    }

    public int getInducedParametricDependencyValue() {
        return 1;
    }

    public IRfNamedElement xGetMember(String name) {
        IRfNamedElement member = this.getLocalMember((Set)null, name, (IRfNamedElement)null);
        if (member != null) {
            return member;
        }
        IRfClassElement parent = this.xGetParent();
        if (parent == null) {
            return null;
        }
        return parent.xGetMember(name);
    }

    public IRfMethodElement xGetLocalMethod(String name) {
        RfFunctionsHolder holder = this.getFunctionHolderWithPrefix(name, 9, true);
        if (holder == null) {
            return null;
        }
        List<RfFunction> functions = holder.getLocalMembers(RfFunction.class);
        if (functions != null && !functions.isEmpty()) {
            return (IRfMethodElement)functions.iterator().next();
        }
        return null;
    }

    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members == null || members.isEmpty()) {
            return null;
        }
        return members.values();
    }

    public void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members == null || members.isEmpty()) {
            return;
        }
        for (RfNamedElement member : members.values()) {
            if (member.isAnonymous()) continue;
            result.add(DVTStringUtil.intern((String)member.getName().toLowerCase()));
        }
    }

    public IRfNamedElement xGetLocalParameter(String parameterName) {
        RfVariable parameter = this.getLocalMember(RfVariable.class, parameterName);
        if (parameter != null) {
            return parameter;
        }
        return null;
    }
}

