/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.text.MessageFormat;

public enum RfNonStandardProblem {
    KEYWORD_AS_IDENTIFIER("Reserved keyword ''{0}'' not allowed as identifier", "report reference;\nreport procedural;"),
    USE_CLAUSE_PACKAGE("Unexpected package ''{0}.{1}'' in use clause", "use ieee.STD_LOGIC_MISC.all;");

    private ProblemKind kind = ProblemKind.NON_STANDARD;
    private String message;
    private String example;
    private boolean isStrict;

    private RfNonStandardProblem(String message, String example) {
        this(ProblemKind.NON_STANDARD, message, example, false);
    }

    private RfNonStandardProblem(ProblemKind kind, String message, String example, boolean isStrict) {
        this.kind = kind;
        this.message = message;
        this.example = example;
        this.isStrict = isStrict;
    }

    public String getMessage(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return this.message;
        }
        return MessageFormat.format(this.message, arguments);
    }

    public String getExample() {
        return this.example;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public String getID() {
        return this.kind.getKindID();
    }

    private static enum ProblemKind {
        NON_STANDARD("NON_STANDARD_"),
        UNSPECIFIED_STANDARD("UNSPECIFIED_STANDARD_");

        private String kindID;

        private ProblemKind(String id) {
            this.kindID = id;
        }

        public String getKindID() {
            return this.kindID;
        }
    }
}

