/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfPackage
extends RfAssociatedType
implements IRfPackageElement {
    private static final long serialVersionUID = 1L;
    public static final int SIMPLE_PACKAGE = 0;
    public static final int UNINSTANTIATED_PACKAGE = 1;
    public static final int GENERIC_MAPPED_PACKAGE = 2;
    public static final String STD_LOGIC_1164_PACKAGE_NAME = "std_logic_1164";
    public static final String STD_LOGIC_ARITH_PACKAGE_NAME = "std_logic_arith";
    private final ReentrantLock elabConstantsLock = new ReentrantLock(false);
    private transient byte semanticEnable;
    private int packageKind;

    public RfPackage(String name) {
        super(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN);
    }

    public String getSignature() {
        return "package " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public IRfNamedElement getImportedSymbol(String symbolName) {
        HashMap resultMap = new HashMap(1);
        this.getMembersWithPrefix(resultMap, symbolName, true, 1);
        return resultMap.isEmpty() ? null : (IRfNamedElement)resultMap.values().iterator().next();
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        boolean equals;
        this.internalGetMembersWithPrefix(result, RfType.class, prefix, null, first, matchType, true);
        boolean bl = equals = (matchType & 1) != 0;
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfComponent.class, prefix, null, first, matchType, true);
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfVariable.class, prefix, null, first, matchType, true);
        if ((equals || first) && !result.isEmpty()) {
            return;
        }
        this.internalGetMembersWithPrefix(result, RfFunctionsHolder.class, prefix, null, first, matchType, true);
    }

    public byte getSemanticEnableRaw() {
        return this.semanticEnable;
    }

    public void setSemanticEnable(byte enable) {
        if (enable > this.semanticEnable) {
            this.semanticEnable = enable;
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PACKAGE: Duplicate package ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public boolean isUninstantiated() {
        return this.packageKind == 1;
    }

    public void setPackageKind(int packageKind) {
        this.packageKind = packageKind;
    }

    public IRfPackageElement getPackage() {
        return this;
    }

    public RfPackageBody getPackageBody() {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope == null) {
            return null;
        }
        return enclosingScope.getLocalMember(RfPackageBody.class, this.getName());
    }

    public boolean hasPackageBody() {
        return this.getPackageBody() != null;
    }

    @Override
    public String getAssociatedTypeName() {
        return this.getName();
    }

    public void elaborateConstants(ELManager manager) {
        if (manager == null) {
            return;
        }
        if (manager.isPermanentAfterElaboration()) {
            return;
        }
        if (manager.isControlNoParamEval()) {
            return;
        }
        this.elabConstantsLock.lock();
        try {
            if (manager.isPermanentElaboration() && this.getSemanticEnableRaw() == 3) {
                return;
            }
            if (manager.getExternalConstants((IRfNamedElement)this) != null) {
                return;
            }
            ELParamValues working = ELParamValues.create((boolean)false);
            manager.addExternalConstants((IRfNamedElement)this, working);
            byte semanticEnableRaw = manager.getSemanticEnableRaw();
            if (manager.isPermanentElaboration() && semanticEnableRaw == 3) {
                this.setSemanticEnable(semanticEnableRaw);
                this.elaborateImportedPackages(manager);
                RfProject rfProject = this.getRfProject();
                RfLibrary enclosingLibrary = this.getEnclosingLibrary();
                ConfigInfo configInfo = new ConfigInfo(false, rfProject, enclosingLibrary, false, rfProject.getToolCompat());
                ELParamValues externalConstants = manager.getExternalConstants((IRfNamedElement)this);
                configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)(externalConstants == null ? ELParamValues.EMPTY : externalConstants), null, (ELManager)manager));
                FullChecksAndLibs fullCompileChecks = manager.getFullChecksAndLibs();
                Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
                FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
                if (onlyLibAndPkgNames != null && !enclosingLibrary.isPredefined()) {
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                        return;
                    }
                    if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                        return;
                    }
                    Set onlyPkgNames = (Set)onlyLibAndPkgNames.get(enclosingLibrary.getName());
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) {
                        return;
                    }
                }
                this.resolveHids(configInfo, !this.isPredefined(), false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            }
            this.computeConstants(manager, working);
            manager.addExternalConstants((IRfNamedElement)this, ELUtils.getValidParamValues((ELParamValues)working));
            RfPackageBody packageBody = this.getPackageBody();
            if (packageBody != null) {
                packageBody.elaborateConstants(manager);
            }
        }
        finally {
            this.elabConstantsLock.unlock();
        }
    }

    public void elaborateImportedPackages(ELManager manager) {
        if (manager.getSemanticEnableRaw() != 3) {
            return;
        }
        NullProtectedList<ImportInfo> importDeclarations = this.getAllImportDeclarations();
        if (importDeclarations == null || importDeclarations.isEmpty()) {
            return;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (ImportInfo importDeclaration : importDeclarations) {
            IRfNamedElement imported = importDeclaration.getImportedElement();
            if (!(imported instanceof IRfConstantsHolder) || visited.contains(imported)) continue;
            visited.add(imported);
            ((IRfConstantsHolder)imported).elaborateConstants(manager);
        }
    }

    public void cleanElaborationInfo() {
        this.semanticEnable = 0;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RfPackageBody && ((RfPackageBody)obj).getPackage() == this) {
            return true;
        }
        return super.checkEquals(obj);
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        DVTLinkedHashMap<String, RfNamedElement> bodyMembers = null;
        RfPackageBody packageBody = this.getPackageBody();
        if (packageBody != null) {
            bodyMembers = packageBody.getLocalMembers(true);
        }
        if (members == null || members.isEmpty()) {
            if (bodyMembers == null || bodyMembers.isEmpty()) {
                return null;
            }
            return bodyMembers.values();
        }
        if (bodyMembers == null || bodyMembers.isEmpty()) {
            return members.values();
        }
        ArrayList result = new ArrayList(members.size() + bodyMembers.size());
        result.addAll(members.values());
        result.addAll(bodyMembers.values());
        return result;
    }

    @Override
    public void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members.values()) {
                if (member.isAnonymous()) continue;
                result.add(DVTStringUtil.intern((String)member.getName()));
            }
        }
        DVTLinkedHashMap<String, RfNamedElement> bodyMembers = null;
        RfPackageBody packageBody = this.getPackageBody();
        if (packageBody != null) {
            bodyMembers = packageBody.getLocalMembers(true);
        }
        if (bodyMembers != null && !bodyMembers.isEmpty()) {
            for (RfNamedElement member : bodyMembers.values()) {
                if (member.isAnonymous()) continue;
                result.add(DVTStringUtil.intern((String)member.getName()));
            }
        }
    }
}

