/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IMembersProvider;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfPackageBody
extends RfAssociatedType
implements IRfPackageElement {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock elabConstantsLock = new ReentrantLock(false);
    private transient RfPackage fPackage = null;
    private transient byte semanticEnable;

    public RfPackageBody(String name) {
        super(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN);
    }

    public String getSignature() {
        return "package body " + this.getName();
    }

    public RfPackage getPackage() {
        if (this.fPackage != null && !this.fPackage.hasNoDefs(false)) {
            return this.fPackage;
        }
        this.fPackage = this.getPackageWithPrefix(this.getName(), 9);
        return this.fPackage;
    }

    public IRfPackageElement getPackageBody() {
        return this;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    protected <T extends IRfNamedElement> void internalMXGetMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        RfPackage thePackage = this.getPackage();
        if (thePackage == null) {
            return;
        }
        thePackage.internalMXGetMembersWithPrefix(result, prefix, first, matchType);
    }

    public void elaborateConstants(ELManager manager) {
        if (manager == null) {
            return;
        }
        if (manager.isPermanentAfterElaboration()) {
            return;
        }
        this.elabConstantsLock.lock();
        try {
            if (manager.isPermanentElaboration() && this.getSemanticEnableRaw() == 3) {
                return;
            }
            if (manager.getExternalConstants((IRfNamedElement)this) != null) {
                return;
            }
            ELParamValues working = ELParamValues.create((boolean)false);
            manager.addExternalConstants((IRfNamedElement)this, working);
            RfPackage rfPackage = this.getPackage();
            if (rfPackage != null) {
                rfPackage.elaborateConstants(manager);
            }
            byte semanticEnableRaw = manager.getSemanticEnableRaw();
            if (manager.isPermanentElaboration() && semanticEnableRaw == 3) {
                this.setSemanticEnable(semanticEnableRaw);
                this.elaborateImportedPackages(manager);
                RfProject rfProject = this.getRfProject();
                RfLibrary enclosingLibrary = this.getEnclosingLibrary();
                ConfigInfo configInfo = new ConfigInfo(false, rfProject, enclosingLibrary, false, rfProject.getToolCompat());
                ELParamValues externalConstants = manager.getExternalConstants((IRfNamedElement)this);
                configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)(externalConstants == null ? ELParamValues.EMPTY : externalConstants), null, (ELManager)manager));
                FullChecksAndLibs fullCompileChecks = manager.getFullChecksAndLibs();
                Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
                FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
                if (onlyLibAndPkgNames != null && !enclosingLibrary.isPredefined()) {
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                        return;
                    }
                    if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(enclosingLibrary.getName())) {
                        return;
                    }
                    Set onlyPkgNames = (Set)onlyLibAndPkgNames.get(enclosingLibrary.getName());
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) {
                        return;
                    }
                }
                this.resolveHids(configInfo, true, false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            }
            this.computeConstants(manager, working);
            ELParamValues resolvedPackage = manager.getExternalConstants((IRfNamedElement)rfPackage);
            if (resolvedPackage == null || resolvedPackage.isEmpty()) {
                resolvedPackage = working;
            } else {
                resolvedPackage.putAll(working);
            }
            manager.addExternalConstants((IRfNamedElement)this, ELUtils.getValidParamValues((ELParamValues)resolvedPackage));
        }
        finally {
            this.elabConstantsLock.unlock();
        }
    }

    public void elaborateImportedPackages(ELManager manager) {
        if (manager.getSemanticEnableRaw() != 3) {
            return;
        }
        NullProtectedList<ImportInfo> importDeclarations = this.getAllImportDeclarations();
        if (importDeclarations == null || importDeclarations.isEmpty()) {
            return;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        for (ImportInfo importDeclaration : importDeclarations) {
            IRfNamedElement imported = importDeclaration.getImportedElement();
            if (!(imported instanceof IRfConstantsHolder) || visited.contains(imported)) continue;
            visited.add(imported);
            ((IRfConstantsHolder)imported).elaborateConstants(manager);
        }
    }

    @Override
    protected IRfNamedElement getMemberInUseClauses(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        RfPackage thePackage;
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getExplicitUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext && (result = ((RfContext)element).getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null) {
                    return result;
                }
                if (element == exclude || element == null || classes != null && !classes.contains(element.getClass())) continue;
                if (element instanceof RfNamedElement && name.equalsIgnoreCase(element.getName())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        if ((useList = this.getWildcardUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element != null) {
                    result = element.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                }
                if (result == null || result == exclude) continue;
                return result;
            }
        }
        if ((thePackage = this.getPackage()) != null) {
            IRfNamedElement element2;
            useList = thePackage.getExplicitUse();
            if (useList != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfContext && (result = ((RfContext)element2).getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null) {
                        return result;
                    }
                    if (element2 == exclude || element2 == null || classes != null && !classes.contains(element2.getClass())) continue;
                    if (element2 instanceof RfNamedElement && name.equalsIgnoreCase(element2.getName())) {
                        return element2;
                    }
                    if (!(element2 instanceof RfType) || (result = ((RfType)element2).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element2.getName()), isFirst, isLast, true, false)) == null) continue;
                    return result;
                }
            }
            if ((useList = thePackage.getWildcardUse()) != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 != null) {
                        result = element2.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                    }
                    if (result == null || result == exclude) continue;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    protected IRfNamedElement getLocalMember(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        IMembersProvider membersProvider = scope -> {
            IRfNamedElement result = scope.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
            if (result == exclude) {
                result = null;
            }
            if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
                result = null;
            }
            return result;
        };
        IRfNamedElement result = membersProvider.getLocalMember((IRfNamedElement)this);
        if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
            return null;
        }
        if (result != null && result != exclude) {
            return result;
        }
        RfPackage thePackage = this.getPackage();
        if (thePackage != null && (result = membersProvider.getLocalMember((IRfNamedElement)thePackage)) != null && result != exclude) {
            return result;
        }
        return null;
    }

    @Override
    protected <Z extends IRfNamedElement, T extends IRfNamedElement> void internalGetMembersWithPrefix(Map<String, Z> result, Class<T> localMemberKind, String prefix, String enumParentTypeName, boolean first, int matchType, boolean local) {
        super.internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, true);
        boolean equals = (matchType & 1) != 0;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        if (localMemberKind != RfFunctionsHolder.class && ((equals || first) && size > 0 || limit100 && size >= 100)) {
            return;
        }
        RfPackage thePackage = this.getPackage();
        if (thePackage != null) {
            thePackage.internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, true);
        }
        if (local) {
            return;
        }
        super.internalGetMemberWithPrefixInUseClauses(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        if (localMemberKind != RfFunctionsHolder.class && ((equals || first) && size > 0 || limit100 && size >= 100)) {
            return;
        }
        if (thePackage != null) {
            thePackage.internalGetMemberWithPrefixInUseClauses(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        }
        if (localMemberKind != RfFunctionsHolder.class && ((equals || first) && size > 0 || limit100 && size >= 100)) {
            return;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (enclosingScope != null) {
            enclosingScope.internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        }
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        Set<Class<RfComponent>> classes;
        IRfNamedElement result;
        if (visited != null) {
            if (visited.contains(this)) {
                return null;
            }
            visited.add(this);
        }
        if ((result = this.getLocalMember(classes = hid == null || !hid.hasOccurrence(HidQualifierCache.COMPONENT_TYPE) ? DVTRfUtils.MEMBERS_OTHERS : Collections.singleton(RfComponent.class), name, (IRfNamedElement)null)) != null) {
            return result;
        }
        RfPackage thePackage = this.getPackage();
        if (thePackage == null) {
            return null;
        }
        if (visited != null) {
            if (visited.contains(thePackage)) {
                return null;
            }
            visited.add(thePackage);
        }
        result = thePackage.getLocalMember(classes, name, (IRfNamedElement)null);
        return result;
    }

    @Override
    public IRfNamedElement semanticGetMemberInUseClauses(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        RfPackage thePackage;
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfNamedElement) {
                    result = ((RfNamedElement)element).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
                } else if (element instanceof IRfLibraryElement) {
                    result = ((IRfLibraryElement)element).getDesignWithPrefix(name, 9);
                }
                if (result == null) continue;
                return result;
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext) {
                    result = ((RfContext)element).semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
                    if (result == null) continue;
                    return result;
                }
                if (!(element instanceof RfNamedElement)) continue;
                if (DVTStringUtil.regionMatches((String)element.getName(), (String)name, (int)9) && DVTRfUtils.MEMBERS_OTHERS.contains(element.getClass())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        if ((thePackage = this.getPackage()) != null) {
            IRfNamedElement element2;
            useList = thePackage.getWildcardUse();
            if (useList != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfNamedElement) {
                        result = ((RfNamedElement)element2).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
                    } else if (element2 instanceof IRfLibraryElement) {
                        result = ((IRfLibraryElement)element2).getDesignWithPrefix(name, 9);
                    }
                    if (result == null) continue;
                    return result;
                }
            }
            if ((useList = thePackage.getExplicitUse()) != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfContext) {
                        result = ((RfContext)element2).semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
                        if (result == null) continue;
                        return result;
                    }
                    if (!(element2 instanceof RfNamedElement)) continue;
                    if (DVTStringUtil.regionMatches((String)element2.getName(), (String)name, (int)9) && DVTRfUtils.MEMBERS_OTHERS.contains(element2.getClass())) {
                        return element2;
                    }
                    if (!(element2 instanceof RfType) || (result = ((RfType)element2).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element2.getName()), isFirst, isLast, true, false)) == null) continue;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    public void internalGetResolvedGenericMap(Map<String, IRfNamedElement> result) {
        super.internalGetResolvedGenericMap(result);
        RfPackage thePackage = this.getPackage();
        if (thePackage != null) {
            thePackage.internalGetResolvedGenericMap(result);
        }
    }

    @Override
    protected void internalGetEnumTypeCandidates(String name, List<IRfNamedElement> result, boolean traverseScope, boolean isPhysical) {
        RfPackage thePackage = this.getPackage();
        super.internalGetEnumTypeCandidates(name, result, thePackage == null ? traverseScope : false, isPhysical);
        if (thePackage != null) {
            thePackage.internalGetEnumTypeCandidates(name, result, traverseScope, isPhysical);
        }
    }

    @Override
    public List<RfPackage> getPackagesWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getPackagesWithPrefix(prefix, matchType);
    }

    @Override
    public RfPackage getPackageWithPrefix(String prefix, int matchType) {
        if (this.getEnclosingScope() == null) {
            return null;
        }
        return this.getEnclosingScope().getPackageWithPrefix(prefix, matchType);
    }

    public byte getSemanticEnableRaw() {
        return this.semanticEnable;
    }

    public void setSemanticEnable(byte enable) {
        if (enable > this.semanticEnable) {
            this.semanticEnable = enable;
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PACKAGE_BODY: Duplicate package body ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.PACKAGE_BLUE);
    }

    public void cleanElaborationInfo() {
        this.semanticEnable = 0;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fPackage = null;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this || obj == this.fPackage) {
            return true;
        }
        return super.checkEquals(obj);
    }

    @Override
    public String getAssociatedTypeName() {
        return this.getName();
    }

    @Override
    protected List<RfPackage> getPackageUses() {
        List<RfPackage> result = super.getPackageUses();
        RfPackage parentPackage = this.getPackage();
        if (parentPackage != null) {
            result.addAll(parentPackage.getPackageUses());
        }
        return result;
    }

    public IRfNamedElement getImportedSymbol(String symbolName) {
        return this.fPackage != null ? this.fPackage.getImportedSymbol(symbolName) : null;
    }

    public <T extends IRfNamedElement> void getMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        if (this.fPackage == null) {
            return;
        }
        this.fPackage.getMembersWithPrefix(result, prefix, first, matchType);
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        IRfNamedElement result = super.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, parserPath, line);
        if (result != null) {
            return result;
        }
        RfPackage thePackage = this.getPackage();
        if (thePackage != null && (result = thePackage.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, null, -1)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public Collection<? extends IRfNamedElement> xGetLocalMembers() {
        DVTLinkedHashMap<String, RfNamedElement> members = this.getLocalMembers(true);
        DVTLinkedHashMap<String, RfNamedElement> packMembers = null;
        RfPackage pack = this.getPackage();
        if (pack != null) {
            packMembers = pack.getLocalMembers(true);
        }
        if (members == null || members.isEmpty()) {
            if (packMembers == null || packMembers.isEmpty()) {
                return null;
            }
            return packMembers.values();
        }
        if (packMembers == null || packMembers.isEmpty()) {
            return members.values();
        }
        ArrayList result = new ArrayList(members.size() + packMembers.size());
        result.addAll(members.values());
        result.addAll(packMembers.values());
        return result;
    }

    @Override
    public void xCollectMemberNames(Set<String> result, boolean isAddPredefined) {
        DVTLinkedHashMap<String, RfNamedElement> packageBody = this.getLocalMembers(true);
        if (packageBody != null && !packageBody.isEmpty()) {
            for (RfNamedElement member : packageBody.values()) {
                if (member.isAnonymous()) continue;
                result.add(DVTStringUtil.intern((String)member.getName()));
            }
        }
        DVTLinkedHashMap<String, RfNamedElement> members = null;
        RfPackage pack = this.getPackage();
        if (pack != null) {
            members = pack.getLocalMembers(true);
        }
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members.values()) {
                if (member.isAnonymous()) continue;
                result.add(DVTStringUtil.intern((String)member.getName()));
            }
        }
    }

    public boolean isPackageBody() {
        return true;
    }
}

