/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class RfPort
extends RfVariable
implements IRfPortElement {
    private static final long serialVersionUID = 1L;

    public RfPort(String name, String direction, DataType dataType, String initialValue) {
        super(name, 4, 8192, direction, dataType, initialValue);
    }

    public void init(String direction, DataType dataType, String initialValue, String name) {
        super.init(name, 4, 8192, direction, dataType, initialValue);
    }

    @Override
    public String getSignature() {
        String range = this.getRange() == null || this.getRange().isEmpty() ? "" : "(" + this.getRange() + ")";
        return "port " + this.getName() + " : " + this.getDirection() + " " + this.getAssociatedTypeName() + range;
    }

    @Override
    public Image getImage() {
        if (this.isInput()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INPUT_PORT);
        }
        if (this.isOutput()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_OUTPUT_PORT);
        }
        if (this.isInout()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
        }
        if (this.isBuffer()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_BUFFER_PORT);
        }
        if (this.isLinkage()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_LINKAGE_PORT);
        }
        return super.getImage();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PORT: Duplicate port ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RfPort)) {
            return false;
        }
        if (((RfPort)obj).getName().equalsIgnoreCase(this.getName())) {
            RfNamedElement objEnclosingScope = ((RfPort)obj).getEnclosingScope();
            RfNamedElement enclosingScope = this.getEnclosingScope();
            return objEnclosingScope.checkEquals(enclosingScope);
        }
        return false;
    }

    public String getContextInformationSignature() {
        String range = this.getRange() == null || this.getRange().isEmpty() ? "" : "(" + this.getRange() + ")";
        return String.valueOf(this.getName()) + " : " + this.getDirection() + " " + this.getAssociatedTypeName() + range;
    }

    public String getDirectionString() {
        String direction = this.getDirection();
        return direction != null ? direction : "";
    }
}

