/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.trace.connections.model.TCLogic;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidUtils;

public class RfProcess
extends RfNamedElement
implements IRfActionBlockElement {
    private static final long serialVersionUID = 2L;
    public static final String PROCESS = "process";
    private boolean fIsAllSensitivityList;
    private transient Map<String, IHid> fSensitivityList;
    private static final long LOGIC_QUALIFIER = HidUtils.toQualifiersSet((HidOperatorQualifier[])DesignUtils.VHDL_PROCESS_LOGIC);

    public RfProcess(String name, boolean isAllSensitivityList) {
        super(name);
        this.init(isAllSensitivityList, name);
    }

    public void init(boolean isAllSensitivityList, String name) {
        this.fIsAllSensitivityList = isAllSensitivityList;
        this.init(name);
    }

    public String getSignature() {
        return "process " + this.getName();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.action";
    }

    public String getViewName() {
        if (this.isAnonymous()) {
            return "[anonymous]";
        }
        return this.getName();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_PROCESS: Duplicate process ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public boolean hasBlockQualifier(IRfActionBlockElement.BlockQualifier qualifier) {
        return IRfActionBlockElement.BlockQualifier.PROCESS == qualifier;
    }

    public boolean hasBlockQualifier(long qualifiers) {
        return (IRfActionBlockElement.BlockQualifier.PROCESS.value() & qualifiers) != 0L;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.fSensitivityList = null;
    }

    public List<IRfNamedElement> getSensitivityListSignals() {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        if (this.fSensitivityList == null || this.fSensitivityList.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, IHid> arg : this.fSensitivityList.entrySet()) {
            result.add(arg.getValue().getElement());
        }
        return result;
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        HashMap<String, Object> attributes;
        int line;
        int endOffset;
        String name;
        int startOffset;
        HidOccurrence occurrence;
        super.resolveHids(configInfo, triggerError, disableExprEvaluate, skipMemberClasses);
        if (this.fIsAllSensitivityList || configInfo.disableRTLChecks) {
            return;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return;
        }
        RfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return;
        }
        if (this.fSensitivityList == null) {
            this.fSensitivityList = DesignUtils.getVHDLSensitivityListDrivers((IRfNamedElement)this, (boolean)true);
        }
        Map<String, IHid> drivers = this.getProcessDrivers();
        LinkedHashMap<String, IHid> superfluousDrivers = new LinkedHashMap<String, IHid>(this.fSensitivityList);
        superfluousDrivers.keySet().removeAll(drivers.keySet());
        Map<String, IHid> missingDrivers = drivers;
        missingDrivers.keySet().removeAll(this.fSensitivityList.keySet());
        LibraryPackageScope libraryPackageScope = this.getLibPkgScope();
        if (!missingDrivers.isEmpty()) {
            for (IHid missingDriver : missingDrivers.values()) {
                occurrence = missingDriver.getOccurrence();
                if (occurrence == null) continue;
                startOffset = occurrence.getOffset();
                name = missingDriver.getName();
                endOffset = startOffset + name.length();
                line = occurrence.getLine();
                attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                attributes.put("QUICKFIX_KIND", 2);
                ((RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature")).addSemanticError(2, "SENSITIVITY_MISSING: Missing ''{0}'' from sensitivity list", libraryPackageScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
            }
        }
        if (!superfluousDrivers.isEmpty()) {
            for (IHid superfuousDriver : superfluousDrivers.values()) {
                occurrence = superfuousDriver.getOccurrence();
                if (occurrence == null) continue;
                startOffset = occurrence.getOffset();
                name = superfuousDriver.getName();
                endOffset = startOffset + name.length();
                line = occurrence.getLine();
                attributes = new HashMap(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", name);
                attributes.put("QUICKFIX_KIND", 3);
                ((RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature")).addSemanticError(2, "SENSITIVITY_UNUSED: The process is not sensitive to ''{0}''", libraryPackageScope, startOffset, endOffset, attributes, line, declaration.getParserPath(), name);
            }
        }
    }

    private Map<String, IHid> getProcessDrivers() {
        TCLogic logic = new TCLogic();
        Collection commonDrivers = logic.getCommonDrivers();
        final ArrayList seqOperators = new ArrayList();
        final ArrayList combOperators = new ArrayList();
        final BiConsumer<IRfNamedElement, Collection> argConsumer = (functionArgument, rhHids) -> {
            if (!(functionArgument instanceof IRfFieldElement) || rhHids == null || rhHids.isEmpty()) {
                return;
            }
            if (((IRfFieldElement)functionArgument).isOutput()) {
                return;
            }
            commonDrivers.addAll(rhHids);
        };
        IHidVisitor<IHidObject> visitor = new IHidVisitor<IHidObject>(){
            RfFunction outerFunctionScope;

            public boolean visit(IHidObject hidObject) {
                if (this.outerFunctionScope != null) {
                    return true;
                }
                if (HidUtils.isOperator((IHidObject)hidObject) && ((HidOperator)hidObject).hasOccurrence(LOGIC_QUALIFIER)) {
                    HidOperator operator = (HidOperator)hidObject;
                    LinkedHashSet hids = new LinkedHashSet();
                    DesignUtils.collectVHDLClockEventHids((IHidOperator)operator, hids, (boolean)true);
                    if (!hids.isEmpty()) {
                        seqOperators.add(operator);
                        return false;
                    }
                    combOperators.add(operator);
                } else if (HidUtils.isHid((IHidObject)hidObject) && ((Hid)hidObject).isMethodCall(false)) {
                    RfHidUtils.consumeMethodCallArguments((IHid)((Hid)hidObject), argConsumer, true);
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            public void setScope(IRfNamedElement scope) {
                if (this.outerFunctionScope == null && scope instanceof RfFunction) {
                    this.outerFunctionScope = (RfFunction)scope;
                }
            }

            public void endScope(IRfNamedElement scope) {
                if (this.outerFunctionScope != null && this.outerFunctionScope == scope) {
                    this.outerFunctionScope = null;
                }
            }
        };
        this.visitHidObject(null, visitor);
        commonDrivers.addAll(DesignUtils.getVHDLClockEventHids(seqOperators, (boolean)false));
        for (IHidOperator operator : combOperators) {
            DesignUtils.collectConcurrentDriversAndLoads((IHidOperator)operator, (TCLogic)logic, (Set)DesignUtils.ASSIGN_HID_FLATTENING);
        }
        return DesignUtils.mapProcessDriversVHDL((IRfNamedElement)this, (TCLogic)logic, (boolean)true);
    }
}

