/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigUtils;
import ro.amiq.dvt.buildconfig.CheckIdKind;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalChecksKind;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.UnelaboratedChecksKind;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.IELProject;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.persistence.VersionChangedException;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.reflection.DVTImplicitConfiguration;
import ro.amiq.dvt.model.reflection.DVTPackageConfiguration;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMixedNamedElementVisitorProxy;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.Identifier;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.QFileCompileInfo;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorAttributes;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.InsensitiveLinkedMap;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.builders.VhdlBuilderUtils;
import ro.amiq.vhdldt.interpreter.factory.XVhdlValueHolderFactory;
import ro.amiq.vhdldt.model.IVhdlModule;
import ro.amiq.vhdldt.model.IVhdlProject;
import ro.amiq.vhdldt.model.VhdlFileInfo;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.floatingwidgets.VhdlFNotificationProvider;
import ro.amiq.vhdldt.model.persistence.Persistence;
import ro.amiq.vhdldt.model.reflection.ArgInfo;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.FileReferenceGraph;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IRfFileListener;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.PredefinedTypeHolder;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAnyListType;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAttribute;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.vhdldt.model.reflection.RfDefElementWithLabel;
import ro.amiq.vhdldt.model.reflection.RfDuplicate;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfGeneratesContainer;
import ro.amiq.vhdldt.model.reflection.RfImplicitDef;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfPortDef;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfPropertySequence;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfRulesContainer;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.RfVariableDef;
import ro.amiq.vhdldt.model.reflection.semantic.RfSemanticError;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.OperatorScopeCache;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.parser.VhdlAMS;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;
import ro.amiq.vhdldt.r2lparser.R2LUtils;
import ro.amiq.vhdldt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.vhdldt.ui.syntaxerrors.SyntaxErrorsManager;

public class RfProject
extends RfNamedElement
implements IRfSingleLangProject,
IELProject {
    private static final long serialVersionUID = 1914L;
    private static final String TEMP_LIBRARY_NAME = "non-top-files";
    public static final String EXTENSIONS_PREFIX = "__extensions__";
    public static final String IEEE_EXTENSIONS_08 = "ieee_predefined_08.vhd";
    public static final String IEEE_EXTENSIONS_93 = "ieee_predefined_93.vhd";
    public static final String STD_EXTENSIONS_08 = "std_predefined_08.vhd";
    public static final String STD_EXTENSIONS_93 = "std_predefined_93.vhd";
    public static final String VHDL_STD_LIB = "std";
    public static final String VHDL_STD_LIB_08 = "std_08";
    public static final String VHDL_STD_LIB_93 = "std_93";
    public static final String VHDL_STANDARD_PACKAGE = "standard";
    public static final String VHDL_IEEE_LIB = "ieee";
    public static final String VHDL_IEEE_LIB_08 = "ieee_08";
    public static final String VHDL_IEEE_LIB_93 = "ieee_93";
    public static final String VITAL2000_LIB = "VITAL2000";
    private RfProjectContent fRfProjectContent = new RfProjectContent();
    private transient RfCompiledFiles fRfCompiledFiles = new RfCompiledFiles();
    private transient RfFileDef fCurrentFileDef;
    private transient long fLastFullBuildStartTime;
    private transient long fLastFullBuildDuration;
    private transient long fLastFullBuildStartMemory;
    private transient long fLastFullBuildMemoryAllocation;
    private transient IBuildConfigParserConstants.UsageBeforeDeclarationScope orderAnalysisScope;
    private transient IncrementalDeltaContainer fIncrementalDeltaContainer;
    private transient Deque<IHidHolder> fOverridedHidHolder;
    private transient boolean fDisableMissingOthersChoice;
    private transient boolean fDisableRedundantOthersChoice;
    private transient boolean fPackageConstantsDisabled;
    private transient FullChecksAndLibs fFullCompileChecks;
    private transient boolean fOverrideRegisterHids;
    private transient IProject fProject;
    private transient boolean fIncrementalBuild;
    private transient Map<ParserPath, DVTEditor> fParserPathToEditorMap;
    private transient Deque<RfNamedElement> fScopeStack;
    private transient String fBuildConfig;
    private transient RfMixedLangProject fMixedLangProjectParent;
    private transient RfLibrary fCurrentLibrary;
    private transient String fCurrentLibraryName;
    private transient String fCurrentPackageName;
    private transient boolean fBuildPending;
    private transient UnelaboratedChecksKind fUnelaboratedCompileChecks;
    private transient RfGUIUtils fGUIUtils;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient int fNofBuildCanceledQueries;
    private transient boolean fCachedBuildCanceled;
    private transient ExecutorService fExecutorService;
    private transient RfProjectState fProjectState = RfProjectState.NEW;
    private transient Object fSemanticErrorsLock = new Object();
    private transient IRfSingleLangProject.SemanticErrorsCategory fSemanticErrorCategory;
    private transient SemanticErrorsTable fSemanticErrors;
    private transient int fMaxNofSemanticProblemsPerFile;
    private transient DVTPFModel fPowerFormatModel;
    private transient ChangedFilesManager fChangedFilesManager;
    private transient Map<ParserPath, List<IRfFileListener>> fParserPathToListenerMap;
    private transient FileReferenceGraph fFileRefGraph;
    private static String[] fPredefinedLibrariesFiles;
    private transient IIdleListener fIdleListener;
    private static transient AtomicInteger fCount1;
    private static transient AtomicInteger fCount2;
    private static transient AtomicInteger fCount3;
    private static transient AtomicInteger fCount4;

    static {
        fCount1 = new AtomicInteger(0);
        fCount2 = new AtomicInteger(0);
        fCount3 = new AtomicInteger(0);
        fCount4 = new AtomicInteger(0);
    }

    private int getMaxSemanticIssuesPerFile() {
        return ro.amiq.vhdldt.test.TestHelper.isTestMode() && ro.amiq.vhdldt.test.TestHelper.isUsingMaxIntSemanticIssuesPerFile() ? Integer.MAX_VALUE : this.fMaxNofSemanticProblemsPerFile;
    }

    public static boolean isPredefined(ParserPath path) {
        if (path == null) {
            return false;
        }
        return RfProject.isPredefined(path.path);
    }

    public static boolean isPredefined(String name) {
        if (name == null) {
            return false;
        }
        return name.endsWith("__extensions__ieee_predefined_08.vhd") || name.endsWith("__extensions__ieee_predefined_93.vhd") || name.endsWith("__extensions__std_predefined_08.vhd") || name.endsWith("__extensions__std_predefined_93.vhd");
    }

    public IRfProjectContent getRfProjectContent() {
        return this.fRfProjectContent;
    }

    public void setRfProjectContent(IRfProjectContent rfProjectContent) {
        this.fRfProjectContent = (RfProjectContent)rfProjectContent;
        this.fRfProjectContent.opCache = new OperatorScopeCache();
    }

    public void restoreInvocationsInfo(IRfProjectContent rfProjectContent, RfCompiledFiles compilesFiles, Map<String, BCFileInstance> buildConfigFiles) {
        if (compilesFiles == null) {
            return;
        }
        VhdlFileInstancesMap fileInstancesMap = this.fRfProjectContent.fFileInstancesMap;
        if (fileInstancesMap == null) {
            return;
        }
        for (ParserPath parserPath : compilesFiles.fCompiledFiles) {
            List<VhdlFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
            if (fileInstances == null) continue;
            for (VhdlFileInstance fileInstance : fileInstances) {
                BuildConfigUtils.sendIndexToBCFiles((int)fileInstance.getIndex(), (LanguageKind)LanguageKind.VHDL, (int)fileInstance.getInvocNumber(), buildConfigFiles);
            }
        }
    }

    public RfCompiledFiles getRfCompiledFiles() {
        this.fRfCompiledFiles.fCompiledFiles = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return this.fRfCompiledFiles;
    }

    public void setRfCompiledFiles(RfCompiledFiles rfCompiledFiles) {
        this.fRfCompiledFiles = rfCompiledFiles;
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        this.fNofBuildCanceledQueries = 0;
        this.fCachedBuildCanceled = false;
    }

    public boolean isCompiled(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null || this.fRfProjectContent.fParserPath2FileDefMap.isEmpty()) {
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                return this.fRfCompiledFiles.fCompiledFiles.contains(parserPath);
            }
            return false;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.containsKey(parserPath);
    }

    private boolean isBuildCanceled() {
        if (FIncrementalNotificationTracker.INSTANCE.isUpdating(this.fProject)) {
            return FIncrementalNotificationFixer.INSTANCE.isCanceled();
        }
        if (this.fGUIUtils != null && this.fGUIUtils.isCancelChecking()) {
            FIncrementalNotificationTracker.INSTANCE.confirmTransientSemanticDirtyCandidate(this.getProject());
            return true;
        }
        FIncrementalNotificationTracker.INSTANCE.resetTransientSemanticDirtyCandidates(this.getProject());
        if (this.fBuildProgressMonitor == null) {
            return false;
        }
        return this.fBuildProgressMonitor.isCanceled();
    }

    public void checkBuildCanceled() throws BuildCancelException {
        this.checkBuildCanceled(false);
    }

    public void checkBuildCanceled(boolean force) throws BuildCancelException {
        if (force || this.fNofBuildCanceledQueries % 5000 == 0) {
            this.fCachedBuildCanceled = this.isBuildCanceled();
        }
        ++this.fNofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.fCachedBuildCanceled) {
            DVTLogger.INSTANCE.logDebug("### VHDL SEMANTIC CANCELED BY USER ###");
            throw new BuildCancelException();
        }
    }

    public void setLastFullBuildStartTime() {
        this.fLastFullBuildStartTime = System.currentTimeMillis();
    }

    public long getLastFullBuildDuration() {
        return this.fLastFullBuildDuration;
    }

    private void updateDuration() {
        long tmp = System.currentTimeMillis();
        this.fLastFullBuildDuration = (tmp - this.fLastFullBuildStartTime) / 1000L;
    }

    public void setLastFullBuildStartMemory() {
        this.fLastFullBuildStartMemory = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
    }

    public long getLastFullBuildMemoryAllocation() {
        return Math.round((double)this.fLastFullBuildMemoryAllocation / 1048576.0);
    }

    private void updateMemoryAllocation() {
        long tmp = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
        this.fLastFullBuildMemoryAllocation = tmp - this.fLastFullBuildStartMemory;
    }

    public IncrementalDeltaContainer getIncrementalDeltaContainer() {
        return this.fIncrementalDeltaContainer;
    }

    public RfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        super("");
        this.init(project, null, true);
        this.compilePredefinedLibraries();
        this.setMixedLangProjectParent(rfMixedLangProject);
    }

    public Set<ParserPath> getCompiledFilesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParserPath> result = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return result;
    }

    public Set<IResource> getCompiledFileResourcesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        Collection<RfFileDef> fileDefs = this.fRfProjectContent.fParserPath2FileDefMap.values();
        if (fileDefs == null || fileDefs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IResource> result = new HashSet<IResource>();
        for (RfFileDef fileDef : fileDefs) {
            IResource adapter = fileDef.getFileAdapter();
            if (adapter == null) continue;
            result.add(adapter);
        }
        return result;
    }

    public boolean hasSomethingToCompile() {
        return this.fRfProjectContent.fParserPath2FileDefMap != null && !this.fRfProjectContent.fParserPath2FileDefMap.keySet().isEmpty();
    }

    public void setMixedLangProjectParent(RfMixedLangProject rfMixedLangProject) {
        this.fMixedLangProjectParent = rfMixedLangProject;
        this.fMixedLangProjectParent.cleanElaborationManagers();
    }

    public void init(IProject project, IDVTRfManager rfManager, boolean shouldRunSemanticChecks) {
        this.fProject = project;
        this.fOverridedHidHolder = new ArrayDeque<IHidHolder>();
        this.fGUIUtils = new RfGUIUtils();
        this.fIncrementalBuild = false;
        this.fFileRefGraph = new FileReferenceGraph(this);
        this.fIncrementalDeltaContainer = null;
        this.fSemanticErrorsLock = new Object();
        this.fSemanticErrors = new SemanticErrorsTable();
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new VhdlFileInstancesMap(this);
        }
        if (this.fRfProjectContent.fLibraries == null) {
            this.fRfProjectContent.fLibraries = new InsensitiveLinkedMap();
        }
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            this.fRfProjectContent.fParserPath2FileDefMap = new LinkedHashMap<ParserPath, RfFileDef>();
        }
        if (this.fRfProjectContent.fToolCompat == null) {
            this.fRfProjectContent.fToolCompat = IBuildConfigParserConstants.ToolCompat.DVT;
        }
        if (this.fRfProjectContent.opCache == null) {
            this.fRfProjectContent.opCache = new OperatorScopeCache();
        }
        IncrementalElaborationKind defaultIncrementalElaborationKind = TestHelper.isTestMode() ? IncrementalElaborationKind.FULL : IncrementalElaborationKind.ADAPTIVE;
        this.setElaborationEnabled(defaultIncrementalElaborationKind);
        if (this.fScopeStack == null) {
            this.fScopeStack = new ArrayDeque<RfNamedElement>();
            this.fScopeStack.push(this);
        }
        if (this.fWildcardUses == null) {
            this.fWildcardUses = new ArrayList();
        }
        this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        this.setDisabledChecks();
        ro.amiq.vhdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
    }

    public VhdlFileInstancesMap getFileInstancesMap() {
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new VhdlFileInstancesMap(this);
        }
        return this.fRfProjectContent.fFileInstancesMap;
    }

    public OperatorScopeCache getOperatorScopeCache() {
        return this.fRfProjectContent.opCache;
    }

    public void restoreMixedLangProjectPreElab(IProgressMonitor monitor) {
        this.setBuildProgressMonitor(monitor);
        try {
            this.fFileRefGraph = new FileReferenceGraph(this);
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
            this.resolveUses(this, true, true, true);
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES}, false, false);
            Collection<RfLibrary> libraries = this.getLibraries();
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            if (fullChecksKind != FullChecksKind.OFF) {
                boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES;
                this.resolveTypes2(libraries, true, true, true, fullChecksKind, onlyLibAndPkgNames, disableRTLChecks);
                this.resolveHidsPredefinedLibraries(libraries);
            } else {
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES;
                this.resolveTypesPredefinedLibraries(libraries);
                this.resolveHidsPredefinedLibraries(libraries);
            }
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void restoreMixedLangProjectPostElab(IProgressMonitor monitor) {
        try {
            try {
                this.checkBuildCanceled(true);
                Collection<RfLibrary> libraries = this.getLibraries();
                FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
                FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
                Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
                if (fullChecksKind != FullChecksKind.OFF) {
                    boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                    this.checkForDuplicates(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                    this.checkUnused(libraries, (Enum<FullChecksKind>)fullChecksKind, onlyLibAndPkgNames, false, true, disableRTLChecks, null);
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                    this.checkUsageBefore(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                }
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
                this.checkCustomPragmas(this.fRfCompiledFiles.fCompiledFiles);
                this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES, IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, false, false);
                ro.amiq.vhdldt.utils.Utils.refreshMarkers(this);
                this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    for (Map.Entry<ParserPath, DVTEditor> entry : this.fParserPathToEditorMap.entrySet()) {
                        DVTEditor editor;
                        ParserPath parserPath = entry.getKey();
                        RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
                        if (fileDef == null || (editor = entry.getValue()) == null) continue;
                        ro.amiq.vhdldt.utils.Utils.startHighlight(fileDef, editor);
                    }
                }
                this.updateBreadcrumbs();
            }
            catch (BuildCancelException buildCancelException) {
                this.setBuildProgressMonitor(null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.setBuildProgressMonitor(null);
            }
        }
        finally {
            this.setBuildProgressMonitor(null);
        }
    }

    private void updateBreadcrumbs() {
        if (this.fMixedLangProjectParent.getSingleLangProject(LanguageKind.VLOG.NATURE_ID) != null) {
            return;
        }
        Job updateJob = new Job("Updating Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    ro.amiq.vhdldt.utils.Utils.startUpdateBreadcrumbs((DVTEditor)editor);
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule();
    }

    public void removeMixedLangProject() {
        IProject project = this.fProject;
        VhdlModelManager.getInstance().saveUnfinishedJobs(project);
        this.clean(false);
        this.fProjectState = RfProjectState.NEW;
        VhdlModelManager.getInstance().cbClean(project, false);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getSignature() {
        return "";
    }

    public boolean isExprEvaluatorDisabled() {
        return false;
    }

    @Override
    protected void removeDirtyElements(ParserPath parserPath, RfProject project) {
        if (this.fRfProjectContent.fLibraries != null) {
            this.removeDirtyElements(this.fRfProjectContent.fLibraries.values().iterator(), parserPath, project);
        }
    }

    public void addListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            ParserPath parserPath;
            if (this.fParserPathToListenerMap == null) {
                this.fParserPathToListenerMap = new HashMap<ParserPath, List<IRfFileListener>>();
            }
            if ((parserPath = this.resource2parser(resource)) == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                listeners = new ArrayList<IRfFileListener>();
                this.fParserPathToListenerMap.put(parserPath, listeners);
            }
            listeners.add(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            ParserPath parserPath = this.resource2parser(resource);
            if (parserPath == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyParsingEndUsingParserPath(Set<ParserPath> incrementalParserPaths) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            for (ParserPath incrementalParserPath : incrementalParserPaths) {
                List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(incrementalParserPath);
                if (listeners == null) {
                    return;
                }
                for (IRfFileListener listener : listeners) {
                    listener.notifyFileReparse(this.getFileDefUsingParserPath(incrementalParserPath));
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void connectFileToDocument(ParserPath parserPath, DVTEditor editor, boolean connectOnlyVisualPositions) {
        try {
            long time = System.currentTimeMillis();
            if (parserPath == null || editor == null) {
                return;
            }
            boolean isEditorVisible = editor.isVisible();
            if (!isEditorVisible && connectOnlyVisualPositions) {
                return;
            }
            if (this.fParserPathToEditorMap == null) {
                this.fParserPathToEditorMap = new HashMap<ParserPath, DVTEditor>();
            }
            this.fParserPathToEditorMap.put(parserPath, editor);
            RfFileDef file = this.getFileDefUsingParserPath(parserPath);
            if (file == null) {
                return;
            }
            IDocument document = editor.getDocument();
            boolean shouldAddFolding = document != null && document.getNumberOfLines() < ro.amiq.vhdldt.utils.Utils.getCodeFoldingNofLines();
            HashSet<DVTSemanticFoldingPosition> foldingPositions = new HashSet<DVTSemanticFoldingPosition>();
            ArrayList<Position> reflectionPositions = new ArrayList<Position>();
            file.connectPositionToDocument(foldingPositions, connectOnlyVisualPositions, isEditorVisible, reflectionPositions);
            if (isEditorVisible && document != null && shouldAddFolding) {
                DVTEditor.addSemanticFolding(foldingPositions, (DVTEditor)editor);
            }
            if (!connectOnlyVisualPositions && document != null) {
                DVTDocumentUtils.addDocumentPositions((IDocument)document, (String)"REFLECTION", reflectionPositions);
            }
            CustomPragmaUtils.notifyListeners((IProject)this.fProject);
            DVTLogger.INSTANCE.logDebug("DEBUG VHDL: Connect File to Document [" + (System.currentTimeMillis() - time) + " ms] - " + parserPath.path);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void disconnectFileFromDocument(ParserPath parserPath) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                if (this.fParserPathToEditorMap != null) {
                    this.fParserPathToEditorMap.remove(parserPath);
                }
                return;
            }
            fileDef.disconnectPositionFromDocument();
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            this.internalRemoveNonTopFile(parserPath, fileDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalRemoveNonTopFile(ParserPath parserPath, RfFileDef fileDef) {
        try {
            IRfSingleLangProject.SemanticErrorsCategory[] categories;
            String libraryName = fileDef.getLibraryName();
            if (!TEMP_LIBRARY_NAME.equals(libraryName)) {
                return;
            }
            RfLibrary library = this.getLocalLibrary(TEMP_LIBRARY_NAME);
            if (library == null) {
                return;
            }
            VhdlQuickViewersUtil.getInstance().removeWaitEditorJob((IFile)fileDef.getFileAdapter());
            this.cleanFile(parserPath, null);
            library.removeDirtyElements(parserPath, this);
            IRfSingleLangProject.SemanticErrorsCategory[] semanticErrorsCategoryArray = categories = IRfSingleLangProject.SemanticErrorsCategory.values();
            int n = categories.length;
            int n2 = 0;
            while (n2 < n) {
                IRfSingleLangProject.SemanticErrorsCategory category = semanticErrorsCategoryArray[n2];
                this.fSemanticErrors.clearFiles(category, this, Collections.singletonList(parserPath));
                ++n2;
            }
            ro.amiq.vhdldt.utils.Utils.refreshMarkers(this);
            ro.amiq.vhdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
            this.updatedSemanticErrors(categories, false, false);
            List emptyList = Collections.emptyList();
            SyntaxErrorsManager.getInstance().reparsed(0, 2, fileDef.getFileAdapter(), emptyList, emptyList, emptyList);
            if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
                this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            }
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath);
            }
            this.fScopeStack.remove(library);
            Collection<RfNamedElement> members = library.getMembers();
            if (members == null || members.isEmpty()) {
                this.fRfProjectContent.fLibraries.remove(TEMP_LIBRARY_NAME);
            }
            DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, this.fProject, ViewsUtils.ALL_BUT_DH_VIEWS);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfFileDef getFile(IResource file) {
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(file);
        if (parserPath == null) {
            return null;
        }
        return this.getFile(parserPath);
    }

    public RfFileDef getFile(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        if (parserPath == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    private void cleanSemanticErrors() {
        this.fSemanticErrors = new SemanticErrorsTable();
        ro.amiq.vhdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
    }

    public void setElaborationEnabled(IncrementalElaborationKind incrementalElaborationKind) {
        this.fRfProjectContent.fIncrementalElaborationKind = incrementalElaborationKind;
    }

    public boolean disableMissingOthersChoice() {
        return this.fDisableMissingOthersChoice;
    }

    public boolean disableRedundantOthersChoice() {
        return this.fDisableRedundantOthersChoice;
    }

    public void postFullBuild(boolean reportToConsole) {
        try {
            this.fCurrentFileDef = null;
            this.fGUIUtils.resetTimer();
            int nofCheck = 1;
            long time = 0L;
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
            this.fSemanticErrors.clearFiles(this.fSemanticErrorCategory, this, null);
            this.computeAutoConfiguredParserPaths();
            this.resolveUses(this, false, false, false);
            if (reportToConsole) {
                this.consolePrint("Performing post full build step " + nofCheck++ + " (VHDL - RU) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangFullBuildPreElab(FullChecksAndLibs fullChecksAndLibs, boolean reportToConsole) {
        try {
            long time = 0L;
            this.checkBuildCanceled(true);
            DVTThreadDumpCollectorAttributes profilingAttributes = BuildConfigManager.getProfilingAttributes((IProject)this.getProject());
            if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RU)) {
                DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RU), (String)"Start (VHDL - RU) build stage...");
            }
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
            this.resolveUses(this, true, true, true);
            if (reportToConsole) {
                this.consolePrint("Performing mixed post full build step (VHDL - RU) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
            }
            if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RU)) {
                DVTThreadDumpCollector.pause((String)"Finish (VHDL - RU) build stage...");
            }
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES}, true, reportToConsole);
            FullChecksKind fullChecksKind = fullChecksAndLibs.getFullChecksKind(false);
            Map onlyLibAndPkgNames = fullChecksAndLibs.getLibraryAndPackageNames(false);
            Collection<RfLibrary> libraries = this.getLibraries();
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            if (fullChecksKind != FullChecksKind.OFF) {
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT)) {
                    DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT), (String)"Start (VHDL - RT) build stage...");
                }
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES;
                this.resolveTypes2(libraries, true, true, true, fullChecksKind, onlyLibAndPkgNames, disableRTLChecks);
                this.resolveHidsPredefinedLibraries(libraries);
                if (reportToConsole) {
                    this.consolePrint("Performing mixed post full build step (VHDL - RT) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                }
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT)) {
                    DVTThreadDumpCollector.pause((String)"Finish (VHDL - RT) build stage...");
                }
            } else {
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT)) {
                    DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT), (String)"Start (VHDL - RT) build stage...");
                }
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES;
                this.resolveTypesPredefinedLibraries(libraries);
                this.resolveHidsPredefinedLibraries(libraries);
                if (reportToConsole) {
                    this.consolePrint("Performing mixed post full build step (VHDL - RT) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                }
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RT)) {
                    DVTThreadDumpCollector.pause((String)"Finish (VHDL - RT) build stage...");
                }
            }
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void resolveHidsPredefinedLibraries(Collection<RfLibrary> libraries) {
        if (libraries == null) {
            return;
        }
        boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
        for (RfLibrary library : libraries) {
            if (!library.isPredefined()) continue;
            this.initExecutorService(true);
            try {
                ConfigInfo configInfo = new ConfigInfo(this.fIncrementalBuild, this, library, disableRTLChecks, this.getToolCompat());
                configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, null, (ELManager)this.getELManager()));
                library.resolveHids(configInfo, true, true, false, FullChecksKind.FULL, null);
            }
            finally {
                this.shutdownExecutorService();
            }
        }
    }

    public void postMixedLangFullBuildPostElab(FullChecksAndLibs fullChecksAndLibs, boolean reportToConsole) {
        try {
            try {
                long time = 0L;
                this.checkBuildCanceled(true);
                FullChecksKind fullChecksKind = fullChecksAndLibs.getFullChecksKind(false);
                Map onlyLibAndPkgNames = fullChecksAndLibs.getLibraryAndPackageNames(false);
                DVTThreadDumpCollectorAttributes profilingAttributes = BuildConfigManager.getProfilingAttributes((IProject)this.getProject());
                if (fullChecksKind != FullChecksKind.OFF) {
                    Collection<RfLibrary> libraries = this.getLibraries();
                    boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RD)) {
                        DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RD), (String)"Start (VHDL - RD) build stage...");
                    }
                    time = System.currentTimeMillis();
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                    this.checkForDuplicates(libraries, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                    if (reportToConsole) {
                        this.consolePrint("Performing mixed post full build step (VHDL - RD) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_RD)) {
                        DVTThreadDumpCollector.pause((String)"Finish (VHDL - RD) build stage...");
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_US)) {
                        DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_US), (String)"Start (VHDL - US) build stage...");
                    }
                    time = System.currentTimeMillis();
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                    this.checkUnused(libraries, (Enum<FullChecksKind>)fullChecksKind, onlyLibAndPkgNames, false, true, disableRTLChecks, null);
                    if (reportToConsole) {
                        this.consolePrint("Performing mixed post full build step (VHDL - US) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_US)) {
                        DVTThreadDumpCollector.pause((String)"Finish (VHDL - US) build stage...");
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_USBD)) {
                        DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_USBD), (String)"Start (VHDL - USBD) build stage...");
                    }
                    time = System.currentTimeMillis();
                    this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                    this.checkUsageBefore(this.getLibraries(), fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                    if (reportToConsole) {
                        this.consolePrint("Performing mixed post full build step (VHDL - USBD) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                    }
                    if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_USBD)) {
                        DVTThreadDumpCollector.pause((String)"Finish (VHDL - USBD) build stage...");
                    }
                }
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_CP)) {
                    DVTThreadDumpCollector.resume((long)profilingAttributes.getInterval(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_CP), (String)"Start (VHDL - CP) build stage...");
                }
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
                boolean shouldReportTime = this.checkCustomPragmas(this.getRfCompiledFiles().fCompiledFiles);
                if (shouldReportTime & reportToConsole) {
                    this.consolePrint("Performing mixed post full build step (VHDL - CP) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                }
                if (profilingAttributes.hasAttribute(DVTThreadDumpCollectorAttributes.DVTProfileAttribute.VHDL_CP)) {
                    DVTThreadDumpCollector.pause((String)"Finish (VHDL - CP) build stage...");
                }
                this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES, IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, true, reportToConsole);
                if (this.fBuildProgressMonitor == null || !this.fBuildProgressMonitor.isCanceled()) {
                    ro.amiq.vhdldt.utils.Utils.saveRFDM(this, false, true, false);
                }
                this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    for (Map.Entry<ParserPath, DVTEditor> entry : this.fParserPathToEditorMap.entrySet()) {
                        ro.amiq.vhdldt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(entry.getKey()), entry.getValue());
                    }
                }
                this.updateBreadcrumbs();
                DVTProblemsUiUpdater dvtProblemsUiUpdater = DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_NAME_CHECKING.getId());
                dvtProblemsUiUpdater.update(this.fProject);
                dvtProblemsUiUpdater.scheduleObjectionsClear(this.fProject);
            }
            catch (BuildCancelException buildCancelException) {
                this.fBuildPending = false;
                ro.amiq.vhdldt.utils.Utils.connectActiveOpenEditor(this);
                DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fBuildPending = false;
                ro.amiq.vhdldt.utils.Utils.connectActiveOpenEditor(this);
                DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
        }
        finally {
            this.fBuildPending = false;
            ro.amiq.vhdldt.utils.Utils.connectActiveOpenEditor(this);
            DVTMixedLangModelManager.getInstance().notifyBuildStatusListeners(this.isBuildCanceled());
            this.setBuildProgressMonitor(null);
            this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        }
    }

    public List<QFileCompileInfo> getQFileCompileInfos(ParserPath path, boolean recursive, boolean inclComps) {
        if (this.fFileRefGraph == null) {
            return null;
        }
        return this.fFileRefGraph.getQFileCompileInfos(path, recursive, inclComps);
    }

    private void checkUsageBefore(IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        try {
            Collection<RfNamedElement> currentFileScopes;
            Map<ParserPath, Set<IRfNamedElement>> delta;
            String libraryName;
            RfLibrary library;
            Set<String> onlyPkgNames;
            Map<ParserPath, Collection<RfNamedElement>> firstLevelElementsInFile = container.firstLevelElements;
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            if (firstLevelElementsInFile != null && !firstLevelElementsInFile.isEmpty()) {
                for (Collection<RfNamedElement> firstLevelElements : firstLevelElementsInFile.values()) {
                    if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                    for (RfNamedElement rfNamedElement : firstLevelElements) {
                        onlyPkgNames = null;
                        if (onlyLibAndPkgNames != null) {
                            library = rfNamedElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, rfNamedElement)) continue;
                        rfNamedElement.visitHidObject(this, (IHidVisitor<?>)new UsageBeforeDeclarationVisitor());
                    }
                }
            }
            if ((delta = container.delta) != null && !delta.isEmpty()) {
                for (Set<IRfNamedElement> changedElements : delta.values()) {
                    if (changedElements == null || changedElements.isEmpty()) continue;
                    for (IRfNamedElement changedElement : changedElements) {
                        if (!(changedElement instanceof RfNamedElement)) continue;
                        Set<String> onlyPkgNames2 = null;
                        if (onlyLibAndPkgNames != null) {
                            RfLibrary library2 = (RfLibrary)changedElement.getEnclosingLibrary();
                            if (library2 == null) continue;
                            String libraryName2 = library2.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName2) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName2)) continue;
                            onlyPkgNames2 = onlyLibAndPkgNames.get(libraryName2);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames2 == null || onlyPkgNames2.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, changedElement)) continue;
                        ((RfNamedElement)changedElement).visitHidObject(this, (IHidVisitor<?>)new UsageBeforeDeclarationVisitor());
                    }
                }
            }
            if ((currentFileScopes = container.currentFileScopes) != null && !currentFileScopes.isEmpty()) {
                for (RfNamedElement rfNamedElement : currentFileScopes) {
                    if (rfNamedElement == null) continue;
                    onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        library = rfNamedElement.getEnclosingLibrary();
                        if (library == null) continue;
                        libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                        onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                    }
                    if (this.alreadyVisited(visited, rfNamedElement)) continue;
                    rfNamedElement.visitHidObject(this, (IHidVisitor<?>)new UsageBeforeDeclarationVisitor());
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
    }

    private void checkUsageBefore(Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        block5: {
            try {
                RfLibrary[] workingCopy;
                if (libraries == null || libraries.isEmpty()) break block5;
                this.initExecutorService(false);
                RfLibrary[] rfLibraryArray = workingCopy = libraries.toArray(new RfLibrary[libraries.size()]);
                int n = workingCopy.length;
                int n2 = 0;
                while (n2 < n) {
                    block7: {
                        RfLibrary library;
                        block6: {
                            library = rfLibraryArray[n2];
                            this.checkBuildCanceled();
                            Set<String> onlyPkgNames = null;
                            if (onlyLibAndPkgNames == null || library.isPredefined()) break block6;
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(library.getName()) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(library.getName())) break block7;
                            onlyPkgNames = onlyLibAndPkgNames.get(library.getName());
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) break block7;
                        }
                        ExecutorService executor = this.getExecutorService();
                        Runnable worker = new Runnable(){

                            @Override
                            public void run() {
                                library.visitHidObject(RfProject.this, (IHidVisitor<?>)new UsageBeforeDeclarationVisitor());
                            }
                        };
                        executor.execute(worker);
                    }
                    ++n2;
                }
                this.shutdownExecutorService();
            }
            catch (BuildCancelException buildCancelException) {}
        }
    }

    private void updateFNotificationTracker(Set<FileCompileInfo> changedFiles, FNotificationDirtyReason dirtyReason) {
        if (changedFiles == null) {
            return;
        }
        ELManager manager = this.getELManager();
        boolean dirtyElab = dirtyReason == FNotificationDirtyReason.ELABORATION && manager != null && manager.hasDirtyMemory();
        for (FileCompileInfo changedFile : changedFiles) {
            if (changedFile == null || !dirtyElab && dirtyReason != FNotificationDirtyReason.UNEXPECTED_EXCEPTION) continue;
            FIncrementalNotificationTracker.INSTANCE.addDirtyResource(this.fProject, (FNotificationDirtyResource)new FIncrementalDirtyFile(changedFile.getFile(), dirtyReason, (DVTFNotificationProvider)VhdlFNotificationProvider.getInstance()));
        }
    }

    public void postIncrementalBuild(VhdlFileInfo info) {
        try {
            this.fIncrementalBuild = true;
            this.fGUIUtils.resetTimer();
            ParserPath parserPath = info.getParserPath();
            this.fIncrementalDeltaContainer.parserPaths.add(parserPath);
            String debugPrefix = "DEBUG VHDL: ";
            long time = 0L;
            time = System.currentTimeMillis();
            this.fIncrementalDeltaContainer.removeDirtyElements(parserPath, this);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Remove Dirty Elements [" + (System.currentTimeMillis() - time) + " ms]");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postIncrementalBuild(Set<FileCompileInfo> changedFiles) {
        try {
            if (changedFiles == null || changedFiles.isEmpty() || this.fIncrementalDeltaContainer == null) {
                return;
            }
            if (BuildConfigManager.isPrintDebugDeltaInfo((IProject)this.fProject)) {
                DVTLogger.INSTANCE.logInfo(this.fIncrementalDeltaContainer.toString());
            }
            String debugPrefix = "DEBUG VHDL: ";
            long time = 0L;
            ro.amiq.vhdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
            if (ro.amiq.vhdldt.test.TestHelper.isTestMode()) {
                ro.amiq.vhdldt.test.TestHelper.fIncrementalDeltaContainer = new IncrementalDeltaContainer(this.fIncrementalDeltaContainer);
            }
            this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES, this, this.fIncrementalDeltaContainer.parserPaths);
            this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES, this, this.fIncrementalDeltaContainer.delta);
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
            this.resolveUses(this.fIncrementalDeltaContainer, this, false, false, false);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Resolve Uses [" + (System.currentTimeMillis() - time) + " ms]");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangIncrementalBuildPreElab(Set<FileCompileInfo> changedFiles, Set<String> updateViewIds) {
        try {
            this.fIncrementalBuild = true;
            this.fFileRefGraph.setDirty(true);
            if (this.fIncrementalDeltaContainer == null) {
                updateViewIds.addAll(ViewsUtils.ALL_VIEWS);
            } else if (this.fIncrementalDeltaContainer.updateViewsIds != null && updateViewIds != null) {
                updateViewIds.addAll(this.fIncrementalDeltaContainer.updateViewsIds);
            }
            if (!this.fBuildPending) {
                ro.amiq.vhdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
                this.updatedSemanticErrors(IRfSingleLangProject.SemanticErrorsCategory.values(), false, false);
                return;
            }
            if (changedFiles == null || changedFiles.isEmpty() || this.fIncrementalDeltaContainer == null) {
                return;
            }
            String debugPrefix = "DEBUG VHDL: ";
            long time = 0L;
            time = System.currentTimeMillis();
            this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
            this.resolveUses(this.fIncrementalDeltaContainer, this, true, true, true);
            DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Resolve Mixed Uses [" + (System.currentTimeMillis() - time) + " ms]");
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES}, false, false);
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            IncrementalChecksKind incrementalChecksKind = BuildConfigManager.getIncrementalCompileChecks((IProject)this.fProject, (boolean)this.isLintingEnabled());
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            if (fullChecksKind != FullChecksKind.OFF && incrementalChecksKind != IncrementalChecksKind.OFF) {
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES, this, this.fIncrementalDeltaContainer.parserPaths);
                this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES, this, this.fIncrementalDeltaContainer.delta);
                ConfigInfo configInfo = new ConfigInfo(true, this, null, disableRTLChecks, this.getToolCompat());
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES;
                this.resolveTypesIncremental(configInfo, true, false, false, fullChecksKind, onlyLibAndPkgNames, null);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Resolve Mixed Types [" + (System.currentTimeMillis() - time) + " ms]");
            } else {
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES);
            }
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postMixedLangIncrementalBuildPostElab(Set<FileCompileInfo> changedFiles, Set<String> updateViewIds) {
        block18: {
            this.fIncrementalBuild = true;
            if (changedFiles != null && !changedFiles.isEmpty() && this.fIncrementalDeltaContainer != null) break block18;
            DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
            DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.parserPaths);
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
            this.setBuildProgressMonitor(null);
            return;
        }
        try {
            this.checkBuildCanceled(true);
            String debugPrefix = "DEBUG VHDL: ";
            long time = 0L;
            Set<ParserPath> changedParserPaths = this.resource2parser(changedFiles);
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            IncrementalChecksKind incrementalChecksKind = BuildConfigManager.getIncrementalCompileChecks((IProject)this.fProject, (boolean)this.isLintingEnabled());
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            if (fullChecksKind != FullChecksKind.OFF && incrementalChecksKind != IncrementalChecksKind.OFF) {
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, this, this.fIncrementalDeltaContainer.parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES;
                this.checkForDuplicates(this.fIncrementalDeltaContainer, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check Duplicates [" + (System.currentTimeMillis() - time) + " ms]");
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, this, this.fIncrementalDeltaContainer.parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                this.checkUnused(this.fIncrementalDeltaContainer, (Enum<FullChecksKind>)fullChecksKind, onlyLibAndPkgNames, true, true, disableRTLChecks);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check unused signals [" + (System.currentTimeMillis() - time) + " ms]");
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS;
                this.checkUsageBefore(this.fIncrementalDeltaContainer, fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check Usage before Declaration [" + (System.currentTimeMillis() - time) + " ms]");
                this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS, this, this.fIncrementalDeltaContainer.parserPaths);
                time = System.currentTimeMillis();
                this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS;
                boolean shouldReportTime = this.checkCustomPragmas(changedParserPaths);
                if (shouldReportTime) {
                    DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Check custom pragmas [" + (System.currentTimeMillis() - time) + " ms]");
                }
            } else {
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS);
                this.fSemanticErrors.setObsolete(IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS);
            }
            this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_TYPES, IRfSingleLangProject.SemanticErrorsCategory.DUPLICATES, IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, IRfSingleLangProject.SemanticErrorsCategory.CUSTOM_PRAGMAS}, false, false);
            if (this.fBuildPending) {
                ro.amiq.vhdldt.utils.Utils.saveRFDM(this, true, true, false);
            }
            this.startNameChecking(changedParserPaths, 0);
            Set<ParserPath> changedParserPathsForHighlight = this.getFilesForIncrementalHighlight();
            if (changedParserPathsForHighlight != null && !changedParserPathsForHighlight.isEmpty() && this.fParserPathToEditorMap != null) {
                for (ParserPath parserPath : changedParserPathsForHighlight) {
                    this.reconnectPositions(parserPath, changedParserPaths == null || !changedParserPaths.contains(parserPath));
                    ro.amiq.vhdldt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(parserPath), this.fParserPathToEditorMap.get(parserPath));
                }
            }
            this.updateBreadcrumbs();
            this.updateFNotificationTracker(changedFiles, FNotificationDirtyReason.ELABORATION);
        }
        catch (BuildCancelException buildCancelException) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.parserPaths);
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
            this.setBuildProgressMonitor(null);
        }
        catch (Exception e) {
            try {
                this.updateFNotificationTracker(changedFiles, FNotificationDirtyReason.UNEXPECTED_EXCEPTION);
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Throwable throwable) {
                Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.parserPaths);
                }
                this.fIncrementalBuild = false;
                this.fBuildPending = false;
                this.setBuildProgressMonitor(null);
                throw throwable;
            }
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
            if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.parserPaths);
            }
            this.fIncrementalBuild = false;
            this.fBuildPending = false;
            this.setBuildProgressMonitor(null);
        }
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
        if (this.fBuildPending && this.fIncrementalDeltaContainer != null) {
            this.notifyParsingEndUsingParserPath(this.fIncrementalDeltaContainer.parserPaths);
        }
        this.fIncrementalBuild = false;
        this.fBuildPending = false;
        this.setBuildProgressMonitor(null);
    }

    public void preElaborationSetup(boolean cleanMarkers, boolean isFullBuild) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ELABORATION;
        if (!cleanMarkers) {
            return;
        }
        if (!isFullBuild && this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, this, isFullBuild ? null : this.fIncrementalDeltaContainer.parserPaths);
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, this, isFullBuild ? null : this.fIncrementalDeltaContainer.delta);
        this.fSemanticErrors.clearFiles(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, this, isFullBuild ? null : this.fIncrementalDeltaContainer.parserPaths);
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, this, isFullBuild ? null : this.fIncrementalDeltaContainer.delta);
    }

    public void preElaborationIncrementalSetup(Map<ParserPath, Set<IRfNamedElement>> elaboratedElementsMap) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.ELABORATION;
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS, this, elaboratedElementsMap);
    }

    public void preUnelaborationSetup(boolean cleanMarkers, boolean isFullBuild, Map<ParserPath, Set<IRfNamedElement>> unelaboratedElementsMap) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS;
        if (!cleanMarkers) {
            return;
        }
        if (!isFullBuild && this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fSemanticErrors.clearDependencies(IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, this, unelaboratedElementsMap);
    }

    public void updateElaborationMarkers(boolean updateStatistics, boolean reportToConsole) {
        this.updatedSemanticErrors(new IRfSingleLangProject.SemanticErrorsCategory[]{IRfSingleLangProject.SemanticErrorsCategory.ELABORATION, IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS}, updateStatistics, reportToConsole);
    }

    public Set<ParserPath> getFilesForIncrementalHighlight() {
        if (this.fIncrementalDeltaContainer == null) {
            return Collections.emptySet();
        }
        return this.fIncrementalDeltaContainer.getDeltaFilesParserPath(false).stream().map(deltaFileWrapper -> deltaFileWrapper.getParserPath()).collect(Collectors.toSet());
    }

    private void reconnectPositions(ParserPath parserPath, boolean shouldComputeReflectionPositions) {
        if (this.fParserPathToEditorMap != null) {
            DVTEditor editor = this.fParserPathToEditorMap.get(parserPath);
            this.connectFileToDocument(parserPath, editor, shouldComputeReflectionPositions);
        }
    }

    private void updatedSemanticErrors(IRfSingleLangProject.SemanticErrorsCategory[] categories, boolean updateStatistics, boolean reportToConsole) {
        try {
            if (this.isSemanticErrorCheck() || this.isSemanticWarningCheck()) {
                ArrayList<RfSemanticError> semanticProblems = new ArrayList<RfSemanticError>();
                IRfSingleLangProject.SemanticErrorsCategory[] semanticErrorsCategoryArray = categories;
                int n = categories.length;
                int n2 = 0;
                while (n2 < n) {
                    IRfSingleLangProject.SemanticErrorsCategory category = semanticErrorsCategoryArray[n2];
                    Map<String, SemanticErrorsTable.ErrorsAndWarnings> errorsAndWarningsPerCategory = this.fSemanticErrors.get(category);
                    for (SemanticErrorsTable.ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                        if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
                        for (Set set : errorsAndWarnings.errorsMap.values()) {
                            if (set == null || set.isEmpty()) continue;
                            semanticProblems.addAll(set);
                        }
                        for (Set set : errorsAndWarnings.warningsMap.values()) {
                            if (set == null || set.isEmpty()) continue;
                            semanticProblems.addAll(set);
                        }
                    }
                    ++n2;
                }
                ro.amiq.vhdldt.utils.Utils.triggerSemanticMarkers(this, semanticProblems, reportToConsole);
            } else {
                DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SEMANTIC.getId()).scheduleObjectionsClear(this.fProject);
                DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_SYNTAX.getId()).scheduleObjectionsClear(this.fProject);
            }
            if (updateStatistics) {
                this.updateDuration();
                this.updateMemoryAllocation();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void consolePrint(String message, boolean isReport) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message, isReport ? DVTBuildConsoleCommon.MessageSink.REPORT : DVTBuildConsoleCommon.MessageSink.CONSOLE);
    }

    @Deprecated
    protected boolean isSemanticErrorCheck() {
        return true;
    }

    @Deprecated
    protected boolean isSemanticWarningCheck() {
        return true;
    }

    public void collectIncrementalChangedPackages(Map<LanguageKind, List<IRfPackageElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectChangedPackages(collected.get(LanguageKind.VLOG));
    }

    public void collectIncrementalChangedNonDesignElements(Map<LanguageKind, Set<IRfNamedElement>> collected) {
    }

    public void collectIncrementalDeltaInstances(Map<LanguageKind, List<IRfInstanceElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectDeltaInstances(collected.get(LanguageKind.VHDL));
    }

    public void collectIncrementalDeltaDesigns(Map<LanguageKind, List<IRfDesignElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectDeltaDesigns(collected.get(LanguageKind.VHDL));
    }

    public void collectIncrementalDeltaBlocks(Map<LanguageKind, List<IRfDesignElement>> collected) {
        if (this.fIncrementalDeltaContainer == null || collected == null) {
            return;
        }
        this.fIncrementalDeltaContainer.collectDeltaBlocks(collected.get(LanguageKind.VHDL));
    }

    public boolean hasIncrementalStructuralDesignChanges() {
        return this.fIncrementalDeltaContainer != null && this.fIncrementalDeltaContainer.hasStructuralDesignChanges();
    }

    public boolean hasIncrementalRemovedDescriptions() {
        return this.fIncrementalDeltaContainer != null && this.fIncrementalDeltaContainer.hasRemovedDescriptions();
    }

    public void cleanIncrementalDeltaContainer() {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        this.fIncrementalDeltaContainer.clear();
        this.fIncrementalDeltaContainer = null;
    }

    public void cleanIncremental(ParserPath parserPath) {
        try {
            this.fBuildPending = true;
            this.orderAnalysisScope = null;
            if (this.fIncrementalDeltaContainer == null) {
                this.fIncrementalDeltaContainer = new IncrementalDeltaContainer();
            }
            this.fIncrementalDeltaContainer.parserPaths.add(parserPath);
            this.cleanFile(parserPath, this.fIncrementalDeltaContainer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void incrementalBuild(VhdlFileInfo info) {
        try {
            this.fIncrementalBuild = true;
            if (this.fIncrementalDeltaContainer == null) {
                this.fIncrementalDeltaContainer = new IncrementalDeltaContainer();
            }
            ParserPath parserPath = info.getParserPath();
            this.fIncrementalDeltaContainer.parserPaths.add(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    private void setDisabledChecks() {
        EnumSet disabledChecks = BuildConfigManager.getDisabledChecks((IProject)this.fProject);
        this.fDisableMissingOthersChoice = disabledChecks.contains(CheckIdKind.MISSING_OTHERS_CHOICE);
        this.fDisableRedundantOthersChoice = disabledChecks.contains(CheckIdKind.REDUNDANT_OTHERS_CHOICE);
        this.fPackageConstantsDisabled = BuildConfigManager.isUnelaboratedDisabledPackageConstants((IProject)this.fProject);
        this.fFullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.fProject);
        this.fUnelaboratedCompileChecks = BuildConfigManager.getUnelaboratedCompileChecksKind((IProject)this.fProject);
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
        this.setElaborationEnabled(BuildConfigManager.getIncrementalElaborationKind((IProject)this.fProject));
    }

    public void activeTestChangedNotification() {
    }

    public void addReference(RfLibrary library, String typeName, RfNamedElement referencedIn) {
        if (library == null || referencedIn == null || referencedIn.isPredefined()) {
            return;
        }
        library.addReference(typeName, (IRfNamedElement)referencedIn);
    }

    public Set<IRfNamedElement> getReferences(RfLibrary library, String dependsOnTypeName) {
        if (dependsOnTypeName == null || library == null) {
            return null;
        }
        return library.getReferences(dependsOnTypeName);
    }

    public void clean() {
        this.clean(true);
    }

    public void clean(boolean compilePredefinedLibs) {
        this.fBuildPending = true;
        this.fIncrementalBuild = false;
        this.orderAnalysisScope = null;
        if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
            for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
                fileDef.deepClean();
            }
            this.fRfProjectContent.fParserPath2FileDefMap.clear();
        }
        this.fIncrementalDeltaContainer = null;
        if (this.fChangedFilesManager != null) {
            this.fChangedFilesManager.clear();
        }
        this.fChangedFilesManager = null;
        this.fFileRefGraph.setDirty(true);
        this.fScopeStack.clear();
        this.fScopeStack.push(this);
        this.deepClean();
        this.fOverridedHidHolder.clear();
        if (this.fRfProjectContent.fLibraries == null) {
            this.fRfProjectContent.fLibraries = new InsensitiveLinkedMap();
        } else {
            this.fRfProjectContent.fLibraries.clear();
        }
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new VhdlFileInstancesMap(this);
        } else {
            this.fRfProjectContent.fFileInstancesMap.clear();
        }
        this.fWildcardUses.clear();
        this.fRfProjectContent.fPredefinedTypeHolder = new PredefinedTypeHolder();
        this.fRfProjectContent.opCache = new OperatorScopeCache();
        if (this.fLibraryClauses != null) {
            this.fLibraryClauses.clear();
        }
        this.setDisabledChecks();
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
        this.cleanSemanticErrors();
        if (compilePredefinedLibs) {
            this.compilePredefinedLibraries();
        }
        if (this.fPowerFormatModel != null) {
            this.fPowerFormatModel.clear();
            this.fPowerFormatModel = null;
        }
        this.fMixedLangProjectParent.cleanElaborationManagers();
    }

    private synchronized void compilePredefinedLibraries() {
        boolean isVhdl08;
        DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.getProject());
        Set translatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)this.getProject());
        int maxIssuesKindNumber = ro.amiq.vhdldt.utils.Utils.maxIssuesKindNumber(this.fProject);
        IVhdlProject vhdlProject = ro.amiq.vhdldt.utils.Utils.getVhdlProject(this.fProject);
        boolean isNotVhdl08 = BuildConfigManager.isNonVhdl08((IProject)this.fProject);
        boolean bl = isVhdl08 = BuildConfigManager.isVhdl08((IProject)this.fProject) || !isNotVhdl08;
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = BuildConfigManager.isVhdlAms((IProject)this.fProject) ? IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_2007 : (isVhdl08 ? IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 : IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993);
        VhdlAMS vhdlParser = vhdlProject.getVHDLParser();
        fPredefinedLibrariesFiles = new String[4];
        String std08_path = VhdlBuilderUtils.importExtensions(this.fProject, STD_EXTENSIONS_08);
        if (isVhdl08 && std08_path != null) {
            RfProject.fPredefinedLibrariesFiles[0] = std08_path;
            vhdlParser.parseFile(std08_path, VHDL_STD_LIB_08, languageSyntax, this, null, false, -1, -1, maxIssuesKindNumber, null, null, commentsPreferences, null, false, false, null);
        }
        String std93_path = VhdlBuilderUtils.importExtensions(this.fProject, STD_EXTENSIONS_93);
        if (isNotVhdl08 && std93_path != null) {
            RfProject.fPredefinedLibrariesFiles[1] = std93_path;
            vhdlParser.parseFile(std93_path, VHDL_STD_LIB_93, languageSyntax, this, null, false, -1, -1, maxIssuesKindNumber, translatePragmas, null, commentsPreferences, null, false, false, null);
        }
        String ieee08_path = VhdlBuilderUtils.importExtensions(this.fProject, IEEE_EXTENSIONS_08);
        if (isVhdl08 && ieee08_path != null) {
            RfProject.fPredefinedLibrariesFiles[2] = ieee08_path;
            vhdlParser.parseFile(ieee08_path, VHDL_IEEE_LIB_08, languageSyntax, this, null, false, -1, -1, maxIssuesKindNumber, translatePragmas, null, commentsPreferences, null, false, false, null);
        }
        String ieee93_path = VhdlBuilderUtils.importExtensions(this.fProject, IEEE_EXTENSIONS_93);
        if (isNotVhdl08 && ieee93_path != null) {
            RfProject.fPredefinedLibrariesFiles[3] = ieee93_path;
            vhdlParser.parseFile(ieee93_path, VHDL_IEEE_LIB_93, languageSyntax, this, null, false, -1, -1, maxIssuesKindNumber, translatePragmas, null, commentsPreferences, null, false, false, null);
        }
    }

    public boolean isPredefinedLibraryFile(ParserPath filePath) {
        if (filePath == null) {
            return true;
        }
        if (fPredefinedLibrariesFiles == null) {
            return false;
        }
        String path = filePath.path;
        String[] stringArray = fPredefinedLibrariesFiles;
        int n = fPredefinedLibrariesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryPath = stringArray[n2];
            if (libraryPath != null && libraryPath.equals(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void remove(IVhdlModule vhdlFile) {
        ParserPath parserPath = vhdlFile.getParserPath();
        if (parserPath != null) {
            this.removeFile(parserPath);
        }
    }

    public void removeFile(ParserPath parserPath) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            if (file == null) {
                return;
            }
            file.cleanUpFile(null);
        }
    }

    public void cleanFile(ParserPath parserPath, IncrementalDeltaContainer incrementalDeltaContainer) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
            if (file == null) {
                return;
            }
            file.cleanUpFile(incrementalDeltaContainer);
            List<VhdlFileInstance> fileInstances = this.getFileInstancesMap().getFileInstances(parserPath);
            for (VhdlFileInstance fileInstace : fileInstances) {
                fileInstace.cleanCustomPragmas();
            }
        }
    }

    @Override
    protected void addMember(RfNamedElement element) {
        if (this.fCurrentLibrary == null) {
            return;
        }
        this.fCurrentLibrary.addMember(element);
    }

    public RfLibrary getCurrentLibrary() {
        return this.fCurrentLibrary;
    }

    public void startModule(String fileName, String libraryName, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        try {
            boolean isNotCompiled;
            ParserPath parserPath = new ParserPath(fileName);
            this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
            this.fScopeStack.clear();
            boolean bl = isNotCompiled = this.fIncrementalBuild && !this.isCompiled(parserPath);
            if (this.fIncrementalBuild && isNotCompiled) {
                libraryName = TEMP_LIBRARY_NAME;
            }
            libraryName = VHDL_IEEE_LIB.equals(libraryName) ? (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 ? VHDL_IEEE_LIB_08 : VHDL_IEEE_LIB_93) : libraryName;
            this.fCurrentLibraryName = libraryName = this.adjustLibraryName(libraryName);
            if (this.fRfProjectContent.fLibraries.containsKey(libraryName)) {
                this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get(libraryName);
            } else {
                this.fCurrentLibrary = new RfLibrary(libraryName, this);
                this.fCurrentLibrary.initPredefinedLibraries(languageSyntax);
                this.fRfProjectContent.fLibraries.put((Object)libraryName, (IDVTMapElement)this.fCurrentLibrary);
                if (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008) {
                    RfContext ieee_bit_context = new RfContext("ieee_bit_context"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String getComment() {
                            return "[PREDEFINED] Context containig the IEEE 'numeric_bit' package";
                        }

                        @Override
                        public boolean isPredefined() {
                            return true;
                        }
                    };
                    ieee_bit_context.addExplicitUse(new ImportInfo(Arrays.asList(new DataTypeChunk(VHDL_IEEE_LIB, -1, -1)), null, ImportInfo.ImportInfoKind.LIBRARY_CLAUSE, -1, -1, null));
                    ieee_bit_context.addWildcardUse(new ImportInfo(Arrays.asList(new DataTypeChunk(VHDL_IEEE_LIB, -1, -1), new DataTypeChunk("numeric_bit", -1, -1)), null, ImportInfo.ImportInfoKind.LIBRARY_CLAUSE, -1, -1, null));
                    this.fCurrentLibrary.addMember(ieee_bit_context);
                    RfContext ieee_std_context = new RfContext("ieee_std_context"){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public String getComment() {
                            return "[PREDEFINED] Context containing the IEEE 'std_logic_1164' and 'numeric_std' packages";
                        }

                        @Override
                        public boolean isPredefined() {
                            return true;
                        }
                    };
                    ieee_std_context.addExplicitUse(new ImportInfo(Arrays.asList(new DataTypeChunk(VHDL_IEEE_LIB, -1, -1)), null, ImportInfo.ImportInfoKind.LIBRARY_CLAUSE, -1, -1, null));
                    ieee_std_context.addWildcardUse(new ImportInfo(Arrays.asList(new DataTypeChunk(VHDL_IEEE_LIB, -1, -1), new DataTypeChunk("std_logic_1164", -1, -1)), null, ImportInfo.ImportInfoKind.LIBRARY_CLAUSE, -1, -1, null));
                    ieee_std_context.addWildcardUse(new ImportInfo(Arrays.asList(new DataTypeChunk(VHDL_IEEE_LIB, -1, -1), new DataTypeChunk("numeric_std", -1, -1)), null, ImportInfo.ImportInfoKind.LIBRARY_CLAUSE, -1, -1, null));
                    this.fCurrentLibrary.addMember(ieee_std_context);
                }
            }
            if (this.fCurrentFileDef == null) {
                int index;
                int n = index = isNotCompiled ? -1 : this.fRfProjectContent.fParserPath2FileDefMap.size() + 1;
                if (!RfProject.isPredefined(fileName)) {
                    this.fCurrentFileDef = new RfFileDef(Path.fromOSString((String)fileName).lastSegment(), index, parserPath, this.fCurrentLibrary, languageSyntax);
                    this.fRfProjectContent.fParserPath2FileDefMap.put(parserPath, this.fCurrentFileDef);
                } else {
                    this.fCurrentFileDef = new RfFileDef(Path.fromOSString((String)fileName).lastSegment(), index, parserPath, this.fCurrentLibrary, languageSyntax);
                }
            }
            this.fScopeStack.push(this.fCurrentLibrary);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startEntity(String name, VhdlCompileInfo compileInfo, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfEntity entity = enclosing.getLocalMember(RfEntity.class, name, this.fIncrementalBuild);
            RfDefElement entityDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(entityDef);
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if (foundElem != null) {
                entityDef = foundElem;
                if (entity != null && entity == foundElem.getLastNamedElement()) {
                    this.pushScope(entityDef, entity);
                    return entityDef;
                }
            }
            RfEntity rfEntity = entity = entity == null || !entity.hasNoDefs(true) ? null : entity;
            if (entity == null) {
                entity = new RfEntity(name);
                enclosing.addMember(entity);
            } else {
                entity.init(name);
            }
            entityDef = entity.addDeclaration(entityDef);
            entity.setCompileInfo(compileInfo);
            this.pushScope(entityDef, entity);
            return entityDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endEntity(RfDefElement def, LineInfo endInfo) {
        try {
            def.setEndOffset(endInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startArchitecture(String name, VhdlCompileInfo compileInfo, DataType dataType, LineInfo lineInfo, CommentBlock comment, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        RfDefElement architectureDef;
        RfDefElement foundElem;
        block8: {
            try {
                if (dataType != null && dataType.getTypeName() != null && !dataType.getTypeName().isEmpty()) break block8;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        RfNamedElement enclosing = this.fScopeStack.peek();
        enclosing = this.getEntityScope(enclosing.getEnclosingLibrary(), dataType, lineInfo, languageSyntax);
        RfArchitecture architecture = enclosing.getLocalMember(RfArchitecture.class, name, this.fIncrementalBuild);
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        if ((foundElem = this.fCurrentFileDef.findDefElement(architectureDef = new RfDefElementWithLabel(this.fCurrentFileDef, name, lineInfo, lineInfo, comment))) != null) {
            architectureDef = foundElem;
            if (architecture != null && architecture == foundElem.getLastNamedElement()) {
                this.pushScope(architectureDef, architecture);
                return architectureDef;
            }
        }
        RfArchitecture rfArchitecture = architecture = architecture == null || !architecture.hasNoDefs(true) ? null : architecture;
        if (architecture == null) {
            architecture = new RfArchitecture(name, dataType);
            enclosing.addMember(architecture);
        } else {
            architecture.init(name, dataType);
        }
        architectureDef = architecture.addDeclaration(architectureDef);
        architecture.setCompileInfo(compileInfo);
        this.pushScope(architectureDef, architecture);
        return architectureDef;
    }

    @NotNull
    private RfEntity getEntityScope(RfLibrary currentLibrary, DataType dataType, LineInfo lineInfo, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        RfLibrary existingLibrary;
        String libraryName = null;
        String entityName = null;
        List<DataTypeChunk> entityFullName = dataType.getTypeName();
        if (entityFullName.size() == 1) {
            libraryName = currentLibrary.getName();
            entityName = entityFullName.get((int)0).name;
        } else if (entityFullName.size() >= 2) {
            libraryName = entityFullName.get((int)0).name;
            entityName = entityFullName.get((int)1).name;
        }
        libraryName = VHDL_IEEE_LIB.equals(libraryName) ? (languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008 ? VHDL_IEEE_LIB_08 : VHDL_IEEE_LIB_93) : libraryName;
        RfLibrary rfLibrary = existingLibrary = "work".equalsIgnoreCase(libraryName) ? currentLibrary : (RfLibrary)this.fRfProjectContent.fLibraries.get(this.adjustLibraryName(libraryName));
        if (existingLibrary == null) {
            libraryName = this.adjustLibraryName(libraryName);
            existingLibrary = new RfLibrary(libraryName, this);
            this.fRfProjectContent.fLibraries.put((Object)libraryName, (IDVTMapElement)existingLibrary);
            RfImplicitDef def = new RfImplicitDef(this.fCurrentFileDef, libraryName, lineInfo);
            existingLibrary.addDeclaration(def);
        }
        RfEntity existingEntity = null;
        RfDuplicate duplicate = existingLibrary.getLocalMember(RfDuplicate.class, entityName);
        existingEntity = duplicate == null ? existingLibrary.getLocalMember(RfEntity.class, entityName) : duplicate.getLastDefMember(RfEntity.class, this.fCurrentFileDef);
        if (existingEntity == null) {
            existingEntity = existingLibrary.getLocalMember(RfEntity.class, entityName);
        }
        if (existingEntity == null) {
            existingEntity = new RfEntity(entityName);
            existingLibrary.addMember(existingEntity);
            RfImplicitDef def = new RfImplicitDef(this.fCurrentFileDef, entityName, lineInfo);
            existingEntity.addDeclaration(def);
        } else if (existingEntity.getAllDefsSize() == 0) {
            RfImplicitDef def = new RfImplicitDef(this.fCurrentFileDef, entityName, lineInfo);
            existingEntity.addDeclaration(def);
        }
        return existingEntity;
    }

    public void endArchitecture(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startConfiguration(String name, VhdlCompileInfo compileInfo, DataType dataType, LineInfo lineInfo, CommentBlock comment, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        RfDefElement configurationDef;
        RfDefElement foundElem;
        block8: {
            try {
                if (dataType != null && dataType.getTypeName() != null && !dataType.getTypeName().isEmpty()) break block8;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        RfNamedElement enclosing = this.fScopeStack.peek();
        enclosing = this.getEntityScope(enclosing.getEnclosingLibrary(), dataType, lineInfo, languageSyntax);
        RfConfiguration configuration = enclosing.getLocalMember(RfConfiguration.class, name, this.fIncrementalBuild);
        if (this.fIncrementalDeltaContainer != null) {
            this.fIncrementalDeltaContainer.changedTypeNames.add(name);
        }
        if ((foundElem = this.fCurrentFileDef.findDefElement(configurationDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment))) != null) {
            configurationDef = foundElem;
            if (configuration != null && configuration == foundElem.getLastNamedElement()) {
                this.pushScope(configurationDef, configuration);
                return configurationDef;
            }
        }
        RfConfiguration rfConfiguration = configuration = configuration == null || !configuration.hasNoDefs(true) ? null : configuration;
        if (configuration == null) {
            configuration = new RfConfiguration(name, dataType);
            enclosing.addMember(configuration);
        } else {
            configuration.init(name, dataType);
        }
        configurationDef = configuration.addDeclaration(configurationDef);
        configuration.setCompileInfo(compileInfo);
        this.pushScope(configurationDef, configuration);
        return configurationDef;
    }

    public void endConfiguration(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startVUnit(String name, VhdlCompileInfo compileInfo, int kind, List<DataTypeChunk> designFullName, String architectureName, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfDefElement vunitDef;
            RfDefElement foundElem;
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfVUnit vunit = enclosing.getLocalMember(RfVUnit.class, name, this.fIncrementalBuild);
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(vunitDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment))) != null) {
                vunitDef = foundElem;
                if (vunit != null && vunit == foundElem.getLastNamedElement()) {
                    this.pushScope(vunitDef, vunit);
                    return vunitDef;
                }
            }
            RfVUnit rfVUnit = vunit = vunit == null || !vunit.hasNoDefs(true) ? null : vunit;
            if (vunit == null) {
                vunit = new RfVUnit(name, kind, designFullName, architectureName);
                enclosing.addMember(vunit);
            } else {
                vunit.init(kind, designFullName, architectureName, name);
            }
            vunitDef = vunit.addDeclaration(vunitDef);
            vunit.setCompileInfo(compileInfo);
            this.pushScope(vunitDef, vunit);
            return vunitDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endVUnit(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startBlock(String name, VhdlCompileInfo compileInfo, LineInfo startLineInfo, IRfActionBlockElement.BlockQualifier qualifier, String alternativeLabel, boolean isOptionalBranch, CommentBlock comment) {
        try {
            RfDefElement blockDef;
            RfDefElement foundElem;
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfBlock block = enclosing.getLocalMember(RfBlock.class, name, this.fIncrementalBuild);
            if (block instanceof RfGeneratesContainer) {
                block = ((RfGeneratesContainer)block).getFirstMember();
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(blockDef = new RfDefElementWithLabel(this.fCurrentFileDef, name, startLineInfo, startLineInfo, null))) != null) {
                blockDef = foundElem;
                if (block != null && block == foundElem.getLastNamedElement()) {
                    this.pushScope(blockDef, block);
                    return blockDef;
                }
            }
            block = block == null || !block.hasNoDefs(true) ? null : block;
            int generateConstructIndex = RfProject.getGenerateConstructIndex(enclosing, isOptionalBranch);
            if (block == null) {
                block = new RfBlock(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN, qualifier != null ? qualifier.value() : 0L, alternativeLabel, isOptionalBranch, generateConstructIndex);
                enclosing.addMember(block);
            } else {
                block.init(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN, qualifier != null ? qualifier.value() : 0L, alternativeLabel, isOptionalBranch, generateConstructIndex);
            }
            blockDef = block.addDeclaration(blockDef);
            block.setCompileInfo(compileInfo);
            blockDef.setDefComment(comment);
            this.pushScope(blockDef, block);
            return blockDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endBlock(RfDefElement def, LineInfo endLineInfo, String expression) {
        try {
            if (def instanceof RfDefElementWithLabel) {
                def.setEndOffset(endLineInfo);
                RfBlock rfBlock = (RfBlock)def.getNamedElement();
                if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && expression != null && !expression.equals(rfBlock.getExpression())) {
                    this.fIncrementalDeltaContainer.changedExpressionBlocks.add(rfBlock);
                }
                rfBlock.setExpression(expression);
            }
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static int getGenerateConstructIndex(RfNamedElement enclosing, boolean isOptionalBranch) {
        int index = 0;
        List<RfBlock> generateBlocks = enclosing.getLocalMembers(RfBlock.class);
        if (generateBlocks != null && !generateBlocks.isEmpty()) {
            for (RfBlock generateBlock : generateBlocks) {
                if (generateBlock.getDeclaration() == null || generateBlock.isOptionalBranch()) continue;
                ++index;
            }
        }
        return index += isOptionalBranch ? 0 : 1;
    }

    public RfDefElement startConfigurationRule(VhdlCompileInfo compileInfo, LineInfo startInfo) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            String uniqueName = IRfConfigurationRule.getUniqueName((int)startInfo.realOffset, (int)startInfo.virtOffset, (int)startInfo.line);
            RfConfigurationRule rule = enclosing.getLocalMember(RfConfigurationRule.class, uniqueName, this.fIncrementalBuild);
            RfDefElement def = new RfDefElement(this.fCurrentFileDef, uniqueName, startInfo, startInfo, null);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(def);
            if (foundElem != null) {
                def = foundElem;
                if (rule != null && rule == foundElem.getLastNamedElement()) {
                    this.pushScope(def, rule);
                    return def;
                }
            }
            RfConfigurationRule rfConfigurationRule = rule = rule == null || !rule.hasNoDefs(true) ? null : rule;
            if (rule == null) {
                rule = new RfConfigurationRule(uniqueName);
                enclosing.addMember(rule);
            }
            def = rule.addDeclaration(def);
            rule.setCompileInfo(compileInfo);
            this.pushScope(def, rule);
            return def;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endConfigurationRule(RfDefElement def, DataType bindingDataType, IRfAssociatedType.AssocTypeKind bindingKind, LineInfo endInfo) {
        try {
            def.setEndOffset(endInfo);
            this.popScope(def);
            RfNamedElement namedElement = def.getNamedElement();
            if (namedElement instanceof RfConfigurationRule) {
                ((RfConfigurationRule)namedElement).init(namedElement.getName(), bindingDataType, bindingKind);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startActionBlock(String name, VhdlCompileInfo compileInfo, IRfActionBlockElement.BlockQualifier qualifier, LineInfo lineInfo, CommentBlock comment) {
        try {
            long qualifiers;
            if (name == null) {
                name = RfNamedElement.getUniqueNameForAnonymous(this.fCurrentFileDef.getParserPath(), lineInfo);
            }
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfActionBlock action = enclosing.getLocalMember(RfActionBlock.class, name, this.fIncrementalBuild);
            RfDefElement actionDef = new RfDefElementWithLabel(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(actionDef);
            if (foundElem != null) {
                actionDef = foundElem;
                if (action != null && action == foundElem.getLastNamedElement()) {
                    this.pushScope(actionDef, action);
                    return actionDef;
                }
            }
            action = action == null || !action.hasNoDefs(true) ? null : action;
            long l = qualifiers = qualifier != null ? qualifier.value() : 0L;
            if (action == null) {
                action = new RfActionBlock(name, qualifiers);
                enclosing.addMember(action);
            } else {
                action.init(qualifiers, name);
            }
            actionDef = action.addDeclaration(actionDef);
            action.setCompileInfo(compileInfo);
            this.pushScope(actionDef, action);
            return actionDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endActionBlock(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startComponent(String name, VhdlCompileInfo compileInfo, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfComponent component = enclosing.getLocalMember(RfComponent.class, name, this.fIncrementalBuild);
            RfDefElement componentDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(componentDef);
            if (foundElem != null) {
                componentDef = foundElem;
                if (component != null && component == foundElem.getLastNamedElement()) {
                    this.pushScope(componentDef, component);
                    return componentDef;
                }
            }
            RfComponent rfComponent = component = component == null || !component.hasNoDefs(true) ? null : component;
            if (component == null) {
                component = new RfComponent(name);
                enclosing.addMember(component);
            } else {
                component.init(name);
            }
            componentDef = component.addDeclaration(componentDef);
            component.setCompileInfo(compileInfo);
            this.pushScope(componentDef, component);
            return componentDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endComponent(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean testComponentInstance(DataType dataType) {
        if (dataType == null) {
            return false;
        }
        RfNamedElement enclosing = this.fScopeStack.peek();
        IRfNamedElement candidate = RfNamedElement.internalComputeAssociatedType(dataType, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN, enclosing, enclosing, this);
        return candidate instanceof RfComponent;
    }

    public RfDefElement startInstance(String name, VhdlCompileInfo compileInfo, DataType dataType, IRfAssociatedType.AssocTypeKind kind, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfInstance instance = enclosing.getLocalMember(RfInstance.class, name, this.fIncrementalBuild);
            RfDefElement instanceDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(instanceDef);
            if (foundElem != null) {
                instanceDef = foundElem;
                if (instance != null && instance == foundElem.getLastNamedElement()) {
                    this.pushScope(instanceDef, instance);
                    return instanceDef;
                }
            }
            RfInstance rfInstance = instance = instance == null || !instance.hasNoDefs(true) ? null : instance;
            if (instance == null) {
                instance = new RfInstance(name, dataType, kind);
                enclosing.addMember(instance);
            } else {
                if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(instance.getDataType())) {
                    this.fIncrementalDeltaContainer.changedDataTypeElements.add(instance);
                }
                instance.init(name, dataType, kind);
            }
            instanceDef = instance.addDeclaration(instanceDef);
            instance.setCompileInfo(compileInfo);
            this.pushScope(instanceDef, instance);
            return instanceDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endInstance(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startFunction(String name, VhdlCompileInfo compileInfo, boolean isProcedure, int subprogramKind, DataType dataType, List<ArgInfo> arguments, List<ArgInfo> generics, boolean hasBody, LineInfo lineInfo, LineInfo argEndInfo, IHidHolder hidHolder, CommentBlock comment, boolean isVhdlAms) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfFunctionsHolder holder = enclosing.getLocalMember(RfFunctionsHolder.class, name);
            if (holder == null) {
                holder = new RfFunctionsHolder(name);
                enclosing.addMember(holder);
            }
            name = RfProject.getFunctionFullName(name, arguments, dataType, hasBody);
            RfFunction existing = holder.getLocalMember(RfFunction.class, name);
            RfDefElement def = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(def);
            if (foundElem != null) {
                def = foundElem;
                if (existing != null && existing == foundElem.getLastNamedElement()) {
                    this.pushScope(def, existing);
                    this.updateFunctionArgumentHids(hidHolder, enclosing, existing);
                    return def;
                }
            }
            RfFunction function = null;
            RfFunction rfFunction = existing = existing == null || !existing.hasNoDefs(true) ? null : existing;
            if (existing != null) {
                function = existing;
                if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(function.getDataType())) {
                    this.fIncrementalDeltaContainer.changedDataTypeElements.add(function);
                }
                function.init(name, isProcedure, subprogramKind, dataType);
            } else {
                String functionName;
                function = new RfFunction(name, isProcedure, subprogramKind, dataType);
                if (!isVhdlAms && ("now".equals(functionName = function.getName()) && dataType != null && "real".equals(dataType.getFirstTypeName()) || "frequency".equals(functionName))) {
                    return def;
                }
                holder.addMember(function);
                function.setEnclosingScope(enclosing, false);
            }
            function.addDeclaration(def);
            function.setCompileInfo(compileInfo);
            this.pushScope(def, function);
            this.updateFunctionArgumentHids(hidHolder, enclosing, function);
            if (generics != null) {
                for (ArgInfo argInfo : generics) {
                    if (argInfo == null) continue;
                    if (argInfo.getKind() == 0x200000) {
                        RfDefElement typeDef = this.startType(argInfo.getName(), compileInfo, RfType.TypeKind.IS_GENERIC, null, argInfo.getStartInfo(), argInfo.getStartInfo(), argInfo.getComment());
                        this.endType(typeDef, argInfo.getStartInfo(), null, null);
                        continue;
                    }
                    this.startVariable(argInfo.getName(), compileInfo, 2, argInfo.getKind(), argInfo.getDirection(), argInfo.getDataType(), argInfo.getInitialValue(), argInfo.getStartInfo(), argEndInfo, argInfo.getComment());
                }
            }
            if (arguments != null) {
                for (ArgInfo argInfo : arguments) {
                    if (argInfo == null) continue;
                    String mode = argInfo.getDirection();
                    int kind = argInfo.getKind();
                    if (kind == 0) {
                        kind = isProcedure && ("out".equals(mode) || "inout".equals(mode)) ? 8192 : 16384;
                    }
                    this.startVariable(argInfo.getName(), compileInfo, 8, kind, mode, argInfo.getDataType(), argInfo.getInitialValue(), argInfo.getStartInfo(), argEndInfo, argInfo.getComment());
                }
            }
            return def;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void updateFunctionArgumentHids(IHidHolder hidHolder, RfNamedElement enclosing, RfFunction function) {
        if (hidHolder != null) {
            RfHidHolder functionHidHolder = function.getOrCreateHidHolder();
            functionHidHolder.addOperators(hidHolder);
            RfHidHolder upperScopeHidHolder = enclosing.getOrCreateHidHolder();
            upperScopeHidHolder.addIdentifiersWithScope(hidHolder, function);
        }
    }

    public static String getFunctionFullName(String name, List<ArgInfo> arguments, DataType dataType, boolean hasBody) {
        boolean hasReturn;
        boolean hasArguments = arguments != null && !arguments.isEmpty();
        boolean bl = hasReturn = dataType != null && dataType.getTypeName() != null && !dataType.getTypeName().isEmpty();
        if (!hasArguments && !hasReturn) {
            return String.valueOf(name) + "@a:" + "@r:" + "@b:" + hasBody;
        }
        String argumentsSignature = "";
        if (arguments != null && !arguments.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (ArgInfo argument : arguments) {
                List<DataTypeChunk> typeName;
                DataType argDataType = argument.getDataType();
                if (argDataType == null || (typeName = argDataType.getTypeName()) == null || typeName.isEmpty()) continue;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(typeName.get((int)(typeName.size() - 1)).name.toLowerCase());
            }
            argumentsSignature = sb.toString();
        }
        String typeSignature = "";
        if (dataType != null && dataType.getTypeName() != null && !dataType.getTypeName().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (DataTypeChunk typeName : dataType.getTypeName()) {
                if (sb.length() != 0) {
                    sb.append(".");
                }
                sb.append(typeName.name);
            }
            typeSignature = sb.toString();
        }
        return String.valueOf(name) + "@a:" + argumentsSignature + "@r:" + typeSignature + "@b:" + hasBody;
    }

    public void endFunction(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startContext(String name, VhdlCompileInfo compileInfo, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfContext context = enclosing.getLocalMember(RfContext.class, name, this.fIncrementalBuild);
            RfDefElement contextDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(contextDef);
            if (foundElem != null) {
                contextDef = foundElem;
                if (context != null && context == foundElem.getLastNamedElement()) {
                    this.pushScope(contextDef, context);
                    return contextDef;
                }
            }
            RfContext rfContext = context = context == null || !context.hasNoDefs(true) ? null : context;
            if (context == null) {
                context = new RfContext(name);
                enclosing.addMember(context);
            } else {
                context.init(name);
            }
            contextDef = context.addDeclaration(contextDef);
            context.setCompileInfo(compileInfo);
            this.pushScope(contextDef, context);
            return contextDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endContext(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startPackage(String name, VhdlCompileInfo compileInfo, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfDefElement packagDef;
            RfDefElement foundElem;
            this.fCurrentPackageName = name;
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfPackage packag = enclosing.getLocalMember(RfPackage.class, name, this.fIncrementalBuild);
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(packagDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment))) != null) {
                packagDef = foundElem;
                if (packag != null && packag == foundElem.getLastNamedElement()) {
                    this.pushScope(packagDef, packag);
                    return packagDef;
                }
            }
            RfPackage rfPackage = packag = packag == null || !packag.hasNoDefs(true) ? null : packag;
            if (packag == null) {
                packag = new RfPackage(name);
                enclosing.addMember(packag);
            } else {
                packag.init(name);
            }
            packagDef = packag.addDeclaration(packagDef);
            packag.setCompileInfo(compileInfo);
            this.pushScope(packagDef, packag);
            return packagDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endPackage(RfDefElement def, LineInfo lineInfo, int packageKind) {
        try {
            this.fCurrentPackageName = null;
            def.setEndOffset(lineInfo);
            ((RfPackage)def.getLastNamedElement()).setPackageKind(packageKind);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startPackageBody(String name, VhdlCompileInfo compileInfo, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfDefElement packagDef;
            RfDefElement foundElem;
            this.fCurrentPackageName = name;
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfPackageBody packag = enclosing.getLocalMember(RfPackageBody.class, name, this.fIncrementalBuild);
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(packagDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment))) != null) {
                packagDef = foundElem;
                if (packag != null && packag == foundElem.getLastNamedElement()) {
                    this.pushScope(packagDef, packag);
                    return packagDef;
                }
            }
            RfPackageBody rfPackageBody = packag = packag == null || !packag.hasNoDefs(true) ? null : packag;
            if (packag == null) {
                packag = new RfPackageBody(name);
                enclosing.addMember(packag);
            } else {
                packag.init(name);
            }
            packagDef = packag.addDeclaration(packagDef);
            packag.setCompileInfo(compileInfo);
            this.pushScope(packagDef, packag);
            return packagDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endPackageBody(RfDefElement def, LineInfo lineInfo) {
        try {
            this.fCurrentPackageName = null;
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startProcess(String name, VhdlCompileInfo compileInfo, boolean isAllSensitivityList, LineInfo lineInfo, CommentBlock comment) {
        try {
            if (name == null) {
                name = RfNamedElement.getUniqueNameForAnonymous(this.fCurrentFileDef.getParserPath(), lineInfo);
            }
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfProcess process = enclosing.getLocalMember(RfProcess.class, name, this.fIncrementalBuild);
            RfDefElement processDef = new RfDefElementWithLabel(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(processDef);
            if (foundElem != null) {
                processDef = foundElem;
                if (process != null && process == foundElem.getLastNamedElement()) {
                    this.pushScope(processDef, process);
                    return processDef;
                }
            }
            RfProcess rfProcess = process = process == null || !process.hasNoDefs(true) ? null : process;
            if (process == null) {
                process = new RfProcess(name, isAllSensitivityList);
                enclosing.addMember(process);
            } else {
                process.init(isAllSensitivityList, name);
            }
            processDef = process.addDeclaration(processDef);
            process.setCompileInfo(compileInfo);
            this.pushScope(processDef, process);
            return processDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endProcess(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startAttribute(String name, VhdlCompileInfo compileInfo, DataType dataType, LineInfo lineInfo) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfAttribute attribute = enclosing.getLocalMember(RfAttribute.class, name, this.fIncrementalBuild);
            RfDefElement attributeDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, null);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(attributeDef);
            if (foundElem != null) {
                attributeDef = foundElem;
                if (attribute != null && attribute == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfAttribute rfAttribute = attribute = attribute == null || !attribute.hasNoDefs(true) ? null : attribute;
            if (attribute == null) {
                attribute = new RfAttribute(name, dataType, RfAttribute.AttributeKind.VALUE);
                enclosing.addMember(attribute);
            } else {
                attribute.init(dataType, name, RfAttribute.AttributeKind.VALUE);
            }
            attributeDef = attribute.addDeclaration(attributeDef);
            attribute.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(attributeDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startVariable(String name, VhdlCompileInfo compileInfo, int interfaceKind, int kind, String direction, DataType dataType, String initialValue, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfVariable variable = enclosing.getLocalMember(RfVariable.class, name, this.fIncrementalBuild);
            RfDefElement variableDef = new RfVariableDef(this.fCurrentFileDef, name, startInfo, endInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(variableDef);
            if (foundElem != null) {
                variableDef = foundElem;
                if (variable != null && variable == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfVariable rfVariable = variable = variable == null || !variable.hasNoDefs(true) ? null : variable;
            if (variable == null) {
                variable = new RfVariable(name, interfaceKind, kind, direction, dataType, initialValue);
                enclosing.addMember(variable);
            } else {
                if (interfaceKind == 8) {
                    enclosing.swapElement(variable);
                }
                String prevInitialValue = variable.getInitialValue(false);
                if (interfaceKind == 8 && this.fIncrementalDeltaContainer != null && (initialValue != null && !initialValue.equals(prevInitialValue) || initialValue == null && prevInitialValue != null)) {
                    this.fIncrementalDeltaContainer.removeElement(variable.getEnclosingScope());
                }
                if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(variable.getDataType())) {
                    this.fIncrementalDeltaContainer.changedDataTypeElements.add(variable);
                }
                variable.init(name, interfaceKind, kind, direction, dataType, initialValue);
            }
            variableDef = variable.addDeclaration(variableDef);
            variable.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(variableDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfAlias startAlias(String name, VhdlCompileInfo compileInfo, DataType dataType, DataType aliasedDataType, int interfaceKind, int aliasKind, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfAlias alias = enclosing.getLocalMember(RfAlias.class, name, this.fIncrementalBuild);
            RfDefElement aliasDef = new RfDefElement(this.fCurrentFileDef, name, startInfo, endInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(aliasDef);
            if (foundElem != null) {
                aliasDef = foundElem;
                if (alias != null && alias == foundElem.getLastNamedElement()) {
                    return alias;
                }
            }
            RfAlias rfAlias = alias = alias == null || !alias.hasNoDefs(true) ? null : alias;
            if (alias == null) {
                alias = new RfAlias(name, interfaceKind, dataType, aliasedDataType, aliasKind);
                enclosing.addMember(alias);
            } else {
                alias.init(interfaceKind, dataType, aliasedDataType, aliasKind, name);
            }
            aliasDef = alias.addDeclaration(aliasDef);
            alias.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(aliasDef);
            return alias;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void startPort(String name, VhdlCompileInfo compileInfo, String direction, DataType dataType, String initialValue, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfPort port = enclosing.getLocalMember(RfPort.class, name, this.fIncrementalBuild);
            RfDefElement portDef = new RfPortDef(this.fCurrentFileDef, name, startInfo, endInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(portDef);
            if (foundElem != null) {
                portDef = foundElem;
                if (port != null && port == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfPort rfPort = port = port == null || !port.hasNoDefs(true) ? null : port;
            if (port == null) {
                port = new RfPort(name, direction, dataType, initialValue);
                enclosing.addMember(port);
            } else {
                enclosing.swapElement(port);
                if (this.fIncrementalBuild && this.fIncrementalDeltaContainer != null && dataType != null && !dataType.equalsChangedFieldAndMethodDataType(port.getDataType())) {
                    this.fIncrementalDeltaContainer.changedDataTypeElements.add(port);
                }
                port.init(direction, dataType, initialValue, name);
            }
            portDef = port.addDeclaration(portDef);
            port.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(portDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Class internalGetTypeClass(RfType.TypeKind typeKind) {
        if (typeKind == RfType.TypeKind.IS_RECORD) {
            return RfRecordType.class;
        }
        if (typeKind == RfType.TypeKind.IS_ARRAY || typeKind == RfType.TypeKind.IS_UNBOUND_ARRAY) {
            return RfListType.class;
        }
        if (typeKind == RfType.TypeKind.IS_ENUM_SCALAR || typeKind == RfType.TypeKind.IS_NUMERIC_SCALAR) {
            return RfScalarType.class;
        }
        return RfType.class;
    }

    public List<IRfPackageElement> getOtherLangPackagesWithPrefix(String prefix, int matchType) {
        return this.fMixedLangProjectParent.getPackagesWithPrefix((IRfSingleLangProject)this, prefix, matchType);
    }

    public void putStandardType(IRfNamedElement element, IRfVhdlTypeElement.VhdlStdType type) {
        this.fRfProjectContent.fPredefinedTypeHolder.putStandardType(element, type);
        this.fRfProjectContent.fPredefinedTypeHolder.putStandardDataType(SDataType.of(element), type);
    }

    public IRfNamedElement getStandardType(IRfVhdlTypeElement.VhdlStdType type) {
        return this.fRfProjectContent.fPredefinedTypeHolder.getStandardType(type);
    }

    public ISDataType getStandardDataType(IRfVhdlTypeElement.VhdlStdType type) {
        return this.fRfProjectContent.fPredefinedTypeHolder.getStandardDataType(type);
    }

    public PredefinedTypeHolder getPredefinedTypesCache() {
        return this.fRfProjectContent.fPredefinedTypeHolder;
    }

    public RfType internalStartType(String name, RfType.TypeKind typeKind, DataType dataType) {
        if (this.fCurrentFileDef.isPredefined()) {
            if ("DVT81b441bd_ANY_ARRAY".equals(name)) {
                RfAnyListType listType = new RfAnyListType(name, typeKind, dataType, this.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), true);
                this.putStandardType(listType, IRfVhdlTypeElement.VhdlStdType.ANY_ARRAY);
                return listType;
            }
            if ("DVT81b441bd_ANY_FILE".equals(name)) {
                RfAnyListType listType = new RfAnyListType(name, typeKind, dataType, this.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_FILE), true);
                this.putStandardType(listType, IRfVhdlTypeElement.VhdlStdType.ANY_FILE);
                return listType;
            }
            if ("DVT81b441bd_ANY_ACCESS".equals(name)) {
                RfType type = new RfType(name, typeKind, dataType);
                this.putStandardType(type, IRfVhdlTypeElement.VhdlStdType.ANY_ACCESS);
                return type;
            }
            if ("DVT81b441bd_ANY_BOOLEAN_ARRAY".equals(name)) {
                RfAnyListType listType = new RfAnyListType(name, typeKind, dataType, this.getStandardType(IRfVhdlTypeElement.VhdlStdType.BOOLEAN), true);
                this.putStandardType(listType, IRfVhdlTypeElement.VhdlStdType.ANY_BOOLEAN_ARRAY);
                return listType;
            }
            if ("DVT81b441bd_ANY_BIT_ARRAY".equals(name)) {
                RfAnyListType listType = new RfAnyListType(name, typeKind, dataType, this.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT), true);
                this.putStandardType(listType, IRfVhdlTypeElement.VhdlStdType.ANY_BIT_ARRAY);
                return listType;
            }
            if ("STRING".equalsIgnoreCase(name)) {
                RfListType rfListType = new RfListType(name, typeKind, dataType);
                this.putStandardType(rfListType, IRfVhdlTypeElement.VhdlStdType.STRING);
                return rfListType;
            }
            if ("bit_vector".equalsIgnoreCase(name)) {
                RfListType rfListType = new RfListType(name, typeKind, dataType);
                this.putStandardType(rfListType, IRfVhdlTypeElement.VhdlStdType.BIT_VECTOR);
                return rfListType;
            }
            if (typeKind == RfType.TypeKind.IS_ENUM_SCALAR || typeKind == RfType.TypeKind.IS_NUMERIC_SCALAR) {
                RfScalarType rfScalarType = new RfScalarType(name, typeKind, dataType);
                if ("DVT81b441bd_UNIVERSAL_INTEGER".equals(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.INTEGER);
                } else if ("DVT81b441bd_UNIVERSAL_REAL".equals(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.REAL);
                } else if ("DVT81b441bd_ANY_PHYSICAL".equals(name)) {
                    rfScalarType.setHasPhysicalUnits(true);
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.ANY_PHYSICAL);
                } else if ("std_ulogic".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.STD_ULOGIC);
                } else if ("character".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.CHARACTER);
                } else if ("severity_level".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.SEVERITY_LEVEL);
                } else if ("boolean".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.BOOLEAN);
                } else if ("time".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.TIME);
                } else if ("bit".equalsIgnoreCase(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.BIT);
                } else if ("DVT81b441bd_ANY_TYPE".equals(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.ANY_TYPE);
                } else if ("DVT81b441bd_ANY_SCALAR_OR_ARRAY".equals(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.ANY_SCALAR_OR_ARRAY);
                } else if ("DVT81b441bd_ANY_CHARACTER_TYPE".equals(name)) {
                    this.putStandardType(rfScalarType, IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER);
                }
                return rfScalarType;
            }
        }
        if (typeKind == RfType.TypeKind.IS_RECORD) {
            return new RfRecordType(name, typeKind, dataType);
        }
        if (typeKind == RfType.TypeKind.IS_ARRAY || typeKind == RfType.TypeKind.IS_UNBOUND_ARRAY) {
            return new RfListType(name, typeKind, dataType);
        }
        if (typeKind == RfType.TypeKind.IS_ENUM_SCALAR || typeKind == RfType.TypeKind.IS_NUMERIC_SCALAR) {
            return new RfScalarType(name, typeKind, dataType);
        }
        return new RfType(name, typeKind, dataType);
    }

    public RfDefElement startType(String name, VhdlCompileInfo compileInfo, RfType.TypeKind typeKind, DataType dataType, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        try {
            RfDefElement typeDef;
            RfDefElement foundElem;
            RfNamedElement enclosing = this.fScopeStack.peek();
            Class clazz = this.internalGetTypeClass(typeKind);
            RfType type = (RfType)enclosing.getLocalMember(clazz, name, this.fIncrementalBuild);
            if (this.fIncrementalDeltaContainer != null && !(enclosing instanceof RfActionBlock)) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(typeDef = new RfDefElement(this.fCurrentFileDef, name, startInfo, endInfo, comment))) != null) {
                typeDef = foundElem;
                if (type != null && type == foundElem.getLastNamedElement()) {
                    this.pushScope(typeDef, type);
                    return typeDef;
                }
            }
            RfType rfType = type = type == null || !type.hasNoDefs(true) ? null : type;
            if (type == null) {
                type = this.internalStartType(name, typeKind, dataType);
                enclosing.addMember(type);
            } else {
                type.init(typeKind, dataType, name);
            }
            typeDef = type.addDeclaration(typeDef);
            type.setCompileInfo(compileInfo);
            this.pushScope(typeDef, type);
            return typeDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endType(RfDefElement def, LineInfo lineInfo, RfType.TypeKind typeKind, DataType elementDataType) {
        try {
            def.setEndOffset(lineInfo);
            ((RfType)def.getLastNamedElement()).init(typeKind, elementDataType, false, null);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfDefElement startTypeBody(String name, VhdlCompileInfo compileInfo, RfType.TypeKind typeKind, DataType dataType, LineInfo startInfo, LineInfo endInfo, CommentBlock comment) {
        try {
            RfDefElement typeBodyDef;
            RfDefElement foundElem;
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfTypeBody typeBody = enclosing.getLocalMember(RfTypeBody.class, name, this.fIncrementalBuild);
            if (this.fIncrementalDeltaContainer != null && !(enclosing instanceof RfActionBlock)) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            if ((foundElem = this.fCurrentFileDef.findDefElement(typeBodyDef = new RfDefElement(this.fCurrentFileDef, name, startInfo, endInfo, comment))) != null) {
                typeBodyDef = foundElem;
                if (typeBody != null && typeBody == foundElem.getLastNamedElement()) {
                    this.pushScope(typeBodyDef, typeBody);
                    return typeBodyDef;
                }
            }
            RfTypeBody rfTypeBody = typeBody = typeBody == null || !typeBody.hasNoDefs(true) ? null : typeBody;
            if (typeBody == null) {
                typeBody = new RfTypeBody(name);
                enclosing.addMember(typeBody);
            } else {
                typeBody.init(name);
            }
            typeBodyDef = typeBody.addDeclaration(typeBodyDef);
            typeBody.setCompileInfo(compileInfo);
            this.pushScope(typeBodyDef, typeBody);
            return typeBodyDef;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endTypeBody(RfDefElement def, LineInfo lineInfo) {
        try {
            def.setEndOffset(lineInfo);
            this.popScope(def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startEnum(String name, VhdlCompileInfo compileInfo, int ordinal, int kind, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            if (!(enclosing instanceof RfType)) {
                return;
            }
            if (this.fIncrementalDeltaContainer != null) {
                this.fIncrementalDeltaContainer.changedTypeNames.add(name);
            }
            RfNamedElement enclosingScope = enclosing.getEnclosingScope();
            RfEnum enumElement = enclosingScope.getLocalMember(RfEnum.class, name, this.fIncrementalBuild);
            RfDefElement enumElementDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(enumElementDef);
            if (foundElem != null) {
                enumElementDef = foundElem;
                if (enumElement != null && enumElement == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfEnum rfEnum = enumElement = enumElement == null || !enumElement.hasNoDefs(true) ? null : enumElement;
            if (enclosing instanceof RfType && name != null && !name.isEmpty() && name.startsWith("'")) {
                ((RfType)enclosing).setCharacterTypeEnum();
            }
            if (enumElement == null) {
                enumElement = new RfEnum(name, ordinal, kind, enclosing);
                enclosing.addMember(enumElement);
            } else {
                enumElement.init(name, ordinal, kind, enclosing);
            }
            if (enclosing instanceof RfScalarType) {
                enclosingScope.addEnumElement(enumElement);
            }
            enumElementDef = enumElement.addDeclaration(enumElementDef);
            enumElement.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(enumElementDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startRecordElement(String name, VhdlCompileInfo compileInfo, DataType dataType, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            if (!(enclosing instanceof RfType)) {
                return;
            }
            ((RfType)enclosing).setTypeKind(RfType.TypeKind.IS_RECORD);
            RfVariable recordVar = enclosing.getLocalMember(RfVariable.class, name, this.fIncrementalBuild);
            RfDefElement recordDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(recordDef);
            if (foundElem != null) {
                recordDef = foundElem;
                if (recordVar != null && recordVar == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfVariable rfVariable = recordVar = recordVar == null || !recordVar.hasNoDefs(true) ? null : recordVar;
            if (recordVar == null) {
                recordVar = new RfVariable(name, 1, 262144, null, dataType, null);
                enclosing.addMember(recordVar);
            } else {
                recordVar.init(name, 1, 262144, null, dataType, null);
            }
            recordDef = recordVar.addDeclaration(recordDef);
            recordVar.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(recordDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startPropertySequence(String name, VhdlCompileInfo compileInfo, int kind, LineInfo lineInfo, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            RfPropertySequence propSeq = enclosing.getLocalMember(RfPropertySequence.class, name, this.fIncrementalBuild);
            RfDefElement propSeqDef = new RfDefElement(this.fCurrentFileDef, name, lineInfo, lineInfo, comment);
            RfDefElement foundElem = this.fCurrentFileDef.findDefElement(propSeqDef);
            if (foundElem != null) {
                propSeqDef = foundElem;
                if (propSeq != null && propSeq == foundElem.getLastNamedElement()) {
                    return;
                }
            }
            RfPropertySequence rfPropertySequence = propSeq = propSeq == null || !propSeq.hasNoDefs(true) ? null : propSeq;
            if (propSeq == null) {
                propSeq = new RfPropertySequence(name, kind);
                enclosing.addMember(propSeq);
            } else {
                propSeq.init(kind, name);
            }
            propSeqDef = propSeq.addDeclaration(propSeqDef);
            propSeq.setCompileInfo(compileInfo);
            this.fCurrentFileDef.addChildDef(propSeqDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setIncrementalChangedImports(boolean incrementalChangedImports, String packageName, RfNamedElement scope) {
        if (this.fIncrementalDeltaContainer == null) {
            return;
        }
        Set<RfNamedElement> importScopes = this.fIncrementalDeltaContainer.changedImportPackageNames.get(packageName);
        if (importScopes == null) {
            importScopes = Collections.newSetFromMap(new IdentityHashMap());
            this.fIncrementalDeltaContainer.changedImportPackageNames.put(packageName, importScopes);
        }
        importScopes.add(scope);
    }

    public boolean isInChangedImportScope(IRfNamedElement candidate) {
        if (this.fIncrementalDeltaContainer == null) {
            return false;
        }
        if (this.fIncrementalDeltaContainer.changedImportPackageNames.isEmpty()) {
            return false;
        }
        if (candidate == null || candidate instanceof RfAssociatedType.RfUnresolvedInfo) {
            return false;
        }
        if (!(candidate instanceof RfNamedElement)) {
            return false;
        }
        RfPackage packageScope = (RfPackage)candidate.getEnclosingScope(RfPackage.class);
        if (packageScope == null) {
            return false;
        }
        String packageName = packageScope.getName();
        return this.fIncrementalDeltaContainer.changedImportPackageNames.containsKey(packageName);
    }

    public void startStdUse(ImportInfo imp, RfNamedElement scope) {
        try {
            if (!(imp instanceof ImportInfo.StdImportInfo)) {
                return;
            }
            if (scope == null) {
                scope = this.fScopeStack.peek();
            }
            if (scope instanceof RfLibrary) {
                return;
            }
            if (scope instanceof RfArchitecture && !scope.getEnclosingScope().isImplicit()) {
                return;
            }
            if (scope instanceof RfPackageBody && ((RfPackageBody)scope).getPackage() != null) {
                return;
            }
            List<ImportInfo> uses = scope.getWildcardUse();
            if (uses != null && !uses.isEmpty()) {
                for (ImportInfo use : uses) {
                    if (!(use instanceof ImportInfo.StdImportInfo)) continue;
                }
            }
            scope.addWildcardUse(imp);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean startUse(List<DataTypeChunk> use, VhdlCompileInfo compileInfo, ImportInfo.ImportInfoKind importInfoKind, int line, int offset, RfNamedElement importScope) {
        boolean foundSTDStandard = false;
        try {
            if (use == null || use.size() <= 1 && importInfoKind != ImportInfo.ImportInfoKind.LIBRARY_CLAUSE) {
                return foundSTDStandard;
            }
            if (importScope == null) {
                importScope = this.fScopeStack.peek();
            }
            if (importScope instanceof RfLibrary) {
                return foundSTDStandard;
            }
            boolean found = false;
            DataTypeChunk useInfo = importInfoKind == ImportInfo.ImportInfoKind.LIBRARY_CLAUSE ? use.get(0) : use.remove(use.size() - 1);
            foundSTDStandard = use.size() == 2 && VHDL_STD_LIB.equalsIgnoreCase(use.get(0).toString()) && VHDL_STANDARD_PACKAGE.equalsIgnoreCase(use.get(1).toString());
            String useName = useInfo.name;
            ParserPath parserPath = this.fCurrentFileDef.getParserPath();
            if (useName.equalsIgnoreCase("all")) {
                if (importScope.fWildcardUses != null && !importScope.fWildcardUses.isEmpty()) {
                    for (ImportInfo importInfo : importScope.fWildcardUses) {
                        if (!use.equals(importInfo.getUseClauseList()) || parserPath == null || !parserPath.equals((Object)importInfo.getParserPath()) || importInfo.getLine() != line) continue;
                        found = true;
                        importInfo.setDirty(false);
                        break;
                    }
                }
                if (!found) {
                    ImportInfo importInfo;
                    importInfo = new ImportInfo(use, null, importInfoKind, line, useInfo.offset, parserPath);
                    importScope.addWildcardUse(importInfo);
                    importInfo.setCompileInfo(compileInfo);
                    this.setIncrementalChangedImports(true, useName, importScope);
                }
            } else if (importInfoKind != ImportInfo.ImportInfoKind.LIBRARY_CLAUSE) {
                if (importScope.fExplicitUses != null && !importScope.fExplicitUses.isEmpty()) {
                    for (ImportInfo importInfo : importScope.fExplicitUses) {
                        if (!use.equals(importInfo.getUseClauseList()) || !useName.equals(importInfo.getExplicitName()) || parserPath == null || !parserPath.equals((Object)importInfo.getParserPath()) || importInfo.getLine() != line) continue;
                        found = true;
                        importInfo.setDirty(false);
                        break;
                    }
                }
                if (!found) {
                    ImportInfo importInfo;
                    importInfo = new ImportInfo(use, useName, importInfoKind, line, useInfo.offset, parserPath);
                    importScope.addExplicitUse(importInfo);
                    importInfo.setCompileInfo(compileInfo);
                    this.setIncrementalChangedImports(true, importInfo.getExplicitName(), importScope);
                }
            } else {
                if (importScope.fLibraryClauses != null && !importScope.fLibraryClauses.isEmpty()) {
                    for (ImportInfo importInfo : importScope.fLibraryClauses) {
                        if (!use.equals(importInfo.getUseClauseList()) || parserPath == null || !parserPath.equals((Object)importInfo.getParserPath()) || importInfo.getLine() != line) continue;
                        found = true;
                        importInfo.setDirty(false);
                        break;
                    }
                }
                if (!found) {
                    ImportInfo importInfo;
                    importInfo = new ImportInfo(use, null, importInfoKind, line, useInfo.offset, parserPath);
                    importInfo.setCompileInfo(compileInfo);
                    importScope.addLibraryClause(importInfo);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return foundSTDStandard;
    }

    private void pushScope(RfDefElement elemDef, RfNamedElement namedElem) {
        RfDefElement addedElem = elemDef;
        this.fScopeStack.push(namedElem);
        if (!this.fCurrentFileDef.stackContains(elemDef)) {
            addedElem = this.fCurrentFileDef.addChildDef(elemDef);
        }
        this.fCurrentFileDef.pushPhysicalScope(addedElem);
    }

    private void popScope(RfDefElement defElement) {
        if (this.checkAndRestoreScopeStack(defElement)) {
            this.fScopeStack.pop();
            this.fCurrentFileDef.popPhysicalScope();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkAndRestoreScopeStack(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        namedElement = defElement.getLastNamedElement();
        if (this.fScopeStack.peek() == namedElement) {
            return true;
        }
        if (this.fScopeStack.contains(namedElement)) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            this.fScopeStack.pop();
            this.fCurrentFileDef.popPhysicalScope();
lbl12:
            // 2 sources

            ** while (this.fScopeStack.peek() != namedElement)
        }
lbl13:
        // 1 sources

        return true;
    }

    public DVTEditor getEditor(ParserPath parserPath) {
        if (this.fParserPathToEditorMap == null) {
            return null;
        }
        return this.fParserPathToEditorMap.get(parserPath);
    }

    public List<RfNamedElement> getAllTypes(boolean isSubtype, boolean includePredefined) {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        List<RfNamedElement> scopes = this.getAllDeclarationScopes(true);
        for (RfNamedElement scope : scopes) {
            List<RfType> types;
            if (!includePredefined && scope.isPredefined() || (types = scope.getLocalMembers(RfType.class)) == null || types.isEmpty()) continue;
            for (RfType type : types) {
                if (!includePredefined && type.isPredefined() || type.isSubtype() != isSubtype) continue;
                result.add(type);
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllDeclarationScopes(boolean includeFunctions) {
        NullProtectedList<RfNamedElement> scopes = new NullProtectedList<RfNamedElement>();
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                scopes.addAll(library.getLocalMembers(RfPackage.class));
                scopes.addAll(library.getLocalMembers(RfPackageBody.class));
                List<RfEntity> entities = library.getLocalMembers(RfEntity.class);
                if (entities == null || entities.isEmpty()) continue;
                scopes.addAll(entities);
                for (RfEntity entity : entities) {
                    List<RfArchitecture> architectures = entity.getLocalMembers(RfArchitecture.class);
                    if (architectures == null || architectures.isEmpty()) continue;
                    scopes.addAll(architectures);
                    for (RfArchitecture architecture : architectures) {
                        scopes.addAll(architecture.getAllLocalBlocks());
                        scopes.addAll(architecture.getAllLocalProcesses());
                    }
                    scopes.addAll(entity.getLocalMembers(RfConfiguration.class));
                }
            }
        }
        if (!includeFunctions) {
            return scopes;
        }
        NullProtectedList<RfFunction> firstLevefFunctions = new NullProtectedList<RfFunction>();
        for (RfNamedElement scope : scopes) {
            firstLevefFunctions.addAll(scope.getLocalMembers(RfFunction.class));
        }
        scopes.addAll(firstLevefFunctions);
        return scopes;
    }

    public List<RfNamedElement> getAllFunctions(boolean isProcedure) {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        List<RfNamedElement> scopes = this.getAllDeclarationScopes(false);
        for (RfNamedElement candidate : scopes) {
            List<RfFunctionsHolder> functionHolders = candidate.getLocalMembers(RfFunctionsHolder.class);
            if (functionHolders == null) continue;
            for (RfFunctionsHolder functionHolder : functionHolders) {
                List<RfFunction> functions;
                if (functionHolder == null || (functions = functionHolder.getLocalMembers(RfFunction.class)) == null || functions.isEmpty()) continue;
                for (RfFunction function : functions) {
                    if (function.isTask() != isProcedure) continue;
                    result.add(function);
                }
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllVariables(int kind) {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        List<RfNamedElement> scopes = this.getAllDeclarationScopes(true);
        for (RfNamedElement scope : scopes) {
            List<RfVariable> variables = scope.getLocalMembers(RfVariable.class);
            if (variables == null || variables.isEmpty()) continue;
            for (RfVariable variable : variables) {
                if (variable.getFieldKind() != kind) continue;
                result.add(variable);
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllComponents() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                List<RfNamedElement> architectures;
                result.addAll(library.getLocalMembers(RfComponent.class));
                List<RfPackage> packages = library.getLocalMembers(RfPackage.class);
                if (packages != null && !packages.isEmpty()) {
                    for (RfPackage pckg : packages) {
                        result.addAll(pckg.getLocalMembers(RfComponent.class));
                    }
                }
                if ((architectures = this.getAllArchitectures()) == null || architectures.isEmpty()) continue;
                for (RfNamedElement architecture : architectures) {
                    result.addAll(architecture.getLocalMembers(RfComponent.class));
                    Collection<RfBlock> allBlocks = ((RfArchitecture)architecture).getAllLocalBlocks();
                    if (allBlocks == null || allBlocks.isEmpty()) continue;
                    for (RfBlock block : allBlocks) {
                        result.addAll(block.getLocalMembers(RfComponent.class));
                    }
                }
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllPorts() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        List<RfNamedElement> elements = this.getAllEntities();
        if (elements != null && !elements.isEmpty()) {
            for (RfNamedElement element : elements) {
                result.addAll(element.getLocalMembers(RfPort.class));
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllEntities() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                result.addAll(library.getLocalMembers(RfEntity.class));
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllPackages() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries != null && !libraries.isEmpty()) {
            for (RfLibrary library : libraries) {
                result.addAll(library.getLocalMembers(RfPackage.class));
            }
        }
        return result;
    }

    public List<RfNamedElement> getAllArchitectures() {
        NullProtectedList<RfNamedElement> result = new NullProtectedList<RfNamedElement>();
        List<RfNamedElement> entities = this.getAllEntities();
        if (entities != null && !entities.isEmpty()) {
            for (RfNamedElement entity : entities) {
                result.addAll(entity.getLocalMembers(RfArchitecture.class));
            }
        }
        return result;
    }

    public List<RfNamedElement> getLocalTypes(RfNamedElement element, boolean includePredefined, boolean sortByType, boolean hideDuplicates) {
        return this.getLocalTypes(element, includePredefined, sortByType, hideDuplicates, new RfNamedElementComparator());
    }

    public List<RfNamedElement> getLocalTypes(RfNamedElement element, boolean includePredefined, boolean sortByType, boolean hideDuplicates, Comparator<? super RfNamedElement> comparator) {
        List<RfNamedElement> allConfigurations;
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        int index0 = 0;
        if (element instanceof RfLibrary && (allConfigurations = ((RfLibrary)element).getAllConfigurations()) != null && !allConfigurations.isEmpty()) {
            elements.addAll(allConfigurations);
        }
        int index1 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfPackage.class));
        if (element instanceof RfArchitecture && ((RfArchitecture)element).getEntity() != null) {
            elements.addAll(((RfArchitecture)element).getEntity().getLocalMembers(hideDuplicates, RfPackage.class));
        }
        int index2 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfPackageBody.class));
        if (element instanceof RfArchitecture && ((RfArchitecture)element).getEntity() != null) {
            elements.addAll(((RfArchitecture)element).getEntity().getLocalMembers(hideDuplicates, RfPackageBody.class));
        }
        int index3 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfType.class));
        if (element instanceof RfArchitecture && ((RfArchitecture)element).getEntity() != null) {
            elements.addAll(((RfArchitecture)element).getEntity().getLocalMembers(hideDuplicates, RfType.class));
        }
        int index4 = elements.size();
        elements.addAll(element.getLocalMembers(hideDuplicates, RfTypeBody.class));
        if (element instanceof RfArchitecture && ((RfArchitecture)element).getEntity() != null) {
            elements.addAll(((RfArchitecture)element).getEntity().getLocalMembers(hideDuplicates, RfTypeBody.class));
        }
        int index5 = elements.size();
        List<RfEntity> entities = element.getLocalMembers(hideDuplicates, RfEntity.class);
        if (entities != null) {
            for (RfEntity entity : entities) {
                List<RfArchitecture> architectures = entity.getArchitectures();
                if (architectures != null && !architectures.isEmpty()) {
                    elements.addAll(architectures);
                    continue;
                }
                elements.add(entity);
            }
        }
        int index6 = elements.size();
        RfNamedElement[] result = elements.toArray(new RfNamedElement[elements.size()]);
        if (sortByType) {
            Arrays.sort(result, index0, index1, comparator);
            Arrays.sort(result, index1, index2, comparator);
            Arrays.sort(result, index2, index3, comparator);
            Arrays.sort(result, index3, index4, comparator);
            Arrays.sort(result, index4, index5, comparator);
            Arrays.sort(result, index5, index6, comparator);
        }
        return Arrays.asList(result);
    }

    public Collection<RfLibrary> getLibraries() {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return this.fRfProjectContent.fLibraries.values();
    }

    public Collection<RfLibrary> getLibrariesByNames(Set<String> libraryNames) {
        if (libraryNames == null) {
            return this.fRfProjectContent.fLibraries.values();
        }
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>();
        for (String libraryName : libraryNames) {
            RfLibrary library = this.getLocalLibrary(libraryName);
            if (library == null) continue;
            result.add(library);
        }
        return result;
    }

    public RfLibrary getLocalLibrary(String name) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return (RfLibrary)this.fRfProjectContent.fLibraries.get(this.adjustLibraryName(name));
    }

    @Override
    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetLocalMembersWithPrefix(resultMap, RfLibrary.class, prefix, null, false, matchType);
        return new NullProtectedList<RfLibrary>((Collection<RfLibrary>)resultMap.values());
    }

    @Override
    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.internalGetLocalMembersWithPrefix(resultMap, RfLibrary.class, prefix, null, true, matchType);
        return resultMap.isEmpty() ? null : (RfLibrary)resultMap.values().iterator().next();
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name) {
        if (this.fRfProjectContent.fLibraries == null || this.fRfProjectContent.fLibraries.isEmpty() || clazz != RfLibrary.class) {
            return null;
        }
        RfLibrary firstLib = (RfLibrary)this.fRfProjectContent.fLibraries.iterator().next();
        RfNamedElement candidate = (RfNamedElement)this.fRfProjectContent.fLibraries.get(firstLib.translateLibraryName(this.adjustLibraryName(name)));
        if (candidate instanceof RfDuplicate) {
            return ((RfDuplicate)candidate).getLastMember(clazz);
        }
        if (candidate == null || !clazz.isInstance(candidate)) {
            return null;
        }
        return (T)candidate;
    }

    @Override
    public RfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        if (this.fRfProjectContent.fLibraries == null || this.fRfProjectContent.fLibraries.isEmpty() || classes != null && !classes.contains(RfLibrary.class)) {
            return null;
        }
        RfLibrary firstLib = (RfLibrary)this.fRfProjectContent.fLibraries.iterator().next();
        RfNamedElement candidate = (RfNamedElement)this.fRfProjectContent.fLibraries.get(firstLib.translateLibraryName(this.adjustLibraryName(name)));
        if (candidate instanceof RfDuplicate) {
            return ((RfDuplicate)candidate).getLastMember(classes);
        }
        if (candidate != null && (classes == null || classes.contains(candidate.getClass()))) {
            return candidate;
        }
        return null;
    }

    @Override
    public <T extends IRfNamedElement> List<T> getLocalMembers(Class<T> clazz) {
        if (this.fRfProjectContent.fLibraries == null || clazz != RfLibrary.class) {
            return null;
        }
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>(this.fRfProjectContent.fLibraries.size());
        for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
            result.add(library);
        }
        return result;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumParentTypeNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (this.fRfProjectContent.fLibraries == null || this.fRfProjectContent.fLibraries.isEmpty() || classes != null && !classes.contains(RfLibrary.class)) {
            return null;
        }
        RfLibrary firstLib = (RfLibrary)this.fRfProjectContent.fLibraries.iterator().next();
        RfNamedElement candidate = (RfNamedElement)this.fRfProjectContent.fLibraries.get(firstLib.translateLibraryName(this.adjustLibraryName(name)));
        if (candidate instanceof RfDuplicate) {
            String enumParentTypeName = enumParentTypeNameProposals != null && enumParentTypeNameProposals.size() == 1 ? enumParentTypeNameProposals.get(0) : "";
            return ((RfDuplicate)candidate).getLastMember(classes, enumParentTypeName);
        }
        return candidate;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unit";
    }

    public Map<ParserPath, DVTEditor> getFileEditors() {
        return this.fParserPathToEditorMap;
    }

    public static IPath getExtensionsPath(IProject project, String ext) {
        IPath stateLocation = ro.amiq.vhdldt.utils.Utils.getInstance().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(project.getName()) + EXTENSIONS_PREFIX + ext);
        return topLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSemanticError(int severity, String pattern, LibraryPackageScope libraryPackageScope, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (severity == 1 && !this.isSemanticErrorCheck()) {
            return true;
        }
        if (severity == 2 && !this.isSemanticWarningCheck()) {
            return true;
        }
        if (parserPath == null) {
            return true;
        }
        String resourcePath = this.parser2resource(parserPath);
        Object object = this.fSemanticErrorsLock;
        synchronized (object) {
            SemanticErrorsTable.LastProblemEntry removedProblem;
            boolean maxSizeReached;
            int nofProblems;
            SemanticErrorsTable.ErrorsAndWarnings errorsAndWarnings;
            int maxSemanticIssuesPerFile;
            block10: {
                maxSemanticIssuesPerFile = this.getMaxSemanticIssuesPerFile();
                errorsAndWarnings = this.fSemanticErrors.getNofErrorsAndWarnings(this.fSemanticErrorCategory, resourcePath);
                nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
                maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
                removedProblem = null;
                if (maxSizeReached) {
                    removedProblem = errorsAndWarnings.removeLastErrorOrWarningAfterLine(this.fSemanticErrorCategory, severity, line);
                    nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
                    boolean bl = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
                }
                if (!maxSizeReached) break block10;
                return true;
            }
            String libraryName = libraryPackageScope.getLibraryName();
            String packageName = libraryPackageScope.getPackageName();
            String message = MessageFormat.format(pattern, arguments);
            RfSemanticError error = new RfSemanticError(severity, message, this.getFileIndex(parserPath), libraryName, packageName, line, resourcePath);
            if (offsetStart != -1 && offsetEnd != -1) {
                error.setOffsetStart(offsetStart);
                error.setOffsetEnd(offsetEnd);
            }
            error.setAttributes(attributes);
            errorsAndWarnings.addErrorOrWarning(this.fSemanticErrorCategory, libraryPackageScope.getClosestTypeContainer(), error);
            nofProblems = severity == 1 ? errorsAndWarnings.nofErrors : errorsAndWarnings.nofWarnings;
            boolean bl = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            if (removedProblem != null && !maxSizeReached) {
                errorsAndWarnings.addErrorOrWarning(this.fSemanticErrorCategory, removedProblem.lastTypeContainer, removedProblem.lastProblem);
            }
        }
        return true;
    }

    public final int getFileIndex(ParserPath parserPath) {
        RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return -1;
        }
        return fileDef.getIndex();
    }

    @Override
    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        try {
            super.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
            if (this.fRfProjectContent.fLibraries != null) {
                this.resolveUses(this.getLibraries().iterator(), rfProject, report, onlyUnresolved, otherLanguage);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void resolveUses(IncrementalDeltaContainer container, final RfProject rfProject, final boolean report, final boolean onlyUnresolved, final boolean otherLanguage) {
        try {
            Map<ParserPath, Set<IRfNamedElement>> delta;
            IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    if (namedElement.isPredefined()) {
                        return false;
                    }
                    if (namedElement instanceof RfDuplicate) {
                        return true;
                    }
                    namedElement.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
                    return true;
                }
            };
            Map<ParserPath, Collection<RfNamedElement>> firstLevelElementsInFile = container.firstLevelElements;
            RfNamedElement enclosingScopeOfCurrentFile = null;
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            if (firstLevelElementsInFile != null && !firstLevelElementsInFile.isEmpty()) {
                for (Collection<RfNamedElement> firstLevelElements : firstLevelElementsInFile.values()) {
                    if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : firstLevelElements) {
                        if (enclosingScopeOfCurrentFile == null) {
                            enclosingScopeOfCurrentFile = firstLevelElement.getEnclosingScope();
                        }
                        if (this.alreadyVisited(visited, firstLevelElement)) continue;
                        firstLevelElement.accept(rfProject, visitor);
                    }
                }
            }
            if (enclosingScopeOfCurrentFile != null) {
                enclosingScopeOfCurrentFile.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
            }
            if ((delta = container.delta) != null && !delta.isEmpty()) {
                for (Set<IRfNamedElement> changedElements : delta.values()) {
                    if (changedElements == null || changedElements.isEmpty()) continue;
                    for (IRfNamedElement changedElement : changedElements) {
                        if (!(changedElement instanceof RfNamedElement) || this.alreadyVisited(visited, changedElement)) continue;
                        ((RfNamedElement)changedElement).accept(rfProject, visitor);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void resolveTypesIncremental(ConfigInfo configInfo, boolean triggerError, boolean onlyUnresolved, boolean otherLanguage, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, Set<IRfNamedElement> visited) {
        try {
            String libraryName;
            RfLibrary library;
            Set<String> onlyPkgNames;
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> collection : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    if (collection == null || collection.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : collection) {
                        onlyPkgNames = null;
                        if (onlyLibAndPkgNames != null) {
                            library = firstLevelElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, firstLevelElement)) continue;
                        configInfo.enclosingLibrary = firstLevelElement.getEnclosingLibrary();
                        firstLevelElement.resolveTypes(configInfo, this, triggerError && !firstLevelElement.isPredefined(), onlyUnresolved, otherLanguage, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.delta != null && !this.fIncrementalDeltaContainer.delta.isEmpty()) {
                for (Set set : this.fIncrementalDeltaContainer.delta.values()) {
                    if (set == null || set.isEmpty()) continue;
                    for (IRfNamedElement changedElement : set) {
                        if (!(changedElement instanceof RfNamedElement)) continue;
                        onlyPkgNames = null;
                        if (onlyLibAndPkgNames != null) {
                            library = (RfLibrary)changedElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, changedElement)) continue;
                        configInfo.enclosingLibrary = ((RfNamedElement)changedElement).getEnclosingLibrary();
                        ((RfNamedElement)changedElement).resolveTypes(configInfo, this, triggerError && !changedElement.isPredefined(), onlyUnresolved, otherLanguage, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                    }
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
    }

    private void resolveTypes2(Collection<RfLibrary> libraries, boolean report, boolean onlyUnresolved, boolean otherLanguage, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean disableRTLChecks) {
        try {
            if (libraries == null) {
                return;
            }
            this.initExecutorService(true);
            for (RfLibrary library : libraries) {
                this.checkBuildCanceled();
                Set<String> onlyPkgNames = null;
                if (onlyLibAndPkgNames != null && !library.isPredefined()) {
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(library.getName()) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(library.getName())) continue;
                    onlyPkgNames = onlyLibAndPkgNames.get(library.getName());
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                }
                ConfigInfo configInfo = new ConfigInfo(this.fIncrementalBuild, this, library, disableRTLChecks, this.getToolCompat());
                library.resolveTypes2(configInfo, this, report, onlyUnresolved, otherLanguage, fullChecksKind, onlyPkgNames);
            }
            this.shutdownExecutorService();
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void resolveTypesPredefinedLibraries(Collection<RfLibrary> libraries) {
        if (libraries == null) {
            return;
        }
        boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
        for (RfLibrary library : libraries) {
            if (!library.isPredefined()) continue;
            this.initExecutorService(true);
            try {
                ConfigInfo configInfo = new ConfigInfo(this.fIncrementalBuild, this, library, disableRTLChecks, this.getToolCompat());
                library.resolveTypes2(configInfo, this, true, true, true, null, null);
            }
            finally {
                this.shutdownExecutorService();
            }
        }
    }

    private final void checkForDuplicates(Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.checkForDuplicates(visited, libraries, fullChecksKind, onlyLibAndPkgNames);
    }

    private final void checkForDuplicates(IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.checkForDuplicates(visited, container, fullChecksKind, onlyLibAndPkgNames);
    }

    private final void checkForDuplicates(Set<IRfNamedElement> visited, Collection<RfLibrary> libraries, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        for (RfNamedElement rfNamedElement : libraries) {
            Set<String> onlyPkgNames = null;
            if (onlyLibAndPkgNames != null) {
                String libraryName = rfNamedElement.getName();
                if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
            }
            this.checkForDuplicates(rfNamedElement, fullChecksKind, onlyPkgNames, visited, null, true);
        }
    }

    private final void checkForDuplicates(Set<IRfNamedElement> visited, IncrementalDeltaContainer container, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        if (container.firstLevelElements != null && !container.firstLevelElements.isEmpty()) {
            for (Collection<RfNamedElement> firstLevelElements : container.firstLevelElements.values()) {
                if (firstLevelElements == null || firstLevelElements.isEmpty()) continue;
                for (RfNamedElement firstLevelElement : firstLevelElements) {
                    RfNamedElement enclosingScope;
                    RfDuplicate duplicateCandidate;
                    Set<String> onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library = firstLevelElement.getEnclosingLibrary();
                        if (library == null) continue;
                        String libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                        onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                    }
                    if ((duplicateCandidate = (enclosingScope = firstLevelElement.getEnclosingScope()).getLocalMember(RfDuplicate.class, firstLevelElement.getName(), false)) != null) {
                        this.checkForDuplicates(duplicateCandidate, fullChecksKind, onlyPkgNames, visited, null, false);
                        continue;
                    }
                    this.checkForDuplicates(firstLevelElement, fullChecksKind, onlyPkgNames, visited, null, false);
                }
            }
        }
        if (container.currentFileScopes != null && !container.currentFileScopes.isEmpty()) {
            Set<ParserPath> changedFiles = container.parserPaths;
            for (RfNamedElement currentFileEnclosingScope : container.currentFileScopes) {
                Set<String> onlyPkgNames = null;
                if (onlyLibAndPkgNames != null) {
                    RfLibrary library = currentFileEnclosingScope.getEnclosingLibrary();
                    if (library == null) continue;
                    String libraryName = library.getName();
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                    onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                }
                this.checkForDuplicates(currentFileEnclosingScope, fullChecksKind, onlyPkgNames, visited, changedFiles, true);
            }
        }
    }

    private final void checkForDuplicates(RfNamedElement root, FullChecksKind fullChecksKind, Set<String> onlyPkgNames, Set<IRfNamedElement> visited, Set<ParserPath> changedFiles, boolean recursive) {
        if (root.isPredefined() && root.hasNoDefs(false)) {
            return;
        }
        if (visited.contains(root)) {
            return;
        }
        visited.add(root);
        if (onlyPkgNames != null && root instanceof RfPackage) {
            if (fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(root.getName())) {
                return;
            }
            if (fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(root.getName())) {
                return;
            }
        }
        if (recursive && onlyPkgNames != null && root instanceof RfLibrary) {
            Collection<RfNamedElement> members = root.getMembers();
            if (members != null && !members.isEmpty()) {
                for (RfNamedElement member : members) {
                    if (!(member instanceof RfPackage) || fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(member.getName()) || fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(member.getName())) continue;
                    this.checkForDuplicates(member, fullChecksKind, onlyPkgNames, visited, changedFiles, recursive);
                }
            }
            return;
        }
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement element) {
                try {
                    Map<Boolean, List<RfNamedElement>> membersPerKind;
                    if (element instanceof RfDuplicate && (membersPerKind = RfProject.this.getDuplicateMembersPerKind(element)) != null) {
                        for (List<RfNamedElement> members : membersPerKind.values()) {
                            if (members.size() == 1) continue;
                            RfNamedElement member1 = null;
                            RfDefElement declaration1 = null;
                            RfNamedElement member1arch = null;
                            RfDefElement declaration1arch = null;
                            RfNamedElement member1conf = null;
                            RfDefElement declaration1conf = null;
                            RfDefElement declaration2 = null;
                            for (RfNamedElement member : members) {
                                HashMap<String, Object> attributes;
                                int startOffset;
                                ParserPath parserPath2;
                                ParserPath parserPath1;
                                int line1;
                                if (member instanceof RfAlias && member1 instanceof RfAlias || member instanceof RfActionBlock && ((RfActionBlock)member).isAnonymous()) continue;
                                boolean isArchitecture = member instanceof RfArchitecture;
                                boolean isConfiguration = member instanceof RfConfiguration;
                                if (declaration1arch == null && isArchitecture) {
                                    declaration1arch = member.getDeclaration();
                                    member1arch = member;
                                    continue;
                                }
                                if (declaration1conf == null && isConfiguration) {
                                    declaration1conf = member.getDeclaration();
                                    member1conf = member;
                                    continue;
                                }
                                if (declaration1 == null && !isConfiguration && !isArchitecture) {
                                    declaration1 = member.getDeclaration();
                                    member1 = member;
                                    continue;
                                }
                                declaration2 = member.getDeclaration();
                                if (member instanceof RfVUnit && member1 instanceof RfEntity || member instanceof RfEntity && member1 instanceof RfVUnit) continue;
                                if (member instanceof RfBlock && member1 instanceof RfBlock) {
                                    int index1 = ((RfBlock)member1).getGenerateConstructIndex();
                                    int index2 = ((RfBlock)member).getGenerateConstructIndex();
                                    String alternativeLabel1 = ((RfBlock)member1).getAlternativeLabel();
                                    String alternativeLabel2 = ((RfBlock)member).getAlternativeLabel();
                                    if (index1 == index2 && (alternativeLabel1 == null || alternativeLabel2 == null || !alternativeLabel1.equals(alternativeLabel2))) continue;
                                }
                                if (member instanceof RfArchitecture && member1arch != null && declaration1arch != null && declaration2 != null) {
                                    LibraryPackageScope libPkgScope = member.getLibPkgScope();
                                    line1 = declaration1arch.getStartLabelLine();
                                    int line2 = declaration2.getStartLabelLine();
                                    parserPath1 = declaration1arch.getParserPath();
                                    parserPath2 = declaration2.getParserPath();
                                    startOffset = declaration2.getStartLabelOffset();
                                    String name = member.getName();
                                    int endOffset = startOffset + name.length();
                                    if (declaration1arch.getDefFile() == declaration2.getDefFile() && declaration1arch.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                    attributes = new HashMap<String, Object>(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                    attributes.put("QUICKFIX_KIND", 11);
                                    if (!member.getClass().equals(member1arch.getClass())) {
                                        RfProject.this.addSemanticError(1, "DUPLICATE_NAME: Duplicate name ''{0}'' already declared\n    at line {1,number,#######} in {2}", libPkgScope, startOffset, endOffset, attributes, line2, parserPath2, name, line1, parserPath1);
                                        continue;
                                    }
                                    if (declaration1arch.getDefFile() == declaration2.getDefFile() && declaration1arch.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                    RfProject.this.addSemanticError(member.getSemanticErrorSeverityForDuplicate(), member.getSemanticErrorCodeForDuplicate(), libPkgScope, startOffset, endOffset, attributes, line2, parserPath2, name, line1, parserPath1);
                                    continue;
                                }
                                if (member instanceof RfConfiguration && member1conf != null && declaration1conf != null && declaration2 != null) {
                                    LibraryPackageScope libPkgScope = member.getLibPkgScope();
                                    line1 = declaration1conf.getStartLabelLine();
                                    int line2 = declaration2.getStartLabelLine();
                                    parserPath1 = declaration1conf.getParserPath();
                                    parserPath2 = declaration2.getParserPath();
                                    startOffset = declaration2.getStartLabelOffset();
                                    String name = member.getName();
                                    int endOffset = startOffset + name.length();
                                    if (declaration1conf.getDefFile() == declaration2.getDefFile() && declaration1conf.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                    attributes = new HashMap(4);
                                    attributes.put("QUICKFIX_ELEMENT_NAME", name);
                                    attributes.put("QUICKFIX_KIND", 11);
                                    if (!member.getClass().equals(member1conf.getClass())) {
                                        RfProject.this.addSemanticError(1, "DUPLICATE_NAME: Duplicate name ''{0}'' already declared\n    at line {1,number,#######} in {2}", libPkgScope, startOffset, endOffset, attributes, line2, parserPath2, name, line1, parserPath1);
                                        continue;
                                    }
                                    if (declaration1conf.getDefFile() == declaration2.getDefFile() && declaration1conf.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                    RfProject.this.addSemanticError(member.getSemanticErrorSeverityForDuplicate(), member.getSemanticErrorCodeForDuplicate(), libPkgScope, startOffset, endOffset, attributes, line2, parserPath2, name, line1, parserPath1);
                                    continue;
                                }
                                if (member1 == null || declaration1 == null || declaration2 == null) continue;
                                boolean isAlias1 = member1 instanceof RfAlias;
                                boolean isAlias2 = member instanceof RfAlias;
                                boolean isEnum1 = member1 instanceof RfEnum;
                                boolean isEnum2 = member instanceof RfEnum;
                                if (isAlias1 && !isAlias2 || !isAlias1 && isAlias2 || isEnum1 && !isEnum2 || !isEnum1 && isEnum2 || isEnum1 && isEnum2 && !((RfEnum)member1).getParentEnumTypeName().equalsIgnoreCase(((RfEnum)member).getParentEnumTypeName()) || member1 instanceof RfFunction && member instanceof RfFunction && !((RfFunction)member1).equals(member, true)) continue;
                                LibraryPackageScope libPkgScope = member.getLibPkgScope();
                                int line12 = declaration1.getStartLabelLine();
                                int line2 = declaration2.getStartLabelLine();
                                ParserPath parserPath12 = declaration1.getParserPath();
                                ParserPath parserPath22 = declaration2.getParserPath();
                                int startOffset2 = declaration2.getStartLabelOffset();
                                String name = member.getName();
                                int endOffset = startOffset2 + name.length();
                                if (declaration1.getDefFile() == declaration2.getDefFile() && declaration1.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                HashMap<String, Object> attributes2 = new HashMap<String, Object>(4);
                                attributes2.put("QUICKFIX_ELEMENT_NAME", name);
                                attributes2.put("QUICKFIX_KIND", 11);
                                if (!member.getClass().equals(member1.getClass())) {
                                    RfProject.this.addSemanticError(1, "DUPLICATE_NAME: Duplicate name ''{0}'' already declared\n    at line {1,number,#######} in {2}", libPkgScope, startOffset2, endOffset, attributes2, line2, parserPath22, name, line12, parserPath12);
                                    continue;
                                }
                                if (declaration1.getDefFile() == declaration2.getDefFile() && declaration1.getStartLabelOffset() == declaration2.getStartLabelOffset()) continue;
                                RfProject.this.addSemanticError(member.getSemanticErrorSeverityForDuplicate(), member.getSemanticErrorCodeForDuplicate(), libPkgScope, startOffset2, endOffset, attributes2, line2, parserPath22, name, line12, parserPath12);
                            }
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return true;
                }
            }
        };
        root.accept(this, visitor);
    }

    private Map<Boolean, List<RfNamedElement>> getDuplicateMembersPerKind(RfNamedElement element) {
        HashMap<Boolean, List<RfNamedElement>> result = new HashMap<Boolean, List<RfNamedElement>>();
        if (element instanceof RfDuplicate) {
            Collection<RfNamedElement> members = element.getMembers();
            if (members != null && !members.isEmpty()) {
                for (RfNamedElement member : members) {
                    boolean isBodyKind = member instanceof RfPackageBody || member instanceof RfTypeBody;
                    ArrayList<RfNamedElement> membersOfKind = (ArrayList<RfNamedElement>)result.get(isBodyKind);
                    if (membersOfKind == null) {
                        membersOfKind = new ArrayList<RfNamedElement>();
                        result.put(isBodyKind, membersOfKind);
                    }
                    membersOfKind.add(member);
                }
            }
        } else {
            boolean isBodyKind = element instanceof RfPackageBody || element instanceof RfTypeBody;
            ArrayList<RfNamedElement> membersOfKind = (ArrayList<RfNamedElement>)result.get(isBodyKind);
            if (membersOfKind == null) {
                membersOfKind = new ArrayList<RfNamedElement>();
                result.put(isBodyKind, membersOfKind);
            }
            membersOfKind.add(element);
        }
        return result;
    }

    public RfFileDef getFileDefUsingParserPath(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.fMixedLangProjectParent;
    }

    public String getNature() {
        return "ro.amiq.vhdldt.VhdlNature";
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public RfProjectState getProjectState() {
        return this.fProjectState;
    }

    public void setProjectState(RfProjectState state) {
        this.fProjectState = state;
    }

    public String parser2resource(ParserPath parserPath) {
        return DVTFileUtils.getInstance().parser2resource(this.fProject, parserPath);
    }

    public ParserPath resource2parser(IResource file) {
        return DVTFileUtils.getInstance().resource2parser(file);
    }

    private Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        return DVTFileUtils.getInstance().resource2parser(changedFiles);
    }

    public void setOverrideRegisterHids(boolean overrideRegisterHids) {
        this.fOverrideRegisterHids = overrideRegisterHids;
    }

    @Override
    public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        if (this.fOverrideRegisterHids) {
            return true;
        }
        RfNamedElement scope = this.fScopeStack.peek();
        return scope instanceof RfFunction || scope instanceof RfArchitecture || scope instanceof RfEntity || scope instanceof RfComponent || scope instanceof RfConfiguration || scope instanceof RfLibrary || scope instanceof RfRulesContainer || scope instanceof IRfPackageElement || scope instanceof IRfVhdlTypeElement || scope instanceof RfType || scope instanceof RfProcess || scope instanceof RfInstance || scope instanceof RfActionBlock || scope instanceof RfVUnit;
    }

    public void newTempHidHolder(boolean force, boolean[] hasTempHidHolder) {
        if (!force && !this.isUndeclaredIdentifierChecks()) {
            return;
        }
        hasTempHidHolder[0] = true;
        this.fOverridedHidHolder.push((IHidHolder)new RfHidHolder(null));
    }

    public IHidHolder getTempHidHolder(boolean[] hasTempHidHolder) {
        if (!hasTempHidHolder[0]) {
            return null;
        }
        hasTempHidHolder[0] = false;
        return this.fOverridedHidHolder.isEmpty() ? null : this.fOverridedHidHolder.pop();
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.updateHolder(updater);
    }

    @Override
    public void addIdentifiers(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.addIdentifiers(updater);
    }

    @Override
    public void addOperators(IHidHolder updater) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return;
        }
        hidHolder.addOperators(updater);
    }

    public RfNamedElement getSemanticScope() {
        return this.fScopeStack != null ? this.fScopeStack.peek() : null;
    }

    private IHidHolder getHidHolderParent() {
        IHidHolder hidHolder;
        IHidHolder iHidHolder = hidHolder = this.fOverridedHidHolder.isEmpty() ? null : this.fOverridedHidHolder.peek();
        if (hidHolder != null && hidHolder != this) {
            return hidHolder;
        }
        return this.getSemanticScope();
    }

    @Override
    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return null;
        }
        if (!this.fOverridedHidHolder.isEmpty()) {
            hidRequest.hid.setSecondaryScope((IRfNamedElement)this.getSemanticScope());
        }
        return hidHolder.addIdentifier(hidRequest, access);
    }

    @Override
    public boolean removeIdentifier(String name) {
        IHidHolder hidHolder = this.getHidHolderParent();
        return hidHolder != null;
    }

    @Override
    public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        IHidHolder hidHolder = this.getHidHolderParent();
        if (hidHolder == null) {
            return null;
        }
        return hidHolder.addOperator(operatorRequest);
    }

    @Override
    public RfHidHolder getHidHolder() {
        return null;
    }

    @Override
    public RfHidHolder getOrCreateHidHolder() {
        return null;
    }

    @Override
    public void setHidHolder(RfHidHolder hidHolder) {
    }

    public boolean isUndeclaredIdentifierChecks() {
        Set onlyPackages;
        FullChecksKind fullChecksKind;
        block17: {
            block16: {
                Map onlyLibAndPkgNames;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                try {
                                    fullChecksKind = this.fFullCompileChecks.getFullChecksKind(false);
                                    onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(false);
                                    if (fullChecksKind != FullChecksKind.FULL) break block12;
                                    return true;
                                }
                                catch (Exception ex) {
                                    DVTLogger.INSTANCE.logError((Throwable)ex);
                                    return true;
                                }
                            }
                            if (fullChecksKind != FullChecksKind.OFF) break block13;
                            return false;
                        }
                        if (this.fCurrentLibraryName != null) break block14;
                        return false;
                    }
                    if (onlyLibAndPkgNames != null) break block15;
                    return false;
                }
                if (fullChecksKind == FullChecksKind.LIBS) {
                    return onlyLibAndPkgNames.containsKey(this.fCurrentLibraryName);
                }
                if (fullChecksKind == FullChecksKind.NOT_LIBS) {
                    return !onlyLibAndPkgNames.containsKey(this.fCurrentLibraryName);
                }
                onlyPackages = (Set)onlyLibAndPkgNames.get(this.fCurrentLibraryName);
                if (onlyPackages != null) break block16;
                return false;
            }
            if (this.fCurrentPackageName != null) break block17;
            return false;
        }
        if (fullChecksKind == FullChecksKind.PKGS) {
            return onlyPackages.contains(this.fCurrentPackageName);
        }
        if (fullChecksKind == FullChecksKind.NOT_PKGS) {
            return !onlyPackages.contains(this.fCurrentPackageName);
        }
        return false;
    }

    protected synchronized boolean isUndeclaredIdentifierChecks(RfLibrary library) {
        FullChecksKind fullChecksKind = this.fFullCompileChecks.getFullChecksKind(false);
        Map onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(false);
        return this.isUndeclaredIdentifierChecks((Enum<FullChecksKind>)fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, library);
    }

    private synchronized boolean isUndeclaredIdentifierChecks(Enum<FullChecksKind> fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, RfLibrary library) {
        if (fullChecksKind == FullChecksKind.FULL) {
            return true;
        }
        if (fullChecksKind == FullChecksKind.OFF) {
            return false;
        }
        if (library == null) {
            return false;
        }
        if (onlyLibAndPkgNames == null) {
            return false;
        }
        String libraryName = library.getName();
        if (fullChecksKind == FullChecksKind.LIBS) {
            return onlyLibAndPkgNames.containsKey(libraryName);
        }
        if (fullChecksKind == FullChecksKind.NOT_LIBS) {
            return !onlyLibAndPkgNames.containsKey(libraryName);
        }
        return false;
    }

    protected synchronized boolean isUndeclaredIdentifierChecks(RfBlock packageElement) {
        FullChecksKind fullChecksKind = this.fFullCompileChecks.getFullChecksKind(false);
        Map onlyLibAndPkgNames = this.fFullCompileChecks.getLibraryAndPackageNames(false);
        return this.isUndeclaredIdentifierChecks((Enum<FullChecksKind>)fullChecksKind, (Map<String, Set<String>>)onlyLibAndPkgNames, packageElement);
    }

    private synchronized boolean isUndeclaredIdentifierChecks(Enum<FullChecksKind> fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, RfBlock packag) {
        if (fullChecksKind == FullChecksKind.FULL) {
            return true;
        }
        if (fullChecksKind == FullChecksKind.OFF) {
            return false;
        }
        if (packag == null) {
            return false;
        }
        if (onlyLibAndPkgNames == null) {
            return false;
        }
        RfLibrary library = packag.getEnclosingLibrary();
        if (library == null) {
            return false;
        }
        String libraryName = library.getName();
        if (fullChecksKind == FullChecksKind.LIBS) {
            return onlyLibAndPkgNames.containsKey(libraryName);
        }
        if (fullChecksKind == FullChecksKind.NOT_LIBS) {
            return !onlyLibAndPkgNames.containsKey(libraryName);
        }
        Set<String> onlyPackages = onlyLibAndPkgNames.get(libraryName);
        if (onlyPackages == null) {
            return false;
        }
        String packageName = packag.getName();
        if (fullChecksKind == FullChecksKind.PKGS) {
            return onlyPackages.contains(packageName);
        }
        if (fullChecksKind == FullChecksKind.NOT_PKGS) {
            return !onlyPackages.contains(packageName);
        }
        return false;
    }

    private final boolean alreadyVisited(Set<IRfNamedElement> visited, IRfNamedElement element) {
        if (visited == null) {
            return false;
        }
        if (visited.contains(element)) {
            return true;
        }
        visited.add(element);
        return false;
    }

    protected void resolveHidsIncremental(ConfigInfo configInfo, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean triggerError, boolean disableExprEvaluate, Set<IRfNamedElement> visited) {
        try {
            Set<String> onlyPkgNames;
            String libraryName;
            RfLibrary library;
            if (DVTLogger.INSTANCE.isDebugMode()) {
                fCount1.set(0);
                fCount2.set(0);
                fCount4.set(0);
            }
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> collection : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    if (collection == null || collection.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : collection) {
                        if (onlyLibAndPkgNames != null) {
                            library = firstLevelElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, firstLevelElement)) continue;
                        configInfo.enclosingLibrary = firstLevelElement.getEnclosingLibrary();
                        firstLevelElement.resolveHids(configInfo, triggerError && !firstLevelElement.isPredefined(), disableExprEvaluate, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.delta != null && !this.fIncrementalDeltaContainer.delta.isEmpty()) {
                for (Set set : this.fIncrementalDeltaContainer.delta.values()) {
                    if (set == null || set.isEmpty()) continue;
                    for (IRfNamedElement changedElement : set) {
                        if (!(changedElement instanceof RfNamedElement)) continue;
                        if (onlyLibAndPkgNames != null) {
                            library = (RfLibrary)changedElement.getEnclosingLibrary();
                            if (library == null) continue;
                            libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (this.alreadyVisited(visited, changedElement)) continue;
                        configInfo.enclosingLibrary = ((RfNamedElement)changedElement).getEnclosingLibrary();
                        ((RfNamedElement)changedElement).resolveHids(configInfo, triggerError && !changedElement.isPredefined(), disableExprEvaluate, IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER);
                    }
                }
            }
            if (this.fIncrementalDeltaContainer.currentFileScopes != null && !this.fIncrementalDeltaContainer.currentFileScopes.isEmpty()) {
                for (RfNamedElement rfNamedElement : this.fIncrementalDeltaContainer.currentFileScopes) {
                    if (rfNamedElement == null) continue;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library2 = rfNamedElement.getEnclosingLibrary();
                        if (library2 == null) continue;
                        String libraryName2 = library2.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName2) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName2)) continue;
                        Set<String> onlyPkgNames2 = onlyLibAndPkgNames.get(libraryName2);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames2 == null || onlyPkgNames2.isEmpty())) continue;
                    }
                    if (this.alreadyVisited(visited, rfNamedElement)) continue;
                    configInfo.enclosingLibrary = rfNamedElement.getEnclosingLibrary();
                    rfNamedElement.resolveLocalHids(configInfo, triggerError && !rfNamedElement.isPredefined(), disableExprEvaluate);
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
        if (DVTLogger.INSTANCE.isDebugMode()) {
            ro.amiq.vhdldt.test.TestHelper.out.println("Nof hids checks = " + fCount1);
            ro.amiq.vhdldt.test.TestHelper.out.println("Nof associated types = " + fCount2);
            ro.amiq.vhdldt.test.TestHelper.out.println("Nof removed action blocks = " + fCount3);
            ro.amiq.vhdldt.test.TestHelper.out.println("Compute associated types time = " + fCount4 + " ms");
            fCount3.set(0);
        }
    }

    private boolean checkCustomPragmas(Set<ParserPath> parserPaths) {
        boolean printResult = false;
        if (parserPaths == null) {
            return false;
        }
        List customPragmas = BuildConfigManager.getCustomPragmas((IProject)this.getProject());
        Set preprocessTranslatePragmas = BuildConfigManager.getPreprocessTranslatePragmas((IProject)this.getProject());
        if ((customPragmas == null || customPragmas.isEmpty()) && (preprocessTranslatePragmas == null || preprocessTranslatePragmas.isEmpty())) {
            return false;
        }
        long time = System.currentTimeMillis();
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        for (ParserPath parserPath : parserPaths) {
            List<CustomPragmaUsage> customPragmasUsages = ro.amiq.vhdldt.utils.Utils.getCustomPragmas(this, parserPath);
            if (customPragmasUsages == null || customPragmasUsages.isEmpty()) continue;
            printResult = true;
            ArrayDeque<CustomPragmaUsage> workingPragmas = new ArrayDeque<CustomPragmaUsage>();
            ArrayList<CustomPragmaUsage> sortedPragmas = new ArrayList<CustomPragmaUsage>();
            for (CustomPragmaUsage pragma : customPragmasUsages) {
                int errorType;
                int n = errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
                if (pragma.getKind() == CustomPragmaUsage.Kind.START) {
                    if (workingPragmas.size() < 3) {
                        workingPragmas.push(pragma);
                        continue;
                    }
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, new Object[0]);
                    continue;
                }
                if (workingPragmas.isEmpty()) {
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getStartPragma());
                    sortedPragmas.add(pragma);
                    continue;
                }
                CustomPragmaUsage stackPragma = (CustomPragmaUsage)workingPragmas.pop();
                if (!stackPragma.getPragmaName().equals(pragma.getPragmaName())) {
                    this.addSemanticError(errorType, "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, stackPragma.getPragma().getEndPragma(), pragma.getPragma().getEndPragma());
                    workingPragmas.push(stackPragma);
                    sortedPragmas.add(pragma);
                    continue;
                }
                stackPragma.setValid();
                pragma.setValid();
                sortedPragmas.add(stackPragma);
                sortedPragmas.add(pragma);
            }
            while (!workingPragmas.isEmpty()) {
                CustomPragmaUsage pragma;
                pragma = (CustomPragmaUsage)workingPragmas.pop();
                sortedPragmas.add(pragma);
                int errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getEndPragma());
            }
            ro.amiq.vhdldt.utils.Utils.setCustomPragmas(this, parserPath, sortedPragmas);
        }
        DVTLogger.INSTANCE.logInfo("VHDLDT Custom pragma checks time = " + (System.currentTimeMillis() - time) + " ms");
        return printResult;
    }

    private void checkIsElaborated(IRfPackageElement packageElem, ConfigInfo configInfo, boolean triggerError, FullChecksKind fullChecksKind, Set<String> onlyPkgNames, Set<IRfNamedElement> visited) {
        this.checkBuildCanceled();
        if (this.alreadyVisited(visited, (IRfNamedElement)packageElem)) {
            return;
        }
        if ((packageElem instanceof RfPackage || packageElem instanceof RfPackageBody) && packageElem.getSemanticEnableRaw() == 0) {
            if (packageElem.isPredefined()) {
                return;
            }
            IRfLibraryElement enclosingLibrary = packageElem.getEnclosingLibrary();
            IRfDefElement declaration = packageElem.getDeclaration();
            String pkgName = packageElem.getName();
            if (packageElem instanceof RfPackage && !this.fPackageConstantsDisabled && triggerError && !packageElem.isPredefined() && declaration != null && enclosingLibrary != null) {
                this.addSemanticError(2, "UNELABORATED_{0}: {1} ''{2}.{3}'' is not elaborated", packageElem.getLibPkgScope(), declaration.getStartOffset(), declaration.getStartOffset() + pkgName.length(), null, packageElem.getLine(), declaration.getParserPath(), "PACKAGE", "Package", enclosingLibrary.getName(), pkgName);
            }
            if (onlyPkgNames != null && fullChecksKind == FullChecksKind.PKGS && !onlyPkgNames.contains(pkgName)) {
                return;
            }
            if (onlyPkgNames != null && fullChecksKind == FullChecksKind.NOT_PKGS && onlyPkgNames.contains(pkgName)) {
                return;
            }
            if (packageElem instanceof RfPackage) {
                RfPackage pkg = (RfPackage)packageElem;
                pkg.resolveHids(configInfo, triggerError && !packageElem.isPredefined(), false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                RfPackageBody pBody = pkg.getPackageBody();
                if (pBody != null) {
                    pBody.resolveHids(configInfo, triggerError && !packageElem.isPredefined(), false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
                }
            } else {
                ((RfPackageBody)packageElem).resolveHids(configInfo, triggerError && !packageElem.isPredefined(), false, RfLibrary.ELABCONSTANTS_SKIPPED_MEMBERS);
            }
            packageElem.setSemanticEnable((byte)1);
        }
    }

    private void checkIsElaborated(ConfigInfo configInfo, RfEntity top, ELManagerConfiguration elabLocalConfig, boolean triggerError, EnumSet<ElaborationDebugZone> elabDebug, Set<IRfNamedElement> visited, Set<ParserPath> visitedLibraryFiles) {
        List<RfArchitecture> topArchitectures;
        this.checkBuildCanceled();
        if (top == null || top.isImplicit()) {
            return;
        }
        if (this.alreadyVisited(visited, top)) {
            return;
        }
        RfDefElement declaration = top.getDeclaration();
        if (top.getSemanticEnableRaw() < 3) {
            RfLibrary enclosingLibrary = top.getEnclosingLibrary();
            if (enclosingLibrary == null) {
                return;
            }
            if (declaration == null) {
                return;
            }
            if (triggerError) {
                String type = DesignUtils.getDesignKindInstanceText((IRfScopeElement)top);
                String entityName = top.getName();
                this.addSemanticError(2, "UNELABORATED_{0}: {1} ''{2}.{3}'' is not elaborated", top.getLibPkgScope(), top.getOffset(), top.getOffset() + entityName.length(), null, top.getLine(), declaration.getParserPath(), type.toUpperCase(), DVTStringUtil.toTitleCase((String)type), enclosingLibrary.getName(), entityName);
            }
        }
        if ((topArchitectures = top.getArchitectures()) != null && !topArchitectures.isEmpty()) {
            for (RfArchitecture topArchitecture : topArchitectures) {
                Collection<? extends IRfBlockElement> firstLevelGenerates;
                if (this.alreadyVisited(visited, topArchitecture)) continue;
                if (topArchitecture.getSemanticEnableRaw() == 0) {
                    topArchitecture.elaborateLocal(ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), elabDebug, (IProgressMonitor)(this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor()));
                }
                if ((firstLevelGenerates = topArchitecture.getLocalGenerateBlocks()) == null) continue;
                for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
                    RfProject.internalCheckIsElaboratedGenerate(iRfBlockElement, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), elabDebug, (IProgressMonitor)(this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor()));
                }
            }
        } else {
            top.resolveHids(configInfo, triggerError, false, null);
        }
    }

    private static void internalCheckIsElaboratedGenerate(IRfBlockElement top, ELManagerConfiguration elabLocalConfig, ELConstantsManager constantsManager, EnumSet<ElaborationDebugZone> elabDebug, IProgressMonitor progressMonitor) {
        Collection<? extends IRfBlockElement> firstLevelGenerates;
        if (!(top instanceof RfBlock)) {
            return;
        }
        RfBlock generateTop = (RfBlock)top;
        if (generateTop.getSemanticEnableRaw() == 0) {
            top.elaborateLocal(ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, constantsManager, elabDebug, progressMonitor);
        }
        if ((firstLevelGenerates = generateTop.getLocalGenerateBlocks()) != null) {
            for (IRfBlockElement iRfBlockElement : firstLevelGenerates) {
                RfProject.internalCheckIsElaboratedGenerate(iRfBlockElement, elabLocalConfig, constantsManager, elabDebug, progressMonitor);
            }
        }
    }

    protected void checkUnused(Collection<RfLibrary> libraries, Enum<FullChecksKind> fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean incremental, boolean triggerError, boolean disableRTLChecks, Set<ParserPath> changedFiles) throws BuildCancelException {
        long time;
        block8: {
            RfLibrary[] workingCopy;
            time = System.currentTimeMillis();
            if (!triggerError || disableRTLChecks) {
                return;
            }
            if (libraries == null || libraries.isEmpty()) break block8;
            RfLibrary[] rfLibraryArray = workingCopy = libraries.toArray(new RfLibrary[libraries.size()]);
            int n = workingCopy.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    List<RfEntity> entities;
                    RfLibrary library;
                    block9: {
                        library = rfLibraryArray[n2];
                        this.checkBuildCanceled();
                        Set<String> onlyPkgNames = null;
                        if (onlyLibAndPkgNames == null) break block9;
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(library.getName()) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(library.getName())) break block10;
                        onlyPkgNames = onlyLibAndPkgNames.get(library.getName());
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) break block10;
                    }
                    if ((entities = library.getLocalMembers(RfEntity.class)) != null && !entities.isEmpty()) {
                        for (RfEntity entity : entities) {
                            List<RfArchitecture> architectures = entity.getLocalMembers(RfArchitecture.class);
                            if (architectures == null || architectures.isEmpty()) continue;
                            for (RfArchitecture architecture : architectures) {
                                architecture.checkUnused(this, incremental, triggerError, changedFiles);
                            }
                        }
                    }
                }
                ++n2;
            }
            this.shutdownExecutorService();
        }
        DVTLogger.INSTANCE.logInfo("VHDLDT Unused signal checks time = " + (System.currentTimeMillis() - time) + " ms");
    }

    protected void checkUnused(IncrementalDeltaContainer container, Enum<FullChecksKind> fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, boolean incremental, boolean triggerError, boolean disableRTLChecks) throws BuildCancelException {
        try {
            if (!triggerError || disableRTLChecks) {
                return;
            }
            Set visitedEntities = Collections.newSetFromMap(new IdentityHashMap());
            Set visited = Collections.newSetFromMap(new IdentityHashMap());
            if (container.firstLevelElements != null && !container.firstLevelElements.isEmpty()) {
                for (Collection<RfNamedElement> firstLevelElements : container.firstLevelElements.values()) {
                    List<RfArchitecture> architectures;
                    if (firstLevelElements == null || firstLevelElements.isEmpty() || (architectures = this.getAllInstanceHolders(firstLevelElements, container.parserPaths)).isEmpty()) continue;
                    for (RfArchitecture architecture : architectures) {
                        Set<String> onlyPkgNames = null;
                        if (onlyLibAndPkgNames != null) {
                            RfLibrary library = architecture.getEnclosingLibrary();
                            if (library == null) continue;
                            String libraryName = library.getName();
                            if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                            onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                            if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                        }
                        if (visited.contains(architecture)) continue;
                        visited.add(architecture);
                        RfEntity entity = architecture.getEntity();
                        if (!visitedEntities.contains(entity)) {
                            visitedEntities.add(entity);
                            this.fSemanticErrors.clearElement(IRfSingleLangProject.SemanticErrorsCategory.UNUSED_SIGNALS, entity, this);
                        }
                        architecture.checkUnused(this, incremental, triggerError, null);
                    }
                }
            }
            if (container.currentFileScopes != null && !container.currentFileScopes.isEmpty()) {
                Set<ParserPath> changedFiles = container.parserPaths;
                for (RfNamedElement currentFileEnclosingScope : container.currentFileScopes) {
                    Set<String> onlyPkgNames = null;
                    if (onlyLibAndPkgNames != null) {
                        RfLibrary library = currentFileEnclosingScope.getEnclosingLibrary();
                        if (library == null) continue;
                        String libraryName = library.getName();
                        if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName) || fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) continue;
                        onlyPkgNames = onlyLibAndPkgNames.get(libraryName);
                        if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) continue;
                    }
                    if (!(currentFileEnclosingScope instanceof RfArchitecture) || visited.contains(currentFileEnclosingScope)) continue;
                    visited.add(currentFileEnclosingScope);
                    currentFileEnclosingScope.checkUnused(this, incremental, triggerError, changedFiles);
                }
            }
        }
        catch (BuildCancelException buildCancelException) {}
    }

    /*
     * Exception decompiling
     */
    public void checkUnelaborated(boolean triggerError, boolean incremental) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkUnelaboratedIncremental(boolean triggerError, Set<IRfNamedElement> unelaboratedDesigns, Set<IRfPackageElement> dirtyPackages, Set<IRfNamedElement> dirtyNonDesignElements) {
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.UNELABORATED_ELEMENTS;
        long time = System.currentTimeMillis();
        try {
            if (this.fRfProjectContent.fIncrementalElaborationKind == null || this.fRfProjectContent.fIncrementalElaborationKind == IncrementalElaborationKind.NONE) {
                return;
            }
            if (this.fIncrementalDeltaContainer == null) {
                return;
            }
            boolean disableRTLChecks = BuildConfigManager.getDisableRTLChecks((IProject)this.fProject);
            boolean semanticShowAliasName = false;
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            HashSet<ParserPath> visitedLibraryFiles = new HashSet<ParserPath>();
            ELManagerConfiguration elabLocalConfig = ELManagerConfiguration.newElabLocalConfig((IProject)this.getProject(), (int)1, (byte)1, (boolean)semanticShowAliasName, (int)1, (int)1, (boolean)false, (EnumSet)ElaborationControl.UNELABORATED_CONTROL_SET);
            EnumSet elabDebug = BuildConfigManager.getElaborationDebug((IProject)this.fProject);
            EnumSet<ElaborationDebugZone> localDebug = elabDebug.contains(ElaborationDebugZone.EVAL) ? EnumSet.of(ElaborationDebugZone.EVAL) : EnumSet.noneOf(ElaborationDebugZone.class);
            ELManager localManager = new ELManager(this.fMixedLangProjectParent, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, elabLocalConfig, this.fMixedLangProjectParent.getNonElabConstantsManager(), localDebug);
            ConfigInfo configInfo = new ConfigInfo(true, this, null, disableRTLChecks, this.getToolCompat());
            configInfo.setElabContext(ELWidthCheckContext.of((ELParamValues)ELParamValues.EMPTY, Collections.emptyList(), (ELManager)localManager));
            FullChecksAndLibs fullCompileChecks = BuildConfigManager.getFullCompileChecks((IProject)this.getProject());
            Map onlyLibAndPkgNames = fullCompileChecks.getLibraryAndPackageNames(false);
            FullChecksKind fullChecksKind = fullCompileChecks.getFullChecksKind(false);
            for (IRfPackageElement iRfPackageElement : dirtyPackages) {
                IRfLibraryElement enclosingLibrary = iRfPackageElement.getEnclosingLibrary();
                if (!(enclosingLibrary instanceof RfLibrary)) continue;
                Set onlyPkgNames = null;
                if (onlyLibAndPkgNames != null) {
                    String libraryName = enclosingLibrary.getName();
                    if (fullChecksKind == FullChecksKind.LIBS && !onlyLibAndPkgNames.containsKey(libraryName)) {
                        return;
                    }
                    if (fullChecksKind == FullChecksKind.NOT_LIBS && onlyLibAndPkgNames.containsKey(libraryName)) {
                        return;
                    }
                    onlyPkgNames = (Set)onlyLibAndPkgNames.get(libraryName);
                    if (fullChecksKind == FullChecksKind.PKGS && (onlyPkgNames == null || onlyPkgNames.isEmpty())) {
                        return;
                    }
                }
                configInfo.enclosingLibrary = enclosingLibrary;
                this.checkIsElaborated(iRfPackageElement, configInfo, triggerError, fullChecksKind, onlyPkgNames, visited);
            }
            if (this.fIncrementalDeltaContainer.firstLevelElements != null && !this.fIncrementalDeltaContainer.firstLevelElements.isEmpty()) {
                for (Collection collection : this.fIncrementalDeltaContainer.firstLevelElements.values()) {
                    if (collection == null || collection.isEmpty()) continue;
                    for (RfNamedElement firstLevelElement : collection) {
                        if (!(firstLevelElement instanceof RfEntity)) continue;
                        this.checkIsElaborated(configInfo, (RfEntity)firstLevelElement, elabLocalConfig, triggerError, localDebug, visited, visitedLibraryFiles);
                    }
                }
            }
            for (IRfNamedElement iRfNamedElement : unelaboratedDesigns) {
                if (!(iRfNamedElement instanceof RfArchitecture)) continue;
                RfEntity entity = ((RfArchitecture)iRfNamedElement).getEntity();
                this.checkIsElaborated(configInfo, entity, elabLocalConfig, triggerError, localDebug, visited, visitedLibraryFiles);
            }
            this.resolveHidsIncremental(configInfo, fullChecksKind, onlyLibAndPkgNames, true, false, visited);
        }
        catch (BuildCancelException buildCancelException) {}
        DVTLogger.INSTANCE.logInfo("VHDLDT Incremental check unelaborated time = " + (System.currentTimeMillis() - time) + " ms");
    }

    private List<RfArchitecture> getAllInstanceHolders(Collection<? extends RfNamedElement> elements, final Set<ParserPath> changedFiles) {
        final ArrayList<RfArchitecture> result = new ArrayList<RfArchitecture>();
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (namedElement instanceof RfArchitecture) {
                    if (changedFiles != null && !changedFiles.isEmpty()) {
                        RfDefElement declaration = namedElement.getDeclaration();
                        if (declaration == null) {
                            return true;
                        }
                        RfFileDef defFile = declaration.getDefFile();
                        if (defFile == null) {
                            return true;
                        }
                        if (!changedFiles.contains(defFile.getParserPath())) {
                            return true;
                        }
                    }
                    result.add((RfArchitecture)namedElement);
                }
                return namedElement instanceof RfDuplicate;
            }
        };
        if (elements != null && !elements.isEmpty()) {
            for (RfNamedElement rfNamedElement : elements) {
                rfNamedElement.accept(this, visitor);
            }
        }
        return result;
    }

    public void initExecutorService(boolean isSingleThread) {
        Integer maxNofThreads = BuildConfigManager.getMaxNofThreads((IProject)this.fProject);
        if (DVTLogger.INSTANCE.isDebugMode()) {
            ro.amiq.vhdldt.test.TestHelper.out.println("Max nof threads = " + maxNofThreads);
        }
        if (maxNofThreads == null || maxNofThreads < 1) {
            maxNofThreads = 1;
        }
        this.fExecutorService = Executors.newFixedThreadPool(isSingleThread ? 1 : maxNofThreads);
    }

    public ExecutorService getExecutorService() {
        return this.fExecutorService;
    }

    public void shutdownExecutorService() {
        if (this.fExecutorService == null) {
            return;
        }
        this.fExecutorService.shutdown();
        while (!this.fExecutorService.isTerminated()) {
            DVTJobsUtils.delay((long)50L);
        }
        this.fExecutorService = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            RfLibrary library;
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null) return true;
            Iterator<RfLibrary> iterator = libraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((library = iterator.next()).visitHidObject(rfProject, visitor));
            return false;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public static void debugDelay() {
    }

    public void computeFilesIncludedByMatchingTop(Map<StringMatcher, Set<String>> expanded) {
        for (ParserPath parserPath : this.getCompiledFilesSet()) {
            for (Map.Entry<StringMatcher, Set<String>> entry : expanded.entrySet()) {
                StringMatcher matcher = entry.getKey();
                if (!matcher.match(parserPath.path)) continue;
                entry.getValue().add(parserPath.path);
            }
        }
    }

    public Set<String> computeFilesInMacroReparseStack(IRfDefElement declaration) {
        return null;
    }

    public ElementType computeElementType(IRfNamedElement namedElement, ElementPath instancePath) {
        if (namedElement instanceof RfArchitecture) {
            return new ElementType(ElementType.ElementTypeName.ARCHITECTURE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfLibrary) {
            return new ElementType(ElementType.ElementTypeName.LIBRARY, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfPackage) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfPackageBody) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE_BODY, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfTypeBody) {
            return new ElementType(ElementType.ElementTypeName.TYPE_BODY, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfBlock) {
            if (((RfBlock)namedElement).isGenerate()) {
                return new ElementType(ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeLanguage.VHDL);
            }
            return new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfConfiguration) {
            return new ElementType(ElementType.ElementTypeName.CONFIGURATION, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfEntity) {
            return new ElementType(ElementType.ElementTypeName.ENTITY, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfComponent) {
            return new ElementType(ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfPort) {
            return new ElementType(ElementType.ElementTypeName.PORT, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfVariable && ((RfVariable)namedElement).isParameter() || namedElement instanceof RfVariable && ((RfVariable)namedElement).isConstant() || namedElement instanceof RfVariable && ((RfVariable)namedElement).isSharedVariable() || namedElement instanceof RfVariable && ((RfVariable)namedElement).isVariable() || namedElement instanceof RfVariable && ((RfVariable)namedElement).isFile()) {
            return new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfVariable && !((RfVariable)namedElement).isArgument() && ((RfVariable)namedElement).isSignal()) {
            return new ElementType(ElementType.ElementTypeName.SIGNAL, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfFunction) {
            return new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfInstance) {
            return new ElementType(ElementType.ElementTypeName.INSTANCE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfProcess) {
            return new ElementType(ElementType.ElementTypeName.PROCESS, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfType) {
            return new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfVUnit) {
            return new ElementType(ElementType.ElementTypeName.VUNIT, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfPropertySequence) {
            return new ElementType(ElementType.ElementTypeName.PROPERTY_SEQUENCE, ElementType.ElementTypeLanguage.VHDL);
        }
        if (namedElement instanceof RfAlias) {
            if (((RfAlias)namedElement).isPackageInstatiation()) {
                return new ElementType(ElementType.ElementTypeName.PACKAGE_INSTANCE, ElementType.ElementTypeLanguage.VHDL);
            }
            if (((RfAlias)namedElement).isSubprogramInstantiation()) {
                return new ElementType(ElementType.ElementTypeName.SUBPROGRAM_INSTANCE, ElementType.ElementTypeLanguage.VHDL);
            }
            return new ElementType(ElementType.ElementTypeName.ALIAS, ElementType.ElementTypeLanguage.VHDL);
        }
        return null;
    }

    public ElementType computeElementType(IRfDefElement defElement, IRfNamedElement namedElement, ElementPath instancePath) {
        IRfNamedElement rfNamedElement = defElement.getNamedElement();
        if (rfNamedElement != null) {
            return this.computeElementType(rfNamedElement, instancePath);
        }
        return this.computeElementType(namedElement, instancePath);
    }

    public IIdleListener getIdleListener() {
        if (this.fIdleListener != null) {
            return this.fIdleListener;
        }
        this.fIdleListener = new IIdleListener(){

            public void platformIsIdle() {
                ro.amiq.vhdldt.utils.Utils.saveRFDM(RfProject.this, false, true, false);
            }

            public boolean isWriteDone() {
                Persistence persistence = RfManager.getInstance().getPersistence(RfProject.this.fProject);
                if (persistence == null) {
                    return true;
                }
                return persistence.isWriteDone();
            }
        };
        return this.fIdleListener;
    }

    @Override
    public void deepClean() {
        if (this.fRfProjectContent != null) {
            this.fRfProjectContent.deepClean();
        }
        this.getFileInstancesMap();
        this.fCurrentFileDef = null;
        super.deepClean();
    }

    public boolean preRestore() {
        return RfManager.getInstance().getPersistence(this.fProject).preRestore(this, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
    }

    public void restore(IProgressMonitor monitor) {
        Persistence persistence = RfManager.getInstance().getPersistence(this.fProject);
        BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode((IProject)this.fProject);
        BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper = precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.MANUAL_SAVE ? BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualSave() : BuildConfigManagerCommon.PersistenceModeWrapper.regular();
        persistence.restore(this, monitor, null, persistenceModeWrapper);
        ro.amiq.vhdldt.utils.Utils.connectActiveOpenEditor(this);
        this.fSemanticErrorCategory = IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES;
        this.resolveUses(this, false, false, false);
    }

    private void startNameChecking(Set<ParserPath> parserPaths, int buildKind) {
        NameCheckerWarningsManager.getInstance().clean();
        if (parserPaths == null || parserPaths.isEmpty()) {
            return;
        }
        for (ParserPath parserPath : parserPaths) {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            NameCheckerWarningsManager.getInstance().build(buildKind, fileDef, this.fProject);
        }
    }

    public static void debugIncrement1() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount1.incrementAndGet();
        }
    }

    public static void debugIncrement2() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount2.incrementAndGet();
        }
    }

    public static void debugIncrement3() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount3.incrementAndGet();
        }
    }

    public static void incrementTime1(int time) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount4.addAndGet(time);
        }
    }

    @Override
    public boolean visitNamedElements(RfProject rfProject, IRfNamedElementVisitor visitor) {
        return this.fRfProjectContent.fLibraries == null || this.visitNamedElement(rfProject, visitor, this.fRfProjectContent.fLibraries.values());
    }

    public void resolveConfigurations() {
        Collection<RfLibrary> libraries = this.getLibraries();
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        for (RfLibrary library : libraries) {
            List<RfNamedElement> allConfigurations = library.getAllConfigurations();
            for (RfNamedElement config : allConfigurations) {
                ((RfConfiguration)config).resolveConfiguration(this);
            }
        }
    }

    public void accept(IRfNamedElementVisitor visitor) {
        this.visitNamedElements(this, visitor);
    }

    public void acceptMixedProxy(final IRfMixedNamedElementVisitorProxy proxy) {
        this.accept(new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                return proxy.visit((IRfNamedElement)namedElement);
            }
        });
    }

    public boolean accept(RfDefElementVisitorAdapter visitor) throws Exception {
        if (this.fRfCompiledFiles == null) {
            return false;
        }
        for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            if (fileDef.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    public void visitDirectMembersOfLibraries(IRfNamedElementVisitor visitor) throws Exception {
        try {
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return;
            }
            for (RfLibrary library : libraries) {
                Collection<RfNamedElement> libraryMembers = library.getMembers();
                if (libraryMembers == null || libraryMembers.isEmpty()) continue;
                for (RfNamedElement member : libraryMembers) {
                    visitor.visit(member);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RfNamedElementVisitorException) {
                throw e;
            }
            throw new RfNamedElementVisitorException(e);
        }
    }

    public void postReadObject(PersistenceInputStream in) throws ClassNotFoundException, IOException, VersionChangedException {
        for (RfFileDef rfFileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            RfLibrary libraryCandidate = rfFileDef.restoreLibraryFromName(this);
            if (libraryCandidate != null) continue;
            throw new VersionChangedException();
        }
    }

    public void postWriteObject(PersistenceOutputStream stream) throws IOException {
    }

    public void syncCancelSave() {
        RfManager.getInstance().getPersistence(this.fProject).syncCancelSave();
    }

    public void getSortCandidatesForContentAssist(IRfNamedElement[] sortedCandidates, String prefix) {
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
    }

    public List<IRfDesignElement> getInstanceHoldersWithPrefix(Collection<? extends RfNamedElement> elements, final String prefix, final int matchType, final int maxNofProposals) {
        final ArrayList<IRfDesignElement> result = new ArrayList<IRfDesignElement>();
        IRfNamedElementVisitor visitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (result.size() >= maxNofProposals) {
                    return false;
                }
                if ((namedElement instanceof RfEntity || namedElement instanceof RfComponent || namedElement instanceof RfConfiguration) && DVTStringUtil.regionMatches((String)namedElement.getName(), (String)prefix, (int)matchType)) {
                    result.add((IRfDesignElement)namedElement);
                }
                return true;
            }
        };
        if (elements != null && !elements.isEmpty()) {
            for (RfNamedElement rfNamedElement : elements) {
                rfNamedElement.accept(this, visitor);
            }
        }
        return result;
    }

    public boolean isLintingEnabled() {
        return false;
    }

    public void stopLintTracking() {
    }

    public ELManager getELManager() {
        return this.fMixedLangProjectParent.getELManager();
    }

    public ELManager getNonELManager() {
        return this.fMixedLangProjectParent.getNonELManager();
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
        this.fPowerFormatModel = powerFormatModel;
    }

    public DVTPFModel getPFModel() {
        return this.fPowerFormatModel;
    }

    public boolean testIsPredefinedLibraryFile(ParserPath parserPath) {
        return this.isPredefinedLibraryFile(parserPath);
    }

    public static IRfDefElement getUsageBeforeDeclaration(IRfNamedElement element) {
        return element instanceof RfFunction ? ((RfFunction)element).getPrototype().getDeclaration() : element.getDeclaration();
    }

    public static boolean isEnableDefBeforeUseCheck(IRfNamedElement usageElement, IRfNamedElement defElement, RfProject rfProject) {
        if (rfProject == null || !(usageElement instanceof RfNamedElement) || !(defElement instanceof RfNamedElement)) {
            return false;
        }
        IRfDefElement usageDef = usageElement.getDeclaration();
        IRfDefElement defDef = defElement.getDeclaration();
        if (!(usageDef instanceof RfDefElement) || !(defDef instanceof RfDefElement)) {
            return false;
        }
        return rfProject.isEnableDefBeforeUseCheck((RfNamedElement)usageElement, usageDef.getParserPath(), (RfNamedElement)defElement, defDef.getParserPath());
    }

    private boolean isEnableDefBeforeUseCheck(RfNamedElement usageElement, ParserPath usageParserPath, RfNamedElement defElement, ParserPath defParserPath) {
        if (usageParserPath == null || defParserPath == null) {
            return false;
        }
        if (usageElement.getDeclarationIndex() == 0 || defElement.getDeclarationIndex() == 0) {
            return false;
        }
        if (this.orderAnalysisScope == null) {
            this.orderAnalysisScope = BuildConfigManager.getUsageBeforeDeclarationScope((IProject)this.getProject());
        }
        boolean wildcard = this.fRfProjectContent.fWildcardConfiguredParserPaths != null && (this.fRfProjectContent.fWildcardConfiguredParserPaths.contains(defParserPath) || this.fRfProjectContent.fWildcardConfiguredParserPaths.contains(usageParserPath));
        boolean autoconf = this.fRfProjectContent.fAutoConfiguredParserPaths != null && (this.fRfProjectContent.fAutoConfiguredParserPaths.contains(defParserPath) || this.fRfProjectContent.fAutoConfiguredParserPaths.contains(usageParserPath));
        boolean sameFile = usageParserPath.equals((Object)defParserPath);
        boolean haveCommonInvoc = usageElement.getInvocNumber() == defElement.getInvocNumber();
        switch (this.orderAnalysisScope) {
            case INVOCATION: {
                if (!haveCommonInvoc) {
                    return false;
                }
            }
            case ALL: {
                if (wildcard || autoconf) {
                    return sameFile;
                }
                return true;
            }
            case FILE: {
                return sameFile;
            }
        }
        return false;
    }

    private void computeAutoConfiguredParserPaths() {
        this.fRfProjectContent.fAutoConfiguredParserPaths = new HashSet<ParserPath>();
        this.fRfProjectContent.fWildcardConfiguredParserPaths = new HashSet<ParserPath>();
        List invocations = BuildConfigManager.getInvocations((IProject)this.fProject);
        if (invocations == null) {
            return;
        }
        for (Invocation i : invocations) {
            boolean hasAutoParent = this.hasAutoParent(i);
            List topFiles = BuildConfigManager.getTopFiles((Invocation)i, (LanguageKind)LanguageKind.VHDL);
            for (BuildConfigProperty topFile : topFiles) {
                String topFileName = topFile.getValue();
                if (topFile.hasAttribute("ATTRIBUTE_WILDCARD_FILE")) {
                    this.fRfProjectContent.fWildcardConfiguredParserPaths.add(new ParserPath(topFileName));
                }
                if (!hasAutoParent) continue;
                this.fRfProjectContent.fAutoConfiguredParserPaths.add(new ParserPath(topFileName));
            }
        }
    }

    public IRfConfiguration resolveDesignOrConfigInLibrary(IRfLibraryElement library, String configName, boolean isConfigOnly) {
        if (!(library instanceof RfLibrary) || configName == null) {
            return null;
        }
        if (isConfigOnly) {
            return this.resolveConfigInLibrary(library, configName);
        }
        final IRfNamedElement topElement = library.getLocalMember(DVTRfUtils.MEMBERS_DESIGN, configName, null);
        if (topElement != null) {
            DVTImplicitConfiguration implicitConfig = new DVTImplicitConfiguration(topElement.getName(), topElement.getEnclosingLibrary(), new ArrayList<IRfDesignElement>(Arrays.asList((IRfDesignElement)topElement))){
                private static final long serialVersionUID = 1L;
                private List<IRfLibraryElement> defaultLiblist;

                public void init() {
                    this.defaultLiblist = RfProject.resolveLiblist(RfProject.this, RfProject.this.getNoConfigLiblist());
                }

                public List<IRfLibraryElement> getDefaultLiblist() {
                    return this.defaultLiblist;
                }

                public void setDefaultLiblist(List<IRfLibraryElement> libList) {
                    this.defaultLiblist = libList;
                }

                public boolean isDummyConfig() {
                    return true;
                }

                public IRfSingleLangProject getRfProject() {
                    return topElement.getRfProject();
                }
            };
            return implicitConfig;
        }
        IRfNamedElement topPackage = ((RfLibrary)library).getLocalMember(Collections.singleton(RfPackage.class), configName, (IRfNamedElement)null);
        if (topPackage instanceof IRfPackageElement) {
            return new DVTPackageConfiguration(configName, (IRfLibraryElement)topPackage.getEnclosingLibrary(), (IRfPackageElement)topPackage);
        }
        return this.resolveConfigInLibrary(library, configName);
    }

    private IRfConfiguration resolveConfigInLibrary(IRfLibraryElement library, String configName) {
        IRfDesignElement configurationCandidate = library.getDesignWithPrefix(configName, 9);
        if (configurationCandidate instanceof RfConfiguration) {
            return (IRfConfiguration)configurationCandidate;
        }
        return null;
    }

    private static List<IRfLibraryElement> resolveLiblist(RfProject rfProject, List<Identifier> liblist) {
        block4: {
            if (liblist != null && !liblist.isEmpty()) break block4;
            return null;
        }
        try {
            ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
            for (Identifier libraryName : liblist) {
                List<IRfLibraryElement> libraries = RfProject.getLibraries(rfProject, libraryName.getName());
                if (libraries == null || libraries.isEmpty()) continue;
                result.addAll(libraries);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static List<IRfLibraryElement> getLibraries(RfProject rfProject, String libraryName) {
        RfMixedLangProject mixedLangProject;
        IRfLibraryElement otherLibrary;
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        RfLibrary library = rfProject.getLibraryWithPrefix(libraryName, 1);
        if (library != null) {
            result.add(library);
        }
        if ((otherLibrary = (mixedLangProject = rfProject.getMixedLangProjectParent()).getLibraryWithPrefix((IRfSingleLangProject)rfProject, libraryName, 1)) != null) {
            result.add(otherLibrary);
        }
        return result;
    }

    public List<Identifier> getNoConfigLiblist() {
        String libName;
        HashSet<String> alreadyIncluded = new HashSet<String>();
        ArrayList<Identifier> result = new ArrayList<Identifier>();
        List invocations = BuildConfigManager.getInvocations((IProject)this.fProject);
        if (invocations != null) {
            for (Invocation invocation : invocations) {
                libName = this.adjustLibraryName(invocation.getLibName());
                if (alreadyIncluded.contains(libName)) continue;
                alreadyIncluded.add(libName);
                result.add(new Identifier(libName, -1, -1));
            }
        }
        if (this.fRfProjectContent.fLibraries != null) {
            for (RfLibrary library : this.fRfProjectContent.fLibraries.values()) {
                libName = this.adjustLibraryName(library.getName());
                if (alreadyIncluded.contains(libName)) continue;
                alreadyIncluded.add(libName);
                result.add(new Identifier(libName, -1, -1));
            }
        }
        return result;
    }

    private boolean hasAutoParent(Invocation i) {
        do {
            if (i.getState().fKind == BuildConfigParser.InvocationKind.REGULAR) continue;
            return true;
        } while ((i = i.getState().fParentInvocation) != null);
        return false;
    }

    public Set<ParserPath> getRawCompiledFilesSet() {
        if (this.fRfCompiledFiles == null) {
            return null;
        }
        return this.fRfCompiledFiles.fCompiledFiles;
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fRfProjectContent.fToolCompat;
    }

    public void setToolCompat(IBuildConfigParserConstants.ToolCompat toolCompat) {
        this.fRfProjectContent.fToolCompat = toolCompat;
    }

    private String adjustLibraryName(String libraryName) {
        return IBuildConfigParserConstants.IUS_TOOLS.contains(this.getToolCompat()) && "worklib".equalsIgnoreCase(libraryName) ? "work" : libraryName;
    }

    public void addBuildFileMapping(Integer fileIndex, String fullBuildFilePath, Integer buildFileLine) {
        if (this.fRfProjectContent.fParserPathToBuildFile == null) {
            this.fRfProjectContent.fParserPathToBuildFile = new LinkedHashMap<Integer, BuildFilePathLine>();
        }
        this.fRfProjectContent.fParserPathToBuildFile.put(fileIndex, new BuildFilePathLine(fullBuildFilePath, buildFileLine.intValue()));
    }

    public List<VhdlFileInstance> getFiles() {
        ArrayList<VhdlFileInstance> compiledFileInstances = new ArrayList<VhdlFileInstance>();
        this.getCompiledFilesSet().stream().forEach(key -> {
            boolean bl = compiledFileInstances.addAll(this.getFileInstancesMap().getFileInstances((ParserPath)key));
        });
        Collections.sort(compiledFileInstances, (f1, f2) -> {
            if (f1.getIndex() <= 0) {
                return 1;
            }
            if (f2.getIndex() <= 0) {
                return -1;
            }
            return f1.getIndex() - f2.getIndex();
        });
        return compiledFileInstances;
    }

    public BuildFilePathLine getBuildFilePathLine(VhdlFileInstance fileInstance) {
        return this.fRfProjectContent.fParserPathToBuildFile.get(fileInstance.getIndex());
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    public IXValueHolderFactoryContributor getFactoryContributor(IRfSingleLangProject.FactoryContributorKind contributorKind, IXSim xSim) {
        return new XVhdlValueHolderFactory();
    }

    public ChangedFilesManager getChangedFilesManager() {
        if (this.fChangedFilesManager == null) {
            this.fChangedFilesManager = new ChangedFilesManager();
        }
        return this.fChangedFilesManager;
    }

    static abstract class LibraryWorker {
        LibraryWorker() {
        }

        abstract void work(ExecutorService var1, RfLibrary var2, Set<String> var3);

        public void executeOnThread(ExecutorService executorService, RfLibrary library, Set<String> onlyPkgNames) {
            executorService.execute(() -> this.work(executorService, library, onlyPkgNames));
        }
    }

    private class RfNamedElementComparator
    implements Comparator<RfNamedElement> {
        private RfNamedElementComparator() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            return o1.getName().compareTo(o2.getName());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    class RfProjectContent
    implements Serializable,
    IRfProjectContent {
        private static final long serialVersionUID = 1914L;
        protected IBuildConfigParserConstants.ToolCompat fToolCompat;
        protected IncrementalElaborationKind fIncrementalElaborationKind;
        protected PredefinedTypeHolder fPredefinedTypeHolder = new PredefinedTypeHolder();
        private transient OperatorScopeCache opCache;
        protected Map<ParserPath, RfFileDef> fParserPath2FileDefMap;
        protected InsensitiveLinkedMap<RfLibrary> fLibraries;
        public VhdlFileInstancesMap fFileInstancesMap;
        public Set<ParserPath> fAutoConfiguredParserPaths;
        public Set<ParserPath> fWildcardConfiguredParserPaths;
        private Map<Integer, BuildFilePathLine> fParserPathToBuildFile;

        RfProjectContent() {
        }

        public void setEnclosingScope(IRfSingleLangProject rfProject) {
            if (this.fLibraries == null || this.fLibraries.isEmpty()) {
                return;
            }
            for (RfLibrary library : this.fLibraries.values()) {
                library.setEnclosingScope((RfNamedElement)rfProject, true);
            }
        }

        public void deepClean() {
            if (this.fLibraries != null) {
                this.fLibraries.deepClean();
            }
            if (this.fParserPath2FileDefMap != null) {
                for (RfFileDef fileDef : this.fParserPath2FileDefMap.values()) {
                    fileDef.deepClean();
                }
                this.fParserPath2FileDefMap.clear();
            }
            this.fPredefinedTypeHolder = null;
            if (this.opCache != null) {
                this.opCache.deepClean();
            }
            this.opCache = null;
        }
    }

    static class SemanticErrorsTable {
        private Map<IRfSingleLangProject.SemanticErrorsCategory, Map<String, ErrorsAndWarnings>> fErrorsAndWarnings = new EnumMap<IRfSingleLangProject.SemanticErrorsCategory, Map<String, ErrorsAndWarnings>>(IRfSingleLangProject.SemanticErrorsCategory.class);
        private Map<IRfSingleLangProject.SemanticErrorsCategory, Set<RfSemanticError>> fAlreadyReportedSet = new EnumMap<IRfSingleLangProject.SemanticErrorsCategory, Set<RfSemanticError>>(IRfSingleLangProject.SemanticErrorsCategory.class);

        public SemanticErrorsTable() {
            this.init();
        }

        public void clearLibsOrPkgs(IRfSingleLangProject.SemanticErrorsCategory category, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            Set<RfSemanticError> set = this.fAlreadyReportedSet.get(category);
            if (onlyLibAndPkgNames == null) {
                for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    if (errorsAndWarnings != null && errorsAndWarnings.errorsMap != null) {
                        for (Set set2 : errorsAndWarnings.errorsMap.values()) {
                            if (set == null) continue;
                            set.removeAll(set2);
                        }
                    }
                    if (errorsAndWarnings == null || errorsAndWarnings.warningsMap == null) continue;
                    for (Set set3 : errorsAndWarnings.warningsMap.values()) {
                        if (set == null) continue;
                        set.removeAll(set3);
                    }
                }
                errorsAndWarningsPerCategory.clear();
            } else {
                for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    this.clearLibsOrPkgs(category, fullChecksKind, onlyLibAndPkgNames, errorsAndWarnings, errorsAndWarnings.errorsMap);
                    this.clearLibsOrPkgs(category, fullChecksKind, onlyLibAndPkgNames, errorsAndWarnings, errorsAndWarnings.warningsMap);
                }
            }
        }

        private void clearLibsOrPkgs(IRfSingleLangProject.SemanticErrorsCategory category, FullChecksKind fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames, ErrorsAndWarnings semanticErrors, Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap) {
            if (problemsMap == null || problemsMap.isEmpty()) {
                return;
            }
            Set<RfSemanticError> set = this.fAlreadyReportedSet.get(category);
            for (Set set2 : problemsMap.values()) {
                if (set2 == null || set2.isEmpty()) continue;
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    RfSemanticError error = (RfSemanticError)iterator.next();
                    if (!error.inLibraryOrPackage((Enum<FullChecksKind>)fullChecksKind, onlyLibAndPkgNames)) continue;
                    iterator.remove();
                    if (set != null) {
                        set.remove(error);
                    }
                    if (error.getSeverity() == 1) {
                        --semanticErrors.nofErrors;
                        continue;
                    }
                    --semanticErrors.nofWarnings;
                }
            }
        }

        public void init() {
            this.fAlreadyReportedSet.clear();
            this.fErrorsAndWarnings.clear();
        }

        public Map<String, ErrorsAndWarnings> get(IRfSingleLangProject.SemanticErrorsCategory category) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.fErrorsAndWarnings.get(category);
            if (errorsAndWarningsPerCategory == null) {
                errorsAndWarningsPerCategory = ro.amiq.vhdldt.test.TestHelper.isTestMode() ? new TreeMap() : new LinkedHashMap();
                this.fErrorsAndWarnings.put(category, errorsAndWarningsPerCategory);
            }
            return errorsAndWarningsPerCategory;
        }

        public void clearDependencies(IRfSingleLangProject.SemanticErrorsCategory category, RfProject rfProject, Map<ParserPath, Set<IRfNamedElement>> delta) {
            if (delta == null || delta.isEmpty()) {
                return;
            }
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            for (Set<IRfNamedElement> namedElements : delta.values()) {
                if (namedElements == null || namedElements.isEmpty()) continue;
                for (IRfNamedElement namedElement : namedElements) {
                    RfElementPath elementPath;
                    ErrorsAndWarnings errorsAndWarnings;
                    String resourcePath;
                    ParserPath parserPath;
                    IRfDefElement declaration;
                    IRfNamedElement closestTypeContainer;
                    if (namedElement instanceof RfLibrary && category == IRfSingleLangProject.SemanticErrorsCategory.RESOLVE_USES) {
                        HashMap<String, Set<String>> onlyLibAndPkgNames = new HashMap<String, Set<String>>();
                        onlyLibAndPkgNames.put(namedElement.getName(), null);
                        this.clearLibsOrPkgs(category, FullChecksKind.LIBS, onlyLibAndPkgNames);
                    }
                    if (namedElement == null || namedElement.hasNoDefs(false) || (closestTypeContainer = (IRfNamedElement)namedElement.getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) == null || closestTypeContainer.hasNoDefs(false) || (declaration = closestTypeContainer.getDeclaration()) == null || (parserPath = declaration.getParserPath()) == null || (resourcePath = rfProject.parser2resource(parserPath)) == null || (errorsAndWarnings = errorsAndWarningsPerCategory.get(resourcePath)) == null || errorsAndWarnings.isEmpty() || (elementPath = RfElementPath.path((IRfNamedElement)closestTypeContainer)) == null) continue;
                    errorsAndWarnings.remove(category, elementPath);
                }
            }
        }

        private void clearElement(IRfSingleLangProject.SemanticErrorsCategory category, RfNamedElement entity, RfProject rfProject) {
            if (rfProject == null || entity == null) {
                return;
            }
            RfDefElement declaration = entity.getDeclaration();
            if (declaration == null) {
                return;
            }
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath == null) {
                return;
            }
            String resourcePath = rfProject.parser2resource(parserPath);
            if (resourcePath == null) {
                return;
            }
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            ErrorsAndWarnings errorsAndWarnings = errorsAndWarningsPerCategory.get(resourcePath);
            if (errorsAndWarnings == null) {
                return;
            }
            RfElementPath elementPath = RfElementPath.path((IRfNamedElement)entity);
            if (elementPath == null) {
                return;
            }
            errorsAndWarnings.remove(category, elementPath);
        }

        public void clearFiles(IRfSingleLangProject.SemanticErrorsCategory category, RfProject rfProject, Collection<ParserPath> changedFiles) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            Set<RfSemanticError> set = this.fAlreadyReportedSet.get(category);
            if (changedFiles == null) {
                for (ErrorsAndWarnings removedErrorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                    if (removedErrorsAndWarnings != null && removedErrorsAndWarnings.errorsMap != null) {
                        for (Set set2 : removedErrorsAndWarnings.errorsMap.values()) {
                            if (set == null) continue;
                            set.removeAll(set2);
                        }
                    }
                    if (removedErrorsAndWarnings == null || removedErrorsAndWarnings.warningsMap == null) continue;
                    for (Set set3 : removedErrorsAndWarnings.warningsMap.values()) {
                        if (set == null) continue;
                        set.removeAll(set3);
                    }
                }
                errorsAndWarningsPerCategory.clear();
            } else {
                for (ParserPath parserPath : changedFiles) {
                    String string;
                    if (parserPath == null || (string = rfProject.parser2resource(parserPath)) == null) continue;
                    ErrorsAndWarnings removedErrorsAndWarnings = errorsAndWarningsPerCategory.remove(string);
                    if (removedErrorsAndWarnings != null && removedErrorsAndWarnings.errorsMap != null) {
                        for (Set set4 : removedErrorsAndWarnings.errorsMap.values()) {
                            if (set == null) continue;
                            set.removeAll(set4);
                        }
                    }
                    if (removedErrorsAndWarnings == null || removedErrorsAndWarnings.warningsMap == null) continue;
                    for (Set set5 : removedErrorsAndWarnings.warningsMap.values()) {
                        if (set == null) continue;
                        set.removeAll(set5);
                    }
                }
            }
        }

        public void setObsolete(IRfSingleLangProject.SemanticErrorsCategory category) {
            Map<String, ErrorsAndWarnings> errorsAndWarningsPerCategory = this.get(category);
            for (ErrorsAndWarnings errorsAndWarnings : errorsAndWarningsPerCategory.values()) {
                if (errorsAndWarnings == null || errorsAndWarnings.isEmpty()) continue;
                this.setObsolete(errorsAndWarnings.errorsMap);
                this.setObsolete(errorsAndWarnings.warningsMap);
            }
        }

        private void setObsolete(Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap) {
            if (problemsMap == null || problemsMap.isEmpty()) {
                return;
            }
            for (Set set : problemsMap.values()) {
                if (set == null || set.isEmpty()) continue;
                for (RfSemanticError problem : set) {
                    problem.setObsolete(true);
                }
            }
        }

        public ErrorsAndWarnings getNofErrorsAndWarnings(IRfSingleLangProject.SemanticErrorsCategory category, String resourcePath) {
            ErrorsAndWarnings nofErrorsAndWarnings;
            Map<String, ErrorsAndWarnings> nofErrorsAndWarningsPerCategory = this.fErrorsAndWarnings.get(category);
            if (nofErrorsAndWarningsPerCategory == null) {
                nofErrorsAndWarningsPerCategory = ro.amiq.vhdldt.test.TestHelper.isTestMode() ? new TreeMap() : new LinkedHashMap();
                this.fErrorsAndWarnings.put(category, nofErrorsAndWarningsPerCategory);
            }
            if ((nofErrorsAndWarnings = nofErrorsAndWarningsPerCategory.get(resourcePath)) == null) {
                nofErrorsAndWarnings = new ErrorsAndWarnings();
                nofErrorsAndWarningsPerCategory.put(resourcePath, nofErrorsAndWarnings);
            }
            return nofErrorsAndWarnings;
        }

        public class ErrorsAndWarnings {
            public int nofWarnings;
            public int nofErrors;
            public Map<RfElementPath, TreeSet<RfSemanticError>> errorsMap = new LinkedHashMap<RfElementPath, TreeSet<RfSemanticError>>();
            public Map<RfElementPath, TreeSet<RfSemanticError>> warningsMap = new LinkedHashMap<RfElementPath, TreeSet<RfSemanticError>>();

            public boolean isEmpty() {
                return this.errorsMap.isEmpty() && this.warningsMap.isEmpty();
            }

            public void remove(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath elementPath) {
                this.remove(category, elementPath, 1);
                this.remove(category, elementPath, 2);
            }

            private void remove(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath elementPath, int severity) {
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap = severity == 1 ? this.errorsMap : this.warningsMap;
                TreeSet<RfSemanticError> removedProblems = problemsMap.remove(elementPath);
                if (removedProblems == null || removedProblems.isEmpty()) {
                    return;
                }
                Set<RfSemanticError> set = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                if (set != null) {
                    set.removeAll(removedProblems);
                }
                if (severity == 1) {
                    this.nofErrors -= removedProblems.size();
                } else {
                    this.nofWarnings -= removedProblems.size();
                }
            }

            public void addErrorOrWarning(IRfSingleLangProject.SemanticErrorsCategory category, RfElementPath closestTypeContainer, RfSemanticError errorOrWarning) {
                Set<RfSemanticError> set = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                if (set != null && set.contains(errorOrWarning)) {
                    return;
                }
                int severity = errorOrWarning.getSeverity();
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap = severity == 1 ? this.errorsMap : this.warningsMap;
                TreeSet<RfSemanticError> problems = problemsMap.get(closestTypeContainer);
                if (problems == null) {
                    problems = new TreeSet();
                    problemsMap.put(closestTypeContainer, problems);
                }
                int size = problems.size();
                problems.add(errorOrWarning);
                if (size < problems.size()) {
                    Set newSet = SemanticErrorsTable.this.fAlreadyReportedSet.computeIfAbsent(category, key -> new HashSet());
                    newSet.add(errorOrWarning);
                    if (errorOrWarning.getSeverity() == 1) {
                        ++this.nofErrors;
                    } else {
                        ++this.nofWarnings;
                    }
                }
            }

            public LastProblemEntry removeLastErrorOrWarningAfterLine(IRfSingleLangProject.SemanticErrorsCategory category, int severity, int line) {
                RfSemanticError lastProblem = null;
                TreeSet<RfSemanticError> lastProblemHolder = null;
                RfElementPath lastTypeContainer = null;
                Map<RfElementPath, TreeSet<RfSemanticError>> problemsMap = severity == 1 ? this.errorsMap : this.warningsMap;
                for (Map.Entry<RfElementPath, TreeSet<RfSemanticError>> problems : problemsMap.entrySet()) {
                    RfSemanticError candidate;
                    if (problems == null || problems.getValue().isEmpty() || (candidate = problems.getValue().last()).getLine() <= line) continue;
                    if (lastProblem == null || candidate.getLine() > lastProblem.getLine()) {
                        lastProblem = candidate;
                        lastProblemHolder = problems.getValue();
                        lastTypeContainer = problems.getKey();
                        continue;
                    }
                    if (candidate.getLine() != lastProblem.getLine() || lastProblem.compareTo(candidate) >= 0) continue;
                    lastProblem = candidate;
                    lastProblemHolder = problems.getValue();
                    lastTypeContainer = problems.getKey();
                }
                if (lastProblemHolder != null && lastProblem != null) {
                    lastProblemHolder.remove(lastProblem);
                    Set<RfSemanticError> set = SemanticErrorsTable.this.fAlreadyReportedSet.get(category);
                    if (set != null) {
                        set.remove(lastProblem);
                    }
                    if (severity == 1) {
                        --this.nofErrors;
                    } else {
                        --this.nofWarnings;
                    }
                    return new LastProblemEntry(lastTypeContainer, lastProblem);
                }
                return null;
            }
        }

        static class LastProblemEntry {
            private RfElementPath lastTypeContainer;
            private RfSemanticError lastProblem;

            public LastProblemEntry(RfElementPath lastTypeContainer, RfSemanticError lastProblem) {
                this.lastTypeContainer = lastTypeContainer;
                this.lastProblem = lastProblem;
            }
        }
    }

    private class UsageBeforeDeclarationVisitor
    extends HidVisitor {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        public UsageBeforeDeclarationVisitor() {
            super(null);
        }

        public void setHolder(IHidHolder holder) {
            this.scope = holder instanceof HidHolder ? ((HidHolder)holder).getScope() : null;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(Hid hid) {
            IRfDefElement declaration;
            boolean hasBeforeDeclError;
            if (hid.isExternalName()) {
                return true;
            }
            if (this.scope == null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfNamedElement) || element.isPredefined() || element instanceof RfInstance) {
                return true;
            }
            if (hid.hasQualifier(HidQualifierCache.LOOP_LABEL)) {
                return true;
            }
            if (hid.hasQualifier(HidQualifierCache.GENERIC_MAP_FORMAL_PART) && element instanceof RfAlias) {
                return true;
            }
            HidOccurrence occurrence = hid.getOccurrence();
            boolean bl = hasBeforeDeclError = !((RfNamedElement)element).isBefore(hid.getUsageIndex(), occurrence.getLine(), occurrence.getOffset());
            if (hasBeforeDeclError && RfProject.isEnableDefBeforeUseCheck(this.scope, element, this.scope.getRfProject() instanceof RfProject ? (RfProject)this.scope.getRfProject() : null) && (declaration = RfProject.getUsageBeforeDeclaration(element)) != null) {
                RfProject.this.addSemanticError(1, "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}", this.scope.getLibPkgScope(), occurrence.getOffset(), occurrence.getOffset() + hid.getName().length(), null, occurrence.getLine(), this.parserPath, RfKind.of(element).getCapitalizedName(), element.getName(), declaration.getStartLine(), declaration.getParserPath());
            }
            return true;
        }
    }
}

