/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.diagrams.wavedrom.BitField;
import ro.amiq.dvt.diagrams.wavedrom.IBitFieldRegister;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.vhdldt.model.reflection.ConstraintHolder;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.RecordConstraintHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

public class RfRecordType
extends RfType
implements IRfCompositeTypeElement,
IBitFieldRegister {
    private static final long serialVersionUID = 1L;

    public RfRecordType(String name, RfType.TypeKind typeKind, DataType dataType) {
        super(name, typeKind, dataType);
    }

    public boolean isStruct() {
        return true;
    }

    @Override
    protected void computeLocalConstraints() {
        if (this.constraintHolder != null) {
            return;
        }
        this.constraintHolder = new RecordConstraintHolder();
        List<RfVariable> localMembers = this.getLocalMembers(RfVariable.class);
        if (localMembers != null) {
            for (RfVariable localMember : localMembers) {
                String name = localMember.getName();
                DataType dataType = localMember.getDataType();
                ArrayList<IndexConstraint> elementConstraints = new ArrayList<IndexConstraint>();
                if (dataType != null) {
                    IHidObject originConstraint;
                    IRfNamedElement associatedBaseType = localMember.getAssociatedType();
                    boolean isScalar = associatedBaseType instanceof RfType && ((RfType)associatedBaseType).hasScalarBaseType();
                    List<IndexConstraint> originalConstraints = dataType.getElementConstraints();
                    if (isScalar && !originalConstraints.isEmpty() && (originConstraint = originalConstraints.get(0).getHidObject()) instanceof RfHidOperator && ((RfHidOperator)originConstraint).isLiteralRange()) continue;
                    elementConstraints.addAll(originalConstraints);
                }
                ((RecordConstraintHolder)this.constraintHolder).addRecordConstraint(name, new ConstraintHolder(elementConstraints));
            }
        }
    }

    @Override
    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        List<RfVariable> recordVariables = this.getRecordElements();
        if (recordVariables == null) {
            return null;
        }
        int index = 0;
        TreeMap<String, StructMemberContextInfo> membersInfo = new TreeMap<String, StructMemberContextInfo>(String.CASE_INSENSITIVE_ORDER);
        for (RfVariable recordVariable : recordVariables) {
            BitVectorContext memberContext = recordVariable.getDataTypeBitVectorContext(evaluator, returnTypeParameterDefault, hierarchyPath, manager);
            if (memberContext == null) {
                return null;
            }
            int memberSize = memberContext.getSize();
            membersInfo.put(recordVariable.getName(), new StructMemberContextInfo(index, recordVariable.getName(), memberContext));
            index += memberSize;
        }
        return BitVectorContext.of((DVTNumber)DVTUnpackedStruct.ofInfo(membersInfo, (boolean)false), (IRfNamedElement)this, (IRfNamedElement)this);
    }

    public int getBitFieldDiagramSize(ElementPath path) {
        ELManager localManager;
        ELParamValuesHidEvaluator evaluator;
        BitVectorContext dataTypeBitVectorContext;
        ELParamValues paramValues;
        if (!this.isRecord()) {
            return 0;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return 0;
        }
        ELParamValues eLParamValues = paramValues = rfProject.getELManager() != null ? rfProject.getELManager().getMemory().paramValuesFor(path) : null;
        if (paramValues == null) {
            paramValues = ELParamValues.create((boolean)true);
        }
        if ((dataTypeBitVectorContext = this.getDataTypeBitVectorContext((IHidEvaluator)(evaluator = paramValues.getHidEvaluator(localManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)))), false, null, localManager)) == null) {
            return 0;
        }
        return dataTypeBitVectorContext.getSize();
    }

    private Set<BitfieldCandidate> collectBitfieldCandidates(BitfieldCandidate parent) {
        if (parent == null || parent.members.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<BitfieldCandidate> result = new LinkedHashSet<BitfieldCandidate>();
        int lane = parent.lane + 1;
        int parentLaneIndex = parent.laneIndex;
        for (StructMemberContextInfo member : parent.members) {
            RfType type = (RfType)((RfVariable)member.context.getOrigin()).transientType;
            BitfieldCandidate candidate = new BitfieldCandidate(member, (Integer)lane, (Integer)(member.startingIndex + parentLaneIndex), parent.name);
            result.add(candidate);
            if (member.context.getContextNumber() instanceof IDVTRangeSelectable && !type.isPredefined() && type.isArray()) {
                int arraySize = ((IDVTRangeSelectable)member.context.getContextNumber()).getArraySize();
                int elementSize = ((IDVTRangeSelectable)member.context.getContextNumber()).getElementSize();
                if (elementSize == 1) {
                    result.add(new BitfieldCandidate(lane + 1, (Integer)(member.startingIndex + parentLaneIndex), (Integer)member.context.getSize(), candidate.name));
                    continue;
                }
                int i = 0;
                while (i < arraySize) {
                    int size = elementSize * i;
                    DVTNumber elementType = ((IDVTRangeSelectable)member.context.getContextNumber()).getElementType();
                    if (elementType instanceof DVTUnpackedStruct) {
                        bitfield = new BitfieldCandidate((DVTUnpackedStruct)elementType, (Integer)(lane + 1), (Integer)(member.startingIndex + size + parentLaneIndex), String.valueOf(member.name) + "[" + i + "]", ((DVTUnpackedArray)member.context.getContextNumber()).elementTypeName);
                        result.add(bitfield);
                        collectMembers = this.collectBitfieldCandidates(bitfield);
                        result.addAll(collectMembers);
                    } else if (elementType instanceof VhdlEnum) {
                        bitfield = new BitfieldCandidate((VhdlEnum)elementType, (Integer)(lane + 1), (Integer)(member.startingIndex + size + parentLaneIndex), String.valueOf(member.name) + "[" + i + "]", type.getAssociatedType().getName());
                        result.add(bitfield);
                        collectMembers = this.collectBitfieldCandidates(bitfield);
                        result.addAll(collectMembers);
                    }
                    ++i;
                }
                continue;
            }
            Set<BitfieldCandidate> collectMembers = this.collectBitfieldCandidates(candidate);
            result.addAll(collectMembers);
        }
        return result;
    }

    public Map<Integer, List<BitField>> getBitFields(ElementPath path, int size) {
        ELManager localManager;
        ELParamValuesHidEvaluator evaluator;
        BitVectorContext context;
        ELParamValues paramValues;
        LinkedHashMap<Integer, List<BitField>> lanes = new LinkedHashMap<Integer, List<BitField>>();
        if (!this.isRecord()) {
            return lanes;
        }
        PriorityQueue<BitfieldCandidate> members = new PriorityQueue<BitfieldCandidate>((b1, b2) -> b1.lane.equals(b2.lane) ? b1.laneIndex.compareTo(b2.laneIndex) : b1.lane.compareTo(b2.lane));
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return lanes;
        }
        ELParamValues eLParamValues = paramValues = rfProject.getELManager() != null ? rfProject.getELManager().getMemory().paramValuesFor(path) : null;
        if (paramValues == null) {
            paramValues = ELParamValues.create((boolean)true);
        }
        if ((context = this.getDataTypeBitVectorContext((IHidEvaluator)(evaluator = paramValues.getHidEvaluator(localManager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class)))), false, null, localManager)) == null) {
            return lanes;
        }
        DVTNumber contextNumber = context.getContextNumber();
        if (!(contextNumber instanceof DVTUnpackedStruct)) {
            return lanes;
        }
        members.addAll(this.collectBitfieldCandidates(new BitfieldCandidate((DVTUnpackedStruct)contextNumber, (Integer)-1, (Integer)0, "", "")));
        int width = ((DVTUnpackedStruct)contextNumber).getSize();
        int lane = 0;
        int laneIndex = 0;
        LinkedList<BitField> membersLane = new LinkedList<BitField>();
        while (!members.isEmpty()) {
            BitfieldCandidate member = (BitfieldCandidate)members.poll();
            if (member.lane != lane) {
                membersLane.add(BitField.BitfieldBuilder.of((int)width, (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(member.type).build());
                lanes.put(lane++, membersLane);
                membersLane = new LinkedList();
                laneIndex = 0;
            }
            if (member.laneIndex != laneIndex) {
                membersLane.add(BitField.BitfieldBuilder.of((int)(member.laneIndex - laneIndex), (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(member.type).build());
                laneIndex += member.laneIndex - laneIndex;
            }
            membersLane.add(BitField.BitfieldBuilder.of((int)member.size, (BitField.Color)member.color).name(member.name).parent(member.parentName).position(laneIndex).type(member.type).build());
            if ((laneIndex += member.size) < width) {
                BitfieldCandidate next = (BitfieldCandidate)members.peek();
                if ((next == null || next.lane == lane) && !members.isEmpty()) continue;
                membersLane.add(BitField.BitfieldBuilder.of((int)(width - laneIndex), (BitField.Color)BitField.Color.PADDING).name("").position(laneIndex).type(member.type).build());
            }
            lanes.put(lane++, membersLane);
            membersLane = new LinkedList();
            laneIndex = 0;
        }
        return lanes;
    }

    public IBitFieldRegister.BitFieldKind getBitFieldKind() {
        return IBitFieldRegister.BitFieldKind.VHDL_RECORD;
    }

    public String getBitFieldDiagramHeader() {
        return "Bit Fields of record";
    }

    private static class BitfieldCandidate {
        List<StructMemberContextInfo> members;
        String name;
        String type;
        String parentName;
        int size;
        Integer lane;
        Integer laneIndex;
        BitField.Color color = BitField.Color.GREEN;

        public BitfieldCandidate(Integer lane, Integer laneIndex, Integer size, String parent) {
            this.size = size;
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.name = parent;
        }

        public BitfieldCandidate(StructMemberContextInfo info, Integer lane, Integer laneIndex, String parent) {
            this.members = info.getMembers();
            this.size = info.context.getSize();
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.parentName = parent;
            this.name = info.name;
            this.type = info.context.getOrigin() instanceof IRfAssociatedType ? ((IRfAssociatedType)info.context.getOrigin()).getAssociatedTypeName() : "";
            this.color = this.getColor(info.context.getOrigin());
        }

        public BitfieldCandidate(DVTUnpackedStruct info, Integer lane, Integer laneIndex, String name, String type) {
            this.members = new ArrayList<StructMemberContextInfo>(info.getMembersInfoOrdered());
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.parentName = "";
            this.name = name;
            this.size = info.getSize();
            this.type = type;
            this.color = BitField.Color.BLUE;
        }

        public BitfieldCandidate(VhdlEnum info, Integer lane, Integer laneIndex, String name, String type) {
            this.members = info.getMembersInfoOrdered();
            this.lane = lane;
            this.laneIndex = laneIndex;
            this.parentName = "";
            this.name = name;
            this.size = info.getSize();
            this.type = type;
            this.color = this.getColor(info.getEnumValue());
        }

        BitField.Color getColor(IRfNamedElement e) {
            if (!(e instanceof RfVariable)) {
                return BitField.Color.GREEN;
            }
            RfType t = (RfType)((RfVariable)e).transientType;
            if (t.isPredefined()) {
                return BitField.Color.GREEN;
            }
            if (t.isRecord()) {
                return BitField.Color.BLUE;
            }
            if (t.isEnumType()) {
                return BitField.Color.ORANGE;
            }
            if (t instanceof RfListType) {
                return BitField.Color.DARK_GREEN;
            }
            return BitField.Color.GREEN;
        }

        public int hashCode() {
            return Objects.hash(this.lane, this.laneIndex, this.members, this.name, this.parentName, this.size, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitfieldCandidate other = (BitfieldCandidate)obj;
            return Objects.equals(this.lane, other.lane) && Objects.equals(this.laneIndex, other.laneIndex);
        }
    }
}

