/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfRulesContainer;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfDefElement;

public abstract class RfRulesContainer
extends RfAssociatedType
implements IRfRulesContainer {
    private static final long serialVersionUID = 2L;
    private transient List<RfConfigurationRule> fCachedConfigurationRules;

    protected RfRulesContainer(String name, DataType dataType, IRfAssociatedType.AssocTypeKind kind) {
        super(name, dataType, kind);
    }

    public Collection<? extends IRfConfigurationRule> getLocalRules() {
        this.computeCachedConfigurationRules();
        return this.fCachedConfigurationRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void computeCachedConfigurationRules() {
        if (this.fCachedConfigurationRules != null) {
            return;
        }
        RfRulesContainer rfRulesContainer = this;
        synchronized (rfRulesContainer) {
            if (this.fCachedConfigurationRules != null) {
                return;
            }
            List<RfConfigurationRule> members = this.getLocalMembers(RfConfigurationRule.class);
            if (members == null || members.isEmpty()) {
                this.fCachedConfigurationRules = Collections.emptyList();
                return;
            }
            for (RfConfigurationRule member : members) {
                this.fCachedConfigurationRules = OptimizedUtils.listAdd(this.fCachedConfigurationRules, (Object)member);
            }
        }
    }

    @Override
    public String getContextType() {
        return null;
    }

    public String getSignature() {
        return null;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.fCachedConfigurationRules = null;
    }
}

