/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfScalarType
extends RfType {
    private static final long serialVersionUID = 1L;
    protected IHidOperator rangeExpression;
    protected boolean hasPhysicalUnits;
    protected Map<String, IRfNamedElement> cachedEnumNames;

    public RfScalarType(String name, RfType.TypeKind typeKind, DataType dataType) {
        super(name, typeKind, dataType);
    }

    public Collection<IRfNamedElement> getEnumValues() {
        Map<String, IRfNamedElement> localEnumCandidatesByType = this.getEnclosingScope().getLocalEnumCandidatesByType(this);
        if (localEnumCandidatesByType.isEmpty()) {
            return null;
        }
        return new ArrayList<IRfNamedElement>(localEnumCandidatesByType.values());
    }

    public IRfNamedElement getEnumValueForOrdinal(int ordinal) {
        Map<String, IRfNamedElement> localEnumCandidatesByType = this.getEnclosingScope().getLocalEnumCandidatesByType(this);
        for (IRfNamedElement candidate : localEnumCandidatesByType.values()) {
            if (!(candidate instanceof RfEnum) || ((RfEnum)candidate).getOrdinal() != ordinal) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public synchronized Map<String, IRfNamedElement> getEnumNames() {
        if (this.cachedEnumNames == null) {
            this.cachedEnumNames = this.getEnclosingScope().getLocalEnumCandidatesByType(this);
        }
        return this.cachedEnumNames;
    }

    public boolean hasPhysicalUnits() {
        return this.hasPhysicalUnits;
    }

    public void setHasPhysicalUnits(boolean hasPhysicalUnits) {
        this.hasPhysicalUnits = hasPhysicalUnits;
    }

    public boolean hasFloatingRange() {
        return this.hasFloatingRange(new HashSet<IRfNamedElement>());
    }

    public boolean hasFloatingRange(Set<IRfNamedElement> visited) {
        if (visited.contains(this)) {
            return false;
        }
        if (this.rangeExpression == null || this.rangeExpression.getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
            return false;
        }
        if (this.hasPhysicalUnits()) {
            return false;
        }
        visited.add(this);
        if (this.rangeExpression.isOperatorResolved()) {
            IRfNamedElement realType;
            ISDataAbstract operatorResolvedType = this.rangeExpression.getOperatorResolvedType();
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operatorResolvedType);
            IRfNamedElement type = STransformer.INSTANCE.getBaseType(dataType.getType(), false);
            return type.equals(realType = this.getRfProject().getStandardType(IRfVhdlTypeElement.VhdlStdType.REAL)) || type instanceof RfScalarType && ((RfScalarType)type).isNumericType() && ((RfScalarType)type).hasFloatingRange(visited);
        }
        Number number = this.getLeftRangeBound();
        return number instanceof Float;
    }

    public void setRange(IHidOperator range) {
        this.rangeExpression = range;
    }

    public IHidOperator getRangeExpression() {
        return this.rangeExpression;
    }

    public Number getLeftRangeBound() {
        if (this.rangeExpression == null) {
            return null;
        }
        IHidObject value = this.rangeExpression.getLHValue();
        if (HidUtils.isOperator((IHidObject)value) && ((HidOperator)value).getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
            value = ((HidOperator)value).getLHValue();
        }
        return HidUtils.isHidImplicit((IHidObject)value) ? (Number)((HidImplicit)value).parseNumberValue() : (Number)null;
    }

    public Number getRightRangeBound() {
        if (this.rangeExpression == null) {
            return null;
        }
        ListContainer rhValues = this.rangeExpression.getRHValues();
        if (rhValues == null || rhValues.size() != 1) {
            return null;
        }
        IHidObject value = (IHidObject)rhValues.get(0);
        if (HidUtils.isOperator((IHidObject)value) && ((HidOperator)value).getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
            value = ((HidOperator)value).getLHValue();
        }
        return HidUtils.isHidImplicit((IHidObject)value) ? (Number)((HidImplicit)value).parseNumberValue() : (Number)null;
    }

    @Override
    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (this.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.CHARACTER))) {
            int[] nArray = new int[2];
            nArray[0] = 7;
            return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)false, (int)7, (int)0, (int[])nArray, (boolean)false, (boolean)true, (boolean)false, (boolean)false, null, null), (IRfNamedElement)this);
        }
        if (this.isNumericType()) {
            if (this.hasFloatingRange()) {
                return BitVectorContext.of((DVTNumber)new VlogRealNumber(0.0), (IRfNamedElement)this, (IRfNamedElement)this);
            }
            return BitVectorContext.of((DVTNumber)VlogBitVector.createForSize((boolean)true, (int)31, (int)0, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, null), (IRfNamedElement)this, (IRfNamedElement)this);
        }
        if (this.isEnumType()) {
            int nofBitsBaseType = 32;
            int enumValuesSize = this.getEnumNames().size();
            boolean is4State = false;
            if ("STD_ULOGIC".equalsIgnoreCase(this.getName()) && enumValuesSize == 9) {
                is4State = true;
                nofBitsBaseType = 1;
            } else {
                nofBitsBaseType = (int)StrictMath.ceil(StrictMath.log(enumValuesSize) / StrictMath.log(2.0));
            }
            return BitVectorContext.of((DVTNumber)new VhdlEnum((IRfNamedElement)this, nofBitsBaseType, is4State), (IRfNamedElement)this, (IRfNamedElement)this);
        }
        return null;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.rangeExpression = null;
        this.hasPhysicalUnits = false;
        this.cachedEnumNames = null;
    }

    @Override
    public IRfNamedElement xGetMember(String name) {
        if (!this.isEnumType()) {
            return super.xGetMember(name);
        }
        Map<String, IRfNamedElement> enumNames = this.getEnumNames();
        if (enumNames == null || enumNames.isEmpty()) {
            return null;
        }
        return enumNames.get(name);
    }
}

