/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfNameTypeScopeHelper;

public class RfScopeUtil {
    public static IRfScopeElement getScopeElementOfDef(IRfScopeElement rfProject, List<? extends DVTRfNameTypeScopeHelper> elementScope) {
        if (elementScope == null) {
            return null;
        }
        if (rfProject == null) {
            return null;
        }
        IRfScopeElement scope = rfProject;
        for (DVTRfNameTypeScopeHelper dVTRfNameTypeScopeHelper : elementScope) {
            RfNamedElement candidate = null;
            int elementKind = dVTRfNameTypeScopeHelper.getElementKind();
            String elementName = dVTRfNameTypeScopeHelper.getElementName();
            if (scope instanceof RfNamedElement && elementKind == 256) {
                candidate = ((IRfScope)scope).getArchitectureWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 2) {
                candidate = ((IRfScope)scope).getEntityWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 2048) {
                candidate = ((IRfScope)scope).getInstanceWithPrefix(elementName, 1, false);
            } else if (scope instanceof IRfScope && elementKind == 4096) {
                candidate = ((IRfScope)scope).getLibraryWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 8192) {
                candidate = ((IRfScope)scope).getBlockWithPrefix(elementName, 1, true);
            } else if (scope instanceof IRfScope && elementKind == 512) {
                candidate = ((IRfScope)scope).getPackageWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 1024) {
                candidate = ((IRfScope)scope).getPackageBodyWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 8) {
                candidate = ((IRfScope)scope).getFunctionWithPrefix(elementName, 1, true);
            } else if (scope instanceof IRfScope && elementKind == 65536) {
                candidate = ((IRfScope)scope).getProcessWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 131072) {
                candidate = ((IRfScope)scope).getTypeWithPrefix(elementName, 1);
            } else if (scope instanceof IRfScope && elementKind == 262144) {
                candidate = ((IRfScope)scope).getTypeBodyWithPrefix(elementName, 1);
            } else if (scope instanceof RfProject && elementKind == 32768) {
                if (elementName == null || elementName.isEmpty()) continue;
                candidate = ((RfProject)scope).getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)((RfProject)scope), elementName, 1);
            } else if (!(scope instanceof IRfScope) && scope instanceof IRfLibraryElement && elementKind == 32768) {
                candidate = ((IRfLibraryElement)scope).getDesignWithPrefix(elementName, 1);
            } else {
                return scope;
            }
            if (candidate == null) {
                return scope;
            }
            scope = candidate;
        }
        return scope;
    }

    public static List<? extends DVTRfNameTypeScopeHelper> getDefOfScopeElement(IRfScopeElement elementScope) {
        if (elementScope == null) {
            return null;
        }
        ArrayList<RfNameTypeScopeHelper> result = new ArrayList<RfNameTypeScopeHelper>();
        IRfScopeElement scope = elementScope;
        do {
            if (scope instanceof RfProject) {
                return result;
            }
            if (!(scope instanceof IRfNamedElement)) {
                return result;
            }
            if (scope instanceof RfFunctionsHolder) continue;
            result.add(0, new RfNameTypeScopeHelper((IRfNamedElement)scope));
        } while ((scope = ((IRfNamedElement)scope).getEnclosingScope()) != null);
        return result;
    }
}

