/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.ConstraintHolder;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.OpenIndexConstraint;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfType
extends RfNamedElement
implements IRfAssociatedType,
IRfVhdlTypeElement,
IRfEnumElement {
    private static final long serialVersionUID = 2L;
    public static final String LENGTH_ATTR = "LENGTH";
    public static final String LEFT_ATTR = "LEFT";
    public static final String RIGHT_ATTR = "RIGHT";
    public static final String HIGH_ATTR = "HIGH";
    public static final String LOW_ATTR = "LOW";
    public static final String RANGE_ATTR = "RANGE";
    public static final String POS_ATTR = "POS";
    public static final String ASCENDING_ATTR = "ASCENDING";
    public static final String EVENT_ATTR = "EVENT";
    protected TypeKind typeKind;
    protected DataType associatedDataType;
    protected boolean isCharacterTypeEnum;
    protected transient IRfNamedElement transientType;
    protected transient ConstraintHolder constraintHolder;

    public RfType(String name, TypeKind typeKind, DataType dataType) {
        super(name);
        this.init(typeKind, dataType, name);
    }

    @Override
    protected void addMember(RfNamedElement element) {
        if (element instanceof RfEnum) {
            this.getEnclosingScope().addMember(element);
        } else {
            super.addMember(element);
        }
    }

    @Override
    public <T extends IRfNamedElement> T getLocalMember(Class<T> clazz, String name) {
        if (clazz == RfEnum.class) {
            return this.getEnclosingScope().getLocalMember(clazz, String.valueOf(name) + "@" + this.getName());
        }
        return super.getLocalMember(clazz, name);
    }

    @Override
    public String getQualifiedName(IRfScopeElement initialScope, ElementPath hierarchyPath, int options) {
        RfNamedElement enclosingScope;
        String enclosingScopeString = "";
        if (IRfNamedElement.QualifiedNameOptions.contains((int)1, (int)options) && (enclosingScope = this.getEnclosingScope()) != null && !(enclosingScope instanceof RfProject)) {
            enclosingScopeString = String.valueOf(enclosingScope.getName()) + ".";
        }
        return String.valueOf(enclosingScopeString) + super.getQualifiedName(initialScope, hierarchyPath, options);
    }

    public IRfNamedElement getResolvedType(boolean resolveIfNotCached) {
        IRfNamedElement assocType = this.getAssociatedType();
        if (!resolveIfNotCached || assocType != null) {
            return assocType;
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return null;
        }
        this.internalResolveType(new ConfigInfo(false, rfProject, this.getEnclosingLibrary(), false, IBuildConfigParserConstants.ToolCompat.DVT), rfProject, false, true, true);
        return this.transientType;
    }

    public void init(TypeKind typeKind, DataType dataType, String name) {
        this.init(typeKind, dataType, true, name);
    }

    public void init(TypeKind typeKind, DataType dataType, boolean forceUpdate, String name) {
        TypeKind typeKind2 = forceUpdate ? typeKind : (this.typeKind = typeKind != null ? typeKind : this.typeKind);
        this.associatedDataType = forceUpdate ? dataType : (dataType != null ? dataType : this.associatedDataType);
        this.init(name);
    }

    public boolean isFullyConstrained() {
        return this.constraintHolder == null || this.constraintHolder.isFullyConstrained();
    }

    public ConstraintHolder getConstraintHolder() {
        return this.constraintHolder;
    }

    protected void computeLocalConstraints() {
        List<IndexConstraint> arrayConstraints;
        if (this.constraintHolder != null) {
            return;
        }
        this.constraintHolder = new ConstraintHolder(this);
        DataType dataType = this.getDataType();
        if (dataType != null && (arrayConstraints = dataType.getArrayConstraints()) != null) {
            for (IndexConstraint indexConstraint : arrayConstraints) {
                IHidObject hidObject = indexConstraint.getHidObject();
                if (!HidUtils.isOperator((IHidObject)hidObject)) continue;
                RfHidOperator constraint = (RfHidOperator)hidObject;
                if (!this.isConstrainedRange(constraint)) {
                    this.constraintHolder.addConstraint(new IndexConstraint((IHidObject)constraint));
                    continue;
                }
                this.constraintHolder.addConstraint(new OpenIndexConstraint((IHidObject)constraint));
                return;
            }
        }
    }

    private boolean isConstrainedRange(RfHidOperator operator) {
        if (operator.isRangeOrPartSelect()) {
            return true;
        }
        IHidObject rightValue = operator.getFirstRHValue();
        if (operator.isLiteralRange()) {
            return !(rightValue instanceof IRfHidImplicitLayer) || !((IRfHidImplicitLayer)rightValue).isBox();
        }
        return false;
    }

    public void setAssocTypeName(DataType dataType) {
        this.associatedDataType = dataType;
    }

    public void setTypeKind(TypeKind typeKind) {
        this.typeKind = typeKind;
    }

    public boolean isArray() {
        return this.associatedDataType != null && (this.typeKind == TypeKind.IS_ARRAY || this.typeKind == TypeKind.IS_UNBOUND_ARRAY);
    }

    public boolean isSubtype() {
        return this.associatedDataType != null && this.typeKind == TypeKind.IS_SUBTYPE;
    }

    public boolean isAccess() {
        return this.associatedDataType != null && this.typeKind == TypeKind.IS_ACCESS;
    }

    public boolean isGeneric() {
        return this.typeKind == TypeKind.IS_GENERIC;
    }

    public boolean isRecord() {
        return this.typeKind == TypeKind.IS_RECORD;
    }

    public boolean isProtected() {
        return this.typeKind == TypeKind.IS_PROTECTED;
    }

    public boolean isFile() {
        return this.typeKind == TypeKind.IS_FILE;
    }

    public boolean isEnumType() {
        return this.typeKind == TypeKind.IS_ENUM_SCALAR;
    }

    public boolean isNumericType() {
        return this.typeKind == TypeKind.IS_NUMERIC_SCALAR;
    }

    public boolean hasScalarBaseType() {
        return this.getBaseOfSubtype() instanceof RfScalarType;
    }

    public IELParamValue getScalarAttribute(IHidEvaluator evaluator, String attributeName, List<IHidObject> argHidObjects, IHidEvaluationGuardian guardian) {
        DataType dataType;
        IHidObject constraintHidObject;
        BitVectorContext defaultContext = BitVectorContext.of((IRfNamedElement)this, (boolean)false);
        boolean isSubtype = this.isSubtype();
        if (isSubtype && (constraintHidObject = (dataType = this.getDataType()).getElementConstraintHidObject(0)) != null) {
            return this.getNumericScalarAttributeFromOperator(attributeName, constraintHidObject, evaluator, defaultContext, guardian);
        }
        RfType finalType = this;
        while (finalType.isSubtype()) {
            finalType = finalType.getAssociatedType();
        }
        if (finalType instanceof RfScalarType && ((RfScalarType)finalType).isEnumType()) {
            int nofEnums = ((RfScalarType)finalType).getEnumNames().size();
            if (LEFT_ATTR.equals(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.ZERO));
            }
            if (RIGHT_ATTR.equals(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf((long)nofEnums - 1L)));
            }
            if (HIGH_ATTR.equals(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf((long)nofEnums - 1L)));
            }
            if (LOW_ATTR.equals(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.ZERO));
            }
            if (RANGE_ATTR.equals(attributeName)) {
                int[] nArray = new int[2];
                nArray[1] = nofEnums - 1;
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(nofEnums - 1), (int)0, (int[])nArray, (boolean)false));
            }
            if (POS_ATTR.equals(attributeName)) {
                if (argHidObjects == null || argHidObjects.size() != 1) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                IELParamValue argValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)argHidObjects.iterator().next(), (IHidEvaluator)evaluator, (BitVectorContext)this.getDataTypeBitVectorContext(evaluator, false, null, null), (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)argValue)) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.createConstant((int)argValue.intValue()));
            }
        } else if (finalType instanceof RfScalarType && ((RfScalarType)finalType).isNumericType()) {
            IHidOperator constraintOperator = ((RfScalarType)finalType).getRangeExpression();
            return this.getNumericScalarAttributeFromOperator(attributeName, (IHidObject)constraintOperator, evaluator, defaultContext, guardian);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private IELParamValue getNumericScalarAttributeFromOperator(String attributeName, IHidObject constraint, IHidEvaluator evaluator, BitVectorContext defaultContext, IHidEvaluationGuardian guardian) {
        if (HidUtils.isOperator((IHidObject)constraint) && ((RfHidOperator)constraint).isLiteralRange()) {
            constraint = ((RfHidOperator)constraint).getFirstRHValue();
        }
        switch (constraint.getHidKind()) {
            case OPERATOR: {
                RfHidOperator constrOp = (RfHidOperator)constraint;
                IHidObject rh0 = constrOp.getFirstRHValue();
                if (rh0 == null) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                if (rh0 instanceof IRfHidImplicitLayer) {
                    if (((IRfHidImplicitLayer)rh0).isBox()) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                int leftIntValue = 0;
                int rightIntValue = 0;
                IRfNamedElement baseOfSubtype = this.getBaseOfSubtype();
                if (RANGE_ATTR.equalsIgnoreCase(attributeName) && ("STD_ULOGIC".equalsIgnoreCase(baseOfSubtype.getName()) || "STD_ULOGIC".equalsIgnoreCase(this.getName()))) {
                    if (!(constrOp.getLHValue() instanceof RfHidImplicit)) return null;
                    if (!(constrOp.getRHValues().get(0) instanceof RfHidImplicit)) {
                        return null;
                    }
                    switch (((RfHidImplicit)constrOp.getLHValue()).getName()) {
                        case "U": {
                            leftIntValue = 0;
                            break;
                        }
                        case "X": {
                            leftIntValue = 1;
                            break;
                        }
                        case "0": {
                            leftIntValue = 2;
                            break;
                        }
                        case "1": {
                            leftIntValue = 3;
                            break;
                        }
                        case "Z": {
                            leftIntValue = 4;
                            break;
                        }
                        case "W": {
                            leftIntValue = 5;
                            break;
                        }
                        case "L": {
                            leftIntValue = 6;
                            break;
                        }
                        case "H": {
                            leftIntValue = 7;
                            break;
                        }
                        case "-": {
                            leftIntValue = 8;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    switch (((RfHidImplicit)constrOp.getRHValues().get(0)).getName()) {
                        case "U": {
                            rightIntValue = 0;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "X": {
                            rightIntValue = 1;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "0": {
                            rightIntValue = 2;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "1": {
                            rightIntValue = 3;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "Z": {
                            rightIntValue = 4;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "W": {
                            rightIntValue = 5;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "L": {
                            rightIntValue = 6;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "H": {
                            rightIntValue = 7;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        case "-": {
                            rightIntValue = 8;
                            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
                        }
                        default: {
                            return null;
                        }
                    }
                }
                IELParamValue leftValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)constrOp.getLHValue(), (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)leftValue)) return null;
                if (DVTNumber.isUndefined((DVTNumber)leftValue.getDVTNumber())) {
                    return null;
                }
                IELParamValue rightValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)constrOp.getRHValues().get(0)), (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)rightValue)) return null;
                if (DVTNumber.isUndefined((DVTNumber)rightValue.getDVTNumber())) {
                    return null;
                }
                leftIntValue = leftValue.intValue();
                rightIntValue = rightValue.intValue();
                if (ASCENDING_ATTR.equalsIgnoreCase(attributeName)) {
                    VlogBitVector vlogBitVector;
                    if (leftIntValue < rightIntValue) {
                        vlogBitVector = VlogBitVector.TRUE;
                        return ELParamValues.ParamValueNumber.of((DVTNumber)vlogBitVector);
                    }
                    vlogBitVector = VlogBitVector.FALSE;
                    return ELParamValues.ParamValueNumber.of((DVTNumber)vlogBitVector);
                }
                if (LEFT_ATTR.equalsIgnoreCase(attributeName)) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(leftIntValue)));
                }
                if (RIGHT_ATTR.equalsIgnoreCase(attributeName)) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(rightIntValue)));
                }
                if (HIGH_ATTR.equalsIgnoreCase(attributeName)) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.max(leftIntValue, rightIntValue))));
                }
                if (LOW_ATTR.equalsIgnoreCase(attributeName)) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.min(leftIntValue, rightIntValue))));
                }
                if (!RANGE_ATTR.equalsIgnoreCase(attributeName)) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)(Math.abs(rightIntValue - leftIntValue) + 1), (int)0, (int[])new int[]{leftIntValue, rightIntValue}, (boolean)false));
            }
            case HID: {
                RfHid hid = (RfHid)constraint;
                HidAccess parentAccess = hid.getParentAccess();
                if (!RANGE_ATTR.equalsIgnoreCase(hid.getName())) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                if (!(parentAccess instanceof RfHidAccess)) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                if (!parentAccess.isAttributeAccess()) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                IELParamValue evaluate = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)parentAccess, (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)evaluate)) return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                if (DVTNumber.isUndefined((DVTNumber)evaluate.getDVTNumber())) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                DVTNumber number = evaluate.getDVTNumber();
                return ((RfHidAccess)parentAccess).getArrayAttribute(attributeName, null, number, null);
            }
        }
        return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
    }

    public boolean isCharacterTypeEnum() {
        return this.typeKind == TypeKind.IS_ENUM_SCALAR && this.isCharacterTypeEnum;
    }

    public void setCharacterTypeEnum() {
        this.isCharacterTypeEnum = true;
    }

    public IRfNamedElement getAssociatedType() {
        return this.transientType;
    }

    public IRfNamedElement getBaseOfSubtype() {
        IdentityHashMap<RfType, RfType> visited = new IdentityHashMap<RfType, RfType>();
        visited.put(this, this);
        RfType result = this;
        while (result instanceof RfType && result.isSubtype()) {
            result = result.transientType;
            if (visited.containsKey(result)) {
                return result;
            }
            visited.put(result, result);
        }
        return result;
    }

    @Override
    public IRfNamedElement getAssociatedTypeWithGenericMap(Map<String, IRfNamedElement> genericMap) {
        if (genericMap == null) {
            return this.getAssociatedType();
        }
        IRfNamedElement assocType = genericMap.get(this.getName());
        if (assocType != null) {
            return assocType;
        }
        return this.getAssociatedType();
    }

    @Override
    public IRfAssociatedType.AssocTypeKind getAssociatedTypeKind() {
        return IRfAssociatedType.AssocTypeKind.ASSOC_TYPE;
    }

    public String getSignature() {
        String result = "type " + this.printScope() + this.getName();
        if (this.isSubtype()) {
            result = String.valueOf(result) + " is subtype of " + DataType.getFullTypeName(this.associatedDataType, false);
        } else if (this.isAccess()) {
            result = String.valueOf(result) + " is access of " + DataType.getFullTypeName(this.associatedDataType, false);
        }
        return result;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        this.internalResolveType(configInfo, rfProject, report, onlyUnresolved, otherLanguage);
        ConfigInfo localConfigInfo = new ConfigInfo(configInfo);
        localConfigInfo.keepGenericMap = false;
        super.resolveHids(localConfigInfo, false, false, null);
        super.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        this.declarePredefinedArrayFunctions();
        this.computeLocalConstraints();
        this.checkUnimplementedProtectedType(rfProject, report);
    }

    private void checkUnimplementedProtectedType(RfProject rfProject, boolean report) {
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (report && enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).hasPackageBody() && this.isProtected() && this.getTypeBody() == null && !this.isPredefined()) {
            RfPackage pkg = (RfPackage)enclosingScope;
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath = declaration.getParserPath();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + declaration.getName().length();
            rfProject.addSemanticError(2, "MISSING_PACKAGE_BODY_DEFINITION: Protected type ''{0}'' is not implemented in package body ''{1}''", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, this.getName(), pkg.getName());
        }
    }

    protected void declarePredefinedArrayFunctions() {
    }

    private void internalResolveType(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        try {
            ParserPath parserPath;
            RfDefElement declaration;
            if (this.associatedDataType == null) {
                return;
            }
            List<DataTypeChunk> assocTypeName = this.associatedDataType.getTypeName();
            if (assocTypeName == null || assocTypeName.isEmpty()) {
                return;
            }
            configInfo.addReference(this.associatedDataType);
            configInfo.addReferenceToIdentifierName(this.associatedDataType);
            this.transientType = this.internalComputeAssociatedType(this.associatedDataType, IRfAssociatedType.AssocTypeKind.ASSOC_TYPE, true);
            if (report && (this.transientType == null || this.transientType instanceof RfAssociatedType.RfUnresolvedInfo) && (declaration = this.getDeclaration()) != null && declaration.getDefFile() != null && !RfProject.isPredefined(parserPath = declaration.getParserPath())) {
                String unresolvedName;
                int line = declaration.getStartLine();
                int index = this.transientType instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.transientType).getIndex() : -1;
                String message = "NON_EXISTING_TYPE: Non existing type ''{0}''";
                if (index == 0 && assocTypeName.size() > 1) {
                    message = "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared";
                }
                String string = unresolvedName = this.transientType instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.transientType).getName() : null;
                if (unresolvedName == null || unresolvedName.isEmpty()) {
                    unresolvedName = DataType.getFullTypeName(this.associatedDataType, true);
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>(4);
                attributes.put("QUICKFIX_ELEMENT_NAME", unresolvedName);
                attributes.put("QUICKFIX_KIND", 10);
                int startOffset = this.transientType instanceof RfAssociatedType.RfUnresolvedInfo ? ((RfAssociatedType.RfUnresolvedInfo)this.transientType).getOffset() : this.associatedDataType.getOffset();
                int endOffset = startOffset + unresolvedName.length();
                rfProject.addSemanticError(1, message, this.getLibPkgScope(), startOffset, endOffset, attributes, line, parserPath, unresolvedName);
            }
            if (!(this.transientType instanceof RfAssociatedType.RfUnresolvedInfo) && this.transientType != null) {
                configInfo.addReference(this.transientType.getName());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public List<RfEnum> getEnumsWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        this.getEnclosingScope().internalGetMembersWithPrefix(resultMap, RfEnum.class, prefix, this.getName(), false, matchType, true);
        return new NullProtectedList<RfEnum>((Collection<RfEnum>)resultMap.values());
    }

    @Override
    public RfEnum getEnumWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        this.getEnclosingScope().internalGetMembersWithPrefix(resultMap, RfEnum.class, prefix, this.getName(), true, matchType, true);
        return resultMap.isEmpty() ? null : (RfEnum)resultMap.values().iterator().next();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_TYPE: Duplicate type ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public String getRange() {
        if (this.associatedDataType == null) {
            return null;
        }
        return this.associatedDataType.getRange();
    }

    public String getAssociatedTypeName() {
        if (this.associatedDataType == null) {
            return "";
        }
        List<DataTypeChunk> assocTypeName = this.associatedDataType.getTypeName();
        if (assocTypeName == null) {
            return "";
        }
        return assocTypeName.get((int)(assocTypeName.size() - 1)).name;
    }

    public BitVectorContext getDataTypeBitVectorContext(IHidEvaluator evaluator, boolean returnTypeParameterDefault, ElementPath hierarchyPath, ELManager manager) {
        return RfAssociatedType.internalGetDataTypeBitVectorContext(this, this.associatedDataType != null ? this.associatedDataType.getArrayConstraints() : null, evaluator, returnTypeParameterDefault, hierarchyPath, manager, this, new HashSet<IRfNamedElement>());
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    public TypeKind getTypeKind() {
        return this.typeKind;
    }

    public RfTypeBody getTypeBody() {
        if (!this.isProtected()) {
            return null;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        RfPackageBody body = null;
        if (enclosingScope instanceof RfPackage) {
            body = ((RfPackage)enclosingScope).getPackageBody();
        } else if (enclosingScope instanceof RfPackageBody) {
            body = (RfPackageBody)enclosingScope;
        }
        return body != null ? body.getLocalMember(RfTypeBody.class, this.getName()) : null;
    }

    @Override
    public void removeDef(RfDefElement def) {
        super.removeDef(def);
        this.transientType = null;
        this.constraintHolder = null;
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.isProtected() && obj instanceof RfTypeBody && ((RfTypeBody)obj).getType() == this) {
            return true;
        }
        return super.checkEquals(obj);
    }

    public static enum TypeKind {
        IS_SUBTYPE,
        IS_ACCESS,
        IS_ARRAY,
        IS_UNBOUND_ARRAY,
        IS_PROTECTED,
        IS_GENERIC,
        IS_INCOMPLETE,
        IS_RECORD,
        IS_NUMERIC_SCALAR,
        IS_ENUM_SCALAR,
        IS_FILE;

    }
}

