/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IMembersProvider;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;

public class RfTypeBody
extends RfAssociatedType
implements IRfVhdlTypeElement {
    private static final long serialVersionUID = 1L;
    private transient RfType fType = null;

    public RfTypeBody(String name) {
        super(name, null, IRfAssociatedType.AssocTypeKind.ASSOC_UNKNOWN);
    }

    public String getSignature() {
        return "type protected body " + this.getName();
    }

    public RfType getType() {
        if (this.fType != null && !this.fType.hasNoDefs(false)) {
            return this.fType;
        }
        this.fType = this.getTypeWithPrefix(this.getName(), 9, false);
        return this.fType;
    }

    @Override
    public String getAssociatedTypeName() {
        return this.getName();
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fType = null;
    }

    public boolean isAccess() {
        return false;
    }

    public boolean isSubtype() {
        return false;
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        super.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        this.checkDeclaration(rfProject);
    }

    private void checkDeclaration(RfProject rfProject) {
        if (this.isPredefined()) {
            return;
        }
        String name = this.getName();
        int startOffset = this.getStartOffset();
        int endOffset = startOffset + name.length();
        int line = this.getLine();
        ParserPath parserPath = this.getDeclaration().getParserPath();
        LibraryPackageScope libPkgScope = this.getLibPkgScope();
        if (this.getEnclosingScope() instanceof RfPackage) {
            rfProject.addSemanticError(1, "ILLEGAL_PROTECTED_TYPE_BODY_DECLARATION: Protected type body ''{0}'' not allowed inside package", libPkgScope, startOffset, endOffset, null, line, parserPath, name);
        }
        if (this.getType() == null) {
            rfProject.addSemanticError(1, "MISSING_PROTECTED_TYPE_DECLARATION: Protected type body ''{0}'' does not have corresponding type declaration", libPkgScope, startOffset, endOffset, null, line, parserPath, name);
        }
    }

    @Override
    public boolean checkEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RfType && ((RfType)obj).isProtected() && ((RfType)obj).getTypeBody() == this) {
            return true;
        }
        return super.checkEquals(obj);
    }

    @Override
    public String getContextType() {
        return null;
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        IRfNamedElement result = super.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, parserPath, line);
        if (result != null) {
            return result;
        }
        RfType type = this.getType();
        if (type != null && (result = type.elementPathMember(name, isFirst, isLast, includeEnums, isOnlyType, bindInstanceScope, classes, exclude, null, -1)) != null) {
            return result;
        }
        return null;
    }

    @Override
    protected IRfNamedElement getMemberInUseClauses(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        RfType theType;
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getExplicitUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext && (result = ((RfContext)element).getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null) {
                    return result;
                }
                if (element == exclude || element == null || classes != null && !classes.contains(element.getClass())) continue;
                if (element instanceof RfNamedElement && name.equalsIgnoreCase(element.getName())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        if ((useList = this.getWildcardUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element != null) {
                    result = element.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                }
                if (result == null || result == exclude) continue;
                return result;
            }
        }
        if ((theType = this.getType()) != null) {
            IRfNamedElement element2;
            useList = theType.getExplicitUse();
            if (useList != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfContext && (result = ((RfContext)element2).getMember(visited, name, enumParentTypeName, isFirst, isLast, isOnlyType, classes, exclude)) != null) {
                        return result;
                    }
                    if (element2 == exclude || element2 == null || classes != null && !classes.contains(element2.getClass())) continue;
                    if (element2 instanceof RfNamedElement && name.equalsIgnoreCase(element2.getName())) {
                        return element2;
                    }
                    if (!(element2 instanceof RfType) || (result = ((RfType)element2).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element2.getName()), isFirst, isLast, true, false)) == null) continue;
                    return result;
                }
            }
            if ((useList = theType.getWildcardUse()) != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 != null) {
                        result = element2.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
                    }
                    if (result == null || result == exclude) continue;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    protected IRfNamedElement getLocalMember(Set<IRfNamedElement> visited, String name, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude) {
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        IMembersProvider membersProvider = scope -> {
            IRfNamedElement result = scope.getVisibleMemberInScope(name, classes, exclude, visited, enumParentTypeName, isFirst, isLast, isOnlyType, false);
            if (result == exclude) {
                result = null;
            }
            if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
                result = null;
            }
            return result;
        };
        IRfNamedElement result = membersProvider.getLocalMember((IRfNamedElement)this);
        if (isOnlyType && result instanceof RfAlias && ((RfAlias)result).isSubprogramInstantiation()) {
            return null;
        }
        if (result != null && result != exclude) {
            return result;
        }
        RfType theType = this.getType();
        if (theType != null && (result = membersProvider.getLocalMember((IRfNamedElement)theType)) != null && result != exclude) {
            return result;
        }
        return null;
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        Set<Class<RfComponent>> classes;
        IRfNamedElement result;
        if (visited != null) {
            if (visited.contains(this)) {
                return null;
            }
            visited.add(this);
        }
        if ((result = this.getLocalMember(classes = hid == null || !hid.hasOccurrence(HidQualifierCache.COMPONENT_TYPE) ? DVTRfUtils.MEMBERS_OTHERS : Collections.singleton(RfComponent.class), name, (IRfNamedElement)null)) != null) {
            return result;
        }
        RfType theType = this.getType();
        if (theType == null) {
            return null;
        }
        if (visited != null) {
            if (visited.contains(theType)) {
                return null;
            }
            visited.add(theType);
        }
        result = theType.getLocalMember(classes, name, (IRfNamedElement)null);
        return result;
    }

    @Override
    public IRfNamedElement semanticGetMemberInUseClauses(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        RfType theType;
        IRfNamedElement element;
        IRfNamedElement result = null;
        List<ImportInfo> useList = this.getWildcardUse();
        if (useList != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfNamedElement) {
                    result = ((RfNamedElement)element).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
                } else if (element instanceof IRfLibraryElement) {
                    result = ((IRfLibraryElement)element).getDesignWithPrefix(name, 9);
                }
                if (result == null) continue;
                return result;
            }
        }
        if ((useList = this.getExplicitUse()) != null) {
            for (ImportInfo use : useList) {
                element = use.getElement();
                if (element instanceof RfContext) {
                    result = ((RfContext)element).semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
                    if (result == null) continue;
                    return result;
                }
                if (!(element instanceof RfNamedElement)) continue;
                if (DVTStringUtil.regionMatches((String)element.getName(), (String)name, (int)9) && DVTRfUtils.MEMBERS_OTHERS.contains(element.getClass())) {
                    return element;
                }
                if (!(element instanceof RfType) || (result = ((RfType)element).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element.getName()), isFirst, isLast, true, false)) == null) continue;
                return result;
            }
        }
        if ((theType = this.getType()) != null) {
            IRfNamedElement element2;
            useList = theType.getWildcardUse();
            if (useList != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfNamedElement) {
                        result = ((RfNamedElement)element2).getLocalMember(DVTRfUtils.MEMBERS_OTHERS, name, (IRfNamedElement)null);
                    } else if (element2 instanceof IRfLibraryElement) {
                        result = ((IRfLibraryElement)element2).getDesignWithPrefix(name, 9);
                    }
                    if (result == null) continue;
                    return result;
                }
            }
            if ((useList = theType.getExplicitUse()) != null) {
                for (ImportInfo use : useList) {
                    element2 = use.getElement();
                    if (element2 instanceof RfContext) {
                        result = ((RfContext)element2).semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
                        if (result == null) continue;
                        return result;
                    }
                    if (!(element2 instanceof RfNamedElement)) continue;
                    if (DVTStringUtil.regionMatches((String)element2.getName(), (String)name, (int)9) && DVTRfUtils.MEMBERS_OTHERS.contains(element2.getClass())) {
                        return element2;
                    }
                    if (!(element2 instanceof RfType) || (result = ((RfType)element2).getEnclosingScope().getVisibleMemberInScope(name, Collections.singleton(RfEnum.class), null, visited, Collections.singletonList(element2.getName()), isFirst, isLast, true, false)) == null) continue;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TYPE);
    }
}

