/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;

public class RfVUnit
extends RfNamedElement {
    private static final long serialVersionUID = 1L;
    public static final int VUNIT = 0;
    public static final int VPROP = 1;
    public static final int VMODE = 2;
    private int fVUnitKind;
    private List<DataTypeChunk> fDesignFullName;
    private String fArchitectureName;
    private transient IRfNamedElement fTransientBoundedDesignOrInstance;

    public RfVUnit(String name, int kind, List<DataTypeChunk> designFullName, String architectureName) {
        super(name);
        this.fVUnitKind = kind;
        this.fDesignFullName = designFullName;
        this.fArchitectureName = architectureName;
    }

    public void init(int kind, List<DataTypeChunk> designFullName, String architectureName, String name) {
        this.fVUnitKind = kind;
        this.fDesignFullName = designFullName;
        this.fArchitectureName = architectureName;
        this.init(name);
    }

    public String getQualifiedName() {
        if (this.getEnclosingScope() == null) {
            return "";
        }
        if (this.getEnclosingScope() instanceof RfLibrary) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + " of " + this.getEnclosingLibrary().getName() + "." + DataType.qualifiedNameAsString(this.fDesignFullName).toString();
    }

    public String getSignature() {
        return String.valueOf(switch (this.fVUnitKind) {
            case 1 -> "vprop ";
            case 2 -> "vmode ";
            default -> "vunit ";
        }) + this.getQualifiedName();
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VUNIT);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fTransientBoundedDesignOrInstance = null;
    }

    public IRfNamedElement getBoundedDesignOrInstance() {
        return this.fTransientBoundedDesignOrInstance;
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        this.internalResolveType(configInfo, rfProject, report, onlyUnresolved, otherLanguage);
    }

    protected void internalResolveType(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        try {
            String designName;
            this.fTransientBoundedDesignOrInstance = null;
            int matchType = 9;
            if (this.fDesignFullName == null || this.fDesignFullName.isEmpty()) {
                return;
            }
            String instancePath = designName = this.fDesignFullName.get((int)0).name;
            DataType dataType = new DataType(this.fDesignFullName);
            configInfo.addReference(dataType);
            configInfo.addReferenceToIdentifierName(dataType);
            if (this.fArchitectureName != null) {
                RfEntity entity = this.getEntityWithPrefix(designName, 1);
                if (entity == null) {
                    this.reportUndeclaredDesignSemanticError(rfProject, report, "UNDECLARED_ENTITY: Entity ''{0}'' is not declared", designName);
                    return;
                }
                this.fTransientBoundedDesignOrInstance = entity.getArchitectureWithPrefix(this.fArchitectureName, 1);
                if (this.fTransientBoundedDesignOrInstance == null) {
                    this.reportUndeclaredDesignSemanticError(rfProject, report, "UNDECLARED_ARCHITECTURE: Architecture ''{0}'' is not declared", this.fArchitectureName);
                }
                if (this.fTransientBoundedDesignOrInstance != null && !(this.fTransientBoundedDesignOrInstance instanceof RfAssociatedType.RfUnresolvedInfo)) {
                    configInfo.addReference(this.fTransientBoundedDesignOrInstance.getName());
                }
                return;
            }
            RfEntity candidate = this.getEntityWithPrefix(designName, 1);
            if (candidate == null) {
                candidate = rfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)rfProject, designName, 9);
            }
            int designFullNameSize = this.fDesignFullName.size();
            if (candidate instanceof IRfDesignElement && designFullNameSize > 1) {
                int i = 1;
                while (candidate != null && i < designFullNameSize) {
                    String candidateName = this.fDesignFullName.get((int)i).name;
                    candidate = candidate.getInstanceWithPrefix(candidateName, matchType);
                    if (i < designFullNameSize - 1 || candidate == null) {
                        instancePath = String.valueOf(instancePath) + "." + candidateName;
                    }
                    ++i;
                }
            }
            this.fTransientBoundedDesignOrInstance = candidate instanceof IRfInstanceElement ? ((IRfInstanceElement)candidate).getSpecializedDesign(null) : candidate;
            if (this.fTransientBoundedDesignOrInstance == null) {
                this.reportUndeclaredDesignSemanticError(rfProject, report, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", instancePath);
            }
            if (this.fTransientBoundedDesignOrInstance != null && !(this.fTransientBoundedDesignOrInstance instanceof RfAssociatedType.RfUnresolvedInfo)) {
                configInfo.addReference(this.fTransientBoundedDesignOrInstance.getName());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void reportUndeclaredDesignSemanticError(RfProject rfProject, boolean report, String pattern, String undeclaredName) {
        ParserPath parserPath;
        if (!report) {
            return;
        }
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null && declaration.getDefFile() != null && !RfProject.isPredefined(parserPath = declaration.getParserPath())) {
            int line = declaration.getStartLine();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + undeclaredName.length();
            rfProject.addSemanticError(1, pattern, this.getLibPkgScope(), startOffset, endOffset, null, line, parserPath, undeclaredName);
        }
    }

    @Override
    protected <T extends IRfNamedElement> void internalMXGetMembersWithPrefix(Map<String, T> result, String prefix, boolean first, int matchType) {
        this.getEnclosingScope().internalMXGetMembersWithPrefix(result, prefix, first, matchType);
        IRfNamedElement design = this.getBoundedDesignOrInstance();
        if (design instanceof RfNamedElement) {
            ((RfNamedElement)design).internalMXGetMembersWithPrefix(result, prefix, first, matchType);
        }
    }

    @Override
    protected <Z extends IRfNamedElement, T extends IRfNamedElement> void internalGetMembersWithPrefix(Map<String, Z> result, Class<T> localMemberKind, String prefix, String enumParentTypeName, boolean first, int matchType, boolean local) {
        super.internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        boolean equals = (matchType & 1) != 0;
        boolean limit100 = (matchType & 0x20) != 0;
        int size = result.size();
        if (localMemberKind != RfFunctionsHolder.class && ((equals || first) && size > 0 || limit100 && size >= 100)) {
            return;
        }
        IRfNamedElement design = this.getBoundedDesignOrInstance();
        if (design instanceof RfNamedElement) {
            ((RfNamedElement)design).internalGetMembersWithPrefix(result, localMemberKind, prefix, enumParentTypeName, first, matchType, local);
        }
    }

    @Override
    protected IRfNamedElement semanticGetMember(Set<IRfNamedElement> visited, boolean recursiveCall, String name, boolean isFirst, boolean isLast, IHid hid) {
        IRfNamedElement result = super.semanticGetMember(visited, recursiveCall, name, isFirst, isLast, hid);
        if (result != null) {
            return result;
        }
        IRfNamedElement design = this.getBoundedDesignOrInstance();
        if (design != null) {
            result = design.semanticGetMember(name, hid, null, (IRfNamedElement)this, null, isFirst, isLast, recursiveCall);
        }
        return result;
    }

    @Override
    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        RfVariable result = this.getVariableWithPrefix(prefix, matchType, false);
        if (result != null) {
            return result;
        }
        IRfNamedElement design = this.getBoundedDesignOrInstance();
        if (design instanceof IRfDesignElement && !(design instanceof RfNamedElement)) {
            return design.getSignalWithPrefix(prefix, matchType);
        }
        return null;
    }

    @Override
    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        IRfNamedElement design;
        boolean equals;
        NullProtectedList<? extends IRfNamedElement> result = new NullProtectedList<IRfNamedElement>();
        result.addAll(super.getSignalsWithPrefix(prefix, matchType));
        boolean bl = equals = (matchType & 1) != 0;
        if ((!equals || result.isEmpty()) && (design = this.getBoundedDesignOrInstance()) instanceof IRfDesignElement && !(design instanceof RfNamedElement)) {
            result.addAll(design.getSignalsWithPrefix(prefix, matchType));
        }
        return result;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        IRfDesignElement result = super.getDesignWithPrefix(prefix, matchType);
        if (result != null) {
            return result;
        }
        RfProject rfProject = this.getRfProject();
        return rfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)rfProject, prefix, matchType);
    }

    @Override
    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        boolean equals;
        NullProtectedList<? extends IRfDesignElement> result = new NullProtectedList<IRfDesignElement>();
        result.addAll(super.getDesignsWithPrefix(prefix, matchType));
        boolean bl = equals = (matchType & 1) != 0;
        if (!equals || result.isEmpty()) {
            RfProject rfProject = this.getRfProject();
            result.addAll(rfProject.getMixedLangProjectParent().getDesignsWithPrefix((IRfSingleLangProject)rfProject, prefix, matchType));
        }
        return result;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_VUNIT: Duplicate vunit ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }
}

