/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.ELBatchUtils;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipInformationUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.ConstraintErrorInfo;
import ro.amiq.vhdldt.model.reflection.ConstraintHolder;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.RecordConstraintHolder;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfVariable
extends RfAssociatedType
implements IRfFieldElement {
    private static final long serialVersionUID = 3L;
    private int fVariableKind = 8192;
    private int fInterfaceKind = 1;
    private String fDirection;
    protected String fInitialValue;

    public RfVariable(String name, int interfaceKind, int variableKind, String direction, DataType dataType, String initialValue) {
        super(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_TYPE);
        this.fInterfaceKind = interfaceKind;
        this.fVariableKind = variableKind;
        this.fDirection = DVTStringUtil.intern((String)direction);
        this.fInitialValue = initialValue;
        if (direction == null && this.fInterfaceKind != 1 && this.fVariableKind != 65536) {
            this.fDirection = DVTStringUtil.intern((String)"in");
        }
    }

    public RfVariable(String name, int interfaceKind, int variableKind, IRfNamedElement assocType) {
        this(name, interfaceKind, variableKind, null, assocType == null ? null : new DataType(assocType.getName()), null);
        this.transientType = assocType;
    }

    public void init(String name, int interfaceKind, int kind, String direction, DataType dataType, String initialValue) {
        super.init(name, dataType, IRfAssociatedType.AssocTypeKind.ASSOC_TYPE);
        this.fInterfaceKind = interfaceKind;
        this.fVariableKind = kind;
        this.fDirection = direction;
        this.fInitialValue = initialValue;
        if (direction == null && this.fInterfaceKind != 1 && this.fVariableKind != 65536) {
            this.fDirection = DVTStringUtil.intern((String)"in");
        }
    }

    @Override
    protected void resolveTypes(ConfigInfo configInfo, RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage, Set<Class<? extends IRfScopeElement>> skipMemberClasses) {
        super.resolveTypes(configInfo, rfProject, report, onlyUnresolved, otherLanguage, skipMemberClasses);
        this.checkUndeclaredDeferredVariable(rfProject, report);
    }

    private void checkUndeclaredDeferredVariable(RfProject rfProject, boolean report) {
        RfPackage pkg;
        RfPackageBody pkgBody;
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (report && enclosingScope instanceof RfPackage && this.isConstant() && this.getInterfaceKind() == 1 && this.getInitialValue(true) == null && !this.isPredefined() && (pkgBody = (pkg = (RfPackage)enclosingScope).getPackageBody()) != null && pkgBody.getLocalMember(RfVariable.class, this.getName()) == null) {
            RfDefElement declaration = this.getDeclaration();
            ParserPath parserPath = declaration.getParserPath();
            int startOffset = declaration.getStartOffset();
            int endOffset = startOffset + declaration.getName().length();
            rfProject.addSemanticError(2, "MISSING_PACKAGE_BODY_DEFINITION: Deferred constant ''{0}'' is not initialized in package body ''{1}''", this.getLibPkgScope(), startOffset, endOffset, null, declaration.getStartLine(), parserPath, this.getName(), pkg.getName());
        }
    }

    @Override
    protected void resolveHids(ConfigInfo configInfo, boolean triggerError, boolean disableExprEvaluate, Set<Class<? extends IRfScopeElement>> skipMemberClasses) throws BuildCancelException {
        super.resolveHids(configInfo, triggerError, disableExprEvaluate, skipMemberClasses);
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
        if (!(!triggerError || this.isRecordElement() || this.isPredefined() || this.isArgument() || this.isPort() || this.isConstant() || this.isAttribute())) {
            this.checkConstraints(rfProject);
        }
    }

    public void checkConstraints(RfProject rfProject) {
        ConstraintErrorInfo result = this.internalCheckConstraints(rfProject);
        if (result == null) {
            return;
        }
        if (result.hasHidObject()) {
            rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), result.getStartOffset(), result.getEndOffset(), null, result.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, result.getErrorArgs());
        } else {
            rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, this.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, result.getErrorArgs());
        }
    }

    protected ConstraintErrorInfo internalCheckConstraints(RfProject rfProject) {
        List<DataTypeChunk> assocDataTypeName;
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        ArrayList<IndexConstraint> elementConstraints = new ArrayList<IndexConstraint>();
        boolean isScalar = this.transientType instanceof RfType && ((RfType)this.transientType).hasScalarBaseType();
        for (IndexConstraint ic : dataType.getElementConstraints()) {
            if (HidUtils.isOperator((IHidObject)ic.getHidObject())) {
                HidOperator op = (HidOperator)ic.getHidObject();
                if (isScalar && op instanceof RfHidOperator && ((RfHidOperator)op).isLiteralRange()) continue;
                RfHidOperator newOp = STransformer.makeStandInOperator(op.getLHValue(), OptimizedUtils.asList((ListContainer)op.getRHValues(), (boolean)false), op.getOperatorType(), op.getOperatorKind(), op.getOperatorText(), op.getOccurrence(), op.getQualifiers());
                newOp.setOperatorResolvedType(op.getOperatorResolvedType());
                elementConstraints.add(new IndexConstraint((IHidObject)newOp, ic.getConstraintName()));
                continue;
            }
            elementConstraints.add(ic);
        }
        List<DataTypeChunk> list = assocDataTypeName = this.associatedDataType != null ? this.associatedDataType.getTypeName() : null;
        if (assocDataTypeName != null && assocDataTypeName.size() >= 2 && "'subtype".equalsIgnoreCase(assocDataTypeName.get((int)(assocDataTypeName.size() - 1)).name)) {
            if (!elementConstraints.isEmpty()) {
                IHidObject hidObject = ((IndexConstraint)elementConstraints.iterator().next()).getHidObject();
                HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)hidObject);
                int startOffset = HidUtils.getStartOffset((HidOccurrence)firstOccurrence);
                int endOffset = HidUtils.getEndOffset((IHidObject)hidObject, (int)startOffset, (HidOccurrence)firstOccurrence);
                int startLine = HidUtils.getLine((HidOccurrence)firstOccurrence);
                ParserPath parserPath = this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null;
                rfProject.addSemanticError(1, "ILLEGAL_CONSTRAINT: Index constraint not allowed, ''SUBTYPE attribute returns a fully constrained subtype", this.getLibPkgScope(), startOffset, endOffset, null, startLine, parserPath, new Object[0]);
            }
            return null;
        }
        return this.checkConstraints(elementConstraints, new ArrayList<IndexConstraint>(), null, rfProject, new HashSet<IRfNamedElement>());
    }

    private Object[] meldConstraints(List<IndexConstraint> onTheWay, List<IndexConstraint> original) {
        ArrayList<IndexConstraint> new1 = new ArrayList<IndexConstraint>();
        ArrayList<IndexConstraint> new2 = new ArrayList<IndexConstraint>();
        int min = Math.min(original.size(), onTheWay.size());
        int i = 0;
        while (i < Math.max(original.size(), onTheWay.size())) {
            if (i < min) {
                if (onTheWay.get(i).isOpen()) {
                    if (original.get(i).isOpen()) {
                        new2.add(onTheWay.get(i));
                    } else {
                        new2.add(original.get(i));
                    }
                } else if (original.get(i).isOpen()) {
                    new2.add(onTheWay.get(i));
                } else {
                    new1.add(onTheWay.get(i));
                    new2.add(original.get(i));
                }
            } else if (original.size() == min) {
                new1.add(onTheWay.get(i));
            } else {
                new2.add(original.get(i));
            }
            ++i;
        }
        return new Object[]{new1, new2};
    }

    protected ConstraintErrorInfo checkConstraints(List<IndexConstraint> originalConstraints, List<IndexConstraint> onTheWayConstraints, String declarationName, RfProject rfProject, HashSet<IRfNamedElement> visited) {
        RfType lastAssocType = null;
        IRfNamedElement assocTypeElement = this.getAssociatedType();
        if (this instanceof RfAlias && assocTypeElement instanceof RfDummyVariable) {
            assocTypeElement = ((RfDummyVariable)assocTypeElement).getAssociatedType();
        }
        ConstraintHolder holder = null;
        while (assocTypeElement instanceof RfType) {
            RfType assocType;
            if (visited.contains(assocTypeElement)) {
                return null;
            }
            visited.add(assocTypeElement);
            if (!originalConstraints.isEmpty() && !onTheWayConstraints.isEmpty()) {
                Object[] meldConstraints = this.meldConstraints(onTheWayConstraints, originalConstraints);
                onTheWayConstraints = (ArrayList<IndexConstraint>)meldConstraints[0];
                originalConstraints = (List)meldConstraints[1];
            }
            if ((assocType = (RfType)assocTypeElement).isAccess()) {
                return null;
            }
            holder = assocType.getConstraintHolder();
            ConstraintHolder constraintHolder = holder = holder != null ? ConstraintHolder.copyOf(holder) : null;
            if (holder != null) {
                if (assocType instanceof RfRecordType) {
                    List<RfVariable> recordMembers = assocType.getLocalMembers(RfVariable.class);
                    if (recordMembers == null) {
                        return null;
                    }
                    for (RfVariable recordElement : recordMembers) {
                        ArrayList<IndexConstraint> newOriginalConstraints;
                        ConstraintErrorInfo result;
                        String elementName = recordElement.getName();
                        List<IndexConstraint> newOnTheWayConstraints = this.findAssociatedConstraintsByName((List<IndexConstraint>)onTheWayConstraints, elementName, null);
                        if (newOnTheWayConstraints.isEmpty()) {
                            newOnTheWayConstraints = this.findAssociatedConstraintsByName(originalConstraints, elementName, null);
                        }
                        if ((result = recordElement.checkConstraints(newOriginalConstraints = new ArrayList<IndexConstraint>(((RecordConstraintHolder)holder).getRecordConstraints(elementName)), newOnTheWayConstraints, declarationName != null ? declarationName : this.getName(), rfProject, new HashSet<IRfNamedElement>(visited))) == null) continue;
                        if ("MISSING_CONSTRAINT: {0} type ''{1}'' in subtype of ''{2}'' is missing an {3} constraint".equals(result.getErrorPattern())) {
                            if (result.hasHidObject()) {
                                rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), result.getStartOffset(), result.getEndOffset(), null, result.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, "Record", assocType.getName(), declarationName != null ? declarationName : this.getName(), "element");
                                continue;
                            }
                            rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, this.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, "Record", assocType.getName(), declarationName != null ? declarationName : this.getName(), "element");
                            continue;
                        }
                        if (result.hasHidObject()) {
                            rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), result.getStartOffset(), result.getEndOffset(), null, result.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, result.getErrorArgs());
                            continue;
                        }
                        rfProject.addSemanticError(1, result.getErrorPattern(), this.getLibPkgScope(), this.getStartOffset(), this.getStartOffset() + this.getName().length(), null, this.getLine(), this.getDeclaration() != null ? this.getDeclaration().getParserPath() : null, result.getErrorArgs());
                    }
                } else if (holder.isFullyConstrained()) {
                    if (!originalConstraints.isEmpty() && ((IndexConstraint)originalConstraints.get(0)).isOpen()) {
                        originalConstraints.remove(0);
                    }
                    if (!onTheWayConstraints.isEmpty() && ((IndexConstraint)onTheWayConstraints.get(0)).isOpen()) {
                        onTheWayConstraints.remove(0);
                    }
                } else if (!onTheWayConstraints.isEmpty()) {
                    if (assocType instanceof RfListType) {
                        consumeFirst = this.consumeFirst((List<IndexConstraint>)onTheWayConstraints, holder, assocType, declarationName);
                        if (consumeFirst != null) {
                            return consumeFirst;
                        }
                    } else if (assocType instanceof RfScalarType || STransformer.INSTANCE.getBaseType(assocTypeElement, true) instanceof RfScalarType) {
                        firstConstraint = (IndexConstraint)onTheWayConstraints.get(0);
                        if (lastAssocType == null && !this.isRecordElement()) {
                            return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' in subtype of ''{1}''", assocType.getName(), declarationName != null ? declarationName : this.getName());
                        }
                        return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' of {1} ''{2}'' in subtype of ''{3}''", assocType.getName(), this.isRecordElement() ? "record element" : "array", lastAssocType != null ? lastAssocType.getName() : this.getName(), declarationName != null ? declarationName : this.getName());
                    }
                } else if (!originalConstraints.isEmpty()) {
                    if (assocType instanceof RfListType) {
                        consumeFirst = this.consumeFirst(originalConstraints, holder, assocType, declarationName);
                        if (consumeFirst != null) {
                            return consumeFirst;
                        }
                    } else if (assocType instanceof RfScalarType || STransformer.INSTANCE.getBaseType(assocTypeElement, true) instanceof RfScalarType) {
                        firstConstraint = (IndexConstraint)originalConstraints.get(0);
                        if (lastAssocType == null && !this.isRecordElement()) {
                            return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' in subtype of ''{1}''", assocType.getName(), declarationName != null ? declarationName : this.getName());
                        }
                        return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' of {1} ''{2}'' in subtype of ''{3}''", assocType.getName(), this.isRecordElement() ? "record element" : "array", lastAssocType != null ? lastAssocType.getName() : this.getName(), declarationName != null ? declarationName : this.getName());
                    }
                }
            }
            if (holder != null && !holder.isFullyConstrained()) {
                boolean isRecord = assocType instanceof RfRecordType;
                return new ConstraintErrorInfo(null, "MISSING_CONSTRAINT: {0} type ''{1}'' in subtype of ''{2}'' is missing an {3} constraint", isRecord ? "Record" : "Array", assocType.getName(), declarationName != null ? declarationName : this.getName(), isRecord ? "element" : "index");
            }
            DataType assocTypeDataType = assocType.getDataType();
            if (assocTypeDataType != null) {
                List<IndexConstraint> assocElementConstraints = assocTypeDataType.getElementConstraints();
                ArrayList<IndexConstraint> newOnTheWay = new ArrayList<IndexConstraint>();
                int counter = 0;
                int i = 0;
                while (i < assocElementConstraints.size()) {
                    if (assocElementConstraints.get(i).isOpen() && i < onTheWayConstraints.size()) {
                        newOnTheWay.add((IndexConstraint)onTheWayConstraints.get(counter++));
                    } else {
                        newOnTheWay.add(assocElementConstraints.get(i));
                    }
                    ++i;
                }
                i = counter;
                while (i < onTheWayConstraints.size()) {
                    newOnTheWay.add((IndexConstraint)onTheWayConstraints.get(i));
                    ++i;
                }
                onTheWayConstraints = newOnTheWay;
            }
            lastAssocType = assocType;
            assocTypeElement = assocType instanceof RfListType ? ((RfListType)assocType).getAssociatedElementType() : assocType.getResolvedType(true);
            if (assocTypeElement instanceof IRfTypeAliasElement) {
                assocTypeElement = ((IRfTypeAliasElement)assocTypeElement).getTranslatedType();
            }
            if (assocTypeElement instanceof RfType) continue;
            originalConstraints.addAll(onTheWayConstraints);
            if (originalConstraints.isEmpty()) continue;
            if (assocType instanceof RfScalarType || STransformer.INSTANCE.getBaseType(assocTypeElement, true) instanceof RfScalarType) {
                for (IndexConstraint constr : originalConstraints) {
                    if (constr.isNonCompositeValidConstraint()) continue;
                    return new ConstraintErrorInfo(constr.getHidObject(), "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' in subtype of ''{1}'' is already constrained", lastAssocType.getName(), declarationName != null ? declarationName : this.getName());
                }
                continue;
            }
            return new ConstraintErrorInfo(((IndexConstraint)originalConstraints.get(0)).getHidObject(), "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' in subtype of ''{1}'' is already constrained", lastAssocType.getName(), declarationName != null ? declarationName : this.getName());
        }
        return null;
    }

    private ConstraintErrorInfo consumeFirst(List<IndexConstraint> onTheWayConstraints, ConstraintHolder holder, IRfNamedElement assocType, String declarationName) {
        IndexConstraint firstConstraint = onTheWayConstraints.get(0);
        String result = holder.consumeConstraints(firstConstraint);
        if ("already_constrained".equals(result)) {
            if (this.isRecordElement()) {
                return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' of {1} ''{2}'' in subtype of ''{3}'' is already constrained", assocType.getName(), "record element", this.getName(), declarationName != null ? declarationName : this.getName());
            }
            return new ConstraintErrorInfo(firstConstraint.getHidObject(), "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' in subtype of ''{1}'' is already constrained", assocType.getName(), declarationName != null ? declarationName : this.getName());
        }
        if (result != null) {
            if (firstConstraint.isOpen()) {
                return new ConstraintErrorInfo(null, "MISSING_CONSTRAINT: {0} type ''{1}'' in subtype of ''{2}'' is missing an {3} constraint", assocType instanceof RfRecordType ? "Record" : "Array", assocType.getName(), declarationName != null ? declarationName : this.getName(), assocType instanceof RfRecordType ? "element" : "index");
            }
            IndexConstraint constraint = firstConstraint.isVariadicConstraint() ? firstConstraint.getLastPeeledConstraint() : firstConstraint;
            return new ConstraintErrorInfo(constraint.getHidObject(), "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)constraint.getHidObject()), result);
        }
        onTheWayConstraints.remove(0);
        return null;
    }

    private List<IndexConstraint> findAssociatedConstraintsByName(List<IndexConstraint> list, String name, IndexConstraint parentConstraint) {
        Iterator<IndexConstraint> iterator = list.iterator();
        while (iterator.hasNext()) {
            IndexConstraint constraint = iterator.next();
            if (constraint.isVariadicConstraint()) {
                iterator.remove();
                List<IndexConstraint> unpackVariadicConstraint = constraint.unpackVariadicConstraint();
                List<IndexConstraint> resultList = this.findAssociatedConstraintsByName(unpackVariadicConstraint, name, constraint);
                if (resultList != null && !resultList.isEmpty()) {
                    IndexConstraint actualResult = resultList.iterator().next();
                    unpackVariadicConstraint.remove(actualResult);
                    list.addAll(unpackVariadicConstraint);
                    return actualResult.unpackNamedConstraint();
                }
                list.addAll(unpackVariadicConstraint);
                return Collections.emptyList();
            }
            if (!constraint.isNamedConstraint() || name == null || !name.equals(constraint.getConstraintName())) continue;
            if (parentConstraint != null) {
                return Arrays.asList(constraint);
            }
            iterator.remove();
            return constraint.unpackNamedConstraint();
        }
        return Collections.emptyList();
    }

    @Override
    protected void resolveUses(RfProject rfProject, boolean report, boolean onlyUnresolved, boolean otherLanguage) {
        if (this instanceof RfAlias) {
            super.resolveUses(rfProject, report, onlyUnresolved, otherLanguage);
        }
    }

    public String getSignature() {
        String interfaceKindName = this.getInterfaceKindName();
        String rawRange = this.getRange();
        String range = rawRange == null || rawRange.isEmpty() ? "" : (rawRange.toLowerCase().startsWith("range") ? " " + rawRange : "(" + rawRange + ")");
        switch (this.fVariableKind) {
            case 262144: {
                return "record element " + this.getName() + " : " + this.getAssociatedTypeName() + range;
            }
            case 131072: {
                return "shared variable " + this.getName() + " : " + this.getAssociatedTypeName() + range;
            }
            case 524288: {
                return "loop parameter " + this.getName() + " : " + this.getAssociatedTypeName() + range;
            }
            case 16384: {
                if (this.isParameter()) {
                    return String.valueOf(interfaceKindName) + this.getName() + " : " + this.getAssociatedTypeName() + range + this.getConstantInitialValueText(true);
                }
                return String.valueOf(interfaceKindName) + "constant " + this.getName() + " : " + this.getAssociatedTypeName() + range + this.getConstantInitialValueText(true);
            }
            case 32768: {
                return String.valueOf(interfaceKindName) + "signal " + this.getName() + " : " + this.getAssociatedTypeName() + range + this.getConstantInitialValueText(true);
            }
            case 65536: {
                return String.valueOf(interfaceKindName) + "file " + this.getName() + " : " + this.getAssociatedTypeName() + range;
            }
            case 0x100000: {
                return String.valueOf(interfaceKindName) + "attribute " + this.getName() + " : " + this.getAssociatedTypeName() + range + this.getConstantInitialValueText(true);
            }
        }
        return String.valueOf(interfaceKindName) + "variable " + this.getName() + " : " + this.getAssociatedTypeName() + range + this.getConstantInitialValueText(true);
    }

    @Override
    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        if (!ELUtils.isVHDLConstantVariable((IRfNamedElement)this)) {
            return this.getSignature();
        }
        RfProject rfProject = this.getRfProject();
        if (rfProject == null) {
            return this.getSignature();
        }
        ELManager manager = rfProject.getELManager();
        if (manager == null) {
            return this.getSignature();
        }
        IELParamValue paramValue = ELBatchUtils.getParameterOrConstantValue((IRfFieldElement)this, (ELManager)manager, (ElementPath)hierarchyPath);
        if (paramValue == null) {
            return this.getSignature();
        }
        ELParamValuesHidEvaluator evaluator = ELParamValues.create((boolean)true).getHidEvaluator(manager);
        BitVectorContext paramContext = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)this, null, (ELManager)manager);
        String actualValue = paramValue.toNiceString(paramContext, PrefConst.getParamRadix(), useCharLimit, false);
        String rawRange = this.getRange();
        String range = rawRange == null || rawRange.isEmpty() ? "" : (rawRange.toLowerCase().startsWith("range") ? " " + rawRange : "(" + rawRange + ")");
        StringBuilder result = new StringBuilder();
        result.append(this.getInterfaceKindName()).append(!this.isParameter() ? "constant " : "").append(this.getName()).append(" : ").append(this.getAssociatedTypeName()).append(range);
        DVTTooltipInformationUtils.getInstance().appendParamActualValue(result, actualValue, " := ");
        DVTTooltipInformationUtils.getInstance().appendParamDefaultValue(result, this.getConstantInitialValueText(false));
        return result.toString();
    }

    public String getInterfaceKindName() {
        switch (this.getInterfaceKind()) {
            case 2: {
                return "generic ";
            }
            case 8: {
                return "argument ";
            }
        }
        return "";
    }

    public String getInitialValue(boolean forceCompute) {
        return this.fInitialValue;
    }

    public boolean isInput() {
        if (this.getDirection() == null) {
            return false;
        }
        return this.getDirection().equalsIgnoreCase("IN");
    }

    public boolean isPrototype() {
        return this.getEnclosingScope() instanceof RfFunction && ((RfFunction)this.getEnclosingScope()).isPrototype();
    }

    public RfVariable getImplementation() {
        if (this.getInterfaceKind() == 1) {
            return this;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (!(enclosingScope instanceof RfFunction) || !this.isPrototype()) {
            return this;
        }
        RfFunction enclosingScopeImplementation = ((RfFunction)this.getEnclosingScope()).getImplementation();
        IRfNamedElement member = enclosingScopeImplementation.getMember(this.getName(), Collections.singleton(RfVariable.class), null, false, false, true, false, false);
        return member instanceof RfVariable ? (RfVariable)member : this;
    }

    public RfVariable getPrototype() {
        if (this.getInterfaceKind() == 1) {
            return this;
        }
        RfNamedElement enclosingScope = this.getEnclosingScope();
        if (!(enclosingScope instanceof RfFunction) || this.isPrototype()) {
            return this;
        }
        RfFunction enclosingScopePrototype = ((RfFunction)enclosingScope).getPrototype();
        IRfNamedElement member = enclosingScopePrototype.getMember(this.getName(), Collections.singleton(RfVariable.class), null, false, false, true, false, false);
        return member instanceof RfVariable ? (RfVariable)member : this;
    }

    public boolean isLinkage() {
        if (this.getDirection() == null) {
            return false;
        }
        return this.getDirection().equalsIgnoreCase("LINKAGE");
    }

    public boolean isBuffer() {
        if (this.getDirection() == null) {
            return false;
        }
        return this.getDirection().equalsIgnoreCase("BUFFER");
    }

    public boolean isInout() {
        if (this.getDirection() == null) {
            return false;
        }
        return this.getDirection().equalsIgnoreCase("INOUT");
    }

    public boolean isOutput() {
        if (this.getDirection() == null) {
            return false;
        }
        return this.getDirection().equalsIgnoreCase("OUT");
    }

    public boolean isRef() {
        return false;
    }

    public boolean isPort() {
        return this.fInterfaceKind == 4;
    }

    public boolean isArgument() {
        return this.fInterfaceKind == 8;
    }

    public boolean isAttribute() {
        return this.fVariableKind == 0x100000;
    }

    public boolean isEnumElement() {
        return this.fVariableKind == 0x400000;
    }

    public boolean isPhysicalUnit() {
        return this.fVariableKind == 0x800000;
    }

    public boolean isParameter() {
        return this.fInterfaceKind == 2;
    }

    public boolean isInParameterPortList() {
        return this.isParameter();
    }

    public boolean isRegularParameter() {
        return this.isParameter();
    }

    public boolean isTypeParameter() {
        return false;
    }

    public boolean isParameterNoDataType() {
        return false;
    }

    public boolean isConstant() {
        return this.fVariableKind == 16384;
    }

    public boolean isVariable() {
        return this.fVariableKind == 8192;
    }

    public boolean isFile() {
        return this.fVariableKind == 65536;
    }

    public boolean isSharedVariable() {
        return this.fVariableKind == 131072;
    }

    public boolean isSignal() {
        return this.fVariableKind == 32768;
    }

    public boolean isRecordElement() {
        return this.fVariableKind == 262144;
    }

    public boolean isLoopParameter() {
        return this.fVariableKind == 524288;
    }

    public String getDirection() {
        return this.fDirection;
    }

    public int getFieldKind() {
        return this.fVariableKind;
    }

    public int getInterfaceKind() {
        return this.fInterfaceKind;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    @Override
    public Image getImage() {
        if (this.isArgument()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
        }
        if (this.isParameter()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_GENERIC);
        }
        if (this.isConstant()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTANT);
        }
        if (this.isSharedVariable()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
        }
        if (this.isSignal()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
        }
        if (this.isFile()) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FILE);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
    }

    @Override
    public void deepClean() {
        super.deepClean();
        this.fDirection = null;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_VARIABLE: Duplicate variable ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public String getComment() {
        String result = super.getComment();
        if (this.isArgument() && (result == null || result.isEmpty())) {
            result = "";
            RfNamedElement enclosingScope = this.getEnclosingScope();
            String enclosingScopeComment = enclosingScope != null ? enclosingScope.getComment() : null;
            result = DVTUtilsCommon.INSTANCE.getAtParamComment(this.getName(), enclosingScopeComment);
        }
        return result;
    }

    public String getConstantInitialValueText(boolean appendDelimiter) {
        RfVariable deferredConstant;
        RfPackageBody packageBody;
        RfNamedElement enclosingScope;
        String initialValue = this.getInitialValue(false);
        if (initialValue == null && (enclosingScope = this.getEnclosingScope()) instanceof RfPackage && (packageBody = ((RfPackage)enclosingScope).getPackageBody()) != null && (deferredConstant = packageBody.getLocalMember(RfVariable.class, this.getName())) != null && deferredConstant.isConstant()) {
            initialValue = deferredConstant.getInitialValue(false);
        }
        if (initialValue != null) {
            return appendDelimiter ? " := " + initialValue : initialValue;
        }
        return "";
    }

    public List<IHidObject> xGetVHDLElementConstraints() {
        DataType dataType = this.getDataType();
        if (dataType == null) {
            return null;
        }
        return dataType.getElementConstraintHidObjects();
    }

    public HidOperator xMakeInitDeclarationOperator(IHidObject initialValue, HidOperatorOccurrence occurrence) {
        return new RfHidOperator.InitialValueDeclarationStatement(this, initialValue, occurrence, this.getCompileInfo());
    }

    @Override
    public boolean isBefore(int useIndex, int useLine, int useOffset) {
        if (this.getInterfaceKind() != 1 && this.getEnclosingScope() instanceof RfFunction && !this.isPrototype()) {
            RfVariable prototype = this.getPrototype();
            return prototype != this ? prototype.isBefore(useIndex, useLine, useOffset) : super.isBefore(useIndex, useLine, useOffset);
        }
        return super.isBefore(useIndex, useLine, useOffset);
    }

    @Override
    public boolean checkEquals(Object obj) {
        boolean isObjComponentGeneric;
        boolean checkEquals = super.checkEquals(obj);
        if (checkEquals) {
            return true;
        }
        boolean isObjGenericInFunction = obj instanceof RfVariable && ((RfVariable)obj).getInterfaceKind() != 1 && ((RfVariable)obj).getEnclosingScope() instanceof RfFunction;
        boolean isGenericInFunction = this.getInterfaceKind() != 1 && this.getEnclosingScope() instanceof RfFunction;
        boolean isComponentGeneric = this.getInterfaceKind() == 2 && (this.getEnclosingScope() instanceof RfComponent || this.getEnclosingScope() instanceof RfEntity);
        boolean bl = isObjComponentGeneric = obj instanceof RfVariable && ((RfVariable)obj).getInterfaceKind() == 2 && (((RfVariable)obj).getEnclosingScope() instanceof RfComponent || ((RfVariable)obj).getEnclosingScope() instanceof RfEntity);
        if (isGenericInFunction && isObjGenericInFunction && this.getLowerCaseName() != null && this.getLowerCaseName().equals(((RfVariable)obj).getLowerCaseName())) {
            return this.getEnclosingScope().checkEquals(((RfVariable)obj).getEnclosingScope());
        }
        if (isComponentGeneric && isObjComponentGeneric && this.getLowerCaseName() != null && this.getLowerCaseName().equals(((RfVariable)obj).getLowerCaseName())) {
            return this.getEnclosingScope().checkEquals(((RfVariable)obj).getEnclosingScope());
        }
        return checkEquals;
    }

    public boolean isObjectStatic() {
        return this.isConstant() || this.isEnumElement() || this.getEnclosingScope() instanceof IRfDesignElement;
    }

    @Override
    public int getInducedParametricDependencyValue() {
        int kind = this.getFieldKind();
        return kind == 16384 | kind == 0x400000 ? 3 : 1;
    }
}

