/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProject;

public class SearchDependencyContainer {
    private static void collectDependencyList(Collection<? extends IRfNamedElement> namedElements, IRfLibraryElement library, Set<IRfNamedElement> result, boolean checkReferences) {
        try {
            Set visitedElement = Collections.newSetFromMap(new IdentityHashMap());
            for (IRfNamedElement iRfNamedElement : namedElements) {
                Collection references;
                Collection<RfNamedElement> members;
                IRfScopeElement typeContainer;
                if (iRfNamedElement == null || !((typeContainer = iRfNamedElement.getEnclosingScope(RfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES)) instanceof IRfNamedElement) || visitedElement.contains(iRfNamedElement)) continue;
                visitedElement.add(iRfNamedElement);
                String typeName = typeContainer.getName();
                if (iRfNamedElement instanceof RfPackage && (members = ((RfPackage)iRfNamedElement).getMembers(true, false)) != null && !members.isEmpty()) {
                    SearchDependencyContainer.collectDependencyList(members, library, result, checkReferences);
                }
                if ((references = library.getReferences(typeName)) == null) continue;
                for (IRfNamedElement reference : new ArrayList(references)) {
                    RfPackage pkg;
                    List<RfArchitecture> newReferences;
                    if (reference == null || result.contains(reference)) continue;
                    if (reference instanceof RfEntity && (newReferences = ((RfEntity)reference).getArchitectures()) != null) {
                        references.addAll(newReferences);
                    }
                    if (!(reference instanceof RfPackageBody) || (pkg = ((RfPackageBody)reference).getPackage()) == null) continue;
                    references.add(pkg);
                }
                for (IRfNamedElement reference : references) {
                    boolean isInstanceOrModule;
                    if (reference == null || result.contains(reference)) continue;
                    String elementName = iRfNamedElement.getName();
                    boolean isPort = RfSearchUtils.isPortOrParameterElement((IRfNamedElement)iRfNamedElement);
                    boolean bl = isInstanceOrModule = reference instanceof RfArchitecture || reference instanceof IRfInstanceElement;
                    if (!checkReferences || isPort || reference.hasReferenceToIdentifierName(elementName)) {
                        result.add(reference);
                        continue;
                    }
                    if (!isInstanceOrModule && !(reference instanceof RfConfiguration)) continue;
                    result.add(reference);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static Set<IRfNamedElement> getAllDependencies(IRfNamedElement element, RfProject rfProject, boolean searchForType) {
        HashSet<IRfNamedElement> result = new HashSet<IRfNamedElement>();
        if (!searchForType) {
            ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
            elements.add(element);
            Collection<RfLibrary> libraries = rfProject.getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return result;
            }
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                SearchDependencyContainer.collectDependencyList(elements, iRfLibraryElement, result, true);
            }
        } else {
            Collection<RfLibrary> projectLibraries;
            String typeName = element.getName();
            String libraryName = element.getEnclosingLibrary().getName();
            ArrayList<RfLibrary> arrayList = new ArrayList<RfLibrary>();
            IRfScopeElement enclosingScope = element.getEnclosingScope(RfReferencesUtils.CLOSEST_TYPE_CONTAINER_FOR_REFERENCES);
            if (enclosingScope == null) {
                enclosingScope = element.getEnclosingScope();
            }
            if (enclosingScope != null && !(enclosingScope instanceof IRfLibraryElement)) {
                typeName = enclosingScope.getName();
            }
            if ((projectLibraries = rfProject.getLibraries()) == null) {
                return result;
            }
            arrayList.addAll(projectLibraries);
            if (arrayList.isEmpty()) {
                return result;
            }
            for (IRfLibraryElement iRfLibraryElement : arrayList) {
                Collection scopes = iRfLibraryElement.getReferences(typeName);
                if (scopes != null) {
                    result.addAll(scopes);
                }
                if ((scopes = iRfLibraryElement.getReferences(libraryName)) == null) continue;
                result.addAll(scopes);
            }
            if (element.getEnclosingScope() instanceof IRfNamedElement) {
                result.add((IRfNamedElement)element.getEnclosingScope());
            }
            if (enclosingScope instanceof RfPackage) {
                RfPackageBody rfPackageBody = ((RfPackage)enclosingScope).getPackageBody();
                if (rfPackageBody != null) {
                    result.add(rfPackageBody);
                }
            } else if (enclosingScope instanceof RfEntity) {
                List<RfArchitecture> list = ((RfEntity)enclosingScope).getArchitectures();
                if (list != null) {
                    result.addAll(list);
                }
                result.addAll(((RfEntity)enclosingScope).getComponentsWithPrefix(enclosingScope.getName(), 1, false));
            } else if (enclosingScope instanceof RfPackageBody) {
                result.add(((RfPackageBody)enclosingScope).getPackage());
            }
            HashSet<RfEntity> hashSet = new HashSet<RfEntity>();
            for (IRfNamedElement reference : result) {
                if (!(reference instanceof RfArchitecture)) continue;
                hashSet.add(((RfArchitecture)reference).getEntity());
            }
            result.addAll(hashSet);
        }
        return result;
    }
}

