/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScopeUtil;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.VhdlReflectionContributorCommon;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.views.DHHistoryItem;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.vhdldt.model.reflection.views.VhdlQuickViewersUtil;
import ro.amiq.vhdldt.parser.VhdlFileInstancesMap;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VhdlReflectionContributor
extends VhdlReflectionContributorCommon {
    public DVTSourceViewerConfiguration getSourceViewerConfiguration() {
        return new VhdlSourceViewerConfiguration(null);
    }

    public List<? extends IDVTFileInstance> getFileInstances(IProject project, ParserPath path) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        VhdlFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        return fileInstancesMap.getFileInstances(path);
    }

    public HistoryItem createHistoryItem(DVTXmlSaveConfig config, IProject project, HistoryItemType historyItemType) {
        switch (historyItemType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                return VhdlQuickViewersUtil.getInstance().createDHHistoryItem(config, project, true, historyItemType);
            }
            case SHOW_INSTANCES_IN_DESIGN_HIERARCHY: {
                return VhdlQuickViewersUtil.getInstance().createDHHistoryItem(config, project, true, historyItemType);
            }
        }
        return null;
    }

    public HistoryItem getHistoryItemFromBCXmlString(String bcXMLString, IProject project, HistoryItemType historyItemType) {
        if (project == null || bcXMLString == null || bcXMLString.isEmpty()) {
            return null;
        }
        switch (historyItemType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                return DHHistoryItem.parseHistoryItem(project.getName(), bcXMLString, true, historyItemType);
            }
            case SHOW_INSTANCES_IN_DESIGN_HIERARCHY: {
                return DHHistoryItem.parseHistoryItem(project.getName(), bcXMLString, true, historyItemType);
            }
        }
        return null;
    }

    public NamedElementAndConfigInfo getNamedElementAndConfigFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        switch (viewType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (!(historyItem instanceof DHHistoryItem) || rfProject == null) {
                    return null;
                }
                IRfNamedElement namedElement = this.getDHNamedElementFromDVTRfNameTypeScopeHelper(rfProject, ((DHHistoryItem)historyItem).getElementScope());
                return new NamedElementAndConfigInfo(namedElement, null);
            }
        }
        return null;
    }

    public HistoryItemType getHistoryItemTypeFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        switch (viewType) {
            case DESIGN_HIERARCHY_ELABORATION: {
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (!(historyItem instanceof DHHistoryItem) || rfProject == null) {
                    return null;
                }
                return ((DHHistoryItem)historyItem).getHistoryItemType();
            }
        }
        return null;
    }

    public List<? extends DVTRfNameTypeScopeHelper> getDefOfScopeElement(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        return RfScopeUtil.getDefOfScopeElement((IRfScopeElement)element);
    }

    public boolean gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return false;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return false;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null).open();
        return true;
    }

    public boolean gotoElement(IProject project, Object wrapper) {
        RfNamedElementActionHyperlink actionHyperlink;
        block7: {
            Object object;
            block6: {
                block5: {
                    try {
                        if (wrapper instanceof RfTreeElementWrapper) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
                if (object != null && object instanceof RfNamedElement) break block6;
                return false;
            }
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)object, project, (IRegion)new Region(0, 1));
            if (actionHyperlink != null) break block7;
            return false;
        }
        actionHyperlink.open();
        return true;
    }

    public MembersViewInput getMembersInput(IDVTElementWrapper wrapper, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        boolean fHasGUIFilteredMembers = false;
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper.getRfElement();
        if (!(rfElement instanceof RfNamedElement) || rfElement instanceof RfConfiguration) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        if (namedElemet instanceof RfArchitecture) {
            fHasGUIFilteredMembers = this.collectMembers(stringMatcher, namedElemet, elements, defaultLabelProvider, applyContentFilters) || fHasGUIFilteredMembers;
            fHasGUIFilteredMembers = this.collectMembers(stringMatcher, ((RfArchitecture)namedElemet).getEntity(), elements, defaultLabelProvider, applyContentFilters) || fHasGUIFilteredMembers;
            return new MembersViewInput(elements, fHasGUIFilteredMembers);
        }
        if (namedElemet instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)namedElemet)).getAssociatedType() != null) {
            namedElemet = (RfNamedElement)((IRfAssociatedType)((Object)namedElemet)).getAssociatedType();
        }
        fHasGUIFilteredMembers = this.collectMembers(stringMatcher, namedElemet, elements, defaultLabelProvider, applyContentFilters) || fHasGUIFilteredMembers;
        return new MembersViewInput(elements, fHasGUIFilteredMembers);
    }

    private boolean collectMembers(StringMatcher stringMatcher, RfNamedElement namedElement, List<IDVTElementWrapper> elements, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        List<RfEnum> enums;
        boolean hasGUIFilteredMembers = false;
        if (namedElement instanceof RfType && (enums = ((RfType)namedElement).getEnclosingScope().getLocalMembers(RfEnum.class)) != null) {
            Iterator<RfEnum> iterator = enums.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getParentEnumTypeName().equals(namedElement.getName())) continue;
                iterator.remove();
            }
            boolean bl = hasGUIFilteredMembers = this.collectMatchingMembers(elements, enums, stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        }
        if (namedElement instanceof RfPackage) {
            boolean bl = hasGUIFilteredMembers = this.collectMatchingMembers(elements, ((RfPackage)namedElement).getLocalMembers(RfComponent.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        }
        if (namedElement instanceof RfBlock) {
            hasGUIFilteredMembers = this.collectMatchingMembers(elements, ((RfBlock)namedElement).getLocalMembers(RfInstance.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
            hasGUIFilteredMembers = this.collectMatchingMembers(elements, ((RfBlock)namedElement).getLocalMembers(RfPort.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
            boolean bl = hasGUIFilteredMembers = this.collectMatchingMembers(elements, ((RfBlock)namedElement).getLocalMembers(RfComponent.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        }
        if (namedElement instanceof RfComponent) {
            hasGUIFilteredMembers = this.collectMatchingMembers(elements, ((RfComponent)namedElement).getLocalMembers(RfPort.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        }
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfVariable.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfActionBlock.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        hasGUIFilteredMembers = this.collectMatchingMembers(elements, namedElement.getLocalMembers(RfFunction.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        List<RfFunctionsHolder> localFunctionsHolders = namedElement.getLocalMembers(RfFunctionsHolder.class);
        if (localFunctionsHolders != null) {
            for (RfFunctionsHolder holder : localFunctionsHolders) {
                boolean bl = hasGUIFilteredMembers = this.collectMatchingMembers(elements, holder.getLocalMembers(RfFunction.class), stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
            }
        }
        return hasGUIFilteredMembers;
    }

    private boolean collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        boolean hasGUIFilteredMembers = false;
        if (members == null) {
            return hasGUIFilteredMembers;
        }
        for (RfNamedElement rfNamedElement : members) {
            if (rfNamedElement.isPredefined()) continue;
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(rfNamedElement);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)defaultLabelProvider.getText((Object)new RfTreeElementWrapper(rfNamedElement)))) continue;
            if (applyContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)rfNamedElement, () -> defaultLabelProvider.getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredMembers = true;
                continue;
            }
            result.add(elementWrapper);
        }
        return hasGUIFilteredMembers;
    }

    public IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IMembersLabelProvider getMembersLabelProvider() {
        return new TypesViewMembersLabelProvider();
    }

    public IRfNamedElement getElementAtExactCursor() {
        return VhdlQuickViewersUtil.getInstance().getElementAtExactCursor();
    }
}

