/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.QFileCompileInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.vhdldt.model.VhdlModelManager;
import ro.amiq.vhdldt.model.persistence.Persistence;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScopeUtil;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;

public abstract class VhdlReflectionContributorCommon
implements IReflectionContributor {
    public String getNature() {
        return "ro.amiq.vhdldt.VhdlNature";
    }

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.vhdldt.VhdlNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasHits(IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        return false;
    }

    public boolean hasHits(ParserPath file, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        return false;
    }

    public List<QFileCompileInfo> getQFileCompileInfos(IProject project, ParserPath path, boolean recursive, boolean inclComps) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getQFileCompileInfos(path, recursive, inclComps);
    }

    public IRfSingleLangProject makeRfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        return new RfProject(project, rfMixedLangProject);
    }

    public PersistenceBase makePersistence(IProject project) {
        return new Persistence(project);
    }

    public IRfNamedElement getDHTransformedNamedElement(IRfNamedElement element) {
        return this.getDHNamedElementFromDVTRfNameTypeScopeHelper(element.getRfProject(), RfScopeUtil.getDefOfScopeElement((IRfScopeElement)element));
    }

    protected IRfNamedElement getDHNamedElementFromDVTRfNameTypeScopeHelper(IRfSingleLangProject rfProject, List<? extends DVTRfNameTypeScopeHelper> defOfScopeElement) {
        IRfScopeElement scope = RfScopeUtil.getScopeElementOfDef((IRfScopeElement)rfProject, defOfScopeElement);
        if (scope == null || scope instanceof IRfSingleLangProject || scope instanceof RfLibrary || !(scope instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)scope;
    }

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        boolean validContentType;
        if (validateContentType && !(validContentType = RfSearchUtils.validContentType((IProject)file.getProject(), (IDocument)document, (int)offset))) {
            return null;
        }
        return RfUtils.getRfElement(file, document, offset);
    }

    public void clearBacklogElements(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            rfProject.getChangedFilesManager().clear();
        }
    }

    public void addBacklogElement(IProject project, FileCompileInfo info) {
        RfProject rfProjectWithoutRestore = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProjectWithoutRestore == null) {
            return;
        }
        rfProjectWithoutRestore.getChangedFilesManager().addBacklogElements(new LinkedHashSet<FileCompileInfo>(Collections.singleton(info)));
    }

    public Set<FileCompileInfo> getChangedElements(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            return rfProject.getChangedFilesManager().getBacklogElements();
        }
        return null;
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo changedElement, IDocument document, IProject project) {
        VhdlModelManager.getInstance().cbIncrementalBuild(monitor, changedElement, document, true);
    }

    public void restoreInvocationsInfo(IProject project, Map<String, BCFileInstance> buildConfigFiles) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            rfProject.restoreInvocationsInfo(rfProject.getRfProjectContent(), rfProject.getRfCompiledFiles(), buildConfigFiles);
        }
    }
}

