/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic;

import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfNonStandardProblem;
import ro.amiq.vhdldt.parser.VhdlProblem;
import ro.amiq.vhdldt.parser.VhdlUtil;

public class RfSemanticError
extends VhdlProblem
implements Comparable<RfSemanticError> {
    private static final long serialVersionUID = 1L;
    public static final String NON_STANDARD_USE_CLAUSE_PACKAGE = RfSemanticError.getNonStandardMessage(RfNonStandardProblem.USE_CLAUSE_PACKAGE, new Object[0]);
    public static final String UNDECLARED_LIBRARY = "UNDECLARED_LIBRARY: Library ''{0}'' is not declared";
    public static final String UNDECLARED_PACKAGE = "UNDECLARED_PACKAGE: Package ''{0}'' is not declared";
    public static final String DUPLICATE_ENTITY = "DUPLICATE_ENTITY: Duplicate entity ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_ARCHITECTURE = "DUPLICATE_ARCHITECTURE: Duplicate architecture ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_COMPONENT = "DUPLICATE_COMPONENT: Duplicate component ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_CONFIGURATION = "DUPLICATE_CONFIGURATION: Duplicate configuration ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DIFFERENT_BLOCK_SPECIFICATION = "DIFFERENT_BLOCK_SPECIFICATION: Block specification ''{0}'' is different from binding block ''{1}'' of entity ''{2}''";
    public static final String MISSING_BLOCK_ALTERNATIVE = "MISSING_BLOCK_ALTERNATIVE: Conditional block specification ''{0}'' must specify an alternative";
    public static final String DUPLICATE_PACKAGE = "DUPLICATE_PACKAGE: Duplicate package ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_PACKAGE_BODY = "DUPLICATE_PACKAGE_BODY: Duplicate package body ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String MISSING_PACKAGE_BODY = "MISSING_INSTANTIATED_PACKAGE_BODY: Instantiated package ''{0}'' does not have a body";
    public static final String MISSING_PACKAGE_BODY_DEF_1 = "MISSING_PACKAGE_BODY_DEFINITION: Deferred constant ''{0}'' is not initialized in package body ''{1}''";
    public static final String MISSING_PACKAGE_BODY_DEF_2 = "MISSING_PACKAGE_BODY_DEFINITION: Protected type ''{0}'' is not implemented in package body ''{1}''";
    public static final String MISSING_PACKAGE_BODY_DEF_3 = "MISSING_PACKAGE_BODY_DEFINITION: Subprogram ''{0}'' is not implemented in package body ''{1}''";
    public static final String UNDECLARED_TYPE = "UNDECLARED_TYPE: Type ''{0}'' is not declared";
    public static final String DUPLICATE_VARIABLE = "DUPLICATE_VARIABLE: Duplicate variable ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_PORT = "DUPLICATE_PORT: Duplicate port ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_PROCESS = "DUPLICATE_PROCESS: Duplicate process ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_TYPE = "DUPLICATE_TYPE: Duplicate type ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String MISSING_PROTECTED_TYPE_DECL = "MISSING_PROTECTED_TYPE_DECLARATION: Protected type body ''{0}'' does not have corresponding type declaration";
    public static final String ILLEGAL_PROTECTED_TYPE_BODY_DECL = "ILLEGAL_PROTECTED_TYPE_BODY_DECLARATION: Protected type body ''{0}'' not allowed inside package";
    public static final String MISSING_SUBPROGRAM_BODY = "MISSING_SUBPROGRAM_BODY: Subprogram ''{0}'' is not implemented in protected type body ''{1}''";
    public static final String DUPLICATE_INSTANCE = "DUPLICATE_INSTANCE: Duplicate instance ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String NOF_PORT_CONNECTIONS = "NOF_PORT_CONNECTIONS: Expected {0} port connections, found {1}";
    public static final String MISSING_PORT_CONNECTION = "MISSING_PORT_CONNECTION: {0} ''{1}'' of {2} ''{3}'' is missing port connection to {5} ''{4}''";
    public static final String NOT_IN_LIST_OF_PORTS = "NOT_IN_LIST_OF_PORTS: ''{0}'' not in the list of ''{1}'' ports";
    public static final String MULTIPLE_PORT_CONNECTIONS = "MULTIPLE_PORT_CONNECTIONS: Multiple connections to port ''{0}''";
    public static final String UNDRIVEN_INPUT_PORT = "UNDRIVEN_INPUT_PORT: Input port ''{0}'' is not driven";
    public static final String INVALID_IMPLICIT_PORT_MAP_1 = "INVALID_IMPLICIT_PORT_MAP: ''{0}'' component port ''{1}.{2}'' associated with ''{3}'' entity port ''{4}.{2}''";
    public static final String INVALID_IMPLICIT_PORT_MAP_2 = "INVALID_IMPLICIT_PORT_MAP: Type mismatch between ''{0}'' of component port ''{1}.{2}'' and ''{3}'' of entity port ''{4}.{2}''";
    public static final String INVALID_IMPLICIT_PORT_MAP_3 = "INVALID_IMPLICIT_PORT_MAP: {0} {1} port ''{2}.{3}'' not in the list of {4} ''{5}'' ports";
    public static final String INVALID_IMPLICIT_PORT_MAP_4 = "IMPLICIT_PORT_MAP: {0} {1} port ''{2}.{3}'' not in the list of {4} ''{5}'' ports";
    public static final String INVALID_IMPLICIT_GENERIC_MAP = "INVALID_IMPLICIT_GENERIC_MAP: Type mismatch between ''{0}'' of component generic ''{1}.{2}'' and ''{3}'' of entity generic ''{4}.{2}''";
    public static final String INVALID_IMPLICIT_GENERIC_MAP_2 = "INVALID_IMPLICIT_GENERIC_MAP: {0} generic ''{1}.{2}'' not in the list of {3} ''{4}'' generics";
    public static final String DUPLICATE_NAMED_BLOCK = "DUPLICATE_NAMED_BLOCK: Duplicate named block ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    public static final String DUPLICATE_VUNIT = "DUPLICATE_VUNIT: Duplicate vunit ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    public static final String NON_EXISTING_TYPE = "NON_EXISTING_TYPE: Non existing type ''{0}''";
    public static final String UNDECLARED_ENUM = "UNDECLARED_ENUM: Enum type value ''{0}'' is undeclared";
    public static final String UNDECLARED_IDENTIFIER = "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared";
    public static final String UNDECLARED_IDENTIFIER_2 = "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''";
    public static final String UNDECLARED_FUNCTION = "UNEXPECTED_IDENTIFIER: Expecting function ''{0}'' but actual target is not a function";
    public static final String INVALID_ACCESS = "INVALID_ACCESS: Type name ''{0}'' cannot be prefix of selected name ''{1}''";
    public static final String UNEXPECTED_LOOP_LABEL = "UNEXPECTED_LOOP_LABEL: Expecting loop label ''{0}'' but actual target is not a loop";
    public static final String DUPLICATE_WHEN_CHOICE = "DUPLICATE_WHEN_CHOICE: Duplicate case enumerated choice ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String MISSING_ENUM_CHOICE = "MISSING_ENUM_CHOICE: Case enumerated choice ''{0}'' is not defined";
    public static final String MISSING_OTHERS_CHOICE = "MISSING_OTHERS_CHOICE: Case choice ''others'' is not defined";
    public static final String OTHERS_CHOICE_USED = "OTHERS_CHOICE_USED: Case choice ''others'' used for non-explicit enumerated choices ''{0}''";
    public static final String REDUNDANT_OTHERS_CHOICE = "REDUNDANT_OTHERS_CHOICE: Case choice ''others'' is redundant";
    public static final String INCONSISTENT_CHOICES = "INCONSISTENT_CHOICES: Case choices inconsistent number of bits";
    public static final String DEPRECATED_PACKAGE = "DEPRECATED_PACKAGE: Package ''{0}.{1}'' is deprecated, use ''IEEE.NUMERIC_STD'' standard package";
    public static final String IMPLICIT_LIBRARY_ACCESS = "IMPLICIT_LIBRARY_ACCESS: Access to ''{0}'' library is implicit; the library clause can be removed";
    public static final String SENSITIVITY_MISSING = "SENSITIVITY_MISSING: Missing ''{0}'' from sensitivity list";
    public static final String SENSITIVITY_UNUSED = "SENSITIVITY_UNUSED: The process is not sensitive to ''{0}''";
    public static final String DUPLICATE_NAME = "DUPLICATE_NAME: Duplicate name ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    public static final String SIGNAL_NEVER_USED = "SIGNAL_NEVER_USED: Signal ''{0}'' is never used";
    public static final String SIGNAL_NEVER_READ_1 = "SIGNAL_NEVER_READ: Signal ''{0}'' is never read";
    public static final String SIGNAL_NEVER_READ_2 = "SIGNAL_NEVER_READ: Signal ''{0}'' is never read (connected to sub-instance output port)";
    public static final String SIGNAL_NEVER_WRITTEN_1 = "SIGNAL_NEVER_WRITTEN: Signal ''{0}'' is never written";
    public static final String SIGNAL_NEVER_WRITTEN_2 = "SIGNAL_NEVER_WRITTEN: Signal ''{0}'' is never written (connected to sub-instance input port)";
    public static final String SIGNAL_MULTIPLE_DRIVERS = "SIGNAL_MULTIPLE_DRIVERS: Signal ''{0}'' has multiple drivers";
    public static final String PORT_CONNECTION_IN = "PORT_CONNECTION: Input port ''{0}'' connected to an output port";
    public static final String PORT_CONNECTION_OUT = "PORT_CONNECTION: Output port ''{0}'' connected to an input port";
    public static final String PORT_DRIVE_IN = "PORT_CONNECTION: Cannot drive input port ''{0}''";
    public static final String PORT_CONNECTION_INOUT_EXPRESSION = "PORT_CONNECTION: {1} port ''{0}'' connected to a non-signal expression";
    public static final String UNDEFINED_SUBPROGRAM_1 = "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined";
    public static final String UNDEFINED_SUBPROGRAM_2 = "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined for expected return type ''{1}''";
    public static final String UNDEFINED_SUBPROGRAM_3 = "UNDEFINED_SUBPROGRAM: Subprogram ''{0}'' referred in {1} ''{2}'' is undefined";
    public static final String UNDEFINED_SUBPROGRAM_4 = "UNDEFINED_SUBPROGRAM: Subprogram ''{0}'' referred in subprogram instantiation ''{1}'' is not an uninstantiated subprogram.";
    public static final String ILLEGAL_SUBPROGRAM_ALIAS = "ILLEGAL_SUBPROGRAM_ALIAS: Alias ''{0}'' must specify the subprogram signature";
    public static final String SUBPROGRAM_KIND_INSTANTIATION = "SUBPROGRAM_KIND_MISMATCH: Expecting uninstantiated {0}, found {1} instead";
    public static final String AMBIGUOUS_SUBPROGRAM = "AMBIGUOUS_SUBPROGRAM: Subprogram call ''{0}'' is ambiguous; there are {1} visible:\n{2}";
    public static final String AMBIGUOUS_EXPRESSION = "AMBIGUOUS_EXPRESSION: Expression ''{0}'' is ambiguous; there are {1} visible:\n{2}";
    public static final String UNDEFINED_PROCEDURE = "UNDEFINED_PROCEDURE: Unable to find a procedure named ''{0}''";
    public static final String UNDECLARED_ARGUMENT = "UNDECLARED_ARGUMENT: ''{0}'' is not an argument";
    public static final String INCOMPLETE_RECORD_ARGUMENT = "INCOMPLETE_RECORD_ARGUMENT: Formal argument ''{0}'' of type ''{1}'' is missing an association for element ''{2}''";
    public static final String ILLEGAL_EMPTY_RETURN = "ILLEGAL_EMPTY_RETURN: Empty return not allowed in function, expecting ''{0}''";
    public static final String ILLEGAL_RETURN_IN_PROCEDURE = "ILLEGAL_VALUE_RETURN: Value return not allowed in procedure";
    public static final String ILLEGAL_RETURN_IN_PROCESS = "ILLEGAL_RETURN: Return not allowed in process";
    public static final String ILLEGAL_TYPE_REFERENCE = "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable";
    public static final String ILLEGAL_CONSTANT_ASSIGN = "ILLEGAL_CONSTANT_ASSIGN: Constant variable ''{0}'' cannot be assigned";
    public static final String ILLEGAL_ASSIGNMENT = "ILLEGAL_ASSIGNMENT: ''{1}'' cannot be assigned to ''{0}''";
    public static final String ILLEGAL_SIGNAL_ASSIGNMENT1 = "ILLEGAL_SIGNAL_ASSIGNMENT: Target ''{0}'' is not a signal";
    public static final String ILLEGAL_SIGNAL_ASSIGNMENT2 = "ILLEGAL_SIGNAL_ASSIGNMENT: Cannot use signal ''{0}'' as left hand side in variable assignment";
    public static final String ILLEGAL_STATEMENT = "ILLEGAL_STATEMENT: Cannot use non-procedure call ''{0}'' as statement";
    public static final String TYPE_MISMATCH = "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''";
    public static final String INVALID_RANGE = "INVALID_RANGE: Range left bound type ''{0}'' is different from right bound type ''{1}''";
    public static final String SUBTYPE_INDICATION = "SUBTYPE_INDICATION: Subtype indication is allowed only for object aliases (i.e. a constant, a variable, a signal, or a file)";
    public static final String ARRAY_INDEX_SELECT1 = "ARRAY_INDEX_SELECT: Select ''{0}'' contains too few indices ({1}) for array type ''{2}'' of dimensionality {3}";
    public static final String ARRAY_INDEX_SELECT2 = "ARRAY_INDEX_SELECT: Select ''{0}'' contains too many indices ({1}) for array type ''{2}'' of dimensionality {3}";
    public static final String INVALID_CONVERSION_OPERAND = "INVALID_TYPE_CONVERSION: The type conversion operand ''{0}'' cannot be {1}";
    public static final String INCOMPATIBLE_TYPE_CONVERSION = "INVALID_TYPE_CONVERSION: The conversion target type ''{0}'' and operand type ''{1}'' are not closely related";
    public static final String INVALID_LITERAL = "INVALID_LITERAL: String literal has a character ''{0}'' not in the enumeration type ''{1}''";
    public static final String INVALID_CHOICE = "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not a simple name";
    public static final String INVALID_UNDEFINED_CHOICE = "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not an element of record type ''{1}''";
    public static final String INVALID_MULTIPLE_CHOICE = "INVALID_AGGREGATE: Record elements of different types were used in multiple choice ''{0}''";
    public static final String INVALID_OTHERS_CHOICE = "INVALID_AGGREGATE: Others choice in ''{0}'' record aggregate must represent at least one element";
    public static final String INCOMPLETE_RECORD_AGGREGATE_1 = "INCOMPLETE_RECORD_AGGREGATE: Formal ''{0}'' of type ''{1}'' is missing an association for element ''{2}''";
    public static final String INCOMPLETE_RECORD_AGGREGATE_2 = "INCOMPLETE_RECORD_AGGREGATE: Formal of type ''{0}'' is missing an association for element ''{1}''";
    public static final String DUPLICATE_RECORD_ASSOCIATION = "DUPLICATE_RECORD_ASSOCIATION: Formal ''{0}'' is associated more than once";
    public static final String DISCONTINUOUS_ASSOCIATION = "DISCONTINUOUS_ASSOCIATION: Formal ''{0}'' member associations must be consecutive";
    public static final String INVALID_ATTRIBUTE = "INVALID_ATTRIBUTE: Attribute ''{0}'' is not defined for prefix ''{1}''";
    public static final String INVALID_CASE_EXPRESSION = "INVALID_CASE_EXPRESSION: The case expression ''{0}'' must be a discrete type or a one-dimensional character array type";
    public static final String MISSING_CONSTRAINT = "MISSING_CONSTRAINT: {0} type ''{1}'' in subtype of ''{2}'' is missing an {3} constraint";
    public static final String ILLEGAL_CONSTRAINT = "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' in subtype of ''{1}'' is already constrained";
    public static final String ILLEGAL_CONSTRAINT2 = "ILLEGAL_CONSTRAINT: Index constraint not allowed, type ''{0}'' of {1} ''{2}'' in subtype of ''{3}'' is already constrained";
    public static final String ILLEGAL_CONSTRAINT3 = "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' of {1} ''{2}'' in subtype of ''{3}''";
    public static final String ILLEGAL_CONSTRAINT4 = "ILLEGAL_CONSTRAINT: Cannot apply index constraint to non-composite type ''{0}'' in subtype of ''{1}''";
    public static final String ILLEGAL_CONSTRAINT5 = "ILLEGAL_CONSTRAINT: Index constraint not allowed, ''SUBTYPE attribute returns a fully constrained subtype";
    public static final String USAGE_BEFORE_DECLARATION = "USAGE_BEFORE_DECLARATION: {0} ''{1}'' is used before being declared\n    at line {2,number,#######} in {3}";
    public static final String GENERIC_NEVER_USED = "GENERIC_NEVER_USED: Generic ''{0}'' is never used";
    public static final String NON_EXISTING_PARAMETER = "NON_EXISTING_PARAMETER: Non existing parameter ''{0}'' of type ''{1}''";
    public static final String OPEN_PARAMETER_OVERRIDE = "OPEN_PARAMETER_OVERRIDE: Expected default value for parameter ''{0}''";
    public static final String INVALID_AGGREGATE_INCOMPLETE2 = "INVALID_AGGREGATE: Array length is ''{0}''; aggregate length is ''{1}''";
    public static final String UNDEFINED_EXPRESSION = "UNRESOLVED_EXPRESSION: Error resolving expression ''{0}''";
    public static final String CUSTOM_PRAGMA_NESTING_EXCEEDED = "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found";
    public static final String CUSTOM_PRAGMA_UNEXPECTED_END = "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found";
    public static final String CUSTOM_PRAGMA_MISMATCH = "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''";
    public static final String CUSTOM_PRAGMA_NO_END = "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found";
    private boolean fObsolete;
    private String fLibraryName;
    private String fPackageName;

    public RfSemanticError(int severity, String message, int fileIndex, String libraryName, String packageName, int line, String filename) {
        super(severity, filename, null, line, message, fileIndex, -1);
        this.fLibraryName = DVTStringUtil.intern((String)libraryName);
        this.fPackageName = DVTStringUtil.intern((String)packageName);
    }

    public boolean isObsolete() {
        return this.fObsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.fObsolete = obsolete;
    }

    public static int getNonStandardSeverity() {
        String severity = VhdlUtil.getNonStandardSeverity();
        if (severity.equals("*** Error: ")) {
            return 1;
        }
        return 2;
    }

    private static String getNonStandardMessage(RfNonStandardProblem problem, Object ... arguments) {
        return VhdlUtil.getNonStandardMessage(problem, arguments);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RfSemanticError)) {
            return false;
        }
        boolean result = super.equals(obj);
        if (!result) {
            return false;
        }
        result = this.getMessage(false).equals(((RfSemanticError)obj).getMessage(false));
        return result;
    }

    @Override
    public int hashCode() {
        return (String.valueOf(this.getMessage(false)) + "@" + this.getSeverity() + "@" + this.getLine() + "@" + this.getFileName()).hashCode();
    }

    public boolean inLibraryOrPackage(Enum<FullChecksKind> fullChecksKind, Map<String, Set<String>> onlyLibAndPkgNames) {
        if (onlyLibAndPkgNames == null || fullChecksKind == FullChecksKind.FULL) {
            return true;
        }
        Set<String> packages = onlyLibAndPkgNames.get(this.fLibraryName);
        if (packages == null && fullChecksKind == FullChecksKind.LIBS && onlyLibAndPkgNames.containsKey(this.fLibraryName)) {
            return true;
        }
        if (packages == null && fullChecksKind == FullChecksKind.NOT_LIBS && !onlyLibAndPkgNames.containsKey(this.fLibraryName)) {
            return true;
        }
        if (packages == null) {
            return false;
        }
        if (packages.isEmpty()) {
            return true;
        }
        if (fullChecksKind == FullChecksKind.PKGS && packages.contains(this.fPackageName)) {
            return true;
        }
        return fullChecksKind == FullChecksKind.NOT_PKGS && !packages.contains(this.fPackageName);
    }

    @Override
    public int compareTo(RfSemanticError o) {
        int result = this.getLine() - o.getLine();
        if (result == 0) {
            if (this.getOffsetStart() < 0) {
                return -1;
            }
            if (o.getOffsetStart() < 0) {
                return 1;
            }
            result = this.getOffsetStart() - o.getOffsetStart();
            if (result == 0) {
                return this.getMessage(false).compareTo(o.getMessage(false));
            }
            return result;
        }
        return result;
    }
}

