/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidExpressionBuilder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.RfDummyPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfGeneratesContainer;
import ro.amiq.vhdldt.model.reflection.RfImplicitDef;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.parser.VhdlCompileInfo;

public class RfHid
extends Hid {
    private static final long serialVersionUID = 11L;
    private static final Set<String> PREDEFINED_ATTRIBUTES = new HashSet<String>();
    private VhdlCompileInfo compileInfo;
    private boolean isAmbiguousElement;

    static {
        PREDEFINED_ATTRIBUTES.add("base");
        PREDEFINED_ATTRIBUTES.add("left");
        PREDEFINED_ATTRIBUTES.add("right");
        PREDEFINED_ATTRIBUTES.add("high");
        PREDEFINED_ATTRIBUTES.add("low");
        PREDEFINED_ATTRIBUTES.add("ascending");
        PREDEFINED_ATTRIBUTES.add("image");
        PREDEFINED_ATTRIBUTES.add("value");
        PREDEFINED_ATTRIBUTES.add("pos");
        PREDEFINED_ATTRIBUTES.add("val");
        PREDEFINED_ATTRIBUTES.add("succ");
        PREDEFINED_ATTRIBUTES.add("pred");
        PREDEFINED_ATTRIBUTES.add("leftof");
        PREDEFINED_ATTRIBUTES.add("rightof");
        PREDEFINED_ATTRIBUTES.add("subtype");
        PREDEFINED_ATTRIBUTES.add("length");
        PREDEFINED_ATTRIBUTES.add("range");
        PREDEFINED_ATTRIBUTES.add("reverse_range");
        PREDEFINED_ATTRIBUTES.add("element");
        PREDEFINED_ATTRIBUTES.add("delayed");
        PREDEFINED_ATTRIBUTES.add("stable");
        PREDEFINED_ATTRIBUTES.add("quiet");
        PREDEFINED_ATTRIBUTES.add("transaction");
        PREDEFINED_ATTRIBUTES.add("event");
        PREDEFINED_ATTRIBUTES.add("active");
        PREDEFINED_ATTRIBUTES.add("last_event");
        PREDEFINED_ATTRIBUTES.add("last_active");
        PREDEFINED_ATTRIBUTES.add("last_value");
        PREDEFINED_ATTRIBUTES.add("driving");
        PREDEFINED_ATTRIBUTES.add("driving_value");
        PREDEFINED_ATTRIBUTES.add("simple_name");
        PREDEFINED_ATTRIBUTES.add("instance_name");
        PREDEFINED_ATTRIBUTES.add("path_name");
    }

    public RfHid(String name, IRfNamedElement secondaryScope, IRfNamedElement element, HidOccurrence occurrence, VhdlCompileInfo compileInfo) {
        this(name, null, occurrence, compileInfo);
        this.secondaryScope = secondaryScope;
        this.element = element;
    }

    public RfHid(String name, IRfNamedElement secondaryScope, HidOccurrence occurrence, VhdlCompileInfo compileInfo) {
        super(name, secondaryScope, occurrence.getOffset(), occurrence.getLine(), occurrence.getQualifiers());
        this.compileInfo = compileInfo;
    }

    public void resolveHids(ConfigInfo configInfo, boolean force, boolean triggerError, IRfNamedElement initialScope, IRfNamedElement parentScope, Map<String, IRfNamedElement> genericMap, ParserPath parserPath, boolean resolveFormalPart) throws BuildCancelException {
        IRfNamedElement enclosingType;
        HidOccurrence occurrence;
        IRfNamedElement bindingElement;
        boolean hasNonExistingElement;
        boolean argumentAccess;
        IRfNamedElement[] iRfNamedElementArray;
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
        rfProject.checkBuildCanceled();
        RfProject.debugDelay();
        configInfo.addReferenceToIdentifierName(this.name);
        if (this.hasQualifier(HidQualifierCache.POS_ATTRIBUTE_ARGUMENT_HID)) {
            return;
        }
        if (this.hasQualifier(HidQualifierCache.EXTERNAL_PATH_NAME)) {
            return;
        }
        boolean isFormalPart = this.hasOccurrence(HidQualifierCache.FORMAL_PART_QUALIFIER);
        if (!resolveFormalPart && isFormalPart) {
            return;
        }
        if (!resolveFormalPart && this.hasQualifier(HidExpressionBuilder.PATTERN_KEY_QUALIFIER)) {
            return;
        }
        boolean isAttribute = this.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER);
        if (!force && configInfo.incremental) {
            if (this.element != null) {
                if (this.element instanceof RfFunction || this.element instanceof RfFunctionsHolder || this.element instanceof RfAlias || this.element instanceof RfGeneratesContainer) {
                    this.element = null;
                } else if (this.element.hasNoDefs(false) && !this.element.isPredefined()) {
                    this.element = null;
                } else if (this.element instanceof RfVariable && !((RfVariable)this.element).isVariable() && parentScope instanceof RfFunction) {
                    this.element = null;
                } else if (this.element instanceof RfPort && (parentScope instanceof RfInstance || parentScope != this.element.getEnclosingScope())) {
                    this.element = null;
                } else if (this.element instanceof RfInstance || this.element instanceof IRfDesignElement && parentScope instanceof RfInstance) {
                    this.element = null;
                }
            }
        } else {
            this.element = null;
            force = true;
        }
        if (this.isAllKeyword() && this.parentAccess != null && this.parentAccess.getAssociatedType() instanceof RfNamedElement) {
            IRfNamedElement parentAssociatedType = this.parentAccess.getAssociatedType();
            this.element = new RfVariable("anonymous", 1, 8192, parentAssociatedType);
            ((RfVariable)this.element).setEnclosingScope((RfNamedElement)parentAssociatedType, false);
        }
        if (isAttribute && RfHid.isPredefinedAttribute(this.name)) {
            this.element = parentScope instanceof RfScalarType && ((RfScalarType)parentScope).isEnumType() ? new RfDummyPredefinedAttribute(this.name, (RfScalarType)parentScope) : RfDummyElement.ATTRIBUTE_ELEMENT;
        }
        if (this.secondaryScope == null || this.secondaryScope == parentScope) {
            IRfNamedElement[] iRfNamedElementArray2 = new IRfNamedElement[1];
            iRfNamedElementArray = iRfNamedElementArray2;
            iRfNamedElementArray2[0] = parentScope;
        } else {
            IRfNamedElement[] iRfNamedElementArray3 = new IRfNamedElement[2];
            iRfNamedElementArray3[0] = parentScope;
            iRfNamedElementArray = iRfNamedElementArray3;
            iRfNamedElementArray3[1] = this.secondaryScope;
        }
        IRfNamedElement[] scopes = iRfNamedElementArray;
        ArrayList<IRfNamedElement> scopeAndFunctions = null;
        int i = 0;
        while (this.element == null && i < scopes.length) {
            IRfNamedElement scope = scopes[i];
            if (!(scope instanceof RfFunctionsHolder)) {
                if (scopeAndFunctions == null) {
                    scopeAndFunctions = new ArrayList<IRfNamedElement>(scopes.length);
                }
                scopeAndFunctions.add(scope);
            } else {
                List<RfFunction> candidates = ((RfFunctionsHolder)scope).getLocalMembers(RfFunction.class);
                if (candidates != null && !candidates.isEmpty()) {
                    if (scopeAndFunctions == null) {
                        scopeAndFunctions = new ArrayList(candidates.size());
                    }
                    scopeAndFunctions.addAll(candidates);
                }
            }
            ++i;
        }
        boolean bl = argumentAccess = this.parentAccess != null && this.parentAccess.getAccessKind() == 4;
        if (scopeAndFunctions != null) {
            scopes = scopeAndFunctions.toArray(new IRfNamedElement[scopeAndFunctions.size()]);
        }
        int i2 = 0;
        while (i2 < scopes.length) {
            boolean searchLocal;
            List<RfFunctionsHolder> candidates;
            IRfNamedElement updatedScope;
            IRfNamedElement translatedType;
            boolean isFirst;
            if (!resolveFormalPart && this.element != null || resolveFormalPart && this.element != null && !(this.element instanceof RfFunctionsHolder)) break;
            IRfNamedElement scope = scopes[i2];
            boolean bl2 = isFirst = this.secondaryScope != null && i2 != 0 || this.parentAccess == null;
            if (scope instanceof RfAlias && ((RfAlias)scope).isSubprogramInstantiation() && (translatedType = ((RfAlias)scope).getAssociatedType()) != null) {
                scope = translatedType;
            }
            if (scope instanceof IRfTypeAliasElement && !(scope instanceof RfNamedElement) && (translatedType = ((IRfTypeAliasElement)scope).getTranslatedType()) != null) {
                scope = translatedType;
            }
            if (this.parentAccess == null && isFormalPart && scope instanceof RfConfigurationRule && !((RfConfigurationRule)scope).isBlockRule() && (updatedScope = ((RfConfigurationRule)scope).getResolvedDesignMapping(null)) != null) {
                scope = updatedScope;
            }
            RfNamedElement vhdlScope = null;
            if (scope instanceof RfNamedElement) {
                if (scope instanceof RfFunction && parentScope instanceof RfFunctionsHolder) {
                    if (this.parentAccess != null && this.parentAccess.getAccessKind() == 0) {
                        triggerError = false;
                    }
                    if (!argumentAccess && !isFormalPart) {
                        IRfNamedElement assocType = ((RfFunction)scope).getAssociatedType();
                        if (assocType != null) {
                            scope = assocType;
                        }
                    } else if (this.element == null) {
                        this.element = ((RfNamedElement)scope).getLocalMember(RfVariable.class, this.name);
                    }
                }
                HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
                while (scope instanceof RfType && ((RfType)scope).isSubtype()) {
                    if (visited.contains(scope)) break;
                    visited.add(scope);
                    scope = ((RfType)scope).getAssociatedType();
                }
                vhdlScope = (RfNamedElement)scope;
            }
            if (this.element == null) {
                if (this.isExternalName()) {
                    this.element = new RfDummyVariable("", new DataType(""), 1, 32768, null, null);
                } else if (parentScope instanceof RfGeneratesContainer && isFormalPart) {
                    this.element = ((RfGeneratesContainer)parentScope).getGenerateBlockAlternative(this.name);
                } else if (isAttribute && initialScope != null) {
                    this.element = initialScope.semanticGetMember(this.name, (IHid)this, parserPath, null, null, true, false, false);
                } else if (this.hasQualifier(HidQualifierCache.LOOP_LABEL) && scope instanceof RfNamedElement) {
                    this.element = ((RfNamedElement)scope).getSequentialStatementWithPrefix(this.name, 9);
                    if (this.element instanceof RfActionBlock && !((RfActionBlock)this.element).isLoop() && (occurrence = this.getOccurrence()) != null) {
                        line = occurrence.getLine();
                        startOffset = occurrence.getOffset();
                        endOffset = startOffset + this.name.length();
                        rfProject.addSemanticError(1, "UNEXPECTED_LOOP_LABEL: Expecting loop label ''{0}'' but actual target is not a loop", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, null, line, parserPath, scope.getName(), this.name);
                    }
                } else if (this.parentAccess != null && this.parentAccess.getAccessKind() == 0 && vhdlScope == parentScope && parentScope instanceof RfScalarType && ((RfScalarType)parentScope).isEnumType()) {
                    occurrence = this.getOccurrence();
                    if (occurrence != null) {
                        line = occurrence.getLine();
                        startOffset = occurrence.getOffset();
                        endOffset = startOffset + this.name.length();
                        rfProject.addSemanticError(1, "INVALID_ACCESS: Type name ''{0}'' cannot be prefix of selected name ''{1}''", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, null, line, parserPath, scope.getName(), this.name);
                    }
                    RfNamedElement enclosingScope = ((RfScalarType)parentScope).getEnclosingScope();
                    Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
                    String enumTypeName = this.getParentHid().getName();
                    this.element = enclosingScope.semanticGetLocalMember(this.name, (IHid)this, parserPath, null, visited, Collections.singletonList(enumTypeName), false, true, false);
                    if (this.element == null) {
                        return;
                    }
                } else if (vhdlScope instanceof RfInstance && this.parentAccess != null && this.parentAccess.getParentHid() != null && vhdlScope == this.parentAccess.getParentHid().getElement()) {
                    IRfDesignElement instantiated = ((RfInstance)vhdlScope).getVHDLPreElaborationDesign();
                    if (instantiated instanceof RfNamedElement) {
                        this.element = ((RfNamedElement)instantiated).semanticGetMember(this.name, (IHid)this, parserPath, null, null, false, false, false);
                    }
                    RfNamedElement enclosingVhdlScope = vhdlScope.getEnclosingScope();
                    if (this.element == null && enclosingVhdlScope != null && (this.hasOccurrence(HidQualifier.HID_IS_ACTUAL_PART) || this.hasAccesses())) {
                        this.element = enclosingVhdlScope.semanticGetMember(this.name, (IHid)this, parserPath, null, null, true, false, false);
                    }
                } else {
                    if (this.hasQualifier(HidQualifierCache.PORT_MAP_FORMAL_PART) && scope instanceof IRfDesignElement) {
                        this.element = ((IRfDesignElement)scope).getPortWithPrefix(this.name, 9);
                    } else if (this.hasQualifier(HidQualifierCache.GENERIC_MAP_FORMAL_PART) && scope instanceof IRfDesignElement) {
                        this.element = ((IRfDesignElement)scope).getParameterWithPrefix(this.name, 9);
                    }
                    if (this.element == null && scope != null) {
                        if (scope instanceof RfDummyPredefinedAttribute && "POS".equalsIgnoreCase(((RfDummyPredefinedAttribute)scope).getName())) {
                            this.addQualifier(HidQualifierCache.POS_ATTRIBUTE_ARGUMENT_HID);
                            RfScalarType enumType = ((RfDummyPredefinedAttribute)scope).getParentEnumType();
                            Map<String, IRfNamedElement> enumNames = enumType.getEnumNames();
                            for (Map.Entry<String, IRfNamedElement> entry : enumNames.entrySet()) {
                                if (!this.name.equals(entry.getKey())) continue;
                                this.element = entry.getValue();
                            }
                        } else {
                            boolean isNotFirstInSequence = !isFirst || this.hasQualifier(HidQualifierCache.LAST_QUALIFIER);
                            this.element = this.hasOccurrence(HidQualifierCache.TYPE_QUALIFIER) && !this.hasOccurrence(HidQualifierCache.ALIAS_TARGET) && isNotFirstInSequence ? scope.getMember(this.name, DVTRfUtils.MEMBERS_TYPES, null, isFirst, false, false, true, false) : scope.semanticGetMember(this.name, (IHid)this, parserPath, null, null, isFirst, false, false);
                            if (this.element == null && this.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER) && i2 == 0 && !(this.secondaryScope instanceof RfRecordType) && scope instanceof RfNamedElement) {
                                this.element = ((RfNamedElement)scope).semanticGetUsedRecordElement(new HashSet<IRfNamedElement>(), this.name);
                            }
                        }
                    }
                }
            }
            if (vhdlScope != null && (candidates = vhdlScope.getFunctionHoldersWithPrefix(this.name, 1, searchLocal = this.parentAccess != null && this.parentAccess.getAccessKind() == 0 && initialScope != parentScope)) != null && !candidates.isEmpty()) {
                if (this.element instanceof RfFunctionsHolder) {
                    ((RfFunctionsHolder)this.element).addFromFunctionsHolders(candidates);
                } else if (this.element != null) {
                    if (this.hasAccesses() && !this.isMethodCall(false) && !(STransformer.INSTANCE.getBaseType(this.element, true) instanceof RfListType)) {
                        ListContainer accesses = this.getAccesses();
                        boolean hasSelectOrArgValues = false;
                        for (HidAccess access : accesses) {
                            if (!access.isSelect()) continue;
                            hasSelectOrArgValues = true;
                            break;
                        }
                        if (hasSelectOrArgValues) {
                            this.element = RfFunctionsHolder.of(this.name, candidates);
                        } else {
                            this.isAmbiguousElement = true;
                        }
                    } else {
                        this.isAmbiguousElement = true;
                    }
                } else {
                    this.element = RfFunctionsHolder.of(this.name, candidates);
                }
            }
            if (this.element == null && rfProject.getMixedLangProjectParent().isMixed()) {
                if (vhdlScope != null) {
                    this.element = vhdlScope.getOtherLangMemberWithPrefix(this.name, 1);
                }
                if (this.element == null && parentScope instanceof IRfLibraryElement) {
                    IRfLibraryElement vlogLibrary;
                    this.element = rfProject.getMixedLangProjectParent().getDesignWithPrefix((IRfSingleLangProject)rfProject, this.name, 9);
                    if (this.element == null && (vlogLibrary = rfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)rfProject, parentScope.getName(), 9)) != null) {
                        this.element = vlogLibrary.getConfigurationWithPrefix(this.name, 9);
                        if (this.element == null) {
                            this.element = vlogLibrary.getPackageWithPrefix(this.name, 9);
                        }
                    }
                }
                if (this.element == null && this.parentAccess == null) {
                    this.element = rfProject.getMixedLangProjectParent().getLibraryWithPrefix((IRfSingleLangProject)rfProject, this.name, 9);
                }
            }
            genericMap = RfNamedElement.updateGenericMap(vhdlScope, genericMap, configInfo.keepGenericMap);
            ++i2;
        }
        boolean bl3 = hasNonExistingElement = this.element == null || (this.element instanceof RfEntity || this.element instanceof RfLibrary) && this.element.getDeclaration() instanceof RfImplicitDef;
        if (triggerError && hasNonExistingElement) {
            this.reportErrors(rfProject, parserPath, initialScope, parentScope);
        } else if (this.element instanceof IRfPackageElement) {
            ELManager manager;
            ELManager eLManager = manager = configInfo.getElabContext() != null ? configInfo.getElabContext().getManager() : null;
            if (manager != null && manager.getSemanticEnableRaw() == 3) {
                ((IRfPackageElement)this.element).elaborateConstants(manager);
            }
        }
        if (parentScope instanceof RfConfigurationRule && !((RfConfigurationRule)parentScope).isBlockRule() && this.element instanceof RfArchitecture && (bindingElement = ((RfConfigurationRule)parentScope).getResolvedDesignMapping(null)) instanceof RfArchitecture && bindingElement != this.element) {
            this.element = null;
            HidOccurrence occurrence2 = this.getOccurrence();
            if (occurrence2 != null) {
                int line = occurrence2.getLine();
                int startOffset = occurrence2.getOffset();
                int endOffset = startOffset + this.name.length();
                rfProject.addSemanticError(1, "DIFFERENT_BLOCK_SPECIFICATION: Block specification ''{0}'' is different from binding block ''{1}'' of entity ''{2}''", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, null, line, parserPath, this.name, bindingElement.getName(), ((RfArchitecture)bindingElement).getEntityName());
            }
        }
        if (parentScope instanceof RfConfigurationRule && ((RfConfigurationRule)parentScope).isBlockRule() && this.element instanceof RfGeneratesContainer && !this.hasAccesses() && (occurrence = this.getOccurrence()) != null) {
            int line = occurrence.getLine();
            int startOffset = occurrence.getOffset();
            int endOffset = startOffset + this.name.length();
            rfProject.addSemanticError(1, "MISSING_BLOCK_ALTERNATIVE: Conditional block specification ''{0}'' must specify an alternative", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, null, line, parserPath, this.name);
        }
        if (this.element instanceof RfNamedElement && (enclosingType = ((RfNamedElement)this.element).getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) != null) {
            configInfo.addReference(enclosingType.getName());
        }
        this.resolveDeepElements(configInfo, force, !this.isAmbiguousElement() && triggerError, initialScope, genericMap, parserPath, parentScope, resolveFormalPart);
    }

    private void resolveDeepElements(ConfigInfo configInfo, boolean force, boolean triggerError, IRfNamedElement initialScope, Map<String, IRfNamedElement> genericMap, ParserPath parserPath, IRfNamedElement parentScope, boolean resolveFormalPart) throws BuildCancelException {
        RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
        rfProject.checkBuildCanceled();
        if (!this.hasAccesses()) {
            return;
        }
        boolean hasNonExistingElement = this.element == null || (this.element instanceof RfEntity || this.element instanceof RfLibrary) && this.element.getDeclaration() instanceof RfImplicitDef;
        List accesses = OptimizedUtils.asList((ListContainer)this.accessesContainer, (boolean)true);
        for (HidAccess hidAccess : accesses) {
            RfHidAccess access = (RfHidAccess)hidAccess;
            if (hasNonExistingElement && (access.getAccessKind() == 0 || access.getAccessKind() == 5)) continue;
            access.resolveType(configInfo, force, triggerError, initialScope, this.element, genericMap, false, false, resolveFormalPart, parserPath);
        }
        if (!this.hasAccesses()) {
            this.accessesContainer = null;
        }
    }

    public void reportErrors(RfProject rfProject, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement parentScope) {
        IRfNamedElement resolvedConfigType;
        IRfNamedElement assocType;
        RfNamedElement entity;
        HidOccurrence occurrence = this.getOccurrence();
        if (occurrence == null) {
            return;
        }
        boolean isPotentialMethodCall = this.isPotentialMethodCall();
        boolean isSignatureType = this.hasQualifier(HidQualifierCache.SIGNATURE_TYPE_QUALIFIER);
        if (this.hasOccurrence(HidQualifierCache.TYPE_QUALIFIER) && !isPotentialMethodCall && !isSignatureType) {
            return;
        }
        if (this.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER)) {
            return;
        }
        if (this.hasQualifier(HidQualifierCache.FORMAL_PART_QUALIFIER) && initialScope instanceof RfConfigurationRule && ((RfConfigurationRule)initialScope).isIncrementalConfiguration()) {
            return;
        }
        if (initialScope instanceof RfConfiguration && ((entity = ((RfConfiguration)initialScope).getEnclosingScope()) == null || entity instanceof RfEntity && entity.isImplicit()) && ((assocType = ((RfConfiguration)initialScope).getAssociatedType()) == null || assocType instanceof RfAssociatedType.RfUnresolvedInfo)) {
            return;
        }
        if (initialScope instanceof RfConfigurationRule && ((resolvedConfigType = ((RfConfigurationRule)initialScope).getResolvedDesignMapping(null)) == null || resolvedConfigType instanceof RfAssociatedType.RfUnresolvedInfo)) {
            return;
        }
        boolean isAttribute = this.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER);
        int line = occurrence.getLine();
        int startOffset = occurrence.getOffset();
        int endOffset = startOffset + this.name.length();
        IRfNamedElement parentElement = null;
        HashMap<String, Object> attributes = new HashMap<String, Object>(4);
        attributes.put("QUICKFIX_ELEMENT_NAME", this.name);
        attributes.put("QUICKFIX_KIND", isPotentialMethodCall ? 14 : 1);
        if (this.parentAccess != null && this.parentAccess.getParentHid() != null && (parentElement = this.parentAccess.getParentHid().getElement()) != null && !isAttribute) {
            attributes.put("QUICKFIX_HIERARCHICAL_ID", true);
            attributes.put("QUICKFIX_SCOPE_ELEMENT_PATH", RfElementPath.path((IRfNamedElement)parentScope).toString());
            if (isPotentialMethodCall) {
                rfProject.addSemanticError(1, "UNEXPECTED_IDENTIFIER: Expecting function ''{0}'' but actual target is not a function", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, attributes, line, parserPath, this.name);
            } else {
                rfProject.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, attributes, line, parserPath, this.name, parentElement);
            }
        } else {
            String errorMessage = this.hasQualifier(HidQualifierCache.COMPONENT_TYPE) ? "UNDECLARED_COMPONENT: Component ''{0}'' is not declared" : "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared";
            rfProject.addSemanticError(1, errorMessage, initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, attributes, line, parserPath, this.name);
        }
    }

    public static boolean isPredefinedAttribute(String name) {
        if (name == null) {
            return true;
        }
        return PREDEFINED_ATTRIBUTES.contains(name.toLowerCase());
    }

    protected boolean useExistingAccess(HidAccess access) {
        return super.useExistingAccess(access) || !access.isSelect();
    }

    public IRfNamedElement getDesignSignal(DesignUtils.DesignRequest request, ELInstance closestAncestorInstance, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        RfHid resolvedHid;
        boolean isPossiblyGeneric;
        IRfNamedElement signal = HidUtils.getResolvedElement((IHidObject)this);
        HidAccess dotAccess = this.getFirstDotHidAccess();
        if (dotAccess == null) {
            IRfPortElement boundPort;
            if (signal == null && dummyPortMap != null && (this.parentAccess != null && this.parentAccess.getAccessKind() == 4 || this.hasOccurrence(HidQualifierCache.FORMAL_PART_QUALIFIER))) {
                return DesignUtils.getPortByName((String)this.name, (DesignUtils.DesignRequest)request, dummyPortMap);
            }
            if (signal instanceof IRfPortElement && signal.getEnclosingScope() instanceof RfComponent && (boundPort = DesignUtils.getPortByName((String)this.name, (DesignUtils.DesignRequest)request, dummyPortMap)) != null) {
                return boundPort;
            }
            return signal instanceof IRfAssociatedTypeElement ? signal : null;
        }
        RfHid signalHid = this;
        Hid firstHid = dotAccess.getParentHid();
        IRfNamedElement firstSegment = HidUtils.getResolvedElement((IHidObject)firstHid);
        Map genericMap = closestAncestorInstance != null ? closestAncestorInstance.getDescription().getLocalResolvedGenericMap(false) : null;
        boolean bl = isPossiblyGeneric = firstSegment instanceof RfPort && HidUtils.getResolvedElement((IHidObject)this) == null && genericMap != null;
        if (isPossiblyGeneric && (resolvedHid = RfHid.resolveHidWithActualType(this, (RfHidAccess)dotAccess, closestAncestorInstance, genericMap)) != null) {
            signalHid = resolvedHid;
        }
        return HierarchicalElement.upwardsOf((Hid)signalHid, (IHidObject)dotAccess.getParentHid(), (boolean)true, (int)1);
    }

    private static final RfHid resolveHidWithActualType(RfHid originalHid, RfHidAccess dotAccess, ELInstance searchInstance, Map<String, IRfNamedElement> genericMap) {
        if (dotAccess == null || dotAccess.getParentHid() == null || searchInstance == null || genericMap == null) {
            return null;
        }
        RfHid copyOfOriginalHid = originalHid.upwardsCopy(false);
        RfHidAccess copyDotAccess = (RfHidAccess)copyOfOriginalHid.getFirstDotHidAccess();
        IRfNamedElement startElement = HidUtils.getResolvedElement((IHidObject)dotAccess.getParentHid());
        if (!(startElement instanceof RfNamedElement)) {
            return null;
        }
        Hid copyDotParentHid = copyDotAccess.getParentHid();
        if (copyDotParentHid == null) {
            return null;
        }
        copyDotParentHid.setElement(startElement);
        try {
            ConfigInfo configInfo = new ConfigInfo(true, ((RfNamedElement)startElement).getRfProject(), null, true, null);
            copyDotAccess.resolveType(configInfo, false, false, null, startElement, genericMap, false, true, false, null);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return HidUtils.isHid((IHidObject)copyOfOriginalHid) && HidUtils.isResolved((IHidObject)copyOfOriginalHid) ? copyOfOriginalHid : null;
    }

    public boolean isMethodCall(boolean stopAtAlias) {
        IRfNamedElement basicElement;
        IRfNamedElement iRfNamedElement = basicElement = !stopAtAlias && this.element instanceof IRfTypeAliasElement ? ((IRfTypeAliasElement)this.element).getTranslatedType() : this.element;
        return basicElement instanceof RfFunctionsHolder || basicElement instanceof IRfMethodElement;
    }

    public boolean isAllKeyword() {
        return "all".equalsIgnoreCase(this.getName());
    }

    public boolean isExternalName() {
        return "<<".equals(this.name);
    }

    public int getUsageIndex() {
        return this.compileInfo == null ? -1 : this.compileInfo.getCompileIndex();
    }

    public int getInvocNumber() {
        return this.compileInfo == null ? -1 : this.compileInfo.getInvocNumber();
    }

    public Map<IRfNamedElement, List<? extends IRfFieldElement>> getMethodsWithArguments() {
        if (!this.isMethodCall(false)) {
            return null;
        }
        IRfNamedElement methodElement = this.element;
        if (methodElement instanceof IRfTypeAliasElement) {
            methodElement = ((IRfTypeAliasElement)methodElement).getTranslatedType();
        }
        if (methodElement instanceof IRfMethodElement) {
            LinkedHashMap<IRfNamedElement, List<? extends IRfFieldElement>> result = new LinkedHashMap<IRfNamedElement, List<? extends IRfFieldElement>>(2);
            result.put(methodElement, ((IRfMethodElement)methodElement).getArguments());
            return result;
        }
        if (!(methodElement instanceof RfFunctionsHolder)) {
            return null;
        }
        List<RfFunction> functions = ((RfFunctionsHolder)methodElement).getLocalMembers(RfFunction.class);
        if (functions == null || functions.isEmpty()) {
            return null;
        }
        LinkedHashMap<IRfNamedElement, List<? extends IRfFieldElement>> result = new LinkedHashMap<IRfNamedElement, List<? extends IRfFieldElement>>(4);
        for (RfFunction candidate : functions) {
            result.put(candidate, candidate.getArguments());
        }
        return result;
    }

    protected ELParamValueScope internalEvaluateFunctionCall(IRfMethodElement element, IHidEvaluator evaluator, IHidEvaluator argumentsEvaluator, IHidEvaluationGuardian guardian) {
        return super.internalEvaluateFunctionCall((IRfMethodElement)(element instanceof RfFunction ? ((RfFunction)element).getImplementation() : element), evaluator, argumentsEvaluator, guardian);
    }

    public boolean isAmbiguousElement() {
        return this.isAmbiguousElement;
    }

    public RfHid shallowCopy(boolean addResolved) {
        RfHid result = new RfHid(this.name, this.secondaryScope, this.getOccurrence(), this.compileInfo);
        result.qualifierSet = this.qualifierSet;
        if (addResolved) {
            result.element = this.element;
        }
        return result;
    }

    public RfHid deepCopy() {
        RfHid result = this.shallowCopy(false);
        if (this.hasAccesses()) {
            ListContainer accesses = this.getAccesses();
            for (HidAccess access : accesses) {
                result.addAccess(access.deepCopy());
            }
        }
        return result;
    }

    public RfHid upwardsCopy(boolean addResolved) {
        RfHid result = this.shallowCopy(addResolved);
        if (this.parentAccess != null) {
            result.parentAccess = this.parentAccess.upwardsCopy(addResolved);
            result.parentAccess.addHid((Hid)result);
        }
        return result;
    }

    public IHidBuilders getHidBuilders() {
        return STransformer.BUILDERS;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (persistence != null && persistence.isSaveCanceled()) {
            throw new PersistenceCancelException();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!(in instanceof PersistenceInputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceInputStream)in).getPersistence();
        if (persistence != null) {
            persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readStart((Object)this);
        }
        if (persistence != null && persistence.isRestoreCanceled()) {
            throw new PersistenceCancelException();
        }
        in.defaultReadObject();
        if (persistence != null) {
            persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readEnd((Object)this);
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }
}

