/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.RfDummyPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfGeneratesContainer;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;

public class RfHidAccess
extends HidAccess
implements IHidAccessArgs {
    private static final long serialVersionUID = 6L;
    public static final String TO_STRING_METHOD_NAME = "to_string";
    public static final String DEALLOCATE_METHOD_NAME = "deallocate";
    public static final String MAXIMUM_METHOD_NAME = "maximum";
    public static final String MINIMUM_METHOD_NAME = "minimum";
    private static final String risingEdge = "rising_edge@a:std_ulogic@r:BOOLEAN@b:false";
    private static final String fallingEdge = "falling_edge@a:std_ulogic@r:BOOLEAN@b:false";
    private static final Set<String> SUPPORTED_INTRP_FUNCTIONS = new HashSet<String>();
    private static final String toBitFromStdLogic = "to_bit@a:std_ulogic,bit@r:bit@b:false";
    private static final String toBitVectorFromStdLogic = "to_bitvector@a:std_logic_vector,bit@r:bit_vector@b:false";
    private static final String toBitVectorFromStdULogic = "to_bitvector@a:std_ulogic_vector,bit@r:bit_vector@b:false";
    private static final String toStdLogicFromBitVector = "to_stdlogicvector@a:bit_vector@r:std_logic_vector@b:false";
    private static final String toStdLogicFromStdULogic = "to_stdlogicvector@a:std_ulogic_vector@r:std_logic_vector@b:false";
    private static final String toStdULogicFromBit = "to_stdulogic@a:bit@r:std_ulogic@b:false";
    private static final String toStdULogicFromBitVector = "to_stdulogicvector@a:bit_vector@r:std_ulogic_vector@b:false";
    private static final String toStdULogicFromStdLogic = "to_stdulogicvector@a:std_logic_vector@r:std_ulogic_vector@b:false";
    private static final String maximumBool = "maximum@a:boolean,boolean@r:boolean@b:false";
    private static final String maximumBit = "maximum@a:bit,bit@r:bit@b:false";
    private static final String maximumChar = "maximum@a:character,character@r:character@b:false";
    private static final String maximumSev = "maximum@a:severity_level,severity_level@r:severity_level@b:false";
    private static final String maximumInt = "maximum@a:integer,integer@r:integer@b:false";
    private static final String maximumReal = "maximum@a:real,real@r:real@b:false";
    private static final String maximumStr = "maximum@a:string,string@r:string@b:false";
    private static final String maximumFOK = "maximum@a:file_open_kind,file_open_kind@r:file_open_kind@b:false";
    private static final String maximumFOS = "maximum@a:file_open_status,file_open_status@r:file_open_status@b:false";
    private static final String minimumBool = "minimum@a:boolean,boolean@r:boolean@b:false";
    private static final String minimumBit = "minimum@a:bit,bit@r:bit@b:false";
    private static final String minimumChar = "minimum@a:character,character@r:character@b:false";
    private static final String minimumSev = "minimum@a:severity_level,severity_level@r:severity_level@b:false";
    private static final String minimumInt = "minimum@a:integer,integer@r:integer@b:false";
    private static final String minimumReal = "minimum@a:real,real@r:real@b:false";
    private static final String minimumStr = "minimum@a:string,string@r:string@b:false";
    private static final String minimumFOK = "minimum@a:file_open_kind,file_open_kind@r:file_open_kind@b:false";
    private static final String minimumFOS = "minimum@a:file_open_status,file_open_status@r:file_open_status@b:false";
    private static final String convIntegerFromUnsigned = "conv_integer@a:unsigned@r:integer@b:false";
    private static final String convUnsignedFromInteger = "conv_unsigned@a:integer,integer@r:unsigned@b:false";
    private static final String convIntegerFromStdULogic = "conv_integer@a:std_ulogic@r:small_int@b:false";
    private static final String convUnsignedFromStdULogic = "conv_unsigned@a:std_ulogic,integer@r:unsigned@b:false";
    private static final Set<String> SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS;
    private static final Set<HidFlatteningOption> SELECTS_HID_FLATTENING;
    private transient List<DataTypeChunk> dataTypeName;

    static {
        SUPPORTED_INTRP_FUNCTIONS.add(risingEdge);
        SUPPORTED_INTRP_FUNCTIONS.add(fallingEdge);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS = new HashSet<String>();
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumBool);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumBool);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumBit);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumBit);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumChar);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumChar);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumSev);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumSev);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumInt);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumInt);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumStr);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumStr);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumFOS);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumFOS);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumFOK);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumFOK);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(maximumReal);
        SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.add(minimumReal);
        SELECTS_HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS);
    }

    public RfHidAccess(int accessKind, List<IHidObject> selects) {
        super(accessKind, selects);
    }

    public RfHidAccess(int accessKind, ListContainer<IHidObject> selectsContainer) {
        super(accessKind, selectsContainer);
    }

    public void resolveType(ConfigInfo configInfo, boolean force, boolean triggerError, IRfNamedElement initialScope, IRfNamedElement parentElement, Map<String, IRfNamedElement> genericMap, boolean stopAtSelect, boolean resolveIfNotCached, boolean resolveFormalPart, ParserPath parserPath) throws BuildCancelException {
        boolean isAttribute;
        RfProject rfProject;
        block45: {
            block47: {
                boolean isExternalName;
                block46: {
                    block44: {
                        boolean isAttributeOfType;
                        IRfNamedElement assocType;
                        rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
                        rfProject.checkBuildCanceled();
                        RfProject.debugDelay();
                        if (parentElement instanceof IRfInstanceElement && (assocType = this.getResolvedType((IRfAssociatedTypeElement)parentElement, resolveIfNotCached)) == null) {
                            return;
                        }
                        boolean bl = isExternalName = this.parentHid instanceof RfHid && ((RfHid)this.parentHid).isExternalName();
                        if (parentElement instanceof RfDummyVariable && initialScope instanceof RfNamedElement && isExternalName && (parentElement = this.computeExternalNameType((RfNamedElement)initialScope)) == null) {
                            return;
                        }
                        if (this.isSelect() && !isExternalName) {
                            IRfNamedElement type = null;
                            if (parentElement instanceof RfType || parentElement instanceof RfFunctionsHolder || parentElement instanceof RfEntity || parentElement instanceof RfGeneratesContainer) {
                                type = parentElement;
                            } else if (parentElement instanceof IRfAssociatedTypeElement) {
                                type = this.getResolvedType((IRfAssociatedTypeElement)parentElement, resolveIfNotCached);
                            } else if (parentElement instanceof RfDummyElement) {
                                type = parentElement;
                            }
                            for (IHidObject select : this.selectsContainer) {
                                if (type == null) break;
                                Set hids = HidUtils.flattenToHids((IHidObject)select, SELECTS_HID_FLATTENING);
                                for (IHid hidIn : hids) {
                                    RfHid hid;
                                    if (!HidUtils.isHid((IHidObject)hidIn) || (hid = (RfHid)hidIn) == this.parentHid || !hid.hasOccurrence(HidQualifierCache.FORMAL_PART_QUALIFIER) && !(type instanceof RfDummyPredefinedAttribute) || hid.getElement() != null) continue;
                                    boolean hidIsActualPartInMethodCall = hid.hasOccurrence(HidQualifierCache.ACTUAL_PART_QUALIFIER) && this.isMethodCall(false);
                                    IRfNamedElement hidMainScope = hidIsActualPartInMethodCall ? initialScope : type;
                                    IRfNamedElement hidSecondaryScope = hidIsActualPartInMethodCall ? null : initialScope;
                                    RfHid ancestorHid = (RfHid)hid.getAncestorHid();
                                    ancestorHid.setSecondaryScope(hidSecondaryScope);
                                    ancestorHid.resolveHids(configInfo, true, triggerError, initialScope, hidMainScope, genericMap, parserPath, true);
                                }
                                if (type instanceof IRfListType) {
                                    type = this.getResolvedType((IRfAssociatedTypeElement)type, resolveIfNotCached);
                                }
                                if (!(type instanceof IRfTypeAliasElement)) continue;
                                type = ((IRfTypeAliasElement)type).getTranslatedType();
                            }
                        }
                        if (!force && configInfo.incremental) {
                            if (this.associatedType != null && (this.associatedType.hasNoDefs(false) && !this.associatedType.isPredefined() || !this.validAssociatedType(parentElement))) {
                                this.associatedType = null;
                                this.dataTypeName = null;
                                force = true;
                            }
                        } else {
                            this.associatedType = null;
                            this.dataTypeName = null;
                            force = configInfo.incremental;
                        }
                        isAttribute = this.accessKind == 5;
                        boolean bl2 = isAttributeOfType = isAttribute && !(parentElement instanceof RfFunctionsHolder) && !(parentElement instanceof IRfMethodElement) && !(parentElement instanceof IRfFieldElement);
                        if (!isAttributeOfType) break block44;
                        this.associatedType = parentElement;
                        break block45;
                    }
                    if (!(parentElement instanceof IRfLibraryElement) && !(parentElement instanceof IRfPackageElement) && !(parentElement instanceof RfType) && !(parentElement instanceof RfFunctionsHolder) && (!(parentElement instanceof RfAlias) || !(((RfAlias)parentElement).getTranslatedType() instanceof RfType))) break block46;
                    this.associatedType = parentElement;
                    break block45;
                }
                if (this.associatedType != null && this.associatedType != parentElement || !(parentElement instanceof IRfAssociatedType)) break block47;
                long time = System.currentTimeMillis();
                DataType dataType = ((IRfAssociatedType)parentElement).getDataType();
                this.dataTypeName = dataType == null ? null : dataType.getTypeName();
                this.associatedType = this.getResolvedType((IRfAssociatedType)parentElement, resolveIfNotCached);
                genericMap = RfNamedElement.updateGenericMap(this.associatedType, genericMap, configInfo.keepGenericMap);
                if (parentElement instanceof RfAlias && this.associatedType instanceof RfVariable && !(this.associatedType instanceof IRfTypeAliasElement)) {
                    this.associatedType = this.getResolvedType((RfVariable)this.associatedType, resolveIfNotCached);
                    genericMap = RfNamedElement.updateGenericMap(this.associatedType, genericMap, configInfo.keepGenericMap);
                }
                int selectIndex = 0;
                if (isExternalName) {
                    ++selectIndex;
                }
                int selectsSize = this.selectsContainer == null ? 0 : this.selectsContainer.size();
                HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
                while (this.associatedType instanceof RfType || this.associatedType instanceof IRfTypeAliasElement) {
                    block49: {
                        block52: {
                            block51: {
                                block50: {
                                    boolean hasFollowing;
                                    block48: {
                                        boolean bl = hasFollowing = selectIndex < selectsSize || this.getAccessKind() == 0;
                                        if (!(this.associatedType instanceof RfType) || !((RfType)this.associatedType).isSubtype()) break block48;
                                        if (visited.contains(this.associatedType)) break;
                                        visited.add(this.associatedType);
                                        this.associatedType = this.getResolvedType((RfType)this.associatedType, resolveIfNotCached);
                                        break block49;
                                    }
                                    if (!hasFollowing || !(this.associatedType instanceof RfType) || !((RfType)this.associatedType).isAccess()) break block50;
                                    if (visited.contains(this.associatedType)) break;
                                    visited.add(this.associatedType);
                                    this.associatedType = this.getResolvedType((RfType)this.associatedType, resolveIfNotCached);
                                    break block49;
                                }
                                if (!(this.associatedType instanceof IRfTypeAliasElement)) break block51;
                                if (visited.contains(this.associatedType)) break;
                                visited.add(this.associatedType);
                                ((IRfTypeAliasElement)this.associatedType).getResolvedType(true);
                                this.associatedType = ((IRfTypeAliasElement)this.associatedType).getTranslatedType();
                                genericMap = RfNamedElement.updateGenericMap(this.associatedType, genericMap, configInfo.keepGenericMap);
                                if (this.associatedType instanceof RfVariable && !(this.associatedType instanceof IRfTypeAliasElement)) {
                                    this.associatedType = this.getResolvedType((RfVariable)this.associatedType, resolveIfNotCached);
                                    genericMap = RfNamedElement.updateGenericMap(this.associatedType, genericMap, configInfo.keepGenericMap);
                                }
                                break block49;
                            }
                            if (!(this.associatedType instanceof RfType) || !((RfType)this.associatedType).isGeneric()) break block52;
                            if (visited.contains(this.associatedType)) break;
                            visited.add(this.associatedType);
                            IRfNamedElement associatedTypeWithGenericMap = ((RfType)this.associatedType).getAssociatedTypeWithGenericMap(genericMap);
                            if (associatedTypeWithGenericMap == null) {
                                return;
                            }
                            this.associatedType = associatedTypeWithGenericMap;
                            break block49;
                        }
                        if (this.associatedType == null || selectIndex >= selectsSize) break;
                        if (!(this.associatedType instanceof RfListType) || parentElement instanceof RfFunction) {
                            this.associatedType = null;
                            break;
                        }
                        IHidObject select = (IHidObject)this.selectsContainer.get(selectIndex);
                        List expandedSelect = HidUtils.flattenSelect((IHidObject)select);
                        int noExpectedConstraints = ((RfListType)this.associatedType).getNofConstraints();
                        if (expandedSelect.size() != noExpectedConstraints) {
                            if (triggerError) {
                                IHidObject errorHidObject = select instanceof IHidImplicit ? this.parentHid : select;
                                String errorMessage = expandedSelect.size() < noExpectedConstraints ? "ARRAY_INDEX_SELECT: Select ''{0}'' contains too few indices ({1}) for array type ''{2}'' of dimensionality {3}" : "ARRAY_INDEX_SELECT: Select ''{0}'' contains too many indices ({1}) for array type ''{2}'' of dimensionality {3}";
                                HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)errorHidObject);
                                int line = HidUtils.getLine((HidOccurrence)firstOccurrence);
                                int startOffset = HidUtils.getStartOffset((HidOccurrence)firstOccurrence);
                                int endOffset = HidUtils.getEndOffset((IHidObject)errorHidObject, (int)startOffset, (HidOccurrence)firstOccurrence);
                                rfProject.addSemanticError(1, errorMessage, initialScope != null ? initialScope.getLibPkgScope() : null, startOffset, endOffset, null, line, parserPath, "(" + HidUtils.toNiceStringVHDL((IHidObject)select) + ")", String.valueOf(expandedSelect.size()), this.associatedType.getName(), String.valueOf(noExpectedConstraints));
                            }
                            this.associatedType = null;
                            return;
                        }
                        int k = 0;
                        while (k < noExpectedConstraints) {
                            block53: {
                                block54: {
                                    SContext selectContext;
                                    DataType assocDataType;
                                    ISDataType indexConstraintDataType;
                                    if (!(this.associatedType instanceof RfListType) || ((RfListType)this.associatedType).getDataType() == null) {
                                        this.associatedType = null;
                                        break;
                                    }
                                    IHidObject currentSelect = (IHidObject)expandedSelect.get(k);
                                    if (this.getParentHid() != null && this.getParentHid().getParentAccess() != null) {
                                        Set hids = HidUtils.flattenToHids((IHidObject)currentSelect, SELECTS_HID_FLATTENING);
                                        for (IHid hidIn : hids) {
                                            RfHid hid;
                                            if (!HidUtils.isHid((IHidObject)hidIn) || (hid = (RfHid)hidIn) == this.parentHid || hid.hasOccurrence(HidQualifierCache.FORMAL_PART_QUALIFIER) || hid.getElement() != null) continue;
                                            hid = (RfHid)hid.getAncestorHid();
                                            hid.resolveHids(configInfo, force, triggerError, initialScope, initialScope, genericMap, parserPath, false);
                                        }
                                    }
                                    if ((indexConstraintDataType = (assocDataType = ((RfListType)this.associatedType).getDataType()).getArrayIndexDataType(0)) == SDataAbstracts.UNDEFINED) {
                                        IHidObject indexConstraint = assocDataType.getArrayConstraintHidObject(0);
                                        indexConstraintDataType = SEvaluator.INSTANCE.calculateHidObject(configInfo, (RfNamedElement)initialScope, parserPath, triggerError, indexConstraint, null);
                                    }
                                    if ((selectContext = SContext.of(SDataUtils.getDataType((ISDataAbstract)indexConstraintDataType), (IHidObject)this)) != null) {
                                        selectContext.contextSource = currentSelect instanceof RfHidImplicit ? this.getParentHid() : currentSelect;
                                    }
                                    ISDataAbstract currentSelectType = SEvaluator.INSTANCE.calculateHidObject(configInfo, (RfNamedElement)initialScope, parserPath, triggerError, currentSelect, selectContext);
                                    if (stopAtSelect && currentSelectType == SDataAbstracts.UNDEFINED) {
                                        this.associatedType = null;
                                        return;
                                    }
                                    ISDataType currentSelectDataType = SDataUtils.getDataType((ISDataAbstract)currentSelectType);
                                    IRfNamedElement selectElementType = currentSelectDataType.getType();
                                    if (!(currentSelectType instanceof SDataVariable) && selectElementType instanceof IRfVhdlTypeElement || currentSelect instanceof RfHidOperator && ((RfHidOperator)currentSelect).isRangeOrPartSelect()) break block53;
                                    if (!((currentSelect = HidUtils.getHidFrom((IHidObject)currentSelect)) instanceof RfHid)) break block54;
                                    RfHid hid = (RfHid)currentSelect;
                                    String hidName = hid.getName().toLowerCase();
                                    if (hid.getParentAccess() instanceof RfHidAccess && hid.getParentAccess().getAccessKind() == 5 && ("range".equals(hidName) || "reverse_range".equals(hidName))) break block53;
                                }
                                this.associatedType = ((RfListType)this.associatedType).getResolvedType(true);
                            }
                            ++k;
                        }
                        ++selectIndex;
                    }
                    genericMap = RfNamedElement.updateGenericMap(this.associatedType, genericMap, configInfo.keepGenericMap);
                }
                RfProject.incrementTime1((int)(System.currentTimeMillis() - time));
                break block45;
            }
            if (this.associatedType == null && parentElement instanceof IRfAssociatedTypeElement) {
                if (!(parentElement instanceof RfNamedElement)) {
                    IRfNamedElement nextType = this.getResolvedType((IRfAssociatedTypeElement)parentElement, resolveIfNotCached);
                    int index = 0;
                    int noOfSelects = this.selectsContainer == null ? 0 : this.selectsContainer.size();
                    while (index < noOfSelects && nextType instanceof IRfListType) {
                        IHidObject select = (IHidObject)this.selectsContainer.get(index);
                        ++index;
                        if (HidUtils.isOperator((IHidObject)select) && ((HidOperator)select).isRangeOrPartSelect()) continue;
                        nextType = this.getResolvedType((IRfAssociatedTypeElement)nextType, resolveIfNotCached);
                    }
                    this.associatedType = nextType;
                }
                if (this.associatedType == null) {
                    this.associatedType = this.getResolvedType((IRfAssociatedTypeElement)parentElement, resolveIfNotCached);
                }
            }
        }
        if (isAttribute && this.associatedType == null) {
            this.associatedType = parentElement;
        }
        if (this.isHidObjectsEmpty()) {
            return;
        }
        List hids = OptimizedUtils.asList((ListContainer)this.hidsContainer, (boolean)true);
        for (Hid rfHid : hids) {
            RfHid hid = (RfHid)rfHid;
            if (this.associatedType == null && hid.getSecondaryScope() == null) {
                if (!triggerError) continue;
                hid.reportErrors(rfProject, parserPath, initialScope, parentElement);
                continue;
            }
            if (this.associatedType != null) {
                configInfo.addReferenceToIdentifierName(this.associatedType.getName());
            }
            hid.resolveHids(configInfo, force, triggerError, initialScope, this.associatedType, genericMap, parserPath, resolveFormalPart);
        }
        if (this.isHidObjectsEmpty()) {
            this.hidsContainer = null;
        }
    }

    private IRfNamedElement getResolvedType(IRfAssociatedTypeElement element, boolean resolveIfNotCached) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof RfNamedElement)) {
            return element.getAssociatedType();
        }
        return element.getResolvedType(resolveIfNotCached);
    }

    private IRfNamedElement computeExternalNameType(RfNamedElement initialScope) {
        for (IHidObject select : this.selectsContainer) {
            Hid typeObjectHid;
            IRfNamedElement resolvedType;
            if (!HidUtils.isOperatorOfType((IHidObject)select, (IHidOperatorConstants.OperatorType)IHidOperatorConstants.OperatorType.EXTERNAL_NAME)) continue;
            ListContainer rhValues = ((HidOperator)select).getRHValues();
            if (rhValues == null || rhValues.size() != 3) break;
            IHidObject typeObject = (IHidObject)rhValues.get(0);
            Object object = typeObject instanceof Hid ? ((Hid)typeObject).getElement() : (resolvedType = typeObject instanceof HidAccess ? ((HidAccess)typeObject).getAssociatedType() : null);
            if (resolvedType == null) {
                this.parentHid.setElement(null);
                return null;
            }
            IHidObject pathNameObject = (IHidObject)rhValues.get(1);
            IHidObject kindObject = (IHidObject)rhValues.get(2);
            String name = HidUtils.isHid((IHidObject)pathNameObject) ? ((Hid)pathNameObject).getName() : "";
            DataType dataType = new DataType(HidUtils.isHid((IHidObject)pathNameObject) ? ((Hid)pathNameObject).getHidNameAsStringList() : Collections.emptyList());
            if (HidUtils.isHidAccess((IHidObject)typeObject)) {
                dataType.setElementConstraints(((HidAccess)typeObject).getSelects());
            }
            int variableKind = kindObject instanceof IRfHidImplicitLayer ? (((IRfHidImplicitLayer)kindObject).isSignal() ? 32768 : (((IRfHidImplicitLayer)kindObject).isVariable() ? 8192 : 16384)) : 8192;
            RfDummyVariable dummyVariable = new RfDummyVariable(name, dataType, 1, variableKind, resolvedType, null);
            dummyVariable.setEnclosingScope(initialScope, false);
            this.parentHid.setElement((IRfNamedElement)dummyVariable);
            ((HidOperator)select).setOperatorResolvedType((ISDataAbstract)SDataVariable.of((ISDataType)SDataType.of(dummyVariable), (boolean)false));
            Object object2 = typeObject instanceof Hid ? (Hid)typeObject : (typeObjectHid = typeObject instanceof HidAccess ? ((HidAccess)typeObject).getParentHid() : null);
            if (typeObjectHid != null && initialScope.getDeclaration() != null) {
                HidOccurrence occurrence = typeObjectHid.getOccurrence();
                dummyVariable.setDeclaration(new RfDefElement(initialScope.getDeclaration().getDefFile(), name, new LineInfo(occurrence.getLine(), occurrence.getOffset(), -1), new LineInfo(occurrence.getLine(), occurrence.getOffset() + typeObjectHid.getName().length(), -1), null));
            }
            return dummyVariable;
        }
        return null;
    }

    private boolean validAssociatedType(IRfNamedElement element) {
        if (element == this.associatedType) {
            return true;
        }
        if (!(element instanceof IRfAssociatedType)) {
            return false;
        }
        DataType dataType = ((IRfAssociatedType)element).getDataType();
        if (dataType == null) {
            return false;
        }
        List<DataTypeChunk> typeName = dataType.getTypeName();
        if (typeName == null) {
            return false;
        }
        if (typeName == this.dataTypeName) {
            return true;
        }
        return typeName.equals(this.dataTypeName);
    }

    public List<IHidObject> getArgumentValues() {
        if (this.parentHid == null || !this.parentHid.isMethodCall(false)) {
            return null;
        }
        if (!this.isSelect()) {
            return Collections.emptyList();
        }
        IHidObject pos = (IHidObject)this.selectsContainer.get(0);
        boolean isOperator = HidUtils.isOperator((IHidObject)pos);
        if (isOperator && ((HidOperator)pos).isSelectList()) {
            List argumentValues = OptimizedUtils.asList((ListContainer)((HidOperator)pos).getRHValues(), (boolean)true);
            Collections.reverse(argumentValues);
            return argumentValues;
        }
        if (!isOperator || !((HidOperator)pos).isRangeOrPartSelect()) {
            return Collections.singletonList(pos);
        }
        return null;
    }

    public List<MethodCall> getMethodCalls(IHidEvaluationGuardian guardian) {
        MethodCall unknownMethodCall;
        List<IHidObject> argumentValues = this.getArgumentValues();
        Map methodsWithFormalArgs = MethodCallUtils.getMethodsWithFormalArguments((IHid)this.parentHid);
        if (methodsWithFormalArgs != null && !methodsWithFormalArgs.isEmpty()) {
            ArrayList<MethodCall> calls = new ArrayList<MethodCall>(methodsWithFormalArgs.size());
            for (Map.Entry methodWithFormalArgs : methodsWithFormalArgs.entrySet()) {
                MethodCall call = MethodCallUtils.getMethodCall((IHidObject)this.parentHid, (IRfNamedElement)((IRfNamedElement)methodWithFormalArgs.getKey()), (List)((List)methodWithFormalArgs.getValue()), argumentValues, (boolean)false, (HidOccurrence)this.getOccurrence());
                if (call == null) continue;
                calls.add(call);
            }
            return calls;
        }
        if (!HidUtils.isResolved((IHidObject)this.parentHid) && (unknownMethodCall = MethodCallUtils.getMethodCall((IHidObject)this.parentHid, null, null, argumentValues, (boolean)false, (HidOccurrence)this.getOccurrence())) != null) {
            return Collections.singletonList(unknownMethodCall);
        }
        return null;
    }

    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        if (this.isAttributeAccess()) {
            return ELParamValueScope.of((IELParamValue)this.resolvePredefinedAttribute(evaluator, context, guardian));
        }
        if (this.getAccessKind() != 0 && this.getAccessKind() != Integer.MIN_VALUE) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        if (this.parentHid == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        BitVectorContext defaultContext = BitVectorContext.of((IRfNamedElement)(context != null ? context.getOrigin() : null), (boolean)true);
        ELParamValueScope valueToSelectScopeRaw = null;
        if (evaluator.isInterpreter() && this.parentHid.getElement() instanceof RfFunction) {
            IHidEvaluator currentEvaluator = evaluator;
            if (this.parentHid.getParentAccess() != null) {
                currentEvaluator = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)this.parentHid.getParentAccess(), (IHidEvaluator)evaluator, (BitVectorContext)context, (IHidEvaluationGuardian)guardian));
            }
            valueToSelectScopeRaw = currentEvaluator.getValue((IHid)this.parentHid, null, null, true, guardian);
        } else {
            valueToSelectScopeRaw = ELUtils.evaluate((IHidObject)this.parentHid, (IHidEvaluator)evaluator, (BitVectorContext)defaultContext, (IHidEvaluationGuardian)guardian);
        }
        if (evaluator.isInterpreter() && ELUtils.isUnsuccessfulEval((ELParamValueScope)valueToSelectScopeRaw)) {
            guardian.logError(DVTStringUtil.appendString((Object[])new Object[]{"Fail to evaluate '", this.parentHid.getName(), "' in scope of '", XUtils.getEnclosingNamedScope((IHidEvaluator)evaluator), "' (id:0016)"}));
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        IELParamValue valueToSelectRaw = XUtils.getValue((ELParamValueScope)valueToSelectScopeRaw);
        if (this.parentHid.getElement() instanceof RfPredefinedAttribute) {
            return valueToSelectScopeRaw;
        }
        if (this.isMethodCall(false)) {
            if (!this.isMethodCall(true)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            if (this.parentHid.getElement() instanceof RfFunctionsHolder) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            MethodCall methodCall = this.getMethodCall(guardian);
            if (methodCall == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            if (methodCall.method instanceof RfFunction) {
                IELParamValue result;
                IRfScopeElement enclosingScope = methodCall.method.getEnclosingScope();
                RfFunction function = (RfFunction)methodCall.method;
                if (TO_STRING_METHOD_NAME.equalsIgnoreCase(function.getName()) && (function.getSubprogramKind() == 4 || enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).isPredefined())) {
                    return ELParamValueScope.of((IELParamValue)this.resolveToStringMethodCall(methodCall, evaluator, guardian));
                }
                if (enclosingScope instanceof RfPackage && ((RfPackage)enclosingScope).isPredefined()) {
                    String functionQualifiedName = function.getQualifiedName();
                    if (SUPPORTED_INTRP_FUNCTIONS.contains(functionQualifiedName)) {
                        if (!evaluator.isInterpreter()) {
                            guardian.logError("Missing implementation of method: " + function.getName());
                            throw new UnknownHidObjectEvaluationException((IHidObject)this);
                        }
                        methodCall.methodValueHolder = XUtils.getValue((ELParamValueScope)valueToSelectScopeRaw);
                        return RfHidAccess.evaluateFunctionCall((IHidObject)this, (MethodCall)methodCall, (IHidEvaluator)evaluator, (IHidEvaluator)evaluator, (IHidEvaluationGuardian)guardian);
                    }
                    if ("standard".equals(enclosingScope.getName()) && SUPPORTED_STD_PACKAGE_MINMAX_FUNCTIONS.contains(functionQualifiedName)) {
                        result = this.resolveCustomStdPackageMethodCall(methodCall, functionQualifiedName, evaluator, guardian);
                        if (result != null) {
                            return ELParamValueScope.of((IELParamValue)result);
                        }
                    } else if ("std_logic_1164".equals(enclosingScope.getName()) && (this.isSupportedToBitVectorFunction(functionQualifiedName) || this.isSupportedToStdLogicVectorFunction(functionQualifiedName))) {
                        result = this.resolveCustomStdLogic1164MethodCall(methodCall, functionQualifiedName, evaluator, guardian);
                        if (result != null) {
                            return ELParamValueScope.of((IELParamValue)result);
                        }
                    } else if ("std_logic_arith".equals(enclosingScope.getName()) && this.isSupportedStdLogicArithFunction(functionQualifiedName)) {
                        IELParamValue result2 = this.resolveCustomStdLogicArithMethodCall(methodCall, functionQualifiedName, evaluator, guardian);
                        if (ELUtils.isUnsuccessfulEval((IELParamValue)result2)) {
                            return ELParamValueScope.UNDEFINED_VALUE;
                        }
                        return ELParamValueScope.of((IELParamValue)(context != null ? context.transform(result2) : result2));
                    }
                }
                RfFunction implementation = function.getImplementation();
                if ((MAXIMUM_METHOD_NAME.equals(function.getName()) || MINIMUM_METHOD_NAME.equals(function.getName())) && function.isPredefined() && implementation.isPrototype() && (result = this.resolvePredefinedMinMaxArrayMethodCall(methodCall, function.getQualifiedName(), evaluator, guardian)) != null) {
                    return ELParamValueScope.of((IELParamValue)result);
                }
                if (implementation.isPrototype()) {
                    guardian.logError("Missing implementation of method: " + function.getName());
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                if (implementation != methodCall.method) {
                    IRfNamedElement element = this.parentHid.getElement();
                    try {
                        this.parentHid.setElement((IRfNamedElement)implementation);
                        methodCall = new MethodCall(methodCall.methodHidObject, (IRfNamedElement)implementation, methodCall.argumentValuesMap, methodCall.argumentValuesMapRaw, methodCall.occurrence);
                        ELParamValueScope eLParamValueScope = RfHidAccess.evaluateFunctionCall((IHidObject)this, (MethodCall)methodCall, (IHidEvaluator)evaluator, (IHidEvaluator)evaluator, (IHidEvaluationGuardian)guardian);
                        return eLParamValueScope;
                    }
                    finally {
                        this.parentHid.setElement(element);
                    }
                }
            }
            return RfHidAccess.evaluateFunctionCall((IHidObject)this, (MethodCall)methodCall, (IHidEvaluator)evaluator, (IHidEvaluator)evaluator, (IHidEvaluationGuardian)guardian);
        }
        if (valueToSelectRaw == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        if (ELUtils.isUnsuccessfulEval((IELParamValue)valueToSelectRaw)) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (this.selectsContainer == null) {
            if (valueToSelectRaw instanceof XValueHolder) {
                return valueToSelectScopeRaw;
            }
            if (DVTNumber.isUndefined((DVTNumber)valueToSelectRaw.getDVTNumber())) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return context != null ? context.transform(valueToSelectScopeRaw) : valueToSelectScopeRaw;
        }
        if (this.getAccessKind() == Integer.MIN_VALUE && valueToSelectRaw instanceof ELParamValues.ParamValueType) {
            BitVectorContext newContext = BitVectorContext.of((DVTNumber)valueToSelectRaw.getDVTNumber(), (IRfNamedElement)(context != null ? context.getOrigin() : null));
            ELParamValueScope resultNumberValue = ELUtils.evaluate((IHidObject)((IHidObject)this.selectsContainer.iterator().next()), (IHidEvaluator)evaluator, (BitVectorContext)newContext, (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)resultNumberValue) || DVTNumber.isUndefined((DVTNumber)resultNumberValue.getDVTNumber())) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            DVTNumber resultNumber = resultNumberValue.getDVTNumber();
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform(resultNumber) : resultNumber)));
        }
        if (guardian.isInterpreter() && this.getAccessKind() == Integer.MIN_VALUE && this.parentHid.hasQualifier(HidQualifierCache.TYPE_QUALIFIER)) {
            BitVectorContext newContext = XValueHolderFactory.getRightOpContext((IELParamValue)valueToSelectRaw, (IHidObject)((IHidObject)this.selectsContainer.iterator().next()), (IRfNamedElement)(context != null ? context.getOrigin() : null), (XValueHolderFactory)guardian.getFactory());
            ELParamValueScope resultNumberValue = ELUtils.evaluate((IHidObject)((IHidObject)this.selectsContainer.iterator().next()), (IHidEvaluator)evaluator, (BitVectorContext)newContext, (IHidEvaluationGuardian)guardian);
            if (ELUtils.isUnsuccessfulEval((ELParamValueScope)resultNumberValue)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return context != null ? context.transform(resultNumberValue) : resultNumberValue;
        }
        return ELParamValueScope.of((IELParamValue)XValueHolderFactory.createSelectProxyValue((HidAccess)this, (IELParamValue)valueToSelectRaw, (BitVectorContext)context, (IHidEvaluator)evaluator, (boolean)false, (boolean)false, (IHidEvaluationGuardian)guardian, (LanguageKind)LanguageKind.VHDL), (IHidEvaluator)XUtils.getScope((ELParamValueScope)valueToSelectScopeRaw));
    }

    public boolean isSupportedToBitVectorFunction(String functionQualifiedName) {
        return toBitVectorFromStdLogic.equals(functionQualifiedName = functionQualifiedName.toLowerCase()) || toBitVectorFromStdULogic.equals(functionQualifiedName) || toBitFromStdLogic.equals(functionQualifiedName);
    }

    public boolean isSupportedToStdLogicVectorFunction(String functionSignatureText) {
        return toStdULogicFromBit.equals(functionSignatureText = functionSignatureText.toLowerCase()) || toStdULogicFromBitVector.equals(functionSignatureText) || toStdULogicFromStdLogic.equals(functionSignatureText) || toStdLogicFromStdULogic.equals(functionSignatureText) || toStdLogicFromBitVector.equals(functionSignatureText);
    }

    public boolean isSupportedStdLogicArithFunction(String functionSignatureText) {
        return convIntegerFromUnsigned.equals(functionSignatureText = functionSignatureText.toLowerCase()) || convUnsignedFromInteger.equals(functionSignatureText) || convIntegerFromStdULogic.equals(functionSignatureText) || convUnsignedFromStdULogic.equals(functionSignatureText);
    }

    private IELParamValue resolveToStringMethodCall(MethodCall methodCall, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        ELManager manager = evaluator.getManager();
        if (manager != null) {
            manager.state.incrementSystemMethodCallsEvals();
        }
        if (methodCall == null || methodCall.argumentValuesMapRaw == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        Collection rawArguments = methodCall.argumentValuesMapRaw.values();
        List<RfVariable> arguments = ((RfFunction)methodCall.method).getArguments();
        if (rawArguments == null || rawArguments.size() != 1 || arguments == null || arguments.size() != 1) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        BitVectorContext argContext = arguments.get(0).getDataTypeBitVectorContext(evaluator, false, null, manager);
        IELParamValue argValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)rawArguments.iterator().next()), (IHidEvaluator)evaluator, (BitVectorContext)argContext, (IHidEvaluationGuardian)guardian));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)argValue)) {
            return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
        }
        if (!ELUtils.isParamValueNumber((IELParamValue)argValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        DVTNumber argNumber = argValue.getDVTNumber();
        if (argNumber instanceof VlogBitVector) {
            if (argNumber.isStruct(true)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            String niceString = null;
            if (((VlogBitVector)argNumber).getArrayDimensions().length > 4) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (argContext != null && argContext.getContextNumber() instanceof VhdlEnum) {
                VhdlEnum vhdlEnum = (VhdlEnum)argContext.getContextNumber();
                IRfNamedElement enumValue = vhdlEnum.getEnumValue();
                IRfSingleLangProject rfProject = enumValue.getRfProject();
                boolean isBit = enumValue != null && enumValue.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT));
                boolean isStdLogic = !isBit && enumValue != null && enumValue.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STD_ULOGIC));
                niceString = ((VlogBitVector)argNumber).toNiceStringVhdl(vhdlEnum, 2, isBit, isStdLogic, false, false);
            } else {
                niceString = argNumber.toString(10, false, false);
            }
            int nofBits = niceString.length() * 8;
            byte[] specifiedBytes = niceString.getBytes(IDVTConstants.ASCII);
            if (specifiedBytes == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            try {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])new int[]{1, nofBits}, (boolean)false, (boolean)true, (BigInteger)new BigInteger(specifiedBytes)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    private IELParamValue resolveCustomStdPackageMethodCall(MethodCall methodCall, String functionQualifiedName, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        boolean hasSecondArgument;
        ELManager manager = evaluator.getManager();
        if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty() || methodCall.argumentValuesMapRaw.size() > 2) {
            return null;
        }
        Iterator iterator = methodCall.argumentValuesMapRaw.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        IRfFieldElement firstArgField = (IRfFieldElement)firstEntry.getKey();
        IELParamValue firstArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)firstEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)firstArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        if (!ELUtils.isParamValueNumber((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        DVTNumber firstArgNumber = firstArgValue.getDVTNumber();
        DVTNumber secondArgNumber = null;
        boolean bl = hasSecondArgument = methodCall.argumentValuesMapRaw.size() == 2;
        if (hasSecondArgument) {
            Map.Entry secondEntry = iterator.next();
            IRfFieldElement secondArgField = (IRfFieldElement)secondEntry.getKey();
            IELParamValue secondArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)secondEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)secondArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)secondArgValue)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
            }
            if (!ELUtils.isParamValueNumber((IELParamValue)secondArgValue)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
            }
            secondArgNumber = secondArgValue.getDVTNumber();
        }
        switch (functionQualifiedName) {
            case "maximum@a:severity_level,severity_level@r:severity_level@b:false": 
            case "minimum@a:file_open_kind,file_open_kind@r:file_open_kind@b:false": 
            case "maximum@a:bit,bit@r:bit@b:false": 
            case "minimum@a:integer,integer@r:integer@b:false": 
            case "minimum@a:file_open_status,file_open_status@r:file_open_status@b:false": 
            case "minimum@a:boolean,boolean@r:boolean@b:false": 
            case "maximum@a:file_open_kind,file_open_kind@r:file_open_kind@b:false": 
            case "maximum@a:string,string@r:string@b:false": 
            case "maximum@a:character,character@r:character@b:false": 
            case "maximum@a:integer,integer@r:integer@b:false": 
            case "maximum@a:boolean,boolean@r:boolean@b:false": 
            case "minimum@a:bit,bit@r:bit@b:false": 
            case "minimum@a:character,character@r:character@b:false": 
            case "maximum@a:file_open_status,file_open_status@r:file_open_status@b:false": 
            case "minimum@a:string,string@r:string@b:false": 
            case "minimum@a:severity_level,severity_level@r:severity_level@b:false": {
                if (!(firstArgNumber instanceof VlogBitVector)) {
                    return null;
                }
                if (!(secondArgNumber instanceof VlogBitVector)) {
                    return null;
                }
                return functionQualifiedName.startsWith(MAXIMUM_METHOD_NAME) ? ELParamValues.ParamValueNumber.of((DVTNumber)((VlogBitVector)firstArgNumber).max(secondArgNumber)) : ELParamValues.ParamValueNumber.of((DVTNumber)((VlogBitVector)firstArgNumber).min(secondArgNumber));
            }
            case "minimum@a:real,real@r:real@b:false": 
            case "maximum@a:real,real@r:real@b:false": {
                if (!(firstArgNumber instanceof VlogRealNumber)) {
                    return null;
                }
                if (!(secondArgNumber instanceof VlogRealNumber)) {
                    return null;
                }
                return functionQualifiedName.startsWith(MAXIMUM_METHOD_NAME) ? ELParamValues.ParamValueNumber.of((DVTNumber)new VlogRealNumber(Math.max(firstArgNumber.doubleValue(), secondArgNumber.doubleValue()))) : ELParamValues.ParamValueNumber.of((DVTNumber)new VlogRealNumber(Math.min(firstArgNumber.doubleValue(), secondArgNumber.doubleValue())));
            }
        }
        return null;
    }

    private IELParamValue resolveCustomStdLogic1164MethodCall(MethodCall methodCall, String functionQualifiedName, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        DVTNumber dvtNumber;
        boolean toBitVectorFunction = this.isSupportedToBitVectorFunction(functionQualifiedName);
        boolean toStdLogicFunction = this.isSupportedToStdLogicVectorFunction(functionQualifiedName);
        if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
            return null;
        }
        ELManager manager = evaluator.getManager();
        Map.Entry firstEntry = methodCall.argumentValuesMapRaw.entrySet().iterator().next();
        IRfNamedElement formalArgument = (IRfNamedElement)firstEntry.getKey();
        if (!(formalArgument instanceof IRfFieldElement)) {
            return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
        }
        IRfFieldElement firstArg = (IRfFieldElement)formalArgument;
        IHidObject firstHidObject = (IHidObject)firstEntry.getValue();
        BitVectorContext argContext = null;
        argContext = evaluator.isInterpreter() && evaluator instanceof XMethodValueHolder ? ((XMethodValueHolder)evaluator).getArgumentContext(firstArg, firstHidObject) : firstArg.getDataTypeBitVectorContext(evaluator, false, null, manager);
        IELParamValue argValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)firstHidObject, (IHidEvaluator)evaluator, (BitVectorContext)argContext, (IHidEvaluationGuardian)guardian.copy((IRfNamedElement)firstArg)));
        if (!evaluator.isInterpreter()) {
            if (ELUtils.isUnsuccessfulEval((IELParamValue)argValue)) {
                throw new UnknownHidObjectEvaluationException(firstHidObject);
            }
            if (!ELUtils.isParamValueNumber((IELParamValue)argValue)) {
                throw new UnknownHidObjectEvaluationException(firstHidObject);
            }
        }
        if (!((dvtNumber = argValue.getDVTNumber()) instanceof VlogBitVector)) {
            return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
        }
        if (toBitVectorFunction) {
            VlogBitVector noMaskEquivalent = ((VlogBitVector)dvtNumber).createNoMaskEquivalent();
            return ELParamValues.ParamValueNumber.of((DVTNumber)noMaskEquivalent);
        }
        if (toStdLogicFunction) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)dvtNumber);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    private IELParamValue resolveCustomStdLogicArithMethodCall(MethodCall methodCall, String functionQualifiedName, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        ELManager manager = evaluator.getManager();
        if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty() || methodCall.argumentValuesMapRaw.size() > 2) {
            return null;
        }
        Iterator iterator = methodCall.argumentValuesMapRaw.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        IRfFieldElement firstArgField = (IRfFieldElement)firstEntry.getKey();
        IELParamValue firstArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)firstEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)firstArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        if (!ELUtils.isParamValueNumber((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        DVTNumber firstArgNumber = firstArgValue.getDVTNumber();
        if (!(firstArgNumber instanceof VlogBitVector var11_12)) {
            return null;
        }
        DVTNumber secondArgNumber = null;
        boolean bl = hasSecondArgument = methodCall.argumentValuesMapRaw.size() == 2;
        if (hasSecondArgument) {
            Map.Entry secondEntry = iterator.next();
            IRfFieldElement secondArgField = (IRfFieldElement)secondEntry.getKey();
            IELParamValue secondArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)secondEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)secondArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)secondArgValue)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
            }
            if (!ELUtils.isParamValueNumber((IELParamValue)secondArgValue)) {
                throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
            }
            secondArgNumber = secondArgValue.getDVTNumber();
            if (!(secondArgNumber instanceof VlogBitVector var18_23)) {
                return null;
            }
            int size = secondArgBitVector.intValue();
            int n = left = size <= 0 ? 0 : size - 1;
            if (functionQualifiedName.equalsIgnoreCase(convUnsignedFromStdULogic) || functionQualifiedName.equalsIgnoreCase(convUnsignedFromInteger)) {
                if (firstArgBitVector instanceof VlogBitVector.VlogBitVector__mask var22_27 && mask.getMask(MaskType.H) == null && mask.getMask(MaskType.L) == null) {
                    int[] nArray = new int[4];
                    nArray[0] = left;
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)left, (int)0, (int[])nArray, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, (EnumMap)VlogBitVector.createOneBitMaskOfType((MaskType)MaskType.X)));
                }
                int[] nArray = new int[4];
                nArray[0] = left;
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)left, (int)0, (int[])nArray, (boolean)true, (boolean)false, (BigInteger)(size <= 0 ? BigInteger.ZERO : firstArgBitVector.bigIntegerValue())));
            }
            return null;
        }
        if (functionQualifiedName.equalsIgnoreCase(convIntegerFromUnsigned)) {
            if (firstArgBitVector instanceof VlogBitVector.VlogBitVector__mask secondEntry && mask.getMask(MaskType.H) == null && mask.getMask(MaskType.L) == null) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.ZERO));
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)firstArgBitVector.bigIntegerValue()));
        }
        if (functionQualifiedName.equalsIgnoreCase(convIntegerFromStdULogic)) {
            if (firstArgBitVector instanceof VlogBitVector.VlogBitVector__mask mask && mask.getMask(MaskType.H) == null && mask.getMask(MaskType.L) == null) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)1, (int)0, (BigInteger)BigInteger.ZERO));
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)1, (int)0, (BigInteger)firstArgBitVector.bigIntegerValue()));
        }
        return null;
    }

    private IELParamValue resolvePredefinedAttribute(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        boolean isRangeSelectableConstrained;
        RfHidAccess parentAccess;
        IRfNamedElement parentAssocType;
        BitVectorContext noContext = BitVectorContext.of((IRfNamedElement)(context != null ? context.getOrigin() : null), (boolean)true);
        if (context == null) {
            context = noContext;
        }
        String attributeName = null;
        List attributeArgumentObjects = null;
        if (this.isAttributeAccess()) {
            ListContainer hids = this.getHids();
            if (!(hids instanceof RfHid)) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            attributeName = ((RfHid)hids).getName().toUpperCase();
            HidAccess firstAccess = ((RfHid)hids).getFirstAccess();
            if (firstAccess != null) {
                attributeArgumentObjects = firstAccess.getSelects();
            }
        } else {
            attributeName = this.parentHid.getName().toUpperCase();
        }
        if ((parentAssocType = (parentAccess = this.isAttributeAccess() ? this : this.parentHid.getParentAccess()).getParentHid().getElement()) instanceof RfType && ((RfType)parentAssocType).hasScalarBaseType()) {
            IELParamValue result = ((RfType)parentAssocType).getScalarAttribute(evaluator, attributeName, attributeArgumentObjects, guardian);
            if (ELUtils.isUnsuccessfulEval((IELParamValue)result)) {
                return null;
            }
            return context.transform(result);
        }
        DVTNumber parentNumber = null;
        IELParamValue parentParamValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)parentAccess.getParentHid(), (IHidEvaluator)evaluator, (BitVectorContext)noContext, (IHidEvaluationGuardian)guardian));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)parentParamValue)) {
            if (!(parentAssocType instanceof IRfAssociatedTypeElement)) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            ELManager manager = evaluator instanceof ELParamValuesHidEvaluator ? ((ELParamValuesHidEvaluator)evaluator).getManager() : null;
            BitVectorContext parentContext = ((IRfAssociatedTypeElement)parentAssocType).getDataTypeBitVectorContext(evaluator, false, null, manager);
            if (parentContext == null) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            parentNumber = parentContext.getContextNumber();
        } else {
            parentNumber = parentParamValue.getDVTNumber();
        }
        boolean bl = isRangeSelectableConstrained = parentNumber instanceof IDVTRangeSelectable && !((IDVTRangeSelectable)parentNumber).isUnconstrainedFirstDimension();
        if (isRangeSelectableConstrained && this.selectsContainer != null) {
            if (ELUtils.isUnsuccessfulEval((IELParamValue)(parentParamValue = XValueHolderFactory.createSelectProxyValue((HidAccess)this, (IELParamValue)parentParamValue, (BitVectorContext)context, (IHidEvaluator)evaluator, (boolean)false, (boolean)false, (IHidEvaluationGuardian)guardian, (LanguageKind)LanguageKind.VHDL)))) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            parentNumber = parentParamValue.getDVTNumber();
        }
        ArrayList<DVTNumber> attributeArgumentNumbers = new ArrayList<DVTNumber>();
        if (attributeArgumentObjects != null) {
            for (IHidObject select : attributeArgumentObjects) {
                IELParamValue argValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)select, (IHidEvaluator)evaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)parentAssocType, (boolean)false), (IHidEvaluationGuardian)guardian));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)argValue)) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                attributeArgumentNumbers.add(argValue.getDVTNumber());
            }
        }
        if ("EVENT".equals(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ONE);
        }
        IELParamValue result = null;
        if (evaluator.isInterpreter() && parentParamValue instanceof XArrayValueHolder) {
            result = this.getArrayAttribute(attributeName, attributeArgumentNumbers, (XArrayValueHolder)parentParamValue);
        } else if (isRangeSelectableConstrained) {
            result = this.getArrayAttribute(attributeName, attributeArgumentNumbers, parentNumber, parentAssocType);
        }
        return context.transform(result);
    }

    private IELParamValue resolvePredefinedMinMaxArrayMethodCall(MethodCall methodCall, String functionQualifiedName, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        ELManager manager = evaluator.getManager();
        if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty() || methodCall.argumentValuesMapRaw.size() > 2) {
            return null;
        }
        Iterator iterator = methodCall.argumentValuesMapRaw.entrySet().iterator();
        Map.Entry firstEntry = iterator.next();
        IRfFieldElement firstArgField = (IRfFieldElement)firstEntry.getKey();
        IELParamValue firstArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)firstEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)firstArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        if (!ELUtils.isParamValueNumber((IELParamValue)firstArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)firstEntry.getValue());
        }
        DVTNumber firstArgNumber = firstArgValue.getDVTNumber();
        IRfNamedElement firstArgArrayType = firstArgField.getAssociatedType();
        IRfNamedElement iRfNamedElement = firstArgArrayType;
        if (!(iRfNamedElement instanceof RfListType) || (var12_13 = (RfListType)iRfNamedElement) != (RfListType)iRfNamedElement || !(( instanceOfPatternExpressionValue = firstArgNumber) instanceof IDVTRangeSelectable) || (var13_15 = (IDVTRangeSelectable) instanceOfPatternExpressionValue) != (IDVTRangeSelectable) instanceOfPatternExpressionValue) {
            return null;
        }
         instanceOfPatternExpressionValue = firstArgListType.getAssociatedType();
        if ( instanceOfPatternExpressionValue instanceof RfScalarType var16_17 && type.hasPhysicalUnits()) {
            return null;
        }
        boolean isMaximum = functionQualifiedName.startsWith("max");
        boolean bl = hasSecondArgument = methodCall.argumentValuesMapRaw.size() == 2;
        if (!hasSecondArgument) {
            int arraySize = firstArgRangeSelectable.getArraySize();
            if (firstArgNumber instanceof VlogBitVector var21_24) {
                if (firstArgBitVector instanceof VlogBitVector.VlogBitVector__mask) {
                    char[] charArray = firstArgBitVector.toString(2, false, false).toCharArray();
                    char bit = charArray[0];
                    byte result = MaskType.getVhdlStdLogicEnumOrdinal((char)bit);
                    int i = 1;
                    while (i < arraySize) {
                        byte value = MaskType.getVhdlStdLogicEnumOrdinal((char)charArray[i]);
                        if (isMaximum && result < value || !isMaximum && result > value) {
                            result = value;
                            bit = charArray[i];
                        }
                        ++i;
                    }
                    if (bit == '0') {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)true, (boolean)false, (BigInteger)BigInteger.ZERO));
                    }
                    if (bit == '1') {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)true, (boolean)false, (BigInteger)BigInteger.ONE));
                    }
                    if (bit == '-') {
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, (EnumMap)VlogBitVector.createOneBitMaskOfType((MaskType)MaskType.DASH)));
                    }
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)0, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null, (EnumMap)VlogBitVector.createOneBitMaskOfType((MaskType)MaskType.valueOf((String)String.valueOf(bit)))));
                }
                if (firstArgBitVector.isString()) {
                    if (firstArgBitVector.isEmptyString()) {
                        int[] nArray = new int[2];
                        nArray[0] = 7;
                        return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)7, (int[])nArray, (boolean)false, (boolean)true, (BigInteger)BigInteger.valueOf(isMaximum ? 0 : 255)));
                    }
                    char[] charArray = firstArgBitVector.stringValue(true).toCharArray();
                    char result = charArray[0];
                    int i = 1;
                    while (i < arraySize) {
                        char value = charArray[i];
                        if (isMaximum && result < value || !isMaximum && result > value) {
                            result = value;
                        }
                        ++i;
                    }
                    int[] nArray = new int[2];
                    nArray[0] = 7;
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)false, (int)0, (int)7, (int[])nArray, (boolean)false, (boolean)true, (BigInteger)BigInteger.valueOf(result)));
                }
                boolean isZero = VlogBitVector.ZERO.equals((VlogBitVector)firstArgBitVector);
                if (isMaximum) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)(isZero ? VlogBitVector.ZERO : VlogBitVector.ONE));
                }
                boolean isAllOnes = firstArgBitVector.getNumber().bitCount() == arraySize;
                return ELParamValues.ParamValueNumber.of((DVTNumber)(isAllOnes ? VlogBitVector.ONE : VlogBitVector.ZERO));
            }
            if (!(firstArgNumber instanceof DVTUnpackedArray isZero)) {
                return null;
            }
            DVTNumber result = firstArgArray.getElementAtIndex(0, false);
            int i = 1;
            while (i < arraySize) {
                DVTNumber number = firstArgArray.getElementAtIndex(i, false);
                if (isMaximum && DVTNumber.lt((DVTNumber)result, (DVTNumber)number) || !isMaximum && DVTNumber.gt((DVTNumber)result, (DVTNumber)number)) {
                    result = number;
                }
                ++i;
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)result);
        }
        Map.Entry secondEntry = iterator.next();
        IRfFieldElement secondArgField = (IRfFieldElement)secondEntry.getKey();
        IELParamValue secondArgValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)((IHidObject)secondEntry.getValue()), (IHidEvaluator)evaluator, (BitVectorContext)secondArgField.getDataTypeBitVectorContext(evaluator, false, null, manager), (IHidEvaluationGuardian)guardian.copy()));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)secondArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
        }
        if (!ELUtils.isParamValueNumber((IELParamValue)secondArgValue)) {
            throw new UnknownHidObjectEvaluationException((IHidObject)secondEntry.getValue());
        }
        DVTNumber secondArgNumber = secondArgValue.getDVTNumber();
        DVTNumber dVTNumber = firstArgNumber;
        if (dVTNumber instanceof VlogBitVector && ( instanceOfPatternExpressionValue = (VlogBitVector)dVTNumber) == (VlogBitVector)dVTNumber && ( instanceOfPatternExpressionValue = secondArgNumber) instanceof VlogBitVector result) {
            if (firstArgBitVector.isString()) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? firstArgBitVector.max((DVTNumber)secondArgBitVector) : firstArgBitVector.min((DVTNumber)secondArgBitVector)));
            }
            String firstArgStr = firstArgBitVector.toString(2, false, false);
            String secondArgStr = secondArgBitVector.toString(2, false, false);
            if (firstArgBitVector instanceof VlogBitVector.VlogBitVector__mask || secondArgBitVector instanceof VlogBitVector.VlogBitVector__mask) {
                char[] firstArgChars = firstArgStr.toCharArray();
                char[] secondArgChars = secondArgStr.toCharArray();
                int i = 0;
                while (i < firstArgChars.length) {
                    firstArgChars[i] = (char)MaskType.getVhdlStdLogicEnumOrdinal((char)firstArgChars[i]);
                    ++i;
                }
                i = 0;
                while (i < secondArgChars.length) {
                    secondArgChars[i] = (char)MaskType.getVhdlStdLogicEnumOrdinal((char)secondArgChars[i]);
                    ++i;
                }
                firstArgStr = String.valueOf(firstArgChars);
                secondArgStr = String.valueOf(secondArgChars);
            }
            if (firstArgStr.compareTo(secondArgStr) < 0) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? secondArgNumber : firstArgNumber));
            }
            return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? firstArgNumber : secondArgNumber));
        }
         instanceOfPatternExpressionValue = firstArgNumber;
        if (!( instanceOfPatternExpressionValue instanceof DVTUnpackedArray) || (firstArgStr = (DVTUnpackedArray) instanceOfPatternExpressionValue) != (DVTUnpackedArray) instanceOfPatternExpressionValue || !(( instanceOfPatternExpressionValue = secondArgNumber) instanceof DVTUnpackedArray) || (secondArgStr = (DVTUnpackedArray) instanceOfPatternExpressionValue) != (DVTUnpackedArray) instanceOfPatternExpressionValue) {
            return null;
        }
        int firstArraySize = firstArgArray.getArraySize();
        int secondArraySize = secondArgArray.getArraySize();
        int minSize = Math.min(firstArraySize, secondArraySize);
        int i = 0;
        while (i < minSize) {
            DVTNumber firstArrayElement = firstArgArray.getElementAtIndex(i, false);
            if (DVTNumber.lt((DVTNumber)firstArrayElement, (DVTNumber)(secondArrayElement = secondArgArray.getElementAtIndex(i, false)))) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? secondArgArray : firstArgArray));
            }
            if (DVTNumber.gt((DVTNumber)firstArrayElement, (DVTNumber)secondArrayElement)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? firstArgArray : secondArgArray));
            }
            ++i;
        }
        if (firstArraySize < secondArraySize) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? secondArgArray : firstArgArray));
        }
        return ELParamValues.ParamValueNumber.of((DVTNumber)(isMaximum ? firstArgArray : secondArgArray));
    }

    public IELParamValue getArrayAttribute(String attributeName, List<DVTNumber> arguments, XArrayValueHolder array) {
        int argumentValue = arguments == null || arguments.isEmpty() ? 1 : arguments.get(0).intValue();
        while (argumentValue > 1) {
            IELParamValue elementType = array.getItemElementValue();
            if (!(elementType instanceof XArrayValueHolder)) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            array = (XArrayValueHolder)elementType;
            --argumentValue;
        }
        if ("LENGTH".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.$size())));
        }
        if ("LEFT".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.getLeftBound())));
        }
        if ("RIGHT".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.getRightBound())));
        }
        if ("HIGH".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.max(array.getLeftBound(), array.getRightBound()))));
        }
        if ("LOW".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.min(array.getLeftBound(), array.getRightBound()))));
        }
        if ("RANGE".equalsIgnoreCase(attributeName)) {
            return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)array.$size(), (int)0, (int[])new int[]{array.getLeftBound(), array.getRightBound()}, (boolean)false));
        }
        return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
    }

    public IELParamValue getArrayAttribute(String attributeName, List<DVTNumber> arguments, DVTNumber parentNumber, IRfNamedElement parentAssocType) {
        if (parentNumber instanceof DVTUnpackedArray) {
            DVTUnpackedArray array = (DVTUnpackedArray)parentNumber;
            int argumentValue = arguments == null || arguments.isEmpty() ? 1 : arguments.get(0).intValue();
            while (argumentValue > 1) {
                DVTNumber elementType = array.getElementType();
                if (!(elementType instanceof DVTUnpackedArray)) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                array = (DVTUnpackedArray)elementType;
                --argumentValue;
            }
            if ("LENGTH".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.getArraySize())));
            }
            if ("LEFT".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.getLeft())));
            }
            if ("RIGHT".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(array.getRight())));
            }
            if ("HIGH".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.max(array.getLeft(), array.getRight()))));
            }
            if ("LOW".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(Math.min(array.getLeft(), array.getRight()))));
            }
            if ("RANGE".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)array.getArraySize(), (int)0, (int[])new int[]{array.getLeft(), array.getRight()}, (boolean)false));
            }
        } else if (parentNumber instanceof VlogBitVector) {
            VlogBitVector number = (VlogBitVector)parentNumber;
            if (!number.isString() && number.getArrayDimensions().length <= 2 && parentAssocType instanceof RfType) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            int argumentValue = arguments == null || arguments.isEmpty() ? 1 : arguments.get(0).intValue();
            while (argumentValue > 1) {
                VlogBitVector elementType = number.decreaseDimension();
                if (elementType == null) {
                    return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
                }
                number = elementType;
                --argumentValue;
            }
            int[] firstDimension = number.getFirstDimension();
            if ("LENGTH".equalsIgnoreCase(attributeName)) {
                if (number.isString() && firstDimension[0] == firstDimension[1]) {
                    return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO);
                }
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(number.getArraySize())));
            }
            if ("LEFT".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(firstDimension != null ? firstDimension[0] : 0)));
            }
            if ("RIGHT".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(firstDimension != null ? firstDimension[1] : 0)));
            }
            if ("HIGH".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(firstDimension != null ? Math.max(firstDimension[0], firstDimension[1]) : 0)));
            }
            if ("LOW".equalsIgnoreCase(attributeName)) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)31, (int)0, (BigInteger)BigInteger.valueOf(firstDimension != null ? Math.min(firstDimension[0], firstDimension[1]) : 0)));
            }
            if ("RANGE".equalsIgnoreCase(attributeName) && firstDimension != null) {
                return ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.create((boolean)true, (int)Math.abs(firstDimension[0] - firstDimension[1]), (int)0, (int[])new int[]{firstDimension[0], firstDimension[1]}, (boolean)false));
            }
            return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
        }
        return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
    }

    public MethodCall getMethodCall(IHidEvaluationGuardian guardian) {
        List<MethodCall> calls = this.getMethodCalls(guardian);
        return calls != null && !calls.isEmpty() ? calls.get(0) : null;
    }

    public IHidOperator getWithClause() {
        return null;
    }

    public boolean isAttributeAccess() {
        return this.accessKind == 5;
    }

    public boolean isAttributeAccess1Step() {
        boolean result = this.isAttributeAccess();
        if (result) {
            return true;
        }
        if (this.getParentHid() == null || this.getParentHid().getParentAccess() == null) {
            return result;
        }
        return this.getParentHid().getParentAccess().isAttributeAccess();
    }

    public final RfHidAccess deepCopy() {
        RfHidAccess result = new RfHidAccess(this.accessKind, (ListContainer<IHidObject>)this.selectsContainer);
        if (!this.isHidObjectsEmpty()) {
            for (Hid hid : this.hidsContainer) {
                result.addHid(hid.deepCopy());
            }
        }
        return result;
    }

    public RfHidAccess upwardsCopy(boolean addResolved) {
        RfHidAccess result = new RfHidAccess(this.accessKind, (ListContainer<IHidObject>)this.selectsContainer);
        if (addResolved) {
            result.associatedType = this.associatedType;
        }
        if (this.parentHid != null) {
            result.parentHid = this.parentHid.upwardsCopy(addResolved);
            result.parentHid.addAccess((HidAccess)result);
        }
        return result;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }
}

