/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;

public class RfHidHolder
extends HidHolder {
    private static final long serialVersionUID = 80L;

    public RfHidHolder(IRfNamedElement scope) {
        super(scope);
    }

    public void resolveHids(ConfigInfo configInfo, IRfNamedElement scope, boolean triggerError) throws BuildCancelException {
        ((RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature")).checkBuildCanceled();
        RfProject.debugDelay();
        if (!this.resolveHidsCheck()) {
            return;
        }
        Iterator entryIterator = this.hidObjectsMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            boolean resolveFormalPart;
            Map.Entry hidsMapEntry = entryIterator.next();
            ParserPath parserPath = (ParserPath)hidsMapEntry.getKey();
            ListContainer hidObjectsContainer = (ListContainer)hidsMapEntry.getValue();
            boolean bl = resolveFormalPart = scope instanceof RfConfigurationRule || scope instanceof RfConfiguration;
            if (hidObjectsContainer instanceof List) {
                for (IHidObject hid : hidObjectsContainer) {
                    if (!(hid instanceof RfHid)) continue;
                    ((RfHid)hid).resolveHids(configInfo, false, triggerError, scope, scope, null, parserPath, resolveFormalPart);
                }
                if (hidObjectsContainer.size() == 1) {
                    hidsMapEntry.setValue((ListContainer)hidObjectsContainer.get(0));
                }
            } else if (!hidObjectsContainer.isEmpty() && hidObjectsContainer.get(0) instanceof RfHid) {
                ((RfHid)hidObjectsContainer).resolveHids(configInfo, false, triggerError, scope, scope, null, parserPath, resolveFormalPart);
            }
            if (!hidObjectsContainer.isEmpty()) continue;
            entryIterator.remove();
        }
        this.resolveHidsCheck();
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!(out instanceof PersistenceOutputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceOutputStream)out).getPersistence();
        if (persistence != null && persistence.isSaveCanceled()) {
            throw new PersistenceCancelException();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (!(in instanceof PersistenceInputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceInputStream)in).getPersistence();
        if (persistence != null) {
            persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readStart((Object)this);
        }
        in.defaultReadObject();
        if (persistence != null) {
            persistence.getBenchmark(((PersistenceInputStream)in).getPersistenceModeWrapper()).readEnd((Object)this);
        }
    }
}

