/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VhdlPhysicalUnit;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.vhdldt.model.reflection.RfAnyListType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class RfHidImplicit
extends HidImplicit
implements IRfHidImplicitLayer {
    private static final long serialVersionUID = 5L;
    private static final int CACHE_LIMIT = 1024;
    private static final List<String> STD_LOGIC_VALUES = new ArrayList<String>(Arrays.asList("'U'", "'X'", "'0'", "'1'", "'Z'", "'W'", "'L'", "'H'", "'-'"));
    public static final char ENUM_CHARACTER_WRAPPING = '\'';
    private static Map<RfHidImplicit, RfHidImplicit> cache = new LRUCache(1024);
    private static Map<Character, String> O_TRANSFORMER = new HashMap<Character, String>();
    private static Map<Character, String> X_TRANSFORMER = new HashMap<Character, String>();
    private static Set<String> O_SPECIFIER_SET = new HashSet<String>();
    private static Set<String> X_SPECIFIER_SET = new HashSet<String>();

    static {
        O_SPECIFIER_SET.add("O");
        O_SPECIFIER_SET.add("UO");
        O_SPECIFIER_SET.add("SO");
        O_TRANSFORMER.put(Character.valueOf('0'), "000");
        O_TRANSFORMER.put(Character.valueOf('1'), "001");
        O_TRANSFORMER.put(Character.valueOf('2'), "010");
        O_TRANSFORMER.put(Character.valueOf('3'), "011");
        O_TRANSFORMER.put(Character.valueOf('4'), "100");
        O_TRANSFORMER.put(Character.valueOf('5'), "101");
        O_TRANSFORMER.put(Character.valueOf('6'), "110");
        O_TRANSFORMER.put(Character.valueOf('7'), "111");
        X_TRANSFORMER.put(Character.valueOf('U'), "UUU");
        X_TRANSFORMER.put(Character.valueOf('X'), "XXX");
        X_TRANSFORMER.put(Character.valueOf('Z'), "ZZZ");
        X_TRANSFORMER.put(Character.valueOf('W'), "WWW");
        X_TRANSFORMER.put(Character.valueOf('L'), "LLL");
        X_TRANSFORMER.put(Character.valueOf('H'), "HHH");
        X_SPECIFIER_SET.add("X");
        X_SPECIFIER_SET.add("UX");
        X_SPECIFIER_SET.add("SX");
        X_TRANSFORMER.put(Character.valueOf('0'), "0000");
        X_TRANSFORMER.put(Character.valueOf('1'), "0001");
        X_TRANSFORMER.put(Character.valueOf('2'), "0010");
        X_TRANSFORMER.put(Character.valueOf('3'), "0011");
        X_TRANSFORMER.put(Character.valueOf('4'), "0100");
        X_TRANSFORMER.put(Character.valueOf('5'), "0101");
        X_TRANSFORMER.put(Character.valueOf('6'), "0110");
        X_TRANSFORMER.put(Character.valueOf('7'), "0111");
        X_TRANSFORMER.put(Character.valueOf('8'), "1000");
        X_TRANSFORMER.put(Character.valueOf('9'), "1001");
        X_TRANSFORMER.put(Character.valueOf('A'), "1010");
        X_TRANSFORMER.put(Character.valueOf('B'), "1011");
        X_TRANSFORMER.put(Character.valueOf('C'), "1100");
        X_TRANSFORMER.put(Character.valueOf('D'), "1101");
        X_TRANSFORMER.put(Character.valueOf('E'), "1110");
        X_TRANSFORMER.put(Character.valueOf('F'), "1111");
        X_TRANSFORMER.put(Character.valueOf('U'), "UUUU");
        X_TRANSFORMER.put(Character.valueOf('X'), "XXXX");
        X_TRANSFORMER.put(Character.valueOf('Z'), "ZZZZ");
        X_TRANSFORMER.put(Character.valueOf('W'), "WWWW");
        X_TRANSFORMER.put(Character.valueOf('L'), "LLLL");
        X_TRANSFORMER.put(Character.valueOf('H'), "HHHH");
    }

    private static RfHidImplicit getFromCache(RfHidImplicit implicit) {
        if (implicit == null) {
            return null;
        }
        RfHidImplicit found = cache.get(implicit);
        if (found == null) {
            found = implicit;
            cache.put(implicit, implicit);
        }
        return found;
    }

    public static RfHidImplicit makeImplicit(String text, int type) {
        return RfHidImplicit.getFromCache(new RfHidImplicit(text, type));
    }

    private RfHidImplicit(String name, int type) {
        super(name, type);
    }

    public Number parseNumberValue() {
        return this.isNumber() ? (Number)DVTStringUtil.parseNumberVHDL((String)this.name, null) : (Number)null;
    }

    public String guessTypeName(boolean translateType) {
        int type = this.getType();
        switch (type) {
            case 181: {
                if (this.name != null && STD_LOGIC_VALUES.contains(this.name)) {
                    return "STD_LOGIC";
                }
                return "CHARACTER";
            }
            case 242: {
                return translateType ? "CHARACTER" : "STRING";
            }
            case 180: {
                return "INTEGER";
            }
            case 243: {
                return "INTEGER";
            }
            case 184: {
                return translateType ? "INTEGER" : "STD_LOGIC_VECTOR";
            }
        }
        return null;
    }

    @NotNull
    public Collection<IRfNamedElement> guessCharacterType(RfNamedElement scope) {
        if (!this.isCharacter()) {
            return Collections.emptyList();
        }
        Collection<IRfNamedElement> candidates = STransformer.INSTANCE.checkImplicitEnumValue(this.getName(), scope, false);
        return candidates;
    }

    @NotNull
    private Collection<IRfNamedElement> guessPhysicalType(RfNamedElement scope) {
        if (!this.isPhysicalUnit()) {
            return Collections.emptyList();
        }
        Collection<IRfNamedElement> candidates = STransformer.INSTANCE.checkImplicitEnumValue(this.getPhysicalUnitName(), scope, true);
        return candidates;
    }

    private String getPhysicalUnitName() {
        if (!this.isPhysicalUnit()) {
            return null;
        }
        String implicitName = this.getName();
        int unitNameStartIndex = implicitName.indexOf(32);
        return unitNameStartIndex >= 0 && unitNameStartIndex < implicitName.length() ? implicitName.substring(unitNameStartIndex + 1) : null;
    }

    private String getPhysicalUnitValue() {
        if (!this.isPhysicalUnit()) {
            return null;
        }
        String implicitName = this.getName();
        int unitNameStartIndex = implicitName.indexOf(32);
        return unitNameStartIndex >= 0 && unitNameStartIndex < implicitName.length() ? implicitName.substring(0, unitNameStartIndex) : null;
    }

    public IRfNamedElement guessType(IRfNamedElement contextType, RfNamedElement scope, RfProject rfProject, boolean resolveCharacterArrays) {
        if (this.type == IHidImplicitConstants.ImplicitType.PHYSICAL_UNIT.id) {
            Collection<IRfNamedElement> candidates = this.guessPhysicalType(scope);
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            STransformer.INSTANCE.reducePossibilitiesByContext(candidates, contextType);
            if (candidates.size() == 1) {
                return candidates.iterator().next();
            }
            return new RfAssociatedType.RfUnresolvedInfo(this.getName(), null, candidates);
        }
        if (this.type == 181) {
            Collection<IRfNamedElement> candidates = this.guessCharacterType(scope);
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            STransformer.INSTANCE.reducePossibilitiesByContext(candidates, contextType);
            if (candidates.size() == 1) {
                return candidates.iterator().next();
            }
            return new RfAssociatedType.RfUnresolvedInfo(this.getName(), null, candidates);
        }
        if (this.type == 184 || this.type == 242) {
            String expandedName = this.getExpandedValue();
            if (expandedName == null) {
                return null;
            }
            String implicitText = new String(expandedName.getBytes(), StandardCharsets.ISO_8859_1);
            int actualLength = implicitText.length();
            if (resolveCharacterArrays) {
                if (contextType == null) {
                    return new RfAnyListType("character_vector", rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER), true, implicitText, scope);
                }
                IRfNamedElement listType = STransformer.INSTANCE.getBaseType(contextType, false);
                if (!(listType instanceof RfListType)) {
                    return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING);
                }
                IRfNamedElement listElementType = ((RfListType)listType).getResolvedType(true);
                if (listElementType == null || listElementType instanceof RfAssociatedType.RfUnresolvedInfo) {
                    return new RfAnyListType("character_vector", rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER), true, implicitText, scope);
                }
                Map<String, IRfNamedElement> enumNames = null;
                if (listElementType instanceof RfScalarType && ((enumNames = ((RfScalarType)listElementType).getEnumNames()) == null || enumNames.isEmpty())) {
                    return new RfAnyListType("character_vector", rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER), true, implicitText, scope);
                }
                int i = 0;
                while (i < actualLength) {
                    String charAt = "" + '\'' + implicitText.charAt(i) + '\'';
                    if (enumNames != null && !enumNames.containsKey(charAt)) {
                        return new RfAssociatedType.RfUnresolvedInfo(String.valueOf(implicitText.charAt(i)), listElementType, null);
                    }
                    if (enumNames == null || i == 0) {
                        Collection<IRfNamedElement> enumCandidates = STransformer.INSTANCE.checkImplicitEnumValue(charAt, scope, this.isPhysicalUnit());
                        STransformer.INSTANCE.reducePossibilitiesByContext(enumCandidates, listElementType);
                        if (enumCandidates == null || enumCandidates.isEmpty()) {
                            return new RfAssociatedType.RfUnresolvedInfo(String.valueOf(implicitText.charAt(i)), listElementType, null);
                        }
                    }
                    ++i;
                }
                return contextType;
            }
            return this.type == 242 ? rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING) : rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.INTEGER);
        }
        if (this.type == 180 || this.type == 243) {
            Number value = this.parseNumberValue();
            if (value instanceof Float) {
                return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.REAL);
            }
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.INTEGER);
        }
        return null;
    }

    private IRfNamedElement resolveCharacterArraysIn87(String implicitText, RfProject rfProject, IRfNamedElement originalContextType, RfNamedElement scope) {
        IRfNamedElement bitType;
        IRfNamedElement listElementType;
        IRfNamedElement listType;
        IRfNamedElement contextType = null;
        if (originalContextType != null && (listType = STransformer.INSTANCE.getBaseType(originalContextType, false)) instanceof RfListType && (listElementType = ((RfListType)listType).getResolvedType(true)) != null && !(listElementType instanceof RfAssociatedType.RfUnresolvedInfo)) {
            contextType = listElementType;
        }
        if (!((bitType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT)) instanceof RfScalarType)) {
            return null;
        }
        Map<String, IRfNamedElement> enumNames = ((RfScalarType)bitType).getEnumNames();
        if (enumNames == null || enumNames.isEmpty()) {
            return null;
        }
        IRfNamedElement charType = rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.CHARACTER);
        if (contextType != null && !contextType.equals(bitType) && !contextType.equals(charType)) {
            return null;
        }
        if (implicitText.isEmpty()) {
            return originalContextType != null ? originalContextType : rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING);
        }
        int i = 0;
        while (i < implicitText.length()) {
            String charAt = "" + '\'' + implicitText.charAt(i) + '\'';
            if (!enumNames.containsKey(charAt)) {
                return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING);
            }
            if (i == 0) {
                Collection<IRfNamedElement> enumCandidates = STransformer.INSTANCE.checkImplicitEnumValue(charAt, scope, this.isPhysicalUnit());
                boolean foundBit = false;
                for (IRfNamedElement enumCandidate : enumCandidates) {
                    if (!(enumCandidate instanceof RfEnum) || !bitType.equals(((RfEnum)enumCandidate).getParentEnumType())) continue;
                    foundBit = true;
                    break;
                }
                if (!foundBit) {
                    return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING);
                }
            }
            ++i;
        }
        return originalContextType != null ? originalContextType : rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT_VECTOR);
    }

    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip((IHidObject)this)) {
            throw new SkippedHidObjectEvaluationException((IHidObject)this);
        }
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        if (this.isID()) {
            if (context == null) {
                return evaluator.getValue((IHid)this, context, guardian);
            }
            IRfNamedElement origin = context.getOrigin();
            if (origin == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            IRfNamedElement resolvedElement = origin.semanticGetMember(this.getName(), null, null, origin, null, true, true, false);
            if (resolvedElement == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            Hid dummyTypeHid = STransformer.BUILDERS.buildHid(this.name, resolvedElement, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            if (dummyTypeHid == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            return evaluator.getValue((IHid)dummyTypeHid, context, guardian);
        }
        if (this.isCharacter()) {
            boolean isSTDULOGIC;
            HashSet<IRfNamedElement> visited;
            IRfNamedElement associatedType;
            if (context == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            if (context.isString()) {
                try {
                    int nofBits = 8;
                    byte[] specifiedBytes = String.valueOf(this.name.charAt(1)).getBytes(IDVTConstants.ASCII);
                    if (specifiedBytes == null) {
                        throw new UnknownHidObjectEvaluationException((IHidObject)this);
                    }
                    try {
                        int[] nArray = new int[2];
                        nArray[0] = nofBits - 1;
                        VlogBitVector result = VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])nArray, (boolean)false, (boolean)true, (BigInteger)new BigInteger(specifiedBytes));
                        return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)context.transform((DVTNumber)result)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new UnknownHidObjectEvaluationException((IHidObject)this);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (!((associatedType = this.unpackAssociatedType(context, visited = new HashSet<IRfNamedElement>())) instanceof RfScalarType) || !((RfScalarType)associatedType).isEnumType()) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            RfScalarType enumType = (RfScalarType)associatedType;
            RfNamedElement enumTypeEnclosingScope = enumType.getEnclosingScope();
            int nofEnumValues = enumType.getEnumNames().size();
            boolean bl = isSTDULOGIC = "STD_ULOGIC".equalsIgnoreCase(enumType.getName()) && 9 == nofEnumValues;
            if (isSTDULOGIC) {
                return ELParamValueScope.of((IELParamValue)this.evaluateStdLogicArrayOrCharacter(this.name, context));
            }
            int nofBits = (int)StrictMath.ceil(StrictMath.log(nofEnumValues) / StrictMath.log(2.0));
            DVTNumber charResult = this.evaluateCharacterValue(this.name.charAt(1), enumTypeEnclosingScope, enumType, evaluator, context, guardian, isSTDULOGIC, nofBits);
            if (charResult == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            if (DVTNumber.isUndefined((DVTNumber)charResult) || !(charResult instanceof VlogBitVector)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)charResult));
        }
        if (this.isPhysicalUnit()) {
            String physicalUnitValue = this.getPhysicalUnitValue();
            Number number = DVTStringUtil.parseNumberVHDL((String)physicalUnitValue, null);
            if (!(number instanceof BigInteger)) {
                Double valueOf = StrictMath.ceil(Double.valueOf(physicalUnitValue));
                return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)new VhdlPhysicalUnit(this.getPhysicalUnitName(), valueOf.intValue())));
            }
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)new VhdlPhysicalUnit(this.getPhysicalUnitName(), number.intValue())));
        }
        if (this.isBitBaseStringLiteral() || this.isStringLiteral()) {
            String value = this.getExpandedValue();
            if (context != null && (context.isString() || context.isNoContext() && this.isStringLiteral())) {
                try {
                    if (value.isEmpty()) {
                        return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)context.transform((DVTNumber)VlogBitVector.create((boolean)true, (int)0, (int)0, (BigInteger)BigInteger.ZERO))));
                    }
                    int nofBits = value.length() * 8;
                    byte[] specifiedBytes = value.getBytes(IDVTConstants.ASCII);
                    if (specifiedBytes == null) {
                        throw new UnknownHidObjectEvaluationException((IHidObject)this);
                    }
                    try {
                        VlogBitVector result = VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])new int[]{1, nofBits}, (boolean)false, (boolean)true, (BigInteger)new BigInteger(specifiedBytes));
                        return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)context.transform((DVTNumber)result)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new UnknownHidObjectEvaluationException((IHidObject)this);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
            }
            if (context != null) {
                int nofBits;
                HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
                IRfNamedElement associatedType = this.unpackAssociatedType(context, visited);
                if (!(associatedType instanceof RfScalarType) || !((RfScalarType)associatedType).isEnumType()) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
                RfScalarType enumType = (RfScalarType)associatedType;
                RfNamedElement enumTypeEnclosingScope = enumType.getEnclosingScope();
                int nofEnumValues = enumType.getEnumNames().size();
                boolean isSTDULOGIC = "STD_ULOGIC".equalsIgnoreCase(enumType.getName()) && 9 == nofEnumValues;
                int n = nofBits = isSTDULOGIC ? 1 : (int)StrictMath.ceil(StrictMath.log(nofEnumValues) / StrictMath.log(2.0));
                if (context.getContextNumber() instanceof VlogBitVector) {
                    if (isSTDULOGIC) {
                        return ELParamValueScope.of((IELParamValue)this.evaluateStdLogicArrayOrCharacter(value, context));
                    }
                    ArrayList<VlogBitVector> result = new ArrayList<VlogBitVector>();
                    int i = 0;
                    while (i < value.length()) {
                        char c = value.charAt(i);
                        DVTNumber charResult = this.evaluateCharacterValue(c, enumTypeEnclosingScope, enumType, evaluator, context, guardian, isSTDULOGIC, nofBits);
                        if (charResult == null) {
                            throw new UnknownHidObjectEvaluationException((IHidObject)this);
                        }
                        if (DVTNumber.isUndefined((DVTNumber)charResult) || !(charResult instanceof VlogBitVector)) {
                            return ELParamValueScope.UNDEFINED_VALUE;
                        }
                        result.add((VlogBitVector)charResult);
                        ++i;
                    }
                    int[] nArray = new int[4];
                    nArray[1] = value.length() - 1;
                    nArray[2] = nofBits - 1;
                    VlogBitVector mergeBitVector = VlogBitVector.mergeBitVector((int)nofBits, result, (int[])nArray);
                    return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)context.transform((DVTNumber)mergeBitVector)));
                }
                if (context.isUnpackedArrayContext()) {
                    return ELParamValueScope.of((IELParamValue)this.makeUnpackedArray(evaluator, context, value, isSTDULOGIC, nofBits, enumType, enumTypeEnclosingScope, guardian));
                }
            }
        }
        if (this.isNumber()) {
            Number number = this.parseNumberValue();
            if (!(number instanceof BigInteger)) {
                try {
                    String nameWithoutUnderscores = this.name.replace("_", "");
                    VlogRealNumber result = new VlogRealNumber(Double.parseDouble(nameWithoutUnderscores));
                    return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)result));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UnknownHidObjectEvaluationException((IHidObject)this);
                }
            }
            VlogBitVector result = VlogBitVector.create((boolean)true, (int)31, (int)0, null, (boolean)false, (boolean)false, (BigInteger)((BigInteger)number));
            return ELParamValueScope.of((IELParamValue)ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)result) : result)));
        }
        throw new UnknownHidObjectEvaluationException((IHidObject)this);
    }

    private IELParamValue makeUnpackedArray(IHidEvaluator evaluator, BitVectorContext context, String value, boolean isSTDULOGIC, int nofBits, RfScalarType enumType, RfNamedElement enumTypeEnclosingScope, IHidEvaluationGuardian guardian) {
        DVTNumber contextNumber = context.getContextNumber();
        if (!(contextNumber instanceof DVTUnpackedArray)) {
            return null;
        }
        DVTUnpackedArray arrayContext = (DVTUnpackedArray)contextNumber;
        int patternSize = value.length();
        int[] firstDimension = arrayContext.getFirstDimension();
        if (firstDimension == null) {
            return null;
        }
        DVTNumber[] result = new DVTNumber[value.length()];
        DVTNumber newContextNumber = arrayContext.decreaseDimension();
        if (newContextNumber == null) {
            throw new UnknownHidObjectEvaluationException((IHidObject)this);
        }
        boolean isAnyDimensionContext = firstDimension[0] == -1 && firstDimension[1] == -1;
        int minDimension = isAnyDimensionContext ? 1 : Math.min(firstDimension[0], firstDimension[1]);
        int maxDimension = isAnyDimensionContext ? patternSize : Math.max(firstDimension[0], firstDimension[1]);
        int dimensionSize = maxDimension - minDimension + 1;
        int position = -1;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (++position > dimensionSize - 1) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            DVTNumber charResult = this.evaluateCharacterValue(c, enumTypeEnclosingScope, enumType, evaluator, context, guardian, isSTDULOGIC, nofBits);
            if (DVTNumber.isUndefined((DVTNumber)charResult)) {
                return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
            }
            if (charResult == null) {
                throw new UnknownHidObjectEvaluationException((IHidObject)this);
            }
            result[i] = charResult;
            ++i;
        }
        int newLeft = isAnyDimensionContext ? 0 : firstDimension[0];
        int newRight = isAnyDimensionContext ? result.length - 1 : firstDimension[1];
        return ELParamValues.ParamValueNumber.of((DVTNumber)new DVTUnpackedArray(newLeft, newRight, newContextNumber, result));
    }

    private DVTNumber evaluateCharacterValue(char c, RfNamedElement enumTypeEnclosingScope, RfScalarType enumType, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian, boolean isSTDULOGIC, int nofBits) {
        int ordinal;
        if (isSTDULOGIC) {
            if ('1' == c) {
                return VlogBitVector.create((boolean)false, (int)0, (int)0, (int[])new int[2], (boolean)false, (boolean)false, (BigInteger)BigInteger.ONE);
            }
            return VlogBitVector.create((boolean)false, (int)0, (int)0, (int[])new int[2], (boolean)false, (boolean)false, (BigInteger)BigInteger.ZERO);
        }
        String charEnumString = "'" + c + "'";
        RfEnum enumValue = enumTypeEnclosingScope.getLocalEnum(charEnumString, enumType.getName(), false);
        BigInteger ordinalValue = null;
        ordinalValue = enumValue instanceof RfEnum ? ((ordinal = enumValue.getOrdinal()) < 0 ? this.getOrdinalValue(charEnumString, enumValue, evaluator, context, guardian) : BigInteger.valueOf(ordinal)) : this.getOrdinalValue(charEnumString, enumValue, evaluator, context, guardian);
        if (ordinalValue == null) {
            return DVTNumber.UNDEFINED;
        }
        int[] nArray = new int[2];
        nArray[0] = nofBits - 1;
        return VlogBitVector.create((boolean)false, (int)(nofBits - 1), (int)0, (int[])nArray, (boolean)false, (boolean)false, (BigInteger)ordinalValue);
    }

    private BigInteger getOrdinalValue(String charEnumString, IRfNamedElement enumValue, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        IELParamValue enumTypeIndexValue = XUtils.getValue((ELParamValueScope)evaluator.getValue((IHid)STransformer.BUILDERS.buildHid(charEnumString, enumValue, HidOccurrence.DUMMY_OCCURRENCE, 0L), context, guardian));
        if (ELUtils.isUnsuccessfulEval((IELParamValue)enumTypeIndexValue) || DVTNumber.isUndefined((DVTNumber)enumTypeIndexValue.getDVTNumber())) {
            return null;
        }
        return enumTypeIndexValue.getDVTNumber().bigIntegerValue();
    }

    private IRfNamedElement unpackAssociatedType(BitVectorContext ctxt, Set<IRfNamedElement> visited) {
        if (ctxt.getContextNumber() instanceof VhdlEnum) {
            return ((VhdlEnum)ctxt.getContextNumber()).getEnumValue();
        }
        IRfNamedElement origin = ctxt.getOrigin();
        IRfNamedElement context = origin instanceof RfAssociatedType ? ((RfAssociatedType)origin).getAssociatedType() : origin;
        while (context instanceof RfType) {
            if (visited.contains(context)) {
                return null;
            }
            visited.add(context);
            while (((RfType)context).isSubtype()) {
                if (!((context = ((RfType)context).getAssociatedType()) instanceof RfType)) {
                    return null;
                }
                if (visited.contains(context)) {
                    return null;
                }
                visited.add(context);
            }
            if (!(context instanceof RfListType)) break;
            context = ((RfListType)context).getAssociatedElementType();
        }
        return context;
    }

    private IELParamValue evaluateStdLogicArrayOrCharacter(String value, BitVectorContext context) {
        EnumMap<MaskType, BitSet> masks = new EnumMap<MaskType, BitSet>(MaskType.class);
        int[] numberLength = new int[1];
        Number number = this.parseStdLogic(value, null, masks, numberLength);
        if (number == null) {
            return ELParamValues.ParamValueNumber.UNDEFINED_VALUE;
        }
        if (masks.isEmpty()) {
            masks = null;
        }
        int[] nArray = new int[4];
        nArray[0] = numberLength[0] - 1;
        VlogBitVector result = VlogBitVector.create((boolean)false, (int)(numberLength[0] - 1), (int)0, (int[])nArray, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, masks, (BigInteger)((BigInteger)number));
        return ELParamValues.ParamValueNumber.of((DVTNumber)(context != null ? context.transform((DVTNumber)result) : result));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Number parseStdLogic(String text, Number defaultValue, EnumMap<MaskType, BitSet> masks, int[] nofBits) {
        if (text == null) {
            return defaultValue;
        }
        StringBuilder number = new StringBuilder();
        int numberBase = 2;
        BitSet xMask = BitSetUtils.valueOf((int)0);
        BitSet zMask = BitSetUtils.valueOf((int)0);
        BitSet hMask = BitSetUtils.valueOf((int)0);
        BitSet lMask = BitSetUtils.valueOf((int)0);
        BitSet uMask = BitSetUtils.valueOf((int)0);
        BitSet wMask = BitSetUtils.valueOf((int)0);
        BitSet dashMask = BitSetUtils.valueOf((int)0);
        try {
            BitSet dashMaskNumber;
            BitSet wMaskNumber;
            BitSet uMaskNumber;
            BitSet lMaskNumber;
            BitSet hMaskNumber;
            BitSet zMaskNumber;
            int length = text.length();
            int i = 0;
            while (true) {
                if (i >= length) {
                    if (number.length() != 0) break;
                    return defaultValue;
                }
                char currChar = text.charAt(i);
                if (currChar != '_' && currChar != '\'') {
                    if (Character.isDigit(currChar)) {
                        number.append(currChar);
                        nofBits[0] = nofBits[0] + 1;
                    } else {
                        int currentIndex = number.length();
                        if (currChar == 'X' || currChar == 'x') {
                            xMask.set(currentIndex);
                            number.append("0");
                        } else if (currChar == 'Z' || currChar == 'z') {
                            zMask.set(currentIndex);
                            number.append("0");
                        } else if (currChar == 'H' || currChar == 'h') {
                            hMask.set(currentIndex);
                            number.append("1");
                        } else if (currChar == 'L' || currChar == 'l') {
                            lMask.set(currentIndex);
                            number.append("0");
                        } else if (currChar == 'U' || currChar == 'u') {
                            uMask.set(currentIndex);
                            number.append("0");
                        } else if (currChar == 'W' || currChar == 'w') {
                            wMask.set(currentIndex);
                            number.append("0");
                        } else {
                            if (currChar != '-') {
                                return null;
                            }
                            dashMask.set(currentIndex);
                            number.append("0");
                        }
                        nofBits[0] = nofBits[0] + 1;
                    }
                }
                ++i;
            }
            int numberLength = number.length();
            BitSet xMaskNumber = this.reverseMask(xMask, numberLength);
            if (!xMaskNumber.isEmpty()) {
                masks.put(MaskType.X, VlogBitVector.createMask((int)nofBits[0], (BitSet)xMaskNumber));
            }
            if (!(zMaskNumber = this.reverseMask(zMask, numberLength)).isEmpty()) {
                masks.put(MaskType.Z, VlogBitVector.createMask((int)nofBits[0], (BitSet)zMaskNumber));
            }
            if (!(hMaskNumber = this.reverseMask(hMask, numberLength)).isEmpty()) {
                masks.put(MaskType.H, VlogBitVector.createMask((int)nofBits[0], (BitSet)hMaskNumber));
            }
            if (!(lMaskNumber = this.reverseMask(lMask, numberLength)).isEmpty()) {
                masks.put(MaskType.L, VlogBitVector.createMask((int)nofBits[0], (BitSet)lMaskNumber));
            }
            if (!(uMaskNumber = this.reverseMask(uMask, numberLength)).isEmpty()) {
                masks.put(MaskType.U, VlogBitVector.createMask((int)nofBits[0], (BitSet)uMaskNumber));
            }
            if (!(wMaskNumber = this.reverseMask(wMask, numberLength)).isEmpty()) {
                masks.put(MaskType.W, VlogBitVector.createMask((int)nofBits[0], (BitSet)wMaskNumber));
            }
            if (!(dashMaskNumber = this.reverseMask(dashMask, numberLength)).isEmpty()) {
                masks.put(MaskType.DASH, VlogBitVector.createMask((int)nofBits[0], (BitSet)dashMaskNumber));
            }
            return new BigInteger(number.toString(), numberBase);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private BitSet reverseMask(BitSet mask, int numberLength) {
        BitSet result = BitSetUtils.valueOf((int)0);
        int i = 0;
        while (i < numberLength) {
            if (mask.get(i)) {
                result.set(numberLength - i - 1);
            }
            ++i;
        }
        return result;
    }

    public String getExpandedValue() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return name;
        }
        int implicitStartIndex = name.indexOf("\"");
        int implicitEndIndex = name.lastIndexOf("\"");
        boolean signed = false;
        StringBuilder expandedValue = new StringBuilder();
        if (!name.startsWith("\"")) {
            int specifiedLength;
            name = name.toUpperCase();
            int lengthEnd = 0;
            while (Character.isDigit(name.charAt(lengthEnd))) {
                ++lengthEnd;
            }
            String baseIndicator = name.substring(lengthEnd, implicitStartIndex);
            signed |= baseIndicator.length() == 2 && Character.toLowerCase(baseIndicator.charAt(0)) == 's';
            int n = specifiedLength = lengthEnd > 0 ? Integer.parseInt(name.substring(0, lengthEnd)) : -1;
            if ("D".equals(baseIndicator)) {
                Number number = this.parseNumberValue();
                String binaryString = Integer.toBinaryString(number.intValue());
                return this.resize(binaryString, specifiedLength, signed);
            }
            int i = implicitStartIndex + 1;
            while (i < implicitEndIndex) {
                if ('_' != name.charAt(i)) {
                    expandedValue.append(this.getCharacterExpansion(name.charAt(i), baseIndicator));
                }
                ++i;
            }
            return this.resize(expandedValue.toString(), specifiedLength, signed);
        }
        return name.substring(1, name.length() - 1);
    }

    private String resize(String value, int size, boolean signed) {
        if (value == null || value.isEmpty() || size < 0 || size == value.length()) {
            return value;
        }
        StringBuilder result = new StringBuilder(value);
        if (size > value.length()) {
            int paddingSize = size - value.length();
            String expansion = new String(new char[paddingSize]).replace('\u0000', signed ? value.charAt(0) : (char)'0');
            result.insert(0, expansion);
            return result.toString();
        }
        return result.substring(value.length() - size);
    }

    private String getCharacterExpansion(char c, String baseIndicator) {
        if (baseIndicator == null) {
            return String.valueOf(c);
        }
        if (O_SPECIFIER_SET.contains(baseIndicator) && O_TRANSFORMER.containsKey(Character.valueOf(c))) {
            return O_TRANSFORMER.get(Character.valueOf(c));
        }
        if (X_SPECIFIER_SET.contains(baseIndicator) && X_TRANSFORMER.containsKey(Character.valueOf(c))) {
            return X_TRANSFORMER.get(Character.valueOf(c));
        }
        return String.valueOf(c);
    }

    public IHid xToHid(IRfNamedElement enclosingScope, HidOccurrence occurrence) {
        return new RfHid(this.getName(), null, enclosingScope.getLocalMember(null, this.getName(), null), occurrence, null);
    }
}

