/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;

public interface RfHidUtils {
    public static final Set<HidFlatteningOption> GUESS_TYPE_FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS_NO_SELECT = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));

    @NotNull
    public static String guessVarTypeFromHids(Set<IHid> hids, boolean translateType) {
        if (hids == null) {
            return RfHidUtils.getDefaultTypeName();
        }
        for (IHid hid : hids) {
            String assocName;
            RfFunction functionCandidate;
            if (hid instanceof RfHidImplicit) {
                String typeName = ((RfHidImplicit)hid).guessTypeName(translateType);
                return typeName != null ? typeName : RfHidUtils.getDefaultTypeName();
            }
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfEnum) {
                return ((RfEnum)element).getParentEnumTypeName();
            }
            if (element instanceof RfFunctionsHolder && (functionCandidate = ((RfFunctionsHolder)element).getLastDefinedFunction()) != null) {
                element = functionCandidate;
            }
            if (!(element instanceof RfAssociatedType)) continue;
            String string = assocName = translateType ? RfHidUtils.getAssocBaseType((RfAssociatedType)element) : ((RfAssociatedType)element).getAssociatedTypeName();
            if (assocName == null || assocName.isEmpty()) continue;
            return assocName;
        }
        return RfHidUtils.getDefaultTypeName();
    }

    public static String getDefaultTypeName() {
        return "STD_LOGIC";
    }

    public static void consumeMethodCallArguments(IHid methodHid, BiConsumer<IRfNamedElement, Collection<IHid>> consumer, boolean ignoreEventControlExpr) {
        if (!HidUtils.isHid((IHidObject)methodHid) || !methodHid.isMethodCall(false) || consumer == null) {
            return;
        }
        if (!((Hid)methodHid).hasAccesses()) {
            return;
        }
        ListContainer accesses = ((Hid)methodHid).getAccesses();
        for (HidAccess access : accesses) {
            List callArguments;
            if (!(access instanceof IHidAccessArgs) || (callArguments = ((IHidAccessArgs)access).getArgumentValues()) == null || callArguments.isEmpty()) continue;
            HidOccurrence occurrence = access.getOccurrence();
            if (ignoreEventControlExpr && occurrence != null && occurrence.hasQualifier(HidQualifierCache.EVENT_CONTROL_EXPR_QUALIFIER)) continue;
            int nofArguments = callArguments.size();
            int i = 0;
            while (i < nofArguments) {
                IHidObject argumentAssociation = (IHidObject)callArguments.get(i);
                Set rhHids = MethodCallUtils.getValueHids((IHidObject)argumentAssociation, FLATTENING_OPTIONS_NO_SELECT);
                if (MethodCallUtils.isNamedConnected((IHidObject)argumentAssociation) || MethodCallUtils.isNamedUnconnected((IHidObject)argumentAssociation)) {
                    IHid lhValue = MethodCallUtils.getMethodArgumentHid((IHidObject)argumentAssociation);
                    IRfNamedElement functionArgument = HidUtils.getResolvedElement((IHidObject)lhValue);
                    consumer.accept(functionArgument, rhHids);
                } else {
                    List<RfFunction> functions;
                    IRfNamedElement methodElement = methodHid.getElement();
                    Collection<RfFunction> collection = methodElement instanceof RfFunctionsHolder ? ((RfFunctionsHolder)methodElement).getLocalMembers(RfFunction.class) : (functions = methodElement instanceof RfFunction ? Collections.singleton((RfFunction)methodElement) : null);
                    if (functions != null && !functions.isEmpty()) {
                        for (RfFunction function : functions) {
                            List<RfVariable> functionArguments = function.getArguments();
                            if (functionArguments == null || nofArguments > functionArguments.size()) continue;
                            RfVariable functionArgument = functionArguments.get(i);
                            consumer.accept(functionArgument, rhHids);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static String getAssocBaseType(IRfAssociatedType arg) {
        IRfNamedElement argAssocType = arg.getAssociatedType();
        String assocTypeName = null;
        if (argAssocType instanceof RfEnum) {
            RfEnum assocEnum = (RfEnum)argAssocType;
            assocTypeName = assocEnum.getParentEnumTypeName();
        }
        if (argAssocType instanceof RfType) {
            String type = ((RfType)argAssocType).getAssociatedTypeName();
            assocTypeName = type.isEmpty() ? argAssocType.getName() : type;
        }
        return assocTypeName == null || assocTypeName.isEmpty() ? arg.getAssociatedTypeName() : assocTypeName;
    }
}

