/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.BaseConfigInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrenceBounds;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.util.GenericValueUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class SAggregateOperation
extends SOperation {
    public boolean isMultipleElementChoice(IHidObject formalPart) {
        return formalPart instanceof RfHidOperator && ((RfHidOperator)formalPart).isBar();
    }

    public boolean isOthersChoice(IHidObject formalPart) {
        return HidUtils.isHidImplicit((IHidObject)formalPart) && ((HidImplicit)formalPart).isOthers();
    }

    public IRfNamedElement checkMultipleElementChoice(boolean isRecord, IHidObject formalPart, Set<RfVariable> alreadyChecked, RfRecordType aggregateType, SEvaluator.VhdlSemanticOperatorVisitor visitor) {
        RfHidOperator multipleOperator = (RfHidOperator)formalPart;
        ListContainer choices = multipleOperator.getRHValues();
        IRfNamedElement finalCorrespondent = null;
        int i = choices.size() - 1;
        while (i >= 0) {
            IHidObject choice = (IHidObject)choices.get(i);
            if (!this.checkSimpleFormalPart(isRecord, choice)) {
                visitor.reportError(choice, "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not a simple name", HidUtils.toNiceStringVHDL((IHidObject)choice));
                return null;
            }
            String correspondentName = ((Hid)choice).getName();
            RfVariable recordElement = aggregateType.getLocalMember(RfVariable.class, correspondentName);
            if (recordElement == null) {
                visitor.reportError(choice, "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not an element of record type ''{1}''", correspondentName, aggregateType.getName());
                return null;
            }
            if (alreadyChecked.contains(recordElement)) {
                visitor.reportError(choice, "DUPLICATE_RECORD_ASSOCIATION: Formal ''{0}'' is associated more than once", recordElement.getName());
                return null;
            }
            alreadyChecked.add(recordElement);
            if (finalCorrespondent != null && !finalCorrespondent.checkTypeCompatibility((IRfNamedElement)recordElement)) {
                visitor.reportError((IHidObject)multipleOperator, "INVALID_AGGREGATE: Record elements of different types were used in multiple choice ''{0}''", HidUtils.toNiceStringVHDL((IHidObject)multipleOperator));
                return null;
            }
            if (finalCorrespondent == null) {
                finalCorrespondent = STransformer.INSTANCE.getBaseType(recordElement, false);
            }
            --i;
        }
        return finalCorrespondent;
    }

    public IRfNamedElement checkOthersChoice(IHidObject formalPart, Set<RfVariable> alreadyChecked, List<RfVariable> recordVariables, SEvaluator.VhdlSemanticOperatorVisitor visitor) {
        IRfNamedElement finalCorrespondent = null;
        for (RfVariable element : recordVariables) {
            if (alreadyChecked.contains(element)) continue;
            alreadyChecked.add(element);
            if (finalCorrespondent != null && !finalCorrespondent.checkTypeCompatibility((IRfNamedElement)element)) {
                visitor.reportError(formalPart, "INVALID_AGGREGATE: Record elements of different types were used in multiple choice ''{0}''", HidUtils.toNiceStringVHDL((IHidObject)formalPart));
                return null;
            }
            if (finalCorrespondent != null) continue;
            finalCorrespondent = STransformer.INSTANCE.getBaseType(element, false);
        }
        return finalCorrespondent;
    }

    public boolean checkSimpleFormalPart(boolean isRecord, IHidObject formalPart) {
        return !isRecord || isRecord & HidUtils.isHid((IHidObject)formalPart);
    }

    public static class AssociationsAggregateTransformer {
        private boolean triggerError;
        private int elementIndex;
        private BaseConfigInfo configInfo;
        private IRfNamedElement previousElement;
        private Map<IRfNamedElement, SingleInstanceTransformer> singleInstanceTransformers;
        private RfProject rfProject;

        public static boolean needsTransformation(Deque<IHidObject> hierarchicalAssociationPath) {
            if (hierarchicalAssociationPath.isEmpty()) {
                return false;
            }
            if (hierarchicalAssociationPath.size() > 1) {
                return true;
            }
            IHidObject formalPart = GenericValueUtils.getFormalPartRaw((IHidObject)hierarchicalAssociationPath.peek(), (long)HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER);
            IHidObject rhValue = (IHidObject)((HidOperator)hierarchicalAssociationPath.peek()).getRHValues().get(0);
            return HidUtils.isHidAccess((IHidObject)formalPart) && SOperation.getOperation(formalPart, null) == SOperation.ARRAY_SELECT || HidUtils.isOperator((IHidObject)rhValue) && ((HidOperator)rhValue).isAggregate();
        }

        public AssociationsAggregateTransformer(boolean triggerError, RfProject project, BaseConfigInfo configInfo) {
            this.triggerError = triggerError;
            this.configInfo = configInfo;
            this.elementIndex = -1;
            this.singleInstanceTransformers = new OptimizedLinkedHashMap();
            this.rfProject = project;
        }

        public void addAssociation(IRfNamedElement scope, IRfNamedElement formal, IRfNamedElement formalType, HidOperatorWrapper association, Deque<IHidObject> hierarchicalAssociationPath) {
            block5: {
                this.elementIndex += formal.equals(this.previousElement) ? 0 : 1;
                this.previousElement = formal;
                SingleInstanceTransformer elementTransformer = this.singleInstanceTransformers.get(formal);
                if (elementTransformer == null) {
                    HidOperatorOccurrence occurrence = ((HidOperator)association.hidObject).getOccurrence();
                    int openBoundary = hierarchicalAssociationPath.peek() instanceof RfHid ? ((RfHid)hierarchicalAssociationPath.peek()).getOccurrence().getOffset() : occurrence.getOpenBoundary();
                    elementTransformer = new SingleInstanceTransformer(this.elementIndex, occurrence.getOffset(), occurrence.getLine(), openBoundary, association.path);
                    this.singleInstanceTransformers.put(formal, elementTransformer);
                }
                if (elementTransformer.getIndex() != this.elementIndex && !elementTransformer.isArraySelect() && !elementTransformer.isDiscontinuous()) {
                    elementTransformer.setIsDiscontinuous();
                    if (this.triggerError) {
                        this.rfProject.addSemanticError(1, "DISCONTINUOUS_ASSOCIATION: Formal ''{0}'' member associations must be consecutive", scope.getLibPkgScope(), elementTransformer.getStartOffset(), elementTransformer.getEndOffset(), null, elementTransformer.getLine(), association.path, formal.getName(), formalType.getName());
                    }
                    return;
                }
                try {
                    elementTransformer.addAssociation(association, hierarchicalAssociationPath);
                }
                catch (SingleInstanceTransformer.DuplicateAssociationException ex) {
                    elementTransformer.setHasDuplicate();
                    if (!this.triggerError) break block5;
                    this.rfProject.addSemanticError(1, "DUPLICATE_RECORD_ASSOCIATION: Formal ''{0}'' is associated more than once", scope.getLibPkgScope(), elementTransformer.getStartOffset(), elementTransformer.getEndOffset(), null, elementTransformer.getLine(), association.path, ex.getPath());
                }
            }
        }

        public Map<String, HidOperatorWrapper> getAssociations(IRfNamedElement scope) {
            IHidHolder hidHolder = scope.getHidHolder();
            LinkedHashMap<String, HidOperatorWrapper> result = new LinkedHashMap<String, HidOperatorWrapper>();
            for (Map.Entry<IRfNamedElement, SingleInstanceTransformer> transformersEntry : this.singleInstanceTransformers.entrySet()) {
                IRfNamedElement formal = transformersEntry.getKey();
                SingleInstanceTransformer transformer = transformersEntry.getValue();
                RfHidOperator associationWithAggregate = transformer.getAssociation();
                if (associationWithAggregate == null) continue;
                ParserPath path = transformer.getPath();
                associationWithAggregate.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
                if (!transformer.hasErrors()) {
                    SEvaluator.INSTANCE.calculateAssociation(new ConfigInfo(this.configInfo), this.triggerError, associationWithAggregate, formal, path, hidHolder);
                }
                result.put(formal.getLowerCaseName(), HidOperatorWrapper.of((HidOperator)associationWithAggregate, (ParserPath)path));
            }
            return result;
        }

        private static class SingleInstanceTransformer {
            private boolean isDiscontinuous;
            private boolean hasDuplicate;
            private int index;
            private OccurrenceWithPath occurrenceWithPath;
            private AssociationMaker maker;

            private static String getStructKey(IHidObject hidObject) {
                if (hidObject instanceof HidOperator) {
                    hidObject = ((HidOperator)hidObject).getLHValue();
                }
                return HidUtils.toStringBuilder((IHidObject)hidObject, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (LanguageKind)LanguageKind.VHDL).toString();
            }

            public SingleInstanceTransformer(int index, int offset, int line, int openBoundary, ParserPath path) {
                this.index = index;
                this.occurrenceWithPath = new OccurrenceWithPath();
                this.occurrenceWithPath.offset = offset;
                this.occurrenceWithPath.line = line;
                this.occurrenceWithPath.openBoundary = openBoundary;
                this.occurrenceWithPath.closeBoundary = -1;
                this.occurrenceWithPath.path = path;
            }

            public void addAssociation(HidOperatorWrapper association, Deque<IHidObject> hierarchicalAssociationPath) throws DuplicateAssociationException {
                this.occurrenceWithPath.closeBoundary = ((HidOperator)association.hidObject).getCloseBoundary();
                if (this.maker == null) {
                    boolean isArraySelect = HidUtils.isHidAccess((IHidObject)((HidOperator)association.hidObject).getLHValue()) && SOperation.getOperation(((HidOperator)association.hidObject).getLHValue(), null) == SOperation.ARRAY_SELECT;
                    this.maker = isArraySelect && hierarchicalAssociationPath.size() == 1 ? new ArrayAssociationMaker((HidAccess)((HidOperator)association.hidObject).getLHValue()) : new StructAssociationMaker(hierarchicalAssociationPath.peek(), true);
                }
                this.maker.addAssociation(hierarchicalAssociationPath);
            }

            public RfHidOperator getAssociation() {
                return this.maker.make(new HidOperatorOccurrence(this.occurrenceWithPath.offset, -1, this.occurrenceWithPath.line, new HidOccurrenceBounds(this.occurrenceWithPath.openBoundary, -1, this.occurrenceWithPath.closeBoundary, -1), 0L, null));
            }

            public int getIndex() {
                return this.index;
            }

            public ParserPath getPath() {
                return this.occurrenceWithPath.path;
            }

            public int getStartOffset() {
                return this.occurrenceWithPath.openBoundary;
            }

            public int getEndOffset() {
                return this.occurrenceWithPath.closeBoundary;
            }

            public int getLine() {
                return this.occurrenceWithPath.line;
            }

            public boolean isArraySelect() {
                return this.maker instanceof ArrayAssociationMaker;
            }

            public boolean isDiscontinuous() {
                return this.isDiscontinuous;
            }

            public boolean hasErrors() {
                return this.hasDuplicate || this.isDiscontinuous;
            }

            public void setIsDiscontinuous() {
                this.isDiscontinuous = true;
            }

            public void setHasDuplicate() {
                this.hasDuplicate = true;
            }

            private static class ArrayAssociationMaker
            implements AssociationMaker {
                IHidObject lhSide;
                List<IHidObject> associations;

                public ArrayAssociationMaker(HidAccess access) {
                    this.lhSide = access.getParentHid();
                    this.associations = new ArrayList<IHidObject>(2);
                }

                @Override
                public void addAssociation(Deque<IHidObject> hierarchicalAssociationPath) throws DuplicateAssociationException {
                    IHidObject peek = hierarchicalAssociationPath.peek();
                    if (!HidUtils.isOperator((IHidObject)peek)) {
                        return;
                    }
                    HidOperator association = (HidOperator)peek;
                    List selects = ((HidAccess)association.getLHValue()).getSelects();
                    if (selects == null || selects.isEmpty()) {
                        return;
                    }
                    this.associations.add((IHidObject)STransformer.makeStandInOperator((IHidObject)selects.get(0), Collections.singletonList((IHidObject)association.getRHValues().get(0)), association.getOperatorType(), IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=>", association.getOccurrence(), HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER));
                }

                @Override
                public RfHidOperator make(HidOperatorOccurrence occurrence) {
                    RfHidOperator aggregate = STransformer.makeStandInOperator((IHidObject)STransformer.makeStandInImplicit("(", IHidImplicitConstants.ImplicitType.VARIADIC_LIMIT.id), this.associations, 198, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, ",", occurrence, HidQualifierCache.IS_AGGREGATE_QUALIFIER);
                    return STransformer.makeStandInOperator(this.lhSide, Collections.singletonList(aggregate), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=>", occurrence, HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER);
                }
            }

            private static interface AssociationMaker {
                public void addAssociation(Deque<IHidObject> var1) throws DuplicateAssociationException;

                public RfHidOperator make(HidOperatorOccurrence var1);
            }

            public static class DuplicateAssociationException
            extends Exception {
                private static final long serialVersionUID = 1L;
                private String path;

                DuplicateAssociationException(IHidObject hidObject) {
                    this.path = String.valueOf(hidObject instanceof Hid ? ((Hid)hidObject).getHierarchicalPath().toString() : "") + "." + SingleInstanceTransformer.getStructKey(hidObject);
                }

                public String getPath() {
                    return this.path;
                }
            }

            private static class OccurrenceWithPath {
                public int offset = -1;
                public int line = -1;
                public int openBoundary = -1;
                public int closeBoundary = -1;
                public ParserPath path = null;
            }

            private static class StructAssociationMaker
            implements AssociationMaker {
                private boolean isRoot;
                private IHidObject hidObject;
                private Map<String, AssociationMaker> children;

                private StructAssociationMaker(IHidObject hidObject, boolean isRoot) {
                    this.hidObject = hidObject;
                    this.isRoot = isRoot;
                }

                @Override
                public void addAssociation(Deque<IHidObject> hierarchicalAssociationPath) throws DuplicateAssociationException {
                    hierarchicalAssociationPath.pop();
                    if (hierarchicalAssociationPath.isEmpty()) {
                        return;
                    }
                    if (this.hidObject instanceof HidOperator) {
                        throw new DuplicateAssociationException(((HidOperator)this.hidObject).getLHValue());
                    }
                    IHidObject childHidObject = hierarchicalAssociationPath.peek();
                    String childKey = SingleInstanceTransformer.getStructKey(childHidObject);
                    if (this.children == null) {
                        this.children = new OptimizedLinkedHashMap();
                        StructAssociationMaker child = new StructAssociationMaker(childHidObject, false);
                        child.addAssociation(hierarchicalAssociationPath);
                        this.children.put(childKey, child);
                    } else if (!this.children.containsKey(childKey)) {
                        StructAssociationMaker child = new StructAssociationMaker(childHidObject, false);
                        child.addAssociation(hierarchicalAssociationPath);
                        this.children.put(childKey, child);
                    } else {
                        StructAssociationMaker child = (StructAssociationMaker)this.children.get(childKey);
                        if (childHidObject instanceof HidOperator) {
                            throw new DuplicateAssociationException(((HidOperator)childHidObject).getLHValue());
                        }
                        child.addAssociation(hierarchicalAssociationPath);
                    }
                }

                @Override
                public RfHidOperator make(HidOperatorOccurrence occurrence) {
                    RfHidOperator aggregateAssociation;
                    if (this.children == null) {
                        RfHidOperator association = (RfHidOperator)this.hidObject;
                        HidOperatorOccurrence newOccurrence = new HidOperatorOccurrence(association.getOccurrence().getOffset(), association.getOccurrence().getVirtualOffset(), association.getOccurrence().getLine(), association.getOccurrence().getBounds(), HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER, association.getOccurrence().getReparseInfo());
                        aggregateAssociation = STransformer.makeStandInOperator(association.getLHValue(), OptimizedUtils.asList((ListContainer)association.getRHValues(), (boolean)true), association.getOperatorType(), association.getOperatorKind(), association.getOperatorText(), newOccurrence, this.isRoot ? HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER : HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                    } else {
                        ArrayList<IHidObject> rhValues = new ArrayList<IHidObject>();
                        for (AssociationMaker child : this.children.values()) {
                            rhValues.add((IHidObject)child.make(occurrence));
                        }
                        RfHidOperator variadic = STransformer.makeStandInOperator((IHidObject)STransformer.makeStandInImplicit("(", IHidImplicitConstants.ImplicitType.VARIADIC_LIMIT.id), rhValues, 198, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, ",", occurrence, HidQualifierCache.IS_AGGREGATE_QUALIFIER);
                        aggregateAssociation = STransformer.makeStandInOperator(this.hidObject, Collections.singletonList(variadic), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=>", occurrence, this.isRoot ? HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER : HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                    }
                    return aggregateAssociation;
                }
            }
        }
    }
}

