/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAttribute;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.RfDummyPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class SAttributeOperation
extends SOperation {
    private static final String[] FOR_ALL_ATTRIBUTES = new String[]{"BASE", "SIMPLE_NAME", "PATH_NAME", "INSTANCE_NAME", "SUBTYPE"};
    private static final String[] SCALAR_ATTRIBUTES = new String[]{"LEFT", "RIGHT", "LOW", "HIGH", "ASCENDING", "IMAGE()", "VALUE()"};
    private static final String[] DISC_OR_PHYSICAL_ATTRIBUTES = new String[]{"POS()", "VAL()", "SUCC()", "PRED()", "LEFTOF()", "RIGHTOF()"};
    private static final String[] ARRAY_ATTRIBUTES = new String[]{"ELEMENT", "LEFT_ARR_", "LEFT()", "RIGHT_ARR_", "RIGHT()", "LOW_ARR_", "LOW()", "HIGH_ARR_", "HIGH()", "RANGE", "RANGE()", "REVERSE_RANGE", "REVERSE_RANGE()", "LENGTH", "LENGTH()", "ASCENDING", "ASCENDING()"};
    private static final String[] SIGNAL_ATTRIBUTES = new String[]{"DELAYED", "DELAYED()", "STABLE", "STABLE()", "QUIET", "QUIET()", "TRANSACTION", "EVENT", "ACTIVE", "LAST_EVENT", "LAST_ACTIVE", "LAST_VALUE", "DRIVING", "DRIVING_VALUE"};
    private static final Set<String> BASE_TYPE = Stream.of("DRIVING_VALUE", "LAST_VALUE", "DELAYED", "DELAYED()", "BASE", "VALUE()", "VAL()", "SUCC()", "PRED()", "LEFTOF()", "RIGHTOF()").collect(Collectors.toSet());
    private static final Set<String> INT_TYPE = Stream.of("POS()", "LENGTH", "LENGTH()").collect(Collectors.toSet());
    private static final Set<String> BOOL_TYPE = Stream.of("DRIVING", "EVENT", "ACTIVE", "QUIET", "QUIET()", "STABLE", "STABLE()", "ASCENDING", "ASCENDING()").collect(Collectors.toSet());
    private static final Set<String> STRING_TYPE = Stream.of("SIMPLE_NAME", "INSTANCE_NAME", "PATH_NAME", "IMAGE()").collect(Collectors.toSet());
    private static final Set<String> BIT_TYPE = Stream.of("TRANSACTION").collect(Collectors.toSet());
    private static final Set<String> TIME_TYPE = Stream.of("LAST_EVENT", "LAST_ACTIVE").collect(Collectors.toSet());
    private static final Set<String> TYPE_TYPE = Stream.of("LEFT", "RIGHT", "HIGH", "LOW", "SUBTYPE").collect(Collectors.toSet());
    private static final Set<String> ELEMENT_TYPE = Stream.of("ELEMENT").collect(Collectors.toSet());
    private static final Set<String> RANGE_TYPE = Stream.of("RANGE", "RANGE()", "REVERSE_RANGE", "REVERSE_RANGE()", "RIGHT()", "LEFT_ARR_", "LEFT()", "RIGHT_ARR_", "HIGH_ARR_", "HIGH()", "LOW_ARR_", "LOW()").collect(Collectors.toSet());
    private static final String _ARR_ = "_ARR_";
    private static final Set<String> ALL_PREDEFINED_ATTRIBUTES = new HashSet<String>();
    private static final Map<AttributeCategory, Set<String>> VALID_ATTRIBUTES = new EnumMap<AttributeCategory, Set<String>>(AttributeCategory.class);

    public SAttributeOperation() {
        Set all_attr = Stream.of(FOR_ALL_ATTRIBUTES).collect(Collectors.toSet());
        Set scalar_attr = Stream.of(SCALAR_ATTRIBUTES).collect(Collectors.toSet());
        Set disc_attr = Stream.of(DISC_OR_PHYSICAL_ATTRIBUTES).flatMap(Stream::of).collect(Collectors.toSet());
        Set array_attr = Stream.of(ARRAY_ATTRIBUTES).collect(Collectors.toSet());
        Set signal_attr = Stream.of(SIGNAL_ATTRIBUTES).collect(Collectors.toSet());
        VALID_ATTRIBUTES.put(AttributeCategory.ALL, all_attr);
        VALID_ATTRIBUTES.put(AttributeCategory.SCALAR, scalar_attr);
        VALID_ATTRIBUTES.put(AttributeCategory.DISCRETE_OR_PHYISCAL, disc_attr);
        VALID_ATTRIBUTES.put(AttributeCategory.ARRAY, array_attr);
        VALID_ATTRIBUTES.put(AttributeCategory.SIGNAL, signal_attr);
        ALL_PREDEFINED_ATTRIBUTES.addAll(all_attr);
        ALL_PREDEFINED_ATTRIBUTES.addAll(scalar_attr);
        ALL_PREDEFINED_ATTRIBUTES.addAll(disc_attr);
        ALL_PREDEFINED_ATTRIBUTES.addAll(array_attr);
        ALL_PREDEFINED_ATTRIBUTES.addAll(signal_attr);
    }

    public IRfNamedElement getAttributeType(IHidObject hidObj, SEvaluator.VhdlSemanticOperatorVisitor visitor, Set<IRfNamedElement> visited) {
        Set<String> validAttributes;
        IRfNamedElement translatedType;
        IRfNamedElement parentElement;
        IRfNamedElement resolvedType;
        if (visited == null) {
            visited = new HashSet<IRfNamedElement>();
        }
        String attributeName = "";
        IHidObject hidObject = hidObj;
        List selects = null;
        if (hidObj instanceof RfHidAccess) {
            selects = ((RfHidAccess)hidObject).getSelects();
            hidObject = ((RfHidAccess)hidObject).getParentHid();
            attributeName = "()";
        } else if (hidObj instanceof RfHid && ((RfHid)hidObj).hasAccesses()) {
            attributeName = "()";
        }
        if (selects != null && selects.size() >= 2) {
            return null;
        }
        if (!(hidObject instanceof RfHid)) {
            return null;
        }
        RfHid attribute = (RfHid)hidObject;
        if (attribute.getElement() instanceof RfAttribute && (resolvedType = ((RfAttribute)attribute.getElement()).getResolvedType(true)) != null && resolvedType != SDataAbstracts.UNDEFINED_ELEMENT) {
            return attribute.getElement();
        }
        if (!(attribute.getParentAccess() instanceof RfHidAccess)) {
            return null;
        }
        RfHidAccess attributeEntity = (RfHidAccess)attribute.getParentAccess();
        IRfNamedElement attributeEntityType = STransformer.INSTANCE.getBaseType(attributeEntity.getAssociatedType(), true);
        if (attributeEntityType == null || attributeEntityType instanceof RfAssociatedType.RfUnresolvedInfo) {
            return null;
        }
        if ((attributeEntityType == RfDummyElement.ATTRIBUTE_ELEMENT || attributeEntityType instanceof RfDummyPredefinedAttribute) && SOperation.getOperation((IHidObject)attributeEntity.getParentHid(), visitor.getScope()) == SOperation.ATTRIBUTE_OPERATION) {
            attributeEntityType = STransformer.INSTANCE.getBaseType(this.getAttributeType((IHidObject)attributeEntity.getParentHid(), visitor, visited), true);
        }
        IRfNamedElement iRfNamedElement = parentElement = attributeEntity.getParentHid() != null ? attributeEntity.getParentHid().getElement() : null;
        if (parentElement instanceof RfAlias && (translatedType = ((RfAlias)parentElement).getTranslatedType()) instanceof RfVariable && translatedType.getEnclosingScope() instanceof RfRecordType) {
            return null;
        }
        if (visited.contains(parentElement)) {
            return null;
        }
        visited.add(parentElement);
        if (attributeEntityType instanceof RfFunctionsHolder) {
            RfFunction function = ((RfFunctionsHolder)attributeEntityType).getLastDefinedFunction();
            if (function != null) {
                attributeEntityType = function.getResolvedType(true);
            } else {
                return null;
            }
        }
        if (attributeEntityType == null) {
            return null;
        }
        long attributeCategories = this.getAttributeCategory(attributeEntityType) | this.getAttributeCategory(attributeEntity.getAssociatedType()) | this.getAttributeCategory(parentElement);
        Hid parentAccess = attributeEntity.getParentHid();
        while (parentAccess != null) {
            IRfNamedElement namedElement = null;
            if (parentAccess instanceof Hid) {
                namedElement = parentAccess.getElement();
                parentAccess = parentAccess.getParentAccess();
            } else {
                if (!(parentAccess instanceof HidAccess)) break;
                namedElement = ((HidAccess)parentAccess).getAssociatedType();
                parentAccess = ((HidAccess)parentAccess).getParentHid();
            }
            attributeCategories |= this.getAttributeCategory(namedElement);
        }
        attributeName = attribute.getName().toUpperCase().concat(attributeName);
        if (this.hasCategory(attributeCategories, AttributeCategory.ARRAY) && ("LEFT".equals(attributeName) || "RIGHT".equals(attributeName) || "HIGH".equals(attributeName) || "LOW".equals(attributeName))) {
            attributeName = String.valueOf(attributeName) + _ARR_;
        }
        if (!(validAttributes = this.getValidAttributes(attributeCategories)).contains(attributeName)) {
            if (ALL_PREDEFINED_ATTRIBUTES.contains(attributeName)) {
                visitor.reportError(hidObj, "INVALID_ATTRIBUTE: Attribute ''{0}'' is not defined for prefix ''{1}''", attributeName, attributeEntityType.getName());
            }
            return null;
        }
        RfAttribute.AttributeKind attributeKind = RfAttribute.AttributeKind.VALUE;
        if (attributeName.startsWith("RANGE") || attributeName.startsWith("REVERSE_RANGE")) {
            attributeKind = RfAttribute.AttributeKind.RANGE;
        } else if (attributeName.startsWith("BASE") || attributeName.startsWith("SUBTYPE") || attributeName.startsWith("ELEMENT")) {
            attributeKind = RfAttribute.AttributeKind.TYPE;
        }
        IRfNamedElement returnType = this.getReturnType(attributeEntityType, attributeName, parentElement, visitor, visited, selects);
        if (returnType instanceof RfAttribute) {
            returnType = ((RfAttribute)returnType).getResolvedType(true);
        } else if (returnType instanceof RfEnum) {
            returnType = ((RfEnum)returnType).getParentEnumType();
        }
        if (attributeName.endsWith(_ARR_)) {
            attributeName = attributeName.substring(0, attributeName.indexOf(_ARR_));
        }
        returnType = new RfPredefinedAttribute(attributeName, returnType, attributeKind);
        attribute.setElement(returnType);
        return returnType;
    }

    private boolean hasCategory(long categories, AttributeCategory category) {
        return (categories & category.value()) != 0L;
    }

    private Set<String> getValidAttributes(long categories) {
        HashSet<String> result = new HashSet<String>();
        AttributeCategory[] attributeCategoryArray = AttributeCategory.values();
        int n = attributeCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeCategory cat = attributeCategoryArray[n2];
            if (this.hasCategory(categories, cat)) {
                result.addAll((Collection<String>)VALID_ATTRIBUTES.get((Object)cat));
            }
            ++n2;
        }
        return result;
    }

    private IRfNamedElement getReturnType(IRfNamedElement type, String attributeName, IRfNamedElement parentElement, SEvaluator.VhdlSemanticOperatorVisitor visitor, Set<IRfNamedElement> visited, List<IHidObject> arguments) {
        if (!(type instanceof RfNamedElement)) {
            return null;
        }
        RfProject rfProject = ((RfNamedElement)type).getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (BASE_TYPE.contains(attributeName)) {
            return STransformer.INSTANCE.getBaseType(type, false);
        }
        if (INT_TYPE.contains(attributeName)) {
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.INTEGER);
        }
        if (BOOL_TYPE.contains(attributeName)) {
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BOOLEAN);
        }
        if (STRING_TYPE.contains(attributeName)) {
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.STRING);
        }
        if (BIT_TYPE.contains(attributeName)) {
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.BIT);
        }
        if (TIME_TYPE.contains(attributeName)) {
            return rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.TIME);
        }
        if (TYPE_TYPE.contains(attributeName)) {
            return type;
        }
        if (ELEMENT_TYPE.contains(attributeName)) {
            return ((RfListType)type).getAssociatedType();
        }
        if (RANGE_TYPE.contains(attributeName) && (parentElement instanceof IRfAssociatedType || parentElement instanceof RfFunctionsHolder)) {
            IndexConstraint rangeConstraint = null;
            int rangePosition = this.extractFirstArgumentInt(arguments);
            if (rangePosition < 0) {
                return null;
            }
            if (type instanceof RfFunctionsHolder) {
                type = ((RfFunctionsHolder)type).getLastDefinedFunction();
            }
            while (type instanceof IRfAssociatedType && (rangeConstraint == null || rangeConstraint.isOpen())) {
                DataType dataType = ((IRfAssociatedType)type).getDataType();
                if (dataType != null) {
                    rangeConstraint = type instanceof RfListType ? dataType.getArrayConstraint(rangePosition - 1) : dataType.getElementConstraint(rangePosition - 1);
                }
                type = ((IRfAssociatedType)type).getAssociatedType();
            }
            if (rangeConstraint == null || rangeConstraint.isOpen()) {
                return null;
            }
            IHidObject rangeObject = rangeConstraint.getHidObject();
            IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)rangeObject);
            if (resolvedElement == RfDummyElement.ATTRIBUTE_ELEMENT) {
                resolvedElement = this.getAttributeType(rangeObject, visitor, visited);
            }
            if (resolvedElement instanceof RfNamedElement) {
                return resolvedElement;
            }
            ISDataAbstract rangeDataAbstract = visitor.resolveCompleteOperator(rangeObject, null, visited);
            if (rangeDataAbstract == SDataAbstracts.UNDEFINED) {
                return null;
            }
            return SDataUtils.getDataType((ISDataAbstract)rangeDataAbstract).getType();
        }
        return null;
    }

    private int extractFirstArgumentInt(List<IHidObject> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return 1;
        }
        IHidObject arg1 = arguments.get(0);
        String valueString = null;
        if (arg1 instanceof Hid) {
            IRfNamedElement element = ((Hid)arg1).getElement();
            if (element instanceof IRfTypeAliasElement) {
                element = ((IRfTypeAliasElement)element).getTranslatedType();
            }
            if (element instanceof IRfFieldElement) {
                valueString = ((IRfFieldElement)element).getInitialValue(false);
            }
        } else if (arg1 instanceof HidImplicit) {
            valueString = ((HidImplicit)arg1).getName();
        }
        if (valueString != null) {
            try {
                int value = Integer.parseInt(valueString);
                if (value >= 1) {
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private long getAttributeCategory(IRfNamedElement type) {
        if (type instanceof RfAlias) {
            return this.getAttributeCategory(((RfAlias)type).getTranslatedType());
        }
        long categories = 1L;
        if (type instanceof RfDummyVariable) {
            type = ((RfDummyVariable)type).getOriginalVar();
        }
        if (type instanceof RfVariable && (((RfVariable)type).isSignal() || type instanceof RfPort)) {
            categories |= AttributeCategory.SIGNAL.value();
        }
        if ((type = STransformer.INSTANCE.getBaseType(type, false)) instanceof RfScalarType) {
            RfScalarType scalar = (RfScalarType)type;
            if (scalar.isNumericType() && !scalar.hasFloatingRange() || scalar.isEnumType() || scalar.hasPhysicalUnits()) {
                categories |= AttributeCategory.DISCRETE_OR_PHYISCAL.value();
            }
            categories |= AttributeCategory.SCALAR.value();
        }
        if (type instanceof RfListType) {
            categories |= AttributeCategory.ARRAY.value();
        }
        return categories;
    }

    static enum AttributeCategory {
        ALL,
        SCALAR,
        DISCRETE_OR_PHYISCAL,
        ARRAY,
        SIGNAL;


        public long value() {
            int ordinal = this.ordinal();
            long result = 1L << ordinal;
            return result;
        }
    }
}

