/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class SContext
implements ISContext {
    public ISDataType dataType;
    public SOperation operation;
    public VhdlContextKind kind;
    public IHidObject contextSource;
    public SContext previousContext;

    private SContext(ISDataType dataType, IHidObject contextSource) {
        boolean isAny = dataType != null && dataType.getType() != null && "DVT81b441bd_ANY_TYPE".equals(dataType.getType().getName());
        this.dataType = dataType;
        this.contextSource = contextSource;
        this.kind = isAny || dataType == SDataAbstracts.UNDEFINED ? VhdlContextKind.ANY : (dataType == STransformer.PROCEDURE_RETURN_TYPE ? VhdlContextKind.VOID : VhdlContextKind.TYPE);
    }

    public static SContext of(ISDataType dataType, IHidObject contextSource) {
        if (dataType == null) {
            return null;
        }
        return new SContext(dataType, contextSource);
    }

    public static SContext copyOf(SContext context) {
        SContext newContext = new SContext(null, null);
        newContext.dataType = context.dataType;
        newContext.operation = context.operation;
        newContext.kind = context.kind;
        newContext.contextSource = context.contextSource;
        return newContext;
    }

    public IRfNamedElement getRfElement() {
        return this.kind == VhdlContextKind.TYPE ? this.dataType.getType() : null;
    }

    public String toString() {
        return this.dataType.toString();
    }

    public boolean isTypeCompatible(IRfNamedElement type) {
        return this.kind == VhdlContextKind.TYPE && type != null && !type.checkTypeCompatibility(this.dataType.getType());
    }

    public String getContextTypeName() {
        return this.kind == VhdlContextKind.TYPE ? this.dataType.getName() : "";
    }

    public ISDataType getFirstIndexContextDataType(SEvaluator.VhdlSemanticOperatorVisitor visitor) {
        IRfNamedElement type = this.getRfElement();
        if (!(type instanceof IRfAssociatedType)) {
            return null;
        }
        DataType dataType = ((IRfAssociatedType)type).getDataType();
        if (dataType == null) {
            return null;
        }
        IRfNamedElement arrayIndexType = dataType.getArrayIndexType(0, visitor);
        return arrayIndexType == null ? (type instanceof RfNamedElement ? ((RfNamedElement)type).getRfProject().getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE) : null) : SDataType.of(arrayIndexType);
    }

    public static enum VhdlContextKind {
        ANY,
        VOID,
        TYPE;

    }
}

