/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class SDataType
implements ISDataType {
    private static final long serialVersionUID = 1L;
    private List<IRfNamedElement> types;

    private SDataType(Collection<? extends IRfNamedElement> types) {
        this.setTypes(types);
    }

    private SDataType(IRfNamedElement argumentType) {
        this.types = OptimizedUtils.listAdd(this.types, (Object)argumentType);
    }

    public static ISDataType of(IRfNamedElement rfScalarType) {
        return rfScalarType == null ? SDataAbstracts.UNDEFINED : new SDataType(rfScalarType);
    }

    public static ISDataType of(Collection<? extends IRfNamedElement> types) {
        return types == null || types.isEmpty() ? SDataAbstracts.UNDEFINED : new SDataType(types);
    }

    public void setTypes(Collection<? extends IRfNamedElement> types) {
        this.types = OptimizedUtils.listAdd(this.types, types);
    }

    public boolean checkTypeCompatibility(ISDataType secondDataType) {
        if (secondDataType == null) {
            return false;
        }
        if (this.getTypes().size() > 1 || secondDataType.getTypes().size() > 1) {
            return false;
        }
        IRfNamedElement firstType = this.getType();
        IRfNamedElement secondType = secondDataType.getType();
        return firstType.checkTypeCompatibility(secondType);
    }

    public LanguageKind getLanguageKind() {
        IRfNamedElement type = this.getType();
        return type == null ? null : type.getLanguageKind();
    }

    public IRfNamedElement getType() {
        return this.types != null && !this.types.isEmpty() ? this.types.get(0) : null;
    }

    public Collection<IRfNamedElement> getTypes() {
        if (this.types == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.types);
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean appendAliasInfo) {
        if (this.types == null || this.types.isEmpty()) {
            return "";
        }
        ArrayList<String> builder = new ArrayList<String>(this.types.size());
        for (IRfNamedElement type : this.types) {
            if (type instanceof RfFunction) {
                RfFunction function = (RfFunction)type;
                builder.add(function.getFunctionSignatureWithReturnType(true));
                continue;
            }
            if (type instanceof RfPredefinedAttribute) {
                builder.add(type.getSignature());
                continue;
            }
            if (type instanceof RfVariable && !(type instanceof RfEnum)) {
                IRfNamedElement associatedType = ((RfVariable)type).getResolvedType(true);
                String associatedTypeString = associatedType != null ? (associatedType.getEnclosingScope() != null ? DVTStringUtil.appendString((Object[])new Object[]{associatedType.getEnclosingScope().getName(), ".", associatedType.getName()}) : associatedType.getName()) : "";
                String typeString = type.getEnclosingScope() != null ? DVTStringUtil.appendString((Object[])new Object[]{type.getEnclosingScope().getName(), ".", type.getName()}) : type.getName();
                builder.add(associatedType != null ? associatedTypeString : typeString);
                continue;
            }
            String typeString = type.getEnclosingScope() != null ? DVTStringUtil.appendString((Object[])new Object[]{type.getEnclosingScope().getName(), ".", type.getName()}) : type.getName();
            builder.add(typeString);
        }
        return builder.size() == 1 ? (String)builder.get(0) : ((Object)builder).toString();
    }

    public String toString() {
        return this.getName();
    }
}

