/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;

public class SDefaultOperation
extends SOperation {
    protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
        return null;
    }

    public ISDataAbstract calculate(ConfigInfo configInfo, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
        ISDataType isValid = this.checkOperands(configInfo, true, operatorInfo, operands, context);
        if (isValid != null) {
            return isValid;
        }
        return operands.get(0);
    }

    public static class SAssignmentOperation
    extends SDefaultOperation {
        @Override
        protected ISDataType checkOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType nonValidOperands = this.checkValidOperands(configInfo, triggerError, operatorInfo, operands);
            if (nonValidOperands != null) {
                return nonValidOperands;
            }
            ISDataAbstract first = operands.get(0);
            SDataVariable firstVariable = SDataUtils.getVariable((ISDataAbstract)first);
            ISDataAbstract second = operands.get(1);
            ISDataType firstDataType = SDataUtils.getDataType((ISDataAbstract)first);
            ISDataType secondDataType = SDataUtils.getDataType((ISDataAbstract)second);
            if (firstVariable != null && firstVariable.isFinal) {
                SAssignmentOperation.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_CONSTANT_ASSIGN: Constant variable ''{0}'' cannot be assigned", ((SDataVariable)first).getVariableName());
                return SDataAbstracts.ILLEGAL;
            }
            if (firstDataType == null || secondDataType == null || firstDataType == SDataAbstracts.TYPE_UNDEFINED || secondDataType == SDataAbstracts.TYPE_UNDEFINED) {
                return null;
            }
            IRfNamedElement firstType = firstDataType.getType();
            IRfNamedElement secondType = secondDataType.getType();
            if (firstType != null && !firstType.checkTypeCompatibility(secondType)) {
                SAssignmentOperation.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_ASSIGNMENT: ''{1}'' cannot be assigned to ''{0}''", firstType.getName(), secondType.getName());
                return SDataAbstracts.ILLEGAL;
            }
            return null;
        }

        @Override
        public ISDataAbstract calculate(ConfigInfo configInfo, OperatorInfo operatorInfo, List<ISDataAbstract> operands, SContext context) {
            ISDataType isValid = this.checkOperands(configInfo, true, operatorInfo, operands, context);
            if (isValid != null) {
                return isValid;
            }
            return operands.get(0);
        }
    }

    public static class SListOperation
    extends SDefaultOperation {
    }
}

