/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISTransformer;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.semantic.extension2.SemanticOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vhdldt.model.reflection.PredefinedTypeHolder;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfAttribute;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfDummyElement;
import ro.amiq.vhdldt.model.reflection.RfDummyVariable;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPredefinedAttribute;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfRecordType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SAggregateOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SAttributeOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDefaultOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SFunctionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STypeConversionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SUniversalOperation;

public enum SEvaluator {
    INSTANCE;

    private static final String DUMMY_HIDOBJECT_NAME = "__dummy_hidobject_name__";

    private SEvaluator() {
        SDataAbstracts.registerTransformer((LanguageKind)LanguageKind.VHDL, (ISTransformer)STransformer.INSTANCE);
    }

    public void calculate(ConfigInfo configInfo, boolean triggerError, IHidHolder hidHolder) {
        if (hidHolder == null) {
            return;
        }
        hidHolder.visitHidObject(null, (IHidVisitor)new VhdlSemanticOperatorVisitor(configInfo, null, null, triggerError));
    }

    public void calculateAssociation(ConfigInfo configInfo, boolean triggerError, HidOperator association, IRfNamedElement resolvedFormal, ParserPath parserPath, IHidHolder hidHolder) {
        VhdlSemanticOperatorVisitor evaluator = new VhdlSemanticOperatorVisitor(configInfo, hidHolder, parserPath, triggerError);
        evaluator.resolveAssociation(association, resolvedFormal);
    }

    public ISDataAbstract calculateHidObject(ConfigInfo configInfo, RfNamedElement scope, ParserPath parserPath, boolean triggerError, IHidObject object, SContext context) {
        if (object == null) {
            return SDataAbstracts.UNDEFINED;
        }
        VhdlSemanticOperatorVisitor visitor = new VhdlSemanticOperatorVisitor(configInfo, (IHidHolder)new RfHidHolder(scope), null, triggerError);
        visitor.setParserPath(parserPath);
        return visitor.resolveOperand(object, context, null);
    }

    public static String filterTypeName(String typeName) {
        if (typeName.startsWith("DVT81b441bd_")) {
            typeName = typeName.substring("DVT81b441bd_".length());
        }
        if (typeName.startsWith("UNIVERSAL_")) {
            typeName = typeName.substring("UNIVERSAL_".length());
        }
        return typeName;
    }

    public static class VhdlSemanticOperatorVisitor
    extends SemanticOperatorVisitor {
        public static final LanguageKind LANG_KIND = LanguageKind.VHDL;
        private boolean reportError;
        private PredefinedTypeHolder typeCache;
        private ConfigInfo configInfo;
        public static final String COND_OP_TEXT = "??";

        public VhdlSemanticOperatorVisitor(ConfigInfo configInfo, IHidHolder hidHolder, ParserPath parserPath, boolean reportError) {
            super(hidHolder, parserPath);
            this.configInfo = configInfo;
            this.reportError = reportError;
            if (configInfo == null) {
                return;
            }
            RfProject rfProject = (RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            this.typeCache = rfProject.getPredefinedTypesCache();
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public RfNamedElement getScope() {
            return this.holder instanceof RfHidHolder ? (RfNamedElement)((RfHidHolder)this.holder).getScope() : null;
        }

        public boolean visit(HidOperator operator) throws BuildCancelException {
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            rfProject.checkBuildCanceled();
            if (!operator.isOperatorResolved()) {
                operator.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
            }
            if (operator.isComplete() && !operator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE)) {
                this.resolveCompleteOperator((IHidObject)operator, null, null);
            }
            return true;
        }

        public boolean visit(Hid hid) throws BuildCancelException {
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            rfProject.checkBuildCanceled();
            if (hid.hasQualifier(HidQualifierCache.POTENTIAL_METHOD_CALL_QUALIFIER | HidQualifierCache.ATTRIBUTE_QUALIFIER)) {
                this.resolveCompleteOperator((IHidObject)hid, SContext.of(STransformer.PROCEDURE_RETURN_TYPE, null), null);
            }
            return true;
        }

        public ISDataAbstract resolveCompleteOperator(IHidObject hidObject, SContext sContext, Set<IRfNamedElement> visited) {
            SContext context = sContext;
            if (context == null) {
                context = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), hidObject);
            }
            if (context == null) {
                return SDataAbstracts.UNDEFINED;
            }
            try {
                SOperation currentOperation = SOperation.getOperation(hidObject, this.getScope());
                if (currentOperation == SOperation.ENUM_DECLARATION_ASSIGN) {
                    return this.resolveEnumDeclarationAssign(hidObject);
                }
                if (currentOperation == SOperation.EXTERNAL_NAME) {
                    return this.resolveExternalName(hidObject, context, visited);
                }
                if (currentOperation == SOperation.PHYSICAL_UNIT_SECONDARY_DECLARATION) {
                    return this.resolvePhysicalUnitSecondaryDeclaration(hidObject, visited);
                }
                if (currentOperation == SOperation.SELECT_ASSIGNMENT_OPERATION) {
                    return this.resolveSelectAssignmentOperation(hidObject, visited);
                }
                if (currentOperation == SOperation.AFTER_OPERATION) {
                    return this.resolveTimeClauseOperations((HidOperator)hidObject, visited);
                }
                if (currentOperation == SOperation.WHEN_OPERATION) {
                    return this.resolveWhenOperation(hidObject, context, null, visited);
                }
                if (currentOperation == SOperation.EXIT_OPERATION) {
                    return this.resolveNextExitOperations(hidObject, visited);
                }
                if (currentOperation == SOperation.NEXT_OPERATION) {
                    return this.resolveNextExitOperations(hidObject, visited);
                }
                if (currentOperation == SOperation.WHILE_OPERATION) {
                    return this.resolveWhileOperation(hidObject, visited);
                }
                if (currentOperation == SOperation.ASSERT_OPERATION) {
                    return this.resolveAssertOperation(hidObject, visited);
                }
                if (currentOperation == SOperation.REPORT_OPERATION) {
                    return this.resolveReportOperation(hidObject, visited);
                }
                if (currentOperation == SOperation.WAIT_OPERATION) {
                    return this.resolveWaitOperation(hidObject, visited);
                }
                if (currentOperation == SOperation.CASE_OPERATION) {
                    return this.resolveCaseExpression(hidObject, visited);
                }
                if (currentOperation == SOperation.CASE_ITEM_WHEN_OPERATION) {
                    return this.resolveCaseItemExpression(hidObject, visited);
                }
                if (currentOperation == SOperation.ATTRIBUTE_OPERATION) {
                    return this.resolveAttribute(hidObject, (SAttributeOperation)currentOperation, visited);
                }
                if (currentOperation == SOperation.ARRAY_SELECT) {
                    return this.resolveArraySelect(hidObject, context);
                }
                if (currentOperation == SOperation.RANGE_OPERATION) {
                    return this.resolveRange(hidObject, visited, context);
                }
                if (currentOperation == SOperation.AGGREGATE) {
                    return this.resolveAggregate((HidOperator)hidObject, context.kind != SContext.VhdlContextKind.TYPE && context.previousContext != null ? context.previousContext : context, (SAggregateOperation)currentOperation, visited);
                }
                if (currentOperation == SOperation.TYPE_CONVERSION) {
                    return this.resolveTypeConversion((RfHidAccess)hidObject, (STypeConversionOperation)currentOperation, visited);
                }
                if (currentOperation == SOperation.IF_OPERATION) {
                    return this.resolveIfCondition((HidOperator)hidObject, visited);
                }
                if (currentOperation == SOperation.QUALIFIED_INSTANCE) {
                    return this.resolveQualifiedExpression((HidOperator)hidObject, visited);
                }
                if (currentOperation == SOperation.ASSIGNMENT_INSTANCE || currentOperation == SOperation.LIST_OPERATION) {
                    return this.resolveGeneric((HidOperator)hidObject, context, (SDefaultOperation)currentOperation, visited);
                }
                if (currentOperation == SOperation.RETURN_STATEMENT) {
                    return this.resolveReturnStatement(hidObject, visited);
                }
                if (currentOperation instanceof SFunctionOperation) {
                    return this.resolveMethodCall(hidObject, context, (SFunctionOperation)currentOperation, visited);
                }
            }
            catch (BuildCancelException ex) {
                throw ex;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveReturnStatement(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            RfNamedElement initialScope = this.getScope();
            if (initialScope == null) {
                return SDataAbstracts.UNDEFINED;
            }
            RfFunction scope = initialScope.getEnclosingScope(RfFunction.class);
            if (scope == null) {
                if (initialScope.getEnclosingScope(RfProcess.class) != null) {
                    this.reportError(hidObject, "ILLEGAL_RETURN: Return not allowed in process", new String[0]);
                }
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement associatedType = scope.getAssociatedType();
            SContext returnContext = SContext.of(SDataType.of(associatedType), hidObject);
            IHidObject returnedObject = (IHidObject)((HidOperator)hidObject).getRHValues().get(0);
            ISDataAbstract resolvedType = this.resolveOperand(returnedObject, returnContext, visited);
            if (scope.isTask() && HidUtils.isHidImplicit((IHidObject)returnedObject) && !((HidImplicit)returnedObject).isEmptyJump()) {
                this.reportError(hidObject, "ILLEGAL_VALUE_RETURN: Value return not allowed in procedure", new String[0]);
                return SDataAbstracts.UNDEFINED;
            }
            if (scope.isFunction() && HidUtils.isHidImplicit((IHidObject)returnedObject) && ((HidImplicit)returnedObject).isEmptyJump()) {
                this.reportError(hidObject, "ILLEGAL_EMPTY_RETURN: Empty return not allowed in function, expecting ''{0}''", scope.getAssociatedTypeName());
                return SDataAbstracts.UNDEFINED;
            }
            return resolvedType;
        }

        private ISDataAbstract resolveEnumDeclarationAssign(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            RfHidOperator hidOperator = (RfHidOperator)hidObject;
            RfNamedElement scope = this.getScope();
            ISDataType resolvedType = SDataType.of(scope);
            hidOperator.setOperatorResolvedType((ISDataAbstract)resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveExternalName(IHidObject hidObject, SContext context, Set<IRfNamedElement> visited) {
            IHidObject errorHidObject = hidObject;
            ISDataAbstract resolvedType = null;
            switch (hidObject.getHidKind()) {
                case ACCESS: {
                    List selects = ((HidAccess)hidObject).getSelects();
                    if (selects == null || selects.isEmpty()) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    if (selects.size() > 1) {
                        IRfNamedElement resolvedTypeElement = ((HidAccess)hidObject).getAssociatedType();
                        if (resolvedTypeElement != null && !resolvedTypeElement.checkTypeCompatibility(context.dataType.getType())) {
                            this.reportError((IHidObject)selects.get(0), "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)errorHidObject), context.getContextTypeName());
                            return SDataAbstracts.UNDEFINED;
                        }
                        return SDataVariable.of((ISDataType)SDataType.of(resolvedTypeElement), (boolean)false);
                    }
                    hidObject = (IHidObject)selects.get(0);
                }
                case OPERATOR: {
                    IRfNamedElement associatedType;
                    if (!HidUtils.isOperatorOfType((IHidObject)hidObject, (IHidOperatorConstants.OperatorType)IHidOperatorConstants.OperatorType.EXTERNAL_NAME)) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    HidOperator externalNameVariadic = (HidOperator)hidObject;
                    resolvedType = externalNameVariadic.getOperatorResolvedType();
                    if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    IRfNamedElement resolvedTypeElement = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
                    if (resolvedTypeElement instanceof RfDummyVariable && (associatedType = ((RfDummyVariable)resolvedTypeElement).getAssociatedType()) == RfDummyElement.ATTRIBUTE_ELEMENT) {
                        ListContainer rhValues = ((HidOperator)hidObject).getRHValues();
                        if (rhValues == null || rhValues.size() != 3) break;
                        IHidObject typeObject = (IHidObject)rhValues.get(0);
                        resolvedType = this.isCompleteOperator(typeObject) ? this.resolveCompleteOperator(typeObject, null, visited) : this.getDataType(typeObject, null, visited);
                        if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                            return SDataAbstracts.UNDEFINED;
                        }
                        resolvedTypeElement = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
                        resolvedType = SDataAbstracts.get((IRfNamedElement)resolvedTypeElement, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    }
                    if (resolvedTypeElement != null && !resolvedTypeElement.checkTypeCompatibility(context.dataType.getType())) {
                        this.reportError((IHidObject)externalNameVariadic, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)errorHidObject), context.getContextTypeName());
                        return SDataAbstracts.UNDEFINED;
                    }
                    return resolvedType;
                }
                case HOLDER: {
                    break;
                }
                case IMPLICIT: {
                    break;
                }
                case HID: {
                    break;
                }
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolvePhysicalUnitSecondaryDeclaration(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!HidUtils.isOperator((IHidObject)hidObject)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator operator = (HidOperator)hidObject;
            if (operator.getRHValues() == null || operator.getRHValues().size() != 1) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject rhValue = (IHidObject)operator.getRHValues().get(0);
            if (!HidUtils.isHidImplicit((IHidObject)rhValue)) {
                return SDataAbstracts.UNDEFINED;
            }
            String implicitText = ((HidImplicit)rhValue).getName();
            if (implicitText.indexOf(" ") < 0) {
                return SDataAbstracts.UNDEFINED;
            }
            String abstractLiteral = implicitText.substring(0, implicitText.indexOf(" "));
            return this.getDataType((IHidObject)RfHidImplicit.makeImplicit(abstractLiteral, 180), SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.INTEGER), (IHidObject)operator), visited);
        }

        private ISDataAbstract resolveSelectAssignmentOperation(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!HidUtils.isOperator((IHidObject)hidObject) || ((HidOperator)hidObject).getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator selectOperator = (HidOperator)hidObject;
            IHidObject assignment = (IHidObject)selectOperator.getRHValues().get(0);
            if (!HidUtils.isOperator((IHidObject)assignment) || ((HidOperator)assignment).getOperatorKind() != IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject whenExpression = (IHidObject)((HidOperator)assignment).getRHValues().get(0);
            if (!HidUtils.isOperator((IHidObject)whenExpression)) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject assignmentLHSide = ((HidOperator)assignment).getLHValue();
            ISDataAbstract resolvedType = this.resolveOperand(assignmentLHSide, null, visited);
            SContext assignmentContext = SContext.of(SDataUtils.getDataType((ISDataAbstract)resolvedType), assignment);
            IHidObject selectExpression = selectOperator.getLHValue();
            resolvedType = this.resolveOperand(selectExpression, null, visited);
            SContext conditionContext = SContext.of(SDataUtils.getDataType((ISDataAbstract)resolvedType), whenExpression);
            this.resolveWhenOperation(whenExpression, assignmentContext, conditionContext, visited);
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveWhenOperation(IHidObject hidObject, SContext expressionContext, SContext conditionContext, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator whenOperator = (HidOperator)hidObject;
            ArrayList<HidOperator> flattenedObjects = new ArrayList<HidOperator>();
            IHidOperatorConstants.OperatorKind opKind = whenOperator.getOperatorKind();
            if (opKind == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                flattenedObjects.add(whenOperator);
            } else if (opKind == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                flattenedObjects.addAll(OptimizedUtils.asList((ListContainer)whenOperator.getRHValues(), (boolean)false));
            }
            expressionContext.contextSource = whenOperator;
            ISDataAbstract firstExpressionDataType = null;
            for (IHidObject iHidObject : flattenedObjects) {
                IHidObject expression = null;
                IHidObject condition = null;
                if (HidUtils.isOperator((IHidObject)iHidObject) && ((RfHidOperator)iHidObject).isWhen()) {
                    expression = ((RfHidOperator)iHidObject).getLHValue();
                    condition = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0);
                } else {
                    expression = iHidObject;
                }
                ISDataAbstract exprDataType = null;
                if (expression != null) {
                    if (expression instanceof HidOperator && ((HidOperator)expression).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR && !((HidOperator)expression).isAggregate()) {
                        HidOperator exprOp = (HidOperator)expression;
                        for (IHidObject waveform : exprOp.getRHValues()) {
                            exprDataType = this.resolveIndividualWaveform(waveform, expressionContext, visited);
                        }
                    } else {
                        exprDataType = this.resolveIndividualWaveform(expression, expressionContext, visited);
                    }
                }
                if (firstExpressionDataType == null) {
                    firstExpressionDataType = exprDataType;
                }
                if (condition == null || HidUtils.isHidImplicit(condition) && ((HidImplicit)condition).isOthers()) continue;
                HidOperator conditionOperator = (HidOperator)iHidObject;
                ISDataAbstract resolvedType = null;
                if (conditionContext == null) {
                    resolvedType = this.resolveGeneralCondition(condition, conditionOperator, visited);
                } else {
                    conditionContext.contextSource = conditionOperator;
                    resolvedType = this.resolveOperand(condition, conditionContext, visited);
                }
                conditionOperator.setOperatorResolvedType(resolvedType);
            }
            whenOperator.setOperatorResolvedType(firstExpressionDataType);
            return firstExpressionDataType;
        }

        private ISDataAbstract resolveIndividualWaveform(IHidObject waveform, SContext context, Set<IRfNamedElement> visited) {
            IHidObject waveformElement = waveform;
            SContext waveformContext = SContext.of(context.dataType, HidUtils.isOperator((IHidObject)waveform) ? waveform : context.contextSource);
            return this.resolveOperand(waveformElement, waveformContext, visited);
        }

        private ISDataAbstract resolveNextExitOperations(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject possibleWhenOp = ((HidOperator)hidObject).getFirstRHValue();
            if (possibleWhenOp instanceof RfHidOperator && ((RfHidOperator)possibleWhenOp).isWhen()) {
                RfHidOperator whenOp = (RfHidOperator)possibleWhenOp;
                ISDataAbstract resolvedType = this.resolveGeneralCondition(whenOp.getLHValue(), whenOp, visited);
                whenOp.setOperatorResolvedType(resolvedType);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveWhileOperation(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator whileOperator = (HidOperator)hidObject;
            IHidObject conditionClause = whileOperator.getLHValue();
            if (conditionClause != null) {
                ISDataAbstract resolvedType = this.resolveGeneralCondition(conditionClause, whileOperator, visited);
                whileOperator.setOperatorResolvedType(resolvedType);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveReportOperation(IHidObject reportOp, Set<IRfNamedElement> visited) {
            IHidObject reportExpression = ((HidOperator)reportOp).getLHValue();
            SContext reportContext = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.STRING), reportOp);
            ISDataAbstract resolvedType = this.resolveOperand(reportExpression, reportContext, visited);
            ((HidOperator)reportOp).setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveAssertOperation(IHidObject assertObject, Set<IRfNamedElement> visited) {
            if (!(assertObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator operator = (HidOperator)assertObject;
            IHidObject conditionClause = ((HidOperator)assertObject).getLHValue();
            if (conditionClause != null) {
                this.resolveGeneralCondition(conditionClause, (HidOperator)assertObject, visited);
            }
            Set flattenedOperators = HidUtils.flattenToOperators((IHidOperator)operator);
            for (IHidOperator flattenedOperator : flattenedOperators) {
                if (!(flattenedOperator instanceof RfHidOperator)) continue;
                RfHidOperator op = (RfHidOperator)flattenedOperator;
                if (op.isReport()) {
                    this.resolveReportOperation((IHidObject)op, visited);
                }
                if (!op.isSeverity()) continue;
                IHidObject severityExpression = op.getLHValue();
                SContext severityContext = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.SEVERITY_LEVEL), (IHidObject)op);
                ISDataAbstract resolvedType = this.resolveOperand(severityExpression, severityContext, visited);
                op.setOperatorResolvedType(resolvedType);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveWaitOperation(IHidObject waitObject, Set<IRfNamedElement> visited) {
            if (!(waitObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator operator = (HidOperator)waitObject;
            Set flattenedOperators = HidUtils.flattenToOperators((IHidOperator)operator);
            for (IHidOperator flattenedOperator : flattenedOperators) {
                IHidObject conditionExpression;
                if (!(flattenedOperator instanceof RfHidOperator)) continue;
                RfHidOperator op = (RfHidOperator)flattenedOperator;
                if (op.isUntilClause() && (conditionExpression = op.getLHValue()) != null) {
                    this.resolveGeneralCondition(conditionExpression, op, visited);
                }
                if (!op.isWaitTimeoutClause()) continue;
                this.resolveTimeClauseOperations(op, visited);
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveTimeClauseOperations(HidOperator op, Set<IRfNamedElement> visited) {
            IHidObject timeoutExpression = op.getLHValue();
            SContext timeoutContext = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.TIME), (IHidObject)op);
            ISDataAbstract resolvedType = this.resolveOperand(timeoutExpression, timeoutContext, visited);
            op.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private void resolveAssociation(HidOperator association, IRfNamedElement lhSide) {
            IRfNamedElement resolvedType;
            association.setOperatorResolvedType((ISDataAbstract)SDataAbstracts.UNDEFINED);
            if (!(lhSide instanceof RfNamedElement)) {
                return;
            }
            if (lhSide instanceof IRfAssociatedType && !((resolvedType = ((IRfAssociatedType)lhSide).getResolvedType(true)) instanceof RfNamedElement)) {
                return;
            }
            IHidObject leftValue = AssociationUtils.getFormalPartRaw((IHidObject)association, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
            if (HidUtils.isHidImplicit((IHidObject)leftValue) || leftValue instanceof Hid && ((Hid)leftValue).getParentAccess() == null && !HidUtils.isResolved((IHidObject)leftValue)) {
                this.createHidAndUpdateOperator(association, ((IHid)leftValue).getName(), lhSide, true);
            }
            this.internalResolveAssociation(association, association.hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER) ? SOperation.PORT_CONNECTION_OPERATION : null);
        }

        private void internalResolveAssociation(HidOperator operator, SOperation operation) {
            IHidObject leftValue = operator.getLHValue();
            IHidObject rightValue = (IHidObject)operator.getRHValues().get(0);
            ISDataAbstract firstDataType = null;
            ISDataAbstract secondDataType = null;
            firstDataType = this.resolveOperand(leftValue, null, null);
            if (firstDataType == SDataAbstracts.UNDEFINED) {
                return;
            }
            SContext context = SContext.of(SDataUtils.getDataType((ISDataAbstract)firstDataType), (IHidObject)operator);
            context.operation = operation;
            secondDataType = this.resolveOperand(rightValue, context, null);
            operator.setOperatorResolvedType(secondDataType);
            IRfNamedElement leftType = SDataUtils.getVariableElement((ISDataAbstract)firstDataType);
            if (leftType instanceof IRfPortElement && !((IRfPortElement)leftType).isInput() && secondDataType != SDataAbstracts.UNDEFINED && !this.checkIsSignal(rightValue)) {
                String portName = leftType.getName();
                String portDirection = ((IRfPortElement)leftType).isInout() ? "Inout" : "Output";
                this.reportError((IHidObject)(rightValue instanceof HidImplicit ? operator : rightValue), "PORT_CONNECTION: {1} port ''{0}'' connected to a non-signal expression", portName, portDirection);
            }
        }

        private void createHidAndUpdateOperator(HidOperator operator, String correspondentName, IRfNamedElement correspondent, boolean isLHSide) {
            if (correspondent == null) {
                return;
            }
            HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
            HidOccurrence hidOccurrence = new HidOccurrence(operatorOccurrence.getOpenBoundary(), operatorOccurrence.getVirtualOffset(), operatorOccurrence.getLine(), 0L, null);
            RfHid standIn = STransformer.makeStandInHid(correspondentName, correspondent, hidOccurrence, 0L);
            if (standIn == null) {
                return;
            }
            if (isLHSide) {
                operator.setLHValue((IHidObject)standIn);
            } else {
                operator.setRHValues(OptimizedUtils.listContainerClear((ListContainer)operator.getRHValues()));
                operator.addRHValue((IHidObject)standIn);
            }
        }

        private ISDataAbstract resolveCaseItemExpression(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator whenOperator = (HidOperator)hidObject;
            if (whenOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                IHidObject caseExpression = whenOperator.getLHValue();
                if (caseExpression == null) {
                    return SDataAbstracts.UNDEFINED;
                }
                IRfNamedElement caseExpressionElement = HidUtils.getResolvedElement((IHidObject)caseExpression);
                if (!(caseExpressionElement instanceof RfNamedElement)) {
                    return SDataAbstracts.UNDEFINED;
                }
                List caseItems = OptimizedUtils.asList((ListContainer)whenOperator.getRHValues(), (boolean)false);
                ArrayList<IHidObject> caseItemExpressions = new ArrayList<IHidObject>();
                for (IHidObject caseItem : caseItems) {
                    if (HidUtils.isHidImplicit((IHidObject)caseItem) && ((HidImplicit)caseItem).isOthers()) continue;
                    if (HidUtils.isOperator((IHidObject)caseItem)) {
                        RfHidOperator rfHidOperator = (RfHidOperator)caseItem;
                        if (!rfHidOperator.isBar() && !rfHidOperator.isRangeOrPartSelect()) continue;
                        caseItemExpressions.addAll(OptimizedUtils.asList((ListContainer)rfHidOperator.getRHValues(), (boolean)false));
                        continue;
                    }
                    caseItemExpressions.add(caseItem);
                }
                SContext context = SContext.of(SDataType.of(caseExpressionElement), caseExpression);
                for (IHidObject expression : caseItemExpressions) {
                    this.resolveOperand(expression, context, visited);
                }
                this.updateElement((IHidObject)whenOperator, (ISDataAbstract)context.dataType);
                return context.dataType;
            }
            IHidObject whenOperatorLH = whenOperator.getLHValue();
            if (whenOperatorLH == null) {
                return SDataAbstracts.UNDEFINED;
            }
            if (!HidUtils.isOperator((IHidObject)whenOperatorLH)) {
                return SDataAbstracts.UNDEFINED;
            }
            ArrayList<RfHidOperator> caseItemExpressions = new ArrayList<RfHidOperator>();
            RfHidOperator caseItemOperator = (RfHidOperator)whenOperatorLH;
            if (caseItemOperator.isBar()) {
                RfHidOperator tmp = caseItemOperator;
                while (HidUtils.isOperator((IHidObject)tmp) && ((HidOperator)tmp).isBar()) {
                    caseItemExpressions.addAll(OptimizedUtils.asList((ListContainer)((HidOperator)tmp).getRHValues(), (boolean)false));
                    tmp = ((HidOperator)tmp).getLHValue();
                }
                caseItemExpressions.add(tmp);
            } else if (caseItemOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                caseItemExpressions.add(caseItemOperator);
            }
            if (caseItemExpressions.isEmpty()) {
                return SDataAbstracts.UNDEFINED;
            }
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            if (rfProject == null) {
                return SDataAbstracts.UNDEFINED;
            }
            SContext caseExpressionContext = SContext.of(rfProject.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.BOOLEAN), (IHidObject)caseItemOperator);
            ISDataAbstract resolvedWhenDataType = null;
            for (IHidObject iHidObject : caseItemExpressions) {
                IHidObject rh;
                if (!HidUtils.isOperatorOfKind((IHidObject)iHidObject, (IHidOperatorConstants.OperatorKind)IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) || HidUtils.isHidImplicit((IHidObject)(rh = (IHidObject)((RfHidOperator)iHidObject).getRHValues().get(0))) && ((HidImplicit)rh).isOthers()) continue;
                resolvedWhenDataType = this.resolveCompleteOperator(iHidObject, caseExpressionContext, visited);
            }
            if (resolvedWhenDataType != null) {
                this.updateElement((IHidObject)whenOperator, resolvedWhenDataType);
            }
            return resolvedWhenDataType;
        }

        private ISDataAbstract resolveCaseExpression(IHidObject hidObject, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof HidOperator)) {
                return SDataAbstracts.UNDEFINED;
            }
            HidOperator caseOperator = (HidOperator)hidObject;
            IHidObject caseExpression = caseOperator.getLHValue();
            ISDataAbstract resolvedType = this.resolveOperand(caseExpression, null, visited);
            if (resolvedType == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
            if (dataType.getTypes().size() > 1) {
                this.reportError(hidObject, "AMBIGUOUS_EXPRESSION: Expression ''{0}'' is ambiguous; there are {1} visible:\n{2}", HidUtils.toNiceStringVHDL((IHidObject)caseExpression), Integer.toString(dataType.getTypes().size()), this.toAmbiguousErrorString(dataType.getTypes(), hidObject));
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement baseType = STransformer.INSTANCE.getBaseType(dataType.getType(), false);
            if (!(baseType instanceof RfNamedElement)) {
                return resolvedType;
            }
            RfNamedElement resolvedElement = (RfNamedElement)baseType;
            if (resolvedElement instanceof RfScalarType) {
                RfScalarType scalar = (RfScalarType)resolvedElement;
                if (scalar.isNumericType() && !scalar.hasFloatingRange() && !scalar.hasPhysicalUnits()) {
                    return resolvedType;
                }
                if (scalar.isEnumType()) {
                    return resolvedType;
                }
            } else if (resolvedElement instanceof RfListType) {
                RfListType list = (RfListType)resolvedElement;
                IRfNamedElement elementType = list.getAssociatedType();
                if (this.typeCache.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER).checkTypeCompatibility(elementType)) {
                    return resolvedType;
                }
            }
            this.reportError(hidObject, "INVALID_CASE_EXPRESSION: The case expression ''{0}'' must be a discrete type or a one-dimensional character array type", HidUtils.toNiceStringVHDL((IHidObject)caseExpression));
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveGeneric(HidOperator operator, SContext context, SDefaultOperation operation, Set<IRfNamedElement> visited) {
            ArrayList<ISDataAbstract> operandReturnTypes = new ArrayList<ISDataAbstract>();
            IHidObject leftValue = operator.getLHValue();
            HidOperator workingOperator = operator;
            boolean aggregateLHS = false;
            if (operation == SOperation.ASSIGNMENT_INSTANCE && leftValue instanceof RfHidOperator) {
                if (((RfHidOperator)leftValue).isAggregate()) {
                    workingOperator = ((RfHidOperator)workingOperator).mirror();
                    leftValue = workingOperator.getLHValue();
                    aggregateLHS = true;
                } else if (((IRfHidOperatorLayer)leftValue).isDeclarationList()) {
                    leftValue = (IHidObject)((HidOperator)leftValue).getRHValues().get(0);
                }
            }
            ISDataAbstract firstDataType = this.resolveOperand(leftValue, SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), (IHidObject)operator), visited);
            operandReturnTypes.add(firstDataType);
            if (firstDataType == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            SContext newContext = SContext.of(SDataUtils.getDataType((ISDataAbstract)firstDataType), (IHidObject)workingOperator);
            ISDataAbstract secondDataType = null;
            ListContainer rightValues = workingOperator.getRHValues();
            if (rightValues != null) {
                int i = rightValues.size() - 1;
                while (i >= 0) {
                    IHidObject rhValue = (IHidObject)rightValues.get(i);
                    secondDataType = this.resolveOperand(rhValue, newContext, visited);
                    if (aggregateLHS && rightValues.size() == 1 && newContext.dataType.getTypes().size() > 1) {
                        return secondDataType;
                    }
                    operandReturnTypes.add(secondDataType);
                    if (secondDataType == SDataAbstracts.UNDEFINED) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    --i;
                }
            }
            OperatorInfo operatorInfo = new OperatorInfo(workingOperator, this.parserPath, (IRfNamedElement)this.getScope(), false);
            ISDataAbstract resolvedType = operation.calculate(this.configInfo, operatorInfo, operandReturnTypes, context);
            operator.setOperatorResolvedType(resolvedType);
            if (operator.isSignalAssignment()) {
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof Hid && ((Hid)lhValue).isExternalName()) {
                    lhValue = (IHidObject)((Hid)lhValue).getAccesses().get(0);
                }
                if (HidUtils.isOperatorOfType((IHidObject)lhValue, (IHidOperatorConstants.OperatorType)IHidOperatorConstants.OperatorType.EXTERNAL_NAME)) {
                    IRfNamedElement element;
                    ISDataAbstract operatorResolvedType = ((HidOperator)lhValue).getOperatorResolvedType();
                    if (operatorResolvedType != null && operatorResolvedType != SDataAbstracts.UNDEFINED && !this.isSignal(element = SDataUtils.getDataType((ISDataAbstract)operatorResolvedType).getType())) {
                        String targetName = HidUtils.toNiceStringVHDL((IHidObject)((IHidObject)((HidOperator)lhValue).getRHValues().get(1)));
                        this.reportError(lhValue, "ILLEGAL_SIGNAL_ASSIGNMENT: Target ''{0}'' is not a signal", targetName);
                        return SDataAbstracts.UNDEFINED;
                    }
                } else {
                    Set leftHandHids = HidUtils.flattenToHids((IHidObject)lhValue, (Set)HidFlatteningOption.IMPLICITS_AND_SELECT_OBJECTS_EXCLUDED);
                    Iterator targetName = leftHandHids.iterator();
                    while (targetName.hasNext()) {
                        IHid parentHid;
                        IHid tmp = parentHid = (IHid)targetName.next();
                        if (parentHid == null || parentHid.hasOccurrence(HidQualifierCache.EXTERNAL_PATH_NAME)) continue;
                        boolean foundSignal = false;
                        while (parentHid != null) {
                            IRfNamedElement leftElement = parentHid.getElement();
                            foundSignal = this.isSignal(leftElement);
                            if (foundSignal) break;
                            parentHid = parentHid.getParentHid();
                        }
                        if (foundSignal) continue;
                        this.reportError(operator.getLHValue(), "ILLEGAL_SIGNAL_ASSIGNMENT: Target ''{0}'' is not a signal", HidUtils.toNiceStringVHDL((IHidObject)tmp));
                        return SDataAbstracts.UNDEFINED;
                    }
                }
            } else if (operator.isAssignment()) {
                RfHidOperator lhOperator;
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof Hid) {
                    RfHid lhHid = (RfHid)lhValue;
                    if (this.checkSignalTarget(lhHid)) {
                        return SDataAbstracts.UNDEFINED;
                    }
                } else if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getAccessKind() == Integer.MIN_VALUE) {
                    Hid lhHid = ((RfHidAccess)lhValue).getParentHid();
                    if (this.checkSignalTarget(lhHid)) {
                        return SDataAbstracts.UNDEFINED;
                    }
                } else if (lhValue instanceof RfHidOperator && (lhOperator = (RfHidOperator)lhValue).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    boolean hasSignals = false;
                    for (IHidObject concatObject : lhOperator.getRHValues()) {
                        Hid lhHid;
                        if (concatObject instanceof Hid && this.checkSignalTarget((Hid)concatObject)) {
                            hasSignals = true;
                        }
                        if (!(concatObject instanceof RfHidAccess) || ((RfHidAccess)concatObject).getAccessKind() != Integer.MIN_VALUE || !this.checkSignalTarget(lhHid = ((RfHidAccess)concatObject).getParentHid())) continue;
                        hasSignals = true;
                    }
                    if (hasSignals) {
                        return SDataAbstracts.UNDEFINED;
                    }
                }
            }
            return resolvedType;
        }

        private boolean checkSignalTarget(Hid hid) {
            RfVariable lhVariable;
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfVariable && (lhVariable = (RfVariable)element).isSignal()) {
                String targetName = HidUtils.toNiceStringVHDL((IHidObject)hid);
                this.reportError((IHidObject)hid, "ILLEGAL_SIGNAL_ASSIGNMENT: Cannot use signal ''{0}'' as left hand side in variable assignment", targetName);
                return true;
            }
            return false;
        }

        private boolean isSignal(IRfNamedElement leftElement) {
            if (leftElement instanceof RfAlias) {
                for (IRfNamedElement chunk : ((RfAlias)leftElement).getTranslatedElementChunks()) {
                    if (!this.isSignal(chunk)) continue;
                    return true;
                }
            }
            return DesignUtils.isFieldSignal((Object)leftElement) || leftElement instanceof IRfPortElement;
        }

        private ISDataAbstract resolveMethodCall(IHidObject hidObject, SContext context, SFunctionOperation functionOperation, Set<IRfNamedElement> visited) {
            ArrayList<IHidObject> argValues = new ArrayList<IHidObject>();
            boolean isConcatenation = hidObject instanceof HidOperator && ((HidOperator)hidObject).isVHDLConcatenation();
            Map<SFunctionOperation.FunctionFilter, List<RfFunction>> filteredFunctions = null;
            if (hidObject instanceof HidOperator) {
                ISDataAbstract concatenationResult;
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    argValues.add(operator.getLHValue());
                }
                if (operator.getRHValues() != null) {
                    argValues.addAll(OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false));
                }
                if (operator.isConcatenation() && (concatenationResult = this.resolveConcatenationCall(argValues, context, (IHidObject)operator)) != SDataAbstracts.UNDEFINED) {
                    return concatenationResult;
                }
                RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
                filteredFunctions = functionOperation.getFilteredFunctions(operator, argValues.size(), context, this.getScope(), rfProject.getOperatorScopeCache());
            } else if (hidObject instanceof HidAccess && ((HidAccess)hidObject).isMethodCall(true)) {
                RfHidAccess hidAccess = (RfHidAccess)hidObject;
                IRfNamedElement element = hidAccess.getParentHid() != null ? hidAccess.getParentHid().getElement() : null;
                List<IHidObject> accessArgs = hidAccess.getArgumentValues();
                argValues.addAll(accessArgs != null ? accessArgs : Collections.emptyList());
                int nofUniqueArguments = 0;
                HashSet<String> uniqueAncestorArgumentNames = new HashSet<String>();
                if (accessArgs != null) {
                    for (IHidObject arg : accessArgs) {
                        IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw((IHidObject)arg, (long)HidOperatorQualifier.IS_ARGUMENT_VALUE.value());
                        if (formalPartRaw == null) {
                            ++nofUniqueArguments;
                            continue;
                        }
                        if (!HidUtils.isHid((IHidObject)formalPartRaw)) continue;
                        Hid hidPart = (Hid)formalPartRaw;
                        String ancestorName = hidPart.getName();
                        if (hidPart.getParentHid() != null) {
                            ancestorName = hidPart.getAncestorHid().getName();
                        }
                        if (uniqueAncestorArgumentNames.contains(ancestorName)) continue;
                        uniqueAncestorArgumentNames.add(ancestorName);
                    }
                }
                if ((filteredFunctions = functionOperation.getFilteredFunctions(element, nofUniqueArguments += uniqueAncestorArgumentNames.size(), context, hidAccess.getSelects().size())) == null) {
                    return SDataAbstracts.UNDEFINED;
                }
            } else if (hidObject instanceof RfHid && ((RfHid)hidObject).isMethodCall(true)) {
                RfHid hid = (RfHid)hidObject;
                if (hid.hasAccesses()) {
                    return this.resolveCompleteOperator((IHidObject)hid.getFirstAccess(), context, visited);
                }
                filteredFunctions = functionOperation.getFilteredFunctions(hid.getElement(), 0, context, 0);
            } else {
                if (hidObject instanceof RfHid) {
                    IRfNamedElement element = ((RfHid)hidObject).getElement();
                    if (element instanceof RfAlias) {
                        element = ((RfAlias)element).getTranslatedType();
                    }
                    if (element != null && !(element instanceof RfFunction)) {
                        this.reportError(hidObject, "ILLEGAL_STATEMENT: Cannot use non-procedure call ''{0}'' as statement", ((RfHid)hidObject).getElement().getName());
                    }
                }
                return SDataAbstracts.UNDEFINED;
            }
            if (filteredFunctions == null) {
                return SDataAbstracts.UNDEFINED;
            }
            return this.internalResolveMethodCall(hidObject, context, argValues, isConcatenation, filteredFunctions, argValues.size(), functionOperation, visited);
        }

        private ISDataAbstract resolveConcatenationCall(List<IHidObject> argValues, SContext context, IHidObject functionCall) {
            if (context == null) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement contextElement = STransformer.INSTANCE.getBaseType(context.getRfElement(), false);
            if (!(contextElement instanceof RfListType)) {
                return SDataAbstracts.UNDEFINED;
            }
            RfListType arrayType = (RfListType)contextElement;
            SContext arrayContext = SContext.of(SDataType.of(arrayType), context.contextSource);
            IRfNamedElement elementType = arrayType.getAssociatedType();
            SContext elementContext = SContext.of(SDataType.of(elementType), context.contextSource);
            if (arrayType == null || elementType == null) {
                return SDataAbstracts.UNDEFINED;
            }
            Iterator<IHidObject> iterator = argValues.iterator();
            boolean reportErrorCache = this.reportError;
            this.reportError = false;
            IHidObject firstArg = iterator.next();
            boolean firstIsArray = false;
            ISDataAbstract firstResolvedType = this.resolveOperand(firstArg, elementContext, null);
            IRfNamedElement firstElemType = SDataUtils.getDataType((ISDataAbstract)firstResolvedType).getType();
            if (firstResolvedType == SDataAbstracts.UNDEFINED || firstElemType == null || !elementType.checkTypeCompatibility(firstElemType)) {
                firstIsArray = true;
                firstResolvedType = this.resolveOperand(firstArg, arrayContext, null);
                IRfNamedElement firstArrayElem = SDataUtils.getDataType((ISDataAbstract)firstResolvedType).getType();
                if (firstResolvedType == SDataAbstracts.UNDEFINED || !arrayType.checkTypeCompatibility(firstArrayElem)) {
                    this.reportError = reportErrorCache;
                    return SDataAbstracts.UNDEFINED;
                }
            }
            IHidObject secondArg = iterator.next();
            boolean secondIsArray = false;
            ISDataAbstract secondResolvedType = this.resolveOperand(secondArg, elementContext, null);
            IRfNamedElement secondElemType = SDataUtils.getDataType((ISDataAbstract)secondResolvedType).getType();
            if (secondResolvedType == SDataAbstracts.UNDEFINED || secondElemType == null || !elementType.checkTypeCompatibility(secondElemType)) {
                secondIsArray = true;
                secondResolvedType = this.resolveOperand(secondArg, arrayContext, null);
                IRfNamedElement secondArrayElem = SDataUtils.getDataType((ISDataAbstract)secondResolvedType).getType();
                if (secondResolvedType == SDataAbstracts.UNDEFINED || secondArrayElem == null || !arrayType.checkTypeCompatibility(secondArrayElem)) {
                    this.reportError = reportErrorCache;
                    return SDataAbstracts.UNDEFINED;
                }
            }
            this.reportError = reportErrorCache;
            RfFunction resolvedFunction = new RfFunction("&", false, 4, Arrays.asList(firstIsArray ? arrayType : elementType, secondIsArray ? arrayType : elementType), contextElement, this.getScope());
            ISDataAbstract resolvedFunctionDataType = SDataAbstracts.get((IRfNamedElement)resolvedFunction, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.updateElement(functionCall, resolvedFunctionDataType);
            return resolvedFunctionDataType;
        }

        /*
         * Unable to fully structure code
         */
        private ISDataAbstract internalResolveMethodCall(IHidObject hidObject, SContext context, List<IHidObject> argValues, boolean isConcatenation, Map<SFunctionOperation.FunctionFilter, List<RfFunction>> filteredFunctions, int noArgs, SFunctionOperation functionOperation, Set<IRfNamedElement> visited) {
            okFunctions = filteredFunctions.get((Object)SFunctionOperation.FunctionFilter.OK);
            possibleFunctions = filteredFunctions.get((Object)SFunctionOperation.FunctionFilter.POSSIBLE_SELECT_NO_FUNC);
            if (okFunctions == null) {
                return SDataAbstracts.UNDEFINED;
            }
            v0 = hasPossibleFunctions = possibleFunctions != null && possibleFunctions.isEmpty() == false;
            if (okFunctions.isEmpty() && !hasPossibleFunctions) {
                if (context.kind == SContext.VhdlContextKind.VOID) {
                    this.reportError(hidObject, "UNDEFINED_PROCEDURE: Unable to find a procedure named ''{0}''", new String[]{HidUtils.toNiceStringVHDL((IHidObject)hidObject)});
                } else if (context.kind == SContext.VhdlContextKind.TYPE) {
                    this.reportError(hidObject, "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined for expected return type ''{1}''", new String[]{"__dummy_hidobject_name__", context.getContextTypeName()});
                } else {
                    this.reportError(hidObject, "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined", new String[]{"__dummy_hidobject_name__"});
                }
                return SDataAbstracts.UNDEFINED;
            }
            operandTypesByPosition = new LinkedHashMap<Integer, ISDataAbstract>(noArgs);
            operandTypesByName = new LinkedHashMap<String, ISDataAbstract>();
            contextByPosition = noArgs > 0 ? SFunctionOperation.computeArgumentContexts(okFunctions, Integer.class, hidObject) : Collections.emptyMap();
            contextByName = noArgs > 0 ? SFunctionOperation.computeArgumentContexts(okFunctions, String.class, hidObject) : Collections.emptyMap();
            recordMemberAssociations = new LinkedHashMap<RfVariable, LinkedHashSet<String>>();
            hasUndefinedOperand = false;
            i = 0;
            while (i < noArgs) {
                block29: {
                    expression = null;
                    argumentContext = null;
                    key = null;
                    actualArgumentValue = argValues.get(i);
                    formalPartRaw = AssociationUtils.getFormalPartRaw((IHidObject)actualArgumentValue, (long)HidOperatorQualifier.IS_ARGUMENT_VALUE.value());
                    isHierarchicalArgumentAssociation = false;
                    if (formalPartRaw != null) break block29;
                    expression = actualArgumentValue;
                    key = i;
                    argumentContext = (SContext)contextByPosition.get(i);
                    ** GOTO lbl44
                }
                expression = AssociationUtils.getActualPartRaw((IHidObject)actualArgumentValue, (long)HidOperatorQualifier.IS_ARGUMENT_VALUE.value());
                if (!(formalPartRaw instanceof RfHid)) {
                    hasUndefinedOperand = true;
                } else {
                    key = ((RfHid)formalPartRaw).getName().toLowerCase();
                    argumentContext = (SContext)contextByName.get(key);
                    if (argumentContext == null && ((RfHid)formalPartRaw).getParentHid() != null) {
                        isHierarchicalArgumentAssociation = true;
                        argumentContext = this.getHierarchicalArgumentContext(contextByName, (RfHid)formalPartRaw, hidObject);
                    }
lbl44:
                    // 4 sources

                    if (argumentContext == null) {
                        if (HidUtils.isResolved((IHidObject)formalPartRaw) && !hasPossibleFunctions) {
                            this.reportError(formalPartRaw, "UNDECLARED_ARGUMENT: ''{0}'' is not an argument", new String[]{HidUtils.toNiceStringVHDL((IHidObject)formalPartRaw)});
                        }
                        hasUndefinedOperand = true;
                    } else {
                        if (isConcatenation) {
                            argumentContext.previousContext = context.previousContext != null ? context.previousContext : context;
                        }
                        resolvedTypeForOperand = null;
                        argumentContext.contextSource = actualArgumentValue instanceof IHidImplicit != false ? hidObject : actualArgumentValue;
                        resolvedTypeForOperand = this.isCompleteOperator(expression) != false ? this.resolveCompleteOperator(expression, argumentContext, visited) : this.getDataType(expression, null, visited);
                        if (SDataUtils.getDataType((ISDataAbstract)resolvedTypeForOperand) != STransformer.OPEN_DATATYPE && !(hasUndefinedOperand |= SDataUtils.getUndefinedDataType((ISDataAbstract)resolvedTypeForOperand) != null)) {
                            if (!(resolvedTypeForOperand instanceof SDataVariable)) {
                                dataType = SDataUtils.getDataType((ISDataAbstract)resolvedTypeForOperand);
                                this.reportError(expression, "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable", new String[]{dataType.getName()});
                                return SDataAbstracts.TYPE_UNDEFINED;
                            }
                            if (key instanceof Integer) {
                                operandTypesByPosition.put(i, resolvedTypeForOperand);
                            } else if (isHierarchicalArgumentAssociation && formalPartRaw != null) {
                                chunkList = ((RfHid)formalPartRaw).getHidNameAsStringList();
                                ancestorName = ((DataTypeChunk)chunkList.get((int)0)).name;
                                if (!operandTypesByName.containsKey(ancestorName)) {
                                    operandTypesByName.put(ancestorName, (ISDataAbstract)contextByName.get((Object)ancestorName).dataType);
                                }
                                if ((ancestorHid = ((RfHid)formalPartRaw).getAncestorHid()).getElement() instanceof RfVariable) {
                                    ancestorVariable = (RfVariable)ancestorHid.getElement();
                                    set = (LinkedHashSet<String>)recordMemberAssociations.get(ancestorVariable);
                                    if (set == null) {
                                        set = new LinkedHashSet<String>();
                                        set.add(((DataTypeChunk)chunkList.get((int)1)).name);
                                        recordMemberAssociations.put(ancestorVariable, set);
                                    } else {
                                        set.add(((DataTypeChunk)chunkList.get((int)1)).name);
                                    }
                                }
                            } else {
                                operandTypesByName.put((String)key, resolvedTypeForOperand);
                            }
                        }
                    }
                }
                ++i;
            }
            if (!recordMemberAssociations.isEmpty()) {
                for (Map.Entry<K, V> entry : recordMemberAssociations.entrySet()) {
                    associatedArgument = (RfVariable)entry.getKey();
                    associatedMembers = (Set)entry.getValue();
                    associatedType = associatedArgument.getAssociatedType();
                    if (!(associatedType instanceof RfNamedElement)) continue;
                    localMembers = ((RfNamedElement)associatedType).getLocalMembers(RfVariable.class);
                    for (RfVariable localMember : localMembers) {
                        if (associatedMembers.contains(localMember.getName())) continue;
                        this.reportError(hidObject, "INCOMPLETE_RECORD_ARGUMENT: Formal argument ''{0}'' of type ''{1}'' is missing an association for element ''{2}''", new String[]{associatedArgument.getName(), associatedType.getName(), localMember.getName()});
                    }
                }
            }
            if (hasUndefinedOperand) {
                filteredFunctions.put(SFunctionOperation.FunctionFilter.OK, Collections.emptyList());
                if (!hasPossibleFunctions) {
                    return SDataAbstracts.UNDEFINED;
                }
            }
            okFunctions.addAll(possibleFunctions);
            resolvedType = this.finishOperator(hidObject, true, context, functionOperation, okFunctions, operandTypesByPosition, operandTypesByName, visited);
            return resolvedType;
        }

        private SContext getHierarchicalArgumentContext(Map<String, SContext> contextByName, RfHid rfHid, IHidObject functionCall) {
            List stringList = rfHid.getHidNameAsStringList();
            if (stringList == null || stringList.isEmpty()) {
                return null;
            }
            SContext context = null;
            for (DataTypeChunk chunk : stringList) {
                if (context == null) {
                    context = contextByName.get(chunk.name);
                } else {
                    ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)context.dataType);
                    if (dataType == null) {
                        return null;
                    }
                    IRfNamedElement type = dataType.getType();
                    if (type instanceof RfVariable) {
                        type = ((RfVariable)type).getAssociatedType();
                    }
                    if (!(type instanceof RfRecordType)) {
                        return null;
                    }
                    if ((type = ((RfRecordType)type).getLocalMember(RfVariable.class, chunk.name)) == null) {
                        return null;
                    }
                    context = SContext.of(SDataType.of(type), functionCall);
                }
                if (context != null) continue;
                return null;
            }
            return context;
        }

        private ISDataAbstract resolveQualifiedExpression(HidOperator operator, Set<IRfNamedElement> visited) {
            ISDataAbstract resolvedType;
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.size() != 1) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject typeHid = (IHidObject)rhValues.get(0);
            if (!HidUtils.isHid((IHidObject)typeHid) || !HidUtils.isResolved((IHidObject)typeHid)) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType contextDataType = SDataType.of(((Hid)typeHid).getElement());
            SContext context = SContext.of(contextDataType, (IHidObject)operator);
            IHidObject expression = operator.getLHValue();
            if (this.isCompleteOperator(expression)) {
                resolvedType = this.resolveCompleteOperator(expression, context, visited);
                if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                    return SDataAbstracts.UNDEFINED;
                }
                if (!contextDataType.checkTypeCompatibility(SDataUtils.getDataType((ISDataAbstract)resolvedType))) {
                    this.reportError((IHidObject)operator, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)expression), context.getContextTypeName());
                    return SDataAbstracts.UNDEFINED;
                }
            } else {
                resolvedType = this.getDataType(expression, context, visited);
            }
            if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            resolvedType = SDataAbstracts.get((IRfNamedElement)context.dataType.getType(), null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            operator.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveIfCondition(HidOperator operator, Set<IRfNamedElement> visited) {
            ISDataAbstract resolvedType = this.resolveGeneralCondition(operator.getLHValue(), operator, visited);
            operator.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveGeneralCondition(IHidObject hidObject, HidOperator originalOperator, Set<IRfNamedElement> visited) {
            ISDataType contextDataType = this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.BOOLEAN);
            SContext newContext = SContext.of(contextDataType, (IHidObject)originalOperator);
            boolean tmp = this.reportError;
            this.reportError = false;
            ISDataAbstract resolvedType = this.resolveCompleteOperator(hidObject, newContext, visited);
            this.reportError = tmp;
            if (SDataUtils.getUndefinedDataType((ISDataAbstract)resolvedType) == null) {
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
                if (dataType.getTypes().size() > 1) {
                    List<RfFunction> ambiguousFunctions = this.getFunctionsFromHidObject(hidObject);
                    if (ambiguousFunctions == null) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    int noPossibilities = ambiguousFunctions.size();
                    this.reportError(hidObject, "AMBIGUOUS_EXPRESSION: Expression ''{0}'' is ambiguous; there are {1} visible:\n{2}", SEvaluator.DUMMY_HIDOBJECT_NAME, String.valueOf(noPossibilities), this.toAmbiguousErrorString(ambiguousFunctions, hidObject));
                    return resolvedType;
                }
                return resolvedType;
            }
            IHidObject implicitConditionOperator = SFunctionOperation.isPredefinedConditionOperator(hidObject) ? hidObject : this.createImplicitConditionOperator(hidObject, (HidOccurrence)(HidUtils.getOccurrence((IHidObject)hidObject) == null ? originalOperator.getOccurrence() : HidUtils.getOccurrence((IHidObject)hidObject)));
            resolvedType = this.resolveCompleteOperator(implicitConditionOperator, newContext, visited);
            if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            return resolvedType;
        }

        private List<RfFunction> getFunctionsFromHidObject(IHidObject hidObject) {
            if (hidObject == null) {
                return null;
            }
            IRfNamedElement element = null;
            switch (hidObject.getHidKind()) {
                case ACCESS: {
                    Hid parentHid = ((RfHidAccess)hidObject).getParentHid();
                    if (parentHid == null) break;
                    element = parentHid.getElement();
                    break;
                }
                case HID: {
                    element = ((Hid)hidObject).getElement();
                    break;
                }
                case HOLDER: {
                    break;
                }
                case IMPLICIT: {
                    break;
                }
                case OPERATOR: {
                    ISDataAbstract operatorResolvedType = ((HidOperator)hidObject).getOperatorResolvedType();
                    if (!(operatorResolvedType instanceof SDataVariable)) break;
                    element = ((SDataVariable)operatorResolvedType).getVariable();
                    break;
                }
            }
            if (element instanceof RfFunctionsHolder) {
                return ((RfFunctionsHolder)element).getLocalMembers(RfFunction.class);
            }
            return null;
        }

        private IHidObject createImplicitConditionOperator(IHidObject conditionExpression, HidOccurrence occurrence) {
            boolean isOperatorOccurrence = occurrence instanceof HidOperatorOccurrence;
            int offset = occurrence.getOffset();
            int virtualOffset = occurrence.getVirtualOffset();
            int line = occurrence.getLine();
            int openBoundary = isOperatorOccurrence ? ((HidOperatorOccurrence)occurrence).getOpenBoundary() : offset;
            int closeBoundary = isOperatorOccurrence ? ((HidOperatorOccurrence)occurrence).getCloseBoundary() : offset + HidUtils.toNiceStringVHDL((IHidObject)conditionExpression).length();
            HidOperatorOccurrence newOccurrence = new HidOperatorOccurrence(offset, virtualOffset, line, openBoundary, -1, closeBoundary, -1, 0L, null);
            return STransformer.makeStandInOperator(conditionExpression, null, 211, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, COND_OP_TEXT, newOccurrence, 0L);
        }

        private ISDataAbstract resolveTypeConversion(RfHidAccess typeConvAccess, STypeConversionOperation currentOperation, Set<IRfNamedElement> visited) {
            List selects = typeConvAccess.getSelects();
            if (selects == null || selects.isEmpty()) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject expression = (IHidObject)selects.get(0);
            SContext context = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), (IHidObject)typeConvAccess);
            context.operation = currentOperation;
            ISDataAbstract resolvedType = this.resolveOperand(expression, context, visited);
            if (!currentOperation.checkValidExpressionType(typeConvAccess, expression, resolvedType, this)) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement conversionType = typeConvAccess.getAssociatedType();
            return SDataAbstracts.get((IRfNamedElement)conversionType, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        }

        private static Hid getFormalPrefixForRecord(IHidObject candidate) {
            IHidObject lhSide;
            HidOperator operator;
            if (candidate instanceof HidOperator && ((operator = (HidOperator)candidate).isAssignment() || operator.isAssociation()) && (lhSide = operator.getLHValue()) instanceof Hid) {
                return (Hid)lhSide;
            }
            return null;
        }

        private ISDataAbstract resolveAggregate(HidOperator aggregate, SContext context, SAggregateOperation currentOperation, Set<IRfNamedElement> visited) {
            if (context.kind != SContext.VhdlContextKind.TYPE) {
                SDataVariable resolvedType = SDataVariable.of((ISDataType)STransformer.ANY_AGGREGATE_DATATYPE, (IRfNamedElement)SDataAbstracts.ANY_AGGREGATE, (boolean)false);
                aggregate.setOperatorResolvedType((ISDataAbstract)resolvedType);
                return resolvedType;
            }
            Collection contextTypes = context.dataType.getTypes();
            if (contextTypes.size() == 1) {
                IRfNamedElement contextType = STransformer.INSTANCE.getBaseType((IRfNamedElement)contextTypes.iterator().next(), false);
                if (contextType instanceof RfType && ((RfType)contextType).isGeneric()) {
                    return SDataAbstracts.UNDEFINED;
                }
                if (contextType instanceof RfRecordType) {
                    return this.resolveAggregateInRecordContext(aggregate, context, currentOperation, visited, contextType);
                }
                if (contextType instanceof RfListType) {
                    return this.resolveAggregateInArrayContext(aggregate, context, currentOperation, visited, contextType);
                }
            } else {
                ArrayList<IRfNamedElement> validContexts = new ArrayList<IRfNamedElement>();
                for (IRfNamedElement contextType : contextTypes) {
                    IRfNamedElement baseContextType = STransformer.INSTANCE.getBaseType(contextType, false);
                    if (baseContextType instanceof RfType && ((RfType)contextType).isGeneric()) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    if (!(baseContextType instanceof RfRecordType) && !(baseContextType instanceof RfListType)) continue;
                    validContexts.add(contextType);
                }
                if (validContexts.isEmpty()) {
                    this.reportError((IHidObject)aggregate, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)aggregate), context.getContextTypeName());
                    return SDataAbstracts.UNDEFINED;
                }
                if (validContexts.size() == 1) {
                    IRfNamedElement contextType;
                    contextType = STransformer.INSTANCE.getBaseType((IRfNamedElement)contextTypes.iterator().next(), false);
                    if (contextType instanceof RfRecordType) {
                        return this.resolveAggregateInRecordContext(aggregate, context, currentOperation, visited, contextType);
                    }
                    if (contextType instanceof RfListType) {
                        return this.resolveAggregateInArrayContext(aggregate, context, currentOperation, visited, contextType);
                    }
                    return SDataAbstracts.UNDEFINED;
                }
                int noPossibilities = validContexts.size();
                this.reportError((IHidObject)aggregate, "AMBIGUOUS_EXPRESSION: Expression ''{0}'' is ambiguous; there are {1} visible:\n{2}", HidUtils.toNiceString((IHidObject)aggregate), String.valueOf(noPossibilities), this.toAmbiguousErrorString(validContexts, (IHidObject)aggregate));
                return SDataAbstracts.UNDEFINED;
            }
            this.reportError((IHidObject)aggregate, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)aggregate), context.getContextTypeName());
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract resolveAggregateInArrayContext(HidOperator aggregate, SContext context, SAggregateOperation currentOperation, Set<IRfNamedElement> visited, IRfNamedElement contextType) {
            IRfNamedElement newContextType = ((IRfAssociatedType)contextType).getResolvedType(true);
            if (!(newContextType instanceof IRfAssociatedType)) {
                return SDataAbstracts.UNDEFINED;
            }
            SContext arrayElementContext = SContext.of(SDataType.of(newContextType), (IHidObject)aggregate);
            SContext arrayContext = SContext.of(SDataType.of(contextType), (IHidObject)aggregate);
            ListContainer associations = aggregate.getRHValues();
            int i = associations.size() - 1;
            while (i >= 0) {
                ISDataAbstract formalType;
                IHidObject association = (IHidObject)associations.get(i);
                SContext formalPartContext = SContext.of(context.getFirstIndexContextDataType(this), association);
                IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw((IHidObject)association, (long)HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                IHidObject expression = null;
                if (formalPartRaw == null) {
                    expression = association;
                } else if (currentOperation.isMultipleElementChoice(formalPartRaw)) {
                    RfHidOperator multipleChoice = (RfHidOperator)formalPartRaw;
                    ListContainer rhValues = multipleChoice.getRHValues();
                    if (rhValues != null) {
                        for (IHidObject rhValue : rhValues) {
                            ISDataAbstract formalType2 = this.resolveOperand(rhValue, formalPartContext, visited);
                            if (formalType2 != SDataAbstracts.UNDEFINED) continue;
                            return SDataAbstracts.UNDEFINED;
                        }
                    }
                } else if (!currentOperation.isOthersChoice(formalPartRaw) && (formalType = this.resolveOperand(formalPartRaw, formalPartContext, visited)) == SDataAbstracts.UNDEFINED) {
                    return SDataAbstracts.UNDEFINED;
                }
                if (expression == null) {
                    expression = AssociationUtils.getActualPartRaw((IHidObject)association, (long)HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                }
                boolean tmp = this.reportError;
                this.reportError = false;
                ISDataAbstract resolvedType = this.resolveOperand(expression, arrayContext, visited);
                this.reportError = tmp;
                if (resolvedType == SDataAbstracts.UNDEFINED) {
                    resolvedType = this.resolveOperand(expression, arrayElementContext, visited);
                }
                if (resolvedType == SDataAbstracts.UNDEFINED) {
                    return SDataAbstracts.UNDEFINED;
                }
                if (formalPartRaw != null) {
                    ((RfHidOperator)association).setOperatorResolvedType(resolvedType);
                }
                --i;
            }
            ISDataAbstract resolvedType = SDataAbstracts.get((IRfNamedElement)context.dataType.getType(), null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            aggregate.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveAggregateInRecordContext(HidOperator aggregate, SContext context, SAggregateOperation currentOperation, Set<IRfNamedElement> visited, IRfNamedElement contextType) {
            Hid formalPrefix = VhdlSemanticOperatorVisitor.getFormalPrefixForRecord(context.contextSource);
            RfRecordType recordContext = (RfRecordType)contextType;
            List<RfVariable> recordVariables = recordContext.getRecordElements();
            Set<RfVariable> alreadyChecked = Collections.newSetFromMap(new IdentityHashMap());
            ListContainer associations = aggregate.getRHValues();
            if (associations.size() > recordVariables.size()) {
                this.reportError((IHidObject)aggregate, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)aggregate), context.getContextTypeName());
                return SDataAbstracts.UNDEFINED;
            }
            int position = -1;
            int i = associations.size() - 1;
            while (i >= 0) {
                IHidObject association = (IHidObject)associations.get(i);
                IHidObject formalPartRaw = AssociationUtils.getFormalPartRaw((IHidObject)association, (long)HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                IRfNamedElement correspondentType = null;
                Object contextSource = association;
                IHidObject expression = null;
                RfVariable recordElement = null;
                if (formalPartRaw == null) {
                    recordElement = recordVariables.get(++position);
                    correspondentType = STransformer.INSTANCE.getBaseType(recordElement, false);
                    alreadyChecked.add(recordElement);
                    expression = association;
                    contextSource = aggregate;
                } else if (currentOperation.isMultipleElementChoice(formalPartRaw)) {
                    correspondentType = currentOperation.checkMultipleElementChoice(true, formalPartRaw, alreadyChecked, recordContext, this);
                    if (correspondentType == null) {
                        return SDataAbstracts.UNDEFINED;
                    }
                } else if (currentOperation.isOthersChoice(formalPartRaw)) {
                    if (alreadyChecked.size() >= recordVariables.size()) {
                        this.reportError(association, "INVALID_AGGREGATE: Others choice in ''{0}'' record aggregate must represent at least one element", recordContext.getName());
                        return SDataAbstracts.UNDEFINED;
                    }
                    correspondentType = currentOperation.checkOthersChoice(association, alreadyChecked, recordVariables, this);
                    if (correspondentType == null) {
                        return SDataAbstracts.UNDEFINED;
                    }
                } else {
                    String correspondentName;
                    if (!currentOperation.checkSimpleFormalPart(true, formalPartRaw)) {
                        this.reportError(formalPartRaw instanceof HidImplicit ? association : formalPartRaw, "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not a simple name", HidUtils.toNiceStringVHDL((IHidObject)formalPartRaw));
                        return SDataAbstracts.UNDEFINED;
                    }
                    Hid formalPartHid = (Hid)formalPartRaw;
                    if (formalPrefix != null && formalPartHid.getParentAccess() == null && HidUtils.isOperator((IHidObject)association)) {
                        Hid formalPartCopy = formalPartHid.upwardsCopy(true);
                        Hid formalPrefixCopy = formalPrefix.upwardsCopy(true);
                        if (formalPartCopy != null) {
                            STransformer.makeStandInAccess(formalPrefixCopy, formalPartCopy, 4, null);
                            HidOperator replaced = (HidOperator)association;
                            contextSource = STransformer.makeStandInOperator((IHidObject)formalPartCopy, OptimizedUtils.asList((ListContainer)replaced.getRHValues(), (boolean)false), replaced.getOperatorType(), replaced.getOperatorKind(), replaced.getOperatorText(), replaced.getOccurrence(), replaced.getQualifiers());
                        }
                    }
                    if ((correspondentType = STransformer.INSTANCE.getBaseType(recordElement = recordContext.getLocalMember(RfVariable.class, correspondentName = formalPartHid.getName()), false)) == null) {
                        this.reportError((IHidObject)formalPartHid, "INVALID_AGGREGATE: Record aggregate choice ''{0}'' is not an element of record type ''{1}''", correspondentName, contextType.getName());
                        return SDataAbstracts.UNDEFINED;
                    }
                    if (alreadyChecked.contains(recordElement)) {
                        this.reportError(association, "DUPLICATE_RECORD_ASSOCIATION: Formal ''{0}'' is associated more than once", recordElement.getName());
                        return SDataAbstracts.UNDEFINED;
                    }
                    alreadyChecked.add(recordElement);
                }
                if (expression == null) {
                    expression = AssociationUtils.getActualPartRaw((IHidObject)association, (long)HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER);
                }
                SContext newContext = SContext.of(SDataType.of(correspondentType), contextSource);
                ISDataAbstract resolvedType = this.resolveOperand(expression, newContext, visited);
                if (formalPartRaw != null) {
                    ((RfHidOperator)association).setOperatorResolvedType(resolvedType);
                    if (formalPartRaw instanceof RfHid) {
                        ((RfHid)formalPartRaw).setElement(recordElement);
                        this.registerTypeDependency(recordElement);
                    } else if (formalPartRaw instanceof RfHidOperator) {
                        RfHidOperator multipleOperator = (RfHidOperator)formalPartRaw;
                        ListContainer choices = multipleOperator.getRHValues();
                        int j = choices.size() - 1;
                        while (j >= 0) {
                            IHidObject choice = (IHidObject)choices.get(j);
                            if (choice instanceof RfHid) {
                                String correspondentName = ((RfHid)choice).getName();
                                recordElement = recordContext.getLocalMember(RfVariable.class, correspondentName);
                                ((RfHid)choice).setElement(recordElement);
                                this.registerTypeDependency(recordElement);
                            }
                            --j;
                        }
                    }
                }
                --i;
            }
            if (alreadyChecked.size() < recordVariables.size()) {
                for (RfVariable variable : recordVariables) {
                    if (alreadyChecked.contains(variable)) continue;
                    if (formalPrefix != null) {
                        this.reportError((IHidObject)aggregate, "INCOMPLETE_RECORD_AGGREGATE: Formal ''{0}'' of type ''{1}'' is missing an association for element ''{2}''", HidUtils.toStringBuilder((IHidObject)formalPrefix, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (LanguageKind)LanguageKind.VHDL).toString(), contextType.getFullNameLabel(), variable.getName());
                        continue;
                    }
                    this.reportError((IHidObject)aggregate, "INCOMPLETE_RECORD_AGGREGATE: Formal of type ''{0}'' is missing an association for element ''{1}''", contextType.getFullNameLabel(), variable.getName());
                }
                return SDataAbstracts.UNDEFINED;
            }
            ISDataAbstract resolvedType = SDataAbstracts.get((IRfNamedElement)context.dataType.getType(), null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
            aggregate.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveRange(IHidObject hidObject, Set<IRfNamedElement> visited, SContext rangeContext) {
            IHidObject rhValue;
            RfNamedElement scope = this.getScope();
            HidOperator rangeOperator = (HidOperator)hidObject;
            ListContainer rhValues = rangeOperator.getRHValues();
            if (rangeOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                for (IHidObject op : rhValues) {
                    SOperation operation = SOperation.getOperation(op, scope);
                    if (operation != SOperation.RANGE_OPERATION && operation != SOperation.ATTRIBUTE_OPERATION) continue;
                    this.resolveCompleteOperator(op, null, visited);
                }
                return SDataAbstracts.UNDEFINED;
            }
            if (rangeContext == null || this.typeCache.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE) == rangeContext.dataType.getType()) {
                rangeContext = scope instanceof RfScalarType && ((RfScalarType)scope).hasPhysicalUnits() ? SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.INTEGER), hidObject) : SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), hidObject);
            }
            Object resolvedType = null;
            ISDataAbstract lhSideResolvedType = null;
            ISDataAbstract rhSideResolvedType = null;
            IRfNamedElement lhSideNamedElement = null;
            IRfNamedElement rhSideNamedElement = null;
            IHidObject lhValue = rangeOperator.getLHValue();
            lhSideResolvedType = this.resolveOperand(lhValue, rangeContext, visited);
            if (lhSideResolvedType != null && lhSideResolvedType != SDataAbstracts.UNDEFINED && SDataUtils.getDataType((ISDataAbstract)lhSideResolvedType).getTypes().size() == 1 && !(lhSideNamedElement = SDataUtils.getDataType((ISDataAbstract)lhSideResolvedType).getType()).isPredefined() && lhSideNamedElement == this.getScope()) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject iHidObject = rhValue = rhValues == null || rhValues.isEmpty() ? null : (IHidObject)rhValues.get(0);
            if (rhValue != null && (rhSideResolvedType = this.resolveOperand(rhValue, rangeContext, visited)) != null && rhSideResolvedType != SDataAbstracts.UNDEFINED && SDataUtils.getDataType((ISDataAbstract)rhSideResolvedType).getTypes().size() == 1 && !(rhSideNamedElement = SDataUtils.getDataType((ISDataAbstract)rhSideResolvedType).getType()).isPredefined() && rhSideNamedElement == this.getScope()) {
                return SDataAbstracts.UNDEFINED;
            }
            if (lhSideNamedElement != null && rhSideNamedElement != null) {
                if (!lhSideNamedElement.checkTypeCompatibility(rhSideNamedElement)) {
                    this.reportError((IHidObject)rangeOperator, "INVALID_RANGE: Range left bound type ''{0}'' is different from right bound type ''{1}''", lhSideNamedElement.getName(), rhSideNamedElement.getName());
                    return SDataAbstracts.UNDEFINED;
                }
                resolvedType = lhSideResolvedType;
            } else {
                resolvedType = lhSideNamedElement != null ? lhSideResolvedType : (rhSideNamedElement != null ? rhSideResolvedType : SDataAbstracts.UNDEFINED);
            }
            rangeOperator.setOperatorResolvedType(resolvedType);
            return resolvedType;
        }

        private ISDataAbstract resolveArraySelect(IHidObject hidObject, SContext context) {
            if (!HidUtils.isHidAccess((IHidObject)hidObject)) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement arraySelectType = ((HidAccess)hidObject).getAssociatedType();
            if (arraySelectType == null) {
                return SDataAbstracts.UNDEFINED;
            }
            if (context != null && !arraySelectType.checkTypeCompatibility(context.dataType.getType())) {
                this.reportError(hidObject, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)hidObject), context.getContextTypeName());
                return SDataAbstracts.UNDEFINED;
            }
            Hid parentHid = ((HidAccess)hidObject).getParentHid();
            return parentHid == null ? SDataVariable.of((ISDataType)SDataType.of(arraySelectType), (boolean)false) : SDataVariable.of((ISDataType)SDataType.of(arraySelectType), (IRfNamedElement)parentHid.getElement(), (boolean)false);
        }

        private ISDataAbstract resolveAttribute(IHidObject hidObject, SAttributeOperation currentOperation, Set<IRfNamedElement> visited) {
            IRfNamedElement attributeType = currentOperation.getAttributeType(hidObject, this, visited);
            if (attributeType == null) {
                return SDataAbstracts.UNDEFINED;
            }
            boolean isVariable = !(attributeType instanceof RfAttribute) || ((RfAttribute)attributeType).isValue();
            return isVariable ? SDataAbstracts.get((IRfNamedElement)attributeType, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false) : SDataType.of(attributeType);
        }

        private ISDataAbstract finishOperator(IHidObject hidObject, boolean reducePossibilities, SContext context, SFunctionOperation functionOperation, Collection<RfFunction> possibleFunctions, Map<Integer, ISDataAbstract> operandTypesByPosition, Map<String, ISDataAbstract> operandTypesByName, Set<IRfNamedElement> visited) {
            IRfNamedElement type;
            ISDataType dataType;
            int noPossibilities;
            ISDataAbstract firstResolvedType = null;
            if (reducePossibilities) {
                possibleFunctions = this.reducePossibilities(possibleFunctions, operandTypesByPosition, operandTypesByName, context, functionOperation);
                Iterator<RfFunction> it = possibleFunctions.iterator();
                while (it.hasNext()) {
                    RfFunction func = it.next();
                    ISDataAbstract finalType = this.resolveArraySelectFromMethodCall(hidObject, context, func, Math.min(func.getNofArgs(), 1));
                    if (finalType == SDataAbstracts.UNDEFINED) {
                        it.remove();
                    }
                    firstResolvedType = finalType;
                }
            }
            if ((noPossibilities = possibleFunctions.size()) == 0) {
                if (context.kind == SContext.VhdlContextKind.TYPE || context.operation instanceof STypeConversionOperation) {
                    this.reportError(hidObject, "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined for expected return type ''{1}''", SEvaluator.DUMMY_HIDOBJECT_NAME, context.getContextTypeName());
                } else {
                    this.reportError(hidObject, "UNDEFINED_SUBPROGRAM: Subprogram call ''{0}'' is undefined", SEvaluator.DUMMY_HIDOBJECT_NAME);
                }
                return SDataAbstracts.UNDEFINED;
            }
            ArrayList<RfFunction> nonGenericPossibilities = new ArrayList<RfFunction>();
            for (RfFunction function : possibleFunctions) {
                boolean hasGeneric = false;
                for (RfVariable rfVariable : function.getArguments()) {
                    IRfNamedElement associatedType = rfVariable.getAssociatedType();
                    if (!(associatedType instanceof RfType) || !((RfType)associatedType).isGeneric()) continue;
                    hasGeneric = true;
                    break;
                }
                if (hasGeneric) continue;
                nonGenericPossibilities.add(function);
            }
            if (noPossibilities == 1) {
                RfFunction resolvedFunction = possibleFunctions.iterator().next();
                ISDataAbstract resolvedFunctionDataType = SDataAbstracts.get((IRfNamedElement)resolvedFunction, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                ISDataAbstract resolvedType = firstResolvedType != null ? firstResolvedType : resolvedFunctionDataType;
                this.updateElement(hidObject, resolvedFunctionDataType);
                this.updateFromCall(hidObject, resolvedFunction, functionOperation, visited);
                return resolvedType;
            }
            ISDataAbstract resolvedType = SDataAbstracts.get(possibleFunctions, (boolean)false, (boolean)true);
            this.updateElement(hidObject, resolvedType);
            if (nonGenericPossibilities.size() == 1) {
                return SDataAbstracts.UNDEFINED;
            }
            boolean hasGenericArguments = false;
            if (operandTypesByName != null && !operandTypesByName.isEmpty()) {
                for (ISDataAbstract operand : operandTypesByName.values()) {
                    dataType = SDataUtils.getDataType((ISDataAbstract)operand);
                    type = dataType.getType();
                    if (!(type instanceof RfType) || !((RfType)type).isGeneric()) continue;
                    hasGenericArguments = true;
                    break;
                }
            }
            if (!hasGenericArguments && operandTypesByPosition != null && !operandTypesByPosition.isEmpty()) {
                for (ISDataAbstract operand : operandTypesByPosition.values()) {
                    dataType = SDataUtils.getDataType((ISDataAbstract)operand);
                    type = dataType.getType();
                    if (!(type instanceof RfType) || !((RfType)type).isGeneric()) continue;
                    hasGenericArguments = true;
                    break;
                }
            }
            SContext.VhdlContextKind contextType = context.kind;
            if (!hasGenericArguments && (contextType != SContext.VhdlContextKind.ANY || context.operation instanceof STypeConversionOperation)) {
                ArrayList<RfFunction> arrayList = new ArrayList<RfFunction>(possibleFunctions);
                this.reportError(hidObject, context.kind == SContext.VhdlContextKind.VOID ? "AMBIGUOUS_SUBPROGRAM: Subprogram call ''{0}'' is ambiguous; there are {1} visible:\n{2}" : "AMBIGUOUS_EXPRESSION: Expression ''{0}'' is ambiguous; there are {1} visible:\n{2}", SEvaluator.DUMMY_HIDOBJECT_NAME, String.valueOf(noPossibilities), this.toAmbiguousErrorString(arrayList, hidObject));
                return SDataAbstracts.UNDEFINED;
            }
            return resolvedType;
        }

        private ISDataAbstract resolveArraySelectFromMethodCall(IHidObject functionHidObject, SContext context, RfFunction function, int nofIgnoredSelects) {
            if (HidUtils.isHidAccess((IHidObject)functionHidObject) && ((HidAccess)functionHidObject).getParentHid() != null) {
                List<IHidObject> selects = ((HidAccess)functionHidObject).getSelects();
                if (function.isTask()) {
                    int taskNofArgs = function.getNofArgs();
                    return taskNofArgs >= 1 && selects.size() > 1 || taskNofArgs == 0 && !selects.isEmpty() ? SDataAbstracts.UNDEFINED : null;
                }
                IRfNamedElement resolvedReturnType = STransformer.INSTANCE.getBaseType(function.getResolvedType(true), false);
                if (resolvedReturnType instanceof RfListType) {
                    selects = selects.subList(nofIgnoredSelects, selects.size());
                    IRfNamedElement resolvedType = resolvedReturnType;
                    if (!selects.isEmpty()) {
                        RfHidAccess newAccess = new RfHidAccess(Integer.MIN_VALUE, selects);
                        newAccess.setParentHid(((RfHidAccess)functionHidObject).getParentHid());
                        boolean stopAtSelect = true;
                        newAccess.resolveType(this.configInfo, false, false, this.getScope(), new RfVariable("anonymous", 1, 8192, resolvedReturnType), null, stopAtSelect, false, false, this.parserPath);
                        resolvedType = newAccess.getAssociatedType();
                        if (resolvedType == null) {
                            return SDataAbstracts.UNDEFINED;
                        }
                    }
                    if (context != null) {
                        if (resolvedType.checkTypeCompatibility(context.dataType.getType())) {
                            return SDataAbstracts.get((IRfNamedElement)resolvedType, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                        }
                        return SDataAbstracts.UNDEFINED;
                    }
                }
            }
            return null;
        }

        private String toAmbiguousErrorString(Collection<? extends IRfNamedElement> elements, IHidObject hidObject) {
            List selects = HidUtils.isHidAccess((IHidObject)hidObject) ? ((RfHidAccess)hidObject).getSelects() : Collections.emptyList();
            return elements.stream().map(element -> this.ambiguousElementToString((IRfNamedElement)element, selects)).collect(Collectors.joining(",\n"));
        }

        private String ambiguousElementToString(IRfNamedElement element, List<IHidObject> selects) {
            StringBuilder sb = new StringBuilder();
            if (element instanceof RfFunction) {
                RfFunction func = (RfFunction)element;
                int selectsIndex = func.getNofArgs() > 0 ? 1 : 0;
                sb.append(element.getSignature());
                if (selectsIndex < selects.size()) {
                    sb.append(", followed by array select ");
                    sb.append(selects.subList(selectsIndex, selects.size()));
                }
            } else {
                sb.append(element.getSignature());
            }
            return sb.toString();
        }

        private boolean isCompleteOperator(IHidObject hidObject) {
            if (HidUtils.isHidImplicit((IHidObject)hidObject)) {
                return false;
            }
            if (HidUtils.isHid((IHidObject)hidObject)) {
                RfHid rfHid = (RfHid)hidObject;
                if (rfHid.isAmbiguousElement()) {
                    return true;
                }
                if (rfHid.isMethodCall(true)) {
                    return true;
                }
                return rfHid.getParentAccess() instanceof RfHidAccess && ((RfHidAccess)rfHid.getParentAccess()).getAccessKind() == 5;
            }
            return true;
        }

        private boolean checkIsSignal(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case IMPLICIT: {
                    HidImplicit implicit = (HidImplicit)hidObject;
                    if (implicit.isOpenAssociation()) {
                        return true;
                    }
                    if (!implicit.isID()) break;
                    return true;
                }
                case OPERATOR: {
                    ISDataAbstract resolvedType;
                    IRfNamedElement variableType;
                    HidOperator operator = (HidOperator)hidObject;
                    if (operator.getOperatorType() != IHidOperatorConstants.OperatorType.EXTERNAL_NAME.id || !operator.isOperatorResolved() || !((variableType = SDataUtils.getDataType((ISDataAbstract)(resolvedType = operator.getOperatorResolvedType())).getType()) instanceof RfVariable) || !((RfVariable)variableType).isSignal()) break;
                    return true;
                }
                case HID: {
                    return this.isSignalRecursive((Hid)hidObject);
                }
                case ACCESS: {
                    return this.isSignalRecursive(((HidAccess)hidObject).getParentHid());
                }
                default: {
                    return false;
                }
            }
            return false;
        }

        private boolean isSignalRecursive(Hid parentHid) {
            if (parentHid == null) {
                return true;
            }
            boolean foundSignal = false;
            while (parentHid != null) {
                IRfNamedElement leftElement = parentHid.getElement();
                if (leftElement == null || leftElement instanceof RfAssociatedType.RfUnresolvedInfo) {
                    return true;
                }
                foundSignal = this.isSignal(leftElement);
                if (foundSignal) break;
                parentHid = parentHid.getParentHid();
            }
            return foundSignal;
        }

        private List<IHidObject> getArguments(IHidObject functionCall) {
            ArrayList<IHidObject> result = new ArrayList<IHidObject>();
            if (functionCall instanceof HidOperator) {
                HidOperator operator = (HidOperator)functionCall;
                if (operator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    result.add(operator.getLHValue());
                }
                if (operator.getRHValues() != null) {
                    result.addAll(OptimizedUtils.asList((ListContainer)operator.getRHValues(), (boolean)false));
                }
            } else if (functionCall instanceof HidAccess) {
                RfHidAccess hidAccess = (RfHidAccess)functionCall;
                List<IHidObject> arguments = hidAccess.getArgumentValues();
                return arguments != null ? arguments : Collections.emptyList();
            }
            return result;
        }

        private void updateElement(IHidObject element, ISDataAbstract resolvedType) {
            if (!this.isCompleteOperator(element)) {
                return;
            }
            switch (element.getHidKind()) {
                case ACCESS: {
                    element = ((RfHidAccess)element).getParentHid();
                    if (element == null) break;
                }
                case HID: {
                    RfHid hid = (RfHid)element;
                    if (!(resolvedType instanceof SDataVariable)) break;
                    IRfNamedElement elem = ((SDataVariable)resolvedType).getVariable();
                    hid.setElement(elem);
                    this.registerTypeDependency(elem);
                    break;
                }
                case OPERATOR: {
                    ((HidOperator)element).setOperatorResolvedType(resolvedType);
                    break;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateFromCall(IHidObject hidObject, RfFunction resolvedFunction, SFunctionOperation functionOperation, Set<IRfNamedElement> visited) {
            if (!(hidObject instanceof RfHidAccess) && !(hidObject instanceof HidOperator)) {
                return;
            }
            if (resolvedFunction == null) {
                return;
            }
            List<RfVariable> arguments = resolvedFunction.getArguments();
            if (arguments == null || arguments.isEmpty()) {
                return;
            }
            ArrayList<IRfNamedElement> resolvedFunctionArguments = new ArrayList<IRfNamedElement>(arguments.size());
            for (RfVariable argument : arguments) {
                if (argument == null) continue;
                resolvedFunctionArguments.add(argument.getResolvedType(true));
            }
            List<IHidObject> actValues = this.getArguments(hidObject);
            int i = 0;
            while (i < Math.min(actValues.size(), resolvedFunctionArguments.size())) {
                block14: {
                    IHidObject argValueObject = actValues.get(i);
                    IRfNamedElement resolvedElement = null;
                    switch (argValueObject.getHidKind()) {
                        case ACCESS: {
                            argValueObject = ((HidAccess)argValueObject).getParentHid();
                            if (argValueObject == null) break;
                        }
                        case HID: {
                            IRfNamedElement resolvedEnum;
                            IRfNamedElement functionArgResolvedElem;
                            RfHid hid = (RfHid)argValueObject;
                            resolvedElement = hid.getElement();
                            if (!(resolvedElement instanceof RfEnum) || !((functionArgResolvedElem = (IRfNamedElement)resolvedFunctionArguments.get(i)) instanceof RfScalarType) || !((RfScalarType)functionArgResolvedElem).isEnumType() || functionArgResolvedElem == ((RfEnum)resolvedElement).getParentEnumType() || (resolvedEnum = ((RfScalarType)functionArgResolvedElem).getEnumNames().get(hid.getName())) == null) break;
                            hid.setElement(resolvedEnum);
                            this.registerTypeDependency(resolvedEnum);
                            break block14;
                        }
                        case OPERATOR: {
                            HidOperator operator = (HidOperator)argValueObject;
                            if (!operator.isOperatorResolved()) break block14;
                            ISDataAbstract operatorType = operator.getOperatorResolvedType();
                            resolvedElement = operatorType instanceof SDataVariable ? ((SDataVariable)operatorType).getVariable() : SDataUtils.getDataType((ISDataAbstract)operatorType).getType();
                        }
                    }
                    ISDataAbstract resolvedType = SDataAbstracts.get((IRfNamedElement)((IRfNamedElement)resolvedFunctionArguments.get(i)), null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    SContext context = SContext.of(SDataUtils.getDataType((ISDataAbstract)resolvedType), hidObject);
                    if (resolvedElement instanceof RfFunctionsHolder) {
                        List<RfFunction> possibleFunctions = ((RfFunctionsHolder)resolvedElement).getLocalMembers(RfFunction.class);
                        STransformer.INSTANCE.reducePossibilitiesByContext(possibleFunctions, context.getRfElement());
                        if (!possibleFunctions.isEmpty()) {
                            this.finishOperator(argValueObject, false, context, functionOperation, possibleFunctions, null, null, visited);
                        }
                    } else if (SDataAbstracts.ANY_AGGREGATE.equals(resolvedElement)) {
                        this.resolveCompleteOperator(argValueObject, context, visited);
                    }
                }
                ++i;
            }
        }

        public void reportError(IHidObject hidObject, String errorMessage, String ... args) {
            if (!this.reportError || hidObject == null) {
                return;
            }
            RfProject rfProject = (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature");
            if (rfProject == null) {
                return;
            }
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (SEvaluator.DUMMY_HIDOBJECT_NAME.equals(arg)) {
                    String string = hidObject instanceof RfHidAccess && ((RfHidAccess)hidObject).getParentHid() != null ? ((RfHidAccess)hidObject).getParentHid().getName() : (hidObject instanceof RfHid ? ((RfHid)hidObject).getName() : (args[i] = hidObject instanceof RfHidOperator ? ((RfHidOperator)hidObject).getOperatorText() : ""));
                }
                if (arg.contains("DVT81b441bd_UNIVERSAL_INTEGER")) {
                    args[i] = arg.replaceAll("DVT81b441bd_UNIVERSAL_INTEGER", "integer");
                }
                if (arg.contains("DVT81b441bd_UNIVERSAL_REAL")) {
                    args[i] = arg.replaceAll("DVT81b441bd_UNIVERSAL_REAL", "real");
                }
                ++i;
            }
            if (hidObject instanceof HidAccess && ((HidAccess)hidObject).isExternalName()) {
                hidObject = (IHidObject)((HidAccess)hidObject).getSelects().get(0);
            }
            HidOccurrence firstOccurrence = HidUtils.getOccurrence((IHidObject)hidObject);
            int line = HidUtils.getLine((HidOccurrence)firstOccurrence);
            int startOffset = HidUtils.getStartOffset((HidOccurrence)firstOccurrence);
            int endOffset = HidUtils.getEndOffset((IHidObject)hidObject, (int)startOffset, (HidOccurrence)firstOccurrence);
            rfProject.addSemanticError(1, errorMessage, this.getScope().getLibPkgScope(), startOffset, endOffset, null, line, this.parserPath, args);
        }

        private Collection<RfFunction> reducePossibilities(Collection<RfFunction> functions, Map<Integer, ISDataAbstract> operandTypesByPosition, Map<String, ISDataAbstract> operandTypesByName, SContext context, SFunctionOperation operation) {
            if (functions == null || functions.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedHashSet<FuzzyFunction> result1 = new LinkedHashSet<FuzzyFunction>();
            LinkedHashSet<FuzzyFunction> result2 = new LinkedHashSet<FuzzyFunction>();
            block0: for (RfFunction function : functions) {
                Collection actualTypes;
                ISDataType actualDataType;
                ISDataAbstract operandType;
                IRfNamedElement argumentType;
                RfVariable argument;
                List<RfVariable> arguments = function.getArguments();
                if (arguments == null || arguments.isEmpty()) {
                    result2.add(new FuzzyFunction(function));
                    continue;
                }
                int noArgs = arguments.size();
                LinkedHashSet<RfVariable> matchedArguments = new LinkedHashSet<RfVariable>(noArgs);
                if (operandTypesByPosition != null && !operandTypesByPosition.isEmpty()) {
                    for (Map.Entry entry : operandTypesByPosition.entrySet()) {
                        Integer i = (Integer)entry.getKey();
                        argument = arguments.get(i);
                        argumentType = argument.getResolvedType(true);
                        operandType = (ISDataAbstract)entry.getValue();
                        actualDataType = SDataUtils.getDataType((ISDataAbstract)operandType);
                        actualTypes = actualDataType.getTypes();
                        if (!SOperation.containsType(actualTypes, argumentType)) continue block0;
                        matchedArguments.add(argument);
                    }
                }
                if (operandTypesByName != null && !operandTypesByName.isEmpty()) {
                    for (Map.Entry entry : operandTypesByName.entrySet()) {
                        String argName = (String)entry.getKey();
                        argument = function.getLocalArgument(argName);
                        if (argument == null) continue block0;
                        argumentType = argument.getResolvedType(true);
                        operandType = (ISDataAbstract)entry.getValue();
                        actualDataType = SDataUtils.getDataType((ISDataAbstract)operandType);
                        actualTypes = actualDataType.getTypes().stream().map(ne -> ne instanceof RfFunction ? ((RfFunction)ne).getResolvedType(true) : ne).collect(Collectors.toList());
                        if (!SOperation.containsType(actualTypes, argumentType)) continue block0;
                        matchedArguments.add(argument);
                    }
                }
                if (matchedArguments.size() != noArgs) {
                    for (RfVariable rfVariable : arguments) {
                        if (!matchedArguments.contains(rfVariable) && (rfVariable.getInitialValue(false) == null || rfVariable.getInitialValue(false).isEmpty())) continue block0;
                    }
                }
                if (operandTypesByPosition != null && operation.isPotentialUniversalOperation(function)) {
                    List<RfFunction> list = ((SUniversalOperation)operation).getSpecializedFunctions(function, new ArrayList<ISDataAbstract>(operandTypesByPosition.values()), context, this.getScope());
                    if (list == null || list.isEmpty()) continue;
                    for (RfFunction func : list) {
                        result1.add(new FuzzyFunction(func));
                    }
                    continue;
                }
                result2.add(new FuzzyFunction(function));
            }
            result1.addAll(result2);
            if (result1.isEmpty()) {
                return Collections.emptySet();
            }
            LinkedList<RfFunction> poss = new LinkedList<RfFunction>();
            for (FuzzyFunction fuzzy : result1) {
                poss.add(fuzzy.original);
            }
            return poss;
        }

        protected ISDataAbstract getDataType(IHidObject operand, SContext context, Set<IRfNamedElement> visited) {
            if (context == null) {
                context = SContext.of(this.typeCache.getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE), operand);
            }
            if (context == null) {
                return SDataAbstracts.UNDEFINED;
            }
            if (visited == null) {
                visited = new HashSet<IRfNamedElement>();
            }
            ISDataAbstract resolvedAbstract = null;
            switch (operand.getHidKind()) {
                case IMPLICIT: {
                    resolvedAbstract = this.getDataTypeForImplicit(operand, context);
                    break;
                }
                default: {
                    resolvedAbstract = this.getDataTypeForOperand(operand, context, visited);
                }
            }
            if (resolvedAbstract == SDataAbstracts.UNDEFINED || resolvedAbstract == null) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType resolvedType = SDataUtils.getDataType((ISDataAbstract)resolvedAbstract);
            if (resolvedType.getTypes().size() > 1) {
                return resolvedAbstract;
            }
            IRfNamedElement resolved = resolvedType.getType();
            if (resolved instanceof RfAssociatedType.RfUnresolvedInfo) {
                if (!((RfAssociatedType.RfUnresolvedInfo)resolved).isErrorReporting()) {
                    return SDataAbstracts.UNDEFINED;
                }
                IRfNamedElement parentScope = ((RfAssociatedType.RfUnresolvedInfo)resolved).getParentScope();
                if (parentScope != null) {
                    this.reportError(context.contextSource, "INVALID_LITERAL: String literal has a character ''{0}'' not in the enumeration type ''{1}''", resolved.getName(), parentScope.getName());
                    return SDataAbstracts.UNDEFINED;
                }
                Collection<IRfNamedElement> possible = ((RfAssociatedType.RfUnresolvedInfo)resolved).getCandidates();
                if (possible != null && possible.size() > 1) {
                    return SDataAbstracts.get(possible, (boolean)false, (boolean)true);
                }
                if (context.kind == SContext.VhdlContextKind.TYPE) {
                    this.reportError(context.contextSource, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)operand), context.getContextTypeName());
                }
                return SDataAbstracts.UNDEFINED;
            }
            if (context.contextSource != null && context.dataType != null && resolved != null && !context.dataType.checkTypeCompatibility(SDataUtils.getDataType((ISDataAbstract)resolvedType))) {
                IHidObject errorHid;
                IHidObject iHidObject = errorHid = HidUtils.isHidImplicit((IHidObject)operand) && !context.contextSource.equals(operand) ? context.contextSource : operand;
                if (context.kind == SContext.VhdlContextKind.TYPE) {
                    this.reportError(errorHid, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)operand), context.getContextTypeName());
                }
                return SDataAbstracts.UNDEFINED;
            }
            return resolvedAbstract;
        }

        protected ISDataAbstract getDataTypeForOperand(IHidObject operand, @NotNull SContext context, Set<IRfNamedElement> visited) {
            switch (operand.getHidKind()) {
                case OPERATOR: {
                    return ((HidOperator)operand).getOperatorResolvedType();
                }
                case HID: {
                    boolean isLHOfAssignment;
                    Hid hid = (Hid)operand;
                    IRfNamedElement resolvedElement = hid.getElement();
                    if (visited.contains(resolvedElement)) {
                        return SDataAbstracts.UNDEFINED;
                    }
                    visited.add(resolvedElement);
                    IRfNamedElement contextElement = context.getRfElement();
                    if (resolvedElement == null && hid.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER)) {
                        if (contextElement instanceof RfScalarType && ((RfScalarType)contextElement).isEnumType() && contextElement.getEnclosingScope() instanceof RfNamedElement) {
                            resolvedElement = ((RfNamedElement)contextElement.getEnclosingScope()).semanticGetMember(hid.getName(), (IHid)hid, null, null, null, true, false, false);
                        } else {
                            RfNamedElement scope = this.getScope();
                            if (scope != null) {
                                resolvedElement = scope.semanticGetMember(hid.getName(), (IHid)hid, null, null, null, true, false, false);
                            }
                        }
                        hid.setElement(resolvedElement);
                        this.registerTypeDependency(resolvedElement);
                    }
                    boolean bl = isLHOfAssignment = context.contextSource instanceof RfHidOperator && ((RfHidOperator)context.contextSource).isAssignment() && hid.equals((Object)((RfHidOperator)context.contextSource).getLHValue());
                    if (resolvedElement instanceof RfAlias && !isLHOfAssignment) {
                        if (context.kind == SContext.VhdlContextKind.ANY) {
                            Collection<IRfNamedElement> possibleTypes = STransformer.INSTANCE.checkImplicitEnumValue(hid.getName(), this.getScope(), false);
                            if (possibleTypes == null || possibleTypes.isEmpty()) {
                                return SDataAbstracts.get((IRfNamedElement)resolvedElement, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                            }
                            possibleTypes.add(resolvedElement);
                            return SDataAbstracts.get(possibleTypes, (boolean)false, (boolean)true);
                        }
                        if (context.dataType.checkTypeCompatibility(SDataType.of(resolvedElement))) {
                            return SDataAbstracts.get((IRfNamedElement)resolvedElement, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        }
                        resolvedElement = ((RfAlias)resolvedElement).getResolvedType(true);
                    }
                    if (resolvedElement instanceof RfVariable && ((RfVariable)resolvedElement).isLoopParameter()) {
                        return this.getDataTypeForLoopParameter((RfVariable)resolvedElement, visited);
                    }
                    if (resolvedElement instanceof RfEnum) {
                        return this.getDataTypeForEnum(context, hid);
                    }
                    return SDataAbstracts.get((IRfNamedElement)resolvedElement, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            return SDataAbstracts.UNDEFINED;
        }

        private ISDataAbstract getDataTypeForEnum(SContext context, Hid hid) {
            Collection<IRfNamedElement> possibleTypes = STransformer.INSTANCE.checkImplicitEnumValue(hid.getName(), this.getScope(), false);
            if (possibleTypes == null || possibleTypes.isEmpty()) {
                return SDataAbstracts.UNDEFINED;
            }
            if (context != null) {
                STransformer.INSTANCE.reducePossibilitiesByContext(possibleTypes, context.getRfElement());
            }
            if (possibleTypes.isEmpty()) {
                if (context != null && context.kind == SContext.VhdlContextKind.TYPE) {
                    this.reportError((IHidObject)hid, "TYPE_MISMATCH: Type error resolving expression ''{0}'' to type ''{1}''", HidUtils.toNiceStringVHDL((IHidObject)hid), context.getContextTypeName());
                }
                return SDataAbstracts.UNDEFINED;
            }
            if (possibleTypes.size() == 1) {
                IRfNamedElement element = possibleTypes.iterator().next();
                hid.setElement(element);
                this.registerTypeDependency(element);
                return SDataVariable.of((ISDataType)SDataType.of(element), (boolean)false);
            }
            return SDataAbstracts.get(possibleTypes, (boolean)false, (boolean)true);
        }

        private void registerTypeDependency(IRfNamedElement element) {
            IRfNamedElement enclosingType;
            if (element instanceof RfNamedElement && (enclosingType = ((RfNamedElement)element).getEnclosingScope(IncrementalDeltaContainer.CLOSEST_TYPE_CONTAINER)) != null) {
                this.configInfo.addReference(enclosingType.getName());
            }
        }

        private ISDataAbstract getDataTypeForLoopParameter(RfVariable variable, Set<IRfNamedElement> visited) {
            RfNamedElement enclosingScope = variable.getEnclosingScope();
            IHidOperator forLoopRangeExpression = null;
            if (enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isFor()) {
                forLoopRangeExpression = ((RfActionBlock)enclosingScope).getForLoopRangeExpression();
            } else if (enclosingScope instanceof RfBlock && ((RfBlock)enclosingScope).isLoopGenerate()) {
                forLoopRangeExpression = ((RfBlock)enclosingScope).getForLoopRangeExpression();
            } else {
                return SDataAbstracts.UNDEFINED;
            }
            if (forLoopRangeExpression == null) {
                return SDataAbstracts.UNDEFINED;
            }
            IHidObject rangeExpression = forLoopRangeExpression.getLHValue();
            ISDataAbstract resolvedType = this.resolveOperand(rangeExpression, null, visited);
            if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement type = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
            if (type instanceof RfPredefinedAttribute) {
                type = ((RfPredefinedAttribute)type).getAssociatedType();
            }
            if (type != null) {
                DataType dataType = variable.getDataType();
                if (dataType != null && type.getName() != null) {
                    dataType.setTypeName(SEvaluator.filterTypeName(type.getName()));
                }
                variable.setAssociatedType(type);
            }
            return SDataVariable.of((ISDataType)SDataType.of(type), (IRfNamedElement)variable, (boolean)false);
        }

        private ISDataAbstract resolveOperand(IHidObject expression, SContext context, Set<IRfNamedElement> visited) {
            return this.isCompleteOperator(expression) ? this.resolveCompleteOperator(expression, context, visited) : this.getDataType(expression, context, visited);
        }

        private ISDataAbstract getDataTypeForImplicit(IHidObject hidObject, SContext context) {
            RfHidImplicit implicit = (RfHidImplicit)hidObject;
            if (implicit.isOpenAssociation()) {
                return SDataVariable.of((ISDataType)STransformer.OPEN_DATATYPE, (boolean)false);
            }
            if (implicit.isOthers()) {
                return SDataVariable.of((ISDataType)STransformer.OTHERS_DATATYPE, (boolean)false);
            }
            if (implicit.isLiteralNull()) {
                return SDataVariable.of((ISDataType)SDataType.of((IRfNamedElement)SDataAbstracts.NULL_IMPLICIT), (boolean)false);
            }
            if (implicit.isLiteralNew()) {
                return SDataVariable.of((ISDataType)SDataType.of((IRfNamedElement)SDataAbstracts.NEW_IMPLICIT), (boolean)false);
            }
            if (implicit.isID()) {
                RfVariable field = this.getScope().getLocalMember(RfVariable.class, implicit.getName(), true);
                return SDataAbstracts.get((IRfNamedElement)field, null, null, null, (LanguageKind)LANG_KIND, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (context == null) {
                return SDataAbstracts.UNDEFINED;
            }
            IRfNamedElement resolved = implicit.guessType(context.getRfElement(), this.getScope(), (RfProject)this.configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature"), true);
            if (resolved == null) {
                return SDataAbstracts.UNDEFINED;
            }
            return SDataVariable.of((ISDataType)SDataType.of(resolved), (boolean)false);
        }

        private static class FuzzyFunction {
            public final RfFunction original;

            public FuzzyFunction(RfFunction function) {
                this.original = function;
            }

            public int hashCode() {
                return 1;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof FuzzyFunction)) {
                    return false;
                }
                return this.original.equals(((FuzzyFunction)obj).original, false);
            }

            public String toString() {
                return this.original.toString();
            }
        }
    }
}

