/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.OperatorScopeCache;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class SFunctionOperation
extends SOperation {
    private static final String CONDITIONAL_OPERATOR_FULL_TEXT = "\"??\"";

    public Map<FunctionFilter, List<RfFunction>> getFilteredFunctions(HidOperator operator, int noArgs, SContext context, RfNamedElement scope, OperatorScopeCache operatorScopeCache) {
        List<RfFunction> functions;
        String operatorText = DVTStringUtil.toLowerCase((String)operator.getOperatorText());
        String operatorText2 = DVTStringUtil.appendString((Object[])new Object[]{"\"", operatorText, "\""});
        if (this.isPredefinedOperator(operatorText2)) {
            operatorText = operatorText2;
        }
        if ((functions = operatorScopeCache.get(scope, operatorText)) == null) {
            functions = scope.getFunctionsWithPrefix(operatorText, 1, false);
            operatorScopeCache.put(scope, operatorText, functions);
        }
        return this.getFilteredFunctions(functions, noArgs, context, 0);
    }

    public Map<FunctionFilter, List<RfFunction>> getFilteredFunctions(IRfNamedElement functionHolderWrapper, int noArgs, SContext context, int nofSelects) {
        if (functionHolderWrapper == null) {
            return Collections.emptyMap();
        }
        List<RfFunction> functions = null;
        if (functionHolderWrapper instanceof RfFunctionsHolder) {
            functions = ((RfFunctionsHolder)functionHolderWrapper).getLocalMembers(RfFunction.class);
        } else if (functionHolderWrapper instanceof RfAlias && ((RfAlias)functionHolderWrapper).getAssociatedType() instanceof RfFunction) {
            functions = Collections.singletonList((RfFunction)((RfAlias)functionHolderWrapper).getAssociatedType());
        } else if (functionHolderWrapper instanceof RfFunction) {
            functions = Collections.singletonList((RfFunction)functionHolderWrapper);
        }
        return this.getFilteredFunctions(functions, noArgs, context, nofSelects);
    }

    public Map<FunctionFilter, List<RfFunction>> getFilteredFunctions(Collection<RfFunction> functions, int noArgValues, SContext context, int nofSelects) {
        if (functions == null || functions.isEmpty()) {
            return Collections.emptyMap();
        }
        ISDataType contextReturnType = context.dataType;
        boolean expectingReturnType = context.kind != SContext.VhdlContextKind.VOID && contextReturnType != SDataAbstracts.UNDEFINED;
        LinkedHashMap<FunctionFilter, List<RfFunction>> result = new LinkedHashMap<FunctionFilter, List<RfFunction>>();
        LinkedList<RfFunction> okFuncs = new LinkedList<RfFunction>();
        LinkedList<RfFunction> possibleFuncs = new LinkedList<RfFunction>();
        for (RfFunction function : functions) {
            switch (this.filterFunctions(function, noArgValues, (ISDataAbstract)contextReturnType, expectingReturnType, nofSelects)) {
                case IGNORE: {
                    break;
                }
                case OK: {
                    okFuncs.add(function);
                    break;
                }
                case POSSIBLE_SELECT_NO_FUNC: {
                    possibleFuncs.add(function);
                    break;
                }
            }
        }
        result.put(FunctionFilter.OK, okFuncs);
        result.put(FunctionFilter.POSSIBLE_SELECT_NO_FUNC, possibleFuncs);
        return result;
    }

    private FunctionFilter filterFunctions(RfFunction function, int noArgValues, ISDataAbstract contextReturnType, boolean expectingReturnType, int nofSelects) {
        int nofFuncArgs = function.getNofArgs();
        if (nofFuncArgs > 0 && nofFuncArgs < noArgValues) {
            return FunctionFilter.IGNORE;
        }
        if (contextReturnType == STransformer.PROCEDURE_RETURN_TYPE && !function.isTask() || expectingReturnType && function.isTask()) {
            return FunctionFilter.IGNORE;
        }
        if (expectingReturnType) {
            IRfNamedElement contextElement;
            IRfNamedElement associatedElement = function.getResolvedType(true);
            if (associatedElement == null || associatedElement instanceof RfAssociatedType.RfUnresolvedInfo) {
                return FunctionFilter.IGNORE;
            }
            ISDataType returnDataType = SDataType.of(associatedElement);
            if (returnDataType == null) {
                return FunctionFilter.IGNORE;
            }
            IRfNamedElement returnElement = returnDataType.getType();
            if (!this.checkSelectCompatibility(returnElement, contextElement = SDataUtils.getDataType((ISDataAbstract)contextReturnType).getType(), nofFuncArgs == 0 ? nofSelects : nofSelects - 1)) {
                return FunctionFilter.IGNORE;
            }
        } else if (noArgValues > nofFuncArgs) {
            return FunctionFilter.IGNORE;
        }
        if (noArgValues > 0 && nofFuncArgs == 0) {
            return FunctionFilter.POSSIBLE_SELECT_NO_FUNC;
        }
        return FunctionFilter.OK;
    }

    private boolean checkSelectCompatibility(IRfNamedElement returnType, IRfNamedElement contextType, int nofSelects) {
        returnType = STransformer.INSTANCE.getBaseType(returnType, false);
        contextType = STransformer.INSTANCE.getBaseType(contextType, false);
        int i = 0;
        while (i < nofSelects) {
            if (!(returnType instanceof RfListType)) {
                return false;
            }
            if (contextType.checkTypeCompatibility(returnType)) {
                return true;
            }
            returnType = ((RfListType)returnType).getAssociatedType();
            ++i;
        }
        return contextType.checkTypeCompatibility(returnType);
    }

    private boolean isPredefinedOperator(String operatorText) {
        return RfFunction.PREDEFINED_OPERATORS.contains(operatorText);
    }

    public static boolean isPredefinedConditionOperator(IHidObject hidObject) {
        if (hidObject == null) {
            return false;
        }
        switch (hidObject.getHidKind()) {
            case OPERATOR: {
                return ((RfHidOperator)hidObject).isConditionalOperator();
            }
            case ACCESS: {
                Hid parentHid = ((HidAccess)hidObject).getParentHid();
                if (parentHid == null) {
                    return false;
                }
                return CONDITIONAL_OPERATOR_FULL_TEXT.equals(parentHid.getName());
            }
        }
        return false;
    }

    public static <T> Map<T, SContext> computeArgumentContexts(List<RfFunction> possibleFunctions, Class<T> clazz, IHidObject functionCall) {
        LinkedHashMap<Object, SContext> result = new LinkedHashMap<Object, SContext>();
        block0: for (RfFunction possible : possibleFunctions) {
            List<RfVariable> arguments = possible.getArguments();
            if (arguments == null || arguments.isEmpty()) continue;
            Integer i = 0;
            while (i < arguments.size()) {
                RfVariable argument = arguments.get(i);
                Object key = clazz == Integer.class ? i : argument.getKey();
                SContext previousContext = (SContext)result.get(key);
                if (previousContext == null || previousContext.kind != SContext.VhdlContextKind.ANY) {
                    IRfNamedElement argumentType = argument.getResolvedType(true);
                    if (argumentType == null) continue block0;
                    ISDataType dataType = SDataType.of(argumentType);
                    if (previousContext == null || !previousContext.dataType.getType().equals(argumentType)) {
                        dataType = previousContext == null ? dataType : possible.getRfProject().getStandardDataType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE);
                        result.put(key, SContext.of(dataType, functionCall));
                    }
                }
                i = i + 1;
            }
        }
        return result;
    }

    public static enum FunctionFilter {
        OK,
        IGNORE,
        POSSIBLE_SELECT_NO_FUNC;

    }

    public static class SLogicalOperation
    extends SFunctionOperation {
    }
}

