/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.OperatorInfo;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SAggregateOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SAttributeOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SCaseItemOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SCaseOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SConditionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDefaultOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SFunctionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SPortConnectionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SQualifierOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SRangeOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STypeConversionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SUniversalOperation;

public abstract class SOperation {
    public static final SOperation IF_OPERATION = new SConditionOperation();
    public static final SOperation QUALIFIED_INSTANCE = new SQualifierOperation();
    public static final SOperation ATTRIBUTE_OPERATION = new SAttributeOperation();
    public static final SOperation ARRAY_SELECT = new SDefaultOperation();
    public static final SOperation AGGREGATE = new SAggregateOperation();
    public static final SOperation TYPE_CONVERSION = new STypeConversionOperation();
    public static final SOperation ASSIGNMENT_INSTANCE = new SDefaultOperation.SAssignmentOperation();
    public static final SOperation RANGE_OPERATION = new SRangeOperation();
    public static final SOperation FUNCTION_OPERATION = new SFunctionOperation();
    public static final SOperation UNIVERSAL_FUNCTION_OPERATION = new SUniversalOperation.SUniversalFunctionOperation();
    public static final SOperation LOGICAL_OPERATION = new SFunctionOperation.SLogicalOperation();
    public static final SOperation ARITHMETIC_UNIVERSAL = new SUniversalOperation.SArithmeticOperation();
    public static final SOperation COMPARISON_UNIVERSAL = new SUniversalOperation.SComparisonOperation();
    public static final SOperation EQUALITY_UNIVERSAL = new SUniversalOperation.SEqualityOperation();
    public static final SOperation CONCATENATION_UNIVERSAL = new SUniversalOperation.SConcatenationOperation();
    public static final SOperation LIST_OPERATION = new SDefaultOperation.SListOperation();
    public static final SOperation CASE_ITEM_WHEN_OPERATION = new SCaseItemOperation();
    public static final SOperation CASE_OPERATION = new SCaseOperation();
    public static final SOperation WAIT_OPERATION = new SDefaultOperation();
    public static final SOperation ASSERT_OPERATION = new SDefaultOperation();
    public static final SOperation REPORT_OPERATION = new SDefaultOperation();
    public static final SOperation WHILE_OPERATION = new SDefaultOperation();
    public static final SOperation NEXT_OPERATION = new SDefaultOperation();
    public static final SOperation EXIT_OPERATION = new SDefaultOperation();
    public static final SOperation WHEN_OPERATION = new SDefaultOperation();
    public static final SOperation PHYSICAL_UNIT_SECONDARY_DECLARATION = new SDefaultOperation();
    public static final SOperation AFTER_OPERATION = new SDefaultOperation();
    public static final SOperation SELECT_ASSIGNMENT_OPERATION = new SDefaultOperation();
    public static final SOperation EXTERNAL_NAME = new SDefaultOperation();
    public static final SOperation ENUM_DECLARATION_ASSIGN = new SDefaultOperation();
    public static final SOperation PORT_CONNECTION_OPERATION = new SPortConnectionOperation();
    public static final SOperation RETURN_STATEMENT = new SDefaultOperation();

    protected boolean checkOperandIsVariable(ISDataAbstract operand) {
        return operand instanceof SDataVariable;
    }

    protected ISDataType acceptOperandsNature(List<ISDataAbstract> operands, ConfigInfo configInfo, OperatorInfo operatorInfo, boolean triggerError) {
        int i = 0;
        while (i < operands.size()) {
            ISDataAbstract operand = operands.get(i);
            if (SDataUtils.getDataType((ISDataAbstract)operand) == SDataAbstracts.ILLEGAL || SDataUtils.getDataType((ISDataAbstract)operand) == SDataAbstracts.UNDEFINED) {
                return SDataAbstracts.UNDEFINED;
            }
            if (operand != SDataAbstracts.TYPE_UNDEFINED && !this.checkOperandIsVariable(operand)) {
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operand);
                if (dataType != null) {
                    SOperation.addSemanticError(configInfo, triggerError, operatorInfo, "ILLEGAL_TYPE_REFERENCE: ''{0}'' cannot be resolved to a variable", dataType.getName());
                }
                return SDataAbstracts.TYPE_UNDEFINED;
            }
            ++i;
        }
        return null;
    }

    public ISDataType checkValidOperands(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, List<ISDataAbstract> operands) {
        ISDataType nonValidOperand = this.acceptOperandsNature(operands, configInfo, operatorInfo, triggerError);
        if (nonValidOperand == SDataAbstracts.UNDEFINED) {
            return SDataAbstracts.UNDEFINED;
        }
        if (nonValidOperand == SDataAbstracts.TYPE_UNDEFINED) {
            return SDataAbstracts.TYPE_UNDEFINED;
        }
        if (nonValidOperand != null) {
            SOperation.addSemanticError(configInfo, triggerError, operatorInfo, "UNDECLARED_TYPE: Type ''{0}'' is not declared", nonValidOperand.getName());
            return SDataAbstracts.ILLEGAL;
        }
        return null;
    }

    public static SOperation getOperation(IHidObject hidObject, RfNamedElement scope) {
        if (hidObject instanceof HidOperator) {
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (operator.hasQualifier(HidQualifierCache.IS_DECLARATION_EXPRESSION_QUALIFIER) && operator.hasQualifier(HidQualifierCache.IS_HIDDEN_QUALIFIER)) {
                return ENUM_DECLARATION_ASSIGN;
            }
            if (operator.isExternalName()) {
                return EXTERNAL_NAME;
            }
            if (operator.isReport()) {
                return REPORT_OPERATION;
            }
            if (operator.isAssociation()) {
                return null;
            }
            if (operator.isSelectAssignment()) {
                return SELECT_ASSIGNMENT_OPERATION;
            }
            if (operator.isNext()) {
                return NEXT_OPERATION;
            }
            if (operator.isWhen()) {
                return WHEN_OPERATION;
            }
            if (operator.isAfter()) {
                return AFTER_OPERATION;
            }
            if (operator.isExit()) {
                return EXIT_OPERATION;
            }
            if (operator.isWhile()) {
                return WHILE_OPERATION;
            }
            if (operator.isAssert()) {
                return ASSERT_OPERATION;
            }
            if (operator.isWaitStatement()) {
                return WAIT_OPERATION;
            }
            if (operator.isCaseCondition()) {
                return CASE_OPERATION;
            }
            if (operator.isCaseItemCondition()) {
                return CASE_ITEM_WHEN_OPERATION;
            }
            if (operator.isAggregate()) {
                return AGGREGATE;
            }
            if (operator.isAssignment()) {
                return ASSIGNMENT_INSTANCE;
            }
            if (operator.isRangeOrPartSelect() || operator.isLiteralRange() || operator.isConstraint() || operator.isSelectList()) {
                return RANGE_OPERATION;
            }
            if (operator.isConditionalOperator()) {
                return FUNCTION_OPERATION;
            }
            if (operator.isIfCondition()) {
                return IF_OPERATION;
            }
            if (operator.isComma()) {
                return LIST_OPERATION;
            }
            if (operator.isVHDLConcatenation()) {
                return CONCATENATION_UNIVERSAL;
            }
            if (operator.isArithmetic()) {
                return ARITHMETIC_UNIVERSAL;
            }
            if (operator.isEqualityOrInequality()) {
                return scope instanceof RfScalarType && ((RfScalarType)scope).hasPhysicalUnits() ? PHYSICAL_UNIT_SECONDARY_DECLARATION : EQUALITY_UNIVERSAL;
            }
            if (operator.isLogical()) {
                return LOGICAL_OPERATION;
            }
            if (operator.isLogicalShift()) {
                return LOGICAL_OPERATION;
            }
            if (operator.isComparison()) {
                return COMPARISON_UNIVERSAL;
            }
            if (operator.isQualifiedExpression()) {
                return QUALIFIED_INSTANCE;
            }
            if (operator.isAbs() || operator.isExponentiation()) {
                return FUNCTION_OPERATION;
            }
            if (operator.isReturnStatement()) {
                return RETURN_STATEMENT;
            }
        } else if (hidObject instanceof RfHidAccess) {
            RfHidAccess hidAccess = (RfHidAccess)hidObject;
            Hid parentHid = hidAccess.getParentHid();
            if (parentHid == null) {
                return null;
            }
            if (((RfHid)parentHid).isAmbiguousElement()) {
                return null;
            }
            if (hidAccess.isMethodCall(true)) {
                return SOperation.getFunctionOperation(parentHid.getName());
            }
            if (hidAccess.getAccessKind() == Integer.MIN_VALUE) {
                List selects = hidAccess.getSelects();
                if (selects != null && !selects.isEmpty() && HidUtils.isOperatorOfType((IHidObject)((IHidObject)selects.get(0)), (IHidOperatorConstants.OperatorType)IHidOperatorConstants.OperatorType.EXTERNAL_NAME)) {
                    return EXTERNAL_NAME;
                }
                if (parentHid.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER)) {
                    return ATTRIBUTE_OPERATION;
                }
                if (parentHid.getElement() == null) {
                    return SOperation.getOperation((IHidObject)parentHid, scope);
                }
                if (parentHid.getElement() instanceof RfVariable) {
                    RfVariable element = (RfVariable)parentHid.getElement();
                    if (element.getAssociatedType() instanceof RfFunction) {
                        return null;
                    }
                    if (STransformer.INSTANCE.getBaseType(element.getAssociatedType(), true) instanceof RfListType) {
                        return ARRAY_SELECT;
                    }
                    return null;
                }
                return TYPE_CONVERSION;
            }
        } else if (hidObject instanceof RfHid) {
            RfHid hid = (RfHid)hidObject;
            if (hid.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER)) {
                return ATTRIBUTE_OPERATION;
            }
            if (hid.isAmbiguousElement()) {
                return null;
            }
            if (hid.isMethodCall(true)) {
                return SOperation.getFunctionOperation(hid.getName());
            }
            if (hid.isPotentialMethodCall()) {
                return SOperation.getFunctionOperation(hid.getName());
            }
        }
        return null;
    }

    private static SOperation getFunctionOperation(String name) {
        return "to_string".equalsIgnoreCase(name) || "deallocate".equalsIgnoreCase(name) ? UNIVERSAL_FUNCTION_OPERATION : FUNCTION_OPERATION;
    }

    protected static void addSemanticWarning(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, Object ... arguments) {
        if (triggerError) {
            SOperation.addSemanticError(configInfo, 2, operatorInfo, message, arguments);
        }
    }

    protected static void addSemanticError(ConfigInfo configInfo, boolean triggerError, OperatorInfo operatorInfo, String message, Object ... arguments) {
        if (triggerError) {
            SOperation.addSemanticError(configInfo, 1, operatorInfo, message, arguments);
        }
    }

    private static void addSemanticError(ConfigInfo configInfo, int messageKind, OperatorInfo operatorInfo, String message, Object ... arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] instanceof String) {
                String arg = (String)arguments[i];
                if (arg.contains("DVT81b441bd_UNIVERSAL_INTEGER")) {
                    arguments[i] = arg.replaceAll("DVT81b441bd_UNIVERSAL_INTEGER", "integer");
                }
                if (arg.contains("DVT81b441bd_UNIVERSAL_REAL")) {
                    arguments[i] = arg.replaceAll("DVT81b441bd_UNIVERSAL_REAL", "real");
                }
            }
            ++i;
        }
        ParserPath parserPath = operatorInfo.getParserPath();
        Map<String, Object> attributes = null;
        HidOperatorOccurrence occurrence = operatorInfo.getOperator().getOccurrence();
        int line = occurrence.getLine();
        int startOffset = occurrence.getOpenBoundary();
        int endOffset = occurrence.getCloseBoundary();
        IRfNamedElement scope = operatorInfo.getScope();
        if (scope == null) {
            return;
        }
        LibraryPackageScope libPackageScope = scope.getLibPkgScope();
        ((RfProject)configInfo.getRfProject("ro.amiq.vhdldt.VhdlNature")).addSemanticError(messageKind, message, libPackageScope, startOffset, endOffset, attributes, line, parserPath, arguments);
    }

    public static boolean containsType(Collection<IRfNamedElement> actualTypes, IRfNamedElement argumentType) {
        for (IRfNamedElement type : actualTypes) {
            if (!type.checkTypeCompatibility(argumentType)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotentialUniversalOperation(RfFunction function) {
        return false;
    }
}

