/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISTransformer;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataTypeCategory;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SDataType;

public enum STransformer implements ISTransformer
{
    INSTANCE;

    public static final ISDataType OTHERS_DATATYPE;
    public static final ISDataType OPEN_DATATYPE;
    public static final ISDataType ANY_AGGREGATE_DATATYPE;
    public static final DummyElement PROCEDURE_RETURN_TYPE_IMPLICIT;
    public static final ISDataType PROCEDURE_RETURN_TYPE;
    public static final DummyElement ALREADY_CHECKED_ELEMENT;
    public static final RfVariable ALREADY_CHECKED_VARIABLE;
    public static final IHidBuilders BUILDERS;

    static {
        OTHERS_DATATYPE = SDataType.of((IRfNamedElement)SDataAbstracts.OTHERS_DUMMY);
        OPEN_DATATYPE = SDataType.of((IRfNamedElement)SDataAbstracts.OPEN_DUMMY);
        ANY_AGGREGATE_DATATYPE = SDataType.of((IRfNamedElement)SDataAbstracts.ANY_AGGREGATE);
        PROCEDURE_RETURN_TYPE_IMPLICIT = new DummyElement("void");
        PROCEDURE_RETURN_TYPE = DummyDataType.of((IRfNamedElement)PROCEDURE_RETURN_TYPE_IMPLICIT);
        ALREADY_CHECKED_ELEMENT = new DummyElement("already_checked_element");
        ALREADY_CHECKED_VARIABLE = new RfVariable("anonymous", 1, 8192, (IRfNamedElement)ALREADY_CHECKED_ELEMENT);
        BUILDERS = new IHidBuilders(){

            public RfHidImplicit buildImplicit(String name, int type) {
                return STransformer.makeStandInImplicit(name, type);
            }

            public RfHid buildHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long hidQualifiers) {
                return STransformer.makeStandInHid(name, resolved, occurrence, hidQualifiers);
            }

            public RfHidAccess buildAccess(Hid first, Hid second, int access) {
                return STransformer.makeStandInAccess(first, second, access, null);
            }

            public HidAccess buildAccess(Hid parent, Hid child, List<IHidObject> selects, int access) {
                return null;
            }

            public RfHidOperator buildOperator(IHidObject lhSide, List<IHidObject> rhSide, int type, IHidOperatorConstants.OperatorKind kind, String text, HidOperatorOccurrence occurrence, long operatorQualifiers) {
                return STransformer.makeStandInOperator(lhSide, rhSide, type, kind, text, occurrence, operatorQualifiers);
            }

            public HidOperator buildDefparamOperator(ElementPath hierarchyParamPath, IRfScopeElement param, String value, int offset) {
                return STransformer.makeStandInDefparamOperator(hierarchyParamPath, param, value, offset);
            }

            public HidOperator buildNotOperator(IHidObject condition, HidOperatorOccurrence occurrence) {
                return STransformer.makeStandInOperator(condition, Collections.emptyList(), 83, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "not", occurrence, 0L);
            }

            public HidOperator buildCycleDelayConstOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
                return null;
            }

            public HidOperator buildCycleDelayRangeOperator(IHidObject lhSide, List<IHidObject> rhSide, IHidOperatorConstants.OperatorKind kind, HidOperatorOccurrence occurrence) {
                return null;
            }
        };
    }

    public ISDataAbstract transform(IRfNamedElement element, IRfNamedElement scope, ELWidthCheckContext elabContext, HashSet<IRfNamedElement> visited, boolean isFinal, boolean isVariable, boolean dimensionsWithMacros, boolean isNetAlias, boolean isRNMTech) {
        if (!(element instanceof RfNamedElement)) {
            return SDataAbstracts.UNDEFINED;
        }
        if (element instanceof RfAlias) {
            element = ((RfAlias)element).getTranslatedType();
        }
        ISDataType dataType = SDataType.of(element);
        if (element instanceof RfType) {
            RfType type = (RfType)element;
            if (type.isGeneric()) {
                return SDataAbstracts.UNDEFINED;
            }
            return isVariable ? SDataVariable.of((ISDataType)dataType, (boolean)isFinal) : dataType;
        }
        if (element instanceof RfFunction) {
            RfFunction function = (RfFunction)element;
            dataType = SDataType.of(function.getResolvedType(true));
            return SDataVariable.of((ISDataType)dataType, (IRfNamedElement)function, (boolean)isFinal);
        }
        if (element instanceof RfEnum) {
            RfNamedElement resolvedType = ((RfEnum)element).getParentEnumType();
            if (resolvedType == null) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType dataType1 = SDataType.of(resolvedType);
            return SDataVariable.of((ISDataType)dataType1, (IRfNamedElement)element, (boolean)isFinal);
        }
        if (element instanceof RfVariable) {
            IRfNamedElement resolvedType = ((RfVariable)element).getResolvedType(true);
            if (resolvedType == null) {
                return SDataAbstracts.UNDEFINED;
            }
            ISDataType dataType1 = SDataType.of(resolvedType);
            return SDataVariable.of((ISDataType)dataType1, (IRfNamedElement)element, (boolean)isFinal);
        }
        return dataType;
    }

    public ISDataAbstract transform(Collection<? extends IRfNamedElement> elements, boolean isFinal, boolean isVariable) {
        boolean isFunctionVariable;
        if (elements == null || elements.isEmpty()) {
            return SDataAbstracts.UNDEFINED;
        }
        if (elements.size() == 1) {
            return this.transform(elements.iterator().next(), null, null, null, isFinal, isVariable, false, false, false);
        }
        ArrayList<RfFunction> functionElements = new ArrayList<RfFunction>();
        for (IRfNamedElement element : elements) {
            if (!(element instanceof RfFunction)) continue;
            RfFunction function = (RfFunction)element;
            functionElements.add(function);
        }
        boolean bl = isFunctionVariable = functionElements.size() == elements.size();
        if (isFunctionVariable) {
            elements = elements.stream().map(el -> ((RfFunction)el).getResolvedType(true)).collect(Collectors.toList());
        }
        ISDataType dataType = SDataType.of(elements);
        RfFunctionsHolder variableType = isFunctionVariable ? new RfFunctionsHolder(((Object)functionElements).toString(), functionElements) : elements.iterator().next();
        return SDataVariable.of((ISDataType)dataType, (IRfNamedElement)variableType, (boolean)isFinal);
    }

    public SDataTypeCategory getCategory(ISDataAbstract dataType) {
        return SDataTypeCategory.UNKNOWN;
    }

    public IRfNamedElement getBaseType(IRfNamedElement element, boolean translateAccess) {
        return this.getBaseType(element, translateAccess, new HashSet<IRfNamedElement>());
    }

    private IRfNamedElement getBaseType(IRfNamedElement element, boolean translateAccess, Set<IRfNamedElement> visited) {
        IRfNamedElement cachedBaseType;
        if (!translateAccess && element instanceof RfNamedElement && (cachedBaseType = ((RfNamedElement)element).getCachedBaseType()) != null) {
            return cachedBaseType;
        }
        if (visited.contains(element)) {
            return element;
        }
        visited.add(element);
        IRfNamedElement resolvedBaseType = element;
        if (element instanceof RfListType) {
            resolvedBaseType = element;
        } else if (element instanceof RfAssociatedType) {
            resolvedBaseType = this.getBaseType(((RfAssociatedType)element).getResolvedType(true), translateAccess, visited);
        } else if (element instanceof RfType) {
            RfType type = (RfType)element;
            if (type.isSubtype() || translateAccess && type.isAccess()) {
                resolvedBaseType = this.getBaseType(type.getResolvedType(true), translateAccess, visited);
            }
        } else if (element instanceof RfEnum) {
            resolvedBaseType = ((RfEnum)element).getParentEnumType();
        }
        if (!translateAccess && element instanceof RfNamedElement) {
            ((RfNamedElement)element).setCachedBaseType(resolvedBaseType);
        }
        return resolvedBaseType;
    }

    @NotNull
    public Collection<IRfNamedElement> checkImplicitEnumValue(String name, RfNamedElement scope, boolean isPhysical) {
        if (name == null) {
            return Collections.emptyList();
        }
        return scope != null ? scope.getEnumTypeCandidates(name, isPhysical) : Collections.emptyList();
    }

    public static final RfHidOperator makeStandInOperator(IHidObject lhValue, List<IHidObject> rhValues, int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, HidOperatorOccurrence occurrence, long qualifiers) {
        RfHidOperator operator = new RfHidOperator(operatorType, operatorKind, operatorText, occurrence, null);
        operator.addLHValue(lhValue);
        if (rhValues == null || rhValues.isEmpty()) {
            return operator;
        }
        for (IHidObject rhValue : rhValues) {
            operator.addRHValue(rhValue);
        }
        operator.addQualifier(qualifiers);
        return operator;
    }

    private static HidOperator makeStandInDefparamOperator(ElementPath hierarchyParamPath, IRfScopeElement param, String value, int offset) {
        if (hierarchyParamPath == null || hierarchyParamPath.isEmpty()) {
            return null;
        }
        Object rhSide = null;
        if (value.charAt(0) == '\"') {
            rhSide = STransformer.makeStandInImplicit(value, 242);
        } else {
            Number number = DVTStringUtil.parseNumberVHDL((String)value, null);
            if (number != null) {
                rhSide = STransformer.makeStandInImplicit(value, 243);
            } else {
                IRfScopeElement scope = param.getEnclosingScope();
                if (!(scope instanceof RfNamedElement)) {
                    return null;
                }
                IRfNamedElement element = ((RfNamedElement)scope).semanticGetMember(value, null, null, (RfNamedElement)scope, null, true, true, false);
                if (element == null) {
                    return null;
                }
                rhSide = STransformer.makeStandInHid(value, element, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            }
        }
        RfHid lhSide = null;
        String[] segments = hierarchyParamPath.getSegments();
        int i = 0;
        while (i < segments.length) {
            String part = segments[i];
            if (lhSide == null) {
                lhSide = STransformer.makeStandInHid(part, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
            } else {
                RfHid newHid = STransformer.makeStandInHid(part, null, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                STransformer.makeStandInAccess(lhSide, newHid, 0, null);
                lhSide = newHid;
            }
            ++i;
        }
        HidOperatorOccurrence dummyHidOperatorOccurrence = new HidOperatorOccurrence(offset, -1, -1, 0L, null);
        RfHidOperator equalsOp = STransformer.makeStandInOperator((IHidObject)lhSide, Collections.singletonList(rhSide), 229, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "=", dummyHidOperatorOccurrence, 0L);
        return equalsOp;
    }

    public static final RfHidImplicit makeStandInImplicit(String name, int type) {
        if (name == null) {
            return null;
        }
        RfHidImplicit implicit = RfHidImplicit.makeImplicit(name, type);
        return implicit;
    }

    public static final RfHid makeStandInHid(String name, IRfNamedElement resolved, HidOccurrence occurrence, long qualifiers) {
        if (name == null) {
            return null;
        }
        RfHid hid = new RfHid(name, null, resolved, occurrence, null);
        hid.addQualifier(qualifiers);
        return hid;
    }

    public static RfHidAccess makeStandInAccess(Hid prev, Hid next, int accessKind, List<IHidObject> selects) {
        RfHidAccess access = new RfHidAccess(accessKind, selects);
        prev.addAccess((HidAccess)access);
        if (next != null) {
            access.addHid(next);
        }
        return access;
    }

    public void reducePossibilitiesByContext(Collection<? extends IRfNamedElement> possibleTypes, IRfNamedElement contextType) {
        if (contextType == null) {
            return;
        }
        Iterator<? extends IRfNamedElement> it = possibleTypes.iterator();
        while (it.hasNext()) {
            IRfNamedElement enumValue = it.next();
            if (contextType.checkTypeCompatibility(enumValue)) continue;
            it.remove();
        }
    }

    @NotNull
    public List<HidOperator> transformAssociation(HidOperator association, final IRfNamedElement lhSideElement, IRfNamedElement initialScope) {
        HidOperatorOccurrence occurrence = association.getOccurrence();
        ISContext context = new ISContext(){

            public IRfNamedElement calculateCorrespondentByPosition(int position) {
                return lhSideElement;
            }

            public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
                return lhSideElement;
            }
        };
        int index = 0;
        ArrayList collected = new ArrayList();
        boolean success = HidUtils.transformAssociation(null, (IHidObject)association, (int)index, (ISContext)context, (IRfNamedElement)initialScope, (HidOperatorOccurrence)occurrence, (long)association.getQualifiers(), (boolean)true, collected, (IHidBuilders)BUILDERS);
        return success ? collected : Collections.emptyList();
    }
}

