/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vhdldt.model.reflection.RfAnyListType;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class STypeConversionOperation
extends SOperation {
    public boolean checkValidExpressionType(RfHidAccess typeConvAccess, IHidObject operandExpression, ISDataAbstract resolvedType, SEvaluator.VhdlSemanticOperatorVisitor visitor) {
        if (resolvedType == null || resolvedType == SDataAbstracts.UNDEFINED) {
            return false;
        }
        if (SDataUtils.getDataType((ISDataAbstract)resolvedType).getTypes().size() > 1) {
            return false;
        }
        String result = this.internalCheckValidExpressionType(resolvedType);
        if (result != null) {
            visitor.reportError((IHidObject)typeConvAccess, "INVALID_TYPE_CONVERSION: The type conversion operand ''{0}'' cannot be {1}", HidUtils.toNiceStringVHDL((IHidObject)operandExpression), result);
            return false;
        }
        ISDataAbstract typeConvAccessType = SDataAbstracts.get((IRfNamedElement)typeConvAccess.getAssociatedType(), null, null, null, (LanguageKind)LanguageKind.VHDL, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        if (typeConvAccessType == null || typeConvAccessType == SDataAbstracts.UNDEFINED) {
            return true;
        }
        ISDataType typeConvDataType = SDataUtils.getDataType((ISDataAbstract)typeConvAccessType);
        ISDataType resolvedDataType = SDataUtils.getDataType((ISDataAbstract)resolvedType);
        boolean closelyRelated = this.internalCheckCloselyRelated(typeConvDataType.getType(), resolvedDataType.getType());
        if (!closelyRelated) {
            String typeMarkName = typeConvAccess.getAssociatedType().getName();
            String operandTypeName = SDataUtils.getDataType((ISDataAbstract)resolvedType).getName();
            visitor.reportError((IHidObject)typeConvAccess, "INVALID_TYPE_CONVERSION: The conversion target type ''{0}'' and operand type ''{1}'' are not closely related", typeMarkName, operandTypeName);
            return false;
        }
        return true;
    }

    private boolean internalCheckCloselyRelated(IRfNamedElement conversionType, IRfNamedElement expressionType) {
        conversionType = STransformer.INSTANCE.getBaseType(conversionType, false);
        expressionType = STransformer.INSTANCE.getBaseType(expressionType, false);
        if (conversionType == null || expressionType == null) {
            return true;
        }
        if (conversionType.equals(expressionType)) {
            return true;
        }
        if (this.isNumericType(conversionType)) {
            return this.isNumericType(expressionType);
        }
        if (this.isArrayType(conversionType) && this.isArrayType(expressionType)) {
            IRfNamedElement conversionAssocType = ((RfListType)conversionType).getAssociatedType();
            IRfNamedElement expressionAssocType = ((RfListType)expressionType).getAssociatedType();
            return this.internalCheckCloselyRelated(conversionAssocType, expressionAssocType);
        }
        return false;
    }

    private String internalCheckValidExpressionType(ISDataAbstract resolvedType) {
        IRfNamedElement type = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
        if (type == SDataAbstracts.NULL_IMPLICIT) {
            return "a literal null";
        }
        if (type == SDataAbstracts.NEW_IMPLICIT) {
            return "an allocator";
        }
        if (!(type instanceof RfNamedElement)) {
            return null;
        }
        RfProject rfProject = ((RfNamedElement)type).getRfProject();
        if (rfProject != null && type instanceof RfAnyListType && ((RfAnyListType)type).getAssociatedType().equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_CHARACTER))) {
            return "a string literal";
        }
        return null;
    }

    private boolean isNumericType(IRfNamedElement element) {
        return element instanceof RfScalarType && ((RfScalarType)element).isNumericType();
    }

    private boolean isArrayType(IRfNamedElement element) {
        return element instanceof RfListType;
    }
}

