/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.semantic.extension2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.vhdldt.model.reflection.RfAnyListType;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SContext;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SFunctionOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SOperation;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public abstract class SUniversalOperation
extends SFunctionOperation {
    public abstract List<RfFunction> getSpecializedFunctions(RfFunction var1, List<ISDataAbstract> var2, SContext var3, RfNamedElement var4);

    @Override
    public boolean isPotentialUniversalOperation(RfFunction function) {
        return function.isPredefinedOperator() && this.hasUniversalArgument(function);
    }

    protected boolean checkOperandSize(RfFunction function, Map<Integer, ISDataAbstract> operandTypesByPosition) {
        int argumentSize;
        if (function == null || operandTypesByPosition == null) {
            return false;
        }
        int n = argumentSize = function.getArguments() != null ? function.getArguments().size() : 0;
        return argumentSize == operandTypesByPosition.size();
    }

    protected boolean hasUniversalArgument(RfFunction function) {
        List<RfVariable> arguments = function.getArguments();
        if (arguments == null) {
            return false;
        }
        for (RfVariable argument : arguments) {
            RfProject rfProject;
            IRfNamedElement argumentType = argument.getResolvedType(true);
            if (argumentType instanceof RfListType) {
                argumentType = ((RfListType)argumentType).getAssociatedType();
            }
            if (!(argumentType instanceof RfNamedElement) || argumentType instanceof RfAssociatedType.RfUnresolvedInfo || (rfProject = ((RfNamedElement)argumentType).getRfProject()) == null || !this.isUniversalElement(argumentType, rfProject)) continue;
            return true;
        }
        return false;
    }

    public boolean isUniversalElement(IRfNamedElement argumentType, RfProject rfProject) {
        if (rfProject == null) {
            return false;
        }
        if (argumentType instanceof RfAnyListType) {
            return true;
        }
        return argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.INTEGER)) || argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.REAL)) || argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_ARRAY)) || argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_TYPE)) || argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_SCALAR_OR_ARRAY)) || argumentType.equals(rfProject.getStandardType(IRfVhdlTypeElement.VhdlStdType.ANY_ACCESS));
    }

    public static class SArithmeticOperation
    extends SUniversalOperation {
        @Override
        public List<RfFunction> getSpecializedFunctions(RfFunction original, List<ISDataAbstract> operandReturnTypes, SContext context, RfNamedElement scope) {
            if (original == null || operandReturnTypes == null || operandReturnTypes.isEmpty()) {
                return Collections.emptyList();
            }
            List<RfVariable> originalArguments = original.getArguments();
            IRfNamedElement originalArgumentType = originalArguments.get(0).getAssociatedType();
            if (originalArgumentType == null) {
                return Collections.emptyList();
            }
            Collection<IRfNamedElement> candidateTypes = this.getRecurringTypes(operandReturnTypes, originalArgumentType);
            if (candidateTypes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<RfFunction> result = new ArrayList<RfFunction>(candidateTypes.size());
            for (IRfNamedElement type : candidateTypes) {
                RfFunction funct = this.createFunctionFromCandidateType(original, STransformer.INSTANCE.getBaseType(type, false), scope, context);
                if (funct == null) continue;
                result.add(funct);
            }
            return result;
        }

        protected Collection<IRfNamedElement> getRecurringTypes(List<ISDataAbstract> actualValues, IRfNamedElement originalArgumentType) {
            LinkedHashSet<IRfNamedElement> result = new LinkedHashSet<IRfNamedElement>();
            for (ISDataAbstract abstractType : actualValues) {
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)abstractType);
                block1: for (IRfNamedElement type : dataType.getTypes()) {
                    for (ISDataAbstract other : actualValues) {
                        if (!other.equals(abstractType) && !SOperation.containsType(SDataUtils.getDataType((ISDataAbstract)other).getTypes(), type)) continue block1;
                    }
                    result.add(type);
                }
            }
            return result;
        }

        protected boolean checkCandidateType(IRfNamedElement type) {
            return true;
        }

        protected RfFunction createFunctionFromCandidateType(RfFunction original, IRfNamedElement recurringType, RfNamedElement scope, SContext context) {
            List<IRfNamedElement> arguments = Collections.nCopies(original.getArguments().size(), recurringType);
            if (this.isUniversalElement(recurringType, scope.getRfProject()) && context != null && context.kind == SContext.VhdlContextKind.TYPE) {
                recurringType = context.getRfElement();
            }
            if (context != null && context.isTypeCompatible(recurringType)) {
                return null;
            }
            return new RfFunction(original.getName(), false, 4, arguments, recurringType, scope);
        }
    }

    public static class SComparisonOperation
    extends SArithmeticOperation {
        @Override
        protected RfFunction createFunctionFromCandidateType(RfFunction original, IRfNamedElement type, RfNamedElement scope, SContext context) {
            List<IRfNamedElement> arguments = Collections.nCopies(original.getArguments().size(), type);
            IRfNamedElement returnType = original.getResolvedType(true);
            if (context != null && context.isTypeCompatible(returnType)) {
                return null;
            }
            return new RfFunction(original.getName(), false, 4, arguments, returnType, scope);
        }
    }

    public static class SConcatenationOperation
    extends SUniversalOperation {
        @Override
        public List<RfFunction> getSpecializedFunctions(RfFunction original, List<ISDataAbstract> operandReturnTypes, SContext context, RfNamedElement scope) {
            IRfNamedElement contextTypeElement;
            if (original == null || operandReturnTypes == null) {
                return Collections.emptyList();
            }
            if (operandReturnTypes.size() != 2) {
                return Collections.emptyList();
            }
            IRfNamedElement iRfNamedElement = contextTypeElement = context == null ? null : STransformer.INSTANCE.getBaseType(context.getRfElement(), true);
            if (contextTypeElement != null && !this.isList(contextTypeElement)) {
                return Collections.emptyList();
            }
            ArrayList<RfFunction> result = new ArrayList<RfFunction>();
            Collection actualFirstDataTypes = SDataUtils.getDataType((ISDataAbstract)operandReturnTypes.get(0)).getTypes();
            Collection actualSecondDataTypes = SDataUtils.getDataType((ISDataAbstract)operandReturnTypes.get(1)).getTypes();
            for (IRfNamedElement firstType : actualFirstDataTypes) {
                if (firstType instanceof RfFunction) {
                    firstType = ((RfFunction)firstType).getResolvedType(true);
                }
                for (IRfNamedElement secondType : actualSecondDataTypes) {
                    IRfNamedElement returnType;
                    IRfNamedElement returnTypeElement;
                    if (secondType instanceof RfFunction) {
                        secondType = ((RfFunction)secondType).getResolvedType(true);
                    }
                    if (secondType == null) continue;
                    firstType = STransformer.INSTANCE.getBaseType(firstType, false);
                    secondType = STransformer.INSTANCE.getBaseType(secondType, false);
                    boolean isFirstAnyCharacter = firstType instanceof RfAnyListType || firstType == SDataAbstracts.ANY_AGGREGATE;
                    boolean isSecondAnyCharacter = secondType instanceof RfAnyListType || secondType == SDataAbstracts.ANY_AGGREGATE;
                    IRfNamedElement iRfNamedElement2 = returnTypeElement = isFirstAnyCharacter ? secondType : firstType;
                    if (firstType.checkTypeCompatibility(secondType)) {
                        if (contextTypeElement == null) {
                            if (this.isList(returnTypeElement)) {
                                this.addFunction(original, returnTypeElement, returnTypeElement, returnTypeElement, result, scope);
                                continue;
                            }
                            returnType = new RfAnyListType(String.valueOf(returnTypeElement.getName()) + "_vector", returnTypeElement, true, null, original.getEnclosingScope());
                            this.addFunction(original, returnTypeElement, returnTypeElement, returnType, result, scope);
                            continue;
                        }
                        if (!this.isList(contextTypeElement) || !returnTypeElement.checkTypeCompatibility(contextTypeElement) && !returnTypeElement.checkTypeCompatibility(((RfListType)contextTypeElement).getAssociatedType())) continue;
                        this.addFunction(original, returnTypeElement, returnTypeElement, contextTypeElement, result, scope);
                        continue;
                    }
                    if (this.isList(firstType) && secondType.checkTypeCompatibility(((RfListType)firstType).getAssociatedType()) || firstType == SDataAbstracts.ANY_AGGREGATE) {
                        if (contextTypeElement == null) {
                            returnType = isFirstAnyCharacter ? new RfAnyListType(String.valueOf(secondType.getName()) + "_vector", secondType, true, null, original.getEnclosingScope()) : firstType;
                            this.addFunction(original, returnType, ((RfListType)returnType).getAssociatedType(), returnType, result, scope);
                            continue;
                        }
                        if (!this.isList(contextTypeElement) || !contextTypeElement.checkTypeCompatibility(firstType) || !secondType.checkTypeCompatibility(((RfListType)contextTypeElement).getAssociatedType())) continue;
                        this.addFunction(original, contextTypeElement, ((RfListType)contextTypeElement).getAssociatedType(), contextTypeElement, result, scope);
                        continue;
                    }
                    if ((!this.isList(secondType) || !firstType.checkTypeCompatibility(((RfListType)secondType).getAssociatedType())) && secondType != SDataAbstracts.ANY_AGGREGATE) continue;
                    IRfNamedElement iRfNamedElement3 = returnType = isSecondAnyCharacter ? new RfAnyListType(String.valueOf(firstType.getName()) + "_vector", firstType, true, null, original.getEnclosingScope()) : secondType;
                    if (contextTypeElement == null) {
                        this.addFunction(original, ((RfListType)returnType).getAssociatedType(), returnType, returnType, result, scope);
                        continue;
                    }
                    if (!(contextTypeElement instanceof RfListType) || !contextTypeElement.checkTypeCompatibility(secondType) || !firstType.checkTypeCompatibility(((RfListType)contextTypeElement).getAssociatedType())) continue;
                    this.addFunction(original, ((RfListType)contextTypeElement).getAssociatedType(), contextTypeElement, contextTypeElement, result, scope);
                }
            }
            return result;
        }

        private void addFunction(RfFunction originalFunction, IRfNamedElement firstType, IRfNamedElement secondType, IRfNamedElement returnType, List<RfFunction> result, RfNamedElement scope) {
            result.add(new RfFunction(originalFunction.getName(), false, 4, Arrays.asList(firstType, secondType), returnType, scope));
        }

        boolean isList(IRfNamedElement element) {
            return element instanceof RfListType && ((RfListType)element).isOneDimensional();
        }
    }

    public static class SEqualityOperation
    extends SComparisonOperation {
        @Override
        protected boolean checkCandidateType(IRfNamedElement type) {
            if (type instanceof RfVariable) {
                if (((RfVariable)type).isFile()) {
                    return false;
                }
                type = ((RfVariable)type).getResolvedType(true);
            }
            if (type instanceof RfType && (((RfType)type).isProtected() || ((RfType)type).isFile())) {
                return false;
            }
            return super.checkCandidateType(type);
        }
    }

    public static class SUniversalFunctionOperation
    extends SUniversalOperation {
        @Override
        public boolean isPotentialUniversalOperation(RfFunction function) {
            return ("to_string".equalsIgnoreCase(function.getName()) || "deallocate".equalsIgnoreCase(function.getName())) && this.hasUniversalArgument(function);
        }

        @Override
        public List<RfFunction> getSpecializedFunctions(RfFunction original, List<ISDataAbstract> operandReturnTypes, SContext context, RfNamedElement scope) {
            RfFunction function;
            RfFunctionsHolder existingHolder;
            String name = original.getName();
            ArrayList<IRfNamedElement> arguments = new ArrayList<IRfNamedElement>();
            RfNamedElement type = null;
            for (ISDataAbstract abs : operandReturnTypes) {
                IRfNamedElement argType = SDataUtils.getDataType((ISDataAbstract)abs).getType();
                if (type == null && argType instanceof RfNamedElement) {
                    type = (RfNamedElement)STransformer.INSTANCE.getBaseType(argType, false);
                }
                arguments.add(type);
            }
            if (type == null) {
                return Collections.emptyList();
            }
            RfNamedElement typeEnclosingScope = type.getEnclosingScope();
            if (typeEnclosingScope != null && (existingHolder = typeEnclosingScope.getLocalMember(RfFunctionsHolder.class, name)) != null && (function = existingHolder.getFunctionByArgumentTypes(arguments, context.getRfElement())) != null) {
                return Collections.singletonList(function);
            }
            RfFunction function2 = new RfFunction(name, original.isTask(), 4, arguments, original.getAssociatedType(), typeEnclosingScope);
            function2.addInEnclosingScopeOf(type, null);
            return Collections.singletonList(function2);
        }
    }
}

