/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;

public class RfEnclosingScopeUtils {
    private static String getText(IRfScope element) {
        RfArchitecture enclosingArch;
        String result;
        if (element == null) {
            return null;
        }
        element = element.getNamedElement();
        boolean isAnonymous = false;
        while (element != null && element instanceof RfActionBlock) {
            element = (IRfScope)element.getEnclosingScope();
        }
        if (element == null) {
            return null;
        }
        String string = result = element instanceof RfType ? element.getName() : element.getQualifiedName();
        if (element instanceof RfNamedElement && ((RfNamedElement)element).isAnonymous()) {
            isAnonymous = true;
            result = "[anonymous]";
        }
        if ((enclosingArch = (RfArchitecture)element.getEnclosingScope(RfArchitecture.class)) != null && element instanceof RfProcess) {
            String arhitectureName = "";
            String entityName = "";
            String processName = "";
            List<RfArchitecture> arhitectures = enclosingArch.getEntity().getArchitectures();
            if (arhitectures != null && arhitectures.size() > 1) {
                arhitectureName = enclosingArch.getName().concat(" of ");
            }
            entityName = enclosingArch.getEntity().getName();
            if (!isAnonymous) {
                processName = element.getName().concat(" ");
            }
            result = processName.concat("in ").concat(arhitectureName).concat(entityName);
        }
        try {
            if (element instanceof RfFunction) {
                String niceSignature = ((RfFunction)element).getNiceSignatureText();
                if (niceSignature != null) {
                    result = niceSignature;
                }
            } else if (element instanceof RfConfigurationRule) {
                result = "[anonymous]";
            } else if (element instanceof RfInstance) {
                DataType dataType = ((RfInstance)element).getDataType();
                result = String.valueOf(result) + " (" + DataType.getFullTypeName(dataType, false) + ")";
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static RfDefElement getScope(IProject project, ParserPath parserPath, int offset) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        return fileDef.getScope(offset);
    }

    public static String getScopeInfo(IProject project, ParserPath parserPath, int offset) {
        String kindName;
        RfDefElement scope = RfEnclosingScopeUtils.getScope(project, parserPath, offset);
        String text = RfEnclosingScopeUtils.getText(scope);
        if (text == null) {
            return null;
        }
        RfNamedElement namedElement = scope.getNamedElement();
        while (namedElement instanceof RfActionBlock) {
            namedElement = namedElement.getEnclosingScope();
        }
        if (namedElement != null && (kindName = namedElement.getKindName()) != null && !kindName.isEmpty()) {
            text = String.valueOf(kindName) + ": " + text;
        }
        return " [" + text + "]";
    }
}

