/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;

public class RfNameTypeScopeHelper
implements DVTRfNameTypeScopeHelper {
    private static final long serialVersionUID = 1L;
    private String fElementName;
    private String fElementArchitectureName;
    private int fElementKind = 0;

    public RfNameTypeScopeHelper(IRfNamedElement element) {
        if (element instanceof RfEntity) {
            this.fElementKind = 2;
            RfArchitecture entityArchitecture = ((RfEntity)element).getArchitecture();
            if (entityArchitecture != null) {
                this.fElementArchitectureName = entityArchitecture.getName();
            }
        } else if (element instanceof RfPackageBody) {
            this.fElementKind = 1024;
        } else if (element instanceof RfPackage) {
            this.fElementKind = 512;
        } else if (element instanceof RfArchitecture) {
            this.fElementKind = 256;
        } else if (element instanceof RfInstance) {
            this.fElementKind = 2048;
        } else if (element instanceof RfLibrary) {
            this.fElementKind = 4096;
        } else if (element instanceof RfTypeBody) {
            this.fElementKind = 262144;
        } else if (element instanceof RfType) {
            this.fElementKind = 131072;
        } else if (element instanceof RfBlock) {
            this.fElementKind = 8192;
        } else if (element instanceof RfFunction) {
            this.fElementKind = 8;
        } else if (element instanceof RfProcess) {
            this.fElementKind = 65536;
        } else if (!(element instanceof RfNamedElement)) {
            this.fElementKind = 32768;
        } else {
            return;
        }
        this.fElementName = element.getName();
    }

    public RfNameTypeScopeHelper(int kind, String name) {
        this.fElementKind = kind;
        this.fElementName = name;
    }

    public String getElementName() {
        return this.fElementName;
    }

    public String getElementArchitectureName() {
        return this.fElementArchitectureName;
    }

    public int getElementKind() {
        return this.fElementKind;
    }

    public boolean equals(Object obj) {
        boolean nameAndTypeCompare;
        if (obj == null || !(obj instanceof RfNameTypeScopeHelper)) {
            return false;
        }
        RfNameTypeScopeHelper elem = (RfNameTypeScopeHelper)obj;
        if (this.fElementName == null && elem.fElementName == null) {
            return this.fElementKind == elem.fElementKind;
        }
        if (this.fElementName == null) {
            return false;
        }
        boolean bl = nameAndTypeCompare = this.fElementName.equals(elem.fElementName) && this.fElementKind == elem.fElementKind;
        return nameAndTypeCompare;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setElementName(String elementName) {
        this.fElementName = elementName;
    }
}

