/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtilsCommon;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.parser.VhdlFileInstance;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class RfUtils
extends RfUtilsCommon {
    public static String getCrossLanguageHyperlinkLabelPart(IRfNamedElement element) {
        if (!(element instanceof IRfDesignElement)) {
            return "";
        }
        IRfDesignElement design = (IRfDesignElement)element;
        switch (design.getKind()) {
            case VLOG_CHECKER: {
                return "Checker";
            }
            case VLOG_INTERFACE: {
                return "Interface";
            }
            case VLOG_PRIMITIVE: {
                return "Primitive";
            }
            case VLOG_PROGRAM: {
                return "Program";
            }
            case VLOG_MODULE: {
                return "Module";
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfNamedElementActionHyperlink getCustomRfNamedElementActionHyperlink(ITextEditor editor, IProject project, IDocument document, int offset) {
        try {
            boolean isComponentInInstance;
            IRegion hyperlinkRegion;
            IRfScope scope;
            RfNamedElementActionHyperlink hyperlinkAction;
            if (!(editor instanceof DVTEditor)) {
                return null;
            }
            RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(editor, document, offset);
            if (elementAndScope == null) return null;
            if (elementAndScope.getIRfNamedElement() == null) return null;
            if (elementAndScope.getIRfNamedElement().isPredefined()) return null;
            IRfNamedElement element = elementAndScope.getIRfNamedElement();
            if (element instanceof RfFunctionsHolder) {
                if (((RfFunctionsHolder)element).hasMultipleFunctions()) {
                    return null;
                }
                element = ((RfFunctionsHolder)element).getLastDefinedFunction().getPrototype();
            }
            if ((hyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, element, scope = elementAndScope.getScope(), hyperlinkRegion = VhdlWordFinder.getDefault().getWordAtOffset(document, offset))) == null) {
                return null;
            }
            IEditorInput editorInput = editor.getEditorInput();
            IFile currentFile = editorInput != null ? (IFile)editorInput.getAdapter(IFile.class) : null;
            IPath currentFilePath = currentFile != null ? currentFile.getLocation() : null;
            boolean showFirstOpenDeclaration = DVTUtilsCommon.INSTANCE.showHyperlinkAction(element.getDeclaration(), element.getName(), offset, currentFilePath);
            boolean bl = isComponentInInstance = element instanceof RfComponent && ((RfComponent)element).getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT && scope != null && scope.getNamedElement() instanceof RfInstance;
            if (showFirstOpenDeclaration && !isComponentInInstance) {
                return hyperlinkAction;
            }
            List<RfNamedElementActionHyperlink> entityAndArchitectureActions = RfUtils.getEntityAndArchitectureHyperlinks(project, elementAndScope, hyperlinkAction.getHyperlinkRegion(), RfUtils.getCurrentBCArchitecture(project, (DVTEditor)editor));
            if (entityAndArchitectureActions.isEmpty()) return hyperlinkAction;
            return entityAndArchitectureActions.get(0);
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static List<RfWNamedElementAndScope> getRfElements(ITextEditor textEditor, IDocument document, int offset) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception x) {
                            DVTLogger.INSTANCE.logError((Throwable)x);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtils.getRfElements(file, document, offset);
    }

    public static IRfScope getRfScope(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        IFile file;
        block12: {
            block11: {
                IEditorInput editorInput;
                block10: {
                    block9: {
                        block8: {
                            if (textEditor != null) break block8;
                            return null;
                        }
                        if (document != null) break block9;
                        return null;
                    }
                    editorInput = textEditor.getEditorInput();
                    if (editorInput != null) break block10;
                    return null;
                }
                file = (IFile)editorInput.getAdapter(IFile.class);
                if (file != null) break block11;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(file.getProject());
            if (rfProject != null) break block12;
            return null;
        }
        try {
            RfFileDef rfFileDef = rfProject.getFile((IResource)file);
            if (rfFileDef != null) {
                return rfFileDef.getScope(offset);
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static boolean isInConfigRuleScope(IRfScope scope) {
        if (scope instanceof RfDefElement) {
            scope = ((RfDefElement)scope).getNamedElement();
        }
        return scope instanceof RfConfigurationRule;
    }

    public static ITypedRegion getTypedRegion(IDocument document, int offset) {
        block3: {
            try {
                if (offset >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        return extension3.getPartition("__vhdl_partitioning", offset, false);
    }

    public static DVTPair<String, String> getSpecadorFormatting(RfNamedElement element, String comment, IProject project, ITextEditor activeEditor) {
        if (element == null || comment == null || project == null || comment.isEmpty()) {
            return new DVTPair((Object)"", (Object)"");
        }
        return CommentFormatter.INSTANCE.format(comment, (IRfNamedElement)element, activeEditor);
    }

    public static IFile getFile(VhdlFileInstance instance, IProject project) {
        if (instance == null || instance.getParserPath() == null || instance.getParserPath().path == null) {
            return null;
        }
        return DVTFileUtils.getInstance().findProjectFile(project, instance.getParserPath().path);
    }

    public static IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    public static String encloseWithBoldTag(String text) {
        return "<b>" + text + "</b>";
    }

    public static String escapeSignature(String signature) {
        return DVTStringUtil.partiallyEscapeHTML((String)signature);
    }

    public static RfArchitecture getCurrentBCArchitecture(IProject project, DVTEditor editor) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        BreadcrumbInput input = RfUtils.getBreadcrumbInput(editor);
        if (input == null) {
            return null;
        }
        IRfBreadcrumbElement leafSegment = input.getLeafSegment();
        if (!(leafSegment instanceof ElementPath)) {
            return null;
        }
        ELInstance elInstance = elManager.getMemory().instanceFor(((ElementPath)leafSegment).toElaborationForm());
        if (elInstance == null) {
            return null;
        }
        IRfNamedElement binding = elInstance.getBinding(false);
        if (!(binding instanceof RfArchitecture)) {
            return null;
        }
        return (RfArchitecture)binding;
    }

    private static BreadcrumbInput getBreadcrumbInput(DVTEditor editor) {
        AbstractBreadcrumbViewer breadcrumbViewer = editor.getBreadcrumbViewer(DHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof DHBreadcrumbViewer)) {
            return null;
        }
        return breadcrumbViewer.getInput();
    }
}

