/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.comment.formatter.CommentFormatter;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfConfigurationRule;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.r2lparser.R2LTooltipManager;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vhdldt.utils.VhdlFileUtils;

public abstract class RfUtilsCommon {
    private static RfElementCache fRfElementCache = new RfElementCache();

    public static void clearCaches() {
        fRfElementCache = new RfElementCache();
    }

    public static RfWNamedElementAndScope getRfElement(IFile file, IDocument document, int offset) {
        List<RfWNamedElementAndScope> elements;
        block5: {
            try {
                elements = RfUtilsCommon.internalComputeElements(file, document, offset);
                if (elements != null && !elements.isEmpty()) break block5;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IRegion region = VhdlWordFinder.getDefault().getWordAtOffset(document, offset);
        if (region == null || region.getLength() == 0) {
            return elements.get(0);
        }
        RfWNamedElementAndScope element = elements.get(0);
        if (elements.size() == 1) {
            fRfElementCache.putCacheElement(region, element);
        }
        return element;
    }

    protected static List<RfWNamedElementAndScope> internalComputeElements(IFile file, IDocument document, int offset) {
        if (file == null || document == null || offset < 0 || offset > document.getLength()) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        if (rfProject == null) {
            return null;
        }
        RfFileDef rfFileDef = rfProject.getFile((IResource)file);
        if (rfFileDef == null) {
            return null;
        }
        RfDefElement rfScope = rfFileDef.getScope(offset);
        IRegion region = VhdlWordFinder.getDefault().getWordAtOffset(document, offset);
        if (region == null || region.getLength() == 0) {
            return Arrays.asList(new RfWNamedElementAndScope(null, rfScope, null));
        }
        fRfElementCache.setDocument(document);
        RfWNamedElementAndScope cachedElement = fRfElementCache.getCacheElement(region);
        if (cachedElement != null) {
            return Arrays.asList(cachedElement);
        }
        R2LTooltipManager manager = new R2LTooltipManager(rfProject, rfScope, (IResource)file, document, offset);
        return manager.getElements();
    }

    public static List<RfWNamedElementAndScope> getRfElements(IFile file, IDocument document, int offset) {
        List<RfWNamedElementAndScope> elements = RfUtilsCommon.internalComputeElements(file, document, offset);
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return elements;
    }

    public static DVTPair<String, String> getSpecadorFormatting(RfNamedElement element, String comment, IProject project, ITextEditor activeEditor) {
        if (element == null || comment == null || project == null || comment.isEmpty()) {
            return new DVTPair((Object)"", (Object)"");
        }
        return CommentFormatter.INSTANCE.format(comment, (IRfNamedElement)element, activeEditor);
    }

    public static RfNamedElementActionHyperlink getRfNamedElementActionHyperlink(IProject project, IRfNamedElement namedElement, IRfScope elementScope, IRegion hyperlinkRegion) {
        RfNamedElementActionHyperlink hyperlink;
        block3: {
            try {
                hyperlink = RfUtilsCommon.createOpenAction(namedElement, project, hyperlinkRegion);
                if (hyperlink != null) break block3;
                return null;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return null;
            }
        }
        hyperlink.setScope(elementScope);
        return hyperlink;
    }

    public static RfNamedElementActionHyperlink createOpenAction(final IRfNamedElement namedElement, final IProject project, IRegion region) {
        if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
            return null;
        }
        if (namedElement == null || namedElement.isPredefined()) {
            return null;
        }
        final IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return null;
        }
        IRfFileDef rfFileDef = declaration.getDefFile();
        if (rfFileDef == null) {
            return null;
        }
        final ParserPath parserPath = rfFileDef.getParserPath();
        final int line = declaration.getStartLine();
        Action action = new Action(){

            public void run() {
                VhdlFileUtils.getInstance().openFile(project, parserPath.path, line, namedElement.getName());
            }

            public String getPath() {
                return parserPath.getCanonicalPath();
            }

            public String getElementName() {
                return declaration.getName();
            }

            public int getLine() {
                return line;
            }
        };
        return new RfNamedElementActionHyperlink(project, namedElement, region, (IAction)action);
    }

    public static boolean isInConfigRuleScope(IRfScope scope) {
        if (scope instanceof RfDefElement) {
            scope = ((RfDefElement)scope).getNamedElement();
        }
        return scope instanceof RfConfigurationRule;
    }

    public static RfNamedElementActionHyperlink getAssociatedTypeHyperlink(IProject project, IRfNamedElement namedElement, IRegion hyperlinkRegion) {
        IRfNamedElement associatedType;
        block4: {
            if (!(namedElement instanceof RfAssociatedType)) {
                return null;
            }
            try {
                associatedType = ((RfAssociatedType)namedElement).getAssociatedType();
                if (associatedType != null && !associatedType.isPredefined()) break block4;
                return null;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return null;
            }
        }
        return RfUtilsCommon.createOpenAction(associatedType, project, hyperlinkRegion);
    }

    public static String getAssociatedTypeHyperlinkLabelPart(IRfNamedElement element) {
        RfKind kind = RfKind.of(element);
        switch (kind) {
            case PORT: 
            case INPUT_PORT: 
            case INOUT_PORT: 
            case OUTPUT_PORT: 
            case BUFFER_PORT: 
            case LINKAGE_PORT: {
                return "Port";
            }
            case FUNCTION: {
                return "Return";
            }
            case TYPE: {
                return "";
            }
        }
        return DVTStringUtil.toTitleCase((String)kind.getName());
    }

    public static boolean isComponent(IRfNamedElement element) {
        return element instanceof RfComponent && ((RfComponent)element).getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT;
    }

    protected static RfArchitecture getCorrespondingArchitecture(RfEntity entity, RfArchitecture bcArchitecture) {
        if (bcArchitecture != null && bcArchitecture.getEntity() == entity) {
            return bcArchitecture;
        }
        return entity.getArchitecture();
    }

    protected static void addOpenActions(List<RfNamedElementActionHyperlink> result, ELInstance instance, IProject project, IRegion hyperlinkRegion, IRfScope scope, boolean hasShowMore) {
        IRfNamedElement designElement;
        boolean unresolvedInstanceType;
        IRfNamedElement entity;
        IRfInstanceElement description = instance.getDescription();
        if (!(description instanceof RfInstance)) {
            return;
        }
        IRfNamedElement architecture = instance.getBinding(false);
        if (architecture == null) {
            return;
        }
        RfNamedElementActionHyperlink archOpenAction = RfUtilsCommon.createOpenAction(architecture, project, hyperlinkRegion);
        if (archOpenAction != null) {
            archOpenAction.setScope(scope);
            archOpenAction.setHasShowMore(hasShowMore);
            archOpenAction.setElementPath(instance.getHierarchyPath());
            result.add(archOpenAction);
        }
        if ((entity = instance.getBinding(true)) == null) {
            return;
        }
        boolean bl = unresolvedInstanceType = entity == ELUtils.UNRESOLVED_INSTANCE_TYPE;
        if (architecture != entity || unresolvedInstanceType) {
            RfNamedElementActionHyperlink entOpenAction;
            RfNamedElementActionHyperlink rfNamedElementActionHyperlink = entOpenAction = unresolvedInstanceType ? RfUtilsCommon.getAssociatedTypeHyperlink(project, (IRfNamedElement)instance.getDescription(), hyperlinkRegion) : RfUtilsCommon.createOpenAction(entity, project, hyperlinkRegion);
            if (entOpenAction != null && DesignUtils.getDesignKind((Object)entOpenAction.getRfNamedElement()) != IRfNamedElement.ElementKind.VHDL_COMPONENT) {
                entOpenAction.setScope(scope);
                entOpenAction.setHasShowMore(hasShowMore);
                entOpenAction.setElementPath(instance.getHierarchyPath());
                result.add(entOpenAction);
            }
        }
        if (DesignUtils.getDesignKind((Object)(designElement = DesignUtils.toGenericDesignElement((IRfNamedElement)((RfInstance)description).getVHDLPreElaborationDesign()))) != IRfNamedElement.ElementKind.VHDL_COMPONENT) {
            return;
        }
        RfNamedElementActionHyperlink componentOpenAction = RfUtilsCommon.createOpenAction(designElement, project, hyperlinkRegion);
        if (componentOpenAction == null) {
            return;
        }
        componentOpenAction.setScope(scope);
        result.add(componentOpenAction);
    }

    public static RfNamedElementActionHyperlink createOpenAction(final RfDefElement defElement, final IProject project, IRegion region, String hyperlinkText) {
        if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
            return null;
        }
        if (defElement == null) {
            return null;
        }
        RfFileDef rfFileDef = defElement.getDefFile();
        if (rfFileDef == null) {
            return null;
        }
        final ParserPath parserPath = rfFileDef.getParserPath();
        final int line = defElement.getStartLine();
        Action action = new Action(){

            public void run() {
                VhdlFileUtils.getInstance().openFile(project, parserPath.path, line, defElement.getName());
            }

            public String getPath() {
                return parserPath.path;
            }

            public String getElementName() {
                return defElement.getName();
            }

            public int getLine() {
                return line;
            }
        };
        return new RfNamedElementActionHyperlink(project, defElement.getNamedElement(), region, (IAction)action, hyperlinkText);
    }

    public static RfNamedElementActionHyperlink createOpenAction(RfDefElement defElement, IProject project, IRegion region) {
        return RfUtilsCommon.createOpenAction(defElement, project, region, null);
    }

    public static ITypedRegion getTypedRegion(IDocument document, int offset) {
        block3: {
            try {
                if (offset >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        return extension3.getPartition("__vhdl_partitioning", offset, false);
    }

    public static List<RfNamedElementActionHyperlink> getEntityAndArchitectureHyperlinks(IProject project, RfWNamedElementAndScope elementAndScope, IRegion hyperlinkRegion, RfArchitecture bcArchitecture) {
        if (elementAndScope == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<RfNamedElementActionHyperlink> result = new ArrayList<RfNamedElementActionHyperlink>();
            IRfNamedElement namedElement = elementAndScope.getIRfNamedElement();
            IRfScope scope = elementAndScope.getScope();
            if (scope == null || RfUtilsCommon.isInConfigRuleScope(scope)) {
                return result;
            }
            if (namedElement instanceof RfConfiguration) {
                RfEntity entity = ((RfConfiguration)namedElement).getEntity();
                if (entity == null) {
                    return result;
                }
                RfNamedElementActionHyperlink openEntityAction = RfUtilsCommon.createOpenAction(entity, project, hyperlinkRegion);
                if (openEntityAction != null) {
                    result.add(openEntityAction);
                }
                if (DesignUtils.isVHDLEntity((IRfNamedElement)entity)) {
                    RfArchitecture architecture = RfUtilsCommon.getCorrespondingArchitecture(entity, bcArchitecture);
                    if (architecture == null) {
                        return result;
                    }
                    RfNamedElementActionHyperlink openArchAction = RfUtilsCommon.createOpenAction(architecture, project, hyperlinkRegion);
                    if (openArchAction == null) {
                        return result;
                    }
                    result.add(openArchAction);
                }
                return result;
            }
            if (namedElement instanceof IRfDesignElement && !(namedElement instanceof RfNamedElement)) {
                RfNamedElementActionHyperlink openAction = RfUtilsCommon.createOpenAction(namedElement, project, hyperlinkRegion);
                if (openAction == null) {
                    return result;
                }
                openAction.setScope(scope);
                result.add(openAction);
            } else if (DesignUtils.isVHDLEntity((IRfNamedElement)namedElement)) {
                RfEntity entity = (RfEntity)namedElement;
                if (!entity.isPredefined() && !entity.isImplicit()) {
                    RfArchitecture architecture = RfUtilsCommon.getCorrespondingArchitecture((RfEntity)namedElement, bcArchitecture);
                    if (architecture == null) {
                        return result;
                    }
                    RfNamedElementActionHyperlink openAction = RfUtilsCommon.createOpenAction(architecture, project, hyperlinkRegion);
                    if (openAction == null) {
                        return result;
                    }
                    openAction.setScope(scope);
                    result.add(openAction);
                }
            } else if (namedElement instanceof RfArchitecture) {
                RfEntity entity = ((RfArchitecture)namedElement).getEntity();
                if (entity != null && !entity.isPredefined() && !entity.isImplicit()) {
                    RfNamedElementActionHyperlink openAction = RfUtilsCommon.createOpenAction(entity, project, hyperlinkRegion);
                    if (openAction == null) {
                        return result;
                    }
                    openAction.setScope(scope);
                    result.add(openAction);
                }
            } else if (namedElement instanceof RfInstance) {
                List allInstances = DVTHyperlinkUtils.getInstance().getInstancesFor((IRfInstanceElement)((RfInstance)namedElement), true, project, 2);
                if (scope != null && scope.getEnclosingScope(RfConfiguration.class) == null && !allInstances.isEmpty()) {
                    RfUtilsCommon.addOpenActions(result, (ELInstance)allInstances.get(0), project, hyperlinkRegion, scope, allInstances.size() > 1);
                }
            }
            return result;
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
            return Collections.emptyList();
        }
    }

    public static RfWNamedElementAndScope getRfElement(ITextEditor textEditor, IDocument document, int offset) {
        IFile file;
        block7: {
            block6: {
                block5: {
                    try {
                        if (textEditor != null) break block5;
                        return null;
                    }
                    catch (Exception x) {
                        DVTLogger.INSTANCE.logError((Throwable)x);
                        return null;
                    }
                }
                if (document != null) break block6;
                return null;
            }
            file = RfUtils.getFile(textEditor);
            if (file != null) break block7;
            return null;
        }
        return RfUtilsCommon.getRfElement(file, document, offset);
    }

    protected static String getTooltipSignature(IRfNamedElementAndScope element, ITextEditor textEditor, DVTTooltipContent tooltipContent, IRfNamedElement candidate) {
        IFile file = ((DVTEditor)textEditor).getCurrentFile();
        int line = tooltipContent.getLine();
        int offset = -1;
        if (line != -1 && file != null) {
            offset = DVTFileUtils.getInstance().getLineOffset(file, line - 1) + tooltipContent.getColumn();
        }
        return candidate.getTooltipSignature(element.getScope(), DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, candidate instanceof RfInstance ? (IRfNamedElement)candidate.getEnclosingScope() : candidate, element.getScope(), false, false), element.getHid(), true);
    }

    protected static String getTooltipComment(IRfNamedElement candidate, ITextEditor textEditor) {
        if (!(candidate instanceof RfNamedElement) || candidate.getRfProject() == null || CommentUtils.getInstance().shouldUseOldTooltip()) {
            return candidate.getComment();
        }
        String tooltipComment = candidate.getRawUntrimmedComment("\n\n");
        if (tooltipComment.isEmpty()) {
            tooltipComment = candidate.getComment();
        }
        return WaveDromManager.getInstance().getCommentWithExtractedWaveformFile(tooltipComment);
    }

    public static void getTooltipFormattedText(IRfNamedElementAndScope elementAndScope, ITextEditor textEditor, DVTTooltipContent tooltipContent) {
        if (elementAndScope == null) {
            return;
        }
        IRfNamedElement candidate = elementAndScope.getIRfNamedElement();
        if (candidate == null) {
            return;
        }
        if (candidate instanceof RfFunctionsHolder) {
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, ((RfFunctionsHolder)candidate).getTooltipFormatedText());
            return;
        }
        String signature = RfUtilsCommon.getTooltipSignature(elementAndScope, textEditor, tooltipContent, candidate);
        if (signature == null) {
            return;
        }
        String waveformTooltipContent = RfUtilsCommon.getWaveformTooltipContent(textEditor, elementAndScope, tooltipContent.getLine(), tooltipContent.getColumn());
        if (waveformTooltipContent != null && !waveformTooltipContent.isEmpty()) {
            tooltipContent.set(DVTTooltipContent.TooltipContent.WAVE_VALUE, waveformTooltipContent);
        }
        String tooltipComment = RfUtilsCommon.getTooltipComment(candidate, textEditor);
        if (!(candidate instanceof RfNamedElement) || candidate.getRfProject() == null || CommentUtils.getInstance().shouldUseOldTooltip()) {
            String commentDelim = tooltipComment.isEmpty() ? "" : "<br>";
            tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, RfUtils.encloseWithBoldTag(RfUtils.escapeSignature(signature)));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, String.valueOf(commentDelim) + RfUtils.escapeSignature(tooltipComment));
            return;
        }
        DVTPair<String, String> tooltipPair = RfUtilsCommon.getSpecadorFormatting((RfNamedElement)candidate, tooltipComment, candidate.getRfProject().getProject(), textEditor);
        tooltipComment = (String)tooltipPair.getKey();
        tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, RfUtils.encloseWithBoldTag(RfUtils.escapeSignature(signature)));
        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipComment);
        tooltipContent.set(DVTTooltipContent.TooltipContent.PREFERENCE, (String)tooltipPair.getValue());
    }

    private static String getWaveformTooltipContent(ITextEditor textEditor, IRfNamedElementAndScope elementAndScope, int line, int column) {
        String waveformToolTipContent;
        if (!(textEditor instanceof IDVTBreadcrumbHost)) {
            return null;
        }
        IRfNamedElement iRfNamedElement = elementAndScope.getIRfNamedElement();
        if (!(iRfNamedElement instanceof RfVariable)) {
            return null;
        }
        int offset = -1;
        IFile file = RfUtils.getFile(textEditor);
        if (line != -1 && file != null) {
            offset = DVTFileUtils.getInstance().getLineOffset(file, line - 1) + column;
        }
        if ((waveformToolTipContent = DVTWaveViewIDEFactory.getInstance().getTooltipForSignalValueInEditor((IDVTBreadcrumbHost)textEditor, elementAndScope, CommentUtils.getInstance().getNewLine(), offset)) == null || waveformToolTipContent.isEmpty()) {
            return null;
        }
        waveformToolTipContent = DVTStringUtil.partiallyEscapeHTML((String)waveformToolTipContent);
        waveformToolTipContent = CommentUtils.getInstance().wrapIntoParagraph(waveformToolTipContent, true);
        return String.valueOf(CommentUtils.getInstance().getNewLine()) + waveformToolTipContent;
    }

    private static class RfElementCache {
        private IDocument fDocument;
        private RfWNamedElementAndScope fCachedElement;
        private IRegion fCachedRegion;
        private long fTimestamp;

        private RfElementCache() {
        }

        public void setDocument(IDocument document) {
            if (document == this.fDocument) {
                return;
            }
            this.fDocument = document;
            this.fCachedRegion = null;
            this.fCachedElement = null;
            this.fTimestamp = 0L;
        }

        public RfWNamedElementAndScope getCacheElement(IRegion region) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    if (region != null && this.fCachedRegion != null) break block7;
                                    return null;
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                            if (this.fCachedElement != null) break block8;
                            return null;
                        }
                        if (region.getLength() != 0) break block9;
                        return null;
                    }
                    if (region.equals(this.fCachedRegion)) break block10;
                    return null;
                }
                long oldTimestamp = this.fTimestamp;
                this.fTimestamp = System.currentTimeMillis();
                if (this.fTimestamp - oldTimestamp <= 200L) break block11;
                return null;
            }
            return new RfWNamedElementAndScope(this.fCachedElement);
        }

        public void putCacheElement(IRegion region, RfWNamedElementAndScope element) {
            this.fCachedElement = new RfWNamedElementAndScope(element);
            this.fCachedRegion = region;
            this.fTimestamp = System.currentTimeMillis();
        }
    }
}

