/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.model.reflection.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vhdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vhdldt.ui.search.SearchQueryProvider;

public class VHDLRfGUIReferencesUtils
extends RfGUIReferencesUtils {
    public static void logComputeReferencesTime(IRfNamedElement namedElement, long startTime) {
        long stopTime = System.currentTimeMillis();
        String logMessagePrefix = "[REFERENCES ENGINE BENCHMARK] VHDLDT - NEW SEARCH ENGINE - time for references of ";
        DVTLogger.INSTANCE.logInfo(String.valueOf(logMessagePrefix) + RfKind.of(namedElement).getName() + " " + namedElement.getName() + " = " + StopWatch.formatTime((long)(stopTime - startTime)));
    }

    public static ISearchQuery showReadersUsages(IRfNamedElement element, IProject project, ITextEditor editor, int offset, IRfScopeElement scopeElement) {
        if (element == null || project == null) {
            return null;
        }
        try {
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(element, true, false, true, searchScope, editor instanceof DVTEditor ? (DVTEditor)editor : null, offset, scopeElement);
            ISearchQuery query = new SearchQueryProvider(1, 8, false, true, RWSearchTypeEnum.READERS).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return query;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static ISearchQuery showWritersUsages(IRfNamedElement element, IProject project, ITextEditor editor, int offset, IRfScopeElement scopeElement) {
        if (element == null || project == null) {
            return null;
        }
        try {
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(element, true, false, true, searchScope, editor instanceof DVTEditor ? (DVTEditor)editor : null, offset, scopeElement);
            ISearchQuery query = new SearchQueryProvider(1, 8, false, true, RWSearchTypeEnum.WRITERS).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return query;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

